/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.MQHeader;
import com.ibm.mq.jmqi.MQRFH;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.msg.client.commonservices.Log.Log;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQPropertyContext;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.DLH;
import com.ibm.msg.client.wmq.v6.jms.internal.IntErrorException;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQXASession;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class MQMessageConsumer
extends WMQPropertyContext
implements ProviderMessageConsumer {
    private static final long serialVersionUID = -7819506386906934953L;
    private static final String CLASSNAME = "MQMessageConsumer";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageConsumer.java, jmscc.wmq.v6, k701, k701-112-140304 1.81.1.15 12/06/21 13:47:50";
    private static int CHUNKTIME;
    static final int DEFAULT_MAX_ASYNC_ATTEMPTS = 5;
    private static final int NO_SYNCPOINT = 3;
    private static final String PROBE_01 = "01";
    private static final String PROBE_02 = "02";
    private static final String PROBE_03 = "03";
    private static final int SPIP = 2;
    private static final int SYNCPOINT = 1;
    public static final String useDefaultBOValues = "com.ibm.mq.jms.useDefaultBOValues";
    private static final long MQHEADER_ASCII = 5571313378871214080L;
    private static final long MQHEADER_EBCDIC = -3109515640373772288L;
    private static final long MQHEADER_MASK = -1099511627776L;
    private static final long MQRFH2_ASCII = 5571313732236222496L;
    private static final long MQRFH2_EBCDIC = -3109514705028104128L;
    private int acknowledgeMode;
    private String backoutRetryQueue;
    private int backoutThreshold;
    private MQJMSMessage baseMessage;
    private String baseQueueName;
    private boolean closed;
    private boolean closing;
    private boolean durable;
    private int getOptions;
    private int browseOptions;
    private int deleteOptions;
    private int acceptOptions;
    private MQGetMessageOptions gmo;
    private ProviderMessageListener listener;
    private int maxAsyncAttempts;
    private MQMessageSelector messageSelector;
    private String mqDLQName;
    private String name;
    private boolean needsRestart;
    private Hashtable nextGenSeenList;
    private boolean noLocal;
    private Object nullValue;
    private Hashtable prevGenSeenList;
    private MQQueue queue;
    private long rescanTimeInterval;
    private long rescanTimeMillis;
    private boolean running;
    private boolean selectorSet;
    private MQSession session;
    private boolean setForPTP;
    private boolean setForPubSub;
    private boolean shared_queue;
    private boolean specialCase;
    private byte[] subscriberId;
    MQSubscription subscription;
    private int syncPoint;
    private boolean transacted;
    private int type;
    private boolean useBrowse;
    private WMQDestination destination;

    protected MQMessageConsumer(WMQDestination queueSpec, String selectorString, MQQueue queue, boolean transacted, int acknowledgeMode, MQSession session) throws JMSException {
        block22: {
            super(null);
            this.backoutRetryQueue = null;
            this.backoutThreshold = 20;
            this.baseQueueName = null;
            this.closed = false;
            this.closing = false;
            this.listener = null;
            this.maxAsyncAttempts = 5;
            this.messageSelector = null;
            this.mqDLQName = null;
            this.name = null;
            this.needsRestart = true;
            this.nextGenSeenList = new Hashtable();
            this.noLocal = false;
            this.nullValue = new Object();
            this.prevGenSeenList = new Hashtable();
            this.queue = null;
            this.rescanTimeMillis = 0L;
            this.running = true;
            this.selectorSet = false;
            this.session = null;
            this.setForPTP = false;
            this.setForPubSub = false;
            this.shared_queue = false;
            this.subscriberId = null;
            this.subscription = null;
            this.syncPoint = 1;
            this.type = 0;
            this.useBrowse = false;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,boolean,int,MQSession)", new Object[]{queueSpec, selectorString, queue, transacted, new Integer(acknowledgeMode), session});
            }
            this.destination = queueSpec;
            this.setForPTP = true;
            acknowledgeMode = session.getAcknowledgeMode();
            this.baseMessage = new MQJMSMessage();
            this.gmo = new MQGetMessageOptions(true);
            this.rescanTimeInterval = session.connection.getRescanInterval();
            if (queueSpec.getIntProperty("failIfQuiesce") == 1) {
                this.gmo.options |= 0x2000;
                this.browseOptions |= 0x2000;
                this.acceptOptions |= 0x2000;
                this.deleteOptions |= 0x2000;
            }
            this.gmo.matchOptions = 0;
            this.specialCase = this.setMessageSelector(selectorString, this.baseMessage, this.gmo);
            if (!this.specialCase) {
                this.gmo.matchOptions = 0;
            }
            if (selectorString == null || selectorString.trim().length() == 0) {
                this.useBrowse = false;
            } else {
                boolean bl = this.useBrowse = !this.specialCase;
            }
            if (queueSpec != null && queueSpec.getIntProperty("deliveryMode") == 3 && queue != null && !queue.isNPMClassHigh()) {
                String key = "MQJMS0003";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidDestinationException je = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,boolean,int,MQSession)", (Throwable)je);
                }
                throw je;
            }
            this.queue = queue;
            this.acknowledgeMode = acknowledgeMode;
            this.session = session;
            this.transacted = transacted;
            this.setSyncpointBehaviour(true);
            this.getOptions = this.gmo.options;
            this.browseOptions |= 0x10;
            this.acceptOptions |= 0x140;
            this.deleteOptions |= 0x144;
            try {
                String borq = "";
                int thresh = 0;
                this.type = Utils.inquireInt(this.queue, 20);
                if (Trace.isOn) {
                    Trace.traceData(this, "queue type: " + this.type, null);
                }
                int[] selectors = new int[]{22, 2019};
                int[] intAttrs = new int[1];
                byte[] charAttrs = new byte[48];
                if (this.type == 3) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "QUEUE is an ALIAS queue, checking TARGQ", null);
                    }
                    PropertyStore.register(useDefaultBOValues, false);
                    if (!PropertyStore.getBooleanPropertyObject(useDefaultBOValues).booleanValue()) {
                        this.baseQueueName = Utils.inquireString(this.queue, 2002);
                        try {
                            int options = 8224;
                            int[] selectors_type = new int[]{20};
                            int[] intAttrs_type = new int[1];
                            MQQueue baseMqQueue = this.session.getQM().accessQueue(this.baseQueueName, options);
                            baseMqQueue.inquire(selectors_type, intAttrs_type, null);
                            if (intAttrs_type[0] == 7) {
                                baseMqQueue.close();
                                int options_forClusterQ = 8232;
                                baseMqQueue = this.session.getQM().accessQueue(this.baseQueueName, options_forClusterQ);
                            }
                            baseMqQueue.inquire(selectors, intAttrs, charAttrs);
                            baseMqQueue.close();
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,boolean,int,MQSession)", mqe, 1);
                            }
                            HashMap<String, Object> inserts = new HashMap<String, Object>();
                            inserts.put("XMSC_INSERT_DESTINATION_NAME", this.baseQueueName);
                            inserts.put("XMSC_INSERT_STRING", this.destination.getName());
                            inserts.put("XMSC_INSERT_VALUE", new Integer(this.backoutThreshold));
                            inserts.put("XMSC_INSERT_EXCEPTION", (Object)mqe);
                            if (mqe instanceof MQException) {
                                inserts.put("XMSC_INSERT_COMP_CODE", new Integer(mqe.getCompCode()));
                                inserts.put("XMSC_INSERT_REASON", new Integer(mqe.getReason()));
                            }
                            Log.log(this, "MQMessageConsumer(WMQDestination,String,MQQueue,boolean,int,MQSession)", "MQJMS1115", inserts);
                        }
                    }
                } else {
                    queue.inquire(selectors, intAttrs, charAttrs);
                }
                borq = new String(charAttrs);
                thresh = intAttrs[0];
                if (Trace.isOn) {
                    Trace.traceData(this, "returned from inquire, threshold = " + thresh + ", borq = '" + borq + "'" + " type: " + this.type, null);
                }
                this.backoutThreshold = thresh;
                if (thresh != 0) {
                    this.maxAsyncAttempts = thresh;
                }
                this.backoutRetryQueue = borq.length() != 0 ? borq : session.getDLQName();
            }
            catch (Exception e) {
                if (!Trace.isOn) break block22;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,boolean,int,MQSession)", e, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,String,com.ibm.msg.client.wmq.v6.base.internal.MQQueue,boolean,int,MQSession)");
        }
    }

    protected MQMessageConsumer(WMQDestination topicSpec, MQSession session, MQSubscription subscription, boolean transacted, int acknowledgeMode) throws JMSException {
        MQQueue subQ;
        block23: {
            super(null);
            this.backoutRetryQueue = null;
            this.backoutThreshold = 20;
            this.baseQueueName = null;
            this.closed = false;
            this.closing = false;
            this.listener = null;
            this.maxAsyncAttempts = 5;
            this.messageSelector = null;
            this.mqDLQName = null;
            this.name = null;
            this.needsRestart = true;
            this.nextGenSeenList = new Hashtable();
            this.noLocal = false;
            this.nullValue = new Object();
            this.prevGenSeenList = new Hashtable();
            this.queue = null;
            this.rescanTimeMillis = 0L;
            this.running = true;
            this.selectorSet = false;
            this.session = null;
            this.setForPTP = false;
            this.setForPubSub = false;
            this.shared_queue = false;
            this.subscriberId = null;
            this.subscription = null;
            this.syncPoint = 1;
            this.type = 0;
            this.useBrowse = false;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,MQSession,MQSubscription,boolean,int)", new Object[]{topicSpec, session, subscription, transacted, new Integer(acknowledgeMode)});
            }
            this.destination = topicSpec;
            this.setForPubSub = true;
            acknowledgeMode = session.getAcknowledgeMode();
            this.queue = subscription.getSubscriberQueue();
            this.session = session;
            this.transacted = transacted;
            if (Trace.isOn && this.queue != null) {
                Trace.traceData(this, this.queue + "(" + this.queue.name + ")", null);
            }
            this.noLocal = subscription.getNoLocal();
            this.name = subscription.getQueueName();
            this.subscriberId = subscription.getCorrelationId();
            this.shared_queue = subscription.isSharedQueue();
            String selectorString = subscription.getSelector();
            this.subscription = subscription;
            this.acknowledgeMode = acknowledgeMode;
            if (Trace.isOn) {
                Trace.traceData(this, "Queue name = " + this.name, null);
            }
            if (this.name.startsWith("SYSTEM.JMS.D.")) {
                if (Trace.isOn) {
                    Trace.traceData(this, "durable set to TRUE", null);
                }
                this.durable = true;
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "durable set to FALSE", null);
                }
                this.durable = false;
            }
            try {
                this.setMessageSelector(selectorString);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,MQSession,MQSubscription,boolean,int)", je, 1);
                }
                this.session = null;
                this.queue = null;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,MQSession,MQSubscription,boolean,int)", je, 1);
                }
                throw je;
            }
            this.selectorSet = selectorString != null && selectorString.length() != 0;
            try {
                int thresh;
                int[] selectors = new int[]{22, 20};
                int[] intAttrs = new int[2];
                this.queue.inquire(selectors, intAttrs, null);
                String borq = this.queue.getAttributeString(2019, 48).trim();
                this.backoutThreshold = thresh = intAttrs[0];
                this.type = intAttrs[1];
                if (Trace.isOn) {
                    Trace.traceData(this, "returned from inquire, threshold = " + thresh + ", borq = '" + borq + "'", null);
                }
                if (thresh != 0) {
                    this.maxAsyncAttempts = thresh;
                }
                this.backoutRetryQueue = borq.length() != 0 ? borq : session.getDLQName();
            }
            catch (Exception e) {
                if (!Trace.isOn) break block23;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,MQSession,MQSubscription,boolean,int)", e, 2);
            }
        }
        this.gmo = new MQGetMessageOptions(true);
        this.gmo.matchOptions = this.shared_queue ? 2 : 0;
        this.getOptions = this.gmo.options;
        this.browseOptions |= 0x10;
        this.acceptOptions |= 0x140;
        this.deleteOptions |= 0x144;
        if (topicSpec.getIntProperty("failIfQuiesce") == 1) {
            this.gmo.options |= 0x2000;
            this.browseOptions |= 0x2000;
            this.acceptOptions |= 0x2000;
            this.deleteOptions |= 0x2000;
        }
        this.setSyncpointBehaviour(false);
        this.baseMessage = new MQJMSMessage();
        if ((this.noLocal || this.selectorSet) && session.getSparseSubscriptions() && this.syncPoint != 3) {
            if (Trace.isOn) {
                Trace.traceData(this, "browse mode", null);
            }
            this.useBrowse = true;
        }
        if (!(topicSpec.getIntProperty("deliveryMode") != 3 || subscription == null || (subQ = subscription.getSubscriberQueue()) != null && subQ.isNPMClassHigh())) {
            this.session = null;
            this.queue = null;
            if (subscription.isDurable()) {
                session.connection.getSubscriptionEngine().closeDurableSubscription(subscription);
            } else {
                session.connection.getSubscriptionEngine().closeSubscription(subscription);
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException je = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,MQSession,MQSubscription,boolean,int)", (Throwable)je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "<init>(WMQDestination,MQSession,MQSubscription,boolean,int)");
        }
    }

    /*
     * Loose catch block
     */
    private void backoutRequeue(MQJMSMessage msg) throws JMSException {
        block41: {
            MQQueue destQ;
            block40: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", new Object[]{msg});
                }
                destQ = null;
                if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                    if (this.type == 0) {
                        this.type = Utils.inquireInt(this.queue, 20);
                    }
                    if (this.type == 3) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Queue " + this.queue.name + "is an ALIAS queue.", null);
                        }
                        if (this.baseQueueName == null || this.baseQueueName.length() == 0) {
                            this.baseQueueName = Utils.inquireString(this.queue, 2002);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Attempting to read Backout Requeue Queue from underlying LOCAL queue " + this.baseQueueName, null);
                        }
                        try {
                            int options = 8232;
                            MQQueue baseMqQueue = this.session.getQM().accessQueue(this.baseQueueName, options);
                            this.backoutRetryQueue = Utils.inquireString(baseMqQueue, 2019);
                            baseMqQueue.close();
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 1);
                            }
                        }
                    } else {
                        this.backoutRetryQueue = Utils.inquireString(this.queue, 2019);
                    }
                }
                if (this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0) {
                    JMSException jmse = ConfigEnvironment.newException("MQJMS1080");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", jmse, 1);
                    }
                    throw jmse;
                }
                this.backoutRetryQueue = this.backoutRetryQueue.trim();
                if (Trace.isOn) {
                    Trace.traceData(this, "BORQ = <" + this.backoutRetryQueue + ">", null);
                }
                try {
                    int openOptions = 8720;
                    destQ = this.session.getQM().accessQueue(this.backoutRetryQueue, openOptions, "", null, null);
                    MQPutMessageOptions pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    destQ.putMsg2(msg, pmo);
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to commit requeued message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "commiting requeued message", null);
                        }
                        this.session.getQM().commit();
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 2);
                    }
                    if (mqe.reasonCode == 2033) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderMessage to requeue has disappeared! Continue as normal", null);
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "Unable to requeue message", null);
                    }
                    JMSException jmse = ConfigEnvironment.newException("MQJMS1081");
                    jmse.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", jmse, 2);
                    }
                    throw jmse;
                }
                Object var6_9 = null;
                if (!Trace.isOn) break block40;
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)");
            }
            try {
                if (destQ != null) {
                    destQ.close();
                }
                break block41;
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 4);
                }
                break block41;
            }
            {
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", je, 3);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", je, 3);
                    }
                    throw je;
                }
            }
            catch (Throwable throwable) {
                block42: {
                    Object var6_10 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)");
                    }
                    try {
                        if (destQ != null) {
                            destQ.close();
                        }
                    }
                    catch (MQException mqe) {
                        if (!Trace.isOn) break block42;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)", mqe, 4);
                    }
                }
                throw throwable;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutRequeue(MQJMSMessage)");
        }
    }

    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "close(boolean)", new Object[]{closingFromSession});
        }
        if (this.setForPTP) {
            this.closeQ();
        } else if (this.setForPubSub) {
            this.closeT();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "close(boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeQ() throws JMSException {
        block23: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()");
            }
            try {
                try {
                    this.closing = true;
                    MQMessageConsumer mQMessageConsumer = this;
                    synchronized (mQMessageConsumer) {
                        if (this.session != null) {
                            this.session.setPlayNice(true);
                            this.session.removeConsumer(this);
                        }
                        if (this.listener != null) {
                            if (this.session != null) {
                                this.session.removeAsync(this);
                            }
                            this.listener = null;
                        }
                        this.closed = true;
                        if (this.queue != null) {
                            try {
                                this.queue.close();
                                this.queue = null;
                            }
                            catch (MQException e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()", e, 1);
                                }
                                JMSException je = ConfigEnvironment.newException("MQJMS2000");
                                je.setLinkedException((Exception)((Object)e));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()", je, 1);
                                }
                                throw je;
                            }
                        }
                        if (this.session != null) {
                            this.session.setPlayNice(false);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Leaving the session object in the Consumer", null);
                        }
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()", je, 2);
                    }
                    throw je;
                }
                Object var6_5 = null;
                if (!Trace.isOn) break block23;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()");
                }
                if (this.session != null) {
                    this.session.setPlayNice(false);
                }
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()");
        }
        if (this.session != null) {
            this.session.setPlayNice(false);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeQ()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeT() throws JMSException {
        block37: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()");
            }
            boolean removeSubscriber = true;
            try {
                try {
                    if (this.session != null) {
                        this.session.setPlayNice(true);
                    }
                    this.closing = true;
                    MQMessageConsumer mQMessageConsumer = this;
                    synchronized (mQMessageConsumer) {
                        block36: {
                            block35: {
                                if (this.listener != null) {
                                    if (this.session != null) {
                                        this.session.removeAsync(this);
                                    }
                                    this.listener = null;
                                }
                                this.closed = true;
                                try {
                                    if (null != this.session && null != this.session.getQM() && this.session.getQM() instanceof MQQueueManager && this.session.getQM().spiSupportsInherited() && (this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3)) {
                                        this.session._acknowledgeInternal();
                                    }
                                }
                                catch (MQException mqe) {
                                    if (!Trace.isOn) break block35;
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()", mqe, 1);
                                }
                            }
                            if (!this.durable) {
                                try {
                                    this.subscription.close();
                                    this.queue = null;
                                }
                                catch (JMSException je) {
                                    Exception e;
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()", je, 2);
                                    }
                                    if ((e = je.getLinkedException()) instanceof MQException && ((MQException)((Object)e)).reasonCode == 2055) {
                                        removeSubscriber = false;
                                        if (Trace.isOn) {
                                            Trace.traceData(this, "close ignoring MQException 2055", null);
                                        }
                                        break block36;
                                    }
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "close() ignoring exception", null);
                                    }
                                    this.queue = null;
                                }
                            } else if (this.queue != null) {
                                try {
                                    this.subscription.close();
                                    this.queue.close();
                                    this.queue = null;
                                }
                                catch (MQException e) {
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()", e, 3);
                                    }
                                    JMSException je = ConfigEnvironment.newException("MQJMS3017", this.subscription.getQueueName());
                                    je.setLinkedException((Exception)((Object)e));
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()", je, 1);
                                    }
                                    throw je;
                                }
                            }
                        }
                        if (this.session != null && removeSubscriber) {
                            this.session.removeConsumer(this);
                        }
                        if (this.session != null) {
                            this.session.setPlayNice(false);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Leaving the session object in the Consumer", null);
                        }
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()", je, 4);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()", je, 2);
                    }
                    throw je;
                }
                Object var7_9 = null;
                if (!Trace.isOn) break block37;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()");
                }
                if (this.session != null) {
                    this.session.setPlayNice(false);
                }
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()");
        }
        if (this.session != null) {
            this.session.setPlayNice(false);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "closeT()");
        }
    }

    private void commitIfRequired(boolean messageWanted, boolean calledFromgetMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", new Object[]{messageWanted, calledFromgetMessage});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Message is" + (messageWanted ? " " : " not ") + "wanted", null);
            Trace.traceData(this, "commitIfRequired is called from" + (calledFromgetMessage ? " getMessage " : " receiveAsync ") + "method", null);
            String tmp = "Not Applicable";
            String tmp1 = "false";
            switch (this.acknowledgeMode) {
                case 1: {
                    tmp = "Session.AUTO_ACKNOWLEDGE";
                    break;
                }
                case 3: {
                    tmp = "Session.DUPS_OK_ACKNOWLEDGE";
                    break;
                }
                case 2: {
                    tmp = "Session.CLIENT_ACKNOWLEDGE";
                    break;
                }
                case 0: {
                    tmp1 = "true";
                    break;
                }
                default: {
                    tmp = "Invalid";
                    tmp1 = "false";
                }
            }
            Trace.traceData(this, "Session.acknowledgeMode = " + tmp + " Transacted = " + tmp1, null);
        }
        if ((this.session.usingAsyncMode() || this.session.hasMessageListener()) && calledFromgetMessage) {
            if (this.setForPubSub) {
                if (Trace.isOn) {
                    Trace.traceData(this, "We are in PubSub async delivery mode", null);
                }
                this.session.setCommitRequired(true);
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "We are in PTP async delivery mode", null);
                }
                if (messageWanted) {
                    this.session.setCommitRequired(true);
                } else if (!(this.session instanceof MQXASession)) {
                    if (!this.session.getCommitRequired() && this.session.transacted) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Message unwanted and commit not required, committing.", null);
                        }
                        this.session.commit();
                    }
                    this.session.setCommitRequired(false);
                } else if (Trace.isOn) {
                    Trace.traceData(this, "Not committing XA session (" + this.session.getClass() + ")", null);
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", 1);
            }
            return;
        }
        try {
            JMSException je;
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession.acknowledgeMode = " + this.acknowledgeMode, null);
            }
            if (this.session.supportsInherited() && this.setForPubSub) {
                if (Trace.isOn) {
                    Trace.traceData(this, "QueueManager supports ITX calls", null);
                }
                switch (this.acknowledgeMode) {
                    case 1: 
                    case 3: {
                        if (messageWanted && !this.session.usingAsyncMode() && !this.session.hasMessageListener() && this.session.getProcessDuration() == 0) {
                            if (this.syncPoint == 2) {
                                if (this.baseMessage.getPersistence() == 1) {
                                    this.session._acknowledgeInternal();
                                }
                            } else if (this.syncPoint == 1) {
                                this.session._acknowledgeInternal();
                            }
                            this.session.setCommitRequired(false);
                            break;
                        }
                        this.session.setCommitRequired(true);
                        break;
                    }
                    case 0: 
                    case 2: {
                        break;
                    }
                    default: {
                        je = ConfigEnvironment.newException("MQJMS1001", new Integer(this.acknowledgeMode));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", je, 1);
                        }
                        throw je;
                    }
                }
            } else if (this.session.getDistTransactionMode() == 0 || !this.session.getTransacted()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "QueueManager doesn't support ITX calls or we're in PTP mode", null);
                }
                switch (this.acknowledgeMode) {
                    case 1: 
                    case 3: {
                        if (this.syncPoint == 2) {
                            if (this.baseMessage.getPersistence() == 1) {
                                this.session._acknowledgeInternal();
                            }
                        } else if (this.syncPoint == 1) {
                            this.session._acknowledgeInternal();
                        }
                        this.session.setCommitRequired(false);
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (!messageWanted && !this.session.getCommitRequired()) {
                            if (this.acknowledgeMode == 0) {
                                this.session.commit();
                            } else {
                                this.session._acknowledgeInternal();
                            }
                            this.session.setCommitRequired(false);
                            break;
                        }
                        this.session.setCommitRequired(true);
                        break;
                    }
                    default: {
                        je = ConfigEnvironment.newException("MQJMS1001", new Integer(this.acknowledgeMode));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", je, 2);
                        }
                        throw je;
                    }
                }
            } else if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession.getDistTransactionMode = " + this.session.getDistTransactionMode(), null);
                Trace.traceData(this, "In a possible global transactional mode. Skipping any commit or acknowledge attempts.", null);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "commitIfRequired(boolean,boolean)", 2);
        }
    }

    private void deadLetter(MQJMSMessage msg, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", new Object[]{msg, new Integer(reason)});
        }
        MQMessage reportMessage = null;
        String replyQ = null;
        String replyQMgr = null;
        MQQueue DLQ = null;
        MQQueue RQ = null;
        try {
            if (this.mqDLQName == null) {
                this.mqDLQName = Utils.inquireString(this.session.getQM(), 2006);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "DLQ = <" + this.mqDLQName + ">", null);
            }
            if (this.mqDLQName == null || this.mqDLQName.length() == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to find DLQ name - is one defined?", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1079");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", je, 1);
                }
                throw je;
            }
            if ((msg.getReport() & 0x7000000) != 0) {
                reportMessage = this.generateReport(msg, reason);
                replyQ = msg.getReplyToQueueName().trim();
                replyQMgr = msg.getReplyToQueueManagerName().trim();
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Constructing DLH", null);
            }
            DLH dlh = new DLH();
            dlh.reason = reason;
            dlh.destQName = this.backoutRetryQueue == null || this.backoutRetryQueue.length() == 0 ? this.queue.name : this.backoutRetryQueue;
            dlh.destQMgrName = this.session.getQMName();
            dlh.putApplType = 28;
            dlh.putApplName = "MQ JMS ConnectionConsumer";
            GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            dlh.putDate = Utils.getDate(gc);
            dlh.putTime = Utils.getTime(gc);
            MQMessage deadMsg = new MQMessage();
            dlh.write(deadMsg, msg);
            int openOptions = 8720;
            DLQ = this.session.getQM().accessQueue(this.mqDLQName, openOptions, this.session.getQMName(), null, null);
            MQPutMessageOptions pmo = new MQPutMessageOptions();
            pmo.options = 514;
            pmo.contextReference = this.queue;
            DLQ.put(deadMsg, pmo);
            if (reportMessage != null) {
                try {
                    openOptions = 8720;
                    RQ = this.session.getQM().accessQueue(replyQ, openOptions, replyQMgr, null, null);
                    pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    RQ.put(reportMessage, pmo);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", mqe, 1);
                    }
                    dlh.destQName = replyQ;
                    dlh.destQMgrName = replyQMgr;
                    dlh.reason = mqe.reasonCode;
                    dlh.write(reportMessage);
                    DLQ.put(reportMessage, pmo);
                }
            }
        }
        catch (MQException mqe) {
            block50: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", mqe, 2);
                }
                if (mqe.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage to dead-letter has disappeared! Continue as normal", null);
                    }
                }
                if (msg != null && msg.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send report message, but message isnon-persistent - so subsume the error", null);
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "backing out attempt to send Report message", null);
                    }
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout Report message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out Report message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe2) {
                    if (!Trace.isOn) break block50;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", mqe2, 3);
                }
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1079");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            block51: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", je, 4);
                }
                if (msg != null && msg.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is non-persistent so ignoring error", null);
                    }
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "backing out attempt to DLQ message", null);
                    }
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout DLQ'd message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out DLQ'd message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block51;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", mqe, 5);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", je, 3);
            }
            throw je;
        }
        try {
            if (DLQ != null) {
                DLQ.close();
            }
            if (RQ != null) {
                RQ.close();
            }
            if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to commit requeued message as session is transacted or Client Ack", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "commiting requeued message", null);
                }
                this.session.getQM().commit();
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", mqe, 6);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1079");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "deadLetter(MQJMSMessage,int)");
        }
    }

    private void discard(MQJMSMessage msgRef, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", new Object[]{msgRef, new Integer(reason)});
        }
        MQJMSMessage discardMessage = msgRef;
        MQMessage reportMessage = null;
        try {
            if ((discardMessage.getReport() & 0x7000000) != 0) {
                reportMessage = this.generateReport(discardMessage, reason);
                String replyQ = discardMessage.getReplyToQueueName().trim();
                String replyQMgr = discardMessage.getReplyToQueueManagerName().trim();
                try {
                    int openOptions = 8720;
                    MQQueue RQ = this.session.getQM().accessQueue(replyQ, openOptions, replyQMgr, null, null);
                    MQPutMessageOptions pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    RQ.put(reportMessage, pmo);
                    RQ.close();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 1);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not put report message to replyToQ", null);
                        Trace.traceData(this, "Attempting to put to DLQ instead", null);
                    }
                    if (this.mqDLQName == null) {
                        this.mqDLQName = Utils.inquireString(this.session.getQM(), 2006);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "DLQ = <" + this.mqDLQName + ">", null);
                    }
                    if (this.mqDLQName == null || this.mqDLQName.length() == 0) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to find DLQ name - is one defined?", null);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1079");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 1);
                        }
                        throw je;
                    }
                    DLH dlh = new DLH();
                    dlh.reason = mqe.reasonCode;
                    dlh.destQName = replyQ;
                    dlh.destQMgrName = replyQMgr;
                    dlh.putApplType = 28;
                    dlh.putApplName = "MQ JMS ConnectionConsumer";
                    GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    dlh.putDate = Utils.getDate(gc);
                    dlh.putTime = Utils.getTime(gc);
                    dlh.write(reportMessage);
                    int openOptions = 8720;
                    MQQueue DLQ = this.session.getQM().accessQueue(this.mqDLQName, openOptions, this.session.getQMName(), null, null);
                    MQPutMessageOptions pmo = new MQPutMessageOptions();
                    pmo.options = 514;
                    pmo.contextReference = this.queue;
                    DLQ.put(reportMessage, pmo);
                    DLQ.close();
                }
            }
        }
        catch (MQException mqe) {
            block45: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 2);
                }
                if (mqe.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage to discard has disappeared! Continue as normal", null);
                    }
                }
                if (discardMessage != null && discardMessage.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send report message, but message isnon-persistent - so subsume the error", null);
                    }
                }
                try {
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout the message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out the message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe2) {
                    if (!Trace.isOn) break block45;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe2, 3);
                }
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1082");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 2);
            }
            throw je;
        }
        catch (JMSException je) {
            block46: {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 4);
                }
                if (discardMessage != null && discardMessage.getPersistence() == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is non-persistent so ignoring error", null);
                    }
                }
                try {
                    if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unable to backout the message as session is transacted or Client Ack", null);
                        }
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backing out the message", null);
                        }
                        this.session.getQM().backout();
                    }
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block46;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 5);
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 3);
            }
            throw je;
        }
        try {
            if (this.session.getTransacted() || this.session.getAcknowledgeMode() == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Unable to commit the report message as session is transacted or Client Ack", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "commiting the report message", null);
                }
                this.session.getQM().commit();
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", mqe, 6);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1082");
            je.setLinkedException((Exception)((Object)mqe));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "discard(MQJMSMessage,int)");
        }
    }

    private MQMessage generateReport(MQJMSMessage msg, int reason) throws JMSException {
        MQMessage out;
        block15: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", new Object[]{msg, new Integer(reason)});
            }
            out = new MQMessage();
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            DataOutputStream dataBuffer = new DataOutputStream(byteBuffer);
            try {
                out.report = 0;
                out.messageType = 4;
                out.expiry = -1;
                out.feedback = reason;
                out.encoding = msg.getEncoding();
                out.characterSet = msg.getCharacterSet();
                out.format = msg.getFormat();
                out.priority = msg.getPriority();
                out.persistence = msg.getPersistence();
                if ((msg.getReport() & 0x80) == 128) {
                    out.messageId = msg.getMessageId();
                }
                out.correlationId = (msg.getReport() & 0x40) == 64 ? msg.getCorrelationId() : msg.getMessageId();
                out.backoutCount = 0;
                out.replyToQueueName = "";
                out.replyToQueueManagerName = this.session.getQMName();
                out.putApplicationType = 28;
                out.putApplicationName = "MQ JMS Message Consumer";
                if ((msg.getReport() & 0x7000000) == 0x7000000) {
                    byte[] buffer = new byte[msg.getMessageDataLength()];
                    buffer = msg.getMessageData();
                    out.write(buffer);
                    break block15;
                }
                if ((msg.getReport() & 0x3000000) != 0x3000000) break block15;
                String format = msg.getFormat();
                int origCharacterSet = msg.getCharacterSet();
                try {
                    if (format.startsWith("MQH")) {
                        msg.writeTo(dataBuffer, origCharacterSet, true);
                    }
                }
                catch (IOException ioe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", ioe, 1);
                    }
                }
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", ioe, 2);
                }
                JMSException jmse = ConfigEnvironment.newException("MQJMS1016");
                jmse.setLinkedException((Exception)ioe);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", jmse, 1);
                }
                throw jmse;
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", mqe, 3);
                }
                JMSException jmse = ConfigEnvironment.newException("MQJMS1016");
                jmse.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", jmse, 2);
                }
                throw jmse;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "generateReport(MQJMSMessage,int)", (Object)out);
        }
        return out;
    }

    private String getIDFromMessage(MQMsg2 message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{message});
        }
        if (message == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", null, 1);
            }
            return null;
        }
        byte[] mid = message.getMessageId();
        switch (mid[0]) {
            case 65: {
                if (mid[1] == 77 && mid[2] == 81 && mid[3] == 32) break;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", null, 2);
                }
                return null;
            }
            case 67: {
                if (mid[1] == 83 && mid[2] == 81 && mid[3] == 32) break;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", null, 3);
                }
                return null;
            }
            case -63: {
                if (mid[1] == -44 && mid[2] == -40 && mid[3] == 64) break;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", null, 4);
                }
                return null;
            }
            case -61: {
                if (mid[1] == -30 && mid[2] == -40 && mid[3] == 64) break;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", null, 5);
                }
                return null;
            }
            default: {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", null, 6);
                }
                return null;
            }
        }
        StringBuffer result = new StringBuffer();
        for (int i = 4; i < mid.length; ++i) {
            int byteValue = mid[i] & 0xFF;
            if (byteValue < 16) {
                result.append("0");
            }
            result.append(Integer.toHexString(byteValue));
        }
        String traceRet1 = result.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getIDFromMessage(com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", traceRet1, 7);
        }
        return traceRet1;
    }

    private JMSMessage getMessage(long timeOut) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", new Object[]{new Long(timeOut)});
        }
        JMSMessage result = null;
        Object uniqueID = null;
        int thisWaitTime = 0;
        long totalTimeWaited = 0L;
        boolean browseFirst = false;
        boolean beyondRescanTime = false;
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "useBrowse = " + this.useBrowse, null);
                if (this.setForPTP) {
                    Trace.traceData(this, "Set for PTP", null);
                } else if (this.setForPubSub) {
                    Trace.traceData(this, "Set for PubSub", null);
                } else {
                    Trace.traceData(this, "Not set for either domain", null);
                }
            }
            if (!this.setForPTP && !this.setForPubSub) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 1);
                }
                return null;
            }
            if (this.setForPubSub && this.session.supportsInherited() && (timeOut > 0L || timeOut == -1L) && this.session.getCommitRequired() && (this.session.getAcknowledgeMode() == 2 || this.session.getAcknowledgeMode() == 0) && this.session.getReceiveIsolation() == 1 && this.session.getProcessDuration() == 1) {
                this.session.inhibitITX();
            }
            int retryCount = 0;
            long endTime = System.currentTimeMillis() + timeOut;
            boolean firstScanDone = false;
            do {
                if (this.closing) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "ABORTING scan because consumer closing", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 2);
                    }
                    return null;
                }
                if (timeOut == -1L) {
                    this.gmo.waitInterval = CHUNKTIME;
                    endTime = -1L;
                } else {
                    this.gmo.waitInterval = (int)Math.min(endTime - System.currentTimeMillis(), (long)CHUNKTIME);
                    if (this.gmo.waitInterval < 0 && !firstScanDone) {
                        this.gmo.waitInterval = 0;
                    }
                    if (this.gmo.waitInterval <= 0 && firstScanDone) {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 3);
                        }
                        return null;
                    }
                }
                thisWaitTime = this.gmo.waitInterval;
                if (Trace.isOn) {
                    Trace.traceData(this, "Current gmo.waitInterval = ", (Object)new Integer(this.gmo.waitInterval));
                }
                if (this.useBrowse) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting up for browse", null);
                    }
                    this.gmo.options = this.browseOptions;
                    if (this.setForPTP) {
                        long now;
                        if (this.needsRestart) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "getMessage using browse first", null);
                            }
                            this.gmo.options &= 0xFFFFFFDF;
                            this.gmo.options |= 0x10;
                            browseFirst = true;
                            this.needsRestart = false;
                            this.rescanTimeMillis = System.currentTimeMillis();
                            this.rescanTimeMillis += this.rescanTimeInterval;
                            if (this.rescanTimeMillis != 0L && this.rescanTimeMillis < endTime) {
                                this.gmo.waitInterval = (int)Math.max(this.rescanTimeMillis - System.currentTimeMillis(), 0L);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "rescanTimeMillis = " + this.rescanTimeMillis + ", rescanTimeInterval =" + this.rescanTimeInterval, null);
                            }
                        } else {
                            if (Trace.isOn) {
                                Trace.traceData(this, "getMessage using browse next", null);
                            }
                            this.gmo.options &= 0xFFFFFFEF;
                            this.gmo.options |= 0x20;
                            browseFirst = false;
                        }
                        if ((now = System.currentTimeMillis()) >= this.rescanTimeMillis) {
                            beyondRescanTime = true;
                            thisWaitTime = 0;
                        } else if (this.rescanTimeMillis - now < (long)thisWaitTime) {
                            thisWaitTime = (int)(this.rescanTimeMillis - now);
                        }
                    }
                    this.gmo.options &= 0xFFFFFFFD;
                    this.gmo.options &= 0xFFFFEFFF;
                    this.gmo.options |= 4;
                } else {
                    this.gmo.options = this.getOptions;
                    this.gmo.options &= 0xFFFFFFDF;
                    this.gmo.options |= this.getSyncPointOptions();
                }
                if (Trace.isOn) {
                    Trace.data(this, "setting waitInterval for this get = ", (Object)Integer.toString(thisWaitTime));
                }
                this.gmo.waitInterval = thisWaitTime;
                if (this.gmo.waitInterval == 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setting get with no wait option", null);
                    }
                    this.gmo.options &= 0xFFFFFFFE;
                    this.gmo.options |= 0;
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setting get with wait option", null);
                    }
                    this.gmo.options &= 0xFFFFFFFF;
                    this.gmo.options |= 1;
                }
                int spiOptions = 0;
                if (this.setForPubSub) {
                    if (this.shared_queue) {
                        this.baseMessage.setCorrelationId(this.subscriberId);
                    }
                    spiOptions = this.getSPIOptions(retryCount);
                } else if (!this.specialCase) {
                    this.gmo.matchOptions = 0;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "getMessage about to MQGet. retry #" + retryCount++, null);
                }
                try {
                    if (this.setForPubSub && this.syncPoint == 3 && !this.durable) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "PubSub outside syncpoint. Using batched get", null);
                        }
                        this.queue.getMsg2(this.baseMessage, this.gmo);
                    } else if (spiOptions != 0) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Attempting to optimise, using spiOptions = " + spiOptions, null);
                        }
                        this.queue.spiGet(this.baseMessage, this.gmo, spiOptions);
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "No spi optimisation. Using getMsg2", null);
                        }
                        this.queue.getMsg2(this.baseMessage, this.gmo);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "get call completed", null);
                    }
                    if (this.syncPoint == 2 && this.baseMessage.getPersistence() == 1) {
                        this.session.setCommitRequired(true);
                    }
                    boolean messageSuitable = true;
                    if (this.setForPubSub) {
                        if (this.noLocal) {
                            messageSuitable = !this.isLocalMessage();
                        }
                        result = null;
                    } else if (this.useBrowse) {
                        messageSuitable = this.isNewPTPMessage();
                    }
                    if (messageSuitable && (result = this.isMessageSelected()) == null) {
                        messageSuitable = false;
                    }
                    if (this.useBrowse) {
                        if (messageSuitable || this.setForPubSub) {
                            boolean removed = this.removeBrowsedMessage(messageSuitable);
                            if (!removed) {
                                result = null;
                                if (Trace.isOn) {
                                    Trace.data(this, "getMessage", (Object)"Browsed message not removed");
                                }
                            }
                            if (browseFirst) {
                                this.needsRestart = true;
                            }
                        } else {
                            if (uniqueID != null) {
                                this.nextGenSeenList.put(uniqueID, this.nullValue);
                            }
                            if (this.backoutThreshold != 0 && this.baseMessage.getBackoutCount() >= this.backoutThreshold && Trace.isOn) {
                                Trace.traceData(this, "unwanted PTP message get with SAVE_ALL_CONTEXT for backout", null);
                            }
                            result = null;
                        }
                    }
                    if (result != null && this.backoutThreshold != 0 && this.baseMessage.getBackoutCount() >= this.backoutThreshold) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "backoutThreshold reached", null);
                        }
                        try {
                            this.backoutRequeue(this.baseMessage);
                            messageSuitable = false;
                        }
                        catch (JMSException je) {
                            Exception e;
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", je, 1);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "ProviderMessage requeue failed. Treating it as a bad message", null);
                            }
                            int reason = (e = je.getLinkedException()) != null && e instanceof MQException ? ((MQException)((Object)e)).reasonCode : 2362;
                            try {
                                this.removeBadMessage(this.baseMessage, reason);
                                messageSuitable = false;
                            }
                            catch (JMSException je2) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", je2, 2);
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "removeBadMessage failed", null);
                                }
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", je2, 1);
                                }
                                throw je2;
                            }
                        }
                    }
                    if (result != null) {
                        this.commitIfRequired(messageSuitable, true);
                    }
                    if (!messageSuitable) {
                        result = null;
                    }
                    switch (this.session.getAcknowledgeMode()) {
                        case 0: 
                        case 2: {
                            if (!messageSuitable || result == null) break;
                            result._setSession(this.session);
                            this.session.setCommitRequired(true);
                            break;
                        }
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", mqe, 3);
                    }
                    if (mqe.reasonCode == 2033) {
                        firstScanDone = true;
                        if (System.currentTimeMillis() >= this.rescanTimeMillis) {
                            beyondRescanTime = true;
                        }
                        if (browseFirst || beyondRescanTime) {
                            this.needsRestart = true;
                        }
                        if ((this.gmo.options & 1) == 1) {
                            totalTimeWaited += (long)thisWaitTime;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "used " + totalTimeWaited + " of " + timeOut + " ms", null);
                        }
                        if (timeOut != -1L && totalTimeWaited >= timeOut) {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 4);
                            }
                            return null;
                        }
                        if (!this.useBrowse) continue;
                        if (Trace.isOn) {
                            Trace.traceData(this, "requesting restart", null);
                        }
                        this.needsRestart = true;
                        this.prevGenSeenList = this.nextGenSeenList;
                        int newSize = this.prevGenSeenList.size();
                        if (newSize < 10) {
                            newSize = 10;
                        }
                        this.nextGenSeenList = new Hashtable(newSize);
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "MQException thrown while getting message", null);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS2002");
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", je, 2);
                    }
                    throw je;
                }
            } while (result == null && this.running);
            if (!this.running && result == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 5);
                }
                return null;
            }
            if (result != null) {
                result.setGotByConsume(false);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", result, 6);
            }
            return result;
        }
        catch (SessionClosedException sce) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", (Throwable)((Object)sce), 4);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "SessionClosedException thrown. Returning null rather than throwing the Exception on.", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 7);
            }
            return null;
        }
        catch (IllegalStateException ise) {
            String message;
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", ise, 5);
            }
            if ((message = ise.getMessage()).equals("MQJMS1024")) {
                if (Trace.isOn) {
                    Trace.traceData(this, "IllegalStateException thrown. The ProviderSession has been closed so we cannot continue. Returning null rather than throwing the Exception on.", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", null, 8);
                }
                return null;
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", ise, 3);
            }
            throw ise;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", e, 6);
            }
            JMSException je = null;
            if (e instanceof JMSException) {
                je = (JMSException)((Object)e);
            } else {
                je = ConfigEnvironment.newException("MQJMS2002");
                je.setLinkedException(e);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getMessage(long)", je, 4);
            }
            throw je;
        }
    }

    private int getSPIOptions(int retryCount) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSPIOptions(int)", new Object[]{new Integer(retryCount)});
        }
        int options = 0;
        try {
            if (!this.setForPubSub || !this.session.supportsInherited()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Not enabling SPI options.", null);
                }
                options = 0;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSPIOptions(int)", new Integer(options), 1);
                }
                return options;
            }
            if (this.syncPoint != 3) {
                if (Trace.isOn) {
                    String tmp = "";
                    switch (this.syncPoint) {
                        case 1: {
                            tmp = "SYNCPOINT";
                            break;
                        }
                        case 2: {
                            tmp = "SPIP";
                            break;
                        }
                        case 3: {
                            tmp = "NO_SYNCPOINT";
                            break;
                        }
                        default: {
                            tmp = "Invalid";
                        }
                    }
                    Trace.traceData(this, "syncpoint = " + tmp + ", durable = " + this.durable, null);
                }
                int ackMode = this.session.getAcknowledgeMode();
                switch (ackMode) {
                    case 1: 
                    case 3: {
                        if (!this.session.getCommitRequired()) break;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Commit required, using spiGETOPT_COMMIT", null);
                        }
                        if (ackMode == 3 && !this.session.getOutcomeNotification() || retryCount > 0) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "DUPS_OK and outcomeNotification(false). Using spiGETOPT_COMMIT_ASYNC", null);
                            }
                            options += 8;
                            break;
                        }
                        options += 2;
                        break;
                    }
                    case 0: 
                    case 2: {
                        options = 0;
                        break;
                    }
                }
                if (this.session.getProcessDuration() == 1) {
                    options += 16;
                    if (this.session.getReceiveIsolation() == 1) {
                        ++options;
                    }
                }
            } else if (Trace.isOn) {
                Trace.traceData(this, "Not operating under syncpoint, no point in using spiGet", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSPIOptions(int)", new Integer(options), 2);
            }
            return options;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSPIOptions(int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSPIOptions(int)", je);
            }
            throw je;
        }
    }

    private int getSyncPointOptions() throws IntErrorException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSyncPointOptions()");
        }
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "getSyncPointOptions", null);
            }
            int result = 0;
            switch (this.syncPoint) {
                case 1: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting for SYNCPOINT", null);
                    }
                    result |= 2;
                    result &= 0xFFFFFFFB;
                    result &= 0xFFFFEFFF;
                    break;
                }
                case 3: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting for NO_SYNCPOINT", null);
                    }
                    result |= 4;
                    result &= 0xFFFFFFFD;
                    result &= 0xFFFFEFFF;
                    break;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting for SPIP", null);
                    }
                    result |= 0x1000;
                    result &= 0xFFFFFFFB;
                    result &= 0xFFFFFFFD;
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Unrecognized syncPoint setting. About to log the error", null);
                    }
                    String detail = ConfigEnvironment.getMessage("MQJMS1006", "syncPoint", String.valueOf(this.syncPoint));
                    HashMap<String, String> ffstData = new HashMap<String, String>();
                    ffstData.put("Message", "MQJMS1016");
                    ffstData.put("Comment", detail);
                    Trace.ffst(this, "getSyncPointOptions()", PROBE_03, ffstData, IntErrorException.class);
                    String key = "MQJMS1016";
                    String msg = ConfigEnvironment.getErrorMessage(key, detail);
                    IntErrorException iee = new IntErrorException(msg, key);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSyncPointOptions()", (Throwable)((Object)iee), 1);
                    }
                    throw iee;
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSyncPointOptions()", new Integer(result));
            }
            return result;
        }
        catch (IntErrorException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSyncPointOptions()", (Throwable)((Object)e));
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "getSyncPointOptions()", (Throwable)((Object)e), 2);
            }
            throw e;
        }
    }

    public void handlePoisonMessage(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "handlePoisonMessage(ProviderMessage)", new Object[]{message});
        }
        try {
            this.backoutRequeue(this.baseMessage);
        }
        catch (JMSException je) {
            Exception e;
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "handlePoisonMessage(ProviderMessage)", je, 1);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage requeue failed. Treating it as a bad message", null);
            }
            int reason = (e = je.getLinkedException()) != null && e instanceof MQException ? ((MQException)((Object)e)).reasonCode : 2362;
            try {
                this.removeBadMessage(this.baseMessage, reason);
            }
            catch (JMSException je2) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "handlePoisonMessage(ProviderMessage)", je2, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "handlePoisonMessage(ProviderMessage)", je2);
                }
                throw je2;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "handlePoisonMessage(ProviderMessage)");
        }
    }

    public boolean shouldMessageBeRequeued(int attempts, ProviderMessage message) {
        boolean requeue;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "shouldMessageBeRequeued(int,ProviderMessage)", new Object[]{new Integer(attempts), message});
        }
        boolean bl = requeue = attempts >= this.backoutThreshold;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "shouldMessageBeRequeued(int,ProviderMessage)", requeue);
        }
        return requeue;
    }

    private boolean isLocalMessage() throws MQException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()");
        }
        boolean localMessage = false;
        RFH rfh1 = null;
        try {
            String id;
            block44: {
                long format;
                try {
                    format = this.baseMessage.getFormatAsLong();
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", e, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS1087");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", je, 1);
                    }
                    throw je;
                }
                id = null;
                if (format == 5571313732235042848L || format == -3109514705039769536L) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Received message has RFH1 header", null);
                    }
                    try {
                        rfh1 = new RFH(this.baseMessage);
                        if (rfh1 != null) {
                            id = rfh1.getValue("UNIQUE_CONNECTION_ID");
                        }
                        break block44;
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", je, 2);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "couldn't create an RFH from the incoming message", null);
                        }
                        break block44;
                    }
                    catch (NoSuchElementException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", e, 3);
                        }
                        break block44;
                    }
                }
                if (format == 5571313732236222496L || format == -3109514705028104128L) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Received message has RFH2 header", null);
                    }
                    try {
                        JmqiEnvironment env = MQSESSION.getJmqiEnv();
                        JmqiSystemEnvironment jmqiSysEnv = MQSESSION.getJmqiSysEnv();
                        JmqiComponentTls tls = jmqiSysEnv.getComponentTls(MQSESSION.jmsv6CompId);
                        JmqiTls jTls = jmqiSysEnv.getJmqiTls(tls);
                        int encoding = this.baseMessage.getEncoding();
                        int ccsid = this.baseMessage.getCharacterSet();
                        long mqheader = format & 0xFFFFFF0000000000L;
                        byte[] buffer = this.baseMessage.getMessageData();
                        int pos = 0;
                        JmqiCodepage cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)env, (int)ccsid);
                        int previousCcsid = ccsid;
                        int ptrSize = 4;
                        MQRFH rfh = env.newMQRFH(10);
                        MQHeader header = rfh.getMqHeader();
                        header.setFormat(this.baseMessage.getFormat());
                        long formatLong = MQHeader.convertFormatToLong((JmqiEnvironment)env, (JmqiCodepage)cp, (String)this.baseMessage.getFormat());
                        while ((mqheader == 5571313378871214080L || mqheader == -3109515640373772288L) && id == null) {
                            if (ccsid == -2) {
                                ccsid = previousCcsid;
                            }
                            if (ccsid != previousCcsid) {
                                cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)env, (int)ccsid);
                            }
                            boolean swap = (encoding & 0xF) == 2;
                            int bodyPos = header.readFromBuffer(buffer, pos, ptrSize, swap, cp, jTls, false);
                            if (formatLong == 5571313732236222496L || formatLong == -3109514705028104128L) {
                                rfh.readBodyFromBuffer(buffer, bodyPos, ptrSize, swap, cp, jTls);
                                int numberOfFolders = rfh.getNameValueDataLength();
                                for (int i = 0; i < numberOfFolders; ++i) {
                                    String folder = rfh.getNameValueData(i);
                                    int idStartTagPos = folder.indexOf("<UNIQUE_CONNECTION_ID>");
                                    int idEndTagPos = folder.indexOf("</UNIQUE_CONNECTION_ID>");
                                    if (idStartTagPos == -1 || idEndTagPos == -1) continue;
                                    id = folder.substring(idStartTagPos + 22, idEndTagPos);
                                    break;
                                }
                            }
                            pos += header.getStrucLength();
                            encoding = header.getEncoding();
                            previousCcsid = ccsid;
                            ccsid = header.getCodedCharSetId();
                            formatLong = header.getFormatLong(cp);
                            mqheader = formatLong & 0xFFFFFF0000000000L;
                        }
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", e, 4);
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS1087");
                        if (Trace.isOn) {
                            Trace.traceData(this, "Create and Throwing " + (Object)((Object)je), null);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", je, 2);
                        }
                        throw je;
                    }
                } else {
                    JMSException je = ConfigEnvironment.newException("MQJMS1087");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", je, 3);
                    }
                    throw je;
                }
            }
            if (id == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "No UNIQUE_CONNECTION_ID in message", null);
                }
            } else if (id.equals(this.session.getConnectionID())) {
                if (Trace.isOn) {
                    Trace.traceData(this, "IDs match (" + id + ")" + ", therefore " + "the message is local, and needs to be " + "discarded. Setting retry=true", null);
                }
                localMessage = true;
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "IDs don't match. Incoming=" + id + ", ProviderConnection=" + this.session.getConnectionID() + ". ProviderMessage is non-local, therefore valid", null);
                }
                localMessage = false;
            }
            this.baseMessage.resetReadPosition();
            if (Trace.isOn) {
                Trace.traceData(this, "isLocalMessage returning " + localMessage, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", localMessage);
            }
            return localMessage;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", je, 5);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", je, 4);
            }
            throw je;
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", mqe, 6);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isLocalMessage()", mqe, 5);
            }
            throw mqe;
        }
    }

    private JMSMessage isMessageSelected() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()");
        }
        try {
            JMSMessage result = null;
            try {
                result = this.baseMessage.createJMSMessage(this.session, this.destination);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", je, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", je, 1);
                }
                throw je;
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", ioe, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "IOException thrown creating JMSMessage, Wrapping in new JMSException", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1000");
                je.setLinkedException((Exception)ioe);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", je, 2);
                }
                throw je;
            }
            boolean messageSuitable = true;
            if (this.setForPTP && this.useBrowse || this.setForPubSub && this.selectorSet && this.subscription.getFilter() == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "About to check selector", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "isMessageSelected just returning JMSMessage", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", result, 1);
                }
                return result;
            }
            messageSuitable = this.messageSelector.isSelected(result, this.baseMessage);
            if (messageSuitable) {
                if (Trace.isOn) {
                    Trace.traceData(this, "isMessageSelected true, returning JMSMessage", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", result, 2);
                }
                return result;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "isMessageSelected false, returning null", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", null, 3);
            }
            return null;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", je, 3);
            }
            this.backoutFailedMsgs();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isMessageSelected()", je, 3);
            }
            throw je;
        }
    }

    private void backoutFailedMsgs() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutFailedMsgs()");
        }
        if (this.backoutThreshold != 0 && this.baseMessage.getBackoutCount() >= this.backoutThreshold) {
            if (Trace.isOn) {
                Trace.traceData(this, "backoutThreshold reached", null);
            }
            try {
                this.backoutRequeue(this.baseMessage);
            }
            catch (JMSException je) {
                Exception e;
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutFailedMsgs()", je, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Message requeue failed. Treating it as a bad message", null);
                }
                int reason = (e = je.getLinkedException()) != null && e instanceof MQException ? ((MQException)((Object)e)).reasonCode : 2362;
                try {
                    this.removeBadMessage(this.baseMessage, reason);
                }
                catch (JMSException je2) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutFailedMsgs()", je2, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutFailedMsgs()", je2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutFailedMsgs()", je2);
                    }
                    throw je2;
                }
            }
            this.commitIfRequired(false, true);
            switch (this.session.getAcknowledgeMode()) {
                case 0: 
                case 2: {
                    this.session.setCommitRequired(true);
                    break;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "backoutFailedMsgs()");
        }
    }

    private boolean isNewPTPMessage() {
        boolean seen;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isNewPTPMessage()");
        }
        String uniqueID = null;
        uniqueID = this.getIDFromMessage(this.baseMessage);
        boolean bl = seen = uniqueID != null && this.prevGenSeenList.containsKey(uniqueID) && !this.nextGenSeenList.containsKey(uniqueID);
        if (seen) {
            if (Trace.isOn) {
                Trace.traceData(this, "message found in seen list. Skipping.", null);
            }
            this.nextGenSeenList.put(uniqueID, this.nullValue);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isNewPTPMessage()", false, 1);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "isNewPTPMessage returning true", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "isNewPTPMessage()", true, 2);
        }
        return true;
    }

    public ProviderMessage receive() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive()");
        }
        try {
            ProviderMessage traceRet1 = this.receiveInternal(-1L);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive()", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive()", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive()", je);
            }
            throw je;
        }
    }

    public ProviderMessage receive(long timeout) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive(long)", new Object[]{new Long(timeout)});
        }
        try {
            if (timeout == 0L) {
                timeout = -1L;
            } else if (timeout == -1L) {
                timeout = 0L;
            }
            ProviderMessage traceRet1 = this.receiveInternal(timeout);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive(long)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive(long)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receive(long)", je);
            }
            throw je;
        }
    }

    protected boolean receiveAsync(long timeOut) throws NoMsgListenerException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", new Object[]{new Long(timeOut)});
        }
        boolean msgDelivered = false;
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "Performing initial validity checks", null);
            }
            if (this.closed) {
                if (Trace.isOn) {
                    Trace.traceData(this, "ProviderMessageConsumer is closed.", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", false, 4);
                }
                return false;
            }
            if (this.listener == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "No registered ProviderMessageListener.", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1012");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 2);
                }
                throw je;
            }
            if (this.queue == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Queue is null.", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2001");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 3);
                }
                throw je;
            }
            if (!this.setForPTP && !this.setForPubSub) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", false, 1);
                }
                return false;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Validity checks passed.", null);
            }
            boolean transacted = this.session.getTransacted();
            if (!this.session.isStarted()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "ProviderSession is not started, returning immediately", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", false, 2);
                }
                return false;
            }
            JMSMessage message = this.getMessage(timeOut);
            if (message != null) {
                if (!transacted && this.acknowledgeMode == 2) {
                    message._setSession(this.session);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "entering async delivery block", null);
                }
                if (this.listener != null) {
                    boolean retry = true;
                    int attempts = 0;
                    while (retry) {
                        try {
                            retry = false;
                            ++attempts;
                            this.listener.onMessage(message);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", t, 1);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Exception thrown from ProviderMessageListener.onMessage()", null);
                            }
                            HashMap<String, Object> ffstData = new HashMap<String, Object>();
                            ffstData.put("Exception", t);
                            ffstData.put("Message", "MQJMS1034");
                            Trace.ffst(this, "receiveAsync(long)", PROBE_01, ffstData, class$javax$jms$JMSException == null ? MQMessageConsumer.class$("javax.jms.JMSException") : class$javax$jms$JMSException);
                            if ((this.acknowledgeMode == 1 || this.acknowledgeMode == 3) && attempts < this.maxAsyncAttempts) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "We will attempt to redeliver this message", null);
                                }
                                retry = true;
                                message.setJMSRedelivered(true);
                                continue;
                            }
                            try {
                                if (this.backoutRetryQueue == null) {
                                    JMSException je = ConfigEnvironment.newException("MQJMS1022");
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "receiveAsync() no backout queue defined.", null);
                                    }
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 4);
                                    }
                                    throw je;
                                }
                                boolean syncRedirect = true;
                                if (this.syncPoint == 3 || this.syncPoint == 2 && this.baseMessage.getPersistence() != 1) {
                                    syncRedirect = false;
                                }
                                this.session.redirectMessage(this.backoutRetryQueue, this.baseMessage, syncRedirect);
                                if (this.syncPoint != 2 || this.baseMessage.getPersistence() == 1) continue;
                                this.session._acknowledgeInternal();
                            }
                            catch (JMSException je) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 2);
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "failed to redirect message. Closing receiver", null);
                                }
                                ffstData = new HashMap();
                                ffstData.put("Exception", (Object)je);
                                ffstData.put("Message", "MQJMS1022");
                                Trace.ffst(this, "receiveAsync(long)", PROBE_02, ffstData, JMSException.class);
                                this.close(false);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 5);
                                }
                                throw je;
                            }
                        }
                    }
                } else {
                    NoMsgListenerException nmle = new NoMsgListenerException("no message listener registered");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", (Throwable)((Object)nmle), 6);
                    }
                    throw nmle;
                }
                if (this.session.getCommitRequired()) {
                    this.commitIfRequired(true, false);
                }
                if (this.session.getAcknowledgeMode() == 2 || this.session.getAcknowledgeMode() == 0) {
                    message._setSession(this.session);
                }
                msgDelivered = true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", msgDelivered, 3);
            }
            return msgDelivered;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveAsync(long)", je, 7);
            }
            throw je;
        }
    }

    private ProviderMessage receiveInternal(long timeOut) throws NoMsgListenerException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", new Object[]{new Long(timeOut)});
        }
        try {
            long timeLeft;
            JMSMessage result = null;
            if (Trace.isOn) {
                Trace.traceData(this, "Performing initial validity checks", null);
            }
            if (this.closed || this.session == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "ProviderSession is closed or null.", null);
                }
                String msg = this.setForPubSub ? ConfigEnvironment.getErrorMessage("MQJMS3034") : (this.setForPTP ? ConfigEnvironment.getErrorMessage("MQJMS3033") : ConfigEnvironment.getErrorMessage("MQJMS3038"));
                IllegalStateException je = new IllegalStateException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", je, 1);
                }
                throw je;
            }
            if (this.queue == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Queue is null.", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS2001");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", je, 2);
                }
                throw je;
            }
            if (!this.session.callingFromOnMessage() && (this.session.usingAsyncMode() || this.session.hasMessageListener())) {
                if (Trace.isOn) {
                    Trace.traceData(this, "ProviderSession is in async mode.", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1013");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", je, 3);
                }
                throw je;
            }
            if (timeOut != -1L && (timeOut > Integer.MAX_VALUE || timeOut < 0L)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Invalid timeOut.", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1067");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", je, 4);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Finished validity checks", null);
            }
            if (timeOut == 0L && this.session.isStopped()) {
                if (Trace.isOn) {
                    Trace.traceData(this, "early return. ProviderSession closed and timeOut = 0", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", null, 1);
                }
                return null;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "receiveInternal - waiting for session start", null);
            }
            if (timeOut == -1L) {
                this.session.waitForStart();
                timeLeft = -1L;
            } else {
                timeLeft = this.session.waitForStart(timeOut);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "receiveInternal - session started", null);
            }
            if (timeOut > 0L && timeLeft == 0L) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Out of time waiting for ProviderSession to start. Returning null", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", null, 2);
                }
                return null;
            }
            if (!this.session.isStarted() || this.closed) {
                if (Trace.isOn) {
                    Trace.traceData(this, "ProviderSession stopped or closed while getting transation Lock. Returning null", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", null, 3);
                }
                return null;
            }
            result = this.getMessage(timeLeft);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", result, 4);
            }
            return result;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveInternal(long)", je, 5);
            }
            throw je;
        }
    }

    public ProviderMessage receiveNoWait() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveNoWait()");
        }
        try {
            ProviderMessage traceRet1 = this.receiveInternal(0L);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveNoWait()", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveNoWait()", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "receiveNoWait()", je);
            }
            throw je;
        }
    }

    private void removeBadMessage(MQJMSMessage msg, int reason) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int)", new Object[]{msg, new Integer(reason)});
        }
        try {
            if ((msg.getReport() & 0x8000000) == 0x8000000) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Discarding message as per MQMD.Report", null);
                }
                this.discard(msg, reason);
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Dead-lettering message as per MQMD.Report", null);
                }
                this.deadLetter(msg, reason);
            }
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int)", jmse);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "throwing " + (Object)((Object)jmse), null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int)", jmse);
            }
            throw jmse;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBadMessage(MQJMSMessage,int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeBrowsedMessage(boolean messageSuitable) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)", new Object[]{messageSuitable});
        }
        try {
            int currentOptions;
            boolean success;
            block23: {
                success = true;
                currentOptions = this.gmo.options;
                this.gmo.options = messageSuitable ? this.acceptOptions : this.deleteOptions;
                try {
                    int rc = 0;
                    if (this.backoutThreshold != 0 && this.baseMessage.getBackoutCount() >= this.backoutThreshold) {
                        this.gmo.options = this.acceptOptions;
                        this.gmo.options |= 0;
                        this.gmo.options |= this.getSyncPointOptions();
                        this.gmo.options &= 0xFFFFFFBF;
                        rc = this.queue.getMsg2NoExc(this.baseMessage, this.gmo);
                        success = true;
                    } else {
                        rc = this.queue.getMsg2NoExc(this.baseMessage, this.gmo, 1);
                        success = true;
                    }
                    if (rc == 2079) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Accepted truncated message. Expected result", null);
                        }
                        success = true;
                    } else if (rc == 2034) {
                        success = false;
                        if (Trace.isOn) {
                            Trace.traceData(this, "couldn't dequeue message - message expired or competing consumers?", null);
                        }
                    } else if (rc == 2033) {
                        success = false;
                        if (Trace.isOn) {
                            Trace.traceData(this, "couldn't dequeue message - message expired or competing consumers?", null);
                        }
                    } else if (rc != 0) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Unexpected reason code from getMsg2()", null);
                        }
                        MQException mqe = new MQException(-1, rc, (Object)this);
                        JMSException je = ConfigEnvironment.newException("MQJMS2002");
                        je.setLinkedException((Exception)((Object)mqe));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)", je, 1);
                        }
                        throw je;
                    }
                    Object var8_8 = null;
                    if (!Trace.isOn) break block23;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)");
                    }
                    this.gmo.options = currentOptions;
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)");
            }
            this.gmo.options = currentOptions;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)", success);
            }
            return success;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "removeBrowsedMessage(boolean)", je, 2);
            }
            throw je;
        }
    }

    public void setMessageListener(ProviderMessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListener(ProviderMessageListener)", "setter", listener);
        }
        if (this.setForPTP) {
            this.setMessageListenerQ(listener);
        } else if (this.setForPubSub) {
            this.setMessageListenerT(listener);
        }
    }

    private void setMessageListenerQ(ProviderMessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerQ(ProviderMessageListener)", new Object[]{listener});
        }
        try {
            if (this.closed || this.session == null) {
                String msg = ConfigEnvironment.getErrorMessage("MQJMS3033");
                IllegalStateException je = new IllegalStateException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerQ(ProviderMessageListener)", je, 1);
                }
                throw je;
            }
            if (listener != null && this.session.hasMessageListener()) {
                JMSException je = ConfigEnvironment.newException("MQJMS1013");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerQ(ProviderMessageListener)", je, 2);
                }
                throw je;
            }
            this.listener = listener;
            if (listener == null) {
                this.session.removeAsync(this);
            } else {
                this.session.addAsync(this);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerQ(ProviderMessageListener)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerQ(ProviderMessageListener)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerQ(ProviderMessageListener)");
        }
    }

    private void setMessageListenerT(ProviderMessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerT(ProviderMessageListener)", new Object[]{listener});
        }
        try {
            if (this.closed || this.session == null) {
                String msg = ConfigEnvironment.getErrorMessage("MQJMS3034");
                IllegalStateException je = new IllegalStateException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerT(ProviderMessageListener)", je, 1);
                }
                throw je;
            }
            if (listener != null && this.session.hasMessageListener()) {
                JMSException je = ConfigEnvironment.newException("MQJMS1013");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerT(ProviderMessageListener)", je, 2);
                }
                throw je;
            }
            this.listener = listener;
            if (listener == null) {
                this.session.removeAsync(this);
            } else {
                this.session.addAsync(this);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerT(ProviderMessageListener)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerT(ProviderMessageListener)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageListenerT(ProviderMessageListener)");
        }
    }

    private void setMessageSelector(String selector) throws InvalidSelectorException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)", new Object[]{selector});
        }
        try {
            if (this.messageSelector == null) {
                this.messageSelector = new MQMessageSelector();
            }
            try {
                if (selector != null) {
                    if (selector.equals("\u0000")) {
                        SyntaxException traceRet1 = new SyntaxException();
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                    boolean allChar = false;
                    boolean keepChecking = true;
                    for (int i = 0; keepChecking && i < selector.length(); ++i) {
                        if (selector.charAt(i) == ' ') {
                            allChar = true;
                            continue;
                        }
                        allChar = false;
                        keepChecking = false;
                    }
                    if (selector.length() == 0 || allChar) {
                        selector = null;
                    }
                }
                this.messageSelector.setSelector(selector);
            }
            catch (SyntaxException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)", e, 1);
                }
                String key = "MQJMS0004";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidSelectorException je = new InvalidSelectorException(msg, key);
                je.setLinkedException((Exception)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)", je, 2);
                }
                throw je;
            }
        }
        catch (InvalidSelectorException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String)");
        }
    }

    private boolean setMessageSelector(String selector, MQMsg2 message, MQGetMessageOptions gmo) throws InvalidSelectorException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", new Object[]{selector, message, gmo});
        }
        try {
            boolean result;
            if (this.messageSelector == null) {
                this.messageSelector = new MQMessageSelector();
            }
            try {
                if (selector != null) {
                    if (selector.equals("\u0000")) {
                        SyntaxException traceRet1 = new SyntaxException();
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                    boolean allChar = false;
                    boolean keepChecking = true;
                    for (int i = 0; keepChecking && i < selector.length(); ++i) {
                        if (selector.charAt(i) == ' ') {
                            allChar = true;
                            continue;
                        }
                        allChar = false;
                        keepChecking = false;
                    }
                    if (selector.length() == 0 || allChar) {
                        selector = null;
                    }
                }
                result = this.messageSelector.setSelector(selector, message, gmo);
            }
            catch (SyntaxException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", e, 1);
                }
                String key = "MQJMS0004";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidSelectorException je = new InvalidSelectorException(msg, key);
                je.setLinkedException((Exception)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", je, 2);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", result);
            }
            return result;
        }
        catch (InvalidSelectorException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setMessageSelector(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions)", je, 3);
            }
            throw je;
        }
    }

    private void setSyncpointBehaviour(boolean forceSPIP) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setSyncpointBehaviour(boolean)", new Object[]{forceSPIP});
        }
        boolean alwaysSync = this.session.getSyncpointAllGets();
        if (this.transacted || alwaysSync || this.acknowledgeMode == 2 || this.session.getDistTransactionMode() == 2) {
            this.syncPoint = 1;
            this.getOptions |= 2;
            this.acceptOptions |= 2;
            if (Trace.isOn) {
                Trace.traceData(this, "syncpoint enabled", null);
            }
        } else if (this.durable || forceSPIP) {
            this.syncPoint = 2;
            this.getOptions |= 0x1000;
            this.acceptOptions |= 0x1000;
            if (Trace.isOn) {
                Trace.traceData(this, "using syncpoint if persistent", null);
            }
        } else {
            this.syncPoint = 3;
            this.getOptions |= 4;
            this.acceptOptions |= 4;
            if (Trace.isOn) {
                Trace.traceData(this, "syncpoint disabled", null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "setSyncpointBehaviour(boolean)");
        }
    }

    public void start(boolean deliverImmediately) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "start(boolean)", new Object[]{deliverImmediately});
        }
        this.running = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "start(boolean)");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "stop()");
        }
        this.running = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "stop()");
        }
    }

    public boolean equals(Object o) {
        boolean equals = super.equals(o);
        if (equals) {
            equals = o instanceof MQMessageConsumer ? (this.listener != null ? this.listener.equals(((MQMessageConsumer)o).listener) : ((MQMessageConsumer)o).listener == null) : false;
        }
        return equals;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQMessageConsumer.java, jmscc.wmq.v6, k701, k701-112-140304  1.81.1.15 12/06/21 13:47:50");
        }
        CHUNKTIME = 5000;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "static()");
        }
        String chunkTimeProperty = "com.ibm.mq.jms.ChunkTime";
        PropertyStore.register(chunkTimeProperty, 5000L, new Long(5000L), new Long(Integer.MAX_VALUE));
        long chunkTimeValue = PropertyStore.getLongProperty(chunkTimeProperty);
        CHUNKTIME = (int)chunkTimeValue;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQMessageConsumer", "static()");
        }
    }
}

