/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.internal.Configuration;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestinationURIParser;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.JMSException;

public class MQJMSMessage
extends MQMsg2 {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQJMSMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.56.1.13 13/01/09 16:32:47";
    public static final String CLASSNAME = "com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage";
    private static final int RFH_CHARACTER_SET = 1208;
    private static final byte[] SPACES;
    private static final String RFH_CHAR_SET_STRING = "UTF8";
    private static final String MQRFH_STRUC_ID = "RFH ";
    private static final int MQRFH_VERSION_1 = 1;
    private static final int MQRFH_VERSION_2 = 2;
    private static final int MQRFH_NO_FLAGS = 0;
    protected static final String MQFMT_RF_HEADER_1 = "MQHRF   ";
    protected static final String MQFMT_RF_HEADER_2 = "MQHRF2  ";
    private static final int MQRFH_STRUC_LENGTH_FIXED_1 = 32;
    private static final int MQRFH_STRUC_LENGTH_FIXED_2 = 36;
    private static final int MQCCSI_INHERIT = -2;
    private static final long MQHEADER_ASCII = 5571313378871214080L;
    private static final long MQHEADER_EBCDIC = -3109515640373772288L;
    private static final long MQHEADER_MASK = -1099511627776L;
    protected static final long MQRFH2_ASCII = 5571313732236222496L;
    protected static final long MQRFH2_EBCDIC = -3109514705028104128L;
    protected static final long MQRFH1_ASCII = 5571313732235042848L;
    protected static final long MQRFH1_EBCDIC = -3109514705039769536L;
    public static final long MQSTR_ASCII = 5571325835654209568L;
    private static final long MQSTR_EBCDIC = -3109486074469007296L;
    private static final String BLANK_STRING15 = "               ";
    private static final Integer ZERO;
    private static final byte[] MQ_NONE;
    private static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    private static final int RFH2_FIXED_SIZE = 36;
    private static final int MQRFH_VERSION_OFFSET = 4;
    private static final int RFH2_LENGTH_OFFSET = 8;
    private static final int RFH2_ENCODING_OFFSET = 12;
    private static final int RFH2_CHARSET_OFFSET = 16;
    private static final int RFH2_FORMAT_OFFSET = 20;
    private static final int RFH_CHAR_SET_OFFSET = 32;
    private byte[] cachedFixedRFH2 = null;
    private int cachedRFH2Length;
    private int cachedRFH2Encoding;
    private int cachedRFH2CharSet;
    private boolean persistenceFromMD;
    private boolean targetClientMatching = true;
    private boolean hasRFH2 = false;
    private byte[] formatAsByteArray = new byte[8];
    private static Hashtable ccsidTable;
    private int dataQuantityHint;
    String cachedRFH2Format;
    private static int defaultReplyToStyle;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JMSMessage createJMSMessage(MQSession session, ProviderDestination destination, int dataQuantity) throws JMSException, IOException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", new Object[]{session, destination, new Integer(dataQuantity)});
        }
        this.dataQuantityHint = dataQuantity;
        JMSMessage jmsMsg = null;
        try {
            try {
                jmsMsg = this.createJMSMessage(session, destination);
            }
            catch (IOException ioe) {
                if (!Trace.isOn) throw ioe;
                Trace.catchBlock(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", ioe, 1);
                Trace.throwing(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", ioe, 1);
                throw ioe;
            }
            catch (JMSException e) {
                if (!Trace.isOn) throw e;
                Trace.catchBlock(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", e, 2);
                Trace.throwing(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", e, 2);
                throw e;
            }
            Object var7_5 = null;
            this.dataQuantityHint = 0;
            if (!Trace.isOn) return jmsMsg;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.dataQuantityHint = 0;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", jmsMsg);
            throw throwable;
        }
        Trace.exit(CLASSNAME, "createJMSMessage(MQSession, ProviderDestination, int)", jmsMsg);
        return jmsMsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JMSMessage createJMSMessage(MQSession session, ProviderDestination destination) throws JMSException, IOException {
        JMSMessage jMSMessage;
        JMSMessage jmsMsg;
        int origEncoding;
        int origCharacterSet;
        block64: {
            if (Trace.isOn) {
                Trace.entry((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", new Object[]{session, destination});
            }
            origCharacterSet = this.getCharacterSet();
            origEncoding = this.getEncoding();
            if (session != null && session.connection != null) {
                this.persistenceFromMD = session.getPersistenceFromMD();
                this.targetClientMatching = session.connection.targetClientMatching;
            }
            jmsMsg = null;
            try {
                try {
                    block73: {
                        block72: {
                            String currentFormat = null;
                            int currentOffset = 0;
                            String nvCharSet = null;
                            String mcdFolder = null;
                            String usrFolder = null;
                            String jmsFolder = null;
                            String mqextFolder = null;
                            int mcdOffset = 0;
                            int mcdLength = 0;
                            int usrOffset = 0;
                            int usrLength = 0;
                            int jmsOffset = 0;
                            int jmsLength = 0;
                            int mqextOffset = 0;
                            int mqextLength = 0;
                            this.hasRFH2 = false;
                            boolean rfh2InUtf8 = false;
                            boolean jmsFolderParsed = false;
                            boolean messageBodyMQ = false;
                            if (destination != null && destination.getIntProperty("messageBody") == 1) {
                                messageBodyMQ = true;
                            }
                            if (Trace.isOn) {
                                Trace.traceData((Object)this, "Resetting read position to start", null);
                            }
                            this.resetReadPosition();
                            int currentEncoding = origEncoding;
                            long currentFormatLong = this.getFormatAsLong();
                            int fmtCset = 1208;
                            int fmtEnc = 1;
                            currentOffset = 0;
                            int hdrStartOffset = 0;
                            while ((currentFormatLong & 0xFFFFFF0000000000L) == 5571313378871214080L || (currentFormatLong & 0xFFFFFF0000000000L) == -3109515640373772288L) {
                                int sugNextCset;
                                int newEnc;
                                int hdrLength;
                                block71: {
                                    block66: {
                                        this.skipReadingBytes(8);
                                        hdrLength = this.readInt(currentEncoding);
                                        newEnc = this.readInt(currentEncoding);
                                        sugNextCset = this.readInt(currentEncoding);
                                        if (currentFormatLong != 5571313732236222496L && currentFormatLong != -3109514705028104128L) break block66;
                                        this.hasRFH2 = true;
                                        currentFormatLong = (long)this.readInt(1) << 32;
                                        currentFormatLong += (long)this.readInt(1) & 0xFFFFFFFFL;
                                        fmtCset = this.getCharacterSet();
                                        fmtEnc = currentEncoding;
                                        this.skipReadingBytes(4);
                                        int csetAsInt = this.readInt(currentEncoding);
                                        if (csetAsInt == 1208) {
                                            rfh2InUtf8 = true;
                                        } else {
                                            nvCharSet = MQJMSMessage.getCharacterSetString(csetAsInt, currentEncoding);
                                            rfh2InUtf8 = false;
                                        }
                                        currentOffset += 36;
                                        while (currentOffset < hdrLength + hdrStartOffset) {
                                            int ll;
                                            block69: {
                                                block67: {
                                                    int i;
                                                    byte[] md;
                                                    block70: {
                                                        block68: {
                                                            ll = this.readInt(currentEncoding);
                                                            currentOffset += 4;
                                                            if (!rfh2InUtf8) break block67;
                                                            md = this.getMessageDataRef();
                                                            if (md[(i = currentOffset) + 0] != 60 || md[i + 1] != 109 || md[i + 2] != 99 || md[i + 3] != 100 || md[i + 4] != 62) break block68;
                                                            mcdOffset = currentOffset;
                                                            mcdLength = ll;
                                                            break block69;
                                                        }
                                                        if (md[i + 0] != 60 || md[i + 1] != 106 || md[i + 2] != 109 || md[i + 3] != 115 || md[i + 4] != 62) break block70;
                                                        jmsOffset = currentOffset;
                                                        jmsLength = ll;
                                                        break block69;
                                                    }
                                                    if (md[i + 0] == 60 && md[i + 1] == 117 && md[i + 2] == 115 && md[i + 3] == 114 && md[i + 4] == 62) {
                                                        usrOffset = currentOffset;
                                                        usrLength = ll;
                                                        break block69;
                                                    } else if (md[i + 0] == 60 && md[i + 1] == 109 && md[i + 2] == 113 && md[i + 3] == 101 && md[i + 4] == 120 && md[i + 5] == 116 && md[i + 6] == 62) {
                                                        mqextOffset = currentOffset;
                                                        mqextLength = ll;
                                                    }
                                                    break block69;
                                                }
                                                String folder = new String(this.getMessageDataRef(), currentOffset, ll, nvCharSet);
                                                if (Trace.isOn) {
                                                    Trace.traceData((Object)this, "createJMSMessage found Folder " + folder, null);
                                                }
                                                if (folder.startsWith("<mcd>")) {
                                                    mcdFolder = folder;
                                                } else if (folder.startsWith("<usr>")) {
                                                    usrFolder = folder;
                                                } else if (folder.startsWith("<jms>")) {
                                                    jmsFolder = folder;
                                                } else if (folder.startsWith("<mqext>")) {
                                                    mqextFolder = folder;
                                                }
                                            }
                                            currentOffset += ll;
                                            this.skipReadingBytes(ll);
                                        }
                                        break block71;
                                    }
                                    currentFormatLong = (long)this.readInt(1) << 32;
                                    currentFormatLong += (long)this.readInt(1) & 0xFFFFFFFFL;
                                    fmtCset = this.getCharacterSet();
                                    fmtEnc = currentEncoding;
                                    this.skipReadingBytes(hdrLength - 28);
                                    currentOffset += hdrLength;
                                }
                                currentEncoding = newEnc;
                                this.setEncoding(newEnc);
                                hdrStartOffset += hdrLength;
                                if (sugNextCset == -2) continue;
                                this.setCharacterSet(sugNextCset);
                            }
                            if (rfh2InUtf8 && mcdLength > 0) {
                                String messageClass;
                                byte[] msgData = this.getMessageDataRef();
                                if (currentFormatLong == 5571325835654209568L || currentFormatLong == -3109486074469007296L) {
                                    messageClass = "jms_text";
                                    currentFormat = "MQSTR   ";
                                } else {
                                    messageClass = "jms_bytes";
                                }
                                jmsMsg = JMSMessage._parseMcdFolderUtf8(session, MQSession.jmsStrings, messageClass, msgData, mcdOffset, mcdLength, messageBodyMQ);
                                if (jmsLength > 0) {
                                    jmsMsg._parseJmsFolderUtf8(msgData, jmsOffset, jmsLength, session, this.persistenceFromMD);
                                    jmsFolderParsed = true;
                                }
                                if (usrLength > 0) {
                                    usrFolder = new String(msgData, usrOffset, usrLength, RFH_CHAR_SET_STRING);
                                    jmsMsg._parseUsrFolder(usrFolder);
                                }
                                if (mqextLength > 0) {
                                    jmsMsg._parseMQExtFolderUtf8(msgData, mqextOffset, mqextLength);
                                }
                            } else if (mcdFolder != null) {
                                String messageClass;
                                if (currentFormatLong == 5571325835654209568L || currentFormatLong == -3109486074469007296L) {
                                    messageClass = "jms_text";
                                    currentFormat = "MQSTR   ";
                                } else {
                                    messageClass = "jms_bytes";
                                }
                                jmsMsg = JMSMessage._parseMcdFolder(session, MQSession.jmsStrings, mcdFolder, messageClass, messageBodyMQ);
                                if (jmsFolder != null) {
                                    jmsMsg._parseJmsFolder(session, jmsFolder, this.persistenceFromMD);
                                    jmsFolderParsed = true;
                                }
                                if (usrFolder != null) {
                                    jmsMsg._parseUsrFolder(usrFolder);
                                }
                                if (mqextFolder != null) {
                                    jmsMsg._parseMQExtFolder(mqextFolder);
                                }
                            } else {
                                if (messageBodyMQ) {
                                    jmsMsg = (JMSMessage)((Object)session.createBytesMessage());
                                } else if (this.getMessageDataLength() == 0) {
                                    jmsMsg = (JMSMessage)session.createMessage();
                                } else if (currentFormatLong == 5571325835654209568L || currentFormatLong == -3109486074469007296L) {
                                    currentFormat = "MQSTR   ";
                                    jmsMsg = (JMSMessage)((Object)session.createTextMessage());
                                } else {
                                    jmsMsg = (JMSMessage)((Object)session.createBytesMessage());
                                }
                                if (rfh2InUtf8) {
                                    byte[] msgData = this.getMessageDataRef();
                                    if (jmsLength > 0) {
                                        jmsMsg._parseJmsFolderUtf8(msgData, jmsOffset, jmsLength, session, this.persistenceFromMD);
                                        jmsFolderParsed = true;
                                    }
                                    if (usrLength > 0) {
                                        usrFolder = new String(msgData, usrOffset, usrLength, RFH_CHAR_SET_STRING);
                                        jmsMsg._parseUsrFolder(usrFolder);
                                    }
                                    if (mqextLength > 0) {
                                        jmsMsg._parseMQExtFolderUtf8(msgData, mqextOffset, mqextLength);
                                    }
                                } else {
                                    if (jmsFolder != null) {
                                        jmsMsg._parseJmsFolder(session, jmsFolder, this.persistenceFromMD);
                                        jmsFolderParsed = true;
                                    }
                                    if (usrFolder != null) {
                                        jmsMsg._parseUsrFolder(usrFolder);
                                    }
                                    if (mqextFolder != null) {
                                        jmsMsg._parseMQExtFolder(mqextFolder);
                                    }
                                }
                            }
                            if (!jmsFolderParsed) {
                                jmsMsg.setJMSDeliveryMode(-3);
                            }
                            this.setMQMDPropsFromHeader(destination, jmsMsg);
                            this.setHeaderFromMQMD(jmsMsg, destination);
                            if (currentFormat == null) {
                                this.formatAsByteArray[0] = (byte)(currentFormatLong >>> 56 & 0xFFL);
                                this.formatAsByteArray[1] = (byte)(currentFormatLong >>> 48 & 0xFFL);
                                this.formatAsByteArray[2] = (byte)(currentFormatLong >>> 40 & 0xFFL);
                                this.formatAsByteArray[3] = (byte)(currentFormatLong >>> 32 & 0xFFL);
                                this.formatAsByteArray[4] = (byte)(currentFormatLong >>> 24 & 0xFFL);
                                this.formatAsByteArray[5] = (byte)(currentFormatLong >>> 16 & 0xFFL);
                                this.formatAsByteArray[6] = (byte)(currentFormatLong >>> 8 & 0xFFL);
                                this.formatAsByteArray[7] = (byte)(currentFormatLong >>> 0 & 0xFFL);
                                String cSetAsString = MQJMSMessage.getCharacterSetString(fmtCset, fmtEnc);
                                currentFormat = new String(this.formatAsByteArray, cSetAsString);
                            }
                            this.setHeaderFromMQMD_on_Receive(jmsMsg, currentFormat);
                            if (this.dataQuantityHint == 1) break block72;
                            if (messageBodyMQ) {
                                jmsMsg._importBody(this.getMessageData(), 0, this.getEncoding(), MQJMSMessage.getCharacterSetString(this.getCharacterSet(), this.getEncoding()));
                                break block73;
                            } else if (currentOffset < this.getMessageDataLength()) {
                                jmsMsg._importBody(this.getMessageData(), currentOffset, this.getEncoding(), MQJMSMessage.getCharacterSetString(this.getCharacterSet(), this.getEncoding()));
                            }
                            break block73;
                        }
                        Trace.traceData((Object)this, "createJMSMessage - HEADER_DATA. ignoring JMS body. dataQuantityHint: ", (Object)new Integer(this.dataQuantityHint));
                        this.dataQuantityHint = 0;
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", jmsMsg);
                    }
                    jMSMessage = jmsMsg;
                    Object var39_47 = null;
                    if (!Trace.isOn) break block64;
                }
                catch (IOException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", e, 1);
                    }
                    if (!Trace.isOn) throw e;
                    Trace.throwing((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", e, 1);
                    throw e;
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", e, 2);
                    }
                    JMSException je = new JMSException("MQJMS1000");
                    je.setLinkedException((Exception)((Object)e));
                    if (!Trace.isOn) throw je;
                    Trace.throwing((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", je, 2);
                    throw je;
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", je, 3);
                    }
                    if (!Trace.isOn) throw je;
                    Trace.throwing((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)", je, 3);
                    throw je;
                }
            }
            catch (Throwable throwable) {
                Object var39_48 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)");
                }
                this.setCharacterSet(origCharacterSet);
                this.setEncoding(origEncoding);
                if (jmsMsg == null) throw throwable;
                jmsMsg.setIntProperty("JMS_IBM_MQMD_CodedCharSetId", origCharacterSet);
                jmsMsg.setIntProperty("JMS_IBM_MQMD_Encoding", origEncoding);
                jmsMsg._setReadOnly();
                throw throwable;
            }
            Trace.finallyBlock((Object)this, CLASSNAME, "createJMSMessage(MQSession,ProviderDestination)");
        }
        this.setCharacterSet(origCharacterSet);
        this.setEncoding(origEncoding);
        if (jmsMsg == null) return jMSMessage;
        jmsMsg.setIntProperty("JMS_IBM_MQMD_CodedCharSetId", origCharacterSet);
        jmsMsg.setIntProperty("JMS_IBM_MQMD_Encoding", origEncoding);
        jmsMsg._setReadOnly();
        return jMSMessage;
    }

    public static String getCharacterSetString(int charSet, int encoding) throws JMSException {
        String retVal;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getCharacterSetString(int,int)", new Object[]{new Integer(charSet), new Integer(encoding)});
        }
        if (charSet < 0) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", "charSet");
            inserts.put("XMSC_INSERT_VALUE", String.valueOf(charSet));
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1006", inserts));
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "getCharacterSetString(int,int)", je);
            }
            throw je;
        }
        if (charSet == 0) {
            charSet = 819;
        }
        if (charSet % 4096 == 1200) {
            JmqiEnvironment env;
            Configuration conf;
            retVal = (encoding & 0xF) == 2 ? "UnicodeLittle" : ((conf = (env = MQSESSION.getJmqiEnv()).getConfiguration()).getBoolValue(Configuration.CCSID_MAPCCSID1200TOUNICODEBIGUNMARKED) ? "UnicodeBigUnmarked" : "UnicodeBig");
        } else {
            retVal = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (int)charSet).charsetId;
            if (retVal == null) {
                retVal = "Cp" + Integer.toString(charSet);
            }
        }
        if (Trace.isOn) {
            Trace.traceData(CLASSNAME, "Mapped " + charSet + " -> " + retVal, null);
        }
        try {
            sccsid.getBytes(retVal);
        }
        catch (UnsupportedEncodingException uee) {
            if (Trace.isOn) {
                Trace.data(CLASSNAME, "getCharacterSetString(int,int)", "Caught expected exception", (Object)uee);
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Charset " + retVal + " not supported, using UTF-8", null);
            }
            retVal = "UTF-8";
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getCharacterSetString(int,int)", (Object)retVal);
        }
        return retVal;
    }

    protected void setHeaderFromMQMD(ProviderMessage jmsMsg) throws JMSException {
        if (Trace.isOn) {
            Trace.data((Object)this, CLASSNAME, "setHeaderFromMQMD(ProviderMessage)", "setter", jmsMsg);
        }
        this.setHeaderFromMQMD(jmsMsg, null);
    }

    protected void setHeaderFromMQMD(ProviderMessage jmsMsg, ProviderDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "setHeaderFromMQMD(ProviderMessage,ProviderDestination)", new Object[]{jmsMsg, destination});
        }
        try {
            String mqmdReplyToQ;
            jmsMsg.setJMSPriority(this.getPriority());
            if (jmsMsg.getJMSDeliveryMode() == -2 || this.persistenceFromMD) {
                if (this.getPersistence() == 0) {
                    jmsMsg.setJMSDeliveryMode(1);
                } else if (this.getPersistence() == 1) {
                    jmsMsg.setJMSDeliveryMode(2);
                } else {
                    jmsMsg.setJMSDeliveryMode(-1);
                }
            }
            String replyToURI = jmsMsg.getJMSReplyToAsString();
            if (jmsMsg instanceof JMSMessage) {
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "message is a JMSMessage", null);
                }
                JMSMessage ibmMsg = (JMSMessage)jmsMsg;
                ibmMsg._setCcsidForStrings(this._getCcsid(), this._getIsCcsidAscii(), this._doStringsNeedCcsidConversion());
                ibmMsg._setJMSMessageIDAsBytes(this.getMessageId());
                ibmMsg._setJMSXUserIDFromBytes(this.getUserIdAsBytes());
                ibmMsg._setJMSXPutAppIDFromBytes(this.getPutApplicationNameAsBytes());
                if ((this.getMessageFlags() & 8) != 0 || (this.getMessageFlags() & 0x10) != 0) {
                    ibmMsg._setJMSXGroupSeqFromInt(this.getMessageSequenceNumber());
                    String groupIDString = JMSMessage._idToString(this.getGroupId());
                    if (groupIDString != null && ibmMsg.getStringProperty("JMSXGroupID") == null) {
                        ibmMsg._setJMSXObjectProperty("JMSXGroupID", groupIDString);
                    }
                }
                ibmMsg._setJMSIBMPutDateFromBytes(this.getPutDateAsBytes());
                ibmMsg._setJMSIBMPutTimeFromBytes(this.getPutTimeAsBytes());
                ibmMsg._setJMSIBMPutApplTypeFromInt(this.getPutApplicationType());
            } else {
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "message is from another vendor, only updating subset of properties", null);
                }
                jmsMsg.setJMSMessageID(JMSMessage._idToString(this.getMessageId()));
            }
            boolean goWithMD = true;
            if (destination != null) {
                int replyToStyle = destination.getIntProperty("XMSC_WMQ_REPLYTO_STYLE");
                goWithMD = replyToStyle == 0 && defaultReplyToStyle == 1 || replyToStyle == 1;
            }
            String string = mqmdReplyToQ = (mqmdReplyToQ = this.getReplyToQueueName()) != null ? mqmdReplyToQ.trim() : null;
            if (goWithMD && mqmdReplyToQ != null && !mqmdReplyToQ.equals("")) {
                String mqmdReplyToQMgr = this.getReplyToQueueManagerName();
                mqmdReplyToQMgr = mqmdReplyToQMgr == null ? "" : mqmdReplyToQMgr.trim();
                StringBuffer replyToDestURI = new StringBuffer("queue://");
                replyToDestURI.append(mqmdReplyToQMgr).append("/").append(mqmdReplyToQ);
                String replyToParamters = null;
                if (replyToURI != null) {
                    int positionOfQuestionMark = replyToURI.indexOf(63);
                    if (positionOfQuestionMark > 0) {
                        replyToParamters = replyToURI.substring(positionOfQuestionMark);
                    }
                } else if (!this.hasRFH2 && this.targetClientMatching) {
                    replyToParamters = "?targetClient=1";
                }
                if (replyToParamters != null) {
                    replyToDestURI.append(replyToParamters);
                }
                jmsMsg.setJMSReplyToAsString(replyToDestURI.toString());
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "setHeaderFromMQMD(ProviderMessage,ProviderDestination)", e);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "setHeaderFromMQMD(ProviderMessage,ProviderDestination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "setHeaderFromMQMD(ProviderMessage,ProviderDestination)");
        }
    }

    private void setHeaderFromMQMD_on_Receive(JMSMessage jmsMsg, String bodyFormat) throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "setHeaderFromMQMD_on_Receive(JMSMessage,String)", new Object[]{jmsMsg, bodyFormat});
        }
        try {
            int report;
            int report_subset;
            if (jmsMsg.getJMSCorrelationID() == null) {
                jmsMsg.setJMSCorrelationIDAsBytes(this.getCorrelationIdRef());
            }
            if (jmsMsg.getJMSTimestamp() == 0L) {
                jmsMsg.setJMSTimestamp(this.getPutTimeMillis());
            }
            if (jmsMsg.getJMSExpiration() == 0L && this.getExpiry() > 0) {
                jmsMsg.setJMSExpiration(System.currentTimeMillis() + (long)(this.getExpiry() * 100));
            }
            if (this.getBackoutCount() > 0) {
                jmsMsg.setJMSRedelivered(true);
            }
            jmsMsg._setJMSXDeliveryCountFromInt(this.getBackoutCount() + 1);
            jmsMsg._setJMSIBMMsgTypeFromInt(this.getMessageType());
            jmsMsg._setJMSXObjectProperty("JMS_IBM_Format", bodyFormat);
            if (this.getFeedback() != 0) {
                jmsMsg._setJMSIBMFeedbackFromInt(this.getFeedback());
            }
            if ((report_subset = (report = this.getReport()) & 0x7000000) != 0) {
                jmsMsg._setJMSIBMReportExceptionFromInt(report_subset);
            }
            if ((report_subset = report & 0xE00000) != 0) {
                jmsMsg._setJMSIBMReportExpirationFromInt(report_subset);
            }
            if ((report_subset = report & 0x700) != 0) {
                jmsMsg._setJMSIBMReportCOAFromInt(report_subset);
            }
            if ((report_subset = report & 0x3800) != 0) {
                jmsMsg._setJMSIBMReportCODFromInt(report_subset);
            }
            if ((report_subset = report & 1) != 0) {
                jmsMsg._setJMSIBMReportPANFromInt(report_subset);
            }
            if ((report_subset = report & 2) != 0) {
                jmsMsg._setJMSIBMReportNANFromInt(report_subset);
            }
            if ((report_subset = report & 0x40) != 0) {
                jmsMsg._setJMSIBMPassCorrelIDFromInt(report_subset);
            }
            if ((report_subset = report & 0x80) != 0) {
                jmsMsg._setJMSIBMReportMsgIDFromInt(report_subset);
            }
            if ((report_subset = report & 0x8000000) != 0) {
                jmsMsg._setJMSIBMReportDiscardFromInt(report_subset);
            }
            if ((this.getMessageFlags() & 0x10) != 0) {
                jmsMsg._setJMSIBMLastMsgInGroupFromBool(true);
            }
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "setHeaderFromMQMD_on_Receive(JMSMessage,String)", e);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "setHeaderFromMQMD_on_Receive(JMSMessage,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "setHeaderFromMQMD_on_Receive(JMSMessage,String)");
        }
    }

    protected void write(JMSMessage jmsMsg, boolean rfhReq, int characterSet, ProviderDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "write(JMSMessage,boolean,int,ProviderDestination)", new Object[]{jmsMsg, rfhReq, new Integer(characterSet), destination});
        }
        try {
            jmsMsg.setJMSRedelivered(false);
            jmsMsg._setJMSXObjectProperty("JMSXDeliveryCount", ZERO);
            this.writeMQMD(jmsMsg);
            if (rfhReq) {
                this.writeRFH2(jmsMsg, characterSet);
            } else {
                this.setCharacterSet(characterSet);
            }
            this.overrideHeaderFromMQMDProps(destination, jmsMsg);
            byte[] body = jmsMsg._exportBody(this.getEncoding(), MQJMSMessage.getCharacterSetString(characterSet, this.getEncoding()));
            if (body != null) {
                this.appendByteArray(body);
            }
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "write(JMSMessage,boolean,int,ProviderDestination)", ex, 1);
            }
            String exString = ConfigEnvironment.getErrorMessage("MQJMS1065");
            JMSException jmsEx = new JMSException(exString);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "write(JMSMessage,boolean,int,ProviderDestination)", jmsEx, 1);
            }
            throw jmsEx;
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "write(JMSMessage,boolean,int,ProviderDestination)", e, 2);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "write(JMSMessage,boolean,int,ProviderDestination)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "write(JMSMessage,boolean,int,ProviderDestination)");
        }
    }

    private void writeMQMD(JMSMessage jmsMsg) throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", new Object[]{jmsMsg});
        }
        try {
            this.setPriority(jmsMsg.getJMSPriority());
            this.setMessageId(MQ_NONE);
            byte[] cidBytes = jmsMsg.getJMSCorrelationIDAsBytes();
            if (cidBytes != null) {
                this.setCorrelationId(cidBytes);
            } else {
                String cidString = jmsMsg.getJMSCorrelationID();
                if (cidString == null) {
                    this.setCorrelationId(MQ_NONE);
                } else {
                    try {
                        this.setCorrelationId(cidString.getBytes(RFH_CHAR_SET_STRING));
                    }
                    catch (UnsupportedEncodingException uee) {
                        if (Trace.isOn) {
                            Trace.catchBlock((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", uee, 1);
                        }
                        int key = 1022;
                        String exString = MQSession.jmsStrings.getErrorMessage(key);
                        JMSException jmsEx = new JMSException(exString, MQSession.jmsStrings.getNativeKey(key));
                        jmsEx.setLinkedException((Exception)uee);
                        if (Trace.isOn) {
                            Trace.throwing((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", jmsEx, 1);
                        }
                        throw jmsEx;
                    }
                }
            }
            int deliveryMode = jmsMsg.getJMSDeliveryMode();
            if (deliveryMode == 1) {
                this.setPersistence(0);
            } else if (deliveryMode == 2) {
                this.setPersistence(1);
            } else if (deliveryMode == 2) {
                this.setPersistence(0);
            } else {
                String exString = ConfigEnvironment.getErrorMessage("MQJMS1042");
                JMSException traceRet1 = new JMSException(exString);
                if (Trace.isOn) {
                    Trace.throwing((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", traceRet1, 2);
                }
                throw traceRet1;
            }
            if (jmsMsg instanceof JMSTextMessage || jmsMsg instanceof JMSStreamMessage || jmsMsg instanceof JMSMapMessage) {
                this.setFormat("MQSTR   ");
            } else {
                this.setFormat("        ");
            }
            long timeToLive = jmsMsg._getTimeToLive();
            if (timeToLive == 0L) {
                this.setExpiry(-1);
            } else if (timeToLive < 214748364700L) {
                this.setExpiry((int)((timeToLive + 100L) / 100L));
            } else {
                this.setExpiry(-1);
            }
            String replyTo = jmsMsg.getJMSReplyToAsString();
            this.resetReplyToQueueName();
            this.resetReplyToQueueManagerName();
            if (replyTo != null) {
                WMQDestinationURIParser jmsReplyToParser = new WMQDestinationURIParser();
                jmsReplyToParser.setUri(replyTo);
                if (jmsReplyToParser.getDomain() == 1) {
                    String qMgrName;
                    String qName = jmsReplyToParser.getDestinationName();
                    if (qName != null) {
                        this.setReplyToQueueName(qName);
                    }
                    if ((qMgrName = jmsReplyToParser.getQmName()) != null) {
                        this.setReplyToQueueManagerName(qMgrName);
                    }
                    this.setMessageType(1);
                } else {
                    this.setMessageType(8);
                }
            } else {
                this.setMessageType(8);
            }
            Enumeration propNames = jmsMsg.getPropertyNames();
            this.setReport(0);
            this.setFeedback(0);
            this.setGroupId(MQ_NONE);
            this.setMessageSequenceNumber(1);
            this.setOffset(0);
            this.setMessageFlags(0);
            this.setOriginalLength(-1);
            String dest = jmsMsg.getJMSDestinationAsString();
            boolean isQueue = dest.startsWith("queue://");
            while (propNames.hasMoreElements()) {
                String name = (String)propNames.nextElement();
                if (!name.startsWith("JMS")) continue;
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "Processing property " + name, null);
                }
                if (isQueue && name.equals("JMSXGroupID")) {
                    String jmsxGroupId = jmsMsg.getStringProperty("JMSXGroupID");
                    if (jmsxGroupId == null) continue;
                    if (jmsxGroupId.startsWith("ID:")) {
                        this.setGroupId(jmsMsg._stringToId(jmsxGroupId));
                    } else {
                        this.setGroupId(jmsxGroupId.getBytes(RFH_CHAR_SET_STRING));
                    }
                    this.setMessageFlags(this.getMessageFlags() | 8);
                    continue;
                }
                if (isQueue && name.equals("JMSXGroupSeq")) {
                    int jmsxGroupSeq;
                    block57: {
                        jmsxGroupSeq = 0;
                        try {
                            jmsxGroupSeq = jmsMsg.getIntProperty("JMSXGroupSeq");
                        }
                        catch (Exception jmsEx) {
                            if (Trace.isOn) {
                                Trace.catchBlock((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", jmsEx, 2);
                            }
                            if (!Trace.isOn) break block57;
                            Trace.traceData((Object)this, "Invalid value passed to JMSXGroupSeq " + jmsEx, null);
                        }
                    }
                    if (jmsxGroupSeq <= 0) continue;
                    this.setMessageSequenceNumber(jmsMsg._getJMSXGroupSeqAsInt());
                    this.setMessageFlags(this.getMessageFlags() | 8);
                    continue;
                }
                if (!name.startsWith("JMS_IBM_")) continue;
                if (name.equals("JMS_IBM_Format")) {
                    this.setFormat(jmsMsg.getStringProperty("JMS_IBM_Format"));
                    continue;
                }
                if (name.equals("JMS_IBM_MsgType")) {
                    this.setMessageType(jmsMsg._getJMSIBMMsgTypeAsInt());
                    continue;
                }
                if (name.equals("JMS_IBM_Feedback")) {
                    this.setFeedback(jmsMsg._getJMSIBMFeedbackAsInt());
                    continue;
                }
                if (name.equals("JMS_IBM_Report_Exception")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportExceptionAsInt() & 0x7000000);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_Expiration")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportExpirationAsInt() & 0xE00000);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_COA")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportCOAAsInt() & 0x700);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_COD")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportCODAsInt() & 0x3800);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_PAN")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportPANAsInt() & 1);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_NAN")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportNANAsInt() & 2);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_Pass_Msg_ID")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportMsgIDAsInt() & 0x80);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_Pass_Correl_ID")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMPassCorrelIDAsInt() & 0x40);
                    continue;
                }
                if (name.equals("JMS_IBM_Report_Discard_Msg")) {
                    this.setReport(this.getReport() | jmsMsg._getJMSIBMReportDiscardAsInt() & 0x8000000);
                    continue;
                }
                if (!name.equals("JMS_IBM_Last_Msg_In_Group") || !isQueue || !jmsMsg._getJMSIBMLastMsgInGroupAsBool()) continue;
                this.setMessageFlags(this.getMessageFlags() | 0x10);
            }
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", ex, 3);
            }
            JMSException jmsEx = ConfigEnvironment.newException("MQJMS1059");
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", jmsEx, 3);
            }
            throw jmsEx;
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", e, 4);
            }
            JMSException jmsEx = ConfigEnvironment.newException("MQJMS1016");
            jmsEx.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "writeMQMD(JMSMessage)", jmsEx, 4);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "writeMQMD(JMSMessage)");
        }
    }

    protected void writeRFH(String Directive, JMSMessage jmsMsg, boolean RFH2req, int bodyCharacterSet, ProviderDestination destination) throws JMSException, IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "writeRFH(String,JMSMessage,boolean,int,ProviderDestination)", new Object[]{Directive, jmsMsg, RFH2req, new Integer(bodyCharacterSet), destination});
        }
        try {
            String PaddedNVPairs = Directive + BLANK_STRING15;
            int NVPairsLength = PaddedNVPairs.length() / 16 * 16;
            String NameValueString = PaddedNVPairs.substring(0, NVPairsLength);
            int encoding = this.getEncoding();
            int cset = this.getCharacterSet();
            String ccsidStr = MQJMSMessage.getCharacterSetString(cset, encoding);
            this.appendByteArray(MQRFH_STRUC_ID.getBytes(ccsidStr));
            this.appendInt(1, encoding);
            this.appendInt(32 + NVPairsLength, encoding);
            this.appendInt(encoding, encoding);
            if (bodyCharacterSet == 0 || bodyCharacterSet == -2) {
                bodyCharacterSet = cset;
            }
            if (RFH2req) {
                this.appendInt(cset, encoding);
                this.appendByteArray(MQFMT_RF_HEADER_2.getBytes(ccsidStr));
            } else {
                this.appendInt(bodyCharacterSet, encoding);
                if (jmsMsg != null && (jmsMsg instanceof JMSTextMessage || jmsMsg instanceof JMSStreamMessage || jmsMsg instanceof JMSMapMessage)) {
                    this.appendByteArray("MQSTR   ".getBytes(ccsidStr));
                } else {
                    this.appendByteArray("        ".getBytes(ccsidStr));
                }
                this.setFormat(MQFMT_RF_HEADER_1);
            }
            this.appendInt(0, encoding);
            this.appendByteArray(NameValueString.getBytes(ccsidStr));
            this.write(jmsMsg, RFH2req, bodyCharacterSet, destination);
        }
        catch (MQException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "writeRFH(String,JMSMessage,boolean,int,ProviderDestination)", e);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)((Object)e));
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "writeRFH(String,JMSMessage,boolean,int,ProviderDestination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "writeRFH(String,JMSMessage,boolean,int,ProviderDestination)");
        }
    }

    private int reverseInt(int integer) {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "reverseInt(int)", new Object[]{new Integer(integer)});
        }
        int regetni = 0;
        regetni = (integer >> 24 & 0xFF) << 0 | (integer >> 16 & 0xFF) << 8 | (integer >> 8 & 0xFF) << 16 | (integer >> 0 & 0xFF) << 24;
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "reverseInt(int)", new Integer(regetni));
        }
        return regetni;
    }

    protected byte[] buildCacheableRFH(String directive, int bodyCharacterSet, int enc) throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "buildCacheableRFH(String,int,int)", new Object[]{directive, new Integer(bodyCharacterSet), new Integer(enc)});
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            String PaddedNVPairs = directive + BLANK_STRING15;
            int NVPairsLength = PaddedNVPairs.length() / 16 * 16;
            String NameValueString = PaddedNVPairs.substring(0, NVPairsLength);
            int version = 1;
            int length = 32 + NVPairsLength;
            int encoding = this.getEncoding();
            int cset = this.getCharacterSet();
            int flags = 0;
            String ccsidStr = MQJMSMessage.getCharacterSetString(cset, encoding);
            if ((enc & 0xF) == 2) {
                version = this.reverseInt(version);
                length = this.reverseInt(length);
                encoding = this.reverseInt(encoding);
                cset = this.reverseInt(cset);
                flags = this.reverseInt(flags);
            }
            dos.write(MQRFH_STRUC_ID.getBytes(ccsidStr));
            dos.writeInt(version);
            dos.writeInt(length);
            dos.writeInt(encoding);
            if (bodyCharacterSet == 0 || bodyCharacterSet == -2) {
                bodyCharacterSet = this.getCharacterSet();
            }
            dos.writeInt(cset);
            dos.write(MQFMT_RF_HEADER_2.getBytes(ccsidStr));
            dos.writeInt(0);
            dos.write(NameValueString.getBytes(ccsidStr));
            dos.flush();
            byte[] traceRet1 = baos.toByteArray();
            if (Trace.isOn) {
                Trace.exit((Object)this, CLASSNAME, "buildCacheableRFH(String,int,int)", traceRet1);
            }
            return traceRet1;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "buildCacheableRFH(String,int,int)", e);
            }
            JMSException je = new JMSException("MQJMS1000");
            je.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "buildCacheableRFH(String,int,int)", je);
            }
            throw je;
        }
    }

    private final void insertIntIntoByteArray(int i, byte[] array, int off, int encoding) {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "insertIntIntoByteArray(int,byte [ ],int,int)", new Object[]{new Integer(i), array, new Integer(off), new Integer(encoding)});
        }
        switch (encoding & 0xF) {
            case 0: 
            case 1: {
                array[off + 0] = (byte)(i >>> 24 & 0xFF);
                array[off + 1] = (byte)(i >>> 16 & 0xFF);
                array[off + 2] = (byte)(i >>> 8 & 0xFF);
                array[off + 3] = (byte)(i >>> 0 & 0xFF);
                break;
            }
            case 2: {
                array[off + 3] = (byte)(i >>> 24 & 0xFF);
                array[off + 2] = (byte)(i >>> 16 & 0xFF);
                array[off + 1] = (byte)(i >>> 8 & 0xFF);
                array[off + 0] = (byte)(i >>> 0 & 0xFF);
                break;
            }
            default: {
                if (!Trace.isOn) break;
                Trace.traceData((Object)this, "Invalid encoding in insertIntIntoByteArray: " + (encoding & 0xF), null);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "insertIntIntoByteArray(int,byte [ ],int,int)");
        }
    }

    private void writeRFH2(JMSMessage jmsMsg, int bodyCharacterSet) throws JMSException, IOException, MQException {
        int mqextLength;
        int mqextPad;
        byte[] mqextBytes;
        int pscLength;
        int pscPad;
        byte[] pscBytes;
        int usrLength;
        int usrPad;
        byte[] usrBytes;
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "writeRFH2(JMSMessage,int)", new Object[]{jmsMsg, new Integer(bodyCharacterSet)});
        }
        byte[] mcdBytes = jmsMsg._getMcdFolder().getBytes(RFH_CHAR_SET_STRING);
        int mcdPad = 3 - (mcdBytes.length - 1) % 4;
        int mcdLength = mcdBytes.length + mcdPad;
        byte[] jmsBytes = jmsMsg._getJmsFolder(this.persistenceFromMD).getBytes(RFH_CHAR_SET_STRING);
        int jmsPad = 3 - (jmsBytes.length - 1) % 4;
        int jmsLength = jmsBytes.length + jmsPad;
        int rfhLength = 44 + mcdLength + jmsLength;
        String rfhString = jmsMsg._getUsrFolder();
        if (rfhString.equals("<usr></usr>")) {
            usrBytes = null;
            usrPad = 0;
            usrLength = 0;
        } else {
            usrBytes = rfhString.getBytes(RFH_CHAR_SET_STRING);
            usrPad = 3 - (usrBytes.length - 1) % 4;
            usrLength = usrBytes.length + usrPad;
            rfhLength += usrLength;
            rfhLength += 4;
        }
        rfhString = jmsMsg._getPscFolder();
        if (rfhString.equals("<psc></psc>")) {
            pscBytes = null;
            pscPad = 0;
            pscLength = 0;
        } else {
            pscBytes = rfhString.getBytes(RFH_CHAR_SET_STRING);
            pscPad = 3 - (pscBytes.length - 1) % 4;
            pscLength = pscBytes.length + pscPad;
            rfhLength += pscLength;
            rfhLength += 4;
        }
        rfhString = jmsMsg._getMQExtFolder();
        if (rfhString == null) {
            mqextBytes = null;
            mqextPad = 0;
            mqextLength = 0;
        } else {
            mqextBytes = rfhString.getBytes(RFH_CHAR_SET_STRING);
            mqextPad = 3 - (mqextBytes.length - 1) % 4;
            mqextLength = mqextBytes.length + mqextPad;
            rfhLength += mqextLength;
            rfhLength += 4;
        }
        if (this.cachedFixedRFH2 == null) {
            this.cachedRFH2Length = rfhLength;
            this.cachedRFH2Encoding = this.getEncoding();
            this.cachedRFH2CharSet = bodyCharacterSet;
            this.cachedRFH2Format = this.getFormat();
            int off = 0;
            this.cachedFixedRFH2 = new byte[36];
            this.insertStrIntoByteArray(MQRFH_STRUC_ID, 4, this.cachedFixedRFH2, off, this.getCharacterSet(), this.cachedRFH2Encoding);
            this.insertIntIntoByteArray(2, this.cachedFixedRFH2, off += MQRFH_STRUC_ID.length(), this.cachedRFH2Encoding);
            this.insertIntIntoByteArray(this.cachedRFH2Length, this.cachedFixedRFH2, off += 4, this.cachedRFH2Encoding);
            this.insertIntIntoByteArray(this.cachedRFH2Encoding, this.cachedFixedRFH2, off += 4, this.cachedRFH2Encoding);
            this.insertIntIntoByteArray(this.cachedRFH2CharSet, this.cachedFixedRFH2, off += 4, this.cachedRFH2Encoding);
            this.insertStrIntoByteArray(this.cachedRFH2Format, 8, this.cachedFixedRFH2, off += 4, this.getCharacterSet(), this.cachedRFH2Encoding);
            this.insertIntIntoByteArray(0, this.cachedFixedRFH2, off += 8, this.cachedRFH2Encoding);
            this.insertIntIntoByteArray(1208, this.cachedFixedRFH2, off += 4, this.cachedRFH2Encoding);
        } else {
            boolean newEncoding = false;
            if (this.cachedRFH2Encoding != this.getEncoding()) {
                newEncoding = true;
                this.cachedRFH2Encoding = this.getEncoding();
                this.insertIntIntoByteArray(this.cachedRFH2Encoding, this.cachedFixedRFH2, 12, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(1208, this.cachedFixedRFH2, 32, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(2, this.cachedFixedRFH2, 4, this.cachedRFH2Encoding);
            }
            if (newEncoding || this.cachedRFH2Length != rfhLength) {
                this.cachedRFH2Length = rfhLength;
                this.insertIntIntoByteArray(this.cachedRFH2Length, this.cachedFixedRFH2, 8, this.cachedRFH2Encoding);
            }
            if (newEncoding || this.cachedRFH2CharSet != bodyCharacterSet) {
                this.cachedRFH2CharSet = bodyCharacterSet;
                this.insertIntIntoByteArray(this.cachedRFH2CharSet, this.cachedFixedRFH2, 16, this.cachedRFH2Encoding);
            }
            if (!this.cachedRFH2Format.equals(this.getFormat())) {
                this.cachedRFH2Format = this.getFormat();
                this.insertStrIntoByteArray(this.cachedRFH2Format, 8, this.cachedFixedRFH2, 20, this.getCharacterSet(), this.cachedRFH2Encoding);
            }
        }
        this.setFormat(MQFMT_RF_HEADER_2);
        this.appendByteArray(this.cachedFixedRFH2);
        if (pscBytes != null) {
            this.appendInt(pscLength, this.getEncoding());
            this.appendByteArray(pscBytes);
            this.appendByteArray(SPACES, 0, pscPad);
        }
        this.appendInt(mcdLength, this.getEncoding());
        this.appendByteArray(mcdBytes);
        this.appendByteArray(SPACES, 0, mcdPad);
        this.appendInt(jmsLength, this.getEncoding());
        this.appendByteArray(jmsBytes);
        this.appendByteArray(SPACES, 0, jmsPad);
        if (mqextBytes != null) {
            this.appendInt(mqextLength, this.getEncoding());
            this.appendByteArray(mqextBytes);
            this.appendByteArray(SPACES, 0, mqextPad);
        }
        if (usrBytes != null) {
            this.appendInt(usrLength, this.getEncoding());
            this.appendByteArray(usrBytes);
            this.appendByteArray(SPACES, 0, usrPad);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "writeRFH2(JMSMessage,int)");
        }
    }

    private void insertStrIntoByteArray(String src, int dstLen, byte[] dst, int offset, int ccsid, int enc) throws JMSException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "insertStrIntoByteArray(String,int,byte [ ],int,int,int)", new Object[]{src, new Integer(dstLen), dst, new Integer(offset), new Integer(ccsid), new Integer(enc)});
        }
        try {
            String ccsidStr = MQJMSMessage.getCharacterSetString(ccsid, enc);
            int lenCopied = 0;
            if (src != null) {
                byte[] b = src.getBytes(ccsidStr);
                System.arraycopy(b, 0, dst, offset, b.length);
                lenCopied = b.length;
            } else {
                lenCopied = 0;
            }
            if (dstLen > lenCopied) {
                byte[] spaceByte = " ".getBytes(ccsidStr);
                for (int j = lenCopied; j < dstLen; ++j) {
                    dst[offset + j] = spaceByte[0];
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, CLASSNAME, "insertStrIntoByteArray(String,int,byte [ ],int,int,int)", e);
            }
            JMSException jmsEx = ConfigEnvironment.newException("MQJMS1016");
            jmsEx.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing((Object)this, CLASSNAME, "insertStrIntoByteArray(String,int,byte [ ],int,int,int)", jmsEx);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "insertStrIntoByteArray(String,int,byte [ ],int,int,int)");
        }
    }

    protected static int getCCSID(String charSet) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getCCSID(String)", new Object[]{charSet});
        }
        try {
            int retVal = 0;
            Integer ccsid = (Integer)ccsidTable.get(charSet);
            if (ccsid != null) {
                retVal = ccsid;
            } else {
                if (charSet.startsWith("Cp")) {
                    charSet = charSet.substring(2);
                } else {
                    JmqiCodepage tempCp;
                    if (Trace.isOn) {
                        Trace.traceData(CLASSNAME, "Attempting to get from jmqi: " + charSet, null);
                    }
                    if ((tempCp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (String)charSet)) != null) {
                        retVal = tempCp.ccsid;
                    }
                }
                if (retVal == 0) {
                    retVal = Integer.parseInt(charSet);
                }
                if (retVal < 0) {
                    if (Trace.isOn) {
                        Trace.exit(CLASSNAME, "getCCSID(String)", new Integer(0), 1);
                    }
                    return 0;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "Mapped " + charSet + " -> " + retVal, null);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getCCSID(String)", new Integer(retVal), 2);
            }
            return retVal;
        }
        catch (NumberFormatException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(CLASSNAME, "getCCSID(String)", ex);
            }
            if (Trace.isOn) {
                Trace.traceData(CLASSNAME, "got a number format exception, returning 0", null);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getCCSID(String)", new Integer(0), 3);
            }
            return 0;
        }
    }

    protected void setPersistenceFromMD(boolean x) {
        if (Trace.isOn) {
            Trace.data((Object)this, CLASSNAME, "setPersistenceFromMD(boolean)", "setter", x);
        }
        this.persistenceFromMD = x;
    }

    private void setMQMDPropsFromHeader(ProviderDestination destination, JMSMessage message) throws JMSException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "setMQMDPropsFromHeader(ProviderDestination,JMSMessage)", new Object[]{destination, message});
        }
        if (destination != null && destination.getBooleanProperty("mdReadEnabled")) {
            int report = this.getReport();
            message.setIntProperty("JMS_IBM_MQMD_Report", report);
            int msgType = this.getMessageType();
            message.setIntProperty("JMS_IBM_MQMD_MsgType", msgType);
            int expiry = this.getExpiry();
            message.setIntProperty("JMS_IBM_MQMD_Expiry", expiry);
            int feedback = this.getFeedback();
            message.setIntProperty("JMS_IBM_MQMD_Feedback", feedback);
            int encoding = this.getEncoding();
            message.setIntProperty("JMS_IBM_MQMD_Encoding", encoding);
            int codedCharSetId = this.getCharacterSet();
            message.setIntProperty("JMS_IBM_MQMD_CodedCharSetId", codedCharSetId);
            String format = this.getFormat();
            message.setStringProperty("JMS_IBM_MQMD_Format", format);
            int priority = this.getPriority();
            message.setIntProperty("JMS_IBM_MQMD_Priority", priority);
            int persistence = this.getPersistence();
            message.setIntProperty("JMS_IBM_MQMD_Persistence", persistence);
            byte[] msgId = this.getMessageId();
            message.setObjectProperty("JMS_IBM_MQMD_MsgId", msgId);
            byte[] correlId = this.getCorrelationId();
            message.setObjectProperty("JMS_IBM_MQMD_CorrelId", correlId);
            int backoutCount = this.getBackoutCount();
            message.setIntProperty("JMS_IBM_MQMD_BackoutCount", backoutCount);
            String replyToQ = this.getReplyToQueueName();
            message.setStringProperty("JMS_IBM_MQMD_ReplyToQ", replyToQ);
            String replyToQMgr = this.getReplyToQueueManagerName();
            message.setStringProperty("JMS_IBM_MQMD_ReplyToQMgr", replyToQMgr);
            String userIdentifier = this.getUserId();
            message.setStringProperty("JMS_IBM_MQMD_UserIdentifier", userIdentifier);
            byte[] accountingToken = this.getAccountingToken();
            message.setObjectProperty("JMS_IBM_MQMD_AccountingToken", accountingToken);
            String applIdentityData = this.getApplicationIdData();
            message.setStringProperty("JMS_IBM_MQMD_ApplIdentityData", applIdentityData);
            int putApplType = this.getPutApplicationType();
            message.setIntProperty("JMS_IBM_MQMD_PutApplType", putApplType);
            String putApplName = this.getPutApplicationName();
            message.setStringProperty("JMS_IBM_MQMD_PutApplName", putApplName);
            String putDate = this.getPutDate();
            message.setStringProperty("JMS_IBM_MQMD_PutDate", putDate);
            String putTime = this.getPutTime();
            message.setStringProperty("JMS_IBM_MQMD_PutTime", putTime);
            String applOriginData = this.getApplicationOriginData();
            message.setStringProperty("JMS_IBM_MQMD_ApplOriginData", applOriginData);
            byte[] groupId = this.getGroupId();
            message.setObjectProperty("JMS_IBM_MQMD_GroupId", groupId);
            int msgSeqNumber = this.getMessageSequenceNumber();
            message.setIntProperty("JMS_IBM_MQMD_MsgSeqNumber", msgSeqNumber);
            int offset = this.getOffset();
            message.setIntProperty("JMS_IBM_MQMD_Offset", offset);
            int msgFlags = this.getMessageFlags();
            message.setIntProperty("JMS_IBM_MQMD_MsgFlags", msgFlags);
            int originalLength = this.getOriginalLength();
            message.setIntProperty("JMS_IBM_MQMD_OriginalLength", originalLength);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "setMQMDPropsFromHeader(ProviderDestination,JMSMessage)");
        }
    }

    private void overrideHeaderFromMQMDProps(ProviderDestination destination, ProviderMessage message) throws JMSException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, CLASSNAME, "overrideHeaderFromMQMDProps(ProviderDestination,ProviderMessage)", new Object[]{destination, message});
        }
        if (destination != null && destination.getBooleanProperty("mdWriteEnabled")) {
            byte[] safeValue;
            int value;
            boolean mqmdV2required = false;
            if (message.propertyExists("JMS_IBM_MQMD_Report")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Report");
                this.setReport(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgType")) {
                value = message.getIntProperty("JMS_IBM_MQMD_MsgType");
                this.setMessageType(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Expiry")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Expiry");
                this.setExpiry(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Feedback")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Feedback");
                this.setFeedback(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Encoding")) {
                value = message.getIntProperty("JMS_IBM_MQMD_Encoding");
                this.setEncoding(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_CodedCharSetId")) {
                value = message.getIntProperty("JMS_IBM_MQMD_CodedCharSetId");
                this.setCharacterSet(value);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Format")) {
                String value2 = message.getStringProperty("JMS_IBM_MQMD_Format");
                this.setFormat(value2);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Priority")) {
                int value3 = message.getIntProperty("JMS_IBM_MQMD_Priority");
                this.setPriority(value3);
            }
            if (message.propertyExists("JMS_IBM_MQMD_Persistence")) {
                int value4 = message.getIntProperty("JMS_IBM_MQMD_Persistence");
                this.setPersistence(value4);
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgId")) {
                Object value5 = message.getObjectProperty("JMS_IBM_MQMD_MsgId");
                safeValue = MQJMSMessage.objectAsByteArray("JMS_IBM_MQMD_MsgId", value5);
                this.setMessageId(safeValue);
            }
            if (message.propertyExists("JMS_IBM_MQMD_CorrelId")) {
                Object value6 = message.getObjectProperty("JMS_IBM_MQMD_CorrelId");
                safeValue = MQJMSMessage.objectAsByteArray("JMS_IBM_MQMD_CorrelId", value6);
                this.setCorrelationId(safeValue);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ReplyToQ")) {
                String value7 = message.getStringProperty("JMS_IBM_MQMD_ReplyToQ");
                this.setReplyToQueueName(value7);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ReplyToQMgr")) {
                String value8 = message.getStringProperty("JMS_IBM_MQMD_ReplyToQMgr");
                this.setReplyToQueueManagerName(value8);
            }
            if (message.propertyExists("JMS_IBM_MQMD_UserIdentifier")) {
                String value9 = message.getStringProperty("JMS_IBM_MQMD_UserIdentifier");
                this.setUserId(value9);
            }
            if (message.propertyExists("JMS_IBM_MQMD_AccountingToken")) {
                Object value10 = message.getObjectProperty("JMS_IBM_MQMD_AccountingToken");
                safeValue = MQJMSMessage.objectAsByteArray("JMS_IBM_MQMD_AccountingToken", value10);
                this.setAccountingToken(safeValue);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ApplIdentityData")) {
                String value11 = message.getStringProperty("JMS_IBM_MQMD_ApplIdentityData");
                this.setApplicationIdData(value11);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutApplType")) {
                int value12 = message.getIntProperty("JMS_IBM_MQMD_PutApplType");
                this.setPutApplicationType(value12);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutApplName")) {
                String value13 = message.getStringProperty("JMS_IBM_MQMD_PutApplName");
                this.setPutApplicationName(value13);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutDate")) {
                String value14 = message.getStringProperty("JMS_IBM_MQMD_PutDate");
                this.setPutDate(value14);
            }
            if (message.propertyExists("JMS_IBM_MQMD_PutTime")) {
                String value15 = message.getStringProperty("JMS_IBM_MQMD_PutTime");
                this.setPutTime(value15);
            }
            if (message.propertyExists("JMS_IBM_MQMD_ApplOriginData")) {
                String value16 = message.getStringProperty("JMS_IBM_MQMD_ApplOriginData");
                this.setApplicationOriginData(value16);
            }
            if (message.propertyExists("JMS_IBM_MQMD_GroupId")) {
                Object value17 = message.getObjectProperty("JMS_IBM_MQMD_GroupId");
                safeValue = MQJMSMessage.objectAsByteArray("JMS_IBM_MQMD_GroupId", value17);
                this.setGroupId(safeValue);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgSeqNumber")) {
                int value18 = message.getIntProperty("JMS_IBM_MQMD_MsgSeqNumber");
                this.setMessageSequenceNumber(value18);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_Offset")) {
                int value19 = message.getIntProperty("JMS_IBM_MQMD_Offset");
                this.setOffset(value19);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_MsgFlags")) {
                int value20 = message.getIntProperty("JMS_IBM_MQMD_MsgFlags");
                this.setMessageFlags(value20);
                mqmdV2required = true;
            }
            if (message.propertyExists("JMS_IBM_MQMD_OriginalLength")) {
                int value21 = message.getIntProperty("JMS_IBM_MQMD_OriginalLength");
                this.setOriginalLength(value21);
                mqmdV2required = true;
            }
            if (this.getVersion() == 1 && mqmdV2required) {
                this.setVersion(2);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, CLASSNAME, "overrideHeaderFromMQMDProps(ProviderDestination,ProviderMessage)");
        }
    }

    private static byte[] objectAsByteArray(String propName, Object object) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "objectAsByteArray(String,Object)", new Object[]{propName, object});
        }
        byte[] result = null;
        if (!(object instanceof byte[])) {
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_PROPERTY", propName);
            inserts.put("XMSC_INSERT_VALUE", object);
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSCMQ1006", inserts));
            if (Trace.isOn) {
                Trace.throwing(CLASSNAME, "objectAsByteArray(String,Object)", je);
            }
            throw je;
        }
        result = (byte[])object;
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "objectAsByteArray(String,Object)", result);
        }
        return result;
    }

    static {
        if (Trace.isOn) {
            Trace.data(CLASSNAME, "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQJMSMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.56.1.13 13/01/09 16:32:47");
        }
        SPACES = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        ZERO = new Integer(0);
        MQ_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        defaultReplyToStyle = 1;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "static()");
        }
        ccsidTable = new Hashtable(13);
        ccsidTable.put("JIS", new Integer(2022));
        ccsidTable.put("EUCJIS", new Integer(954));
        ccsidTable.put("SJIS", new Integer(932));
        ccsidTable.put("KSC5601", new Integer(5601));
        ccsidTable.put(RFH_CHAR_SET_STRING, new Integer(1208));
        ccsidTable.put("UTF-8", new Integer(1208));
        ccsidTable.put("UnicodeLittle", new Integer(1200));
        ccsidTable.put("UnicodeBig", new Integer(1200));
        ccsidTable.put("UnicodeBigUnmarked", new Integer(1200));
        ccsidTable.put("GB18030", new Integer(5488));
        ccsidTable.put("ISO8859_1", new Integer(819));
        ccsidTable.put("ISO8859-1", new Integer(819));
        ccsidTable.put("ISO-8859-1", new Integer(819));
        ccsidTable.put("IBM-500", new Integer(500));
        String overrideReplyToStyle = PropertyStore.getStringProperty("com.ibm.mq.jms.replyToStyle");
        defaultReplyToStyle = overrideReplyToStyle != null ? (overrideReplyToStyle.equalsIgnoreCase("MQMD") ? 1 : (overrideReplyToStyle.equalsIgnoreCase("RFH2") ? 2 : 1)) : 1;
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "static()");
        }
    }
}

