/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.disthub2.impl.matching.MatchTarget;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderConnectionBrowser;
import com.ibm.msg.client.provider.ProviderMessageReferenceHandler;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageReference;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageSelector;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueAgent;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class MQConnectionBrowser
extends MatchTarget
implements ProviderConnectionBrowser {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int matchTargetCount;
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQConnectionBrowser.java, jmscc.wmq.v6, k701, k701-112-140304 1.32.1.2 09/12/14 14:57:00";
    private MQQueueAgent agent;
    private MQConnection connection;
    private boolean correlIdAsIdentity = true;
    private WMQDestination dest;
    private boolean isDurable = false;
    private JMSException jmsException;
    private MQMessageSelector messageSelector = new MQMessageSelector();
    private String mqQueueName;
    private MQSubscription mqsub = null;
    private ProviderMessageReferenceHandler mrh;
    private boolean pubSub = false;
    private boolean qAgentActive = false;
    private Object qaLock = new Object();
    private int quantityHint;
    ReceiverFlag receiveFlag = new ReceiverFlag();

    protected MQConnectionBrowser(MQConnection conn, WMQDestination dest, String selectorString, ProviderMessageReferenceHandler mrh, int quantityHint) throws JMSException {
        super(4, "JMSND:browser" + Integer.toString(++matchTargetCount));
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "<init>(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int)", new Object[]{conn, dest, selectorString, mrh, new Integer(quantityHint)});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Already returned from parent constructor.", null);
        }
        this.MQConnectionBrowserInit(conn, dest, selectorString, mrh, quantityHint, null);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "<init>(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int)");
        }
    }

    protected MQConnectionBrowser(MQConnection conn, WMQDestination dest, String selectorString, ProviderMessageReferenceHandler mrh, int quantityHint, String name) throws JMSException {
        super(4, "JMS:" + name);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "<init>(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", new Object[]{conn, dest, selectorString, mrh, new Integer(quantityHint), name});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Already passed to parent constructor.", null);
        }
        this.MQConnectionBrowserInit(conn, dest, selectorString, mrh, quantityHint, name);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "<init>(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateQueueAgent() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "activateQueueAgent()");
        }
        try {
            boolean act = false;
            Object object = this.qaLock;
            synchronized (object) {
                if (!this.qAgentActive) {
                    act = true;
                    this.qAgentActive = true;
                }
            }
            if (act) {
                this.agent.activate(this.connection);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "activateQueueAgent()", je);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Leaving via Exception", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "activateQueueAgent()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "activateQueueAgent()");
        }
    }

    private void checkException() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "checkException()");
        }
        if (this.jmsException != null) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "checkException()", this.jmsException);
            }
            throw this.jmsException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "checkException()");
        }
    }

    public void close(boolean closingFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)", new Object[]{closingFromConnection});
        }
        try {
            this.deactivateQueueAgent();
            this.connection.removeBrowser(this);
            try {
                if (this.agent != null) {
                    this.agent.removeBrowser(this);
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)", je, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "MQQueueAgentThread produced exception", null);
                    if (this.jmsException != null) {
                        // empty if block
                    }
                }
                this.jmsException = je;
            }
            if (this.pubSub) {
                try {
                    this.mqsub.close();
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)", je, 1);
                    }
                    throw je;
                }
            }
            this.mrh.endDeliver();
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)", je, 3);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "close(boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateQueueAgent() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deactivateQueueAgent()");
        }
        boolean act = false;
        Object object = this.qaLock;
        synchronized (object) {
            if (this.qAgentActive) {
                act = true;
                this.qAgentActive = false;
            }
        }
        if (act) {
            this.agent.deactivate();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deactivateQueueAgent()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deliver(MQMessageReference message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", new Object[]{message});
        }
        boolean result = false;
        try {
            MQConnectionBrowser mQConnectionBrowser = this;
            synchronized (mQConnectionBrowser) {
                if (null == this.mrh && Trace.isOn) {
                    Trace.traceData(this, "MRH is null!", null);
                }
                try {
                    this.mrh.handleMessageReference(message);
                }
                catch (JMSException jmse) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", jmse, 1);
                    }
                }
                catch (RuntimeException re) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", re, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Caught RuntimeException from MessageReferenceHandler: " + re, null);
                        Trace.traceData(this, "Not throwing exception. ProviderMessage should be redelivered after timeout", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", re);
                    }
                    throw re;
                }
            }
            result = true;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", result, 1);
            }
            return result;
        }
        catch (RuntimeException re) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", re, 3);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "deliver(MQMessageReference)", result, 2);
            }
            return result;
        }
    }

    protected void endDeliver() {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "endDeliver()");
            }
            try {
                this.mrh.endDeliver();
            }
            catch (JMSException jmse) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "endDeliver()", jmse);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "endDeliver()");
        }
    }

    protected MQConnection getConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getConnection()", "getter", this.connection);
        }
        return this.connection;
    }

    protected byte[] getCorrelId() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getCorrelId()");
        }
        if (this.mqsub != null) {
            byte[] traceRet1 = this.mqsub.getCorrelationId();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getCorrelId()", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getCorrelId()", null, 2);
        }
        return null;
    }

    protected JMSException getException() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getException()", "getter", (Object)this.jmsException);
        }
        return this.jmsException;
    }

    protected MQMessageSelector getMessageSelector() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getMessageSelector()", "getter", this.messageSelector);
        }
        return this.messageSelector;
    }

    protected int getQuantityHint() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getQuantityHint()", "getter", new Integer(this.quantityHint));
        }
        return this.quantityHint;
    }

    protected String getSelectorString() {
        String traceRet1 = this.messageSelector.getSelector();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "getSelectorString()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected boolean isPubSub() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "isPubSub()", "getter", this.pubSub);
        }
        return this.pubSub;
    }

    private void MQConnectionBrowserInit(MQConnection conn, WMQDestination dest, String newSelectorString, ProviderMessageReferenceHandler mrh, int quantityHint, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", new Object[]{conn, dest, newSelectorString, mrh, new Integer(quantityHint), name});
        }
        String qatVersionProperty = "com.ibm.mq.jms.tuning.QATVersion";
        PropertyStore.register(qatVersionProperty, "");
        String qatVersion = PropertyStore.getStringProperty(qatVersionProperty);
        if (qatVersion != "" && !qatVersion.equals("1") && !qatVersion.equals("2")) {
            if (Trace.isOn) {
                Trace.traceData(this, "Invalid value set for QATVersion", null);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1006", "QATVersion", qatVersion);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 1);
            }
            throw je;
        }
        try {
            if (conn == null || dest == null || mrh == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "null parameter passed to ConnectionBrowser constructor", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1093", this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 2);
                }
                throw je;
            }
            try {
                if (newSelectorString != null) {
                    this.messageSelector.setSelector(newSelectorString);
                }
            }
            catch (SyntaxException se) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", se, 1);
                }
                String key = "MQJMS0004";
                String msg = ConfigEnvironment.getErrorMessage(key);
                InvalidSelectorException je = new InvalidSelectorException(msg, key);
                je.setLinkedException((Exception)se);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", (Throwable)je, 3);
                }
                throw je;
            }
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "Sanity test 1. (quantityHint)", null);
                }
                if (quantityHint < 0 || quantityHint > 2) {
                    JMSException traceRet3 = ConfigEnvironment.newException("MQJMS1094");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", traceRet3, 4);
                    }
                    throw traceRet3;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "sanity test 1. passed", null);
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 2);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 5);
                }
                throw je;
            }
            try {
                this.connection = conn;
                this.dest = dest;
                this.mrh = mrh;
                this.quantityHint = quantityHint;
                if (dest.isTopic()) {
                    this.mqQueueName = this.pubSubSetup(dest, this.messageSelector.getSelector(), name);
                    if (Trace.isOn) {
                        Trace.traceData(this, "Topic-based browser using queue '" + this.mqQueueName + "'", null);
                    }
                } else {
                    this.mqQueueName = dest.getName();
                    this.correlIdAsIdentity = false;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Queue-based consumer using queue '" + this.mqQueueName + "'", null);
                    }
                }
                this.agent = MQQueueAgent.getQueueAgent(this.connection, dest, this.mqQueueName, this.correlIdAsIdentity);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 6);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)", je, 7);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "MQConnectionBrowserInit(MQConnection,WMQDestination,String,ProviderMessageReferenceHandler,int,String)");
        }
    }

    private String pubSubSetup(WMQDestination topic, String selector, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "pubSubSetup(WMQDestination,String,String)", new Object[]{topic, selector, name});
        }
        MQSession mqs = null;
        try {
            this.pubSub = true;
            boolean sharedQ = true;
            MQConnection conn = this.connection;
            MQSubscriptionEngine mqse = conn.getSubscriptionEngine();
            String subQName = null;
            if (name == null) {
                subQName = MQSubscriptionEngine.validateQueueName(conn.getBrkCCSubQueue(), 0);
                if (Trace.isOn) {
                    Trace.traceData(this, "Non-durable Browser on '" + subQName + "'", null);
                }
            } else {
                subQName = MQSubscriptionEngine.validateQueueName(topic.getStringProperty("brokerCCDurSubQueue"), 1);
                if (Trace.isOn) {
                    Trace.traceData(this, "Durable Browser on '" + subQName + "'", null);
                }
            }
            if (subQName.endsWith("*")) {
                sharedQ = false;
                this.correlIdAsIdentity = false;
            } else {
                sharedQ = true;
                this.correlIdAsIdentity = true;
            }
            if (name == null) {
                this.isDurable = false;
                mqs = this.connection.getCBBrokerSession();
                this.mqsub = mqse.openSubscription(mqs, topic, selector, false, sharedQ, subQName);
            } else {
                this.isDurable = true;
                mqs = this.connection.getCBBrokerSession();
                this.mqsub = mqse.openDurableSubscription(mqs, topic, selector, false, sharedQ, subQName, name);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Topic-based browser using queue '" + this.mqsub.getQueueName() + "'", null);
                Trace.traceData(this, "This queue is" + (!sharedQ ? " NOT" : "") + " SHARED", null);
                Trace.traceData(this, "CorrelId '" + Utils.bytesToHex(this.mqsub.getCorrelationId()) + "'", null);
                Trace.traceData(this, "The subscription is " + (!this.isDurable ? "NON-" : "") + "DURABLE", null);
            }
            String traceRet1 = this.mqsub.getQueueName();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "pubSubSetup(WMQDestination,String,String)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            block19: {
                try {
                    if (je.getErrorCode() == "MQJMS3023") {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Already subscribed. Closing session as this will not be reused.", null);
                        }
                        mqs.close(false);
                    }
                }
                catch (Exception e) {
                    if (!Trace.isOn) break block19;
                    Trace.traceData(this, "Exception closing session, rethrowing to ensure reconnection thread ends" + e.toString(), null);
                }
            }
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "pubSubSetup(WMQDestination,String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "pubSubSetup(WMQDestination,String,String)", je);
            }
            throw je;
        }
    }

    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "start()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "start()");
        }
    }

    public void startInternal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "startInternal()");
        }
        this.jmsException = null;
        if (this.connection.getMessageRetention() == 1) {
            this.agent.addBrowser(this, true);
        } else {
            this.agent.addBrowser(this, false);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "startInternal()");
        }
    }

    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "stop()");
        }
        try {
            this.agent.removeBrowser(this);
            this.checkException();
            this.endDeliver();
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "stop()", je);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Leaving via Exception", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "stop()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "stop()");
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderConnection = " + this.connection, null);
                Trace.traceData(this, "ProviderDestination = " + this.dest, null);
                Trace.traceData(this, "Selector = " + this.messageSelector.getSelector(), null);
                Trace.traceData(this, "Quantity = " + this.quantityHint, null);
            }
            buff.append("ProviderConnection to '");
            buff.append((null == this.connection.qmgrName ? "null" : this.connection.qmgrName) + "'\n");
            buff.append("ProviderDestination = '");
            buff.append(this.dest.toURI() + "'\n");
            buff.append("Selector    = '");
            buff.append(this.messageSelector.getSelector() + "'\n");
            buff.append("Quantity    =  " + this.quantityHint);
            String traceRet1 = buff.toString();
            return traceRet1;
        }
        catch (Exception e) {
            String traceRet2 = buff.toString();
            return traceRet2;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQConnectionBrowser", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQConnectionBrowser.java, jmscc.wmq.v6, k701, k701-112-140304  1.32.1.2 09/12/14 14:57:00");
        }
        matchTargetCount = 0;
    }

    class ReceiverFlag {
        boolean receiving = false;

        ReceiverFlag() {
        }
    }
}

