/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.util.Hashtable;
import javax.jms.JMSException;

public class MQBrokerSubscriptionList {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQBrokerSubscriptionList.java, jmscc.wmq.v6, k701, k701-112-140304 1.17.1.2 09/12/14 14:56:51";
    private static String CLSNAME;
    private static Hashtable openSubscriptions;

    public MQBrokerSubscriptionList() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "<init>()");
        }
        if (openSubscriptions == null) {
            if (Trace.isOn) {
                Trace.traceData(CLSNAME, "creating new Hashtable", null);
            }
            openSubscriptions = new Hashtable();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "<init>()");
        }
    }

    public synchronized boolean getSubscription(String fullName, MQSession mqs) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "getSubscription(String,MQSession)", new Object[]{fullName, mqs});
        }
        try {
            if (openSubscriptions.containsKey(fullName)) {
                JMSException je = ConfigEnvironment.newException("MQJMS3023");
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "subscription " + fullName + " already in use", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "getSubscription(String,MQSession)", je, 1);
                }
                throw je;
            }
            openSubscriptions.put(fullName, mqs);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "getSubscription(String,MQSession)", true);
            }
            return true;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "getSubscription(String,MQSession)", e);
            }
            JMSException traceRet1 = (JMSException)((Object)e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "getSubscription(String,MQSession)", traceRet1, 2);
            }
            throw traceRet1;
        }
    }

    public synchronized boolean removeSubscription(String fullName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "removeSubscription(String)", new Object[]{fullName});
        }
        if (!openSubscriptions.containsKey(fullName)) {
            JMSException je = new JMSException("MQJMS3051");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "removeSubscription(String)", je);
            }
            throw je;
        }
        openSubscriptions.remove(fullName);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "removeSubscription(String)", true);
        }
        return true;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQBrokerSubscriptionList.java, jmscc.wmq.v6, k701, k701-112-140304  1.17.1.2 09/12/14 14:56:51");
        }
        CLSNAME = "MQBrokerSubscriptionList";
    }
}

