/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.WMQCommonUtils;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.jms.internal.BrokerConnectionInfo;
import com.ibm.msg.client.wmq.v6.jms.internal.Cleanup;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionList;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscription;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSubscriptionEngine;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.IOException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

class MQBrokerSubscriptionEngine
extends MQSubscriptionEngine {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQBrokerSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304 1.53.1.3 12/09/20 12:37:38";
    private int WSClone = 0;
    private static MQBrokerSubscriptionList localSubscriptions;
    private int cleanupLevel = 0;
    private int SLEEPTIME = 3000;
    private static final int CLEANUP_CANCEL_DEFERRED = 1;
    private static final int CLEANUP_CANCEL_REGISTER = 2;
    private static final int CLEANUP_CANCEL_SUBSCRIBE = 4;
    private static final int CLEANUP_LEAVE_ONLY = 8;
    private static final int CLEANUP_PURGE_QUEUE = 16;
    private MQMsg2 durableSubscriptionMessage;

    public MQBrokerSubscriptionEngine(MQConnection connection, String qmName) throws JMSException {
        super(connection);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "<init>(MQConnection,String)", new Object[]{connection, qmName});
        }
        this.WSClone = connection.getIntProperty("XMSC_WMQ_CLONE_SUPPORT");
        if (localSubscriptions == null && this.WSClone == 1) {
            localSubscriptions = new MQBrokerSubscriptionList();
        }
        Cleanup cleanup = new Cleanup();
        cleanup.setCleanupLevel(connection.getIntProperty("XMSC_WMQ_CLEANUP_LEVEL"));
        this.cleanupLevel = cleanup.getCleanupLevel();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "<init>(MQConnection,String)");
        }
    }

    public MQSubscription openSubscription(MQSession mqs, WMQDestination topic, String selector, boolean noLocal, boolean sharedQueue, String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", new Object[]{mqs, topic, selector, noLocal, sharedQueue, queueName});
        }
        MQBrokerSubscription subscription = null;
        MQManagedObject subscriberQueue = null;
        byte[] correlationID = null;
        byte[] deferredMessageId = null;
        String escapedClientID = WMQCommonUtils.escapeString(this.getMQConnection().getClientID());
        int regOpts = 65536;
        MQMsg2 jmsMessage = new MQMsg2();
        MQBrokerMessage brokerResponse = null;
        JmqiEnvironment jmqiEnv = MQSESSION.getJmqiEnv();
        Pint cleanupAction = jmqiEnv.newPint(0);
        int fiqBehaviour = 1;
        if (topic != null) {
            fiqBehaviour = topic.getIntProperty("failIfQuiesce");
        } else if (mqs != null) {
            fiqBehaviour = mqs.getFailIfQuiesce();
        }
        try {
            if (sharedQueue) {
                regOpts |= 1;
            }
            subscription = new MQBrokerSubscription(this, mqs, false, sharedQueue, mqs.getQMName(), escapedClientID, null, topic, selector, noLocal, queueName, null, null);
            subscriberQueue = this.openSubscriberQueue(mqs, queueName, sharedQueue, false, fiqBehaviour);
            subscription.setSubscriberQueue((MQQueue)subscriberQueue);
            subscription.setQueueName(((MQQueue)subscriberQueue).name);
            jmsMessage.setMessageType(1);
            jmsMessage.setReport(0);
            MQPutMessageOptions pmo = new MQPutMessageOptions(true);
            if (sharedQueue) {
                pmo.options += 128;
            }
            if (fiqBehaviour == 1) {
                pmo.options |= 0x2000;
            }
            correlationID = this.setDeferredMessage(subscription, "DeregSub", regOpts, jmsMessage, pmo);
            deferredMessageId = jmsMessage.getMessageId();
            if (Trace.isOn) {
                Trace.traceData(this, "Put deferred message, correID:", (Object)correlationID);
            }
            try {
                jmsMessage = new MQMsg2();
                subscription.setCorrelationId(correlationID);
                if (sharedQueue) {
                    jmsMessage.setCorrelationId(correlationID);
                    regOpts |= 1;
                }
                jmsMessage.setMessageType(1);
                jmsMessage.setReport(0);
                this.sendBrokerMessage(subscription, "RegSub", regOpts, jmsMessage, null);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 1);
                }
                cleanupAction.x &= 0xFFFFFFFB;
                cleanupAction.x |= 1;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 1);
                }
                throw je;
            }
            try {
                if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Receiving RFH1 ProviderMessage from broker", null);
                    }
                    brokerResponse = new RFH1BrokerMessageImpl();
                    brokerResponse = this.getBrokerResponse(mqs, jmsMessage, true);
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Receiving RFH2 ProviderMessage from broker", null);
                    }
                    brokerResponse = new RFH2BrokerMessageImpl();
                    brokerResponse = this.getBrokerResponse(mqs, jmsMessage, true);
                }
                int reason = 0;
                String reasonText = null;
                BrokerCommandFailedException bcfe = null;
                switch (Integer.parseInt(brokerResponse.get("MQPSCompCode"))) {
                    case 1: {
                        cleanupAction.x |= 4;
                        cleanupAction.x |= 1;
                        reason = Integer.parseInt(brokerResponse.get("MQPSReason"));
                        reasonText = brokerResponse.get("MQPSReasonText");
                        bcfe = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, "MQRCCF" + Integer.toString(reason));
                        bcfe.setReason(reason);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)bcfe), 2);
                        }
                        throw bcfe;
                    }
                    case 2: {
                        cleanupAction.x &= 0xFFFFFFFB;
                        cleanupAction.x |= 1;
                        reason = Integer.parseInt(brokerResponse.get("MQPSReason"));
                        reasonText = brokerResponse.get("MQPSReasonText");
                        bcfe = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, "MQRCCF" + Integer.toString(reason));
                        bcfe.setReason(reason);
                        if (reason == 2035) {
                            bcfe.setUserId(brokerResponse.get("MQPSUserId"));
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)bcfe), 3);
                        }
                        throw bcfe;
                    }
                    case 0: {
                        if (Trace.isOn) {
                            Trace.traceData(this, "non-durable RegSub command processed ok", null);
                        }
                        cleanupAction.x &= 0xFFFFFFFB;
                        cleanupAction.x &= 0xFFFFFFFE;
                        break;
                    }
                    default: {
                        cleanupAction.x |= 4;
                        cleanupAction.x |= 1;
                        if (Trace.isOn) {
                            Trace.traceData(this, "unrecognized completion code: " + brokerResponse.get("MQPSCompCode"), null);
                        }
                        String msg = ConfigEnvironment.getErrorMessage("MQJMS1087");
                        bcfe = new BrokerCommandFailedException(msg, "MQRCCF" + brokerResponse.get("MQPSCompCode"));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)bcfe), 4);
                        }
                        throw bcfe;
                    }
                }
            }
            catch (NoBrokerResponseException nbre) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)nbre), 2);
                }
                cleanupAction.x |= 4;
                cleanupAction.x |= 1;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)nbre), 5);
                }
                throw nbre;
            }
            subscription.setDeferredMsgId(deferredMessageId);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 3);
            }
            if ((cleanupAction.x & 4) != 0) {
                regOpts = 1;
                jmsMessage.clearMessageData();
                this.sendBrokerMessage(subscription, "DeregSub", regOpts, jmsMessage, null);
            }
            if ((cleanupAction.x & 1) != 0) {
                this.cancelDeferredMessage(mqs, deferredMessageId);
            }
            if (subscriberQueue != null && subscriberQueue.isOpen()) {
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "deleting subscription queue", null);
                    }
                    if (!sharedQueue) {
                        ((MQQueue)subscriberQueue).closeOptions = 2;
                    }
                    ((MQQueue)subscriberQueue).close();
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", e, 4);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "queue delete failed", null);
                    }
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS2000");
                    BrokerCommandFailedException bcfe = new BrokerCommandFailedException(msg, "MQJMS2000");
                    bcfe.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", (Throwable)((Object)bcfe), 6);
                    }
                    throw bcfe;
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", je, 7);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openSubscription(MQSession,WMQDestination,String,boolean,boolean,String)", subscription);
        }
        return subscription;
    }

    public void closeSubscription(MQSubscription sub) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", new Object[]{sub});
        }
        int regOpts = 0;
        MQMsg2 jmsMessage = new MQMsg2();
        MQQueue subscriberQueue = null;
        try {
            if (!(sub instanceof MQBrokerSubscription)) {
                JMSException je = ConfigEnvironment.newException("MQJMS3049");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", je, 1);
                }
                throw je;
            }
            MQBrokerSubscription subscription = (MQBrokerSubscription)sub;
            if (subscription.isClosed() || subscription.getMQSession() == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "null or closed session. Subscription should already be closed. Returning", null);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", 1);
                }
                return;
            }
            subscriberQueue = subscription.getSubscriberQueue();
            regOpts |= 0x10000;
            jmsMessage.setMessageType(1);
            jmsMessage.setReport(0);
            if (subscription.isSharedQueue()) {
                ++regOpts;
                jmsMessage.setCorrelationId(subscription.getCorrelationId());
            }
            this.sendBrokerMessage(subscription, "DeregSub", regOpts, jmsMessage, null);
            if (subscription.getMQSession() == null && Trace.isOn) {
                Trace.traceData(this, "session is null", null);
            }
            this.cleanupUnconsumedMessages(sub.getMQSession(), sub.isSharedQueue(), sub.getQueueName(), sub.getCorrelationId(), jmsMessage);
            if (sub.isSharedQueue() && subscriberQueue != null && subscriberQueue.isOpen()) {
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "closing subscription queue", null);
                    }
                    subscriberQueue.close();
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", e, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS2000");
                    je.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", je, 2);
                    }
                    throw je;
                }
            }
            this.cancelDeferredMessage(subscription.getMQSession(), subscription.getDeferredMsgId());
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeSubscription(MQSubscription)", 2);
        }
    }

    public MQSubscription openDurableSubscription(MQSession mqs, WMQDestination topic, String selector, boolean noLocal, boolean sharedQueue, String queueName, String subName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", new Object[]{mqs, topic, selector, noLocal, sharedQueue, queueName, subName});
        }
        String fullName = null;
        String escapedQMgrName = null;
        String escapedClientID = null;
        String escapedSubName = null;
        String escapedSelector = null;
        String userSubData = null;
        MQBrokerSubscription testSubscription = null;
        MQBrokerSubscription newSubscription = null;
        MQManagedObject subscriberQueue = null;
        MQBrokerMessage brokerMsg = null;
        MQBrokerMessage brokerResponse = null;
        byte[] correlationId1 = null;
        byte[] correlationId2 = null;
        byte[] deferredMsgId = null;
        JmqiEnvironment jmqiEnv = MQSESSION.getJmqiEnv();
        Pint cleanupAction = jmqiEnv.newPint(0);
        boolean locallySubscribed = false;
        String receivedSubName = null;
        String receivedQmgrName = null;
        String receivedQueueName = null;
        String receivedUserSubData = null;
        String receivedTopic = null;
        this.durableSubscriptionMessage = null;
        if (Trace.isOn && this.WSClone == 1) {
            Trace.traceData(this, "WebSphere clones enabled", null);
        }
        int fiqBehaviour = 1;
        if (topic != null) {
            fiqBehaviour = topic.getIntProperty("failIfQuiesce");
        } else if (mqs != null) {
            fiqBehaviour = mqs.getFailIfQuiesce();
        }
        try {
            String clientID = this.getMQConnection().getClientID();
            if (clientID == null) {
                JMSException je = ConfigEnvironment.newException("MQJMS3024");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 1);
                }
                throw je;
            }
            testSubscription = new MQBrokerSubscription(this, mqs, true, sharedQueue, mqs.getQMName(), clientID, subName, topic, selector, noLocal, queueName, null, null);
            escapedQMgrName = WMQCommonUtils.escapeString(mqs.getQMName());
            escapedClientID = WMQCommonUtils.escapeString(this.getMQConnection().getClientID());
            escapedSubName = WMQCommonUtils.escapeString(subName);
            fullName = "JMS:" + escapedQMgrName + ":" + escapedClientID + ":" + escapedSubName;
            if (Trace.isOn) {
                Trace.traceData(this, "Fullname = '" + fullName + "'", null);
            }
            if (selector != null && !selector.trim().equals("")) {
                escapedSelector = WMQCommonUtils.escapeString(selector);
                userSubData = "sel=\"" + escapedSelector + "\"";
            } else {
                userSubData = "";
            }
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "Setting deferred message", null);
                }
                brokerMsg = this.createProviderMessage(mqs, topic, fullName, testSubscription.getFilter());
                if (Trace.isOn) {
                    Trace.traceData(this, "creating put message options", null);
                }
                MQPutMessageOptions pmo = new MQPutMessageOptions(true);
                MQMsg2 msg = new MQMsg2();
                msg.setMessageType(8);
                pmo.options += 128;
                if (Trace.isOn) {
                    Trace.traceData(this, "setting deferred message", null);
                }
                correlationId1 = this.setDeferredMessage(mqs, brokerMsg, msg, pmo, true, fiqBehaviour);
                deferredMsgId = msg.getMessageId();
                if (Trace.isOn) {
                    Trace.traceData(this, "got correlID", (Object)correlationId1);
                    Trace.traceData(this, "got MessgeID", (Object)deferredMsgId);
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 1);
                }
                cleanupAction.x &= 0xFFFFFFFE;
                cleanupAction.x &= 0xFFFFFFFD;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 2);
                }
                throw je;
            }
            if (this.WSClone == 1) {
                try {
                    localSubscriptions.getSubscription(fullName, mqs);
                    locallySubscribed = true;
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 2);
                    }
                    cleanupAction.x |= 9;
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 3);
                    }
                    throw je;
                }
            }
            if (sharedQueue) {
                brokerResponse = this.sharedQueueRegister(mqs, testSubscription, correlationId1, cleanupAction);
            } else {
                brokerResponse = this.nonSharedQueueRegister(mqs, testSubscription, correlationId1, cleanupAction, queueName, fiqBehaviour);
                queueName = testSubscription.getQueueName();
            }
            String tmp = brokerResponse.get("MQPSCorrelId");
            if (tmp != null) {
                correlationId2 = Utils.hexToBytes(tmp);
            }
            int reason = Integer.parseInt(brokerResponse.get("MQPSReason"));
            String reasonText = brokerResponse.get("MQPSReasonText");
            if (Trace.isOn) {
                Trace.traceData(this, "got response from exclusive register", null);
            }
            switch (Integer.parseInt(brokerResponse.get("MQPSCompCode"))) {
                case 1: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "broker returned with warning", null);
                    }
                    cleanupAction.x |= 9;
                    if (reason == 3157) {
                        if (!sharedQueue) {
                            break;
                        }
                    } else {
                        cleanupAction.x |= 2;
                    }
                    BrokerCommandFailedException je = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, "MQCCF" + Integer.toString(reason));
                    je.setReason(reason);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", (Throwable)((Object)je), 4);
                    }
                    throw je;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "broker command failed", null);
                    }
                    if (this.WSClone == 1 && (reason == 3155 || reason == 3156)) {
                        MQBrokerSubscription traceRet1 = this.webSphereCloneHandling(mqs, topic, sharedQueue, queueName, userSubData, testSubscription, brokerResponse, correlationId1, correlationId2, deferredMsgId, cleanupAction, fiqBehaviour, reason);
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", traceRet1, 1);
                        }
                        return traceRet1;
                    }
                    cleanupAction.x |= 1;
                    reason = Integer.parseInt(brokerResponse.get("MQPSReason"));
                    reasonText = brokerResponse.get("MQPSReasonText");
                    BrokerCommandFailedException bcfe = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, "MQCCF" + Integer.toString(reason));
                    bcfe.setReason(reason);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", (Throwable)((Object)bcfe), 5);
                    }
                    throw bcfe;
                }
                case 0: {
                    break;
                }
                default: {
                    cleanupAction.x |= 0xB;
                    if (Trace.isOn) {
                        Trace.traceData(this, "unrecognized completion code: " + brokerResponse.get("MQPSCompCode"), null);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS1087", "MQRCCF: " + brokerResponse.get("MQPSCompCode"));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 6);
                    }
                    throw je;
                }
            }
            testSubscription.setCorrelationId(correlationId2);
            if (Trace.isOn) {
                try {
                    receivedSubName = brokerResponse.get("MQPSSubName");
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", e, 3);
                    }
                    Trace.traceData(this, "Couldn't get subName", null);
                }
                if (receivedSubName == null) {
                    Trace.traceData(this, "received null subName", null);
                } else {
                    receivedSubName = receivedSubName.trim();
                    Trace.traceData(this, "got subName         = '" + receivedSubName + "'", null);
                }
                Trace.traceData(this, "wanted subName      = '" + fullName + "'", null);
            }
            receivedQmgrName = brokerResponse.get("MQPSQMgrName").trim();
            if (Trace.isOn) {
                Trace.traceData(this, "got QueueManager    = '" + receivedQmgrName + "'", null);
                Trace.traceData(this, "wanted QueueManager = '" + escapedQMgrName + "'", null);
            }
            receivedQueueName = brokerResponse.get("MQPSQName").trim();
            if (Trace.isOn) {
                Trace.traceData(this, "got Queue           = '" + receivedQueueName + "'", null);
                Trace.traceData(this, "wanted Queue        = '" + queueName + "'", null);
            }
            if ((receivedUserSubData = brokerResponse.get("MQPSSubUserData")) == null) {
                receivedUserSubData = "";
            }
            if (Trace.isOn) {
                Trace.traceData(this, "got UserSubData      = '" + receivedUserSubData + "'", null);
                Trace.traceData(this, "wanted UserSubData   = '" + userSubData + "'", null);
            }
            receivedTopic = brokerResponse.get("MQPSTopic").trim();
            if (Trace.isOn) {
                Trace.traceData(this, "got Topic            = '" + receivedTopic + "'", null);
                Trace.traceData(this, "wanted Topic         = '" + topic.getName() + "'", null);
            }
            if (!mqs.getQMName().equals(receivedQmgrName) || !queueName.equals(receivedQueueName)) {
                cleanupAction.x |= 0xB;
                String specified = new String(mqs.getQMName() + ":" + queueName);
                String original = new String(receivedQmgrName + ":" + receivedQueueName);
                JMSException je = ConfigEnvironment.newException("MQJMS3022", specified, original);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 7);
                }
                throw je;
            }
            if (!userSubData.equals(receivedUserSubData) || !this.topicMatches(topic, receivedTopic)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Subscription exists, but requires updating", null);
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "subscription needs to drop and recreate a previous subscription", null);
                    }
                    testSubscription.setDeferredMsgId(deferredMsgId);
                    this.closeDurableSubscription(testSubscription);
                    this.durableUnsubscribe(mqs, subName, true);
                    newSubscription = (MQBrokerSubscription)this.openDurableSubscription(mqs, topic, selector, noLocal, sharedQueue, queueName, subName);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 4);
                    }
                    cleanupAction.x |= 0xB;
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 8);
                    }
                    throw je;
                }
            }
            if (brokerResponse.isOptionSet("MQPSRegOpts", 32)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "subscription needs to recover from previous update error", null);
                }
                try {
                    testSubscription.setDeferredMsgId(deferredMsgId);
                    this.closeDurableSubscription(testSubscription);
                    this.durableUnsubscribe(mqs, subName, true);
                    newSubscription = (MQBrokerSubscription)this.openDurableSubscription(mqs, topic, selector, noLocal, sharedQueue, queueName, subName);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 5);
                    }
                    cleanupAction.x |= 0xB;
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 9);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.traceData(this, "subscription exists as requested.", null);
            }
            newSubscription = testSubscription;
            if (this.WSClone == 1) {
                try {
                    this.migrateToShared(mqs, sharedQueue, newSubscription);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 6);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 10);
                    }
                    throw je;
                }
            }
            if (newSubscription.getSubscriberQueue() == null) {
                newSubscription.setSubscriberQueue(this.openSubscriberQueue(mqs, queueName, sharedQueue, true, fiqBehaviour));
            }
            newSubscription.setDeferredMsgId(deferredMsgId);
            if (Trace.isOn) {
                if (sharedQueue) {
                    Trace.traceData(this, "got subscription with correlID", (Object)newSubscription.getCorrelationId());
                } else {
                    Trace.traceData(this, "got dynamic queue subscrpition", null);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", newSubscription, 2);
            }
            return newSubscription;
        }
        catch (JMSException je) {
            block108: {
                block107: {
                    block106: {
                        block105: {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 7);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "cleaning up after exception", null);
                                if ((cleanupAction.x & 1) != 0) {
                                    Trace.traceData(this, "must cancel deferred message", null);
                                }
                                if ((cleanupAction.x & 2) != 0) {
                                    Trace.traceData(this, "must cancel register broker command", null);
                                }
                                if ((cleanupAction.x & 8) == 0) {
                                    Trace.traceData(this, "closing subscriber queue", null);
                                }
                                if ((cleanupAction.x & 0x10) == 0) {
                                    Trace.traceData(this, "Purging subscriber queue", null);
                                }
                            }
                            if ((cleanupAction.x & 2) != 0) {
                                try {
                                    int regOpts = 524288;
                                    this.durableSubscriptionMessage.clearMessageData();
                                    this.durableSubscriptionMessage.setMessageType(8);
                                    this.sendBrokerMessage(testSubscription, "DeregSub", regOpts, this.durableSubscriptionMessage, null);
                                }
                                catch (JMSException je2) {
                                    if (!Trace.isOn) break block105;
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je2, 8);
                                }
                            }
                        }
                        if ((cleanupAction.x & 1) != 0) {
                            try {
                                this.cancelDeferredMessage(mqs, deferredMsgId);
                            }
                            catch (JMSException je2) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je2, 9);
                                }
                                if (!Trace.isOn) break block106;
                                Trace.traceData(this, "Exception cancelling deferred message", null);
                            }
                        }
                    }
                    if (subscriberQueue != null && subscriberQueue.isOpen() && (cleanupAction.x & 8) == 0) {
                        try {
                            if (Trace.isOn) {
                                Trace.traceData(this, "closing subscription queue", null);
                            }
                            if ((cleanupAction.x & 0x10) != 0) {
                                ((MQQueue)subscriberQueue).closeOptions = 2;
                            }
                            ((MQQueue)subscriberQueue).close();
                        }
                        catch (MQException mqe) {
                            if (!Trace.isOn) break block107;
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", mqe, 10);
                        }
                    }
                }
                if (this.WSClone == 1 && locallySubscribed) {
                    try {
                        localSubscriptions.removeSubscription(fullName);
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", e, 11);
                        }
                        if (!Trace.isOn) break block108;
                        Trace.traceData(this, "error encountered while removing subscription entry from localSubscriptions table", null);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "openDurableSubscription(MQSession,WMQDestination,String,boolean,boolean,String,String)", je, 11);
            }
            throw je;
        }
    }

    private boolean topicMatches(WMQDestination topic, String receivedTopic) {
        String topicName;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "topicMatches(WMQDestination,String)", new Object[]{topic, receivedTopic});
        }
        if ((topicName = topic.getName()).length() != receivedTopic.length()) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "topicMatches(WMQDestination,String)", false, 1);
            }
            return false;
        }
        char[] topicNameCharArray = topicName.toCharArray();
        char[] receivedTopicNameCharArray = receivedTopic.toCharArray();
        for (int i = 0; i < topicNameCharArray.length; ++i) {
            if (topicNameCharArray[i] == receivedTopicNameCharArray[i] || topicNameCharArray[i] == '*' && receivedTopicNameCharArray[i] == '#') continue;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "topicMatches(WMQDestination,String)", false, 2);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "topicMatches(WMQDestination,String)", true, 3);
        }
        return true;
    }

    private MQBrokerMessage sharedQueueRegister(MQSession mqs, MQBrokerSubscription testSubscription, byte[] correlationId1, Pint cleanupAction) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint)", new Object[]{mqs, testSubscription, correlationId1, cleanupAction});
        }
        this.durableSubscriptionMessage = this.registerExclusive(testSubscription, correlationId1, cleanupAction);
        MQBrokerMessage brokerResponse = null;
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "getting broker response", null);
            }
            brokerResponse = this.getBrokerResponse(mqs, this.durableSubscriptionMessage, true);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint)", je);
            }
            cleanupAction.x |= 1;
            if (je instanceof NoBrokerResponseException) {
                cleanupAction.x |= 0xA;
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint)", brokerResponse);
        }
        return brokerResponse;
    }

    private MQBrokerMessage nonSharedQueueRegister(MQSession mqs, MQBrokerSubscription testSubscription, byte[] correlationId1, Pint cleanupAction, String queueName, int fiqBehaviour) throws JMSException, BrokerCommandFailedException {
        MQBrokerMessage brokerResponse;
        block18: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "nonSharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint,String,int)", new Object[]{mqs, testSubscription, correlationId1, cleanupAction, queueName, new Integer(fiqBehaviour)});
            }
            MQQueue subscriberQueue = this.openSubscriberQueue(mqs, queueName, false, true, fiqBehaviour);
            String subscriberQueueName = subscriberQueue.name.trim();
            testSubscription.setSubscriberQueue(subscriberQueue);
            testSubscription.setQueueName(subscriberQueueName);
            if (Trace.isOn) {
                Trace.traceData(this, "opened new dynamic queue: " + subscriberQueueName, null);
            }
            cleanupAction.x |= 0x10;
            this.durableSubscriptionMessage = this.registerExclusive(testSubscription, correlationId1, cleanupAction);
            if (Trace.isOn) {
                Trace.traceData(this, "using dynamic queues. Checking initial broker response", null);
            }
            brokerResponse = null;
            try {
                brokerResponse = this.getBrokerResponse(mqs, this.durableSubscriptionMessage, true);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "nonSharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint,String,int)", je, 1);
                }
                if (je instanceof NoBrokerResponseException) {
                    cleanupAction.x |= 1;
                    cleanupAction.x |= 2;
                    cleanupAction.x |= 8;
                } else {
                    cleanupAction.x |= 1;
                    cleanupAction.x &= 0xFFFFFFFD;
                    cleanupAction.x &= 0xFFFFFFF7;
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "nonSharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint,String,int)", je, 1);
                }
                throw je;
            }
            int reason = Integer.parseInt(brokerResponse.get("MQPSReason"));
            String reasonText = brokerResponse.get("MQPSReasonText");
            if (reason != 0 && (this.WSClone != 1 || reason != 3155 && reason != 3156)) {
                if (Trace.isOn) {
                    Trace.traceData(this, "exclusive register failed", null);
                }
                cleanupAction.x |= 1;
                cleanupAction.x &= 0xFFFFFFFD;
                cleanupAction.x &= 0xFFFFFFF7;
                reason = Integer.parseInt(brokerResponse.get("MQPSReason"));
                reasonText = brokerResponse.get("MQPSReasonText");
                BrokerCommandFailedException bcfe = new BrokerCommandFailedException("Broker command failed: " + reasonText + " Reason code " + reason, "MQCCF" + Integer.toString(reason));
                bcfe.setReason(reason);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "nonSharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint,String,int)", (Throwable)((Object)bcfe), 2);
                }
                throw bcfe;
            }
            String receivedQueueName1 = brokerResponse.get("MQPSQName").trim();
            if (Trace.isOn) {
                Trace.traceData(this, "register succeeded to queue: " + receivedQueueName1, null);
            }
            if (!receivedQueueName1.equals(subscriberQueueName)) {
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "closing subscription queue", null);
                    }
                    subscriberQueue.closeOptions = 2;
                    subscriberQueue.close();
                    testSubscription.setQueueName(receivedQueueName1);
                    subscriberQueue = this.openSubscriberQueue(mqs, receivedQueueName1, false, true, fiqBehaviour);
                    testSubscription.setSubscriberQueue(subscriberQueue);
                }
                catch (MQException mqe) {
                    if (!Trace.isOn) break block18;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "nonSharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint,String,int)", mqe, 2);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "nonSharedQueueRegister(MQSession,MQBrokerSubscription,byte [ ],Pint,String,int)", brokerResponse);
        }
        return brokerResponse;
    }

    private MQMsg2 registerExclusive(MQBrokerSubscription testSubscription, byte[] correlationId1, Pint cleanupAction) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "registerExclusive(MQBrokerSubscription,byte [ ],Pint)", new Object[]{testSubscription, correlationId1, cleanupAction});
        }
        MQMsg2 jmsMessage = null;
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "attempting exclusive register", null);
            }
            int regOpts = 360449;
            testSubscription.setCorrelationId(correlationId1);
            jmsMessage = new MQMsg2();
            jmsMessage.setCorrelationId(correlationId1);
            jmsMessage.setMessageType(1);
            jmsMessage.setReport(0);
            this.sendBrokerMessage(testSubscription, "RegSub", regOpts, jmsMessage, null);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "registerExclusive(MQBrokerSubscription,byte [ ],Pint)", je);
            }
            cleanupAction.x |= 1;
            cleanupAction.x &= 0xFFFFFFFD;
            cleanupAction.x |= 8;
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "registerExclusive(MQBrokerSubscription,byte [ ],Pint)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "registerExclusive(MQBrokerSubscription,byte [ ],Pint)", (Object)jmsMessage);
        }
        return jmsMessage;
    }

    private void migrateToShared(MQSession mqs, boolean sharedQueue, MQBrokerSubscription newSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "migrateToShared(MQSession,boolean,MQBrokerSubscription)", new Object[]{mqs, sharedQueue, newSubscription});
        }
        int regOpts = 196608;
        if (sharedQueue) {
            ++regOpts;
        }
        MQMsg2 jmsMessage = new MQMsg2();
        jmsMessage.setCorrelationId(newSubscription.getCorrelationId());
        jmsMessage.setMessageType(1);
        jmsMessage.setReport(0);
        try {
            this.sendBrokerMessage(newSubscription, "RegSub", regOpts, jmsMessage, null);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "migrateToShared(MQSession,boolean,MQBrokerSubscription)", je);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "error sending migrate to shared subscription message to broker", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "migrateToShared(MQSession,boolean,MQBrokerSubscription)", je, 1);
            }
            throw je;
        }
        MQBrokerMessage brokerResponse = this.getBrokerResponse(mqs, jmsMessage, true);
        int response = Integer.parseInt(brokerResponse.get("MQPSCompCode"));
        int responseReason = Integer.parseInt(brokerResponse.get("MQPSReason"));
        if (response != 0 && (response != 1 || responseReason != 3157)) {
            JMSException je = ConfigEnvironment.newException(brokerResponse.get("MQPSReasonText"));
            if (Trace.isOn) {
                Trace.traceData(this, "migrate to shared broker command failed" + brokerResponse.get("MQPSReasonText"), null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "migrateToShared(MQSession,boolean,MQBrokerSubscription)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "migrateToShared(MQSession,boolean,MQBrokerSubscription)");
        }
    }

    private MQBrokerSubscription webSphereCloneHandling(MQSession mqs, WMQDestination topic, boolean sharedQueue, String queueName, String userSubData, MQBrokerSubscription testSubscription, MQBrokerMessage brokerResponse, byte[] correlationId1, byte[] correlationId2, byte[] deferredMsgId, Pint cleanupAction, int fiqBehaviour, int reason) throws JMSException {
        block25: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", new Object[]{mqs, topic, sharedQueue, queueName, userSubData, testSubscription, brokerResponse, correlationId1, correlationId2, deferredMsgId, cleanupAction, new Integer(fiqBehaviour), new Integer(reason)});
            }
            if (reason == 3155) {
                if (Trace.isOn) {
                    Trace.traceData(this, "subscription already shared by another WebSphere clone", null);
                }
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "subscription exclusively locked. Hopefully, this will change soon", null);
                }
                try {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Sleeping for " + this.SLEEPTIME + " milis", null);
                    }
                    Thread.sleep(this.SLEEPTIME);
                }
                catch (InterruptedException ie) {
                    if (!Trace.isOn) break block25;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", ie, 1);
                }
            }
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Subscription in use by another clone.Re-trying with join shared", null);
        }
        testSubscription.setCorrelationId(correlationId2);
        int regOpts = 229376;
        if (sharedQueue) {
            ++regOpts;
        }
        MQMsg2 jmsMessage1 = new MQMsg2();
        jmsMessage1.setCorrelationId(correlationId1);
        jmsMessage1.setMessageType(1);
        jmsMessage1.setReport(0);
        try {
            this.sendBrokerMessage(testSubscription, "RegSub", regOpts, jmsMessage1, null);
            if (Trace.isOn) {
                Trace.traceData(this, "Receiving RFH2 ProviderMessage from broker", null);
            }
            brokerResponse = this.getBrokerResponse(mqs, jmsMessage1, true);
            int response = Integer.parseInt(brokerResponse.get("MQPSCompCode"));
            int responseReason = Integer.parseInt(brokerResponse.get("MQPSReason"));
            if (response != 0 && (response != 1 || responseReason != 3157)) {
                JMSException je2 = ConfigEnvironment.newException("MQJMS3050");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", je2, 1);
                }
                throw je2;
            }
        }
        catch (JMSException je2) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", je2, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", je2, 2);
            }
            throw je2;
        }
        String receivedSubName1 = brokerResponse.get("MQPSSubName");
        String receivedQmgrName1 = this.safeTrim(brokerResponse.get("MQPSQMgrName"));
        String receivedQueueName1 = this.safeTrim(brokerResponse.get("MQPSQName"));
        String receivedUserSubData1 = brokerResponse.get("MQPSSubUserData");
        if (receivedUserSubData1 == null) {
            receivedUserSubData1 = "";
        }
        String receivedTopic1 = this.safeTrim(brokerResponse.get("MQPSTopic"));
        byte[] correlationId21 = Utils.hexToBytes(brokerResponse.get("MQPSCorrelId"));
        testSubscription.setCorrelationId(correlationId21);
        if (Trace.isOn) {
            Trace.traceData(this, "subscription we are trying to join is:", (Object)receivedSubName1);
            Trace.traceData(this, "Topic:    " + receivedTopic1, null);
            Trace.traceData(this, "SubData:  " + receivedUserSubData1, null);
            Trace.traceData(this, "QMgr:     " + receivedQmgrName1, null);
            Trace.traceData(this, "Queue:    " + receivedQueueName1, null);
            Trace.traceData(this, "CorrelId: " + Utils.bytesToHex(correlationId21), null);
        }
        if (!(mqs.getQMName().equals(receivedQmgrName1) && queueName.equals(receivedQueueName1) && userSubData.equals(receivedUserSubData1) && topic.getName().equals(receivedTopic1))) {
            JMSException je2 = ConfigEnvironment.newException("MQJMS3050");
            if (Trace.isOn) {
                Trace.traceData(this, "subscription already in use by another clone and cannot beupdated", null);
            }
            cleanupAction.x |= 1;
            cleanupAction.x |= 2;
            cleanupAction.x |= 8;
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", je2, 3);
            }
            throw je2;
        }
        MQBrokerSubscription newSubscription = testSubscription;
        if (newSubscription.getSubscriberQueue() == null) {
            newSubscription.setSubscriberQueue(this.openSubscriberQueue(mqs, queueName, sharedQueue, true, fiqBehaviour));
        }
        newSubscription.setDeferredMsgId(deferredMsgId);
        if (Trace.isOn) {
            Trace.traceData(this, "got subscription with correlID", (Object)newSubscription.getCorrelationId());
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "webSphereCloneHandling(MQSession,WMQDestination,boolean,String,String,MQBrokerSubscription,MQBrokerMessage,byte [ ],byte [ ],byte [ ],Pint,int,int)", newSubscription);
        }
        return newSubscription;
    }

    private String safeTrim(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private MQBrokerMessage createProviderMessage(MQSession mqs, WMQDestination topic, String fullName, String filter) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createProviderMessage(MQSession,WMQDestination,String,String)", new Object[]{mqs, topic, fullName, filter});
        }
        MQBrokerMessage brokerMsg = null;
        if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
            if (Trace.isOn) {
                Trace.traceData(this, "Creating RFH1 ProviderMessage", null);
            }
            brokerMsg = new RFH1BrokerMessageImpl();
        } else {
            if (Trace.isOn) {
                Trace.traceData(this, "Creating RFH2 ProviderMessage", null);
            }
            brokerMsg = new RFH2BrokerMessageImpl();
        }
        brokerMsg.set("MQPSCommand", "DeregSub");
        brokerMsg.set("MQPSTopic", topic.getName());
        brokerMsg.setOption("MQPSRegOpts", "LeaveOnly");
        brokerMsg.setOption("MQPSRegOpts", "VariableUserId");
        brokerMsg.setOption("MQPSRegOpts", "FullResp");
        brokerMsg.setOption("MQPSRegOpts", "CorrelAsId");
        brokerMsg.set("MQPSSubIdentity", Utils.bytesToHex(mqs.getSessionName()));
        brokerMsg.set("MQPSSubName", fullName);
        if (filter != null) {
            if (Trace.isOn) {
                Trace.traceData(this, "setting filter to ", (Object)filter);
            }
            brokerMsg.set("MQPSFilter", filter);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createProviderMessage(MQSession,WMQDestination,String,String)", brokerMsg);
        }
        return brokerMsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDurableSubscription(MQSubscription sub) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", new Object[]{sub});
        }
        int regOpts = 0;
        MQMsg2 jmsMessage = new MQMsg2();
        MQQueue subscriberQueue = null;
        try {
            block37: {
                try {
                    try {
                        if (!(sub instanceof MQBrokerSubscription)) {
                            JMSException je = new JMSException("MQJMS3049");
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 1);
                            }
                            throw je;
                        }
                        MQBrokerSubscription subscription = (MQBrokerSubscription)sub;
                        regOpts += 524288;
                        jmsMessage.setMessageType(8);
                        try {
                            this.sendBrokerMessage(subscription, "DeregSub", regOpts, jmsMessage, null);
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 1);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Error sending BrokerMessage: ", null);
                            }
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 2);
                            }
                            throw je;
                        }
                        try {
                            this.cancelDeferredMessage(subscription.getMQSession(), subscription.getDeferredMsgId());
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 2);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Error cancelling deferred MQPUT: ", null);
                            }
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 3);
                            }
                            throw je;
                        }
                        subscriberQueue = subscription.getSubscriberQueue();
                        if (subscriberQueue != null && subscriberQueue.isOpen()) {
                            try {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "closing subscription queue", null);
                                }
                                subscriberQueue.close();
                            }
                            catch (MQException e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", e, 3);
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "queue close failed", null);
                                }
                                JMSException je = ConfigEnvironment.newException("MQJMS2000");
                                je.setLinkedException((Exception)((Object)e));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 4);
                                }
                                throw je;
                            }
                        }
                        Object var9_13 = null;
                        if (!Trace.isOn) break block37;
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 4);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "exception thrown while attempting to close durable subscription", null);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 5);
                        }
                        throw je;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
                    }
                    if (this.WSClone == 1) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "attempting to remove localSubscription entry", null);
                        }
                        localSubscriptions.removeSubscription(((MQBrokerSubscription)sub).getEscapedFullName());
                    }
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
            }
            if (this.WSClone == 1) {
                if (Trace.isOn) {
                    Trace.traceData(this, "attempting to remove localSubscription entry", null);
                }
                localSubscriptions.removeSubscription(((MQBrokerSubscription)sub).getEscapedFullName());
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 5);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)", je, 6);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "closeDurableSubscription(MQSubscription)");
        }
    }

    public void durableUnsubscribe(MQSession mqs, String subName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String)", new Object[]{mqs, subName});
        }
        this.durableUnsubscribe(mqs, subName, false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String)");
        }
    }

    private void durableUnsubscribe(MQSession mqs, String subName, boolean swallowWarning) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", new Object[]{mqs, subName, swallowWarning});
        }
        int regOpts = 0;
        MQMsg2 jmsMessage = new MQMsg2();
        BrokerConnectionInfo brk = mqs.getBrk();
        byte[] defCorrelID = null;
        byte[] defMessageID = null;
        String fullName = null;
        String topicName = null;
        String filter = null;
        String streamName = null;
        MQBrokerMessage brokerMsg = null;
        MQBrokerMessage responseMsg = null;
        boolean sharedQueue = false;
        byte[] correlationId = null;
        String queueName = null;
        boolean invalidSubName = false;
        String unknownTopic = new String("JMS:SYS:Unknown");
        try {
            try {
                try {
                    if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Creating new RFH1 ProviderMessage", null);
                        }
                        brokerMsg = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Creating new RFH2 ProviderMessage", null);
                        }
                        brokerMsg = new RFH2BrokerMessageImpl();
                    }
                    fullName = "JMS:" + WMQCommonUtils.escapeString(mqs.getQMName()) + ":" + WMQCommonUtils.escapeString(this.getMQConnection().getClientID()) + ":" + WMQCommonUtils.escapeString(subName);
                    brokerMsg.set("MQPSCommand", "DeregSub");
                    brokerMsg.set("MQPSSubName", fullName);
                    brokerMsg.set("MQPSSubIdentity", Utils.bytesToHex(mqs.getSessionName()));
                    regOpts = 589824;
                    brokerMsg.setOption("MQPSRegOpts", regOpts);
                    brokerMsg.set("MQPSStreamName", brk.streamQ);
                    if (mqs.getQMName() != null) {
                        brokerMsg.set("MQPSQMgrName", mqs.getQMName());
                    }
                    jmsMessage.setMessageType(8);
                    jmsMessage.setFormat(brokerMsg.getHeaderFormat());
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", e, 1);
                    }
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS3008");
                    JMSException je = new JMSException(msg, "MQJMS3008");
                    je.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 1);
                    }
                    throw je;
                }
                try {
                    defCorrelID = this.setDeferredMessage(mqs, brokerMsg, jmsMessage, null, true, 0);
                    defMessageID = jmsMessage.getMessageId();
                    if (defCorrelID == null && Trace.isOn) {
                        Trace.traceData(this, "Queue manager does not support deferred messages", null);
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Could not send brokerMessage with deferred MQPUT", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 2);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 3);
                }
                throw je;
            }
            try {
                brokerMsg.clear();
                brokerMsg.set("MQPSCommand", "RegSub");
                brokerMsg.set("MQPSSubIdentity", Utils.bytesToHex(mqs.getSessionName()));
                brokerMsg.set("MQPSSubName", fullName);
                brokerMsg.set("MQPSTopic", unknownTopic);
                regOpts = 360448;
                brokerMsg.setOption("MQPSRegOpts", regOpts);
                brokerMsg.set("MQPSStreamName", brk.streamQ);
                if (mqs.getQMName() != null) {
                    brokerMsg.set("MQPSQMgrName", mqs.getQMName());
                }
                jmsMessage = new MQMsg2();
                jmsMessage.setMessageType(1);
                jmsMessage.setReport(0);
                jmsMessage.setFormat(brokerMsg.getHeaderFormat());
                this.sendBrokerMessage(mqs, brokerMsg, jmsMessage, null, true);
                try {
                    if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Receiving RFH1 ProviderMessage from broker", null);
                        }
                        responseMsg = new RFH1BrokerMessageImpl();
                        responseMsg = this.getBrokerResponse(mqs, jmsMessage, false);
                    } else {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Receiving RFH2 ProviderMessage from broker", null);
                        }
                        responseMsg = new RFH2BrokerMessageImpl();
                        responseMsg = this.getBrokerResponse(mqs, jmsMessage, false);
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 4);
                    }
                    if (je instanceof NoBrokerResponseException) {
                        responseMsg = null;
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 4);
                    }
                    throw je;
                }
                int brokerCompCode = Integer.parseInt(responseMsg.get("MQPSCompCode"));
                if (swallowWarning && brokerCompCode == 1) {
                    brokerCompCode = 0;
                }
                String reasonText = "Broker did not respond";
                switch (brokerCompCode) {
                    case 1: {
                        reasonText = responseMsg.get("MQPSReasonText");
                        BrokerCommandFailedException traceRet2 = new BrokerCommandFailedException("Broker Command warning: " + reasonText, "MQCCF" + responseMsg.get("MQPSReason"));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", (Throwable)((Object)traceRet2), 5);
                        }
                        throw traceRet2;
                    }
                    case 2: {
                        reasonText = responseMsg.get("MQPSReasonText");
                        BrokerCommandFailedException traceRet3 = new BrokerCommandFailedException("Broker Command failed: " + reasonText, "MQCCF" + responseMsg.get("MQPSReason"));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", (Throwable)((Object)traceRet3), 6);
                        }
                        throw traceRet3;
                    }
                    case 0: {
                        topicName = responseMsg.get("MQPSTopic");
                        filter = responseMsg.get("MQPSFilter");
                        streamName = responseMsg.get("MQPSStreamName");
                        if (Trace.isOn && null != brk.streamQ && !brk.streamQ.equals(streamName)) {
                            Trace.traceData(this, "This subscription is on stream '" + streamName + "'", null);
                            Trace.traceData(this, "The deferred deregister message we sent uses stream '" + brk.streamQ + "'", null);
                            Trace.traceData(this, "We may not be able to deregister if something goes wrong while we have this subscription", null);
                        }
                        if (null == streamName) {
                            streamName = brk.streamQ;
                        }
                        break;
                    }
                    default: {
                        reasonText = responseMsg.get("MQPSReasonText");
                        String msg = ConfigEnvironment.getErrorMessage("MQJMS3040", reasonText);
                        BrokerCommandFailedException traceRet4 = new BrokerCommandFailedException(msg, "MQJMS3040");
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", (Throwable)((Object)traceRet4), 7);
                        }
                        throw traceRet4;
                    }
                }
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", e, 5);
                }
                BrokerCommandFailedException je = new BrokerCommandFailedException(e.getMessage(), e.getErrorCode());
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", (Throwable)((Object)je), 8);
                }
                throw je;
            }
            try {
                if (topicName.equals(unknownTopic)) {
                    invalidSubName = true;
                }
                sharedQueue = responseMsg.isOptionSet("MQPSRegOpts", 1);
                queueName = responseMsg.get("MQPSQName");
                String tmp = responseMsg.get("MQPSCorrelId");
                if (tmp != null) {
                    correlationId = Utils.hexToBytes(tmp);
                }
                brokerMsg.clear();
                brokerMsg.set("MQPSCommand", "DeregSub");
                brokerMsg.set("MQPSSubIdentity", Utils.bytesToHex(mqs.getSessionName()));
                brokerMsg.set("MQPSSubName", fullName);
                brokerMsg.set("MQPSTopic", topicName);
                regOpts = 65536;
                brokerMsg.setOption("MQPSRegOpts", regOpts);
                brokerMsg.set("MQPSStreamName", streamName);
                if (mqs.getQMName() != null) {
                    brokerMsg.set("MQPSQMgrName", mqs.getQMName());
                }
                if (filter != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setting filter to " + filter, null);
                    }
                    brokerMsg.set("MQPSFilter", filter);
                }
                jmsMessage = new MQMsg2();
                jmsMessage.setMessageType(1);
                jmsMessage.setReport(0);
                jmsMessage.setFormat(brokerMsg.getHeaderFormat());
                this.sendBrokerMessage(mqs, brokerMsg, jmsMessage, null, true);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", e, 6);
                }
                NoBrokerResponseException je = new NoBrokerResponseException(e.getMessage(), e.getErrorCode());
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", (Throwable)((Object)je), 9);
                }
                throw je;
            }
            if (invalidSubName) {
                if (Trace.isOn) {
                    Trace.traceData(this, "No record found for '" + subName + "'", null);
                }
                String key = "MQJMS3018";
                String msg = ConfigEnvironment.getErrorMessage(key, subName);
                InvalidDestinationException ide = new InvalidDestinationException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", (Throwable)ide, 10);
                }
                throw ide;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "About to call cleanup to remove unconsumed messages", null);
            }
            try {
                responseMsg = this.cleanupUnconsumedMessages(mqs, sharedQueue, queueName, correlationId, jmsMessage);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 7);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "exception thrown while attempting to cleanup subscriber queue", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 11);
                }
                throw je;
            }
            try {
                this.cancelDeferredMessage(mqs, defMessageID);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 8);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Exception thrown cancelling deferred deregister message. Ignoring", null);
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 9);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)", je, 12);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "durableUnsubscribe(MQSession,String,boolean)");
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "close()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "close()");
        }
    }

    private byte[] sendBrokerMessageInternal(MQSession mqs, MQBrokerMessage brokerMsg, MQMsg2 jmsMessage, MQPutMessageOptions pmo, boolean deferred, boolean durable, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", new Object[]{mqs, brokerMsg, jmsMessage, pmo, deferred, durable, new Integer(fiqBehaviour)});
        }
        MQQueue brokerQ = null;
        byte[] sessionName = null;
        byte[] correlId = null;
        try {
            BrokerConnectionInfo brk = mqs.getBrk();
            try {
                MQConnection mqc = this.getMQConnection();
                if ("RegSub".equals(brokerMsg.get("MQPSCommand")) && mqc.getBrkOptLevel() > 0) {
                    if (!mqs.persistenceFromMD && !durable) {
                        brokerMsg.setOption("MQPSRegOpts", "NonPers");
                    }
                    if (mqs.acknowledgeMode == 3) {
                        brokerMsg.setOption("MQPSRegOpts", "DupsOK");
                    }
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Exception thrown attempting to set nonPersistent and DupsOk options", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 1);
                }
                throw je;
            }
            try {
                try {
                    if (durable) {
                        sessionName = mqs.getSessionName();
                        brokerMsg.set("MQPSSubIdentity", Utils.bytesToHex(sessionName));
                        brokerMsg.setOption("MQPSRegOpts", "VariableUserId");
                        brokerMsg.set("MQPSStreamName", brk.streamQ);
                    }
                    brokerMsg.writeToMessage(jmsMessage);
                    jmsMessage.setReplyToQueueManagerName("");
                    jmsMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    jmsMessage.setFormat(brokerMsg.getHeaderFormat());
                    jmsMessage.setPersistence(1);
                }
                catch (MQException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", e, 2);
                    }
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS1000");
                    BrokerCommandFailedException je = new BrokerCommandFailedException(msg, e.getErrorCode());
                    je.setLinkedException((Exception)((Object)e));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", (Throwable)((Object)je), 2);
                    }
                    throw je;
                }
                try {
                    int openOptions = 16;
                    MQQueueManager qm = mqs.getQM();
                    if (pmo == null) {
                        pmo = new MQPutMessageOptions();
                    }
                    if (fiqBehaviour == 1) {
                        openOptions |= 0x2000;
                        pmo.options |= 0x2000;
                    }
                    if (deferred) {
                        MQQueueManager spiQm = qm;
                        if (!spiQm.spiSupportsDeferred()) {
                            JMSException je = ConfigEnvironment.newException("MQJMS3047");
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 3);
                            }
                            throw je;
                        }
                        brokerQ = spiQm.accessQueue(brk.controlQ, openOptions, brk.qmName, null, null);
                        brokerQ.spiDeferredPut(jmsMessage, pmo);
                    } else {
                        brokerQ = mqs.getQM().accessQueue(brk.controlQ, openOptions, brk.qmName, null, null);
                        brokerQ.putMsg2(jmsMessage, pmo);
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", mqe, 3);
                    }
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS2008", brk.controlQ);
                    BrokerCommandFailedException je = new BrokerCommandFailedException(msg, "MQJMS2008");
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.traceData(this, "Failed to MQPUT broker command due to: " + (Object)((Object)mqe), null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", (Throwable)((Object)je), 4);
                    }
                    throw je;
                }
                correlId = jmsMessage.getCorrelationId();
                try {
                    brokerQ.close();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", mqe, 4);
                    }
                    String msg = ConfigEnvironment.getErrorMessage("MQJMS2000");
                    BrokerCommandFailedException je = new BrokerCommandFailedException(msg, "MQJMS2000");
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.traceData(this, "Failed to close broker queue", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", (Throwable)((Object)je), 5);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 5);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Failed to put message to broker queue", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 6);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 6);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", je, 7);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,boolean,int)", correlId);
        }
        return correlId;
    }

    private byte[] sendBrokerMessageInternal(MQSubscription subscription, String command, int regOpts, MQMsg2 jmsMessage, MQPutMessageOptions pmo, boolean deferred) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", new Object[]{subscription, command, new Integer(regOpts), jmsMessage, pmo, deferred});
        }
        MQSession mqs = null;
        String selector = null;
        String subUserData = null;
        byte[] correlationID = null;
        String filter = null;
        MQBrokerMessage brokerMessage = null;
        try {
            mqs = subscription.getMQSession();
            BrokerConnectionInfo brk = mqs.getBrk();
            selector = subscription.getSelector();
            subUserData = selector != null && !selector.trim().equals("") ? "sel=\"" + WMQCommonUtils.escapeString(selector) + "\"" : "";
            try {
                if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Creating RFH1 ProviderMessage", null);
                    }
                    brokerMessage = new RFH1BrokerMessageImpl();
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Creating RFH2 ProviderMessage", null);
                    }
                    brokerMessage = new RFH2BrokerMessageImpl();
                }
                brokerMessage.set("MQPSCommand", command);
                brokerMessage.setOption("MQPSRegOpts", regOpts);
                String topicStreamName = subscription.getMQTopic().getStringProperty("XMSC_WMQ_BROKER_PUBQ");
                if (topicStreamName == null || topicStreamName.equals("")) {
                    brokerMessage.set("MQPSStreamName", brk.streamQ);
                } else {
                    brokerMessage.set("MQPSStreamName", topicStreamName);
                }
                brokerMessage.set("MQPSTopic", subscription.getTopic());
                if (null != mqs.getQM() && mqs.getQMName() != null) {
                    brokerMessage.set("MQPSQMgrName", mqs.getQMName());
                }
                brokerMessage.set("MQPSQName", subscription.getQueueName());
                if (subscription.isDurable()) {
                    brokerMessage.set("MQPSSubName", ((MQBrokerSubscription)subscription).getEscapedFullName());
                }
                if (!command.equals("DeregSub")) {
                    brokerMessage.set("MQPSSubUserData", subUserData);
                } else {
                    brokerMessage.unset("MQPSSubUserData");
                }
                filter = subscription.getFilter();
                if (filter != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setting filter to " + filter, null);
                    }
                    brokerMessage.set("MQPSFilter", filter);
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", je, 1);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Error constructing MQBrokerMessage", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", je, 1);
                }
                throw je;
            }
            try {
                if (jmsMessage == null) {
                    jmsMessage = new MQMsg2();
                }
                jmsMessage.setReplyToQueueManagerName("");
                jmsMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                jmsMessage.setFormat(brokerMessage.getHeaderFormat());
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", e, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Error detailing jmsMessage", null);
                }
                String msg = ConfigEnvironment.getErrorMessage("MQJMS1000");
                BrokerCommandFailedException je = new BrokerCommandFailedException(msg, "MQJMS1000");
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", (Throwable)((Object)je), 2);
                }
                throw je;
            }
            int fiqBehaviour = 1;
            if (subscription.getMQTopic() != null) {
                fiqBehaviour = subscription.getMQTopic().getIntProperty("failIfQuiesce");
            } else if (mqs != null) {
                fiqBehaviour = mqs.getFailIfQuiesce();
            }
            try {
                correlationID = this.sendBrokerMessageInternal(mqs, brokerMessage, jmsMessage, pmo, deferred, subscription.isDurable(), fiqBehaviour);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", je, 3);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", je, 3);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", correlationID);
            }
            return correlationID;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessageInternal(MQSubscription,String,int,MQMsg2,MQPutMessageOptions,boolean)", je, 4);
            }
            throw je;
        }
    }

    private byte[] sendBrokerMessage(MQSubscription subscription, String command, int regOpts, MQMsg2 jmsMessage, MQPutMessageOptions pmo) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessage(MQSubscription,String,int,MQMsg2,MQPutMessageOptions)", new Object[]{subscription, command, new Integer(regOpts), jmsMessage, pmo});
        }
        byte[] traceRet1 = this.sendBrokerMessageInternal(subscription, command, regOpts, jmsMessage, pmo, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessage(MQSubscription,String,int,MQMsg2,MQPutMessageOptions)", traceRet1);
        }
        return traceRet1;
    }

    private byte[] sendBrokerMessage(MQSession mqs, MQBrokerMessage brokerMsg, MQMsg2 jmsMessage, MQPutMessageOptions pmo, boolean durable) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessage(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean)", new Object[]{mqs, brokerMsg, jmsMessage, pmo, durable});
        }
        byte[] traceRet1 = this.sendBrokerMessageInternal(mqs, brokerMsg, jmsMessage, pmo, false, durable, mqs.getFailIfQuiesce());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "sendBrokerMessage(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean)", traceRet1);
        }
        return traceRet1;
    }

    private byte[] setDeferredMessage(MQSubscription subscription, String command, int regOptions, MQMsg2 jmsMessage, MQPutMessageOptions pmo) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "setDeferredMessage(MQSubscription,String,int,MQMsg2,MQPutMessageOptions)", new Object[]{subscription, command, new Integer(regOptions), jmsMessage, pmo});
        }
        byte[] deferredCorrelationID = null;
        deferredCorrelationID = this.sendBrokerMessageInternal(subscription, command, regOptions, jmsMessage, pmo, true);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "setDeferredMessage(MQSubscription,String,int,MQMsg2,MQPutMessageOptions)", deferredCorrelationID);
        }
        return deferredCorrelationID;
    }

    private byte[] setDeferredMessage(MQSession mqs, MQBrokerMessage brokerMsg, MQMsg2 jmsMessage, MQPutMessageOptions pmo, boolean durable, int fiqBehaviour) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "setDeferredMessage(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,int)", new Object[]{mqs, brokerMsg, jmsMessage, pmo, durable, new Integer(fiqBehaviour)});
        }
        byte[] deferredCorrelationID = null;
        deferredCorrelationID = this.sendBrokerMessageInternal(mqs, brokerMsg, jmsMessage, pmo, true, durable, fiqBehaviour);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "setDeferredMessage(MQSession,MQBrokerMessage,MQMsg2,MQPutMessageOptions,boolean,int)", deferredCorrelationID);
        }
        return deferredCorrelationID;
    }

    private void cancelDeferredMessage(MQSession mqs, byte[] messageID) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])", new Object[]{mqs, messageID});
        }
        try {
            MQQueueManager qm;
            MQQueueManager spiQm = qm = mqs.getQM();
            if (!spiQm.spiSupportsDeferred()) {
                JMSException je = new JMSException("MQJMS3047");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])", je, 1);
                }
                throw je;
            }
            spiQm.spiCancelDeferred(messageID);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])", je, 1);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])", je, 2);
            }
            throw je;
        }
        catch (MQException me) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])", me, 2);
            }
            BrokerCommandFailedException je = new BrokerCommandFailedException(me.getMessage(), me.getErrorCode());
            je.setLinkedException((Exception)((Object)me));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])", (Throwable)((Object)je), 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cancelDeferredMessage(MQSession,byte [ ])");
        }
    }

    private MQBrokerMessage getBrokerResponse(MQSession mqs, MQMsg2 sentMessage, boolean fullResponseRequested) throws JMSException {
        MQBrokerMessage responseMessage;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2,boolean)", new Object[]{mqs, sentMessage, fullResponseRequested});
        }
        MQMsg2 qResponse = null;
        MQQueue replyQ = null;
        MQGetMessageOptions brokerResponseGmo = null;
        MQBrokerMessage originalBrokerMessage = null;
        try {
            qResponse = new MQMsg2();
            qResponse.setCorrelationId(sentMessage.getMessageId());
            try {
                replyQ = mqs.replyQ == null ? mqs.getResponseQueue() : mqs.replyQ;
                brokerResponseGmo = new MQGetMessageOptions();
                brokerResponseGmo.options = 1;
                brokerResponseGmo.waitInterval = 120000;
                if (this.connection.getFailIfQuiesce() == 1) {
                    brokerResponseGmo.options |= 0x2000;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "setting broker timeout to 120000", null);
                }
                replyQ.getMsg2(qResponse, brokerResponseGmo);
            }
            catch (MQException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2,boolean)", e, 1);
                }
                String key = "MQJMS5053";
                String msg = ConfigEnvironment.getErrorMessage(key);
                NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
                je.setLinkedException((Exception)((Object)e));
                if (Trace.isOn) {
                    Trace.traceData(this, "error getting broker response", null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2,boolean)", (Throwable)((Object)je), 1);
                }
                throw je;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "got broker response", null);
            }
            if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Creating RFH1 ProviderMessage", null);
                }
                responseMessage = new RFH1BrokerMessageImpl();
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "Creating RFH2 ProviderMessage", null);
                }
                responseMessage = new RFH2BrokerMessageImpl();
            }
            responseMessage.initializeFromMessage(qResponse);
            if (fullResponseRequested) {
                if (Trace.isOn) {
                    Trace.traceData(this, "requested full Response. Did we get it?", null);
                }
                if ((responseMessage.get("MQPSTopic") == null || responseMessage.get("MQPSTopic").equals("")) && Integer.parseInt(responseMessage.get("MQPSCompCode")) != 2) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "No full response. Assume that this command failed", null);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Get the original command", null);
                    }
                    if ((originalBrokerMessage = MQBrokerMessage.fromMessage(sentMessage)).get("MQPSCommand").equals("RegSub")) {
                        boolean sharedQueue = originalBrokerMessage.isOptionSet("MQPSRegOpts", "CorrelAsId");
                        this.cleanupUnwantedSubscription(mqs, sentMessage, sharedQueue);
                    }
                    Trace.ffst(this, "getBrokerResponse", "XO00H001", null, NoBrokerResponseException.class);
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2,boolean)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2,boolean)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "getBrokerResponse(MQSession,MQMsg2,boolean)", responseMessage);
        }
        return responseMessage;
    }

    /*
     * Loose catch block
     */
    byte[] createSessionName(MQSession mqs) throws JMSException {
        byte[] messageId;
        block26: {
            MQQueue queue;
            block24: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", new Object[]{mqs});
                }
                messageId = null;
                MQQueueManager qm = mqs.getQM();
                queue = null;
                try {
                    block23: {
                        MQPutMessageOptions pmo;
                        MQMessage tempMsg;
                        block22: {
                            queue = qm.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 8210);
                            tempMsg = new MQMessage();
                            pmo = new MQPutMessageOptions();
                            if (this.connection.getFailIfQuiesce() == 1) {
                                pmo.options |= 0x2000;
                            }
                            pmo.options |= 0x80;
                            try {
                                tempMsg.writeString("sessGen");
                            }
                            catch (IOException ie) {
                                if (!Trace.isOn) break block22;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", ie, 1);
                            }
                        }
                        tempMsg.expiry = 1;
                        tempMsg.persistence = 0;
                        queue.put(tempMsg, pmo);
                        messageId = tempMsg.messageId;
                        try {
                            queue.get(tempMsg);
                        }
                        catch (MQException me) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", me, 2);
                            }
                            if (me.reasonCode == 2033) break block23;
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", me, 1);
                            }
                            throw me;
                        }
                    }
                    Object var9_11 = null;
                    if (!Trace.isOn) break block24;
                }
                catch (Throwable throwable) {
                    block25: {
                        Object var9_12 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)");
                        }
                        if (queue != null) {
                            try {
                                queue.close();
                            }
                            catch (MQException mqe) {
                                if (!Trace.isOn) break block25;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", mqe, 4);
                            }
                        }
                    }
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)");
            }
            if (queue != null) {
                try {
                    queue.close();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", mqe, 4);
                    }
                }
            }
            break block26;
            {
                catch (MQException ex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", ex, 3);
                    }
                    JMSException je = ex.reasonCode == 2085 ? ConfigEnvironment.newException("MQJMS3014", "SYSTEM.JMS.PS.STATUS.QUEUE") : ConfigEnvironment.newException("MQJMS3005", (Object)ex);
                    je.setLinkedException((Exception)((Object)ex));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", je, 2);
                    }
                    throw je;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "createSessionName(MQSession)", messageId);
        }
        return messageId;
    }

    /*
     * Loose catch block
     */
    private MQBrokerMessage cleanupUnconsumedMessages(MQSession mqs, boolean sharedQueue, String queueName, byte[] correlationId, MQMsg2 sentMessage) throws JMSException {
        MQBrokerMessage mQBrokerMessage;
        MQManagedObject reportQueue;
        block70: {
            block69: {
                MQBrokerMessage brokerResponse;
                block68: {
                    MQMsg2 responseMessage;
                    MQGetMessageOptions brokerResponseGmo;
                    int openOptions;
                    block65: {
                        MQBrokerMessage mQBrokerMessage2;
                        block67: {
                            block66: {
                                if (Trace.isOn) {
                                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", new Object[]{mqs, sharedQueue, queueName, correlationId, sentMessage});
                                }
                                int cleanupLevel = this.cleanupLevel;
                                openOptions = 0;
                                reportQueue = null;
                                brokerResponseGmo = null;
                                responseMessage = null;
                                brokerResponse = null;
                                if (cleanupLevel != 0) break block65;
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Cleanup level is NONE; skipping cleanup", null);
                                }
                                if (Trace.isOn) {
                                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", null, 1);
                                }
                                mQBrokerMessage2 = null;
                                Object var17_18 = null;
                                if (!Trace.isOn) break block66;
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)");
                            }
                            try {
                                if (reportQueue != null && reportQueue.isOpen()) {
                                    ((MQQueue)reportQueue).close();
                                }
                            }
                            catch (MQException mqe) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", mqe, 7);
                                }
                                if (!Trace.isOn) break block67;
                                Trace.traceData(this, "exception thrown closing reportQueue. Not much we can do about this though.", null);
                            }
                        }
                        return mQBrokerMessage2;
                    }
                    openOptions = 10;
                    if (this.connection.getFailIfQuiesce() == 1) {
                        openOptions |= 0x2000;
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "opening report queue", null);
                        }
                        reportQueue = mqs.getQM().accessQueue("SYSTEM.JMS.REPORT.QUEUE", openOptions);
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", mqe, 1);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "exception thrown opening report queue", null);
                        }
                        if (mqe.reasonCode == 2042) {
                            if ((openOptions & 2) == 2) {
                                JMSException je = ConfigEnvironment.newException("MQJMS3045", "SYSTEM.JMS.REPORT.QUEUE");
                                je.setLinkedException((Exception)((Object)mqe));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 1);
                                }
                                throw je;
                            }
                            JMSException je = ConfigEnvironment.newException("MQJMS3046", "SYSTEM.JMS.REPORT.QUEUE");
                            je.setLinkedException((Exception)((Object)mqe));
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 2);
                            }
                            throw je;
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.REPORT.QUEUE");
                        je.setLinkedException((Exception)((Object)mqe));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 3);
                        }
                        throw je;
                    }
                    try {
                        brokerResponseGmo = new MQGetMessageOptions();
                        brokerResponseGmo.options = 545;
                        brokerResponseGmo.waitInterval = 120000;
                        if (this.connection.getFailIfQuiesce() == 1) {
                            brokerResponseGmo.options |= 0x2000;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "setting broker timeout to 120000", null);
                        }
                        responseMessage = new MQMsg2();
                        responseMessage.setCorrelationId(sentMessage.getMessageId());
                        if (Trace.isOn) {
                            Trace.traceData(this, "Setting reponse correlationId = " + Utils.bytesToHex(sentMessage.getMessageId()), null);
                        }
                        ((MQQueue)reportQueue).getMsg2(responseMessage, brokerResponseGmo);
                    }
                    catch (MQException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", e, 2);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "exception thrown getting response message from report queue", null);
                        }
                        String key = "MQJMS5053";
                        String msg = ConfigEnvironment.getErrorMessage(key);
                        NoBrokerResponseException je = new NoBrokerResponseException(msg, key);
                        je.setLinkedException((Exception)((Object)e));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", (Throwable)((Object)je), 4);
                        }
                        throw je;
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "got MQ response message, converting to MQBrokerMessage", null);
                        }
                        brokerResponse = MQBrokerMessage.fromMessage(responseMessage);
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "exception thrown while creating MQBrokerMessage", null);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 5);
                        }
                        throw je;
                    }
                    int reasonCode = Integer.parseInt(brokerResponse.get("MQPSCompCode"));
                    if (reasonCode != 0) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "The broker deregister command failed. Abort cleanup and throw exception", null);
                        }
                        String reasonText = brokerResponse.get("MQPSReasonText");
                        JMSException je = new JMSException(reasonText);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 6);
                        }
                        throw je;
                    }
                    try {
                        if (sharedQueue) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "shared queue, calling removeMessages", null);
                            }
                            Cleanup.removeMessages(mqs.getQM(), queueName, correlationId);
                        } else {
                            if (Trace.isOn) {
                                Trace.traceData(this, "dynamic queue, calling removeDynamicQueue", null);
                            }
                            Cleanup.removeDynamicQueue(mqs.getQM(), queueName);
                        }
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 4);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "exception thrown while attempting to clean  subscriber queue", null);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 7);
                        }
                        throw je;
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Removing message", null);
                        }
                        brokerResponseGmo.options = 320;
                        if (this.connection.getFailIfQuiesce() == 1) {
                            brokerResponseGmo.options |= 0x2000;
                        }
                        ((MQQueue)reportQueue).getMsg2(responseMessage, brokerResponseGmo, 1);
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", mqe, 5);
                        }
                        if (mqe.reasonCode == 2079) break block68;
                        String detail = "Couldn't get locked message from queue (" + (Object)((Object)mqe) + ")";
                        JMSException je = ConfigEnvironment.newException("MQJMS1016", detail);
                        je.setLinkedException((Exception)((Object)mqe));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 8);
                        }
                        throw je;
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", brokerResponse, 2);
                }
                mQBrokerMessage = brokerResponse;
                Object var17_19 = null;
                if (!Trace.isOn) break block69;
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)");
            }
            try {
                if (reportQueue != null && reportQueue.isOpen()) {
                    ((MQQueue)reportQueue).close();
                }
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", mqe, 7);
                }
                if (!Trace.isOn) break block70;
                Trace.traceData(this, "exception thrown closing reportQueue. Not much we can do about this though.", null);
            }
        }
        return mQBrokerMessage;
        catch (JMSException je) {
            try {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 6);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", je, 9);
                }
                throw je;
            }
            catch (Throwable throwable) {
                block71: {
                    Object var17_20 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)");
                    }
                    try {
                        if (reportQueue != null && reportQueue.isOpen()) {
                            ((MQQueue)reportQueue).close();
                        }
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnconsumedMessages(MQSession,boolean,String,byte [ ],MQMsg2)", mqe, 7);
                        }
                        if (!Trace.isOn) break block71;
                        Trace.traceData(this, "exception thrown closing reportQueue. Not much we can do about this though.", null);
                    }
                }
                throw throwable;
            }
        }
    }

    private void cleanupUnwantedSubscription(MQSession mqs, MQMsg2 sentMessage, boolean sharedQueue) {
        block33: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", new Object[]{mqs, sentMessage, sharedQueue});
            }
            MQMsg2 jmsMessage = new MQMsg2();
            MQBrokerMessage originalBrokerMessage = null;
            MQBrokerMessage newBrokerMessage = null;
            try {
                block32: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "resetting read position", null);
                    }
                    try {
                        sentMessage.resetReadPosition();
                    }
                    catch (MQException mie) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", mie, 1);
                        }
                        if (!Trace.isOn) break block32;
                        Trace.traceData(this, "error resetting read position", null);
                    }
                }
                originalBrokerMessage = MQBrokerMessage.fromMessage(sentMessage);
                if (this.getMQConnection().getBrkVersion() == 0 || this.getMQConnection().getBrkVersion() == -1) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Composing new RFH1 message to deregister", null);
                    }
                    newBrokerMessage = new RFH1BrokerMessageImpl();
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Composing new RFH2 message to deregister", null);
                    }
                    newBrokerMessage = new RFH2BrokerMessageImpl();
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Setting command to deregister", null);
                }
                newBrokerMessage.set("MQPSCommand", "DeregSub");
                String originalStreamName = originalBrokerMessage.get("MQPSStreamName");
                String originalQMgrName = originalBrokerMessage.get("MQPSQMgrName");
                String originalQName = originalBrokerMessage.get("MQPSQName");
                if (originalStreamName != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting stream name to '" + originalStreamName + "'", null);
                    }
                    newBrokerMessage.set("MQPSStreamName", originalStreamName);
                }
                if (originalQMgrName != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting qMgr name to '" + originalQMgrName + "'", null);
                    }
                    newBrokerMessage.set("MQPSQMgrName", originalQMgrName);
                }
                if (originalQName != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Setting qName to '" + originalQName + "'", null);
                    }
                    newBrokerMessage.set("MQPSQName", originalQName);
                }
                if (Trace.isOn && sharedQueue) {
                    Trace.traceData(this, "Shared queue, setting corelId as Id", null);
                }
                if (sharedQueue) {
                    newBrokerMessage.setOption("MQPSRegOpts", 1);
                }
                newBrokerMessage.setOption("MQPSRegOpts", 64);
                newBrokerMessage.writeToMessage(jmsMessage);
                jmsMessage.setMessageType(1);
                jmsMessage.setReport(0);
                if (sharedQueue) {
                    jmsMessage.setCorrelationId(sentMessage.getCorrelationId());
                }
                try {
                    this.sendBrokerMessage(mqs, newBrokerMessage, jmsMessage, null, false);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", je, 1);
                    }
                    throw je;
                }
                try {
                    this.cleanupUnconsumedMessages(mqs, sharedQueue, originalBrokerMessage.get("MQPSQName"), sentMessage.getCorrelationId(), jmsMessage);
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", je, 3);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "exception thrown dealing with broker response and subscriber queue cleanup", null);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", je, 2);
                    }
                    throw je;
                }
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)", je, 4);
                }
                if (!Trace.isOn) break block33;
                Trace.traceData(this, "Problems encountered attempting to deal with an erroneously created subscription.", null);
                Trace.traceData(this, "Subscription could still exist causing unwanted messages to be delivered", null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "cleanupUnwantedSubscription(MQSession,MQMsg2,boolean)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerSubscriptionEngine", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQBrokerSubscriptionEngine.java, jmscc.wmq.v6, k701, k701-112-140304  1.53.1.3 12/09/20 12:37:38");
        }
    }
}

