/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH1BrokerMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.RFH2BrokerMessageImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;

abstract class MQBrokerMessage {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQBrokerMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.18.1.1 09/08/17 08:08:58";
    private static final String clsName = "MQBrokerMessage";
    public static final String MQPS_COMMAND = "MQPSCommand";
    public static final String MQPS_COMP_CODE = "MQPSCompCode";
    public static final String MQPS_DELETE_OPTIONS = "MQPSDelOpts";
    public static final String MQPS_ERROR_ID = "MQPSErrorId";
    public static final String MQPS_ERROR_POS = "MQPSErrorPos";
    public static final String MQPS_INTEGER_DATA = "MQPSIntData";
    public static final String MQPS_PARAMETER_ID = "MQPSParmId";
    public static final String MQPS_PUBLICATION_OPTIONS = "MQPSPubOpts";
    public static final String MQPS_PUBLISH_TIMESTAMP = "MQPSPubTime";
    public static final String MQPS_Q_MGR_NAME = "MQPSQMgrName";
    public static final String MQPS_Q_NAME = "MQPSQName";
    public static final String MQPS_REASON = "MQPSReason";
    public static final String MQPS_REASON_TEXT = "MQPSReasonText";
    public static final String MQPS_REGISTRATION_OPTIONS = "MQPSRegOpts";
    public static final String MQPS_SEQUENCE_NUMBER = "MQPSSeqNum";
    public static final String MQPS_STREAM_NAME = "MQPSStreamName";
    public static final String MQPS_STRING_DATA = "MQPSStringData";
    public static final String MQPS_TOPIC = "MQPSTopic";
    public static final String MQPS_USER_ID = "MQPSUserId";
    public static final String MQPS_SUBSCRIPTION_IDENTITY = "MQPSSubIdentity";
    public static final String MQPS_SUBSCRIPTION_NAME = "MQPSSubName";
    public static final String MQPS_SUBSCRIPTION_USER_DATA = "MQPSSubUserData";
    public static final String MQPS_CORREL_ID = "MQPSCorrelId";
    public static final String MQPS_FILTER = "MQPSFilter";
    public static final String MQPS_DELETE_PUBLICATION = "DeletePub";
    public static final String MQPS_DEREGISTER_PUBLISHER = "DeregPub";
    public static final String MQPS_DEREGISTER_SUBSCRIBER = "DeregSub";
    public static final String MQPS_PUBLISH = "Publish";
    public static final String MQPS_REGISTER_PUBLISHER = "RegPub";
    public static final String MQPS_REGISTER_SUBSCRIBER = "RegSub";
    public static final String MQPS_REQUEST_UPDATE = "ReqUpdate";
    public static final String MQPS_ANONYMOUS = "Anon";
    public static final String MQPS_CORREL_ID_AS_IDENTITY = "CorrelAsId";
    public static final String MQPS_DEREGISTER_ALL = "DeregAll";
    public static final String MQPS_DIRECT_REQUESTS = "DirectReq";
    public static final String MQPS_INCLUDE_STREAM_NAME = "InclStreamName";
    public static final String MQPS_INFORM_IF_RETAINED = "InformIfRet";
    public static final String MQPS_IS_RETAINED_PUBLICATION = "IsRetainedPub";
    public static final String MQPS_LOCAL = "Local";
    public static final String MQPS_NEW_PUBLICATIONS_ONLY = "NewPubsOnly";
    public static final String MQPS_NO_REGISTRATION = "NoReg";
    public static final String MQPS_NONE = "None";
    public static final String MQPS_OTHER_SUBSCRIBERS_ONLY = "OtherSubsOnly";
    public static final String MQPS_PUBLISH_ON_REQUEST_ONLY = "PubOnReqOnly";
    public static final String MQPS_RETAIN_PUBLICATION = "RetainPub";
    public static final String MQPS_DUPLICATES_OK = "DupsOK";
    public static final String MQPS_NON_PERSISTENT = "NonPers";
    public static final String MQPS_PERSISTENT = "Pers";
    public static final String MQPS_PERSISTENT_AS_PUBLISH = "PersAsPub";
    public static final String MQPS_PERSISTENT_AS_Q = "PersAsQueue";
    public static final String MQPS_ADD_NAME = "AddName";
    public static final String MQPS_NO_ALTERATION = "NoAlter";
    public static final String MQPS_FULL_RESPONSE = "FullResp";
    public static final String MQPS_JOIN_SHARED = "JoinShared";
    public static final String MQPS_JOIN_EXCLUSIVE = "JoinExcl";
    public static final String MQPS_LEAVE_ONLY = "LeaveOnly";
    public static final String MQPS_VARIABLE_USER_ID = "VariableUserId";
    public static final String MQPS_LOCKED = "Locked";
    public static final int MQDELO_NONE = 0;
    public static final int MQDELO_LOCAL = 4;
    public static final int MQPUBO_NONE = 0;
    public static final int MQPUBO_CORREL_ID_AS_IDENTITY = 1;
    public static final int MQPUBO_RETAIN_PUBLICATION = 2;
    public static final int MQPUBO_OTHER_SUBSCRIBERS_ONLY = 4;
    public static final int MQPUBO_NO_REGISTRATION = 8;
    public static final int MQPUBO_IS_RETAINED_PUBLICATION = 16;
    public static final int MQREGO_NONE = 0;
    public static final int MQREGO_CORREL_ID_AS_IDENTITY = 1;
    public static final int MQREGO_ANONYMOUS = 2;
    public static final int MQREGO_LOCAL = 4;
    public static final int MQREGO_DIRECT_REQUESTS = 8;
    public static final int MQREGO_NEW_PUBLICATIONS_ONLY = 16;
    public static final int MQREGO_PUBLISH_ON_REQUEST_ONLY = 32;
    public static final int MQREGO_DEREGISTER_ALL = 64;
    public static final int MQREGO_INCLUDE_STREAM_NAME = 128;
    public static final int MQREGO_INFORM_IF_RETAINED = 256;
    public static final int MQREGO_DUPLICATES_OK = 512;
    public static final int MQREGO_NON_PERSISTENT = 1024;
    public static final int MQREGO_PERSISTENT = 2048;
    public static final int MQREGO_PERSISTENT_AS_PUBLISH = 4096;
    public static final int MQREGO_PERSISTENT_AS_Q = 8192;
    public static final int MQREGO_ADD_NAME = 16384;
    public static final int MQREGO_NO_ALTERATION = 32768;
    public static final int MQREGO_FULL_RESPONSE = 65536;
    public static final int MQREGO_JOIN_SHARED = 131072;
    public static final int MQREGO_JOIN_EXCLUSIVE = 262144;
    public static final int MQREGO_LEAVE_ONLY = 524288;
    public static final int MQREGO_VARIABLE_USER_ID = 0x100000;
    public static final int MQREGO_LOCKED = 0x200000;
    private static Hashtable optionFields;
    private Hashtable nameValuePairs = new Hashtable();
    private int encoding = 273;
    private int codedCharSetId = 1208;
    private String format = "        ";
    private static final int MQRFH_ASCII_STRUCID_INT = 1380337696;
    private static final int MQRFH_EBCDIC_STRUCID_INT = -641284032;

    public static boolean isOptionField(String fieldname) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionField(String)", new Object[]{fieldname});
        }
        boolean traceRet1 = optionFields.containsKey(fieldname);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionField(String)", traceRet1);
        }
        return traceRet1;
    }

    public static int optionToFlag(String field, String option) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "optionToFlag(String,String)", new Object[]{field, option});
        }
        int out = 0;
        try {
            boolean interpretAsDecimal = false;
            Hashtable flags = (Hashtable)optionFields.get(field);
            if (flags != null) {
                Integer v = (Integer)flags.get(option);
                if (v != null) {
                    out = v;
                } else {
                    interpretAsDecimal = true;
                }
            } else {
                interpretAsDecimal = true;
            }
            if (interpretAsDecimal) {
                try {
                    out = Integer.parseInt(option);
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "optionToFlag(String,String)", nfe, 1);
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS3040", option);
                    je.setLinkedException((Exception)nfe);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "optionToFlag(String,String)", je, 1);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "optionToFlag(String,String)", new Integer(out));
            }
            return out;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "optionToFlag(String,String)", je, 2);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "optionToFlag(String,String)", je, 2);
            }
            throw je;
        }
    }

    MQBrokerMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "<init>()");
        }
    }

    public void set(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,String)", new Object[]{name, value});
        }
        try {
            if (MQBrokerMessage.isOptionField(name)) {
                JMSException je = ConfigEnvironment.newException("MQJMS3040", name);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,String)", je, 1);
                }
                throw je;
            }
            this.nameValuePairs.put(name, value);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,String)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,String)");
        }
    }

    public void set(String name, int options) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,int)", new Object[]{name, new Integer(options)});
        }
        this.nameValuePairs.put(name, new Integer(options));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "set(String,int)");
        }
    }

    public void setOption(String name, String option) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,String)", new Object[]{name, option});
        }
        try {
            int flag = MQBrokerMessage.optionToFlag(name, option);
            this.setOption(name, flag);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,String)");
        }
    }

    public void setOption(String name, int option) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,int)", new Object[]{name, new Integer(option)});
        }
        try {
            Object old = this.nameValuePairs.get(name);
            int newValue = 0;
            if (old != null) {
                if (!(old instanceof Integer)) {
                    JMSException je = ConfigEnvironment.newException("MQJMS3040", name);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,int)", je, 1);
                    }
                    throw je;
                }
                newValue = (Integer)old;
            }
            this.nameValuePairs.put(name, new Integer(newValue |= option));
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,int)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setOption(String,int)");
        }
    }

    public void update(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,String)", new Object[]{name, value});
        }
        try {
            value = value.trim();
            Object old = this.nameValuePairs.get(name);
            boolean option = MQBrokerMessage.isOptionField(name);
            if (option) {
                int flag = MQBrokerMessage.optionToFlag(name, value);
                int newValue = 0;
                if (old != null) {
                    if (!(old instanceof Integer)) {
                        JMSException je = ConfigEnvironment.newException("MQJMS3040", name);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,String)", je, 1);
                        }
                        throw je;
                    }
                    newValue = (Integer)old;
                }
                this.nameValuePairs.put(name, new Integer(newValue |= flag));
            } else {
                if (old != null) {
                    JMSException je = ConfigEnvironment.newException("MQJMS3041", name);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,String)", je, 2);
                    }
                    throw je;
                }
                this.nameValuePairs.put(name, value);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,String)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,String)");
        }
    }

    public void update(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,int)", new Object[]{name, new Integer(value)});
        }
        try {
            Object old = this.nameValuePairs.get(name);
            if (old != null && !(old instanceof Integer)) {
                JMSException je = ConfigEnvironment.newException("MQJMS3040", name);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,int)", je, 1);
                }
                throw je;
            }
            int newValue = 0;
            if (old != null) {
                newValue = (Integer)old;
            }
            this.nameValuePairs.put(name, new Integer(newValue |= value));
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,int)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "update(String,int)");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "clear()");
        }
        this.nameValuePairs.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "clear()");
        }
    }

    public void unset(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unset(String)", new Object[]{name});
        }
        this.nameValuePairs.remove(name);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unset(String)");
        }
    }

    public void unsetOption(String field, String option) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,String)", new Object[]{field, option});
        }
        try {
            int flag = MQBrokerMessage.optionToFlag(field, option);
            this.unsetOption(field, flag);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,String)");
        }
    }

    public void unsetOption(String field, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,int)", new Object[]{field, new Integer(value)});
        }
        try {
            Object old = this.nameValuePairs.get(field);
            if (old != null && !(old instanceof Integer)) {
                JMSException je = ConfigEnvironment.newException("MQJMS3040", field);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,int)", je, 1);
                }
                throw je;
            }
            if (old != null) {
                int newValue = 0;
                newValue = (Integer)old;
                this.nameValuePairs.put(field, new Integer(newValue &= ~value));
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,int)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "unsetOption(String,int)");
        }
    }

    public Enumeration getFields() {
        Enumeration e = this.nameValuePairs.keys();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getFields()", "getter", e);
        }
        return e;
    }

    public String get(String name) {
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "get(String)", new Object[]{name});
        }
        if ((v = this.nameValuePairs.get(name)) == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "get(String)", null, 1);
            }
            return null;
        }
        String traceRet1 = v.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "get(String)", traceRet1, 2);
        }
        return traceRet1;
    }

    public int getOptions(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getOptions(String)", new Object[]{name});
        }
        try {
            Object v = this.nameValuePairs.get(name);
            if (v == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getOptions(String)", new Integer(0), 1);
                }
                return 0;
            }
            if (v instanceof Integer) {
                int traceRet1 = (Integer)v;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getOptions(String)", new Integer(traceRet1), 2);
                }
                return traceRet1;
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3040", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getOptions(String)", je, 1);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getOptions(String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getOptions(String)", je, 2);
            }
            throw je;
        }
    }

    public boolean isOptionSet(String field, String option) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,String)", new Object[]{field, option});
        }
        try {
            int flag = MQBrokerMessage.optionToFlag(field, option);
            boolean traceRet1 = this.isOptionSet(field, flag);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,String)", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,String)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,String)", je);
            }
            throw je;
        }
    }

    public boolean isOptionSet(String field, int option) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,int)", new Object[]{field, new Integer(option)});
        }
        try {
            Object v = this.nameValuePairs.get(field);
            if (v == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,int)", false, 1);
                }
                return false;
            }
            if (v instanceof Integer) {
                boolean traceRet1;
                int set = (Integer)v;
                boolean bl = traceRet1 = (set & option) == option;
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,int)", traceRet1, 2);
                }
                return traceRet1;
            }
            JMSException je = ConfigEnvironment.newException("MQJMS3040", field);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,int)", je, 1);
            }
            throw je;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "isOptionSet(String,int)", je, 2);
            }
            throw je;
        }
    }

    public void setEncoding(int encoding) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setEncoding(int)", "setter", new Integer(encoding));
        }
        this.encoding = encoding;
    }

    public int getEncoding() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getEncoding()", "getter", new Integer(this.encoding));
        }
        return this.encoding;
    }

    public void setCodedCharSetId(int codedCharSetId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setCodedCharSetId(int)", "setter", new Integer(codedCharSetId));
        }
        this.codedCharSetId = codedCharSetId;
    }

    public int getCodedCharSetId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getCodedCharSetId()", "getter", new Integer(this.codedCharSetId));
        }
        return this.codedCharSetId;
    }

    public void setFormat(String format) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setFormat(String)", new Object[]{format});
        }
        this.format = format;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "setFormat(String)");
        }
    }

    public String getFormat() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getFormat()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "getFormat()", this.format);
        }
        return this.format;
    }

    public abstract void writeToMessage(MQMsg2 var1) throws JMSException;

    public abstract void initializeFromMessage(MQMsg2 var1) throws JMSException;

    public abstract String getHeaderFormat();

    public static MQBrokerMessage fromMessage(MQMsg2 message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", new Object[]{message});
        }
        try {
            int version;
            int strucId;
            try {
                strucId = message.readInt(1);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", e, 1);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1089", e.toString());
                je.setLinkedException(e);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", je, 1);
                }
                throw je;
            }
            try {
                version = message.readInt(message.getEncoding());
            }
            catch (Exception e) {
                block23: {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", e, 2);
                    }
                    try {
                        message.skipReadingBytes(-4);
                    }
                    catch (Exception e2) {
                        if (!Trace.isOn) break block23;
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", e2, 3);
                    }
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1089", e.toString());
                je.setLinkedException(e);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", je, 2);
                }
                throw je;
            }
            try {
                message.skipReadingBytes(-8);
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", e, 4);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS1089", e.toString());
                je.setLinkedException(e);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", je, 3);
                }
                throw je;
            }
            MQBrokerMessage out = strucId == 1380337696 || strucId == -641284032 ? (version == 1 ? new RFH1BrokerMessageImpl() : (version == 2 ? new RFH2BrokerMessageImpl() : null)) : null;
            if (out == null) {
                if (Trace.isOn) {
                    Trace.traceData(clsName, "ProviderMessage header not understood", null);
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3042");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", je, 4);
                }
                throw je;
            }
            ((MQBrokerMessage)out).initializeFromMessage(message);
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", out);
            }
            return out;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", je, 5);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "fromMessage(MQMsg2)", je, 5);
            }
            throw je;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/MQBrokerMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.18.1.1 09/08/17 08:08:58");
        }
        optionFields = new Hashtable();
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "static()");
        }
        Hashtable<String, Integer> flags = new Hashtable<String, Integer>();
        flags.put(MQPS_LOCAL, new Integer(4));
        optionFields.put(MQPS_DELETE_OPTIONS, flags);
        flags = new Hashtable();
        flags.put(MQPS_CORREL_ID_AS_IDENTITY, new Integer(1));
        flags.put(MQPS_ANONYMOUS, new Integer(2));
        flags.put(MQPS_LOCAL, new Integer(4));
        flags.put(MQPS_DIRECT_REQUESTS, new Integer(8));
        flags.put(MQPS_NEW_PUBLICATIONS_ONLY, new Integer(16));
        flags.put(MQPS_PUBLISH_ON_REQUEST_ONLY, new Integer(32));
        flags.put(MQPS_DEREGISTER_ALL, new Integer(64));
        flags.put(MQPS_INCLUDE_STREAM_NAME, new Integer(128));
        flags.put(MQPS_INFORM_IF_RETAINED, new Integer(256));
        flags.put(MQPS_DUPLICATES_OK, new Integer(512));
        flags.put(MQPS_NON_PERSISTENT, new Integer(1024));
        flags.put(MQPS_PERSISTENT, new Integer(2048));
        flags.put(MQPS_PERSISTENT_AS_PUBLISH, new Integer(4096));
        flags.put(MQPS_PERSISTENT_AS_Q, new Integer(8192));
        flags.put(MQPS_ADD_NAME, new Integer(16384));
        flags.put(MQPS_NO_ALTERATION, new Integer(32768));
        flags.put(MQPS_FULL_RESPONSE, new Integer(65536));
        flags.put(MQPS_JOIN_SHARED, new Integer(131072));
        flags.put(MQPS_JOIN_EXCLUSIVE, new Integer(262144));
        flags.put(MQPS_LEAVE_ONLY, new Integer(524288));
        flags.put(MQPS_VARIABLE_USER_ID, new Integer(0x100000));
        flags.put(MQPS_LOCKED, new Integer(0x200000));
        optionFields.put(MQPS_REGISTRATION_OPTIONS, flags);
        flags = new Hashtable();
        flags.put(MQPS_CORREL_ID_AS_IDENTITY, new Integer(1));
        flags.put(MQPS_RETAIN_PUBLICATION, new Integer(2));
        flags.put(MQPS_OTHER_SUBSCRIBERS_ONLY, new Integer(4));
        flags.put(MQPS_NO_REGISTRATION, new Integer(8));
        flags.put(MQPS_IS_RETAINED_PUBLICATION, new Integer(16));
        optionFields.put(MQPS_PUBLICATION_OPTIONS, flags);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage", "static()");
        }
    }
}

