/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;

public class JMSTextMessage
extends JMSMessage
implements ProviderTextMessage {
    static final long serialVersionUID = -7013263043146565366L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSTextMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.18.1.1 09/08/17 08:08:42";
    String messageText = null;
    byte[] messageBytes = null;
    String characterSet;
    int dataStart;
    char[] HPCodepage = null;
    boolean readOnly = false;

    public JMSTextMessage(JMSStringResources jmsStrings) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "<init>(JMSStringResources)", new Object[]{jmsStrings});
        }
        this.messageClass = "jms_text";
        this.jmsStrings = jmsStrings;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "<init>(JMSStringResources)");
        }
    }

    public JMSTextMessage(JMSStringResources jmsStrings, String string) throws JMSException {
        this(jmsStrings);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "<init>(JMSStringResources,String)", new Object[]{jmsStrings, string});
        }
        this.messageClass = "jms_text";
        this.setText(string);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "<init>(JMSStringResources,String)");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        try {
            if (this.messageBytes == null) {
                if (this.messageText == null) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", null, 1);
                    }
                    return null;
                }
                this.messageBytes = this.messageText.getBytes(characterSet);
                this.characterSet = characterSet;
                this.dataStart = 0;
            } else {
                if (this.characterSet.equals(characterSet)) {
                    if (this.dataStart != 0) {
                        byte[] tempBytes = new byte[this.messageBytes.length - this.dataStart];
                        System.arraycopy(this.messageBytes, this.dataStart, tempBytes, 0, this.messageBytes.length - this.dataStart);
                        this.messageBytes = tempBytes;
                        this.dataStart = 0;
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", this.messageBytes, 2);
                        }
                        return this.messageBytes;
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", this.messageBytes, 3);
                    }
                    return this.messageBytes;
                }
                this.messageText = new String(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart, this.characterSet);
                this.messageBytes = this.messageText.getBytes(characterSet);
                this.characterSet = characterSet;
                this.dataStart = 0;
            }
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", ex);
            }
            JMSException jmsEx = this.newJMSException(1008, characterSet);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", jmsEx);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_exportBody(int,String)", this.messageBytes, 4);
        }
        return this.messageBytes;
    }

    public void _importBody(byte[] wireformat, int dataStart, int encoding, String charSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_importBody(byte [ ],int,int,String)", new Object[]{wireformat, new Integer(dataStart), new Integer(encoding), charSet});
        }
        this.messageBytes = wireformat;
        this.messageText = null;
        this.dataStart = dataStart;
        this.characterSet = charSet;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_importBody(byte [ ],int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "clearBody()");
        }
        this.readOnly = false;
        this.messageText = null;
        this.messageBytes = null;
        this.isNullMessage = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "clearBody()");
        }
    }

    public String getText() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "getText()");
        }
        try {
            if (this.messageText == null && this.messageBytes != null) {
                if (this.characterSet.equals("1051") || this.characterSet.equalsIgnoreCase("Cp1051")) {
                    this.messageText = this.unicodeFrom1051(this.messageBytes, this.dataStart);
                    this.characterSet = new String("UTF8");
                } else {
                    this.messageText = new String(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart, this.characterSet);
                }
                this.messageBytes = null;
            }
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "getText()", ex);
            }
            JMSException jmsEx = this.newMessageFormatException(1008, this.characterSet);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "getText()", jmsEx);
            }
            throw jmsEx;
        }
        if (this.isNullMessage && this.messageText != null && this.messageText.length() == 0) {
            this.messageText = null;
        } else if (!this.isNullMessage && this.messageText == null) {
            this.messageText = "";
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "getText()", this.messageText);
        }
        return this.messageText;
    }

    public void setText(String messageText) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "setText(String)", new Object[]{messageText});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "setText(String)", traceRet1);
            }
            throw traceRet1;
        }
        this.isNullMessage = messageText == null;
        this.messageText = messageText;
        this.messageBytes = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "setText(String)");
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.toString());
        retval.append("\n");
        try {
            if (this.messageText == null) {
                this.getText();
            }
        }
        catch (JMSException ex) {
            retval.append(this.jmsStrings.getMessage(1025, (Object)ex));
            retval.append(">");
        }
        if (this.messageText == null) {
            retval.append("<null>");
        } else if (this.messageText.length() > 100) {
            retval.append(this.messageText.substring(0, 100));
            retval.append("\n" + this.jmsStrings.getMessage(1026, new Integer(this.messageText.length() - 100)));
        } else {
            retval.append(this.messageText);
        }
        String traceRet1 = retval.toString();
        return traceRet1;
    }

    void _setBodyReadOnly() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_setBodyReadOnly()");
        }
        this.readOnly = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "_setBodyReadOnly()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        if (this.messageClass.equals("jms_text")) {
            this.messageClass = "jms_text";
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    public String unicodeFrom1051(byte[] messageBytes, int dataStart) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "unicodeFrom1051(byte [ ],int)", new Object[]{messageBytes, new Integer(dataStart)});
        }
        int dataLength = messageBytes.length - dataStart;
        char[] output = new char[dataLength];
        if (this.HPCodepage == null) {
            this.HPCodepage = this.get1051codepage();
        }
        int i = dataStart;
        for (int offs = 0; offs < dataLength; ++offs) {
            int b = (messageBytes[i] + 256) % 256;
            output[offs] = this.HPCodepage[b];
            ++i;
        }
        String traceRet1 = new String(output);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "unicodeFrom1051(byte [ ],int)", traceRet1);
        }
        return traceRet1;
    }

    private char[] get1051codepage() {
        int i;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "get1051codepage()");
        }
        char[] cp = new char[256];
        char[] CP1051_to_chars = new char[]{'\u00c0', '\u00c2', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u02ca', '\u02cb', '\u02c6', '\u00a8', '\u02dc', '\u00d9', '\u00db', '\u20a4', '\u00af', '\u00dd', '\u00fd', '\u00b0', '\u00c7', '\u00e7', '\u00d1', '\u00f1', '\u00a1', '\u00bf', '\u00a4', '\u00a3', '\u00a5', '\u00a7', '\u0192', '\u00a2', '\u00e2', '\u00ea', '\u00f4', '\u00fb', '\u00e1', '\u00e9', '\u00f3', '\u00fa', '\u00e0', '\u00e8', '\u00f2', '\u00f9', '\u00e4', '\u00eb', '\u00f6', '\u00fc', '\u00c5', '\u00ee', '\u00d8', '\u00c6', '\u00e5', '\u00ed', '\u00f8', '\u00e6', '\u00c4', '\u00ec', '\u00d6', '\u00dc', '\u00c9', '\u00ef', '\u00df', '\u00d4', '\u00c1', '\u00c3', '\u00e3', '\u00d0', '\u00f0', '\u00cd', '\u00cc', '\u00d3', '\u00d2', '\u00d5', '\u00f5', '\u0160', '\u0161', '\u00da', '\u0178', '\u00ff', '\u00de', '\u00fe', '\u00b7', '\u00b5', '\u00b6', '\u00be', '\u00ad', '\u00bc', '\u00bd', '\u00aa', '\u00ba', '\u00ab', '\u25a0', '\u00bb', '\u00b1', '\u001a'};
        for (i = 0; i < 161; ++i) {
            cp[i] = (char)i;
        }
        for (i = 161; i <= 255; ++i) {
            cp[i] = CP1051_to_chars[i - 161];
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "get1051codepage()", cp);
        }
        return cp;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSTextMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSTextMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.18.1.1 09/08/17 08:08:42");
        }
    }
}

