/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;

public class JMSStreamMessage
extends JMSMessage
implements ProviderStreamMessage {
    static final long serialVersionUID = -3015681339377486635L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSStreamMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.25.1.1 09/08/17 08:08:20";
    private static final String STREAM_BODY_NAME = "stream";
    private static final String STREAM_BODY_CLOSE_TAG = "</stream>";
    private static final String STREAM_ELT_NAME = "elt";
    private StringBuffer dataWritten;
    private String streamBody;
    private transient StringTokenizer dataToBeRead;
    private transient Object currentField;
    private transient boolean retrying = false;
    private transient int readPos = 0;
    boolean readOnly = false;
    private ArrayList streamForToString = new ArrayList();

    public JMSStreamMessage(JMSStringResources jmsStrings) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "<init>(JMSStringResources)", new Object[]{jmsStrings});
        }
        this.messageClass = "jms_stream";
        this.jmsStrings = jmsStrings;
        this.clearBody();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "<init>(JMSStringResources)");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        try {
            StringBuffer body = new StringBuffer();
            if (this.dataWritten != null && this.streamBody == null) {
                body.append(this.dataWritten.toString());
                body.append(STREAM_BODY_CLOSE_TAG);
            } else if (this.streamBody != null) {
                body.append(this.streamBody);
                if (this.streamBody.indexOf(STREAM_BODY_CLOSE_TAG) == -1) {
                    body.append(STREAM_BODY_CLOSE_TAG);
                }
            } else {
                Trace.ffst(this, "_exportBody(int,String)", "XO00G001", new HashMap(), JMSException.class);
            }
            byte[] traceRet1 = body.toString().getBytes(characterSet);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_exportBody(int,String)", traceRet1);
            }
            return traceRet1;
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_exportBody(int,String)", ex);
            }
            JMSException jmsEx = this.newJMSException(1008, characterSet);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_exportBody(int,String)", jmsEx);
            }
            throw jmsEx;
        }
    }

    public void _importBody(byte[] wireformat, int dataStart, int encoding, String charSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_importBody(byte [ ],int,int,String)", new Object[]{wireformat, new Integer(dataStart), new Integer(encoding), charSet});
        }
        try {
            this.streamBody = new String(wireformat, dataStart, wireformat.length - dataStart, charSet);
            this.parseStreamBodyForToString(this.streamBody);
            this.readOnly = true;
            this.reset();
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_importBody(byte [ ],int,int,String)", ex);
            }
            JMSException jmsEx = this.newJMSException(1008, charSet);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_importBody(byte [ ],int,int,String)", jmsEx);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_importBody(byte [ ],int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "clearBody()");
        }
        this.readOnly = false;
        this.dataToBeRead = null;
        this.streamBody = null;
        this.dataWritten = new StringBuffer("<stream>");
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "clearBody()");
        }
    }

    public boolean readBoolean() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBoolean()");
        }
        boolean retval = this.toBoolean(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBoolean()", retval);
        }
        return retval;
    }

    public byte readByte() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readByte()");
        }
        byte retval = this.toByte(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readByte()", new Byte(retval));
        }
        return retval;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBytes(byte [ ])", new Object[]{value});
        }
        byte[] msgValue = null;
        msgValue = this.toBytes(this.readField());
        if (msgValue == null) {
            this.retrying = false;
            int traceRet1 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBytes(byte [ ])", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        if (msgValue.length == 0) {
            if (value.length > 0) {
                this.retrying = false;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBytes(byte [ ])", new Integer(0), 2);
            }
            return 0;
        }
        int bytesLeft = msgValue.length - this.readPos;
        if (bytesLeft == 0) {
            this.retrying = false;
            this.readPos = 0;
            int traceRet2 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBytes(byte [ ])", new Integer(traceRet2), 3);
            }
            return traceRet2;
        }
        if (value.length > bytesLeft) {
            System.arraycopy(msgValue, this.readPos, value, 0, bytesLeft);
            this.retrying = false;
            this.readPos = 0;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBytes(byte [ ])", new Integer(bytesLeft), 4);
            }
            return bytesLeft;
        }
        System.arraycopy(msgValue, this.readPos, value, 0, value.length);
        this.readPos += value.length;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readBytes(byte [ ])", new Integer(value.length), 5);
        }
        return value.length;
    }

    public char readChar() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readChar()");
        }
        char retval = this.toChar(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readChar()", new Character(retval));
        }
        return retval;
    }

    public double readDouble() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readDouble()");
        }
        double retval = this.toDouble(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readDouble()", new Double(retval));
        }
        return retval;
    }

    private Object readField() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()");
        }
        try {
            String type;
            if (!this.readOnly) {
                JMSException traceRet1 = this.newMessageNotReadableException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (this.retrying) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", this.currentField, 1);
                }
                return this.currentField;
            }
            String name = this.dataToBeRead.nextToken();
            if (name.equals("/stream")) {
                JMSException traceRet2 = this.newMessageEOFException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", traceRet2, 2);
                }
                throw traceRet2;
            }
            this.currentField = null;
            this.retrying = true;
            int nullIndex = 0;
            boolean byteIndex = false;
            boolean shortForm = false;
            if (name.charAt(name.length() - 1) == '/') {
                shortForm = true;
            }
            if ((nullIndex = name.indexOf(" xsi:nil")) != -1) {
                int spaceIndex = 0;
                spaceIndex = name.indexOf(" ");
                name = name.substring(0, spaceIndex);
                if (!shortForm) {
                    String token = this.dataToBeRead.nextToken();
                    if (token.charAt(0) != '/') {
                        token = this.dataToBeRead.nextToken();
                    }
                    if (token.charAt(0) != '/') {
                        JMSException traceRet3 = this.newMessageFormatException(1010);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", traceRet3, 3);
                        }
                        throw traceRet3;
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", null, 2);
                }
                return null;
            }
            int index = name.indexOf(" dt=");
            if (index != -1) {
                type = name.substring(index + 4);
                name = name.substring(0, index);
            } else {
                type = "'string'";
            }
            if (shortForm) {
                this.currentField = this.deformatElement(type, "");
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", this.currentField, 3);
                }
                return this.currentField;
            }
            String value = this.dataToBeRead.nextToken();
            if (value.charAt(0) == '/') {
                this.currentField = this.deformatElement(type, "");
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", this.currentField, 4);
                }
                return this.currentField;
            }
            String token = this.dataToBeRead.nextToken();
            if (token.charAt(0) != '/') {
                JMSException traceRet4 = this.newMessageFormatException(1010);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", traceRet4, 4);
                }
                throw traceRet4;
            }
            this.currentField = this.deformatElement(type, value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", this.currentField, 5);
            }
            return this.currentField;
        }
        catch (NoSuchElementException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", ex);
            }
            JMSException traceRet5 = this.newMessageEOFException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readField()", traceRet5, 5);
            }
            throw traceRet5;
        }
    }

    public float readFloat() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readFloat()");
        }
        float retval = this.toFloat(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readFloat()", new Float(retval));
        }
        return retval;
    }

    public int readInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readInt()");
        }
        int retval = this.toInt(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readInt()", new Integer(retval));
        }
        return retval;
    }

    public long readLong() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readLong()");
        }
        long retval = this.toLong(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readLong()", new Long(retval));
        }
        return retval;
    }

    public Object readObject() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readObject()");
        }
        Object retval = this.readField();
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readObject()", retval);
        }
        return retval;
    }

    public short readShort() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readShort()");
        }
        short retval = this.toShort(this.readField());
        this.retrying = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readShort()", new Short(retval));
        }
        return retval;
    }

    public String readString() throws JMSException {
        Object fieldValue;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readString()");
        }
        if ((fieldValue = this.readField()) instanceof byte[]) {
            JMSException traceRet1 = this.newMessageFormatException(1011);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readString()", traceRet1);
            }
            throw traceRet1;
        }
        this.retrying = false;
        if (fieldValue == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readString()", null, 1);
            }
            return null;
        }
        String traceRet2 = fieldValue.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readString()", traceRet2, 2);
        }
        return traceRet2;
    }

    public void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "reset()");
        }
        if (!this.readOnly) {
            this.dataWritten.append(STREAM_BODY_CLOSE_TAG);
            this.streamBody = this.dataWritten.toString();
            this.dataWritten = null;
            this.readOnly = true;
        }
        this.dataToBeRead = new StringTokenizer(this.streamBody, "<>");
        this.retrying = false;
        if (!this.dataToBeRead.nextToken().equals(STREAM_BODY_NAME)) {
            JMSException traceRet1 = this.newMessageFormatException(1010);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "reset()", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "reset()");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBoolean(boolean)", new Object[]{value});
        }
        this.writeObject(new Boolean(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeByte(byte)", new Object[]{new Byte(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeByte(byte)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement(STREAM_ELT_NAME, "'i1'", String.valueOf(value), this.dataWritten);
        this.streamForToString.add(new Byte(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeByte(byte)");
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBytes(byte [ ])", new Object[]{value});
        }
        this.writeObject(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBytes(byte [ ],int,int)", traceRet1);
            }
            throw traceRet1;
        }
        this.dataWritten.append("<elt dt='bin.hex'>");
        JMSStreamMessage.binToHex(value, offset, length, this.dataWritten);
        this.dataWritten.append("</elt>");
        byte[] bytes = new byte[length];
        System.arraycopy(value, offset, bytes, 0, length);
        this.streamForToString.add(bytes);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeChar(char)", new Object[]{new Character(value)});
        }
        this.writeObject(new Character(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeChar(char)");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeDouble(double)", new Object[]{new Double(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeDouble(double)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement(STREAM_ELT_NAME, "'r8'", String.valueOf(value), this.dataWritten);
        this.streamForToString.add(new Double(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeDouble(double)");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeFloat(float)", new Object[]{new Float(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeFloat(float)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement(STREAM_ELT_NAME, "'r4'", String.valueOf(value), this.dataWritten);
        this.streamForToString.add(new Float(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeFloat(float)");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeInt(int)", new Object[]{new Integer(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeInt(int)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement(STREAM_ELT_NAME, "'i4'", String.valueOf(value), this.dataWritten);
        this.streamForToString.add(new Integer(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeInt(int)");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeLong(long)", new Object[]{new Long(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeLong(long)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement(STREAM_ELT_NAME, "'i8'", String.valueOf(value), this.dataWritten);
        this.streamForToString.add(new Long(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeLong(long)");
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeObject(Object)", new Object[]{value});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeObject(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof byte[])) {
            JMSException traceRet2 = this.newMessageFormatException(1018, value.getClass());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeObject(Object)", traceRet2, 2);
            }
            throw traceRet2;
        }
        this.formatElement(STREAM_ELT_NAME, value, this.dataWritten);
        this.streamForToString.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeObject(Object)");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeShort(short)", new Object[]{new Short(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeShort(short)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement(STREAM_ELT_NAME, "'i2'", String.valueOf(value), this.dataWritten);
        this.streamForToString.add(new Short(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeShort(short)");
        }
    }

    public void writeString(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeString(String)", new Object[]{value});
        }
        this.writeObject(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "writeString(String)");
        }
    }

    void _setBodyReadOnly() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_setBodyReadOnly()");
        }
        this.readOnly = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "_setBodyReadOnly()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        if (this.messageClass.equals("jms_stream")) {
            this.messageClass = "jms_stream";
        }
        if (this.readOnly) {
            this.currentField = null;
            this.retrying = false;
            this.readPos = 0;
            this.dataToBeRead = new StringTokenizer(this.streamBody, "<>");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    public void stepBack() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "stepBack()");
        }
        this.retrying = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "stepBack()");
        }
    }

    public ArrayList getStreamData() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "getStreamData()", "getter", this.streamForToString);
        }
        return this.streamForToString;
    }

    private void parseStreamBodyForToString(String streamBody) throws JMSException {
        StringTokenizer dataToBeRead;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)", new Object[]{streamBody});
        }
        if (!(dataToBeRead = new StringTokenizer(streamBody, "<>")).nextToken().equals(STREAM_BODY_NAME)) {
            JMSException je = this.newMessageFormatException(1010);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)", je, 1);
            }
            throw je;
        }
        String name = dataToBeRead.nextToken();
        String value = null;
        String token = null;
        Object currentField = null;
        try {
            while (!name.equals("/stream")) {
                boolean shortForm = name.charAt(name.length() - 1) == '/';
                int nullIndex = name.indexOf(" xsi:nil");
                if (nullIndex != -1) {
                    int spaceIndex = name.indexOf(" ");
                    name = name.substring(0, spaceIndex);
                    if (!shortForm) {
                        token = dataToBeRead.nextToken();
                        if (token.charAt(0) != '/') {
                            token = dataToBeRead.nextToken();
                        }
                        if (token.charAt(0) != '/') {
                            JMSException je2 = this.newMessageFormatException(1010);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)", je2, 2);
                            }
                            throw je2;
                        }
                    }
                    this.streamForToString.add(null);
                    name = dataToBeRead.nextToken();
                    continue;
                }
                int index = name.indexOf(" dt=");
                String type = "";
                if (index != -1) {
                    type = name.substring(index + 4);
                    name = name.substring(0, index);
                } else {
                    type = "'string'";
                }
                if (shortForm) {
                    currentField = this.deformatElement(type, "");
                    this.streamForToString.add(currentField);
                    name = dataToBeRead.nextToken();
                    continue;
                }
                value = dataToBeRead.nextToken();
                if (value.charAt(0) == '/') {
                    currentField = this.deformatElement(type, "");
                    this.streamForToString.add(currentField);
                } else {
                    token = dataToBeRead.nextToken();
                    if (token.charAt(0) != '/') {
                        JMSException je = this.newMessageFormatException(1010);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)", je, 3);
                        }
                        throw je;
                    }
                    currentField = this.deformatElement(type, value);
                    this.streamForToString.add(currentField);
                }
                name = dataToBeRead.nextToken();
            }
        }
        catch (NoSuchElementException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)", ex);
            }
            JMSException je = this.newMessageFormatException(1010);
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "parseStreamBodyForToString(String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSStreamMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.25.1.1 09/08/17 08:08:20");
        }
    }
}

