/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.PublishSubscribeSetupException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQPubSubServices;
import com.ibm.msg.client.wmq.v6.jms.internal.MQQueueServices;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import javax.jms.JMSException;

public class JMSServicesMgr {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSServicesMgr.java, jmscc.wmq.v6, k701, k701-112-140304 1.18.1.1 09/08/17 08:08:08";
    private PublishSubscribeSetupException sme;
    private MQQueueServices queueServices = null;
    private MQPubSubServices pubSubServices = null;
    boolean pubSubSet = false;
    boolean queueSet = false;

    JMSServicesMgr() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "<init>()");
        }
    }

    protected void setQueueServices(MQQueueServices qs) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "setQueueServices(MQQueueServices)", "setter", qs);
        }
        this.queueServices = qs;
        this.queueSet = true;
    }

    protected void setPubSubServices(MQPubSubServices pss) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "setPubSubServices(MQPubSubServices)", "setter", pss);
        }
        this.pubSubServices = pss;
        this.pubSubSet = true;
    }

    protected boolean isPubSub() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "isPubSub()", "getter", this.pubSubSet);
        }
        return this.pubSubSet;
    }

    protected boolean isPTP() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "isPTP()", "getter", this.queueSet);
        }
        return this.queueSet;
    }

    void closePS(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "closePS(MQSession)", new Object[]{session});
        }
        try {
            if (this.pubSubSet) {
                this.pubSubServices.closePubSub(session);
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "closePS(MQSession)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "closePS(MQSession)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "closePS(MQSession)");
        }
    }

    protected JMSException getQueueOpenException(MQException mqe) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueOpenException(MQException)", new Object[]{mqe});
        }
        if (this.queueSet) {
            JMSException traceRet1 = this.queueServices.getQueueOpenException(mqe, "");
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueOpenException(MQException)", (Object)traceRet1);
            }
            return traceRet1;
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueOpenException(MQException)", (Throwable)((Object)this.sme));
        }
        throw this.sme;
    }

    void checkQueueAccess(WMQDestination queue, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkQueueAccess(WMQDestination,MQSession)", new Object[]{queue, session});
        }
        if (!this.queueSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkQueueAccess(WMQDestination,MQSession)", (Throwable)((Object)this.sme));
            }
            throw this.sme;
        }
        this.queueServices.checkQueueAccess(queue, session);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkQueueAccess(WMQDestination,MQSession)");
        }
    }

    MQQueue getOutputQueue(WMQDestination dest, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getOutputQueue(WMQDestination,MQSession)", new Object[]{dest, session});
        }
        if (this.queueSet) {
            try {
                MQQueue traceRet1 = this.queueServices.getOutputQueue(dest, session);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getOutputQueue(WMQDestination,MQSession)", traceRet1);
                }
                return traceRet1;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getOutputQueue(WMQDestination,MQSession)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getOutputQueue(WMQDestination,MQSession)", je, 1);
                }
                throw je;
            }
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getOutputQueue(WMQDestination,MQSession)", (Throwable)((Object)this.sme), 2);
        }
        throw this.sme;
    }

    MQQueue getQueueForBrowse(WMQDestination queueSpec, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueForBrowse(WMQDestination,MQSession)", new Object[]{queueSpec, session});
        }
        if (this.queueSet) {
            try {
                MQQueue traceRet1 = this.queueServices.getQueueForBrowse(queueSpec, session);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueForBrowse(WMQDestination,MQSession)", traceRet1);
                }
                return traceRet1;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueForBrowse(WMQDestination,MQSession)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueForBrowse(WMQDestination,MQSession)", je, 1);
                }
                throw je;
            }
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getQueueForBrowse(WMQDestination,MQSession)", (Throwable)((Object)this.sme), 2);
        }
        throw this.sme;
    }

    void getBrokerResponse(MQSession session, MQMsg2 response, boolean immediateResponse) throws NoBrokerResponseException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getBrokerResponse(MQSession,MQMsg2,boolean)", new Object[]{session, response, immediateResponse});
        }
        if (!this.pubSubSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getBrokerResponse(MQSession,MQMsg2,boolean)", (Throwable)((Object)this.sme));
            }
            throw this.sme;
        }
        this.pubSubServices.getBrokerResponse(session, response, immediateResponse);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getBrokerResponse(MQSession,MQMsg2,boolean)");
        }
    }

    boolean checkForResponse(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkForResponse(MQSession)", new Object[]{session});
        }
        if (this.pubSubSet) {
            try {
                boolean traceRet1 = this.pubSubServices.checkForResponse(session);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkForResponse(MQSession)", traceRet1, 1);
                }
                return traceRet1;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkForResponse(MQSession)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkForResponse(MQSession)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "checkForResponse(MQSession)", false, 2);
        }
        return false;
    }

    boolean getSparseSubscriptions(MQSession session) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getSparseSubscriptions(MQSession)", new Object[]{session});
        }
        if (this.pubSubSet) {
            boolean traceRet1 = this.pubSubServices.getSparseSubscriptions(session);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getSparseSubscriptions(MQSession)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getSparseSubscriptions(MQSession)", false, 2);
        }
        return false;
    }

    private void setBrokerTimeout(int x) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "setBrokerTimeout(int)", new Object[]{new Integer(x)});
        }
        if (!this.pubSubSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "setBrokerTimeout(int)", (Throwable)((Object)this.sme));
            }
            throw this.sme;
        }
        this.pubSubServices.setBrokerTimeout(x);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "setBrokerTimeout(int)");
        }
    }

    private int getBrokerTimeout() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getBrokerTimeout()");
        }
        if (this.pubSubSet) {
            int traceRet1 = this.pubSubServices.getBrokerTimeout();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getBrokerTimeout()", new Integer(traceRet1));
            }
            return traceRet1;
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getBrokerTimeout()", (Throwable)((Object)this.sme));
        }
        throw this.sme;
    }

    protected ProviderMessage consume(ProviderMessageReference mRef, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "consume(ProviderMessageReference,MQSession)", new Object[]{mRef, session});
        }
        if (this.queueSet) {
            ProviderMessage traceRet1 = this.queueServices.consume(mRef, session);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "consume(ProviderMessageReference,MQSession)", traceRet1);
            }
            return traceRet1;
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1112").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "consume(ProviderMessageReference,MQSession)", (Throwable)((Object)this.sme));
        }
        throw this.sme;
    }

    protected ProviderMessage consume(byte[] flattenedRef, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "consume(byte [ ],MQSession)", new Object[]{flattenedRef, session});
        }
        if (this.queueSet) {
            ProviderMessage traceRet1 = this.queueServices.consume(flattenedRef, session);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "consume(byte [ ],MQSession)", traceRet1);
            }
            return traceRet1;
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1112").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "consume(byte [ ],MQSession)", (Throwable)((Object)this.sme));
        }
        throw this.sme;
    }

    void redirectMessage(String qName, MQMsg2 message, boolean syncPoint, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", new Object[]{qName, message, syncPoint, session});
        }
        if (!this.queueSet) {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)", (Throwable)((Object)this.sme));
            }
            throw this.sme;
        }
        this.queueServices.redirectMessage(qName, message, syncPoint, session);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "redirectMessage(String,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2,boolean,MQSession)");
        }
    }

    protected ProviderMessageReference recreateMessageReference(byte[] flatMR, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "recreateMessageReference(byte [ ],MQSession)", new Object[]{flatMR, session});
        }
        if (this.queueSet) {
            ProviderMessageReference traceRet1 = this.queueServices.recreateMessageReference(flatMR, session);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "recreateMessageReference(byte [ ],MQSession)", traceRet1);
            }
            return traceRet1;
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "recreateMessageReference(byte [ ],MQSession)", (Throwable)((Object)this.sme));
        }
        throw this.sme;
    }

    void sendCommand(String topicName, int command, String postfix, byte[] subscriberId, boolean wait, boolean nonDurable, MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "sendCommand(String,int,String,byte [ ],boolean,boolean,MQSession)", new Object[]{topicName, new Integer(command), postfix, subscriberId, wait, nonDurable, session});
        }
        if (this.pubSubSet) {
            try {
                this.pubSubServices.sendCommand(topicName, command, postfix, subscriberId, wait, nonDurable, session);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "sendCommand(String,int,String,byte [ ],boolean,boolean,MQSession)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "sendCommand(String,int,String,byte [ ],boolean,boolean,MQSession)", je, 1);
                }
                throw je;
            }
        } else {
            this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "sendCommand(String,int,String,byte [ ],boolean,boolean,MQSession)", (Throwable)((Object)this.sme), 2);
            }
            throw this.sme;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "sendCommand(String,int,String,byte [ ],boolean,boolean,MQSession)");
        }
    }

    boolean requestResponse(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "requestResponse(MQSession)", new Object[]{session});
        }
        if (this.pubSubSet) {
            try {
                boolean traceRet1 = this.pubSubServices.requestResponse(session);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "requestResponse(MQSession)", traceRet1);
                }
                return traceRet1;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "requestResponse(MQSession)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "requestResponse(MQSession)", je, 1);
                }
                throw je;
            }
        }
        this.sme = new PublishSubscribeSetupException(ConfigEnvironment.newException("MQJMS1111").getMessage());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "requestResponse(MQSession)", (Throwable)((Object)this.sme), 2);
        }
        throw this.sme;
    }

    MQQueue getResponseQueue(MQSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getResponseQueue(MQSession)", new Object[]{session});
        }
        if (this.pubSubSet) {
            try {
                MQQueue traceRet1 = this.pubSubServices.getResponseQueue(session);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getResponseQueue(MQSession)", traceRet1, 1);
                }
                return traceRet1;
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getResponseQueue(MQSession)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getResponseQueue(MQSession)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "getResponseQueue(MQSession)", null, 2);
        }
        return null;
    }

    void initialisePubSub(MQSession session, boolean transacted, int acknowledgeMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "initialisePubSub(MQSession,boolean,int)", new Object[]{session, transacted, new Integer(acknowledgeMode)});
        }
        if (this.pubSubSet) {
            try {
                this.pubSubServices.initialisePubSub(session.connection, transacted, acknowledgeMode, session);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "initialisePubSub(MQSession,boolean,int)", je);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "initialisePubSub(MQSession,boolean,int)", je);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "initialisePubSub(MQSession,boolean,int)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSServicesMgr", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSServicesMgr.java, jmscc.wmq.v6, k701, k701-112-140304  1.18.1.1 09/08/17 08:08:08");
        }
    }
}

