/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;

public class JMSObjectMessage
extends JMSMessage
implements ProviderObjectMessage {
    static final long serialVersionUID = -9160649637541619341L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSObjectMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.19.1.1 09/08/17 08:07:56";
    byte[] messageBytes = null;
    int dataStart;
    boolean readOnly = false;

    public JMSObjectMessage(JMSStringResources jmsStrings) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "<init>(JMSStringResources)", new Object[]{jmsStrings});
        }
        this.messageClass = "jms_object";
        this.jmsStrings = jmsStrings;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "<init>(JMSStringResources)");
        }
    }

    public JMSObjectMessage(JMSStringResources jmsStrings, Serializable object) throws JMSException {
        this(jmsStrings);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "<init>(JMSStringResources,Serializable)", new Object[]{jmsStrings, object});
        }
        this.setObject(object);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "<init>(JMSStringResources,Serializable)");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        if (this.messageBytes != null && this.dataStart != 0) {
            int length = this.messageBytes.length - this.dataStart;
            byte[] t = new byte[length];
            System.arraycopy(this.messageBytes, this.dataStart, t, 0, length);
            this.messageBytes = t;
            this.dataStart = 0;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "_exportBody(int,String)", this.messageBytes);
        }
        return this.messageBytes;
    }

    public void _importBody(byte[] wireformat, int dataStart, int encoding, String charSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "_importBody(byte [ ],int,int,String)", new Object[]{wireformat, new Integer(dataStart), new Integer(encoding), charSet});
        }
        this.messageBytes = wireformat;
        this.dataStart = dataStart;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "_importBody(byte [ ],int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "clearBody()");
        }
        this.readOnly = false;
        this.messageBytes = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "clearBody()");
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable object;
        block11: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()");
            }
            object = null;
            try {
                if (this.messageBytes == null) break block11;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart);
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (Trace.isOn) {
                            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "run()");
                        }
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "run()", cl);
                        }
                        return cl;
                    }
                });
                if (classLoader != null) {
                    MQObjectInputStream objIn = new MQObjectInputStream(inputStream, classLoader);
                    object = (Serializable)objIn.readObject();
                    break block11;
                }
                JMSException jmsEx = this.newMessageFormatException(1024);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()", jmsEx, 1);
                }
                throw jmsEx;
            }
            catch (IOException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()", ex, 1);
                }
                JMSException jmsEx = this.newMessageFormatException(1024);
                jmsEx.setLinkedException((Exception)ex);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()", jmsEx, 2);
                }
                throw jmsEx;
            }
            catch (ClassNotFoundException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()", ex, 2);
                }
                JMSException jmsEx = this.newMessageFormatException(1024);
                jmsEx.setLinkedException((Exception)ex);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()", jmsEx, 3);
                }
                throw jmsEx;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getObject()", object);
        }
        return object;
    }

    public void setObject(Serializable object) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "setObject(Serializable)", new Object[]{object});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "setObject(Serializable)", traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            ByteArrayOutputStream serialisedObject = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(serialisedObject);
            objOut.writeObject(object);
            this.messageBytes = serialisedObject.toByteArray();
            this.dataStart = 0;
            object = null;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "setObject(Serializable)", ex);
            }
            JMSException jmsEx = this.newMessageFormatException(1023);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "setObject(Serializable)", jmsEx, 2);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "setObject(Serializable)");
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.toString());
        retval.append("\n");
        try {
            Serializable object = this.getObject();
            if (object == null) {
                retval.append("<null>");
            } else {
                retval.append(object.getClass());
            }
        }
        catch (JMSException ex) {
            retval.append(this.jmsStrings.getMessage(1025, (Object)ex));
            retval.append(">");
        }
        String traceRet1 = retval.toString();
        return traceRet1;
    }

    void _setBodyReadOnly() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "_setBodyReadOnly()");
        }
        this.readOnly = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "_setBodyReadOnly()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        if (this.messageClass.equals("jms_object")) {
            this.messageClass = "jms_object";
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    public void setSerializedObject(byte[] objectBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "setSerializedObject(byte [ ])", "setter", objectBytes);
        }
        this._importBody(objectBytes, 0, 0, "");
    }

    public byte[] getSerializedObject() throws JMSException {
        byte[] traceRet1 = this._exportBody(0, "");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "getSerializedObject()", "getter", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSObjectMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.19.1.1 09/08/17 08:07:56");
        }
    }
}

