/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSAcknowledgePoint;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSNullMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ResourceAllocationException;

public abstract class JMSMessage
implements JmsPropertyContext,
ProviderMessage,
Serializable {
    static final long serialVersionUID = -4436266789041169376L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.60.1.7 13/05/30 12:59:53";
    public static final String trimJMSXUserID = "com.ibm.mq.jms.trimJMSXUserID";
    String messageClass = "jms_none";
    public static final String CLASS_NONE = "jms_none";
    public static final String CLASS_TEXT = "jms_text";
    public static final String CLASS_OBJECT = "jms_object";
    public static final String CLASS_MAP = "jms_map";
    public static final String CLASS_STREAM = "jms_stream";
    public static final String CLASS_BYTES = "jms_bytes";
    private static final String MCD_CLASS_NONE = "<mcd><Msd>jms_none</Msd></mcd>";
    private static final String MCD_CLASS_TEXT = "<mcd><Msd>jms_text</Msd></mcd>";
    private static final String MCD_CLASS_OBJECT = "<mcd><Msd>jms_object</Msd></mcd>";
    private static final String MCD_CLASS_MAP = "<mcd><Msd>jms_map</Msd></mcd>";
    private static final String MCD_CLASS_STREAM = "<mcd><Msd>jms_stream</Msd></mcd>";
    private static final String MCD_CLASS_BYTES = "<mcd><Msd>jms_bytes</Msd></mcd>";
    private static final String MCD_CLASS_TEXT_NULL_MSG = "<mcd><Msd>jms_text</Msd><msgbody xsi:nil=\"true\"></msgbody></mcd>";
    private static final byte[] OPEN_MCDMSD;
    private static final byte[] CLOSE_MSDMCD;
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final String CHARSET_PROPERTY = "JMS_IBM_Character_Set";
    private static final char[] BIN2HEX;
    private transient JMSAcknowledgePoint session = null;
    private boolean gotByConsume = false;
    transient JMSStringResources jmsStrings = null;
    private String jmsStringResourcesClassName;
    private boolean propertiesReadOnly = false;
    protected Map properties = Collections.synchronizedMap(new HashMap());
    private String correlationId = null;
    private byte[] nativeCorrelId = null;
    private int deliveryMode = 2;
    private boolean hideDeliveryMode = false;
    private long expiration = 0L;
    private long timeToLive = 0L;
    private int priority = 4;
    private boolean redelivered = false;
    private long timestamp = 0L;
    private String type = null;
    private transient MQSession destinationFactory = null;
    private ProviderDestination destination = null;
    private transient String destinationString = null;
    private ProviderDestination replyTo = null;
    private transient String replyToString = null;
    private String messageId = null;
    private byte[] nativeMessageId = null;
    private String msDomain = null;
    private String msFormat = null;
    private String msSet = null;
    private String msType = null;
    private String psTopic = null;
    private String psConnID = null;
    boolean isNullMessage = true;
    private static Object HELD_INTERNAL;
    private transient byte[] userIDAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private transient byte[] putApplNameAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private transient byte[] putDateAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private transient byte[] putTimeAsBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32};
    private transient int deliveryCountAsInt;
    private transient int msgTypeAsInt;
    private transient int groupSeqAsInt;
    private transient int putApplTypeAsInt;
    private transient int feedbackAsInt;
    private transient int reportExceptionAsInt;
    private transient int reportExpirationAsInt;
    private transient int reportCOAAsInt;
    private transient int reportCODAsInt;
    private transient int reportPANAsInt;
    private transient int reportNANAsInt;
    private transient int passCorrelIDAsInt;
    private transient int reportMsgIDAsInt;
    private transient int reportDiscardAsInt;
    private transient boolean lastMsgInGroupAsBool;
    private int ccsidForStrings;
    private boolean ccsidForStringsIsAscii;
    private boolean stringsNeedCcsidConversion;
    private String cachedCcsidAsStr = null;
    private String armCorrelator = null;
    private String wrmCorrelator = null;

    private String convertBytesToString(byte[] b, boolean isInvariant) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "convertBytesToString(byte [ ],boolean)", new Object[]{b, isInvariant});
        }
        String retVal = null;
        boolean canDoQuickConversion = false;
        if (this.stringsNeedCcsidConversion) {
            if (this.ccsidForStringsIsAscii) {
                if (isInvariant) {
                    canDoQuickConversion = true;
                } else {
                    canDoQuickConversion = true;
                    for (int i = 0; i < b.length && canDoQuickConversion; ++i) {
                        canDoQuickConversion = b[i] >= 0;
                    }
                }
            }
        } else {
            canDoQuickConversion = true;
        }
        if (canDoQuickConversion) {
            String s = "";
            for (int i = 0; i < b.length; ++i) {
                s = s + (char)b[i];
            }
            retVal = s;
        } else {
            if (this.cachedCcsidAsStr == null) {
                this.cachedCcsidAsStr = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (int)this.ccsidForStrings).charsetId;
                if (this.cachedCcsidAsStr == null) {
                    this.cachedCcsidAsStr = String.valueOf(this.ccsidForStrings);
                }
            }
            try {
                retVal = new String(b, this.cachedCcsidAsStr);
            }
            catch (UnsupportedEncodingException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "convertBytesToString(byte [ ],boolean)", e);
                }
                this.cachedCcsidAsStr = null;
                JMSException traceRet1 = this.newJMSException(1001);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "convertBytesToString(byte [ ],boolean)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "convertBytesToString(byte [ ],boolean)", retVal);
        }
        return retVal;
    }

    public void _setCcsidForStrings(int _ccsid, boolean _ccsidIsAscii, boolean _stringsNeedCcsidConversion) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setCcsidForStrings(int,boolean,boolean)", new Object[]{new Integer(_ccsid), _ccsidIsAscii, _stringsNeedCcsidConversion});
        }
        this.ccsidForStrings = _ccsid;
        this.ccsidForStringsIsAscii = _ccsidIsAscii;
        this.stringsNeedCcsidConversion = _stringsNeedCcsidConversion;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setCcsidForStrings(int,boolean,boolean)");
        }
    }

    private Object getInternalPropForName(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getInternalPropForName(String)", new Object[]{name});
        }
        Object retVal = null;
        if (name.equals("JMSXUserID")) {
            retVal = this.convertBytesToString(this.userIDAsBytes, false);
            PropertyStore.register(trimJMSXUserID, false);
            boolean isTrim = PropertyStore.getBooleanProperty(trimJMSXUserID);
            if (isTrim && retVal != null) {
                retVal = ((String)retVal).trim();
                if (Trace.isOn) {
                    Trace.data(this, "getInternalPropForName(String)", "JMXUserID without pad", retVal);
                }
            }
        } else if (name.equals("JMSXAppID")) {
            retVal = this.convertBytesToString(this.putApplNameAsBytes, false);
        } else if (name.equals("JMS_IBM_PutDate")) {
            retVal = this.convertBytesToString(this.putDateAsBytes, true);
        } else if (name.equals("JMS_IBM_PutTime")) {
            retVal = this.convertBytesToString(this.putTimeAsBytes, true);
        } else if (name.equals("JMSXDeliveryCount")) {
            retVal = new Integer(this.deliveryCountAsInt);
        } else if (name.equals("JMS_IBM_MsgType")) {
            retVal = new Integer(this.msgTypeAsInt);
        } else if (name.equals("JMSXGroupSeq")) {
            retVal = new Integer(this.groupSeqAsInt);
        } else if (name.equals("JMS_IBM_PutApplType")) {
            retVal = new Integer(this.putApplTypeAsInt);
        } else if (name.equals("JMS_IBM_Feedback")) {
            retVal = new Integer(this.feedbackAsInt);
        } else if (name.equals("JMS_IBM_Report_Exception")) {
            retVal = new Integer(this.reportExceptionAsInt);
        } else if (name.equals("JMS_IBM_Report_Expiration")) {
            retVal = new Integer(this.reportExpirationAsInt);
        } else if (name.equals("JMS_IBM_Report_COA")) {
            retVal = new Integer(this.reportCOAAsInt);
        } else if (name.equals("JMS_IBM_Report_COD")) {
            retVal = new Integer(this.reportCODAsInt);
        } else if (name.equals("JMS_IBM_Report_PAN")) {
            retVal = new Integer(this.reportPANAsInt);
        } else if (name.equals("JMS_IBM_Report_NAN")) {
            retVal = new Integer(this.reportNANAsInt);
        } else if (name.equals("JMS_IBM_Report_Pass_Correl_ID")) {
            retVal = new Integer(this.passCorrelIDAsInt);
        } else if (name.equals("JMS_IBM_Report_Pass_Msg_ID")) {
            retVal = new Integer(this.reportMsgIDAsInt);
        } else if (name.equals("JMS_IBM_Report_Discard_Msg")) {
            retVal = new Integer(this.reportDiscardAsInt);
        } else if (name.equals("JMS_IBM_Last_Msg_In_Group")) {
            retVal = new Boolean(this.lastMsgInGroupAsBool);
        } else if (name.equals("JMS_IBM_ArmCorrelator")) {
            retVal = this._getJMSIBMArmCorrelator();
        } else if (name.equals("JMS_IBM_RMCorrelator")) {
            retVal = this._getJMSIBMWrmCorrelator();
        } else {
            JMSException traceRet1 = this.newJMSException(1001);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getInternalPropForName(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getInternalPropForName(String)", retVal);
        }
        return retVal;
    }

    public void _setJMSXUserIDFromBytes(byte[] id) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXUserIDFromBytes(byte [ ])", new Object[]{id});
        }
        int length = Math.min(id.length, this.userIDAsBytes.length);
        System.arraycopy(id, 0, this.userIDAsBytes, 0, length);
        this.properties.put("JMSXUserID", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXUserIDFromBytes(byte [ ])");
        }
    }

    public void _setJMSXPutAppIDFromBytes(byte[] id) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXPutAppIDFromBytes(byte [ ])", new Object[]{id});
        }
        int length = Math.min(id.length, this.putApplNameAsBytes.length);
        System.arraycopy(id, 0, this.putApplNameAsBytes, 0, length);
        this.properties.put("JMSXAppID", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXPutAppIDFromBytes(byte [ ])");
        }
    }

    public void _setJMSXDeliveryCountFromInt(int c) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXDeliveryCountFromInt(int)", new Object[]{new Integer(c)});
        }
        this.deliveryCountAsInt = c;
        this.properties.put("JMSXDeliveryCount", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXDeliveryCountFromInt(int)");
        }
    }

    public void _setJMSIBMMsgTypeFromInt(int t) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMMsgTypeFromInt(int)", new Object[]{new Integer(t)});
        }
        this.msgTypeAsInt = t;
        this.properties.put("JMS_IBM_MsgType", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMMsgTypeFromInt(int)");
        }
    }

    public int _getJMSIBMMsgTypeAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMMsgTypeAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_MsgType") == HELD_INTERNAL ? this.msgTypeAsInt : this.getIntProperty("JMS_IBM_MsgType");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMMsgTypeAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSXGroupSeqFromInt(int g) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXGroupSeqFromInt(int)", new Object[]{new Integer(g)});
        }
        this.groupSeqAsInt = g;
        this.properties.put("JMSXGroupSeq", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXGroupSeqFromInt(int)");
        }
    }

    public int _getJMSXGroupSeqAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSXGroupSeqAsInt()");
        }
        int retVal = this.properties.get("JMSXGroupSeq") == HELD_INTERNAL ? this.groupSeqAsInt : this.getIntProperty("JMSXGroupSeq");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSXGroupSeqAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMPutDateFromBytes(byte[] b) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPutDateFromBytes(byte [ ])", new Object[]{b});
        }
        int length = Math.min(b.length, this.putDateAsBytes.length);
        System.arraycopy(b, 0, this.putDateAsBytes, 0, length);
        this.properties.put("JMS_IBM_PutDate", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPutDateFromBytes(byte [ ])");
        }
    }

    public void _setJMSIBMPutTimeFromBytes(byte[] b) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPutTimeFromBytes(byte [ ])", new Object[]{b});
        }
        int length = Math.min(b.length, this.putTimeAsBytes.length);
        System.arraycopy(b, 0, this.putTimeAsBytes, 0, length);
        this.properties.put("JMS_IBM_PutTime", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPutTimeFromBytes(byte [ ])");
        }
    }

    public void _setJMSIBMPutApplTypeFromInt(int t) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPutApplTypeFromInt(int)", new Object[]{new Integer(t)});
        }
        this.putApplTypeAsInt = t;
        this.properties.put("JMS_IBM_PutApplType", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPutApplTypeFromInt(int)");
        }
    }

    public void _setJMSIBMFeedbackFromInt(int f) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMFeedbackFromInt(int)", new Object[]{new Integer(f)});
        }
        this.feedbackAsInt = f;
        this.properties.put("JMS_IBM_Feedback", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMFeedbackFromInt(int)");
        }
    }

    public int _getJMSIBMFeedbackAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMFeedbackAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Feedback") == HELD_INTERNAL ? this.feedbackAsInt : this.getIntProperty("JMS_IBM_Feedback");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMFeedbackAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportExceptionFromInt(int r) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportExceptionFromInt(int)", new Object[]{new Integer(r)});
        }
        this.reportExceptionAsInt = r;
        this.properties.put("JMS_IBM_Report_Exception", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportExceptionFromInt(int)");
        }
    }

    public int _getJMSIBMReportExceptionAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportExceptionAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_Exception") == HELD_INTERNAL ? this.reportExceptionAsInt : this.getIntProperty("JMS_IBM_Report_Exception");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportExceptionAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportExpirationFromInt(int e) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportExpirationFromInt(int)", new Object[]{new Integer(e)});
        }
        this.reportExpirationAsInt = e;
        this.properties.put("JMS_IBM_Report_Expiration", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportExpirationFromInt(int)");
        }
    }

    public int _getJMSIBMReportExpirationAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportExpirationAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_Expiration") == HELD_INTERNAL ? this.reportExpirationAsInt : this.getIntProperty("JMS_IBM_Report_Expiration");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportExpirationAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportCOAFromInt(int r) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportCOAFromInt(int)", new Object[]{new Integer(r)});
        }
        this.reportCOAAsInt = r;
        this.properties.put("JMS_IBM_Report_COA", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportCOAFromInt(int)");
        }
    }

    public int _getJMSIBMReportCOAAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportCOAAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_COA") == HELD_INTERNAL ? this.reportCOAAsInt : this.getIntProperty("JMS_IBM_Report_COA");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportCOAAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportCODFromInt(int r) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportCODFromInt(int)", new Object[]{new Integer(r)});
        }
        this.reportCODAsInt = r;
        this.properties.put("JMS_IBM_Report_COD", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportCODFromInt(int)");
        }
    }

    public int _getJMSIBMReportCODAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportCODAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_COD") == HELD_INTERNAL ? this.reportCODAsInt : this.getIntProperty("JMS_IBM_Report_COD");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportCODAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportPANFromInt(int r) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportPANFromInt(int)", new Object[]{new Integer(r)});
        }
        this.reportPANAsInt = r;
        this.properties.put("JMS_IBM_Report_PAN", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportPANFromInt(int)");
        }
    }

    public int _getJMSIBMReportPANAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportPANAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_PAN") == HELD_INTERNAL ? this.reportPANAsInt : this.getIntProperty("JMS_IBM_Report_PAN");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportPANAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportNANFromInt(int r) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportNANFromInt(int)", new Object[]{new Integer(r)});
        }
        this.reportNANAsInt = r;
        this.properties.put("JMS_IBM_Report_NAN", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportNANFromInt(int)");
        }
    }

    public int _getJMSIBMReportNANAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportNANAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_NAN") == HELD_INTERNAL ? this.reportNANAsInt : this.getIntProperty("JMS_IBM_Report_NAN");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportNANAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMPassCorrelIDFromInt(int c) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPassCorrelIDFromInt(int)", new Object[]{new Integer(c)});
        }
        this.passCorrelIDAsInt = c;
        this.properties.put("JMS_IBM_Report_Pass_Correl_ID", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMPassCorrelIDFromInt(int)");
        }
    }

    public int _getJMSIBMPassCorrelIDAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMPassCorrelIDAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_Pass_Correl_ID") == HELD_INTERNAL ? this.passCorrelIDAsInt : this.getIntProperty("JMS_IBM_Report_Pass_Correl_ID");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMPassCorrelIDAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportMsgIDFromInt(int i) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportMsgIDFromInt(int)", new Object[]{new Integer(i)});
        }
        this.reportMsgIDAsInt = i;
        this.properties.put("JMS_IBM_Report_Pass_Msg_ID", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportMsgIDFromInt(int)");
        }
    }

    public int _getJMSIBMReportMsgIDAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportMsgIDAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_Pass_Msg_ID") == HELD_INTERNAL ? this.reportMsgIDAsInt : this.getIntProperty("JMS_IBM_Report_Pass_Msg_ID");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportMsgIDAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMReportDiscardFromInt(int d) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportDiscardFromInt(int)", new Object[]{new Integer(d)});
        }
        this.reportDiscardAsInt = d;
        this.properties.put("JMS_IBM_Report_Discard_Msg", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMReportDiscardFromInt(int)");
        }
    }

    public int _getJMSIBMReportDiscardAsInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportDiscardAsInt()");
        }
        int retVal = this.properties.get("JMS_IBM_Report_Discard_Msg") == HELD_INTERNAL ? this.reportDiscardAsInt : this.getIntProperty("JMS_IBM_Report_Discard_Msg");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMReportDiscardAsInt()", new Integer(retVal));
        }
        return retVal;
    }

    public void _setJMSIBMLastMsgInGroupFromBool(boolean l) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMLastMsgInGroupFromBool(boolean)", new Object[]{l});
        }
        this.lastMsgInGroupAsBool = l;
        this.properties.put("JMS_IBM_Last_Msg_In_Group", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMLastMsgInGroupFromBool(boolean)");
        }
    }

    public boolean _getJMSIBMLastMsgInGroupAsBool() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMLastMsgInGroupAsBool()");
        }
        boolean retVal = this.properties.get("JMS_IBM_Last_Msg_In_Group") == HELD_INTERNAL ? this.lastMsgInGroupAsBool : this.getBooleanProperty("JMS_IBM_Last_Msg_In_Group");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMLastMsgInGroupAsBool()", retVal);
        }
        return retVal;
    }

    public JMSMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "<init>()");
        }
    }

    public static JMSMessage _copyFromMessage(ProviderSession session, ProviderMessage inputMsg) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_copyFromMessage(ProviderSession,ProviderMessage)", new Object[]{session, inputMsg});
        }
        JMSMessage outputMsg = null;
        if (inputMsg instanceof ProviderTextMessage) {
            ProviderTextMessage textMsg = ((MQSession)session).createTextMessage();
            textMsg.setText(((ProviderTextMessage)inputMsg).getText());
            outputMsg = (JMSMessage)((Object)textMsg);
        } else if (inputMsg instanceof ProviderBytesMessage) {
            int bytesRead;
            ProviderBytesMessage bytesMsg = ((MQSession)session).createBytesMessage();
            ((JMSBytesMessage)inputMsg).reset();
            byte[] copyBuffer = new byte[4000];
            while ((bytesRead = ((JMSBytesMessage)inputMsg).readBytes(copyBuffer)) >= 0) {
                ((JMSBytesMessage)bytesMsg).writeBytes(copyBuffer, 0, bytesRead);
            }
            outputMsg = (JMSMessage)((Object)bytesMsg);
        } else if (inputMsg instanceof ProviderMapMessage) {
            ProviderMapMessage mapMsg = ((MQSession)session).createMapMessage();
            Enumeration mapNames = ((ProviderMapMessage)inputMsg).getMapNames();
            while (mapNames.hasMoreElements()) {
                String name = (String)mapNames.nextElement();
                mapMsg.setObject(name, ((ProviderMapMessage)inputMsg).getObject(name));
            }
            outputMsg = (JMSMessage)((Object)mapMsg);
        } else if (inputMsg instanceof ProviderStreamMessage) {
            ProviderStreamMessage streamMsg = ((MQSession)session).createStreamMessage();
            ((ProviderStreamMessage)inputMsg).reset();
            try {
                while (true) {
                    streamMsg.writeObject(((ProviderStreamMessage)inputMsg).readObject());
                }
            }
            catch (MessageEOFException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_copyFromMessage(ProviderSession,ProviderMessage)", ex, 1);
                }
                outputMsg = (JMSMessage)((Object)streamMsg);
            }
        } else if (inputMsg instanceof ProviderObjectMessage) {
            JMSObjectMessage objectMsg = (JMSObjectMessage)((MQSession)session).createObjectMessage();
            objectMsg.setObject(((JMSObjectMessage)inputMsg).getObject());
            outputMsg = objectMsg;
        } else {
            outputMsg = (JMSMessage)((MQSession)session).createMessage();
        }
        outputMsg.setJMSType(inputMsg.getJMSType());
        outputMsg.setJMSCorrelationID(inputMsg.getJMSCorrelationID());
        String rTo = inputMsg.getJMSReplyToAsString();
        outputMsg.setJMSReplyToAsString(rTo);
        Enumeration propertyNames = inputMsg.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            try {
                outputMsg.setObjectProperty(name, inputMsg.getObjectProperty(name));
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_copyFromMessage(ProviderSession,ProviderMessage)", e, 2);
                }
                if (!Trace.isOn) continue;
                Trace.traceData("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "warning: property " + name + " discarded", null);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_copyFromMessage(ProviderSession,ProviderMessage)", outputMsg);
        }
        return outputMsg;
    }

    public abstract byte[] _exportBody(int var1, String var2) throws JMSException;

    public String _getJmsFolder(boolean persistenceFromMD) throws JMSException {
        Object jmsxGroupSeq;
        Object jmsxGroupId;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJmsFolder(boolean)", new Object[]{persistenceFromMD});
        }
        StringBuffer rfhstr = new StringBuffer(100);
        rfhstr.append("<jms>");
        String destString = this.getJMSDestinationAsString();
        if (destString == null) {
            JMSException traceRet1 = this.newJMSException(1001);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJmsFolder(boolean)", traceRet1);
            }
            throw traceRet1;
        }
        this.formatElement("Dst", destString, rfhstr);
        String rToString = this.getJMSReplyToAsString();
        if (rToString != null) {
            this.formatElement("Rto", rToString, rfhstr);
        }
        if (this.timestamp != 0L) {
            rfhstr.append("<Tms>");
            rfhstr.append(String.valueOf(this.timestamp));
            rfhstr.append("</Tms>");
        }
        if (this.expiration != 0L) {
            rfhstr.append("<Exp>");
            rfhstr.append(String.valueOf(this.expiration));
            rfhstr.append("</Exp>");
        }
        if (this.correlationId != null && !this.correlationId.startsWith("ID:")) {
            this.formatElement("Cid", this.correlationId, rfhstr);
        }
        if (this.priority != 4) {
            rfhstr.append("<Pri>");
            rfhstr.append(this.priority);
            rfhstr.append("</Pri>");
        }
        if (!persistenceFromMD && !this.hideDeliveryMode || persistenceFromMD && this.deliveryMode != 2) {
            rfhstr.append("<Dlv>");
            rfhstr.append(this.deliveryMode);
            rfhstr.append("</Dlv>");
        }
        if ((jmsxGroupId = this.getObjectProperty("JMSXGroupID")) instanceof String) {
            this.formatElement("Gid", jmsxGroupId, rfhstr);
        }
        if ((jmsxGroupSeq = this.getObjectProperty("JMSXGroupSeq")) instanceof Integer) {
            this.formatElement("Seq", "", jmsxGroupSeq.toString(), rfhstr);
        }
        rfhstr.append("</jms>");
        String traceRet2 = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJmsFolder(boolean)", traceRet2);
        }
        return traceRet2;
    }

    public String _getMcdFolder() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()");
        }
        if (this.msDomain == null && this.type == null) {
            if (this.messageClass == CLASS_TEXT && this.isNullMessage) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_TEXT_NULL_MSG, 1);
                }
                return MCD_CLASS_TEXT_NULL_MSG;
            }
            if (CLASS_TEXT.equals(this.messageClass) && !this.isNullMessage) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_TEXT, 2);
                }
                return MCD_CLASS_TEXT;
            }
            if (CLASS_BYTES.equals(this.messageClass)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_BYTES, 3);
                }
                return MCD_CLASS_BYTES;
            }
            if (CLASS_NONE.equals(this.messageClass)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_NONE, 4);
                }
                return MCD_CLASS_NONE;
            }
            if (CLASS_OBJECT.equals(this.messageClass)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_OBJECT, 5);
                }
                return MCD_CLASS_OBJECT;
            }
            if (CLASS_MAP.equals(this.messageClass)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_MAP, 6);
                }
                return MCD_CLASS_MAP;
            }
            if (CLASS_STREAM.equals(this.messageClass)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", MCD_CLASS_STREAM, 7);
                }
                return MCD_CLASS_STREAM;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "Unhandled message class type in _getMcdFolder() - " + this.messageClass, null);
            }
            JMSException traceRet1 = this.newJMSException(1001);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", traceRet1);
            }
            throw traceRet1;
        }
        StringBuffer rfhstr = new StringBuffer(40);
        rfhstr.append("<mcd><Msd>");
        if (this.msDomain != null) {
            rfhstr.append(this.msDomain);
            rfhstr.append("</Msd>");
            if (this.msSet != null && this.msSet.length() > 0) {
                this.formatElement("Set", this.msSet, rfhstr);
            }
            if (this.msType != null && this.msType.length() > 0) {
                this.formatElement("Type", this.msType, rfhstr);
            }
            if (this.msFormat != null && this.msFormat.length() > 0) {
                this.formatElement("Fmt", this.msFormat, rfhstr);
            }
        } else {
            rfhstr.append(this.messageClass);
            rfhstr.append("</Msd>");
            if (this.type != null) {
                this.formatElement("Type", this.type, rfhstr);
            }
        }
        if (CLASS_TEXT.equals(this.messageClass) && this.isNullMessage) {
            rfhstr.append("<msgbody xsi:nil=\"true\"></msgbody>");
        }
        rfhstr.append("</mcd>");
        String traceRet2 = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMcdFolder()", traceRet2, 8);
        }
        return traceRet2;
    }

    public String _getPscFolder() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getPscFolder()");
        }
        if (this.psTopic == null || this.psConnID == null) {
            String traceRet2 = "<psc></psc>";
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getPscFolder()", traceRet2, 1);
            }
            return traceRet2;
        }
        StringBuffer rfhstr = new StringBuffer(128);
        rfhstr.append("<psc><Command>Publish</Command><PubOpt>None</PubOpt>");
        rfhstr.append("<Topic>");
        this.backReference(rfhstr, this.psTopic);
        rfhstr.append("</Topic>");
        rfhstr.append("<UNIQUE_CONNECTION_ID>" + this.psConnID + "</UNIQUE_CONNECTION_ID></psc>");
        String traceRet1 = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getPscFolder()", traceRet1, 2);
        }
        return traceRet1;
    }

    public long _getTimeToLive() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getTimeToLive()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getTimeToLive()", new Long(this.timeToLive));
        }
        return this.timeToLive;
    }

    public String _getUsrFolder() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getUsrFolder()");
        }
        StringBuffer rfhstr = new StringBuffer(40);
        Iterator propNames = this.properties.keySet().iterator();
        rfhstr.append("<usr>");
        while (propNames.hasNext()) {
            String name = (String)propNames.next();
            if (name.startsWith("JMS")) continue;
            Object value = this.getObjectProperty(name);
            this.formatElement(name, value, rfhstr);
        }
        rfhstr.append("</usr>");
        String traceRet1 = rfhstr.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getUsrFolder()", traceRet1);
        }
        return traceRet1;
    }

    public String _getMQExtFolder() throws JMSException {
        String traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMQExtFolder()");
        }
        StringBuffer rfhstr = null;
        String armCorrelator = this._getJMSIBMArmCorrelator();
        String wrmCorrelator = this._getJMSIBMWrmCorrelator();
        if (armCorrelator != null || wrmCorrelator != null) {
            rfhstr = new StringBuffer(40);
            rfhstr.append("<mqext>");
            if (armCorrelator != null) {
                this.formatElement("Arm", armCorrelator, rfhstr);
            }
            if (wrmCorrelator != null) {
                this.formatElement("Wrm", wrmCorrelator, rfhstr);
            }
            rfhstr.append("</mqext>");
        }
        String string = traceRet1 = rfhstr != null ? rfhstr.toString() : null;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getMQExtFolder()", traceRet1);
        }
        return traceRet1;
    }

    public static String _idToString(byte[] id) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_idToString(byte [ ])", new Object[]{id});
        }
        if (id == null) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_idToString(byte [ ])", (Object)null, 1);
            }
            return null;
        }
        int len = id.length;
        char[] idchars = new char[3 + 2 * len];
        idchars[0] = 73;
        idchars[1] = 68;
        idchars[2] = 58;
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            int binByte = id[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            idchars[2 * i + 3] = BIN2HEX[binByte / 16];
            idchars[2 * i + 4] = BIN2HEX[binByte % 16];
        }
        if (sum == 0) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_idToString(byte [ ])", (Object)null, 2);
            }
            return null;
        }
        String traceRet1 = new String(idchars);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_idToString(byte [ ])", (Object)traceRet1, 3);
        }
        return traceRet1;
    }

    public abstract void _importBody(byte[] var1, int var2, int var3, String var4) throws JMSException;

    public void _parseJmsFolder(MQSession destFactory, String s, boolean persistenceFromMD) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolder(MQSession,String,boolean)", new Object[]{destFactory, s, persistenceFromMD});
        }
        this.deliveryMode = -2;
        StringTokenizer strtok = new StringTokenizer(s, "<>");
        if (!strtok.nextToken().equals("jms")) {
            JMSException traceRet1 = this.newJMSException(1001);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolder(MQSession,String,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String name = "";
        while (!name.equals("/jms")) {
            String tmp;
            strtok.nextToken("<");
            String token = strtok.nextToken("<");
            int to = token.indexOf(">");
            name = token.substring(0, to);
            String value = token.substring(to + 1);
            if (name.charAt(0) == '/') continue;
            if (name.startsWith("Cid")) {
                this.setJMSCorrelationID((String)this.deformatElement("'string'", value));
            } else if (name.startsWith("Tms")) {
                this.timestamp = Long.parseLong(value);
            } else if (name.startsWith("Exp")) {
                this.expiration = Long.parseLong(value);
            } else if (name.startsWith("Rto")) {
                tmp = (String)this.deformatElement("'string'", value);
                this._setJMSReplyToAsString(destFactory, tmp);
            } else if (name.startsWith("Dst")) {
                tmp = (String)this.deformatElement("'string'", value);
                this._setJMSDestinationAsString(destFactory, tmp);
            } else if (!persistenceFromMD && name.startsWith("Dlv")) {
                this.deliveryMode = Integer.parseInt(value);
            } else if (name.startsWith("Gid")) {
                this.setObjectProperty("JMSXGroupID", this.deformatElement("'string'", value));
            } else if (name.startsWith("Seq")) {
                this.setObjectProperty("JMSXGroupSeq", this.deformatElement("'i4'", value));
            }
            if ((token = strtok.nextToken(">")).charAt(1) == '/') continue;
            JMSException traceRet2 = this.newMessageFormatException(1012);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolder(MQSession,String,boolean)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolder(MQSession,String,boolean)");
        }
    }

    public void _parseJmsFolderUtf8(byte[] rawData, int offset, int length, MQSession destFactory, boolean persistenceFromMD) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolderUtf8(byte [ ],int,int,MQSession,boolean)", new Object[]{rawData, new Integer(offset), new Integer(length), destFactory, persistenceFromMD});
        }
        try {
            this.deliveryMode = -2;
            while (rawData[offset + (length - 1)] != 62) {
                --length;
            }
            byte[] openJmsTag = new byte[]{60, 106, 109, 115, 62};
            byte[] closeJmsTag = new byte[]{60, 47, 106, 109, 115, 62};
            for (int i = 0; i < openJmsTag.length; ++i) {
                if (rawData[offset + i] == openJmsTag[i]) continue;
                JMSException traceRet1 = this.newMessageFormatException(1012);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolderUtf8(byte [ ],int,int,MQSession,boolean)", traceRet1, 1);
                }
                throw traceRet1;
            }
            int j = offset + length - closeJmsTag.length;
            for (int i = 0; i < closeJmsTag.length; ++i) {
                if (rawData[j] != closeJmsTag[i]) {
                    JMSException traceRet2 = this.newMessageFormatException(1012);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolderUtf8(byte [ ],int,int,MQSession,boolean)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
                ++j;
            }
            int TAG_VALUE_DST = 0x447374;
            int TAG_VALUE_TMS = 5533043;
            int TAG_VALUE_EXP = 4552816;
            int TAG_VALUE_PRI = 5272169;
            int TAG_VALUE_DLV = 4484214;
            int TAG_VALUE_CID = 4417892;
            int TAG_VALUE_RTO = 5403759;
            int TAG_VALUE_GID = 4680036;
            int TAG_VALUE_SEQ = 5465457;
            int index = offset + openJmsTag.length;
            int folderEnd = offset + length - closeJmsTag.length;
            block16: while (index < folderEnd) {
                while (rawData[index] != 60) {
                    ++index;
                }
                ++index;
                int elementNameValue = 0;
                boolean endOfName = false;
                while (rawData[index] != 62) {
                    if (rawData[index] == 32) {
                        endOfName = true;
                    }
                    if (!endOfName) {
                        char c = (char)rawData[index];
                        if (c < '\u0000') {
                            c = (char)(c + 256);
                        }
                        elementNameValue = (elementNameValue << 8) + c;
                    }
                    ++index;
                }
                int elementStart = ++index;
                while (rawData[index] != 62) {
                    ++index;
                }
                int elementEnd = index;
                while (rawData[elementEnd] != 60) {
                    --elementEnd;
                }
                int elementLen = elementEnd - elementStart;
                while (rawData[index] != 60) {
                    ++index;
                }
                switch (elementNameValue) {
                    case 0x447374: {
                        String dstString = this.safeUTF8ToString(rawData, elementStart, elementLen);
                        this._setJMSDestinationAsString(destFactory, dstString);
                        continue block16;
                    }
                    case 5533043: {
                        this.timestamp = this.utf8ToLong(rawData, elementStart, elementLen);
                        continue block16;
                    }
                    case 4552816: {
                        this.expiration = this.utf8ToLong(rawData, elementStart, elementLen);
                        continue block16;
                    }
                    case 5272169: {
                        continue block16;
                    }
                    case 4484214: {
                        if (persistenceFromMD) continue block16;
                        this.deliveryMode = this.utf8ToInt(rawData, elementStart, elementLen);
                        continue block16;
                    }
                    case 4417892: {
                        String cidString = this.unsafeUTF8ToString(rawData, elementStart, elementLen);
                        this.setJMSCorrelationID(cidString);
                        continue block16;
                    }
                    case 5403759: {
                        String rtoString = this.safeUTF8ToString(rawData, elementStart, elementLen);
                        this._setJMSReplyToAsString(destFactory, rtoString);
                        continue block16;
                    }
                    case 4680036: {
                        String gidString = this.safeUTF8ToString(rawData, elementStart, elementLen);
                        this.setObjectProperty("JMSXGroupID", gidString);
                        continue block16;
                    }
                    case 5465457: {
                        int seqNum = this.utf8ToInt(rawData, elementStart, elementLen);
                        this.setObjectProperty("JMSXGroupSeq", new Integer(seqNum));
                        continue block16;
                    }
                }
                if (!Trace.isOn) continue;
                Trace.traceData(this, "unknown element name in jms folder: " + Integer.toHexString(elementNameValue), null);
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolderUtf8(byte [ ],int,int,MQSession,boolean)", aioobe);
            }
            JMSException traceRet3 = this.newMessageFormatException(1012);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolderUtf8(byte [ ],int,int,MQSession,boolean)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseJmsFolderUtf8(byte [ ],int,int,MQSession,boolean)");
        }
    }

    public void _parseMQExtFolder(String s) throws JMSException {
        StringTokenizer strtok;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolder(String)", new Object[]{s});
        }
        if (!(strtok = new StringTokenizer(s, "<>")).nextToken().equals("mqext")) {
            JMSException traceRet1 = this.newJMSException(1001);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolder(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String name = strtok.nextToken();
        while (!name.equals("/mqext")) {
            String token = strtok.nextToken();
            String value = token.charAt(0) == '/' ? "" : token;
            if (name.startsWith("Arm")) {
                this._setJMSIBMArmCorrelator((String)this.deformatElement("'string'", value));
            } else if (name.startsWith("Wrm")) {
                this._setJMSIBMWrmCorrelator((String)this.deformatElement("'string'", value));
            }
            if (token.charAt(0) != '/') {
                token = strtok.nextToken();
            }
            if (token.charAt(0) != '/') {
                JMSException traceRet2 = this.newMessageFormatException(1012);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolder(String)", traceRet2, 2);
                }
                throw traceRet2;
            }
            name = strtok.nextToken();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolder(String)");
        }
    }

    public void _parseMQExtFolderUtf8(byte[] rawData, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolderUtf8(byte [ ],int,int)", new Object[]{rawData, new Integer(offset), new Integer(length)});
        }
        try {
            while (rawData[offset + (length - 1)] != 62) {
                --length;
            }
            byte[] openJmsTag = new byte[]{60, 109, 113, 101, 120, 116, 62};
            byte[] closeJmsTag = new byte[]{60, 47, 109, 113, 101, 120, 116, 62};
            for (int i = 0; i < openJmsTag.length; ++i) {
                if (rawData[offset + i] == openJmsTag[i]) continue;
                JMSException traceRet1 = this.newMessageFormatException(1012);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolderUtf8(byte [ ],int,int)", traceRet1, 1);
                }
                throw traceRet1;
            }
            int j = offset + length - closeJmsTag.length;
            for (int i = 0; i < closeJmsTag.length; ++i) {
                if (rawData[j] != closeJmsTag[i]) {
                    JMSException traceRet2 = this.newMessageFormatException(1012);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolderUtf8(byte [ ],int,int)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
                ++j;
            }
            int TAG_VALUE_ARM = 4289133;
            int TAG_VALUE_WAS = 5730925;
            int index = offset + openJmsTag.length;
            int folderEnd = offset + length - closeJmsTag.length;
            block9: while (index < folderEnd) {
                while (rawData[index] != 60) {
                    ++index;
                }
                ++index;
                int elementNameValue = 0;
                boolean endOfName = false;
                while (rawData[index] != 62) {
                    if (rawData[index] == 32) {
                        endOfName = true;
                    }
                    if (!endOfName) {
                        char c = (char)rawData[index];
                        if (c < '\u0000') {
                            c = (char)(c + 256);
                        }
                        elementNameValue = (elementNameValue << 8) + c;
                    }
                    ++index;
                }
                int elementStart = ++index;
                while (rawData[index] != 62) {
                    ++index;
                }
                int elementEnd = index;
                while (rawData[elementEnd] != 60) {
                    --elementEnd;
                }
                int elementLen = elementEnd - elementStart;
                while (rawData[index] != 60) {
                    ++index;
                }
                switch (elementNameValue) {
                    case 4289133: {
                        String armString = this.safeUTF8ToString(rawData, elementStart, elementLen);
                        this._setJMSIBMArmCorrelator(armString);
                        continue block9;
                    }
                    case 5730925: {
                        String wasString = this.safeUTF8ToString(rawData, elementStart, elementLen);
                        this._setJMSIBMWrmCorrelator(wasString);
                        continue block9;
                    }
                }
                if (!Trace.isOn) continue;
                Trace.traceData(this, "unknown element name in mqext folder: " + Integer.toHexString(elementNameValue), null);
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolderUtf8(byte [ ],int,int)", aioobe);
            }
            JMSException traceRet3 = this.newMessageFormatException(1012);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolderUtf8(byte [ ],int,int)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMQExtFolderUtf8(byte [ ],int,int)");
        }
    }

    private String safeUTF8ToString(byte[] data, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "safeUTF8ToString(byte [ ],int,int)", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        int ESC_AMP = 6385008;
        int ESC_GT = 26484;
        int ESC_LT = 27764;
        int ESC_APOS = 1634758515;
        int ESC_QUOT = 1903521652;
        char[] ch = new char[length];
        int rawIndex = offset;
        int charIndex = 0;
        boolean inEscape = false;
        int escapeVal = 0;
        while (rawIndex - offset < length) {
            byte c = data[rawIndex];
            if (inEscape) {
                if (c == 59) {
                    inEscape = false;
                    switch (escapeVal) {
                        case 6385008: {
                            ch[charIndex] = 38;
                            break;
                        }
                        case 26484: {
                            ch[charIndex] = 62;
                            break;
                        }
                        case 27764: {
                            ch[charIndex] = 60;
                            break;
                        }
                        case 1634758515: {
                            ch[charIndex] = 39;
                            break;
                        }
                        case 1903521652: {
                            ch[charIndex] = 34;
                            break;
                        }
                        default: {
                            JMSException traceRet1 = this.newMessageFormatException(1012);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "safeUTF8ToString(byte [ ],int,int)", traceRet1);
                            }
                            throw traceRet1;
                        }
                    }
                    ++charIndex;
                } else {
                    if (c < 0) {
                        c = (byte)(c + 256);
                    }
                    escapeVal <<= 8;
                    escapeVal += c;
                }
            } else if (c == 38) {
                inEscape = true;
                escapeVal = 0;
            } else {
                ch[charIndex] = (char)data[rawIndex];
                ++charIndex;
            }
            ++rawIndex;
        }
        String traceRet2 = new String(ch, 0, charIndex);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "safeUTF8ToString(byte [ ],int,int)", traceRet2);
        }
        return traceRet2;
    }

    private String unsafeUTF8ToString(byte[] data, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        try {
            for (int i = 0; i < length; ++i) {
                if (data[i + offset] >= 0) continue;
                String traceRet1 = this.expandRefs(new String(data, offset, length, "UTF8"));
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", traceRet1, 1);
                }
                return traceRet1;
            }
            String traceRet2 = this.safeUTF8ToString(data, offset, length);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", traceRet2, 2);
            }
            return traceRet2;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", je, 1);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", je, 1);
            }
            throw je;
        }
        catch (UnsupportedEncodingException ue) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", ue, 2);
            }
            JMSException traceRet3 = this.newMessageFormatException(1012);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "unsafeUTF8ToString(byte [ ],int,int)", traceRet3, 2);
            }
            throw traceRet3;
        }
    }

    private int utf8ToInt(byte[] data, int offset, int length) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "utf8ToInt(byte [ ],int,int)", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        int end = length + offset;
        int total = 0;
        for (int i = offset; i < end; ++i) {
            int digit = data[i] - 48;
            if (digit < 0 || digit >= 10) {
                char[] cdata = new char[length];
                for (int j = 0; j < length; ++j) {
                    cdata[j] = (char)data[offset + j];
                }
                String s = new String(cdata);
                int traceRet1 = Integer.parseInt(s);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "utf8ToInt(byte [ ],int,int)", new Integer(traceRet1), 1);
                }
                return traceRet1;
            }
            total = total * 10 + digit;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "utf8ToInt(byte [ ],int,int)", new Integer(total), 2);
        }
        return total;
    }

    private long utf8ToLong(byte[] data, int offset, int length) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "utf8ToLong(byte [ ],int,int)", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        int end = length + offset;
        long total = 0L;
        for (int i = offset; i < end; ++i) {
            int digit = data[i] - 48;
            if (digit < 0 || digit >= 10) {
                char[] cdata = new char[length];
                for (int j = 0; j < length; ++j) {
                    cdata[j] = (char)data[offset + j];
                }
                String s = new String(cdata);
                long traceRet1 = Long.parseLong(s);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "utf8ToLong(byte [ ],int,int)", new Long(traceRet1), 1);
                }
                return traceRet1;
            }
            total = total * 10L + (long)digit;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "utf8ToLong(byte [ ],int,int)", new Long(total), 2);
        }
        return total;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JMSMessage _parseMcdFolder(ProviderSession session, JMSStringResources jmsStrings, String s, String fbClass, boolean forceBytesMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolder(ProviderSession,JMSStringResources,String,String,boolean)", new Object[]{session, jmsStrings, s, fbClass, forceBytesMessage});
        }
        JMSMessage msg = null;
        if (forceBytesMessage) {
            msg = (JMSMessage)((Object)((MQSession)session).createBytesMessage());
        }
        String jmsType = null;
        String msDomain = null;
        String msSet = null;
        String msFormat = null;
        boolean isNullMsgFlag = false;
        StringTokenizer strtok = new StringTokenizer(s, "<>");
        if (!strtok.nextToken().equals("mcd")) {
            msg = new JMSNullMessage(jmsStrings);
            JMSException traceRet1 = msg.newMessageFormatException(1012);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolder(ProviderSession,JMSStringResources,String,String,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String name = strtok.nextToken();
        while (!name.startsWith("/mcd")) {
            String token;
            String value;
            boolean assumingTypeEmpty;
            block45: {
                block54: {
                    boolean msgbodyField;
                    block44: {
                        block47: {
                            block53: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block48: {
                                                    block46: {
                                                        assumingTypeEmpty = false;
                                                        msgbodyField = false;
                                                        value = strtok.nextToken();
                                                        if (!name.startsWith("msgbody")) break block46;
                                                        msgbodyField = true;
                                                        if (name.indexOf("xsi:nil=\"true\"") != -1) {
                                                            isNullMsgFlag = true;
                                                        }
                                                        if (name.indexOf("xsi:nil='true'") != -1) {
                                                            isNullMsgFlag = true;
                                                        }
                                                        break block44;
                                                    }
                                                    if (!name.startsWith("Msd") || forceBytesMessage) break block47;
                                                    if (!value.equals(CLASS_NONE)) break block48;
                                                    msg = (JMSMessage)((MQSession)session).createMessage();
                                                    break block44;
                                                }
                                                if (!value.equals(CLASS_TEXT)) break block49;
                                                msg = (JMSMessage)((Object)((MQSession)session).createTextMessage());
                                                msg.isNullMessage = false;
                                                break block44;
                                            }
                                            if (!value.equals(CLASS_BYTES)) break block50;
                                            msg = (JMSMessage)((Object)((MQSession)session).createBytesMessage());
                                            break block44;
                                        }
                                        if (!value.equals(CLASS_MAP)) break block51;
                                        msg = (JMSMessage)((Object)((MQSession)session).createMapMessage());
                                        break block44;
                                    }
                                    if (!value.equals(CLASS_STREAM)) break block52;
                                    msg = (JMSMessage)((Object)((MQSession)session).createStreamMessage());
                                    break block44;
                                }
                                if (!value.equals(CLASS_OBJECT)) break block53;
                                msg = (JMSMessage)((Object)((MQSession)session).createObjectMessage());
                                break block44;
                            }
                            msDomain = value;
                            if (CLASS_TEXT.equals(fbClass)) {
                                msg = (JMSMessage)((Object)((MQSession)session).createTextMessage());
                                msg.isNullMessage = false;
                                break block44;
                            } else if (CLASS_BYTES.equals(fbClass)) {
                                msg = (JMSMessage)((Object)((MQSession)session).createBytesMessage());
                                break block44;
                            } else {
                                msg = new JMSNullMessage(jmsStrings);
                                JMSException traceRet2 = msg.newMessageFormatException(1014);
                                if (Trace.isOn) {
                                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolder(ProviderSession,JMSStringResources,String,String,boolean)", traceRet2, 2);
                                }
                                throw traceRet2;
                            }
                        }
                        if (name.startsWith("Type")) {
                            if (value.equals("/Type")) {
                                jmsType = "";
                                assumingTypeEmpty = true;
                            } else {
                                jmsType = value;
                            }
                        } else if (name.startsWith("Set")) {
                            if (value.equals("/Set")) {
                                msSet = "";
                                assumingTypeEmpty = true;
                            } else {
                                msSet = value;
                            }
                        } else if (name.startsWith("Fmt")) {
                            if (value.equals("/Fmt")) {
                                msFormat = "";
                                assumingTypeEmpty = true;
                            } else {
                                msFormat = value;
                            }
                        }
                    }
                    if (!msgbodyField) break block54;
                    if (name.charAt(name.length() - 1) == '/') {
                        assumingTypeEmpty = true;
                        token = value;
                        break block45;
                    } else if (value.equals("/msgbody")) {
                        assumingTypeEmpty = true;
                        token = strtok.nextToken();
                        break block45;
                    } else {
                        token = strtok.nextToken();
                    }
                    break block45;
                }
                token = strtok.nextToken();
            }
            if (assumingTypeEmpty) {
                if (token.equals("/Type") || token.equals("/Set") || token.equals("/Fmt")) {
                    if (token.equals("/Type")) {
                        jmsType = value;
                    } else if (token.equals("/Set")) {
                        msSet = value;
                    } else if (token.equals("/Fmt")) {
                        msFormat = value;
                    }
                    name = strtok.nextToken();
                    continue;
                }
                name = token;
                continue;
            }
            if (token.charAt(0) != '/') {
                msg = new JMSNullMessage(jmsStrings);
                JMSException traceRet3 = msg.newMessageFormatException(1012);
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolder(ProviderSession,JMSStringResources,String,String,boolean)", traceRet3, 3);
                }
                throw traceRet3;
            }
            name = strtok.nextToken();
        }
        if (msDomain != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("mcd://");
            sb.append(msDomain);
            if (msSet != null) {
                sb.append('/');
                sb.append(msSet);
            }
            if (jmsType != null) {
                if (msSet == null) {
                    sb.append('/');
                }
                sb.append('/');
                sb.append(jmsType);
            }
            if (msFormat != null) {
                sb.append("?format=");
                sb.append(msFormat);
            }
            msg.setJMSType(sb.toString());
        } else if (jmsType != null) {
            msg.setJMSType((String)msg.deformatElement("'string'", jmsType));
        }
        msg.isNullMessage = isNullMsgFlag;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolder(ProviderSession,JMSStringResources,String,String,boolean)", msg);
        }
        return msg;
    }

    public static JMSMessage _parseMcdFolderUtf8(ProviderSession session, JMSStringResources jmsStrings, String fbClass, byte[] data, int off, int len, boolean forceBytesMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolderUtf8(ProviderSession,JMSStringResources,String,byte [ ],int,int,boolean)", new Object[]{session, jmsStrings, fbClass, data, new Integer(off), new Integer(len), forceBytesMessage});
        }
        boolean matchFailed = false;
        JMSMessage retMsg = null;
        while (data[off + (len - 1)] != 62) {
            --len;
        }
        int lastByte = off + len - 1;
        if (forceBytesMessage) {
            retMsg = (JMSMessage)((Object)((MQSession)session).createBytesMessage());
        } else if (lastByte < OPEN_MCDMSD.length + CLOSE_MSDMCD.length) {
            matchFailed = true;
        } else if (data[off + 0] == 60 && data[off + 1] == 109 && data[off + 2] == 99 && data[off + 3] == 100 && data[off + 4] == 62 && data[off + 5] == 60 && data[off + 6] == 77 && data[off + 7] == 115 && data[off + 8] == 100 && data[off + 9] == 62 && data[off + 10] == 106 && data[off + 11] == 109 && data[off + 12] == 115 && data[off + 13] == 95 && data[lastByte - 11] == 60 && data[lastByte - 10] == 47 && data[lastByte - 9] == 77 && data[lastByte - 8] == 115 && data[lastByte - 7] == 100 && data[lastByte - 6] == 62 && data[lastByte - 5] == 60 && data[lastByte - 4] == 47 && data[lastByte - 3] == 109 && data[lastByte - 2] == 99 && data[lastByte - 1] == 100) {
            if (data[off + 14] == 110 && data[off + 15] == 111 && data[off + 16] == 110 && data[off + 17] == 101 && lastByte == off + MCD_CLASS_NONE.length() - 1) {
                retMsg = (JMSMessage)((MQSession)session).createMessage();
            } else if (data[off + 14] == 116 && data[off + 15] == 101 && data[off + 16] == 120 && data[off + 17] == 116 && lastByte == off + MCD_CLASS_TEXT.length() - 1) {
                retMsg = (JMSMessage)((Object)((MQSession)session).createTextMessage());
                retMsg.isNullMessage = false;
            } else if (data[off + 14] == 111 && data[off + 15] == 98 && data[off + 16] == 106 && data[off + 17] == 101 && data[off + 18] == 99 && data[off + 19] == 116 && lastByte == off + MCD_CLASS_OBJECT.length() - 1) {
                retMsg = (JMSMessage)((Object)((MQSession)session).createObjectMessage());
            } else if (data[off + 14] == 109 && data[off + 15] == 97 && data[off + 16] == 112 && lastByte == off + MCD_CLASS_MAP.length() - 1) {
                retMsg = (JMSMessage)((Object)((MQSession)session).createMapMessage());
            } else if (data[off + 14] == 115 && data[off + 15] == 116 && data[off + 16] == 114 && data[off + 17] == 101 && data[off + 18] == 97 && data[off + 19] == 109 && lastByte == off + MCD_CLASS_STREAM.length() - 1) {
                retMsg = (JMSMessage)((Object)((MQSession)session).createStreamMessage());
            } else if (data[off + 14] == 98 && data[off + 15] == 121 && data[off + 16] == 116 && data[off + 17] == 101 && data[off + 18] == 115 && lastByte == off + MCD_CLASS_BYTES.length() - 1) {
                retMsg = (JMSMessage)((Object)((MQSession)session).createBytesMessage());
            } else {
                matchFailed = true;
            }
        } else {
            matchFailed = true;
        }
        if (matchFailed) {
            String mcdStr = null;
            try {
                mcdStr = new String(data, off, len, "UTF8");
            }
            catch (UnsupportedEncodingException ue) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolderUtf8(ProviderSession,JMSStringResources,String,byte [ ],int,int,boolean)", ue);
                }
                int key = 1012;
                MessageFormatException traceRet1 = new MessageFormatException(jmsStrings.getErrorMessage(key), jmsStrings.getNativeKey(key));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolderUtf8(ProviderSession,JMSStringResources,String,byte [ ],int,int,boolean)", (Throwable)traceRet1);
                }
                throw traceRet1;
            }
            retMsg = JMSMessage._parseMcdFolder(session, jmsStrings, mcdStr, fbClass, forceBytesMessage);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseMcdFolderUtf8(ProviderSession,JMSStringResources,String,byte [ ],int,int,boolean)", retMsg);
        }
        return retMsg;
    }

    public void _parseUsrFolder(String s) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", new Object[]{s});
        }
        try {
            StringTokenizer strtok = new StringTokenizer(s, "<>");
            if (!strtok.nextToken().equals("usr")) {
                JMSException traceRet1 = this.newJMSException(1001);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", traceRet1, 1);
                }
                throw traceRet1;
            }
            String name = strtok.nextToken();
            while (!name.equals("/usr")) {
                String value;
                boolean newNull = false;
                int nullIndex = 0;
                try {
                    nullIndex = name.indexOf(" xsi:nil");
                    if (nullIndex != -1) {
                        int dtindex = name.indexOf(" dt=");
                        if (dtindex != -1 && dtindex < nullIndex) {
                            nullIndex = dtindex;
                        }
                        newNull = true;
                    } else {
                        newNull = false;
                    }
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", e, 1);
                    }
                    newNull = false;
                }
                if (newNull) {
                    int firstSpace = name.indexOf(32);
                    this.setObjectProperty(name.substring(0, firstSpace), null);
                    if (name.charAt(name.length() - 1) != '/') {
                        value = strtok.nextToken();
                        if (value.charAt(0) != '/') {
                            value = strtok.nextToken();
                        }
                        if (value.charAt(0) != '/') {
                            JMSException traceRet2 = this.newMessageFormatException(1012);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", traceRet2, 2);
                            }
                            throw traceRet2;
                        }
                    }
                } else if (!newNull) {
                    String type;
                    boolean endsWithSlash = name.charAt(name.length() - 1) == '/';
                    int index = name.indexOf(" dt=");
                    if (index != -1) {
                        type = name.substring(index + 4, name.length() - (endsWithSlash ? 1 : 0));
                        int firstSpace = name.indexOf(32);
                        name = name.substring(0, firstSpace);
                    } else {
                        if (endsWithSlash) {
                            name = name.substring(0, name.length() - 1);
                        }
                        type = "'string'";
                    }
                    if (endsWithSlash) {
                        this.setObjectProperty(name, this.deformatElement(type, ""));
                    } else {
                        String token;
                        value = strtok.nextToken();
                        if (value.startsWith('/' + name) && !value.equals('/' + name)) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "startsWith /: " + name + " Type : " + type + " value : " + value, null);
                            }
                            this.setObjectProperty(name, this.deformatElement(type, value));
                            token = strtok.nextToken();
                            if (token.charAt(0) != '/') {
                                JMSException traceRet3 = this.newMessageFormatException(1012);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", traceRet3, 3);
                                }
                                throw traceRet3;
                            }
                        } else if (value.startsWith('/' + name)) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "startsWith / 2 ", null);
                            }
                            this.setObjectProperty(name, this.deformatElement(type, ""));
                        } else {
                            if (Trace.isOn) {
                                Trace.traceData(this, "!!startsWith ", null);
                            }
                            this.setObjectProperty(name, this.deformatElement(type, value));
                            token = strtok.nextToken();
                            if (token.charAt(0) != '/') {
                                JMSException traceRet4 = this.newMessageFormatException(1012);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", traceRet4, 4);
                                }
                                throw traceRet4;
                            }
                        }
                    }
                }
                name = strtok.nextToken();
            }
        }
        catch (Exception ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", ex, 2);
            }
            JMSException jmsEx = this.newMessageFormatException(1012);
            jmsEx.setLinkedException(ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)", jmsEx, 5);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_parseUsrFolder(String)");
        }
    }

    public void _setJMSMessageIDAsBytes(byte[] messageId) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSMessageIDAsBytes(byte [ ])", new Object[]{messageId});
        }
        this.messageId = null;
        this.nativeMessageId = messageId;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSMessageIDAsBytes(byte [ ])");
        }
    }

    public void _setJMSXObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXObjectProperty(String,Object)", new Object[]{name, value});
        }
        this.properties.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSXObjectProperty(String,Object)");
        }
    }

    public void _setReadOnly() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setReadOnly()");
        }
        this.propertiesReadOnly = true;
        this._setBodyReadOnly();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setReadOnly()");
        }
    }

    abstract void _setBodyReadOnly();

    public void _setSession(JMSAcknowledgePoint session) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setSession(JMSAcknowledgePoint)", new Object[]{session});
        }
        this.session = session;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setSession(JMSAcknowledgePoint)");
        }
    }

    public void _setTimeToLive(long currentTime, long timeToLive) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setTimeToLive(long,long)", new Object[]{new Long(currentTime), new Long(timeToLive)});
        }
        this.expiration = timeToLive == 0L ? 0L : timeToLive + currentTime;
        this.timeToLive = timeToLive;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setTimeToLive(long,long)");
        }
    }

    public byte[] _stringToId(String idString) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_stringToId(String)", new Object[]{idString});
        }
        byte[] traceRet1 = this.hexToBin(idString, 3);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_stringToId(String)", traceRet1);
        }
        return traceRet1;
    }

    public void acknowledge() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "acknowledge()");
        }
        if (this.session == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "acknowledge() not valid for this session type (session is null)", null);
            }
        } else {
            this.session._acknowledge(this.gotByConsume);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "acknowledge()");
        }
    }

    void backReference(StringBuffer sb, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "backReference(StringBuffer,String)", new Object[]{sb, string});
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                sb.append("&lt;");
                continue;
            }
            if ('>' == ch) {
                sb.append("&gt;");
                continue;
            }
            if ('&' == ch) {
                sb.append("&amp;");
                continue;
            }
            if ('\"' == ch) {
                sb.append("&quot;");
                continue;
            }
            if ('\'' == ch) {
                sb.append("&apos;");
                continue;
            }
            if ('\ud800' <= ch && ch < '\udc00') {
                int next;
                if (i + 1 >= string.length()) {
                    String insert = Integer.toHexString(ch) + " ?";
                    JMSException traceRet1 = this.newJMSException(1015, insert);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "backReference(StringBuffer,String)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
                if (56320 > (next = string.charAt(++i)) || next >= 57344) {
                    String insert = Integer.toHexString(ch) + " " + Integer.toHexString(next);
                    JMSException traceRet2 = this.newJMSException(1015, insert);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "backReference(StringBuffer,String)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
                next = (ch - 55296 << 10) + next - 56320 + 65536;
                sb.append("&#x");
                sb.append(Integer.toHexString(next));
                sb.append(";");
                continue;
            }
            sb.append(ch);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "backReference(StringBuffer,String)");
        }
    }

    static int binToHex(byte[] bin, int start, int length, StringBuffer hex) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "binToHex(byte [ ],int,int,StringBuffer)", new Object[]{bin, new Integer(start), new Integer(length), hex});
        }
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            int binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            hex.append(BIN2HEX[binByte / 16]);
            hex.append(BIN2HEX[binByte % 16]);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "binToHex(byte [ ],int,int,StringBuffer)", new Integer(sum));
        }
        return sum;
    }

    public abstract void clearBody() throws JMSException;

    public void clearProperties() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "clearProperties()");
        }
        this.propertiesReadOnly = false;
        this.properties.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "clearProperties()");
        }
    }

    Object deformatElement(String datatype, String value) throws JMSException {
        char openingQuote;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", new Object[]{datatype, value});
        }
        if (Trace.isOn) {
            if (value == null) {
                Trace.traceData(this, "type is " + datatype + " value is " + value, null);
            } else if (value.length() <= 50) {
                Trace.traceData(this, "type is " + datatype + " value is " + value, null);
            } else {
                Trace.traceData(this, "type is " + datatype + " value starts " + value.substring(0, 50), null);
            }
        }
        if ((openingQuote = datatype.charAt(0)) != '\'' && openingQuote != '\"') {
            JMSException traceRet1 = this.newMessageFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String type = datatype.substring(1, datatype.indexOf(openingQuote, 1));
        if (type.equals("string")) {
            if (value == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", null, 1);
                }
                return null;
            }
            String traceRet2 = this.expandRefs(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet2, 2);
            }
            return traceRet2;
        }
        if (type.equals("i4")) {
            Integer traceRet3 = new Integer(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet3, 3);
            }
            return traceRet3;
        }
        if (type.equals("i2")) {
            Short traceRet4 = new Short(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet4, 4);
            }
            return traceRet4;
        }
        if (type.equals("i8")) {
            Long traceRet5 = new Long(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet5, 5);
            }
            return traceRet5;
        }
        if (type.equals("int")) {
            Long traceRet6 = new Long(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet6, 6);
            }
            return traceRet6;
        }
        if (type.equals("i1")) {
            Byte traceRet7 = new Byte(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet7, 7);
            }
            return traceRet7;
        }
        if (type.equals("r4")) {
            Float traceRet8 = new Float(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet8, 8);
            }
            return traceRet8;
        }
        if (type.equals("r8")) {
            Double traceRet9 = new Double(value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet9, 9);
            }
            return traceRet9;
        }
        if (type.equals("bin.hex")) {
            if (value.length() == 0) {
                byte[] traceRet10 = new byte[]{};
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet10, 10);
                }
                return traceRet10;
            }
            byte[] traceRet11 = this.hexToBin(value, 0);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet11, 11);
            }
            return traceRet11;
        }
        if (type.equals("boolean")) {
            if (value.equals("1")) {
                Boolean traceRet12 = new Boolean(true);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet12, 12);
                }
                return traceRet12;
            }
            if (value.equals("0")) {
                Boolean traceRet13 = new Boolean(false);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet13, 13);
                }
                return traceRet13;
            }
            JMSException traceRet14 = this.newMessageFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet14, 2);
            }
            throw traceRet14;
        }
        if (type.equals("char")) {
            Character traceRet15 = new Character(this.expandRefs(value).charAt(0));
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet15, 14);
            }
            return traceRet15;
        }
        JMSException traceRet16 = this.newMessageFormatException(1018, type);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "deformatElement(String,String)", traceRet16, 3);
        }
        throw traceRet16;
    }

    String expandRefs(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "expandRefs(String)", new Object[]{string});
        }
        if (string.length() == 0) {
            String traceRet1 = "";
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "expandRefs(String)", traceRet1, 1);
            }
            return traceRet1;
        }
        StringBuffer sb = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('&' == ch) {
                String entity = string.substring(i + 1, i + 4);
                if (entity.equals("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (entity.equals("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (string.substring(i + 1, i + 5).equals("amp;")) {
                    sb.append("&");
                    i += 4;
                    continue;
                }
                if (string.substring(i + 1, i + 6).equals("apos;")) {
                    sb.append("'");
                    i += 5;
                    continue;
                }
                if (string.substring(i + 1, i + 6).equals("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                JMSException traceRet2 = this.newMessageFormatException(1016, "&" + entity);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "expandRefs(String)", traceRet2);
                }
                throw traceRet2;
            }
            sb.append(ch);
        }
        String traceRet3 = sb.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "expandRefs(String)", traceRet3, 2);
        }
        return traceRet3;
    }

    void formatElement(String name, Object value, StringBuffer buffer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "formatElement(String,Object,StringBuffer)", new Object[]{name, value, buffer});
        }
        boolean written = false;
        buffer.append("<");
        buffer.append(name);
        if (value instanceof String) {
            buffer.append(">");
            this.backReference(buffer, (String)value);
            written = true;
        } else if (value instanceof Integer) {
            buffer.append(" dt='i4'>");
        } else if (value instanceof Short) {
            buffer.append(" dt='i2'>");
        } else if (value instanceof Byte) {
            buffer.append(" dt='i1'>");
        } else if (value instanceof Long) {
            buffer.append(" dt='i8'>");
        } else if (value instanceof Float) {
            buffer.append(" dt='r4'>");
        } else if (value instanceof Double) {
            buffer.append(" dt='r8'>");
        } else if (value instanceof byte[]) {
            buffer.append(" dt='bin.hex'>");
            JMSMessage.binToHex((byte[])value, 0, ((byte[])value).length, buffer);
            written = true;
        } else if (value instanceof Boolean) {
            buffer.append(" dt='boolean'>");
            value = ((Boolean)value).booleanValue() ? "1" : "0";
        } else if (value instanceof Character) {
            buffer.append(" dt='char'>");
            this.backReference(buffer, ((Character)value).toString());
            written = true;
        } else if (value == null) {
            buffer.append(" xsi:nil='true'>");
            buffer.append("</");
            buffer.append(name);
            buffer.append(">");
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "formatElement(String,Object,StringBuffer)", 1);
            }
            return;
        }
        if (!written) {
            buffer.append(value.toString());
        }
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "formatElement(String,Object,StringBuffer)", 2);
        }
    }

    void formatElement(String name, String type, String value, StringBuffer buffer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "formatElement(String,String,String,StringBuffer)", new Object[]{name, type, value, buffer});
        }
        buffer.append("<");
        buffer.append(name);
        if (type != null && !type.equals("")) {
            buffer.append(" dt=" + type);
        }
        buffer.append(">");
        buffer.append(value);
        buffer.append("</");
        buffer.append(name);
        buffer.append(">");
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "formatElement(String,String,String,StringBuffer)");
        }
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getBooleanProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getBooleanProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        boolean traceRet2 = this.toBoolean(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getBooleanProperty(String)", traceRet2);
        }
        return traceRet2;
    }

    public byte getByteProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getByteProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getByteProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        byte traceRet2 = this.toByte(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getByteProperty(String)", new Byte(traceRet2));
        }
        return traceRet2;
    }

    public byte[] getBytesProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getBytesProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getBytesProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        byte[] traceRet2 = this.toBytes(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getBytesProperty(String)", traceRet2);
        }
        return traceRet2;
    }

    public char getCharProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getCharProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getCharProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        char traceRet2 = this.toChar(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getCharProperty(String)", new Character(traceRet2));
        }
        return traceRet2;
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getDoubleProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getDoubleProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        double traceRet2 = this.toDouble(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getDoubleProperty(String)", new Double(traceRet2));
        }
        return traceRet2;
    }

    public float getFloatProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getFloatProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getFloatProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        float traceRet2 = this.toFloat(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getFloatProperty(String)", new Float(traceRet2));
        }
        return traceRet2;
    }

    public int getIntProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getIntProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getIntProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        int traceRet2 = this.toInt(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getIntProperty(String)", new Integer(traceRet2));
        }
        return traceRet2;
    }

    public String getJMSCorrelationID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSCorrelationID()");
        }
        if (this.correlationId == null && this.nativeCorrelId != null) {
            this.correlationId = JMSMessage._idToString(this.nativeCorrelId);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSCorrelationID()", this.correlationId);
        }
        return this.correlationId;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSCorrelationIDAsBytes()");
        }
        try {
            if (this.nativeCorrelId == null && this.correlationId != null) {
                this.nativeCorrelId = this.correlationId.getBytes("UTF8");
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSCorrelationIDAsBytes()", this.nativeCorrelId);
            }
            return this.nativeCorrelId;
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSCorrelationIDAsBytes()", ex);
            }
            JMSException jmsEx = this.newJMSException(1022);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSCorrelationIDAsBytes()", jmsEx);
            }
            throw jmsEx;
        }
    }

    public Integer getJMSDeliveryMode() throws JMSException {
        Integer traceRet1 = new Integer(this.deliveryMode);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSDeliveryMode()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Long getJMSExpiration() throws JMSException {
        Long traceRet1 = new Long(this.expiration);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSExpiration()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getJMSMessageID() throws JMSException {
        if (this.messageId == null && this.nativeMessageId != null) {
            this.messageId = JMSMessage._idToString(this.nativeMessageId);
            this.nativeMessageId = null;
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSMessageID()", "getter", this.messageId);
        }
        return this.messageId;
    }

    public Integer getJMSPriority() throws JMSException {
        Integer traceRet1 = new Integer(this.priority);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSPriority()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Boolean getJMSRedelivered() throws JMSException {
        Boolean traceRet1 = new Boolean(this.redelivered);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSRedelivered()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Long getJMSTimestamp() throws JMSException {
        Long traceRet1 = new Long(this.timestamp);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSTimestamp()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getJMSType() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSType()", "getter", this.type);
        }
        return this.type;
    }

    public long getLongProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getLongProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getLongProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        long traceRet2 = this.toLong(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getLongProperty(String)", new Long(traceRet2));
        }
        return traceRet2;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getObjectProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getObjectProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        Object retval = this._getProperty(name);
        if (retval == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getObjectProperty(String)", null, 1);
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getObjectProperty(String)", retval, 2);
        }
        return retval;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getPropertyNames()");
        }
        final Iterator iterator = this.properties.keySet().iterator();
        Enumeration e = new Enumeration(){

            public boolean hasMoreElements() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "hasMoreElements()");
                }
                boolean b = iterator.hasNext();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "hasMoreElements()", b);
                }
                return b;
            }

            public Object nextElement() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "nextElement()");
                }
                Object o = iterator.next();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.null", "nextElement()", o);
                }
                return o;
            }
        };
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getPropertyNames()", e);
        }
        return e;
    }

    public short getShortProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getShortProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getShortProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        short traceRet2 = this.toShort(this._getProperty(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getShortProperty(String)", new Short(traceRet2));
        }
        return traceRet2;
    }

    public String getStringProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getStringProperty(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getStringProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        Object retval = this._getProperty(name);
        if (retval == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getStringProperty(String)", null, 1);
            }
            return null;
        }
        String traceRet2 = retval.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getStringProperty(String)", traceRet2, 2);
        }
        return traceRet2;
    }

    byte[] hexToBin(String hex, int start) throws JMSException {
        int length;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "hexToBin(String,int)", new Object[]{hex, new Integer(start)});
        }
        if ((length = hex.length() - start) == 0) {
            byte[] traceRet1 = new byte[]{};
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "hexToBin(String,int)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (length < 0 || length % 2 != 0) {
            JMSException traceRet2 = this.newJMSException(1006, hex.substring(start));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "hexToBin(String,int)", traceRet2, 1);
            }
            throw traceRet2;
        }
        byte[] retval = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            int digit1 = Character.digit(hex.charAt(2 * i + start), 16) << 4;
            int digit2 = Character.digit(hex.charAt(2 * i + start + 1), 16);
            if (digit1 < 0 || digit2 < 0) {
                JMSException traceRet3 = this.newJMSException(1006, hex.substring(start));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "hexToBin(String,int)", traceRet3, 2);
                }
                throw traceRet3;
            }
            retval[i] = (byte)(digit1 + digit2);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "hexToBin(String,int)", retval, 2);
        }
        return retval;
    }

    private boolean isSettablePropertyName(String propertyName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", new Object[]{propertyName});
        }
        if (propertyName == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", false, 1);
            }
            return false;
        }
        if (!Character.isJavaIdentifierStart(propertyName.charAt(0))) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", false, 2);
            }
            return false;
        }
        for (int i = 1; i < propertyName.length(); ++i) {
            if (Character.isJavaIdentifierPart(propertyName.charAt(i))) continue;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", false, 3);
            }
            return false;
        }
        if (propertyName.startsWith("JMS")) {
            if (this.jmsStrings.getJMS_IBM_names().containsKey(propertyName) || propertyName.equals("JMSXGroupID") || propertyName.equals("JMSXGroupSeq") || propertyName.equals("JMSXUserID") || propertyName.equals("JMSXAppID") || propertyName.equals("JMSXDeliveryCount") || propertyName.equals("JMSXState") || propertyName.equals("JMSXProducerTXID") || propertyName.equals("JMSXConsumerTXID") || propertyName.equals("JMSXRcvTimestamp") || propertyName.equals("JMS_IBM_MQMD_Report") || propertyName.equals("JMS_IBM_MQMD_MsgType") || propertyName.equals("JMS_IBM_MQMD_Expiry") || propertyName.equals("JMS_IBM_MQMD_Feedback") || propertyName.equals("JMS_IBM_MQMD_Encoding") || propertyName.equals("JMS_IBM_MQMD_CodedCharSetId") || propertyName.equals("JMS_IBM_MQMD_Format") || propertyName.equals("JMS_IBM_MQMD_Priority") || propertyName.equals("JMS_IBM_MQMD_Persistence") || propertyName.equals("JMS_IBM_MQMD_MsgId") || propertyName.equals("JMS_IBM_MQMD_CorrelId") || propertyName.equals("JMS_IBM_MQMD_BackoutCount") || propertyName.equals("JMS_IBM_MQMD_ReplyToQ") || propertyName.equals("JMS_IBM_MQMD_ReplyToQMgr") || propertyName.equals("JMS_IBM_MQMD_UserIdentifier") || propertyName.equals("JMS_IBM_MQMD_AccountingToken") || propertyName.equals("JMS_IBM_MQMD_ApplIdentityData") || propertyName.equals("JMS_IBM_MQMD_PutApplType") || propertyName.equals("JMS_IBM_MQMD_PutApplName") || propertyName.equals("JMS_IBM_MQMD_PutDate") || propertyName.equals("JMS_IBM_MQMD_PutTime") || propertyName.equals("JMS_IBM_MQMD_ApplOriginData") || propertyName.equals("JMS_IBM_MQMD_GroupId") || propertyName.equals("JMS_IBM_MQMD_MsgSeqNumber") || propertyName.equals("JMS_IBM_MQMD_Offset") || propertyName.equals("JMS_IBM_MQMD_MsgFlags") || propertyName.equals("JMS_IBM_MQMD_OriginalLength")) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", true, 4);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", false, 5);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isSettablePropertyName(String)", true, 6);
        }
        return true;
    }

    JMSException newJMSException(int key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newJMSException(int)", new Object[]{new Integer(key)});
        }
        String exString = this.jmsStrings.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newJMSException(int)", (Object)traceRet1);
        }
        return traceRet1;
    }

    JMSException newJMSException(int key, Object insert) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newJMSException(int,Object)", new Object[]{new Integer(key), insert});
        }
        String exString = this.jmsStrings.getErrorMessage(key, insert);
        JMSException traceRet1 = new JMSException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newJMSException(int,Object)", (Object)traceRet1);
        }
        return traceRet1;
    }

    JMSException newJMSException(int key, Object insert1, Object insert2) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newJMSException(int,Object,Object)", new Object[]{new Integer(key), insert1, insert2});
        }
        String exString = this.jmsStrings.getErrorMessage(key, insert1, insert2);
        JMSException traceRet1 = new JMSException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newJMSException(int,Object,Object)", (Object)traceRet1);
        }
        return traceRet1;
    }

    JMSException newMessageEOFException() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageEOFException()");
        }
        int key = 5;
        String exString = this.jmsStrings.getErrorMessage(key);
        MessageEOFException traceRet1 = new MessageEOFException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageEOFException()", (Object)traceRet1);
        }
        return traceRet1;
    }

    JMSException newMessageFormatException() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageFormatException()");
        }
        int key = 6;
        String exString = this.jmsStrings.getErrorMessage(key);
        MessageFormatException traceRet1 = new MessageFormatException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageFormatException()", traceRet1);
        }
        return traceRet1;
    }

    JMSException newMessageFormatException(int key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageFormatException(int)", new Object[]{new Integer(key)});
        }
        String exString = this.jmsStrings.getErrorMessage(key);
        MessageFormatException traceRet1 = new MessageFormatException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageFormatException(int)", traceRet1);
        }
        return traceRet1;
    }

    JMSException newMessageFormatException(int key, Object insert) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageFormatException(int,Object)", new Object[]{new Integer(key), insert});
        }
        String exString = this.jmsStrings.getErrorMessage(key, insert);
        MessageFormatException traceRet1 = new MessageFormatException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageFormatException(int,Object)", traceRet1);
        }
        return traceRet1;
    }

    JMSException newMessageNotReadableException() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageNotReadableException()");
        }
        int key = 7;
        String exString = this.jmsStrings.getErrorMessage(key);
        MessageNotReadableException traceRet1 = new MessageNotReadableException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageNotReadableException()", traceRet1);
        }
        return traceRet1;
    }

    JMSException newMessageNotWriteableException() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageNotWriteableException()");
        }
        int key = 8;
        String exString = this.jmsStrings.getErrorMessage(key);
        MessageNotWriteableException traceRet1 = new MessageNotWriteableException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newMessageNotWriteableException()", traceRet1);
        }
        return traceRet1;
    }

    JMSException newResourceAllocationException() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newResourceAllocationException()");
        }
        int key = 9;
        String exString = this.jmsStrings.getErrorMessage(key);
        ResourceAllocationException traceRet1 = new ResourceAllocationException(exString, this.jmsStrings.getNativeKey(key));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "newResourceAllocationException()", traceRet1);
        }
        return traceRet1;
    }

    public boolean propertyExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "propertyExists(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "propertyExists(String)", traceRet1);
            }
            throw traceRet1;
        }
        boolean retval = this.properties.containsKey(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "propertyExists(String)", retval);
        }
        return retval;
    }

    public void setBatchProperties(Map properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBatchProperties(Map)", new Object[]{properties});
        }
        Iterator keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.setObjectProperty((String)key, properties.get(key));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBatchProperties(Map)");
        }
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBooleanProperty(String,boolean)", new Object[]{name, value});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBooleanProperty(String,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBooleanProperty(String,boolean)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBooleanProperty(String,boolean)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Boolean(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBooleanProperty(String,boolean)");
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setByteProperty(String,byte)", new Object[]{name, new Byte(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setByteProperty(String,byte)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setByteProperty(String,byte)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setByteProperty(String,byte)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Byte(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setByteProperty(String,byte)");
        }
    }

    public void setBytesProperty(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBytesProperty(String,byte [ ])", new Object[]{name, value});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBytesProperty(String,byte [ ])", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBytesProperty(String,byte [ ])", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBytesProperty(String,byte [ ])", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setBytesProperty(String,byte [ ])");
        }
    }

    public void setCharProperty(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setCharProperty(String,char)", new Object[]{name, new Character(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setCharProperty(String,char)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setCharProperty(String,char)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setCharProperty(String,char)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Character(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setCharProperty(String,char)");
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setDoubleProperty(String,double)", new Object[]{name, new Double(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setDoubleProperty(String,double)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setDoubleProperty(String,double)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setDoubleProperty(String,double)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Double(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setDoubleProperty(String,double)");
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setFloatProperty(String,float)", new Object[]{name, new Float(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setFloatProperty(String,float)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setFloatProperty(String,float)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setFloatProperty(String,float)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Float(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setFloatProperty(String,float)");
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setIntProperty(String,int)", new Object[]{name, new Integer(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setIntProperty(String,int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setIntProperty(String,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setIntProperty(String,int)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Integer(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setIntProperty(String,int)");
        }
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSCorrelationID(String)", new Object[]{correlationID});
        }
        this.nativeCorrelId = (byte[])(correlationID == null ? null : (byte[])(correlationID.startsWith("ID:") ? this._stringToId(correlationID) : null));
        this.correlationId = correlationID;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSCorrelationID(String)");
        }
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlID) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSCorrelationIDAsBytes(byte [ ])", new Object[]{correlID});
        }
        if (correlID == null) {
            this.nativeCorrelId = null;
            this.correlationId = null;
        } else {
            this.nativeCorrelId = new byte[correlID.length];
            System.arraycopy(correlID, 0, this.nativeCorrelId, 0, correlID.length);
            this.correlationId = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSCorrelationIDAsBytes(byte [ ])");
        }
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSDeliveryMode(int)", new Object[]{new Integer(deliveryMode)});
        }
        if (deliveryMode == -2) {
            this.deliveryMode = 2;
            this.hideDeliveryMode = true;
        } else if (deliveryMode == -3) {
            this.deliveryMode = -2;
            this.hideDeliveryMode = true;
        } else {
            this.deliveryMode = deliveryMode;
            this.hideDeliveryMode = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSDeliveryMode(int)");
        }
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSExpiration(long)", "setter", new Long(expiration));
        }
        this.expiration = expiration;
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSMessageID(String)", "setter", id);
        }
        this.messageId = id;
        this.nativeMessageId = null;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSPriority(int)", "setter", new Integer(priority));
        }
        this.priority = priority;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSRedelivered(boolean)", "setter", redelivered);
        }
        this.redelivered = redelivered;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSTimestamp(long)", "setter", new Long(timestamp));
        }
        this.timestamp = timestamp;
    }

    public void setJMSType(String type) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", new Object[]{type});
        }
        if (type == null || !type.startsWith("mcd://")) {
            this.type = type;
            this.msDomain = null;
            this.msSet = null;
            this.msType = null;
            this.msFormat = null;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", 1);
            }
            return;
        }
        if (!CLASS_TEXT.equals(this.messageClass) && !CLASS_BYTES.equals(this.messageClass)) {
            JMSException traceRet1 = this.newJMSException(1028, "JMSType", type);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String msDomain = null;
        String msSet = null;
        String msType = null;
        String msFormat = null;
        int index = 6;
        int query = type.indexOf(63, index);
        String path = query == -1 ? type : type.substring(0, query);
        int separator = path.indexOf(47, index);
        if (separator == -1) {
            if (path.length() <= 6) {
                JMSException traceRet2 = this.newJMSException(1028, "JMSType", type);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", traceRet2, 2);
                }
                throw traceRet2;
            }
            msDomain = path.substring(index);
        } else {
            if (separator == index) {
                JMSException traceRet3 = this.newJMSException(1028, "JMSType", type);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", traceRet3, 3);
                }
                throw traceRet3;
            }
            msDomain = path.substring(index, separator);
            index = separator + 1;
            if ((separator = path.indexOf(47, index)) == -1) {
                msSet = path.substring(index);
            } else {
                msSet = path.substring(index, separator);
                index = separator + 1;
                msType = path.substring(index);
            }
        }
        if (query > 0) {
            if (type.regionMatches(true, query, "?format=", 0, 8)) {
                msFormat = type.substring(query + 8);
                if (msFormat.indexOf(38) != -1) {
                    JMSException traceRet5 = this.newJMSException(1028, "JMSType", type);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", traceRet5, 4);
                    }
                    throw traceRet5;
                }
            } else {
                JMSException traceRet6 = this.newJMSException(1028, "JMSType", type);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", traceRet6, 5);
                }
                throw traceRet6;
            }
        }
        this.type = type;
        this.msDomain = msDomain;
        this.msSet = msSet;
        this.msType = msType;
        this.msFormat = msFormat;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSType(String)", 2);
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setLongProperty(String,long)", new Object[]{name, new Long(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setLongProperty(String,long)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setLongProperty(String,long)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setLongProperty(String,long)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Long(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setLongProperty(String,long)");
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setObjectProperty(String,Object)", new Object[]{name, value});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setObjectProperty(String,Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setObjectProperty(String,Object)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setObjectProperty(String,Object)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (value instanceof byte[]) {
            this.properties.put(name, value);
        } else {
            if (!(value instanceof String || value instanceof Number || value instanceof Boolean || value == null)) {
                MessageFormatException traceRet4 = new MessageFormatException("Invalid Object type");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setObjectProperty(String,Object)", (Throwable)traceRet4, 4);
                }
                throw traceRet4;
            }
            this.properties.put(name, value);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setObjectProperty(String,Object)");
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setShortProperty(String,short)", new Object[]{name, new Short(value)});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setShortProperty(String,short)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setShortProperty(String,short)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setShortProperty(String,short)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, new Short(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setShortProperty(String,short)");
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setStringProperty(String,String)", new Object[]{name, value});
        }
        if (this.propertiesReadOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setStringProperty(String,String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setStringProperty(String,String)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1020, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setStringProperty(String,String)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.properties.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setStringProperty(String,String)");
        }
    }

    public void removeProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "removeProperty(String)", new Object[]{name});
        }
        this.properties.remove(name);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "removeProperty(String)");
        }
    }

    private void _setJMSDestinationAsString(MQSession df, String destString) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSDestinationAsString(MQSession,String)", new Object[]{df, destString});
        }
        if (destString == null) {
            this.destination = null;
            this.destinationString = null;
            if (this.replyTo != null || this.replyToString == null) {
                this.destinationFactory = null;
            }
        } else {
            if (df == null || this.destinationFactory != null && df != this.destinationFactory) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Internal error: Invalid destination factory, or did not match existing df", null);
                }
                JMSException traceRet1 = this.newJMSException(1001);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSDestinationAsString(MQSession,String)", traceRet1);
                }
                throw traceRet1;
            }
            this.destination = null;
            this.destinationString = destString;
            this.destinationFactory = df;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSDestinationAsString(MQSession,String)");
        }
    }

    private void _setJMSReplyToAsString(MQSession df, String rToString) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSReplyToAsString(MQSession,String)", new Object[]{df, rToString});
        }
        if (rToString == null || rToString.trim().length() == 0) {
            this.replyTo = null;
            this.replyToString = null;
            if (this.destination != null || this.destinationString == null) {
                this.destinationFactory = null;
            }
        } else {
            if (df == null || this.destinationFactory != null && df != this.destinationFactory) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Internal error: Invalid destination factory, or did not match existing df", null);
                }
                JMSException traceRet1 = this.newJMSException(1001);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSReplyToAsString(MQSession,String)", traceRet1);
                }
                throw traceRet1;
            }
            this.replyTo = null;
            this.replyToString = rToString;
            this.destinationFactory = df;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSReplyToAsString(MQSession,String)");
        }
    }

    public boolean _hasJMSReplyTo() {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_hasJMSReplyTo()");
        }
        boolean bl = traceRet1 = this.replyToString != null || this.replyTo != null;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_hasJMSReplyTo()", traceRet1);
        }
        return traceRet1;
    }

    private Object _getProperty(String name) throws JMSException {
        Object value;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getProperty(String)", new Object[]{name});
        }
        if ((value = this.properties.get(name)) == HELD_INTERNAL) {
            value = this.getInternalPropForName(name);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getProperty(String)", value);
        }
        return value;
    }

    boolean toBoolean(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBoolean(Object)", new Object[]{value});
        }
        if (value == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBoolean(Object)", false, 1);
            }
            return false;
        }
        if (value instanceof Boolean) {
            boolean traceRet1 = (Boolean)value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBoolean(Object)", traceRet1, 2);
            }
            return traceRet1;
        }
        if (value instanceof String) {
            boolean traceRet2 = Boolean.valueOf((String)value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBoolean(Object)", traceRet2, 3);
            }
            return traceRet2;
        }
        JMSException traceRet3 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBoolean(Object)", traceRet3);
        }
        throw traceRet3;
    }

    byte toByte(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toByte(Object)", new Object[]{value});
        }
        if (value == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toByte(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Byte) {
            byte traceRet2 = (Byte)value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toByte(Object)", new Byte(traceRet2), 1);
            }
            return traceRet2;
        }
        if (value instanceof String) {
            byte traceRet3 = Byte.valueOf((String)value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toByte(Object)", new Byte(traceRet3), 2);
            }
            return traceRet3;
        }
        JMSException traceRet4 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toByte(Object)", traceRet4, 2);
        }
        throw traceRet4;
    }

    byte[] toBytes(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBytes(Object)", new Object[]{value});
        }
        if (value == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBytes(Object)", null, 1);
            }
            return null;
        }
        if (value instanceof byte[]) {
            byte[] traceRet1 = (byte[])value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBytes(Object)", traceRet1, 2);
            }
            return traceRet1;
        }
        JMSException traceRet2 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toBytes(Object)", traceRet2);
        }
        throw traceRet2;
    }

    char toChar(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toChar(Object)", new Object[]{value});
        }
        if (value == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toChar(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Character) {
            char traceRet2 = ((Character)value).charValue();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toChar(Object)", new Character(traceRet2));
            }
            return traceRet2;
        }
        JMSException traceRet3 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toChar(Object)", traceRet3, 2);
        }
        throw traceRet3;
    }

    double toDouble(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toDouble(Object)", new Object[]{value});
        }
        if (value == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toDouble(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Double) {
            double traceRet2 = (Double)value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toDouble(Object)", new Double(traceRet2), 1);
            }
            return traceRet2;
        }
        if (value instanceof Float) {
            double traceRet3 = ((Float)value).doubleValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toDouble(Object)", new Double(traceRet3), 2);
            }
            return traceRet3;
        }
        if (value instanceof String) {
            double traceRet4 = Double.valueOf((String)value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toDouble(Object)", new Double(traceRet4), 3);
            }
            return traceRet4;
        }
        JMSException traceRet5 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toDouble(Object)", traceRet5, 2);
        }
        throw traceRet5;
    }

    float toFloat(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toFloat(Object)", new Object[]{value});
        }
        if (value == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toFloat(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Float) {
            float traceRet2 = ((Float)value).floatValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toFloat(Object)", new Float(traceRet2), 1);
            }
            return traceRet2;
        }
        if (value instanceof String) {
            float traceRet3 = Float.valueOf((String)value).floatValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toFloat(Object)", new Float(traceRet3), 2);
            }
            return traceRet3;
        }
        JMSException traceRet4 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toFloat(Object)", traceRet4, 2);
        }
        throw traceRet4;
    }

    int toInt(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", new Object[]{value});
        }
        if (value == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Integer) {
            int traceRet2 = (Integer)value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", new Integer(traceRet2), 1);
            }
            return traceRet2;
        }
        if (value instanceof Short) {
            int traceRet3 = ((Short)value).intValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", new Integer(traceRet3), 2);
            }
            return traceRet3;
        }
        if (value instanceof Byte) {
            int traceRet4 = ((Byte)value).intValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", new Integer(traceRet4), 3);
            }
            return traceRet4;
        }
        if (value instanceof String) {
            int traceRet5 = Integer.valueOf((String)value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", new Integer(traceRet5), 4);
            }
            return traceRet5;
        }
        JMSException traceRet6 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toInt(Object)", traceRet6, 2);
        }
        throw traceRet6;
    }

    long toLong(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", new Object[]{value});
        }
        if (value == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Long) {
            long traceRet2 = (Long)value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", new Long(traceRet2), 1);
            }
            return traceRet2;
        }
        if (value instanceof Integer) {
            long traceRet3 = ((Integer)value).longValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", new Long(traceRet3), 2);
            }
            return traceRet3;
        }
        if (value instanceof Short) {
            long traceRet4 = ((Short)value).longValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", new Long(traceRet4), 3);
            }
            return traceRet4;
        }
        if (value instanceof Byte) {
            long traceRet5 = ((Byte)value).longValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", new Long(traceRet5), 4);
            }
            return traceRet5;
        }
        if (value instanceof String) {
            long traceRet6 = Long.valueOf((String)value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", new Long(traceRet6), 5);
            }
            return traceRet6;
        }
        JMSException traceRet7 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toLong(Object)", traceRet7, 2);
        }
        throw traceRet7;
    }

    short toShort(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toShort(Object)", new Object[]{value});
        }
        if (value == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toShort(Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Short) {
            short traceRet2 = (Short)value;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toShort(Object)", new Short(traceRet2), 1);
            }
            return traceRet2;
        }
        if (value instanceof Byte) {
            short traceRet3 = ((Byte)value).shortValue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toShort(Object)", new Short(traceRet3), 2);
            }
            return traceRet3;
        }
        if (value instanceof String) {
            short traceRet4 = Short.valueOf((String)value);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toShort(Object)", new Short(traceRet4), 3);
            }
            return traceRet4;
        }
        JMSException traceRet5 = this.newMessageFormatException(1017, value.getClass());
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "toShort(Object)", traceRet5, 2);
        }
        throw traceRet5;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        try {
            retval.append("\n" + this.jmsStrings.getMessage(1013) + ": " + this.messageClass);
            retval.append("\n  JMSType:         " + this.type);
            retval.append("\n  JMSDeliveryMode: " + this.deliveryMode);
            retval.append("\n  JMSExpiration:   " + this.expiration);
            retval.append("\n  JMSPriority:     " + this.priority);
            retval.append("\n  JMSMessageID:    " + this.getJMSMessageID());
            retval.append("\n  JMSTimestamp:    " + this.timestamp);
            retval.append("\n  JMSCorrelationID:" + this.getJMSCorrelationID());
            retval.append("\n  JMSDestination:  " + this.getJMSDestinationAsString());
            retval.append("\n  JMSReplyTo:      " + this.getJMSReplyToAsString());
            retval.append("\n  JMSRedelivered:  " + this.redelivered);
            Enumeration propertyNames = this.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                retval.append("\n  " + name + ":" + this.getObjectProperty(name));
            }
        }
        catch (JMSException ex) {
            // empty catch block
        }
        String traceRet1 = retval.toString();
        return traceRet1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
        }
        if (this.jmsStrings != null) {
            this.jmsStringResourcesClassName = this.jmsStrings.getClass().getName();
        }
        String[] possiblyInternalProps = new String[]{"JMSXUserID", "JMSXAppID", "JMS_IBM_PutDate", "JMS_IBM_PutTime", "JMSXDeliveryCount", "JMS_IBM_MsgType", "JMSXGroupSeq", "JMS_IBM_PutApplType", "JMS_IBM_Feedback", "JMS_IBM_Report_Exception", "JMS_IBM_Report_Expiration", "JMS_IBM_Report_COA", "JMS_IBM_Report_COD", "JMS_IBM_Report_PAN", "JMS_IBM_Report_NAN", "JMS_IBM_Report_Pass_Correl_ID", "JMS_IBM_Report_Pass_Msg_ID", "JMS_IBM_Report_Discard_Msg", "JMS_IBM_Last_Msg_In_Group"};
        try {
            for (int i = 0; i < possiblyInternalProps.length; ++i) {
                String propName = possiblyInternalProps[i];
                if (this.properties.get(propName) != HELD_INTERNAL) continue;
                this.properties.put(propName, this.getInternalPropForName(propName));
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "writeObject(java.io.ObjectOutputStream)", je);
            }
            IOException traceRet2 = new IOException(je.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "writeObject(java.io.ObjectOutputStream)", traceRet2);
            }
            throw traceRet2;
        }
        out.defaultWriteObject();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        if (this.jmsStringResourcesClassName != null) {
            try {
                Class jsrClass = CSSystem.dynamicLoadClass(this.jmsStringResourcesClassName, this.getClass(), false);
                this.jmsStrings = (JMSStringResources)jsrClass.newInstance();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "readObject(java.io.ObjectInputStream)", e);
                }
                ClassNotFoundException traceRet1 = new ClassNotFoundException("unable to recreate JMSStringResources from " + this.jmsStringResourcesClassName);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "readObject(java.io.ObjectInputStream)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (this.userIDAsBytes == null) {
            this.userIDAsBytes = new byte[12];
            Arrays.fill(this.userIDAsBytes, (byte)32);
        }
        if (this.putApplNameAsBytes == null) {
            this.putApplNameAsBytes = new byte[28];
            Arrays.fill(this.userIDAsBytes, (byte)32);
        }
        if (this.putDateAsBytes == null) {
            this.putDateAsBytes = new byte[8];
            Arrays.fill(this.putDateAsBytes, (byte)32);
        }
        if (this.putTimeAsBytes == null) {
            this.putTimeAsBytes = new byte[8];
            Arrays.fill(this.putTimeAsBytes, (byte)32);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    public void setPSCTopic(String psTopic) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setPSCTopic(String)", "setter", psTopic);
        }
        this.psTopic = psTopic;
    }

    public void setPSCConnID(String psConnID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setPSCConnID(String)", "setter", psConnID);
        }
        this.psConnID = psConnID;
    }

    public String _getJMSIBMArmCorrelator() {
        String retVal;
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMArmCorrelator()");
            }
            retVal = null;
            if (this.properties.get("JMS_IBM_ArmCorrelator") == HELD_INTERNAL) {
                retVal = this.armCorrelator;
            } else {
                try {
                    retVal = this.getStringProperty("JMS_IBM_ArmCorrelator");
                }
                catch (JMSException je) {
                    if (!Trace.isOn) break block6;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMArmCorrelator()", je);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMArmCorrelator()", retVal);
        }
        return retVal;
    }

    public String _getJMSIBMWrmCorrelator() {
        String retVal;
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMWrmCorrelator()");
            }
            retVal = null;
            if (this.properties.get("JMS_IBM_RMCorrelator") == HELD_INTERNAL) {
                retVal = this.wrmCorrelator;
            } else {
                try {
                    retVal = this.getStringProperty("JMS_IBM_RMCorrelator");
                }
                catch (JMSException je) {
                    if (!Trace.isOn) break block6;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMWrmCorrelator()", je);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_getJMSIBMWrmCorrelator()", retVal);
        }
        return retVal;
    }

    public void _setJMSIBMArmCorrelator(String correlator) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMArmCorrelator(String)", new Object[]{correlator});
        }
        this.armCorrelator = correlator;
        this.properties.put("JMS_IBM_ArmCorrelator", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMArmCorrelator(String)");
        }
    }

    public void _setJMSIBMWrmCorrelator(String correlator) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMWrmCorrelator(String)", new Object[]{correlator});
        }
        this.wrmCorrelator = correlator;
        this.properties.put("JMS_IBM_RMCorrelator", HELD_INTERNAL);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "_setJMSIBMWrmCorrelator(String)");
        }
    }

    public void setGotByConsume(boolean consumed) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setGotByConsume(boolean)", "setter", consumed);
        }
        this.gotByConsume = consumed;
    }

    public boolean setGotByConsume() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setGotByConsume()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setGotByConsume()", this.gotByConsume);
        }
        return this.gotByConsume;
    }

    public String getJMSDestinationAsString() throws JMSException {
        if (this.destinationString == null && this.destination != null) {
            this.destinationString = this.destination.toURI();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSDestinationAsString()", "getter", this.destinationString);
        }
        return this.destinationString;
    }

    public String getJMSReplyToAsString() throws JMSException {
        if (this.replyToString == null && this.replyTo != null) {
            this.replyToString = this.replyTo.toURI();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "getJMSReplyToAsString()", "getter", this.replyToString);
        }
        return this.replyToString;
    }

    public void setJMSDestinationAsString(String newDestination) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSDestinationAsString(String)", "setter", newDestination);
        }
        this.destinationString = newDestination;
        this.destination = null;
        this.destinationFactory = null;
    }

    public void setJMSReplyToAsString(String newReplyTo) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "setJMSReplyToAsString(String)", "setter", newReplyTo);
        }
        this.replyToString = newReplyTo;
        this.replyTo = null;
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "clear()");
        }
        this.properties.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "clear()");
        }
    }

    public boolean containsKey(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "containsKey(Object)", new Object[]{key});
        }
        boolean traceRet1 = this.properties.containsKey(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "containsKey(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean containsValue(Object value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "containsValue(Object)", new Object[]{value});
        }
        boolean traceRet1 = this.properties.containsValue(value);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "containsValue(Object)", traceRet1);
        }
        return traceRet1;
    }

    public Set entrySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "entrySet()");
        }
        Set traceRet1 = this.properties.entrySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "entrySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object get(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "get(Object)", new Object[]{key});
        }
        Object traceRet1 = this.properties.get(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "get(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean isEmpty() {
        boolean traceRet1 = this.properties.isEmpty();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "isEmpty()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Set keySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "keySet()");
        }
        Set traceRet1 = this.properties.keySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "keySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object put(Object arg0, Object arg1) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "put(Object,Object)", new Object[]{arg0, arg1});
        }
        Object traceRet1 = this.properties.put(arg0, arg1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "put(Object,Object)", traceRet1);
        }
        return traceRet1;
    }

    public void putAll(Map arg0) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "putAll(Map)", new Object[]{arg0});
        }
        this.properties.putAll(arg0);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "putAll(Map)");
        }
    }

    public Object remove(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "remove(Object)", new Object[]{key});
        }
        Object traceRet1 = this.properties.remove(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "remove(Object)", traceRet1);
        }
        return traceRet1;
    }

    public int size() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "size()");
        }
        int traceRet1 = this.properties.size();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "size()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Collection values() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "values()");
        }
        Collection traceRet1 = this.properties.values();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "values()", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.60.1.7 13/05/30 12:59:53");
        }
        OPEN_MCDMSD = "<mcd><Msd>".getBytes();
        CLOSE_MSDMCD = "</Msd></mcd>".getBytes();
        BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HELD_INTERNAL = "JMSMessage.HELD_INTERNAL";
    }
}

