/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.collections.CSHashtable;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;

public class JMSMapMessage
extends JMSMessage
implements ProviderMapMessage {
    static final long serialVersionUID = 3908796707964271920L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSMapMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.23.1.2 10/03/03 02:46:13";
    private CSHashtable mapdata = new CSHashtable();
    boolean readOnly = false;
    boolean inExportBody = false;
    protected boolean mapNameStyle = true;

    public JMSMapMessage(JMSStringResources jmsStrings) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "<init>(JMSStringResources)", new Object[]{jmsStrings});
        }
        this.messageClass = "jms_map";
        this.jmsStrings = jmsStrings;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "<init>(JMSStringResources)");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        this.inExportBody = true;
        StringBuffer body = new StringBuffer(100);
        try {
            Enumeration elementNames = this.getMapNames();
            body.append("<map>");
            while (elementNames.hasMoreElements()) {
                String name = (String)elementNames.nextElement();
                Object value = this.getObject(name);
                this.eltFormatElement(name, value, body);
            }
            body.append("</map>");
            this.inExportBody = false;
            byte[] traceRet1 = body.toString().getBytes(characterSet);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_exportBody(int,String)", traceRet1);
            }
            return traceRet1;
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_exportBody(int,String)", ex);
            }
            JMSException jmsEx = this.newJMSException(1008, characterSet);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_exportBody(int,String)", jmsEx);
            }
            throw jmsEx;
        }
    }

    public void _importBody(byte[] wireformat, int dataStart, int encoding, String charSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", new Object[]{wireformat, new Integer(dataStart), new Integer(encoding), charSet});
        }
        try {
            String body = new String(wireformat, dataStart, wireformat.length - dataStart, charSet);
            Tokenizer strtok = new Tokenizer(body);
            if (!strtok.nextToken().equals("map")) {
                JMSException traceRet1 = this.newMessageFormatException(1009);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", traceRet1, 1);
                }
                throw traceRet1;
            }
            String name = strtok.nextToken();
            while (!name.equals("/map")) {
                String token;
                String type;
                if (name.length() > 3 && name.substring(0, 3).equals("elt")) {
                    name = this._handleIllegalCharacters(name);
                }
                int nullIndex = 0;
                boolean newNull = false;
                try {
                    nullIndex = name.indexOf(" xsi:nil");
                    newNull = nullIndex != -1;
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", e, 1);
                    }
                    newNull = false;
                }
                boolean shortForm = false;
                boolean byteIndex = false;
                if (name.charAt(name.length() - 1) == '/') {
                    shortForm = true;
                }
                if (newNull) {
                    int spaceIndex = 0;
                    spaceIndex = name.indexOf(" ");
                    type = "'string'";
                    name = name.substring(0, spaceIndex);
                    if (!shortForm) {
                        token = strtok.nextToken();
                        if (token.charAt(0) != '/') {
                            token = strtok.nextToken();
                        }
                        if (token.charAt(0) != '/') {
                            JMSException traceRet2 = this.newMessageFormatException(1012);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", traceRet2, 2);
                            }
                            throw traceRet2;
                        }
                    }
                    this.setObject(name, this.deformatElement(type, null));
                } else {
                    int index = name.indexOf(" dt=");
                    if (index != -1) {
                        type = name.substring(index + 4);
                        name = name.substring(0, index);
                        if (shortForm) {
                            type = type.substring(0, type.length() - 1);
                        }
                    } else {
                        type = "'string'";
                        if (shortForm) {
                            name = name.substring(0, name.length() - 1);
                        }
                    }
                    if (shortForm) {
                        this.setObject(name, this.deformatElement(type, ""));
                    } else {
                        String value = strtok.nextToken();
                        if (value.charAt(0) == '/' && (value.equals("/elt") || name.equals(value.substring(1, value.length())))) {
                            this.setObject(name, this.deformatElement(type, ""));
                        } else {
                            this.setObject(name, this.deformatElement(type, value));
                            token = strtok.nextToken();
                            if (token.charAt(0) != '/') {
                                JMSException traceRet3 = this.newMessageFormatException(1009);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", traceRet3, 3);
                                }
                                throw traceRet3;
                            }
                        }
                    }
                }
                name = strtok.nextToken();
            }
            this.readOnly = true;
        }
        catch (UnsupportedEncodingException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", ex, 2);
            }
            JMSException jmsEx = this.newJMSException(1008, charSet);
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", jmsEx, 4);
            }
            throw jmsEx;
        }
        catch (Exception ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", ex, 3);
            }
            JMSException jmsEx = this.newMessageFormatException(1009);
            jmsEx.setLinkedException(ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)", jmsEx, 5);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_importBody(byte [ ],int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "clearBody()");
        }
        this.readOnly = false;
        this.mapdata.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "clearBody()");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getBoolean(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getBoolean(String)", traceRet1);
            }
            throw traceRet1;
        }
        boolean traceRet2 = this.toBoolean(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getBoolean(String)", traceRet2);
        }
        return traceRet2;
    }

    public byte getByte(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getByte(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getByte(String)", traceRet1);
            }
            throw traceRet1;
        }
        byte traceRet2 = this.toByte(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getByte(String)", new Byte(traceRet2));
        }
        return traceRet2;
    }

    public byte[] getBytes(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getBytes(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getBytes(String)", traceRet1);
            }
            throw traceRet1;
        }
        byte[] traceRet2 = this.toBytes(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getBytes(String)", traceRet2);
        }
        return traceRet2;
    }

    public char getChar(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getChar(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getChar(String)", traceRet1);
            }
            throw traceRet1;
        }
        char traceRet2 = this.toChar(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getChar(String)", new Character(traceRet2));
        }
        return traceRet2;
    }

    public double getDouble(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getDouble(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getDouble(String)", traceRet1);
            }
            throw traceRet1;
        }
        double traceRet2 = this.toDouble(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getDouble(String)", new Double(traceRet2));
        }
        return traceRet2;
    }

    public float getFloat(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getFloat(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getFloat(String)", traceRet1);
            }
            throw traceRet1;
        }
        float traceRet2 = this.toFloat(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getFloat(String)", new Float(traceRet2));
        }
        return traceRet2;
    }

    public int getInt(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getInt(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getInt(String)", traceRet1);
            }
            throw traceRet1;
        }
        int traceRet2 = this.toInt(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getInt(String)", new Integer(traceRet2));
        }
        return traceRet2;
    }

    public long getLong(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getLong(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getLong(String)", traceRet1);
            }
            throw traceRet1;
        }
        long traceRet2 = this.toLong(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getLong(String)", new Long(traceRet2));
        }
        return traceRet2;
    }

    public Enumeration getMapNames() throws JMSException {
        Enumeration traceRet1 = this.mapdata.keys();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getMapNames()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Object getObject(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getObject(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getObject(String)", traceRet1);
            }
            throw traceRet1;
        }
        Object retval = this.mapdata.get(name);
        if (retval == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getObject(String)", null, 1);
            }
            return null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getObject(String)", retval, 2);
        }
        return retval;
    }

    public short getShort(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getShort(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getShort(String)", traceRet1);
            }
            throw traceRet1;
        }
        short traceRet2 = this.toShort(this.mapdata.get(name));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getShort(String)", new Short(traceRet2));
        }
        return traceRet2;
    }

    public String getString(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getString(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1002, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getString(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        Object retval = this.mapdata.get(name);
        if (retval == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getString(String)", null, 1);
            }
            return null;
        }
        if (retval instanceof byte[]) {
            JMSException traceRet2 = this.newMessageFormatException(1011);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getString(String)", traceRet2, 2);
            }
            throw traceRet2;
        }
        String traceRet3 = retval.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getString(String)", traceRet3, 2);
        }
        return traceRet3;
    }

    private boolean isSettableMapName(String elementName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "isSettableMapName(String)", new Object[]{elementName});
        }
        boolean reply = true;
        for (int i = 0; i < elementName.length(); ++i) {
            char ch = elementName.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch)) continue;
                reply = false;
                break;
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            reply = false;
            break;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "isSettableMapName(String)", reply);
        }
        return reply;
    }

    public boolean itemExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "itemExists(String)", new Object[]{name});
        }
        if (name == null) {
            JMSException traceRet1 = this.newJMSException(1003);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "itemExists(String)", traceRet1);
            }
            throw traceRet1;
        }
        boolean retval = this.mapdata.containsKey(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "itemExists(String)", retval);
        }
        return retval;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBoolean(String,boolean)", new Object[]{name, value});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBoolean(String,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBoolean(String,boolean)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBoolean(String,boolean)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Boolean(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBoolean(String,boolean)");
        }
    }

    public void setByte(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setByte(String,byte)", new Object[]{name, new Byte(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setByte(String,byte)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setByte(String,byte)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setByte(String,byte)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Byte(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setByte(String,byte)");
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ])", new Object[]{name, value});
        }
        if (value == null) {
            this.setObject(name, value);
        } else if (value.length == 0) {
            this.setObject(name, value);
        } else {
            this.setBytes(name, value, 0, value.length);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ])");
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ],int,int)", new Object[]{name, value, new Integer(offset), new Integer(length)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ],int,int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ],int,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ],int,int)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (value.length == 0) {
            this.mapdata.put(name, new byte[0]);
        } else {
            byte[] elementValue = new byte[length];
            System.arraycopy(value, offset, elementValue, 0, length);
            this.mapdata.put(name, elementValue);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setBytes(String,byte [ ],int,int)");
        }
    }

    public void setChar(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setChar(String,char)", new Object[]{name, new Character(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setChar(String,char)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setChar(String,char)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setChar(String,char)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Character(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setChar(String,char)");
        }
    }

    public void setDouble(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setDouble(String,double)", new Object[]{name, new Double(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setDouble(String,double)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setDouble(String,double)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setDouble(String,double)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Double(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setDouble(String,double)");
        }
    }

    public void setFloat(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setFloat(String,float)", new Object[]{name, new Float(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setFloat(String,float)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setFloat(String,float)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setFloat(String,float)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Float(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setFloat(String,float)");
        }
    }

    public void setInt(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setInt(String,int)", new Object[]{name, new Integer(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setInt(String,int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setInt(String,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setInt(String,int)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Integer(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setInt(String,int)");
        }
    }

    public void setLong(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setLong(String,long)", new Object[]{name, new Long(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setLong(String,long)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setLong(String,long)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setLong(String,long)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Long(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setLong(String,long)");
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setObject(String,Object)", new Object[]{name, value});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setObject(String,Object)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setObject(String,Object)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setObject(String,Object)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (!(value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof byte[] || value == null)) {
            JMSException traceRet4 = this.newMessageFormatException(1018, value.getClass());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setObject(String,Object)", traceRet4, 4);
            }
            throw traceRet4;
        }
        this.mapdata.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setObject(String,Object)");
        }
    }

    public void setShort(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setShort(String,short)", new Object[]{name, new Short(value)});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setShort(String,short)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setShort(String,short)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setShort(String,short)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, new Short(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setShort(String,short)");
        }
    }

    public void setString(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setString(String,String)", new Object[]{name, value});
        }
        if (this.readOnly) {
            JMSException traceRet1 = this.newMessageNotWriteableException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setString(String,String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String exString = this.jmsStrings.getErrorMessage(1020, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(exString);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setString(String,String)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            JMSException traceRet3 = this.newMessageFormatException(1021, name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setString(String,String)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.mapdata.put(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "setString(String,String)");
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.toString());
        retval.append("\n");
        retval.append(this.mapdata.toString());
        String traceRet1 = retval.toString();
        return traceRet1;
    }

    public String _handleIllegalCharacters(String propertyName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_handleIllegalCharacters(String)", new Object[]{propertyName});
        }
        try {
            if (propertyName.length() > 3 && propertyName.substring(0, 3).equals("elt")) {
                int endbit;
                String name = propertyName;
                String realName = "";
                String nameIntro = "";
                boolean newNull = false;
                int nullIndex = 0;
                nullIndex = name.indexOf(" xsi:nil");
                newNull = nullIndex != -1;
                String nullbit = "";
                if (newNull) {
                    nullbit = name.substring(nullIndex, nullIndex + 15);
                }
                if ((endbit = name.indexOf(" dt=")) != -1) {
                    nameIntro = name.substring(0, name.indexOf("name=") + 5);
                    int realNameStart = nameIntro.length() + 1;
                    int realNameEnd = name.indexOf("dt=") - 2;
                    realName = name.substring(realNameStart, realNameEnd);
                    realName = realName + name.substring(endbit, name.length());
                    name = realName + nullbit;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Altered Name = " + name, null);
                    }
                } else {
                    nameIntro = name.substring(0, name.indexOf("name=") + 5);
                    int realNameStart = nameIntro.length() + 1;
                    realName = newNull ? name.substring(realNameStart, name.indexOf("xsi:nil") - 2) : name.substring(realNameStart, name.length() - 1);
                    name = realName + nullbit;
                    if (Trace.isOn) {
                        Trace.traceData(this, "(String) Altered Name = " + name, null);
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_handleIllegalCharacters(String)", name, 1);
                }
                return name;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_handleIllegalCharacters(String)", propertyName, 2);
            }
            return propertyName;
        }
        catch (Exception ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_handleIllegalCharacters(String)", ex);
            }
            JMSException jmsEx = this.newMessageFormatException(1012);
            jmsEx.setLinkedException(ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_handleIllegalCharacters(String)", jmsEx);
            }
            throw jmsEx;
        }
    }

    void _setBodyReadOnly() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_setBodyReadOnly()");
        }
        this.readOnly = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "_setBodyReadOnly()");
        }
    }

    boolean getInExportBody() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "getInExportBody()", "getter", this.inExportBody);
        }
        return this.inExportBody;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        if (this.messageClass.equals("jms_map")) {
            this.messageClass = "jms_map";
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    void eltFormatElement(String name, Object value, StringBuffer buffer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "eltFormatElement(String,Object,StringBuffer)", new Object[]{name, value, buffer});
        }
        boolean written = false;
        buffer.append("<");
        if (this.mapNameStyle) {
            buffer.append("elt name=\"" + name + "\"");
        } else {
            buffer.append(name);
        }
        if (value instanceof String) {
            buffer.append(">");
            this.backReference(buffer, (String)value);
            written = true;
        } else if (value instanceof Integer) {
            buffer.append(" dt='i4'>");
        } else if (value instanceof Short) {
            buffer.append(" dt='i2'>");
        } else if (value instanceof Byte) {
            buffer.append(" dt='i1'>");
        } else if (value instanceof Long) {
            buffer.append(" dt='i8'>");
        } else if (value instanceof Float) {
            buffer.append(" dt='r4'>");
        } else if (value instanceof Double) {
            buffer.append(" dt='r8'>");
        } else if (value instanceof byte[]) {
            buffer.append(" dt='bin.hex'>");
            JMSMapMessage.binToHex((byte[])value, 0, ((byte[])value).length, buffer);
            written = true;
        } else if (value instanceof Boolean) {
            buffer.append(" dt='boolean'>");
            value = ((Boolean)value).booleanValue() ? "1" : "0";
        } else if (value instanceof Character) {
            buffer.append(" dt='char'>");
            this.backReference(buffer, ((Character)value).toString());
            written = true;
        } else if (value == null) {
            buffer.append(" xsi:nil='true'>");
            buffer.append("</");
            if (this.mapNameStyle) {
                buffer.append("elt");
            } else {
                buffer.append(name);
            }
            buffer.append(">");
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "eltFormatElement(String,Object,StringBuffer)", 1);
            }
            return;
        }
        if (!written) {
            buffer.append(value.toString());
        }
        buffer.append("</");
        if (this.mapNameStyle) {
            buffer.append("elt");
        } else {
            buffer.append(name);
        }
        buffer.append(">");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "eltFormatElement(String,Object,StringBuffer)", 2);
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSMapMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSMapMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.23.1.2 10/03/03 02:46:13");
        }
    }

    private class Tokenizer {
        private Vector tokens = new Vector();

        private Tokenizer(String string) {
            String token;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "<init>(String)", new Object[]{string});
            }
            int length = string.length();
            boolean hide = false;
            int tokenStart = 0;
            boolean decorated = false;
            for (int index = 0; index < length; ++index) {
                char ch = string.charAt(index);
                if (ch == '\"') {
                    hide = !hide;
                    continue;
                }
                if (hide) continue;
                if (decorated) {
                    if (ch != '>') continue;
                    if (index > tokenStart && (token = string.substring(tokenStart + 1, index)).length() > 0) {
                        this.tokens.add(token);
                    }
                    decorated = false;
                    tokenStart = index;
                    continue;
                }
                if (ch != '<') continue;
                if (index > tokenStart && (token = string.substring(tokenStart + 1, index)).length() > 0) {
                    this.tokens.add(token);
                }
                decorated = true;
                tokenStart = index;
            }
            if (length - tokenStart > 2) {
                token = string.substring(tokenStart + 1, length - 1);
                this.tokens.add(token);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "<init>(String)");
            }
        }

        private String nextToken() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "nextToken()");
            }
            if (this.tokens.size() <= 0) {
                NoSuchElementException traceRet1 = new NoSuchElementException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "nextToken()", traceRet1);
                }
                throw traceRet1;
            }
            String token = (String)this.tokens.firstElement();
            this.tokens.remove(0);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "nextToken()", token);
            }
            return token;
        }

        private String nextElement() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "nextElement()");
            }
            if (this.tokens.size() <= 0) {
                NoSuchElementException traceRet1 = new NoSuchElementException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "nextElement()", traceRet1);
                }
                throw traceRet1;
            }
            String token = (String)this.tokens.firstElement();
            this.tokens.remove(0);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.Tokenizer", "nextElement()", token);
            }
            return token;
        }
    }
}

