/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;

public class JMSBytesMessage
extends JMSMessage
implements ProviderBytesMessage {
    static final long serialVersionUID = -8017520360760128818L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSBytesMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.30.1.2 10/07/09 14:43:01";
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_S390 = 768;
    private transient ByteArrayOutputStream _writeBytes;
    private transient DataOutputStream writeStream;
    private byte[] dataBuffer;
    private int dataStart;
    private transient ByteArrayInputStream readStream;
    private transient ByteArrayInputStream readLengthStream;
    private boolean lengthCheck = false;

    public JMSBytesMessage(JMSStringResources jmsStrings) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "<init>(JMSStringResources)", new Object[]{jmsStrings});
        }
        this.messageClass = "jms_bytes";
        this.jmsStrings = jmsStrings;
        this.clearBody();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "<init>(JMSStringResources)");
        }
    }

    public byte[] _exportBody(int encoding, String characterSet) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_exportBody(int,String)", new Object[]{new Integer(encoding), characterSet});
        }
        this.getReadStream(false);
        byte[] buff = new byte[this.dataBuffer.length - this.dataStart];
        System.arraycopy(this.dataBuffer, this.dataStart, buff, 0, this.dataBuffer.length - this.dataStart);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_exportBody(int,String)", buff);
        }
        return buff;
    }

    public void _importBody(byte[] wireformat, int dataStart, int encoding, String charSet) throws JMSException {
        String exposedCharSet;
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_importBody(byte [ ],int,int,String)", new Object[]{wireformat, new Integer(dataStart), new Integer(encoding), charSet});
            }
            this.getReadStream(true);
            this.dataBuffer = wireformat;
            this.dataStart = dataStart;
            this._setJMSXObjectProperty("JMS_IBM_Encoding", new Integer(encoding));
            exposedCharSet = charSet;
            if (charSet.startsWith("Cp")) {
                try {
                    exposedCharSet = Integer.toString(Integer.parseInt(charSet.substring(2)));
                }
                catch (NumberFormatException nfe) {
                    if (!Trace.isOn) break block5;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_importBody(byte [ ],int,int,String)", nfe);
                }
            }
        }
        this._setJMSXObjectProperty("JMS_IBM_Character_Set", exposedCharSet);
        this.reset();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_importBody(byte [ ],int,int,String)");
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "clearBody()");
        }
        this.dataBuffer = null;
        this.dataStart = 0;
        this.readStream = null;
        this.readLengthStream = null;
        this._writeBytes = new ByteArrayOutputStream();
        this.writeStream = new DataOutputStream(this._writeBytes);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "clearBody()");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readBytes(byte [ ])", new Object[]{value});
        }
        int traceRet1 = this.readBytes(value, value.length);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readBytes(byte [ ])", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readBytes(byte [ ],int)", new Object[]{value, new Integer(length)});
        }
        if (value.length < length || length < 0) {
            IndexOutOfBoundsException traceRet2 = new IndexOutOfBoundsException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readBytes(byte [ ],int)", traceRet2);
            }
            throw traceRet2;
        }
        this.checkReadStream();
        int traceRet4 = this.readStream.read(value, 0, length);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readBytes(byte [ ],int)", new Integer(traceRet4));
        }
        return traceRet4;
    }

    public void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "reset()");
        }
        this.getReadStream(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "reset()");
        }
    }

    private void getReadStream(boolean removeWriteStream) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getReadStream(boolean)", new Object[]{removeWriteStream});
        }
        if (this.writeStream != null && this._writeBytes != null) {
            this.dataBuffer = this._writeBytes.toByteArray();
            this.dataStart = 0;
            if (removeWriteStream) {
                this.writeStream = null;
                this._writeBytes = null;
            }
        }
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[0];
        }
        this.readStream = new ByteArrayInputStream(this.dataBuffer);
        this.readLengthStream = new ByteArrayInputStream(this.dataBuffer);
        this.lengthCheck = false;
        this.readStream.skip(this.dataStart);
        this.readLengthStream.skip(this.dataStart);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getReadStream(boolean)");
        }
    }

    public String toString() {
        Object encoding;
        StringBuffer retval;
        int LINE_LENGTH;
        int MAX_LINES;
        block7: {
            MAX_LINES = 10;
            LINE_LENGTH = 40;
            retval = new StringBuffer();
            encoding = null;
            try {
                encoding = this.getObjectProperty("JMS_IBM_Encoding");
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block7;
                Trace.data(this, "toString", (Object)"Exception reading encoding prop - ignoring and using defaults");
            }
        }
        int integerEncoding = encoding instanceof Integer ? (Integer)encoding & 0xF : 1;
        int floatEncoding = encoding instanceof Integer ? (Integer)encoding & 0xF00 : 256;
        retval.append(super.toString() + "\n");
        retval.append(this.jmsStrings.getMessage(1027, new Integer(integerEncoding), new Integer(floatEncoding)));
        retval.append("\n");
        if (this._writeBytes != null) {
            this.dataBuffer = this._writeBytes.toByteArray();
        }
        if (this.dataBuffer != null) {
            int curpos = this.dataStart;
            for (int lines_written = 0; lines_written < MAX_LINES; ++lines_written) {
                if (this.dataBuffer.length <= curpos + LINE_LENGTH) {
                    JMSBytesMessage.binToHex(this.dataBuffer, curpos, this.dataBuffer.length - curpos, retval);
                    curpos = this.dataBuffer.length;
                    retval.append("\n");
                    break;
                }
                JMSBytesMessage.binToHex(this.dataBuffer, curpos, LINE_LENGTH, retval);
                retval.append("\n");
                curpos += LINE_LENGTH;
            }
            if (curpos != this.dataBuffer.length) {
                retval.append("...\n");
            }
        }
        String traceRet1 = retval.toString();
        return traceRet1;
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeBytes(byte [ ])", new Object[]{value});
        }
        this.writeBytes(value, 0, value.length);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        try {
            if (this.writeStream != null) {
                this.writeStream.write(value, offset, length);
            }
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeBytes(byte [ ],int,int)", ex);
            }
            JMSException jmsEx = this.newResourceAllocationException();
            jmsEx.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeBytes(byte [ ],int,int)", jmsEx);
            }
            throw jmsEx;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeBytes(byte [ ],int,int)");
        }
    }

    void _setBodyReadOnly() {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_setBodyReadOnly()");
            }
            try {
                this.reset();
            }
            catch (JMSException ex) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_setBodyReadOnly()", ex);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "_setBodyReadOnly()");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
        }
        try {
            try {
                this.reset();
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeObject(java.io.ObjectOutputStream)", je, 1);
                }
                IOException traceRet1 = new IOException("failed to reset ProviderBytesMessage for serialization");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeObject(java.io.ObjectOutputStream)", traceRet1, 1);
                }
                throw traceRet1;
            }
            out.defaultWriteObject();
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeObject(java.io.ObjectOutputStream)", e, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeObject(java.io.ObjectOutputStream)", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        try {
            in.defaultReadObject();
            try {
                this.reset();
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readObject(java.io.ObjectInputStream)", je, 1);
                }
                IOException traceRet1 = new IOException("failed to reset ProviderBytesMessage for serialisation");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readObject(java.io.ObjectInputStream)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (this.messageClass.equals("jms_bytes")) {
                this.messageClass = "jms_bytes";
            }
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readObject(java.io.ObjectInputStream)", e, 2);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readObject(java.io.ObjectInputStream)", e, 2);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "readObject(java.io.ObjectInputStream)");
        }
    }

    public long getBodyLength() throws JMSException, MessageNotReadableException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getBodyLength()");
        }
        long length = 0L;
        byte[] copyBuffer = new byte[4000];
        try {
            int moreBytes;
            if (!this.lengthCheck) {
                this.readLengthStream.mark(0);
                this.lengthCheck = true;
            } else {
                this.readLengthStream.reset();
            }
            while ((moreBytes = this.readLengthStream.read(copyBuffer)) >= 0) {
                length += (long)moreBytes;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getBodyLength()", new Long(length));
            }
            return length;
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getBodyLength()", ioe);
            }
            JMSException jmsEx = this.newResourceAllocationException();
            jmsEx.setLinkedException((Exception)ioe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getBodyLength()", jmsEx);
            }
            throw jmsEx;
        }
    }

    public byte[] getBytes() throws JMSException {
        byte[] bytes = new byte[this.dataBuffer.length - this.dataStart];
        this.readBytes(bytes);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "getBytes()", "getter", bytes);
        }
        return bytes;
    }

    public void setBytes(byte[] bytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "setBytes(byte [ ])", "setter", bytes);
        }
        this.clearBody();
        this.writeBytes(bytes);
        this.reset();
    }

    private void checkReadStream() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "checkReadStream()");
        }
        if (this.readStream == null) {
            String message = "ByteMessage readStream was null. Shouldn't happen when the message is in readOnly mode";
            if (Trace.isOn) {
                Trace.data(this, "checkReadStream", (Object)message);
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Message", message);
            Trace.ffst(this, "readInt()", "", data, null);
            JMSException je = this.newMessageEOFException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "checkReadStream()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "checkReadStream()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/JMSBytesMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.30.1.2 10/07/09 14:43:01");
        }
    }
}

