/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;
import javax.jms.JMSException;

class DLH {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MQDLH_STRUC_ID = "DLH ";
    private static final int MQDLH_VERSION_1 = 1;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/DLH.java, jmscc.wmq.v6, k701, k701-112-140304 1.20.1.2 10/08/19 11:37:06";
    private int codedCharSetId;
    String destQMgrName;
    String destQName;
    private int encoding;
    private String format;
    private int msgCharSet;
    private int msgEncoding;
    String putApplName;
    int putApplType;
    String putDate;
    String putTime;
    int reason;
    private String strucId;
    private int version;

    DLH() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>()");
        }
        this.strucId = MQDLH_STRUC_ID;
        this.version = 1;
        this.reason = 0;
        this.destQName = Utils.padString(null, 48);
        this.destQMgrName = Utils.padString(null, 48);
        this.encoding = 273;
        this.codedCharSetId = 0;
        this.format = "        ";
        this.putApplType = 0;
        this.putApplName = Utils.padString(null, 28);
        this.putDate = Utils.padString(null, 8);
        this.putTime = Utils.padString(null, 8);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>()");
        }
    }

    DLH(MQMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{message});
        }
        if (message == null) {
            JMSException je = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", je, 1);
            }
            throw je;
        }
        this.msgCharSet = message.characterSet;
        this.msgEncoding = message.encoding;
        try {
            byte[] tmp = new byte[4];
            message.readFully(tmp, 0, 4);
            this.strucId = this.getString(tmp);
            if (!this.strucId.equals(MQDLH_STRUC_ID)) {
                Exception traceRet1 = new Exception("strucId");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", traceRet1, 2);
                }
                throw traceRet1;
            }
            this.version = message.readInt();
            if (this.version != 1) {
                Exception traceRet2 = new Exception("version");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", traceRet2, 3);
                }
                throw traceRet2;
            }
            this.reason = message.readInt();
            tmp = new byte[48];
            message.readFully(tmp, 0, 48);
            this.destQName = this.getString(tmp);
            message.readFully(tmp, 0, 48);
            this.destQMgrName = this.getString(tmp);
            this.encoding = message.readInt();
            this.codedCharSetId = message.readInt();
            tmp = new byte[8];
            message.readFully(tmp, 0, 8);
            this.format = this.getString(tmp);
            this.putApplType = message.readInt();
            tmp = new byte[28];
            message.readFully(tmp, 0, 28);
            this.putApplName = this.getString(tmp);
            tmp = new byte[8];
            message.readFully(tmp, 0, 8);
            this.putDate = this.getString(tmp);
            message.readFully(tmp, 0, 8);
            this.putTime = this.getString(tmp);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1076");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "<init>(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
        }
    }

    private String getString(byte[] barray) throws UnsupportedEncodingException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "getString(byte [ ])", new Object[]{barray});
        }
        try {
            String traceRet1 = new String(barray, MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "getString(byte [ ])", traceRet1);
            }
            return traceRet1;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "getString(byte [ ])", je, 1);
            }
            UnsupportedEncodingException uee = new UnsupportedEncodingException(je.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "getString(byte [ ])", uee, 1);
            }
            throw uee;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StrucId='" + this.strucId + "'\n");
        buf.append("Version=" + this.version + "\n");
        buf.append("Reason=" + this.reason + "\n");
        buf.append("DestQName='" + this.destQName + "'\n");
        buf.append("DestQMgrName='" + this.destQMgrName + "'\n");
        buf.append("Encoding=" + this.encoding + "\n");
        buf.append("CodedCharSetId=" + this.codedCharSetId + "\n");
        buf.append("Format='" + this.format + "'\n");
        buf.append("PutApplType=" + this.putApplType + "\n");
        buf.append("PutApplName='" + this.putApplName + "'\n");
        buf.append("PutDate='" + this.putDate + "'\n");
        buf.append("PutTime='" + this.putTime + "'");
        String traceRet1 = buf.toString();
        return traceRet1;
    }

    void write(MQMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{message});
        }
        try {
            this.encoding = message.encoding;
            this.codedCharSetId = message.characterSet;
            this.format = message.format;
            message.encoding = 273;
            message.characterSet = 0;
            message.format = "MQDEAD  ";
            int bodyLen = message.getMessageLength();
            byte[] bodyBuffer = new byte[bodyLen];
            message.seek(0);
            message.readFully(bodyBuffer);
            message.seek(0);
            this.writeDLHFields(message);
            message.write(bodyBuffer);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1075");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
        }
    }

    protected void write(MQMessage deadMsg, MQMsg2 msg2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", new Object[]{deadMsg, msg2});
        }
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        DataOutputStream dataBuffer = new DataOutputStream(byteBuffer);
        GregorianCalendar putDateCal = new GregorianCalendar();
        try {
            this.encoding = msg2.getEncoding();
            this.codedCharSetId = msg2.getCharacterSet();
            this.format = msg2.getFormat();
            deadMsg.encoding = 273;
            deadMsg.characterSet = 0;
            deadMsg.format = "MQDEAD  ";
            deadMsg.accountingToken = msg2.getAccountingToken();
            deadMsg.applicationIdData = msg2.getApplicationIdData();
            deadMsg.applicationOriginData = msg2.getApplicationOriginData();
            deadMsg.backoutCount = msg2.getBackoutCount();
            deadMsg.correlationId = msg2.getCorrelationId();
            deadMsg.expiry = msg2.getExpiry();
            deadMsg.feedback = msg2.getFeedback();
            deadMsg.groupId = msg2.getGroupId();
            deadMsg.messageFlags = msg2.getMessageFlags();
            deadMsg.messageId = msg2.getMessageId();
            deadMsg.messageSequenceNumber = msg2.getMessageSequenceNumber();
            deadMsg.messageType = msg2.getMessageType();
            deadMsg.persistence = msg2.getPersistence();
            deadMsg.priority = msg2.getPriority();
            deadMsg.putApplicationName = msg2.getPutApplicationName();
            deadMsg.putApplicationType = msg2.getPutApplicationType();
            putDateCal.setTimeInMillis(msg2.getPutTimeMillis());
            deadMsg.putDateTime = putDateCal;
            deadMsg.replyToQueueManagerName = msg2.getReplyToQueueManagerName();
            deadMsg.replyToQueueName = msg2.getReplyToQueueName();
            deadMsg.report = msg2.getReport();
            deadMsg.userId = msg2.getUserId();
            byte[] bodyBuffer = null;
            bodyBuffer = msg2.getMessageData();
            this.writeDLHFields(deadMsg);
            dataBuffer.write(bodyBuffer);
            deadMsg.write(byteBuffer.toByteArray());
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", e);
            }
            JMSException je = ConfigEnvironment.newException("MQJMS1075");
            je.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "write(com.ibm.msg.client.wmq.v6.base.internal.MQMessage,com.ibm.msg.client.wmq.v6.base.internal.MQMsg2)");
        }
    }

    private void writeDLHFields(MQMessage m) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "writeDLHFields(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)", new Object[]{m});
        }
        m.writeString(this.strucId);
        m.writeInt(this.version);
        m.writeInt(this.reason);
        m.writeString(Utils.padString(this.destQName, 48));
        m.writeString(Utils.padString(this.destQMgrName, 48));
        m.writeInt(this.encoding);
        m.writeInt(this.codedCharSetId);
        m.writeString(this.format);
        m.writeInt(this.putApplType);
        m.writeString(Utils.padString(this.putApplName, 28));
        m.writeString(Utils.padString(this.putDate, 8));
        m.writeString(Utils.padString(this.putTime, 8));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.DLH", "writeDLHFields(com.ibm.msg.client.wmq.v6.base.internal.MQMessage)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.DLH", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/DLH.java, jmscc.wmq.v6, k701, k701-112-140304  1.20.1.2 10/08/19 11:37:06");
        }
    }
}

