/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.jms.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderExceptionListener;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.jms.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.jms.internal.MQBrokerMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQConnection;
import com.ibm.msg.client.wmq.v6.jms.internal.Utils;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;

public class Cleanup {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/Cleanup.java, jmscc.wmq.v6, k701, k701-112-140304 1.34.1.3 12/09/28 11:34:38";
    private static final String CLSNAME = "Cleanup";
    private static final String reportQueueName = "SYSTEM.JMS.REPORT.QUEUE";
    private static long assumeOld;
    private static final int CAT_SUCC_DEREG = 1;
    private static final int CAT_SUCC_STOP = 2;
    private static final int CAT_SUCCESS = 3;
    private static final int CAT_UNSUCCESS = 4;
    private static final int CAT_PCF_RESPONSE = 5;
    private static final int CAT_UNSUCCESS_DEREG = 6;
    private static final int CAT_UNRECOGNISED = 99;
    private static final int RESP_DONE = 0;
    private static final int RESP_TRY_LATER = 1;
    private static final int RESP_FAILED = 2;
    private static final byte[] dummyArray;
    private static final ByteBuffer dummyMessageText;
    private static final String[] defaultNDQueues;
    private static final byte[] blankMessageId;
    private static final int CLEANUP_PROPERTY_NOT_SET = -1;
    private static final int CLEANUP_PROPERTY_ERROR = -2;
    static int cleanupProperty;
    static String invalidCleanupValue;
    private boolean endCleanup = false;
    private ProviderExceptionListener exceptionListener = null;
    private PrintWriter printWriter = null;
    private Object runLock = new Object();
    private boolean isRunning = false;
    private long cleanupInterval = 3600000L;
    private int cleanupLevel = 1;

    public Cleanup() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "<init>()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupInterval(long interval) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupInterval(long)", new Object[]{new Long(interval)});
        }
        try {
            if (interval < 0L) {
                JMSException je = ConfigEnvironment.newException("MQJMS1006", "cleanupInterval", String.valueOf(interval));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupInterval(long)", je, 1);
                }
                throw je;
            }
            Object je = this.runLock;
            synchronized (je) {
                if (this.isRunning && (this.getCleanupLevel() == 3 || this.getCleanupLevel() == 4)) {
                    String msg = ConfigEnvironment.getMessage("MQJMS3043");
                    IllegalStateException je2 = new IllegalStateException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupInterval(long)", (Throwable)je2, 2);
                    }
                    throw je2;
                }
                this.cleanupInterval = interval;
                if (this.isRunning) {
                    this.runLock.notifyAll();
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupInterval(long)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupInterval(long)", je, 3);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupInterval(long)");
        }
    }

    public long getCleanupInterval() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "getCleanupInterval()", "getter", new Long(this.cleanupInterval));
        }
        return this.cleanupInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupLevel(int level) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)", new Object[]{new Integer(level)});
        }
        try {
            switch (level) {
                case -1: {
                    if (cleanupProperty == -2) {
                        JMSException e = ConfigEnvironment.newException("MQJMS1006", "cleanupLevel", invalidCleanupValue);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)", e, 1);
                        }
                        throw e;
                    }
                    level = cleanupProperty;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    JMSException je = ConfigEnvironment.newException("MQJMS1006", "cleanupLevel", String.valueOf(level));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)", je, 2);
                    }
                    throw je;
                }
            }
            Object je = this.runLock;
            synchronized (je) {
                if (this.isRunning && (level == 3 || level == 4) && this.getCleanupInterval() > 0L) {
                    String msg = ConfigEnvironment.getMessage("MQJMS3043");
                    IllegalStateException je2 = new IllegalStateException(msg);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)", (Throwable)je2, 3);
                    }
                    throw je2;
                }
                this.cleanupLevel = level;
                if (this.isRunning) {
                    this.runLock.notifyAll();
                }
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)", je, 4);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setCleanupLevel(int)");
        }
    }

    public int getCleanupLevel() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "getCleanupLevel()", "getter", new Integer(this.cleanupLevel));
        }
        return this.cleanupLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(MQConnection conn) {
        block42: {
            block40: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)", new Object[]{conn});
                }
                try {
                    try {
                        boolean end;
                        long cleanupInterval;
                        int level;
                        Object object = this.runLock;
                        synchronized (object) {
                            MQQueueManager qmgr = conn.getInitialQM();
                            if (qmgr == null) {
                                qmgr = conn.createQMNonXA();
                            }
                            this.isRunning = true;
                            level = this.getCleanupLevel();
                            cleanupInterval = this.getCleanupInterval();
                            if (level == 0) {
                                String msg = ConfigEnvironment.getMessage("MQJMS3044");
                                IllegalStateException traceRet1 = new IllegalStateException(msg);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)", (Throwable)traceRet1, 1);
                                }
                                throw traceRet1;
                            }
                            if ((level == 3 || level == 4) && cleanupInterval > 0L) {
                                String msg = ConfigEnvironment.getMessage("MQJMS3043");
                                IllegalStateException traceRet2 = new IllegalStateException(msg);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)", (Throwable)traceRet2, 2);
                                }
                                throw traceRet2;
                            }
                            this.endCleanup = false;
                            end = false;
                        }
                        while (!end) {
                            long timeStarted;
                            block39: {
                                String messageText;
                                String key;
                                String time;
                                String date;
                                timeStarted = System.currentTimeMillis();
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Cleanup started at " + timeStarted, null);
                                }
                                if (this.printWriter != null) {
                                    GregorianCalendar gc = new GregorianCalendar();
                                    date = Utils.getDate(gc);
                                    time = Utils.getTime(gc);
                                    key = "MQJMS3052";
                                    messageText = ConfigEnvironment.getMessage(key, time, date);
                                    this.printWriter.println(messageText);
                                    this.printWriter.flush();
                                }
                                try {
                                    void var6_4;
                                    this.performCleanup((MQQueueManager)var6_4, level);
                                    if (this.printWriter != null) {
                                        GregorianCalendar gc = new GregorianCalendar();
                                        date = Utils.getDate(gc);
                                        time = Utils.getTime(gc);
                                        key = "MQJMS3053";
                                        messageText = ConfigEnvironment.getMessage(key, time, date);
                                        this.printWriter.println(messageText);
                                        this.printWriter.flush();
                                    }
                                }
                                catch (JMSException je) {
                                    ProviderExceptionListener el;
                                    if (Trace.isOn) {
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)", je, 1);
                                    }
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "run - informing ProviderExceptionListener", null);
                                    }
                                    if ((el = this.exceptionListener) == null) break block39;
                                    el.onException(je, true);
                                }
                            }
                            boolean cont = false;
                            Object object2 = this.runLock;
                            synchronized (object2) {
                                while (!cont) {
                                    cleanupInterval = this.getCleanupInterval();
                                    level = this.getCleanupLevel();
                                    if (this.endCleanup || cleanupInterval == 0L) {
                                        cont = true;
                                        end = true;
                                        continue;
                                    }
                                    long waitFor = timeStarted + cleanupInterval - System.currentTimeMillis();
                                    if (waitFor > 0L) {
                                        if (Trace.isOn) {
                                            Trace.traceData(this, "Sleeping for " + waitFor, null);
                                        }
                                        if (this.printWriter != null) {
                                            String key = "MQJMS3054";
                                            long waitTimeInSeconds = waitFor / 1000L;
                                            long waitTimeInMinutes = waitTimeInSeconds / 60L;
                                            String insert = String.valueOf(waitTimeInMinutes);
                                            String messageText = ConfigEnvironment.getMessage(key, insert);
                                            this.printWriter.println(messageText);
                                            this.printWriter.flush();
                                        }
                                        try {
                                            this.runLock.wait(waitFor);
                                        }
                                        catch (InterruptedException ie) {
                                            if (!Trace.isOn) continue;
                                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)", ie, 2);
                                        }
                                        continue;
                                    }
                                    cont = true;
                                }
                            }
                        }
                        Object var22_28 = null;
                        if (!Trace.isOn) break block40;
                    }
                    catch (JMSException je) {
                        ProviderExceptionListener el;
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)", je, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "run - informing ProviderExceptionListener", null);
                        }
                        if ((el = this.exceptionListener) != null) {
                            el.onException(je, true);
                        }
                        Object var22_29 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)");
                        }
                        Object object = this.runLock;
                        synchronized (object) {
                            this.isRunning = false;
                            this.runLock.notifyAll();
                            break block42;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var22_30 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)");
                    }
                    Object object = this.runLock;
                    synchronized (object) {
                        this.isRunning = false;
                        this.runLock.notifyAll();
                        throw throwable;
                    }
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)");
            }
            Object object = this.runLock;
            synchronized (object) {
                this.isRunning = false;
                this.runLock.notifyAll();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "run(MQConnection)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "stop()");
        }
        Object object = this.runLock;
        synchronized (object) {
            if (this.isRunning && !this.endCleanup) {
                this.endCleanup = true;
                this.runLock.notifyAll();
            }
            while (this.isRunning) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Cleanup still running: wait", null);
                }
                try {
                    this.runLock.wait();
                }
                catch (InterruptedException ie) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "stop()", ie);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "stop()");
        }
    }

    public void setExceptionListener(ProviderExceptionListener el) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setExceptionListener(ProviderExceptionListener)", "setter", el);
        }
        this.exceptionListener = el;
    }

    public ProviderExceptionListener getExceptionListener() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "getExceptionListener()", "getter", this.exceptionListener);
        }
        return this.exceptionListener;
    }

    public boolean isRunning() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "isRunning()", "getter", this.isRunning);
        }
        return this.isRunning;
    }

    public void cleanup(MQConnection conn) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanup(MQConnection)", new Object[]{conn});
        }
        try {
            int cleanupLevel;
            MQQueueManager qmgr = conn.getInitialQM();
            if (qmgr == null) {
                qmgr = conn.createQMNonXA();
            }
            if ((cleanupLevel = this.getCleanupLevel()) == 0) {
                String msg = ConfigEnvironment.getMessage("MQJMS3044");
                IllegalStateException traceRet1 = new IllegalStateException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanup(MQConnection)", (Throwable)traceRet1, 1);
                }
                throw traceRet1;
            }
            this.performCleanup(qmgr, cleanupLevel);
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanup(MQConnection)", je);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanup(MQConnection)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanup(MQConnection)");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCleanup(MQQueueManager qmgr, int level) throws JMSException {
        block85: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", new Object[]{qmgr, new Integer(level)});
            }
            reportQueue = null;
            currentTime = 0L;
            try {
                block86: {
                    if (level != 0) break block86;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Cleanup level is NONE; skipping cleanup", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", 1);
                    }
                    var23_5 = null;
                    if (!Trace.isOn) ** GOTO lbl269
                    ** GOTO lbl268
                }
                openOptions = 8216;
                switch (level) {
                    case 1: 
                    case 2: {
                        openOptions |= 2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        openOptions |= 4;
                        break;
                    }
                    default: {
                        je = ConfigEnvironment.newException("MQJMS1016", "Bad level " + level + " encountered in Cleanup");
                        if (Trace.isOn == false) throw je;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 1);
                        throw je;
                    }
                }
                try {
                    reportQueue = qmgr.accessQueue("SYSTEM.JMS.REPORT.QUEUE", openOptions);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 1);
                    }
                    if (mqe.reasonCode != 2042) {
                        je = ConfigEnvironment.newException("MQJMS2008", "SYSTEM.JMS.REPORT.QUEUE");
                        je.setLinkedException((Exception)mqe);
                        if (Trace.isOn == false) throw je;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 4);
                        throw je;
                    }
                    if ((openOptions & 2) == 2) {
                        je = ConfigEnvironment.newException("MQJMS3045", "SYSTEM.JMS.REPORT.QUEUE");
                        je.setLinkedException((Exception)mqe);
                        if (Trace.isOn == false) throw je;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 2);
                        throw je;
                    }
                    je = ConfigEnvironment.newException("MQJMS3046", "SYSTEM.JMS.REPORT.QUEUE");
                    je.setLinkedException((Exception)mqe);
                    if (Trace.isOn == false) throw je;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 3);
                    throw je;
                }
                try {
                    dummyMsg = new MQMsg2();
                    dummyMsg.setMessageData(Cleanup.dummyMessageText);
                    dummyMsg.setCharacterSet(1208);
                    dummyMsg.setPersistence(0);
                    dummyPMO = new MQPutMessageOptions();
                    dummyPMO.options = 8194;
                    reportQueue.putMsg2(dummyMsg, dummyPMO);
                    currentTime = dummyMsg.getPutTimeMillis();
                    qmgr.backout();
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 2);
                    }
                    je = ConfigEnvironment.newException("MQJMS2007");
                    je.setLinkedException((Exception)mqe);
                    if (Trace.isOn == false) throw je;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 5);
                    throw je;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "Current MQ clock is " + currentTime, null);
                }
                done = false;
                msg = new MQMsg2();
                gmo = new MQGetMessageOptions();
                first = true;
                while (!done) {
                    block84: {
                        haveMessage = false;
                        category = 0;
                        gmo.options = 8704;
                        gmo.options = first ? (gmo.options |= 16) : (gmo.options |= 32);
                        gmo.matchOptions = 0;
                        try {
                            reportQueue.getMsg2(msg, gmo);
                            haveMessage = true;
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 3);
                            }
                            if (mqe.reasonCode != 2033) {
                                je = ConfigEnvironment.newException("MQJMS2002");
                                je.setLinkedException((Exception)mqe);
                                if (Trace.isOn == false) throw je;
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 6);
                                throw je;
                            }
                            done = true;
                        }
                        if (done) continue;
                        if (Trace.isOn) {
                            Trace.traceData(this, "Found message on report queue", null);
                        }
                        age = 0L;
                        try {
                            age = currentTime - msg.getPutTimeMillis();
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 4);
                            }
                            detail = "Unexpected error from getPutTimeMillis (" + (Object)mqe + ")";
                            je = ConfigEnvironment.newException("MQJMS1016", detail);
                            je.setLinkedException((Exception)mqe);
                            if (Trace.isOn == false) throw je;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 7);
                            throw je;
                        }
                        mqbm = null;
                        try {
                            mqbm = MQBrokerMessage.fromMessage(msg);
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 5);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "ProviderMessage is not a broker message", null);
                            }
                            category = 99;
                        }
                        try {
                            if (mqbm == null) break block84;
                            command = mqbm.get("MQPSCommand");
                            compCode = mqbm.get("MQPSCompCode");
                            reasonCode = mqbm.get("MQPSReason");
                            reasonText = mqbm.get("MQPSReasonText");
                            if (Trace.isOn) {
                                Trace.traceData(this, "ProviderMessage has command '" + command + "'", null);
                                Trace.traceData(this, "ProviderMessage has completion code '" + compCode + "'", null);
                                Trace.traceData(this, "ProviderMessage has reason code '" + reasonCode + "'", null);
                                Trace.traceData(this, "ProviderMessage has reason text '" + reasonText + "'", null);
                            }
                            if ("DeregSub".equals(command) || reasonText.equals("MQRCCF_NOT_REGISTERED") || reasonText.equals(Integer.toString(3073))) {
                                if (compCode != null && compCode.equals("0")) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "ProviderMessage is response to dereg sub w. full data", null);
                                    }
                                    category = 1;
                                    break block84;
                                } else {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "ProviderMessage is response to unsuccessful dereg sub", null);
                                    }
                                    category = 6;
                                }
                                break block84;
                            }
                            if ("RegSub".equals(command)) {
                                if (compCode != null && compCode.equals("0")) {
                                    poro = mqbm.isOptionSet("MQPSRegOpts", "PubOnReqOnly");
                                    if (poro) {
                                        if (Trace.isOn) {
                                            Trace.traceData(this, "ProviderMessage is response to reg sub w. poro", null);
                                        }
                                        category = 2;
                                        break block84;
                                    } else {
                                        if (Trace.isOn) {
                                            Trace.traceData(this, "ProviderMessage appears to be response to reg sub, setting to remove message and subs (CAT_SUCC_STOP)", null);
                                        }
                                        category = 2;
                                    }
                                    break block84;
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "ProviderMessage is response to unsuccessful reg sub", null);
                                }
                                category = 4;
                                break block84;
                            }
                            if (command == null) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "ProviderMessage has no command field", null);
                                }
                                category = compCode == null ? 99 : (compCode.equals("0") ? 3 : 4);
                            } else {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "ProviderMessage has unrecognised command field", null);
                                }
                                category = 99;
                            }
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 6);
                            }
                            detail = "Error dealing with MQBrokerMessage (" + je.toString() + ")";
                            je2 = ConfigEnvironment.newException("MQJMS1016", detail);
                            je2.setLinkedException((Exception)je);
                            if (Trace.isOn == false) throw je2;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je2, 8);
                            throw je2;
                        }
                    }
                    try {
                        if (category == 99 && msg.getFormat().equals("MQADMIN ") && msg.getMessageType() == 2) {
                            category = 5;
                        }
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 7);
                        }
                        detail = "Could not fetch header data from MQMsg2 (" + (Object)mqe + ")";
                        je = ConfigEnvironment.newException("MQJMS1016", detail);
                        je.setLinkedException((Exception)mqe);
                        if (Trace.isOn == false) throw je;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 9);
                        throw je;
                    }
                    v0 = sufficientlyOld = age >= Cleanup.assumeOld;
                    if (Trace.isOn) {
                        Trace.traceData(this, "ProviderMessage is of category " + category, null);
                        if (sufficientlyOld) {
                            Trace.traceData(this, "ProviderMessage is sufficiently old", null);
                        } else {
                            Trace.traceData(this, "ProviderMessage is not sufficiently old", null);
                        }
                    }
                    process = false;
                    switch (level) {
                        case 1: {
                            if (sufficientlyOld && (category == 1 || category == 2 || category == 3 || category == 5)) {
                                process = true;
                                break;
                            }
                            process = false;
                            break;
                        }
                        case 2: {
                            if (sufficientlyOld) {
                                process = true;
                                break;
                            }
                            process = false;
                            break;
                        }
                        case 3: 
                        case 4: {
                            process = true;
                            break;
                        }
                        default: {
                            je = ConfigEnvironment.newException("MQJMS1016", "Bad level " + level + " encountered in Cleanup");
                            if (Trace.isOn == false) throw je;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 10);
                            throw je;
                        }
                    }
                    removeMessage = false;
                    result = 1;
                    if (process) {
                        result = this.processMessage(qmgr, msg, mqbm, category);
                    }
                    if (removeMessage = level == 4 ? true : (result == 0 ? true : category == 6)) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "Removing message", null);
                        }
                        try {
                            gmo.options = 8512;
                            reportQueue.getMsg2(msg, gmo, 1);
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 8);
                            }
                            if (mqe.reasonCode == 2079) ** GOTO lbl244
                            je = ConfigEnvironment.newException("MQJMS1016");
                            je.setLinkedException((Exception)mqe);
                            if (Trace.isOn == false) throw je;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 11);
                            throw je;
                        }
                    } else if (Trace.isOn) {
                        Trace.traceData(this, "Leaving message on queue", null);
                    }
lbl244:
                    // 5 sources

                    first = false;
                }
                if (level == 4) {
                    this.cleanupNonDur(qmgr, reportQueue);
                }
                ** GOTO lbl277
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 9);
                }
                if (Trace.isOn == false) throw je;
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", je, 12);
                throw je;
            }
            {
                catch (Throwable var22_51) {
                    var23_7 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)");
                    }
                    try {
                        if (reportQueue == null) throw var22_51;
                        reportQueue.close();
                        throw var22_51;
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn == false) throw var22_51;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 10);
                    }
                    throw var22_51;
                }
lbl268:
                // 1 sources

                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)");
lbl269:
                // 2 sources

                ** try [egrp 10[TRYBLOCK] [13 : 1946->1957)] { 
lbl270:
                // 1 sources

                if (reportQueue == null) return;
                reportQueue.close();
                return;
lbl273:
                // 1 sources

                catch (MQException mqe) {
                    if (Trace.isOn == false) return;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 10);
                }
                return;
lbl277:
                // 1 sources

                var23_6 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)");
                }
                ** try [egrp 10[TRYBLOCK] [13 : 1946->1957)] { 
lbl281:
                // 1 sources

                if (reportQueue != null) {
                    reportQueue.close();
                }
lbl285:
                // 1 sources

                catch (MQException mqe) {}
                if (!Trace.isOn) break block85;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", mqe, 10);
            }
        }
        if (Trace.isOn == false) return;
        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "performCleanup(MQQueueManager,int)", 2);
    }

    private int processMessage(MQQueueManager qmgr, MQMsg2 msg, MQBrokerMessage mqbm, int category) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", new Object[]{qmgr, msg, mqbm, new Integer(category)});
        }
        int out = 2;
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "Category " + category + " message", null);
            }
            switch (category) {
                case 1: 
                case 2: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Cleaning up any orphaned message", null);
                    }
                    if (mqbm.isOptionSet("MQPSRegOpts", "CorrelAsId")) {
                        try {
                            String qmName = mqbm.get("MQPSQMgrName");
                            String qName = mqbm.get("MQPSQName");
                            String correlId = mqbm.get("MQPSCorrelId");
                            byte[] correlIdAsBytes = Utils.hexToBytes(correlId);
                            if (qmName != null && qmName.equals(qmgr.name) && qName != null && correlId != null && correlIdAsBytes != null && correlIdAsBytes.length == 24) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Removing messages with correlId " + correlId + " from " + qName, null);
                                }
                                Cleanup.removeMessages(qmgr, qName, correlIdAsBytes);
                                out = 0;
                                break;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Response message has surprising information - ignoring", null);
                            }
                            out = 2;
                        }
                        catch (JMSException je) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", je, 1);
                            }
                            out = 2;
                        }
                        break;
                    }
                    try {
                        String qmName = mqbm.get("MQPSQMgrName");
                        String qName = mqbm.get("MQPSQName");
                        String topic = mqbm.get("MQPSTopic");
                        if (qmName != null && qmName.trim().equals(qmgr.name.trim()) && qName != null) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Removing dynamic queue " + qName, null);
                            }
                            if (topic != null && topic.trim().equals("JMS:SYS:Unknown") && qName.trim().equals(reportQueueName)) {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Found durable subscriber unsubscribe request response, flagging to remove", null);
                                }
                                out = 0;
                                break;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Removing dynamic queue " + qName, null);
                            }
                            Cleanup.removeDynamicQueue(qmgr, qName);
                            out = 0;
                            break;
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Reponse message has surprising information - ignoring", null);
                        }
                        out = 2;
                    }
                    catch (TransactionInProgressException tipe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", tipe, 2);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Will retry this cleanup later", null);
                        }
                        out = 1;
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", je, 3);
                        }
                        out = 2;
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 99: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Nothing to do", null);
                    }
                    out = 0;
                    break;
                }
                default: {
                    JMSException je = ConfigEnvironment.newException("MQJMS1016");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", je, 1);
                    }
                    throw je;
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", new Integer(out));
            }
            return out;
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", je, 4);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "processMessage(MQQueueManager,MQMsg2,MQBrokerMessage,int)", je, 2);
            }
            throw je;
        }
    }

    /*
     * Loose catch block
     */
    static void removeMessages(MQQueueManager qmgr, String qName, byte[] correlId) throws JMSException {
        block30: {
            MQQueue q;
            block29: {
                if (Trace.isOn) {
                    Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", new Object[]{qmgr, qName, correlId});
                }
                q = null;
                try {
                    q = qmgr.accessQueue(qName, 8193);
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", mqe, 1);
                    }
                    if (mqe.reasonCode == 2085) {
                        block28: {
                            if (Trace.isOn) {
                                Trace.traceData(CLSNAME, "Queue doesn't exist. No messages to remove.", null);
                            }
                            if (Trace.isOn) {
                                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", 1);
                            }
                            Object var7_6 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])");
                            }
                            try {
                                if (q != null) {
                                    q.close();
                                }
                            }
                            catch (MQException mqe2) {
                                if (Trace.isOn) {
                                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", mqe2, 3);
                                }
                                if (!Trace.isOn) break block28;
                                Trace.traceData(CLSNAME, "Ignoring exception from queue.close()", null);
                            }
                        }
                        return;
                    }
                    JMSException je = ConfigEnvironment.newException("MQJMS3014", qName);
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", je, 1);
                    }
                    throw je;
                }
                Cleanup.removeMessages(q, correlId);
                Object var7_7 = null;
                if (!Trace.isOn) break block29;
                Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])");
            }
            try {
                if (q != null) {
                    q.close();
                }
                break block30;
            }
            catch (MQException mqe2) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", mqe2, 3);
                }
                if (Trace.isOn) {
                    Trace.traceData(CLSNAME, "Ignoring exception from queue.close()", null);
                }
                break block30;
            }
            {
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", je, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", je, 2);
                    }
                    throw je;
                }
            }
            catch (Throwable throwable) {
                block31: {
                    Object var7_8 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])");
                    }
                    try {
                        if (q != null) {
                            q.close();
                        }
                    }
                    catch (MQException mqe2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", mqe2, 3);
                        }
                        if (!Trace.isOn) break block31;
                        Trace.traceData(CLSNAME, "Ignoring exception from queue.close()", null);
                    }
                }
                throw throwable;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeMessages(MQQueueManager,String,byte [ ])", 2);
        }
    }

    /*
     * Exception decompiling
     */
    static void removeMessages(MQQueue queue, byte[] correlId) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static void removeMessages(MQQueue queue) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void removeDynamicQueue(MQQueueManager qmgr, String qName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", new Object[]{qmgr, qName});
        }
        try {
            MQQueue q = null;
            try {
                q = qmgr.accessQueue(qName, 8196);
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", mqe, 1);
                }
                if (mqe.reasonCode == 2042) {
                    try {
                        if (Trace.isOn) {
                            Trace.traceData(CLSNAME, "Dynamic Queue " + qName + " in use (mqrc2042), removing anyway.", null);
                        }
                        q = qmgr.accessQueue(qName, 8194);
                    }
                    catch (MQException me) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", me, 2);
                        }
                        if (mqe.reasonCode == 2085 || mqe.reasonCode == 2052) {
                            if (Trace.isOn) {
                                Trace.traceData(CLSNAME, "Queue doesn't exist.", null);
                            }
                            if (Trace.isOn) {
                                Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", 1);
                            }
                            return;
                        }
                        JMSException je = ConfigEnvironment.newException("MQJMS3014", qName);
                        je.setLinkedException((Exception)((Object)me));
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", je, 1);
                        }
                        throw je;
                    }
                }
                if (mqe.reasonCode == 2085 || mqe.reasonCode == 2052) {
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "Queue doesn't exist.", null);
                    }
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", 2);
                    }
                    return;
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3014", qName);
                je.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", je, 2);
                }
                throw je;
            }
            q.closeOptions = 2;
            try {
                q.close();
            }
            catch (MQException mqe) {
                block33: {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", mqe, 3);
                    }
                    if (Trace.isOn) {
                        Trace.traceData(CLSNAME, "DELETE_PURGE failed", null);
                    }
                    q.closeOptions = 0;
                    try {
                        q.close();
                    }
                    catch (MQException mqe2) {
                        if (Trace.isOn) {
                            Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", mqe2, 4);
                        }
                        if (!Trace.isOn) break block33;
                        Trace.traceData(CLSNAME, "Ignoring MQException on close", null);
                    }
                }
                if (mqe.reasonCode == 2045) {
                    String msg = ConfigEnvironment.getMessage("MQJMS0010");
                    TransactionInProgressException je = new TransactionInProgressException(msg);
                    je.setLinkedException((Exception)((Object)mqe));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", je, 3);
                    }
                    throw je;
                }
                JMSException je = ConfigEnvironment.newException("MQJMS3017", qName);
                je.setLinkedException((Exception)((Object)mqe));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", je, 4);
                }
                throw je;
            }
        }
        catch (JMSException je) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", je, 5);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", je, 5);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "removeDynamicQueue(MQQueueManager,String)", 3);
        }
    }

    public static String resolveQMName(MQConnection conn) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "resolveQMName(MQConnection)", new Object[]{conn});
        }
        String resolvedName = null;
        MQQueueManager qmgr = null;
        qmgr = conn.getInitialQM();
        if (qmgr == null) {
            qmgr = conn.createQMNonXA();
        }
        if (qmgr != null) {
            resolvedName = Utils.inquireString(qmgr, 2015);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "resolveQMName(MQConnection)", (Object)resolvedName);
        }
        return resolvedName;
    }

    private void cleanupNonDur(MQQueueManager qmgr, MQQueue reportQueue) {
        String[] queues;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanupNonDur(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", new Object[]{qmgr, reportQueue});
        }
        if ((queues = Utils.listMatchingQueues(qmgr, reportQueue, "SYSTEM.JMS.ND.*")) == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "listMatchingQueues failed; only clearing out known SYSTEM.JMS.ND.* queues", null);
            }
            queues = defaultNDQueues;
        }
        for (int i = 0; i < queues.length; ++i) {
            MQQueue queue;
            block31: {
                block30: {
                    String qName = queues[i];
                    queue = null;
                    if (Trace.isOn) {
                        Trace.traceData(this, "Dealing with queue " + qName, null);
                    }
                    try {
                        queue = qmgr.accessQueue(qName, 8228);
                        if (Trace.isOn) {
                            Trace.traceData(this, "Opened queue for input and inquire", null);
                        }
                        int defType = queue.getDefinitionType();
                        if (Trace.isOn) {
                            Trace.traceData(this, "Definition type is " + defType, null);
                        }
                        boolean delete = false;
                        boolean error = false;
                        switch (defType) {
                            case 1: 
                            case 3: {
                                delete = false;
                                break;
                            }
                            case 2: {
                                String trimmed = qName.trim();
                                int beginIndex = trimmed.length() - 16;
                                if (beginIndex < 0) {
                                    delete = false;
                                    break;
                                }
                                String last16 = trimmed.substring(beginIndex);
                                char[] char16 = last16.toCharArray();
                                delete = true;
                                for (int j = 0; j < 16 && delete; ++j) {
                                    if (char16[j] >= '0' && char16[j] <= '9' || char16[j] >= 'a' && char16[j] <= 'z' || char16[j] >= 'A' && char16[j] <= 'Z') continue;
                                    delete = false;
                                }
                                break;
                            }
                            default: {
                                if (Trace.isOn) {
                                    Trace.traceData(this, "WARNING: Unrecognised definition type", null);
                                }
                                error = true;
                                delete = false;
                            }
                        }
                        if (!error && !delete) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Removing messages from queue", null);
                            }
                            Cleanup.removeMessages(queue);
                        } else if (!error && delete) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Setting queue.closeOptions to DELETE_PURGE", null);
                            }
                            queue.closeOptions = 2;
                        }
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanupNonDur(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", mqe, 1);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Ignoring exception while performing NONDUR cleanup:", null);
                        }
                    }
                    catch (JMSException je) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanupNonDur(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", je, 2);
                        }
                        if (!Trace.isOn) break block30;
                        Trace.traceData(this, "Ignoring exception while performing NONDUR cleanup:", null);
                    }
                }
                try {
                    if (queue != null) {
                        queue.close();
                    }
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanupNonDur(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)", mqe, 3);
                    }
                    if (!Trace.isOn) break block31;
                    Trace.traceData(this, "Ignoring exception on queue.close", null);
                }
            }
            queue = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "cleanupNonDur(MQQueueManager,com.ibm.msg.client.wmq.v6.base.internal.MQQueue)");
        }
    }

    public void setPrintWriter(PrintWriter pw) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "setPrintWriter(PrintWriter)", "setter", pw);
        }
        this.printWriter = pw;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/jms/internal/Cleanup.java, jmscc.wmq.v6, k701, k701-112-140304  1.34.1.3 12/09/28 11:34:38");
        }
        assumeOld = 60000L;
        dummyArray = new byte[]{77, 81, 32, 74, 77, 83, 32, 67, 108, 101, 97, 110, 117, 112, 32, 84, 101, 109, 112, 111, 114, 97, 114, 121, 32, 77, 101, 115, 115, 97, 103, 101};
        dummyMessageText = ByteBuffer.wrap(dummyArray);
        defaultNDQueues = new String[]{"SYSTEM.JMS.ND.SUBSCRIBER.QUEUE", "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE"};
        blankMessageId = new byte[24];
        cleanupProperty = -1;
        invalidCleanupValue = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "static()");
        }
        String cleanupPropertyName = "com.ibm.mq.jms.cleanup";
        PropertyStore.register(cleanupPropertyName, "");
        String levelName = PropertyStore.getStringProperty(cleanupPropertyName);
        if (levelName != null) {
            if ((levelName = levelName.toUpperCase()).equals("NONE")) {
                cleanupProperty = 0;
            } else if (levelName.equals("SAFE")) {
                cleanupProperty = 1;
            } else if (levelName.equals("STRONG")) {
                cleanupProperty = 2;
            } else {
                cleanupProperty = -2;
                invalidCleanupValue = levelName;
            }
        }
        if (cleanupProperty == -1) {
            cleanupProperty = 1;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.jms.internal.Cleanup", "static()");
        }
    }
}

