/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.disthub2.spi.ExceptionConstants;
import com.ibm.mq.jms.JMSListenerSetException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.JMSWrappedException;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl;
import java.io.Serializable;
import java.util.HashMap;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements ClientExceptionConstants,
ExceptionConstants,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/TopicSubscriberImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.12.1.1 09/08/17 08:48:32";
    private static final long serialVersionUID = -7718791450874296380L;
    private static final DebugObject debug;
    public TopicSessionImpl jmsSession;

    TopicSubscriberImpl(WMQDestination topic, String selector, String appName, boolean noLocalMessages, int subMode, TopicSessionImpl session, JmsPropertyContext propertyContext) throws JMSException {
        super(topic, selector, appName, noLocalMessages, subMode, session, propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "<init>(WMQDestination,String,String,boolean,int,TopicSessionImpl,JmsPropertyContext)", new Object[]{topic, selector, appName, noLocalMessages, new Integer(subMode), session, propertyContext});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "<init>(WMQDestination,String,String,boolean,int,TopicSessionImpl,JmsPropertyContext)");
        }
    }

    public WMQDestination getTopic() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTopic");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTopic", (Object)this.topic);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "getTopic()", "getter", this.topic);
        }
        return this.topic;
    }

    protected void deliverGapToExceptionListener(MessageImpl msg) {
        ConnectionImpl ci;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "deliverGapToExceptionListener(MessageImpl)", new Object[]{msg});
        }
        if ((ci = this.getSession().getConnection()) != null) {
            JMSException je = new JMSException(ExceptionBuilder.buildReasonString((int)-1954489557, (Object[])new Object[]{new Long(msg.gsTic)}));
            ci.deliverException((Exception)((Object)je), false);
        } else {
            HashMap<String, String> ffstData = new HashMap<String, String>();
            ffstData.put("ConnectionImpl", "null");
            Trace.ffst(this, "deliverGapToExceptionListener(MessageImpl)", "XO007001", ffstData, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "deliverGapToExceptionListener(MessageImpl)");
        }
    }

    public ProviderMessage receive() throws JMSListenerSetException, IllegalStateException, JMSWrappedException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "receive()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receive");
        }
        MessageImpl msg = null;
        this.ackLatest(false);
        while ((msg = (MessageImpl)super.receive()) != null) {
            this.subInfo.latest = msg;
            this.subInfo.acked = false;
            if (msg.gapMsg) {
                this.deliverGapToExceptionListener(msg);
                continue;
            }
            if (msg.silenceMsg) continue;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"receive");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "receive()", msg);
        }
        return msg;
    }

    public ProviderMessage receive(long timeOut) throws JMSException, IllegalStateException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "receive(long)", new Object[]{new Long(timeOut)});
        }
        MessageImpl msg = null;
        this.ackLatest(false);
        while ((msg = (MessageImpl)super.receive(timeOut)) != null) {
            this.subInfo.latest = msg;
            this.subInfo.acked = false;
            if (msg.gapMsg) {
                this.deliverGapToExceptionListener(msg);
                continue;
            }
            if (msg.silenceMsg) continue;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "receive(long)", msg);
        }
        return msg;
    }

    public ProviderMessage receiveNoWait() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "receiveNoWait()");
        }
        MessageImpl msg = null;
        this.ackLatest(false);
        while ((msg = (MessageImpl)super.receiveNoWait()) != null) {
            this.subInfo.latest = msg;
            this.subInfo.acked = false;
            if (msg.gapMsg) {
                this.deliverGapToExceptionListener(msg);
                continue;
            }
            if (msg.silenceMsg) continue;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "receiveNoWait()", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatch(MessageImpl msg) {
        block13: {
            block12: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "dispatch(MessageImpl)", new Object[]{msg});
                }
                if (debug.debugIt(32)) {
                    debug.debug(-165922073994779L, (Object)"dispatch", (Object)msg);
                }
                this.acquireUpReadLock();
                this.subInfo.latest = msg;
                this.subInfo.acked = false;
                try {
                    if (msg.gapMsg) {
                        this.deliverGapToExceptionListener(msg);
                    } else if (!msg.silenceMsg) {
                        this.activeListener.onMessage(msg);
                    }
                    Object var3_2 = null;
                    if (!Trace.isOn) break block12;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "dispatch(MessageImpl)");
                    }
                    this.releaseUpReadLock();
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "dispatch(MessageImpl)");
            }
            this.releaseUpReadLock();
            try {
                this.ackLatest(false);
            }
            catch (Exception e) {
                ConnectionImpl c;
                SessionImpl s;
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "dispatch(MessageImpl)", e);
                }
                if ((s = this.getSession()) == null || (c = s.getConnection()) == null) break block13;
                c.connectionDropped(e, false);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "dispatch(MessageImpl)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/TopicSubscriberImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.12.1.1 09/08/17 08:48:32");
        }
        debug = new DebugObject("TopicSubscriberImpl");
    }
}

