/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.security.MinCrypto;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TemporaryTopicImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.MQMessageProducer;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public final class TopicSessionImpl
extends SessionImpl
implements ProviderSession,
ClientExceptionConstants,
Serializable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/TopicSessionImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.16.1.1 09/08/17 08:48:20";
    private static final long serialVersionUID = -707352621412550726L;
    private static final MinCrypto cryptorand;
    private String unlikely;
    private int topicCounter;
    private static final char MIN_TEMP_TOPIC_CHAR = '0';
    private static final char MAX_TEMP_TOPIC_CHAR = 'z';
    private static final char[] TEMP_TOPIC_CHARS;

    TopicSessionImpl(ConnectionImpl connection, boolean transacted, int ackMode, JmsPropertyContext propertyContext) throws JMSInvalidParameterException, JMSNotSupportedException {
        super(connection, transacted, ackMode, propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "<init>(ConnectionImpl,boolean,int,JmsPropertyContext)", new Object[]{connection, transacted, new Integer(ackMode), propertyContext});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "<init>(ConnectionImpl,boolean,int,JmsPropertyContext)");
        }
    }

    private void makeUnlikely() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "makeUnlikely()");
        }
        byte[] bytes = cryptorand.random(20);
        StringBuffer sbuf = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            char c = TEMP_TOPIC_CHARS[Math.abs(bytes[i] % TEMP_TOPIC_CHARS.length)];
            sbuf.append(c);
        }
        this.unlikely = sbuf.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "makeUnlikely()");
        }
    }

    public TopicSubscriberImpl createSubscriber(WMQDestination topic, String messageSelector, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,JmsPropertyContext)", new Object[]{topic, messageSelector, propertyContext});
        }
        TopicSubscriberImpl result = this.createSubscriber(topic, messageSelector, false, propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,JmsPropertyContext)", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriberImpl createSubscriber(WMQDestination topic, String messageSelector, boolean noLocal, JmsPropertyContext propertyContext) throws JMSException {
        int brokerVersion;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", new Object[]{topic, messageSelector, noLocal, propertyContext});
        }
        WMQDestination mqtopic = null;
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (topic == null || topic.toString().length() == 0) {
            if (Trace.isOn) {
                Trace.traceData(this, "Topic is Null", null);
            }
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            InvalidDestinationException traceRet2 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!topic.isTopic()) {
            if (Trace.isOn) {
                Trace.traceData(this, "Not an MQTopic", null);
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException traceRet3 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        mqtopic = topic;
        if (mqtopic.containsAnyWildcard() && ((brokerVersion = mqtopic.getIntProperty("brokerVersion")) == 0 || brokerVersion == -1)) {
            if (Trace.isOn) {
                Trace.traceData(this, "Invalid wildcard", null);
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException traceRet4 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        if (topic instanceof TemporaryTopicImpl && !((TemporaryTopicImpl)topic).isCreatedOnThisConnection(this)) {
            if (Trace.isOn) {
                Trace.traceData(this, "Temporary Topic not created on this connection", null);
            }
            JMSException traceRet5 = new JMSException(ExceptionBuilder.buildReasonString((int)793507705, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", traceRet5, 5);
            }
            throw traceRet5;
        }
        TopicSubscriberImpl newSubscriber = new TopicSubscriberImpl(mqtopic, messageSelector, null, noLocal, this.getConnection().isPre1_2() ? 1 : 2, this, propertyContext);
        TopicSessionImpl topicSessionImpl = this;
        synchronized (topicSessionImpl) {
            this.consumers.addElement(newSubscriber);
            if (!this.isStopped()) {
                newSubscriber.start();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createSubscriber(WMQDestination,String,boolean,JmsPropertyContext)", newSubscriber);
        }
        return newSubscriber;
    }

    public TopicSubscriberImpl createDurableSubscriber(WMQDestination topic, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createDurableSubscriber(WMQDestination,String)", new Object[]{topic, name});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createDurableSubscriber(WMQDestination,String)", traceRet1);
        }
        throw traceRet1;
    }

    public TopicSubscriberImpl createDurableSubscriber(WMQDestination topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createDurableSubscriber(WMQDestination,String,String,boolean)", new Object[]{topic, name, messageSelector, noLocal});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createDurableSubscriber(WMQDestination,String,String,boolean)", traceRet1);
        }
        throw traceRet1;
    }

    public TopicSubscriberImpl createDurableSubscriber(WMQDestination topic, String name, String messageSelector) throws JMSParameterIsNullException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createDurableSubscriber(WMQDestination,String,String)", new Object[]{topic, name, messageSelector});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createDurableSubscriber(WMQDestination,String,String)", traceRet1);
        }
        throw traceRet1;
    }

    public TopicPublisherImpl createPublisher(WMQDestination topic, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createPublisher(WMQDestination,JmsPropertyContext)", new Object[]{topic, propertyContext});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createPublisher(WMQDestination,JmsPropertyContext)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        TopicPublisherImpl newPublisher = new TopicPublisherImpl(topic, this, propertyContext);
        this.producers.addElement(newPublisher);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createPublisher(WMQDestination,JmsPropertyContext)", newPublisher);
        }
        return newPublisher;
    }

    public TemporaryTopicImpl createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createTemporaryTopic()");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createTemporaryTopic()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (this.unlikely == null) {
            this.makeUnlikely();
        }
        String topic = this.unlikely + '/' + this.topicCounter++;
        TemporaryTopicImpl result = new TemporaryTopicImpl(this, this.getConnection().getTemporaryTopicString(topic), (JmsPropertyContext)this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createTemporaryTopic()", result);
        }
        return result;
    }

    public void unsubscribe(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "unsubscribe(String)", new Object[]{name});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "unsubscribe(String)", traceRet1);
        }
        throw traceRet1;
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close()");
        }
        super.close(null, true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close()");
        }
    }

    public void close(Exception e, boolean appClose) throws JMSException {
        int i;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close(Exception,boolean)", new Object[]{e, appClose});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close(Exception,boolean)", 1);
            }
            return;
        }
        if (this.consumers != null) {
            Vector tempSubscribers = (Vector)this.consumers.clone();
            for (i = 0; i < tempSubscribers.size(); ++i) {
                TopicSubscriberImpl subscriber = (TopicSubscriberImpl)tempSubscribers.elementAt(i);
                try {
                    subscriber.close(e, appClose);
                    continue;
                }
                catch (JMSException je) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close(Exception,boolean)", je, 1);
                }
            }
        }
        if (this.producers != null) {
            Vector tempPublishers = (Vector)this.producers.clone();
            for (i = 0; i < tempPublishers.size(); ++i) {
                MQMessageProducer publisher = (MQMessageProducer)tempPublishers.elementAt(i);
                try {
                    publisher.close(true);
                    continue;
                }
                catch (JMSException je) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close(Exception,boolean)", je, 2);
                }
            }
        }
        this.consumers.removeAllElements();
        this.producers.removeAllElements();
        super.close(e, appClose);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "close(Exception,boolean)", 2);
        }
    }

    public ProviderMessageProducer createProducer(ProviderDestination destination, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", new Object[]{destination, propertyContext});
        }
        if (destination == null | destination.isTopic()) {
            TopicPublisherImpl traceRet1 = this.createPublisher((WMQDestination)destination, propertyContext);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", traceRet1);
            }
            return traceRet1;
        }
        if (destination.isQueue()) {
            JMSException je = ConfigEnvironment.newException("MQJMS1112");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", je, 1);
            }
            throw je;
        }
        String key = "MQJMS0003";
        String msg = ConfigEnvironment.getErrorMessage(key);
        InvalidDestinationException je = new InvalidDestinationException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", (Throwable)je, 2);
        }
        throw je;
    }

    public ProviderMessageConsumer createConsumer(ProviderDestination destination, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,JmsPropertyContext)", new Object[]{destination, propertyContext});
        }
        if (destination.isTopic()) {
            TopicSubscriberImpl traceRet1 = this.createSubscriber((WMQDestination)destination, null, propertyContext);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,JmsPropertyContext)", traceRet1);
            }
            return traceRet1;
        }
        if (destination.isQueue()) {
            JMSException je = ConfigEnvironment.newException("MQJMS1112");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,JmsPropertyContext)", je, 1);
            }
            throw je;
        }
        String key = "MQJMS0003";
        String msg = ConfigEnvironment.getErrorMessage(key);
        InvalidDestinationException je = new InvalidDestinationException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,JmsPropertyContext)", (Throwable)je, 2);
        }
        throw je;
    }

    public ProviderMessageConsumer createConsumer(ProviderDestination destination, String messageSelector, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,JmsPropertyContext)", new Object[]{destination, messageSelector, propertyContext});
        }
        if (destination.isTopic()) {
            TopicSubscriberImpl traceRet1 = this.createSubscriber((WMQDestination)destination, messageSelector, propertyContext);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,JmsPropertyContext)", traceRet1);
            }
            return traceRet1;
        }
        if (destination.isQueue()) {
            JMSException je = ConfigEnvironment.newException("MQJMS1112");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,JmsPropertyContext)", je, 1);
            }
            throw je;
        }
        String key = "MQJMS0003";
        String msg = ConfigEnvironment.getErrorMessage(key);
        InvalidDestinationException je = new InvalidDestinationException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,JmsPropertyContext)", (Throwable)je, 2);
        }
        throw je;
    }

    public ProviderMessageConsumer createConsumer(ProviderDestination topic, String messageSelector, boolean noLocal, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", new Object[]{topic, messageSelector, noLocal, propertyContext});
        }
        if (topic.isTopic()) {
            TopicSubscriberImpl traceRet1 = this.createSubscriber((WMQDestination)topic, messageSelector, noLocal, propertyContext);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", traceRet1);
            }
            return traceRet1;
        }
        if (topic.isQueue()) {
            JMSException je = ConfigEnvironment.newException("MQJMS1112");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", je, 1);
            }
            throw je;
        }
        String key = "MQJMS0003";
        String msg = ConfigEnvironment.getErrorMessage(key);
        InvalidDestinationException je = new InvalidDestinationException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", (Throwable)je, 2);
        }
        throw je;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/TopicSessionImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.16.1.1 09/08/17 08:48:20");
        }
        cryptorand = new MinCrypto();
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "static()");
        }
        FastVector tempTopicChars = new FastVector();
        for (char c = '0'; c <= 'z'; c = (char)((char)(c + 1))) {
            if (c == 47 || c == 35 || c == 43 || c == 63) continue;
            tempTopicChars.addElement((Object)new Character(c));
        }
        TEMP_TOPIC_CHARS = new char[tempTopicChars.size()];
        for (int i = 0; i < tempTopicChars.size(); ++i) {
            TopicSessionImpl.TEMP_TOPIC_CHARS[i] = ((Character)tempTopicChars.elementAt(i)).charValue();
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl", "static()");
        }
    }
}

