/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSNotActiveException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.StreamMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TemporaryTopicImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TextMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage;
import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;

public class TopicPublisherImpl
extends MessageProducerImpl
implements ClientLogConstants,
ClientExceptionConstants {
    private static final long serialVersionUID = -888482796080850354L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/TopicPublisherImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.12.1.1 09/08/17 08:48:09";

    TopicPublisherImpl(WMQDestination topic, TopicSessionImpl session, JmsPropertyContext propertyContext) throws JMSNotActiveException, InvalidDestinationException, JMSException {
        super(topic, session, propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "<init>(WMQDestination,TopicSessionImpl,JmsPropertyContext)", new Object[]{topic, session, propertyContext});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "<init>(WMQDestination,TopicSessionImpl,JmsPropertyContext)");
        }
    }

    public WMQDestination getTopic() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "getTopic()", "getter", this.topic);
        }
        return this.topic;
    }

    public void publish(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage)", new Object[]{message});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "TopicPublisher closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "topic == null", null);
            }
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSNotSupportedException traceRet2 = new JMSNotSupportedException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        this.publish(message, this.deliveryMode, this.priority, this.timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage)");
        }
    }

    public void publish(ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "TopicPublisher is closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage,int,int,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.topic == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "topic == null", null);
            }
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSNotSupportedException traceRet2 = new JMSNotSupportedException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage,int,int,long)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        MessageImpl.validateDeliveryMode(deliveryMode);
        MessageImpl.validatePriority(priority);
        if (timeToLive > 0L) {
            String key = "MQJMS6402";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet3 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage,int,int,long)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (timeToLive != -1L && timeToLive < 0L) {
            JMSException je = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(timeToLive));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage,int,int,long)", je, 4);
            }
            throw je;
        }
        MessageImpl msg = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(this.topic, msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(ProviderMessage,int,int,long)");
        }
    }

    private MessageImpl createGryphonDomesticMessage(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "createGryphonDomesticMessage(ProviderMessage)", new Object[]{message});
        }
        if (message instanceof MessageImpl) {
            MessageImpl traceRet1 = (MessageImpl)message;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "createGryphonDomesticMessage(ProviderMessage)", traceRet1, 1);
            }
            return traceRet1;
        }
        MessageImpl msg = null;
        SessionImpl sess = this.getSession();
        Class<?> msgCls = message.getClass();
        Class<?>[] intfs = msgCls.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (intfs[i].getName().equals("javax.jms.ByteMessage")) {
                msg = (BytesMessageImpl)sess.createBytesMessage();
                byte[] buf = new byte[256];
                int len = -1;
                while ((len = ((JMSBytesMessage)message).readBytes(buf)) == buf.length) {
                    ((ProviderBytesMessage)((Object)msg)).setBytes(buf);
                }
                if (len == -1) break;
                byte[] trimmedBuffer = new byte[len];
                System.arraycopy(buf, 0, trimmedBuffer, 0, len);
                ((ProviderBytesMessage)((Object)msg)).setBytes(trimmedBuffer);
                break;
            }
            if (intfs[i].getName().equals("javax.jms.ProviderStreamMessage")) {
                msg = (StreamMessageImpl)sess.createStreamMessage();
                try {
                    while (true) {
                        ((ProviderStreamMessage)((Object)msg)).writeObject(((ProviderStreamMessage)message).readObject());
                    }
                }
                catch (MessageEOFException e) {
                    if (!Trace.isOn) break;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "createGryphonDomesticMessage(ProviderMessage)", e);
                    break;
                }
            }
            if (intfs[i].getName().equals("javax.jms.ProviderTextMessage")) {
                msg = (TextMessageImpl)sess.createTextMessage();
                ((ProviderTextMessage)((Object)msg)).setText(((ProviderTextMessage)message).getText());
                break;
            }
            if (intfs[i].getName().equals("javax.jms.ProviderObjectMessage")) {
                msg = (ObjectMessageImpl)sess.createObjectMessage();
                ((ProviderObjectMessage)((Object)msg)).setSerializedObject(((ProviderObjectMessage)message).getSerializedObject());
                break;
            }
            if (!intfs[i].getName().equals("javax.jms.ProviderMapMessage")) continue;
            msg = (MapMessageImpl)sess.createMapMessage();
            Enumeration names = ((ProviderMapMessage)((Object)msg)).getMapNames();
            while (names.hasMoreElements()) {
                String n = (String)names.nextElement();
                ((ProviderMapMessage)((Object)msg)).setObject(n, ((ProviderMapMessage)message).getObject(n));
            }
            break;
        }
        if (msg == null) {
            msg = new MessageImpl();
        }
        msg.setJMSCorrelationID(message.getJMSCorrelationID());
        msg.setJMSPriority(message.getJMSPriority());
        msg.setJMSExpiration(message.getJMSExpiration());
        msg.setJMSType(message.getJMSType());
        Enumeration props = message.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            msg.setObjectProperty(name, message.getObjectProperty(name));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "createGryphonDomesticMessage(ProviderMessage)", msg, 2);
        }
        return msg;
    }

    public void publish(WMQDestination topic, ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage)", new Object[]{topic, message});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "TopicPublisher is closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (topic == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "topic == null", null);
            }
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSParameterIsNullException traceRet2 = new JMSParameterIsNullException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (!topic.isTopic()) {
            if (Trace.isOn) {
                Trace.traceData(this, "Not an MQ Topic", null);
            }
            InvalidDestinationException traceRet3 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{topic.getClass().toString()}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        WMQDestination mqtopic = topic;
        if (mqtopic.containsWildcard()) {
            InvalidDestinationException traceRet4 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{topic}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        this.publish(mqtopic, message, this.deliveryMode, this.priority, this.timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage)");
        }
    }

    public void publish(WMQDestination topic, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "TopicPublisher is closed", null);
            }
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (topic != null && topic instanceof TemporaryTopicImpl && ((TemporaryTopicImpl)topic).isDeleted()) {
            String key = "MQJMS3019";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet2 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (topic == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "topic == null", null);
            }
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSParameterIsNullException traceRet3 = new JMSParameterIsNullException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (!topic.isTopic()) {
            InvalidDestinationException traceRet4 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{topic.getClass().toString()}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        WMQDestination mqtopic = topic;
        if (mqtopic.containsWildcard()) {
            InvalidDestinationException traceRet5 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{topic}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", (Throwable)traceRet5, 5);
            }
            throw traceRet5;
        }
        MessageImpl.validateDeliveryMode(deliveryMode);
        MessageImpl.validatePriority(priority);
        if (timeToLive > 0L) {
            String key = "MQJMS6402";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet6 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", traceRet6, 6);
            }
            throw traceRet6;
        }
        if (timeToLive != -1L && timeToLive < 0L) {
            JMSException je = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(timeToLive));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)", je, 7);
            }
            throw je;
        }
        MessageImpl msg = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(mqtopic, msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "publish(WMQDestination,ProviderMessage,int,int,long)");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "close()");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "close()", 1);
            }
            return;
        }
        TopicSessionImpl session = (TopicSessionImpl)this.getSession();
        if (session != null) {
            session.closed(this);
        }
        super.close(false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "close()", 2);
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/TopicPublisherImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.12.1.1 09/08/17 08:48:09");
        }
    }
}

