/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.Logger;
import com.ibm.disthub2.impl.client.Security;
import com.ibm.disthub2.impl.formats.Framing;
import com.ibm.disthub2.impl.formats.MessageEncrypter;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.security.CryptoInstantiationException;
import com.ibm.disthub2.impl.security.MessageProtection;
import com.ibm.disthub2.impl.security.Qop;
import com.ibm.disthub2.impl.security.SecurityContext;
import com.ibm.disthub2.impl.util.ExceptionWrapper;
import com.ibm.disthub2.impl.util.Hex;
import com.ibm.disthub2.impl.util.Release;
import com.ibm.disthub2.spi.AuthException;
import com.ibm.disthub2.spi.AuthResult;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.disthub2.spi.Principal;
import com.ibm.mq.jms.ISSLException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.AuthBase;
import com.ibm.msg.client.wmq.v6.direct.internal.AuthClient;
import com.ibm.msg.client.wmq.v6.direct.internal.AuthPrincipal;
import com.ibm.msg.client.wmq.v6.direct.internal.ISSL;
import com.ibm.msg.client.wmq.v6.direct.internal.JsseCredsImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;

public class SxaSecurityImpl
implements Security,
ClientExceptionConstants,
ClientLogConstants {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/SxaSecurityImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.9.1.1 09/08/17 08:47:38";
    private static final DebugObject debug;
    protected ISSL issl = null;
    protected Object isslCreds = null;
    protected SecurityContext sc;
    protected Hashtable qopCache;
    protected static final Byte QOP_MINTEGRITY;
    protected static final Byte QOP_PRIVACY;
    protected Socket toAuth = null;
    BaseConfig baseConfig;

    public SxaSecurityImpl(BaseConfig bc) throws AuthException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "<init>(BaseConfig)", new Object[]{bc});
        }
        this.baseConfig = bc;
        if (AuthBase.SSLrequired(AuthBase.parseAuthProtocols(this.baseConfig.AUTH_PROTOCOLS))) {
            try {
                this.issl = new JsseImpl();
                if (Trace.isOn) {
                    Trace.traceData(this, "Instantiated JsseImpl", null);
                }
                this.issl.setEnabledCipherSuites(this.baseConfig.SSL_CIPHER_SUITES);
                if (Trace.isOn) {
                    Trace.traceData(this, "Set cipherSuites", null);
                }
                JsseCredsImpl creds = new JsseCredsImpl(this.baseConfig.SSL_SOCKET_FACTORY, this.baseConfig.SSL_PEER_NAME, this.baseConfig.SSL_CERT_STORES);
                if (Trace.isOn) {
                    Trace.traceData(this, "Created JsseCredsImpl object", null);
                }
                this.isslCreds = this.issl.createCredentials(creds);
            }
            catch (ISSLException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "<init>(BaseConfig)", e);
                }
                AuthException traceRet1 = new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)841495238, (Object[])new Object[]{new ExceptionWrapper((Throwable)e)})), null);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "<init>(BaseConfig)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "<init>(BaseConfig)");
        }
    }

    public Principal createPrincipal(String user, String passwd) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "createPrincipal(String,String)", new Object[]{user, passwd == null ? passwd : "********"});
        }
        RealSecUsername traceRet1 = new RealSecUsername(user == null ? "" : user, passwd == null ? "" : passwd);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "createPrincipal(String,String)", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int authorize(Socket socket, Principal creds) throws IOException {
        int ans;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "authorize(Socket,Principal)", new Object[]{socket, creds});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"authorize", (Object)socket);
        }
        try {
            Properties metaData = new Properties();
            metaData.put("release", "1.2");
            short[] protos = AuthBase.parseAuthProtocols(this.baseConfig.AUTH_PROTOCOLS);
            if (this.baseConfig.AUTH_TIMEOUT > 0L) {
                SxaSecurityImpl sxaSecurityImpl = this;
                synchronized (sxaSecurityImpl) {
                    this.toAuth = socket;
                    if (this.baseConfig.THREADER != null) {
                        this.baseConfig.THREADER.schedule((Runnable)new AuthTimer(this, this.baseConfig.AUTH_TIMEOUT));
                    } else {
                        new Thread(new AuthTimer(this, this.baseConfig.AUTH_TIMEOUT)).start();
                    }
                }
            }
            AuthResult result = new AuthClient(socket, (AuthPrincipal)creds, metaData, protos, this.issl).authenticate();
            if (this.baseConfig.AUTH_TIMEOUT > 0L) {
                SxaSecurityImpl sxaSecurityImpl = this;
                synchronized (sxaSecurityImpl) {
                    this.toAuth = null;
                    this.notifyAll();
                }
            }
            ans = Release.getRemoteRelease((String)result.authMetaData.getProperty("release"));
            if (Boolean.valueOf(result.authMetaData.getProperty("qop", "false")).booleanValue()) {
                this.baseConfig.ENABLE_QOP_SECURITY = true;
            }
            this.sc = new SecurityContext(creds, result.sharedSecret, this.baseConfig.ENABLE_QOP_SECURITY);
        }
        catch (CryptoInstantiationException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "authorize(Socket,Principal)", e, 1);
            }
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"authorize", (Object)("Failed with exception: " + new ExceptionWrapper((Throwable)e)));
            }
            IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)-911376984, (Object[])new Object[]{e}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "authorize(Socket,Principal)", traceRet1, 1);
            }
            throw traceRet1;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "authorize(Socket,Principal)", e, 2);
            }
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"authorize", (Object)("Failed with exception: " + new ExceptionWrapper((Throwable)e)));
            }
            IOException traceRet2 = new IOException(ExceptionBuilder.buildReasonString((int)-873358984, (Object[])new Object[]{e}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "authorize(Socket,Principal)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            this.qopCache = new Hashtable();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"authorize", (Object)new Integer(ans));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "authorize(Socket,Principal)", new Integer(ans));
        }
        return ans;
    }

    public MessageEncrypter incoming(byte[] msg) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "incoming(byte [ ])", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"incoming", (Object)msg);
        }
        MessageProtection result = null;
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            Qop.checkIntegrity((byte[])msg, (SecurityContext)this.sc, (boolean)false, (boolean)this.baseConfig.ENABLE_QOP_SECURITY);
            if (Framing.qop((byte[])msg) == 14) {
                MessageProtection mp = this.sc.getMP();
                Qop.sessionDecrypt((byte[])msg, (MessageProtection)mp, (Object)this.sc.getServerKey(), (byte[])this.sc.getDecryptIV());
                result = mp;
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"incoming", (Object)Hex.toString((byte[])msg));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"incoming", result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "incoming(byte [ ])", result);
        }
        return result;
    }

    public byte[] outgoing(MessageHandle msg, byte qop) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "outgoing(MessageHandle,byte)", new Object[]{msg, new Byte(qop)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"outgoing", (Object)msg, (Object)new Byte(qop));
        }
        if (!this.baseConfig.ENABLE_QOP_SECURITY && qop != 1) {
            IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)-1015179332, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "outgoing(MessageHandle,byte)", traceRet1);
            }
            throw traceRet1;
        }
        MessageProtection mp = qop == 14 ? this.sc.getMP() : null;
        int overhead = Framing.overhead((byte)qop, (MessageEncrypter)this.sc.getMP(), (boolean)false);
        int length = msg.getEncodedLength((MessageEncrypter)mp);
        byte[] result = new byte[overhead + length];
        int sksl = msg.toByteArray(result, overhead, length, (MessageEncrypter)mp);
        if (qop != 14) {
            sksl = 0;
        }
        if (qop == 1) {
            Framing.frameMessage((byte[])result, (short)msg.getInterpreterId(), (long)msg.getEncodingSchema().getId(), (int)result.length);
        } else {
            byte[] digest = null;
            if ((qop & 6) == 6) {
                digest = Qop.computeDigest((byte[])result, (int)(overhead + sksl), (int)(length - sksl), (MessageProtection)this.sc.getMP());
            }
            Qop.frameMessage((byte[])result, (short)msg.getInterpreterId(), (long)msg.getEncodingSchema().getId(), (byte)qop, (int)(qop == 14 ? sksl : -1), (SecurityContext)this.sc, (byte[])digest, (boolean)true, (int)(overhead + length));
            Qop.channelProtect((byte[])result, (MessageProtection)this.sc.getMP(), (long)this.sc.getNextSendCount(), (Object[])this.sc.getClientMAC());
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"outgoing", (Object)Hex.toString((byte[])result));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"outgoing", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "outgoing(MessageHandle,byte)", result);
        }
        return result;
    }

    public byte[] framePropagationMessage(byte[] seq) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "framePropagationMessage(byte [ ])", new Object[]{seq});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"framePropagationMessage", (Object)seq);
        }
        byte qop = this.baseConfig.ENABLE_QOP_SECURITY ? (byte)14 : 1;
        int overhead = Framing.overhead((byte)qop, (MessageEncrypter)this.sc.getMP(), (boolean)true);
        byte[] result = new byte[seq.length + overhead];
        System.arraycopy(seq, 0, result, overhead, seq.length);
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            Qop.framePropagationMessage((byte[])result, (SecurityContext)this.sc, (boolean)true, (int)result.length);
        } else {
            Framing.framePropagationMessage((byte[])result, (int)result.length);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"framePropagationMessage", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "framePropagationMessage(byte [ ])", result);
        }
        return result;
    }

    public byte getQop(MessageHandle msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "getQop(MessageHandle)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getQop", (Object)msg);
        }
        int result = 1;
        if (this.baseConfig.ENABLE_QOP_SECURITY) {
            int type = msg.getChoice(149);
            if (type == 10) {
                result = Qop.getSingleHopControlRequiredQop((int)msg.getChoice(162));
            } else if (type != 1) {
                result = Qop.getPayloadRequiredQop((int)type);
            } else {
                String topic = msg.getString(4);
                Byte ans = (Byte)this.qopCache.get(topic);
                if (ans != null) {
                    result = ans.byteValue();
                } else {
                    msg.setBoolean(1, true);
                    result = 14;
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"qopUpdate", (Object)new Byte((byte)result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "getQop(MessageHandle)", new Byte((byte)result));
        }
        return (byte)result;
    }

    public void qopUpdate(MessageHandle msg) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "qopUpdate(MessageHandle)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"qopUpdate", (Object)msg);
        }
        if (this.qopCache == null) {
            IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)-1015179332, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "qopUpdate(MessageHandle)", traceRet1);
            }
            throw traceRet1;
        }
        this.qopCache.put(msg.getString(45), new Byte(msg.getByte(44)));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"qopUpdate");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "qopUpdate(MessageHandle)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.SxaSecurityImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/SxaSecurityImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.9.1.1 09/08/17 08:47:38");
        }
        debug = new DebugObject("SxaSecurityImpl");
        QOP_MINTEGRITY = new Byte(6);
        QOP_PRIVACY = new Byte(14);
    }

    static class AuthTimer
    implements Runnable {
        private SxaSecurityImpl instance;
        private long time;

        public AuthTimer(SxaSecurityImpl I, long T) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "<init>(SxaSecurityImpl,long)", new Object[]{I, new Long(T)});
            }
            this.instance = I;
            this.time = T;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "<init>(SxaSecurityImpl,long)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block15: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "run()");
                }
                try {
                    SxaSecurityImpl sxaSecurityImpl = this.instance;
                    synchronized (sxaSecurityImpl) {
                        this.instance.wait(this.time);
                        if (this.instance.toAuth != null) {
                            block14: {
                                block13: {
                                    try {
                                        this.instance.toAuth.shutdownInput();
                                    }
                                    catch (Throwable t) {
                                        if (!Trace.isOn) break block13;
                                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "run()", t, 1);
                                    }
                                }
                                try {
                                    this.instance.toAuth.shutdownOutput();
                                }
                                catch (Throwable t) {
                                    if (!Trace.isOn) break block14;
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "run()", t, 2);
                                }
                            }
                            this.instance.toAuth.close();
                        }
                    }
                }
                catch (Throwable x) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "run()", x, 3);
                    }
                    if (!Logger.logIt((long)1198397518584002L)) break block15;
                    Logger.log((long)1198397518584002L, (String)"SxaSecurityImpl", (Object[])new Object[]{new ExceptionWrapper(x)});
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthTimer", "run()");
            }
        }
    }

    public class RealSecUsername
    implements Principal,
    AuthPrincipal {
        protected String m_login;
        protected String m_passwd;

        public RealSecUsername(String login, String passwd) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.RealSecUsername", "<init>(String,String)", new Object[]{login, passwd == null ? passwd : "********"});
            }
            this.m_login = login;
            this.m_passwd = passwd;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.RealSecUsername", "<init>(String,String)");
            }
        }

        public String toString() {
            return this.m_login;
        }

        public int hashCode() {
            int traceRet1 = 0;
            if (null != this.m_login) {
                traceRet1 = this.m_login.hashCode();
            }
            return traceRet1;
        }

        public String getName() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.RealSecUsername", "getName()", "getter", this.m_login);
            }
            return this.m_login;
        }

        public String getPassword() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.RealSecUsername", "getPassword()", "getter", this.m_passwd == null ? this.m_passwd : "********");
            }
            return this.m_passwd;
        }

        public Object getSSLCredentials() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.RealSecUsername", "getSSLCredentials()", "getter", SxaSecurityImpl.this.isslCreds);
            }
            return SxaSecurityImpl.this.isslCreds;
        }

        public boolean equals(Object o) {
            try {
                RealSecUsername u = (RealSecUsername)o;
                boolean traceRet1 = this.m_login.equals(u.m_login);
                return traceRet1;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

