/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.security.MinCrypto;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.provider.ProviderQueueBrowser;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQTemporaryQueue;
import com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.DHPropertyContext;
import com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue;
import com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionDispatcher;
import com.ibm.msg.client.wmq.v6.direct.internal.StreamMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TemporaryTopicImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TextMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicSubscriberImpl;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public class SessionImpl
extends DHPropertyContext
implements ProviderSession,
ClientLogConstants,
ClientExceptionConstants {
    private static final long serialVersionUID = 3360640181316085615L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/SessionImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.23.1.1 09/08/17 08:46:50";
    private static final DebugObject debug;
    private boolean active = true;
    private boolean stopped = true;
    private boolean transacted;
    private int acknowledgeMode;
    private ConnectionImpl parentConnection;
    private ProviderMessageListener listener;
    private MessageQueue dispatchQueue;
    private static MessageQueue s_dispatchQueue;
    private SessionDispatcher dispatcher;
    private static SessionDispatcher s_dispatcher;
    private static boolean threadPoolChecked;
    protected Vector consumers;
    protected Vector producers;
    boolean mapNameStyle = true;
    private static final MinCrypto cryptorand;
    private String unlikely;
    private int topicCounter;

    private static synchronized void checkForThreadPooling(SessionConfig sessionConfig) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "checkForThreadPooling(SessionConfig)", new Object[]{sessionConfig});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"StreamMessageImpl.checkForThreadPooling");
        }
        if (!threadPoolChecked) {
            threadPoolChecked = true;
            if (SessionConfig.getSessionConfig().MAX_CLIENT_READ_THREADS > 0) {
                s_dispatchQueue = new MessageQueue(sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
                s_dispatcher = new SessionDispatcher(s_dispatchQueue);
                ConnectionImpl.threadProvider.schedule((Runnable)s_dispatcher);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"CheckForThreadPooling");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "checkForThreadPooling(SessionConfig)");
        }
    }

    SessionImpl(ConnectionImpl connection, boolean transacted, int ackMode, JmsPropertyContext propertyContext) throws JMSInvalidParameterException, JMSNotSupportedException {
        super(propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "<init>(ConnectionImpl,boolean,int,JmsPropertyContext)", new Object[]{connection, transacted, new Integer(ackMode), propertyContext});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"SessionImpl", (Object)connection, (Object)new Boolean(transacted), (Object)new Integer(ackMode));
        }
        this.transacted = transacted;
        this.setAcknowledgeMode(ackMode);
        this.parentConnection = connection;
        this.mapNameStyle = connection.mapNameStyle;
        SessionImpl.checkForThreadPooling(connection.sessionConfig);
        if (s_dispatchQueue != null) {
            this.dispatchQueue = s_dispatchQueue;
            this.dispatcher = s_dispatcher;
        } else {
            this.dispatchQueue = new MessageQueue(connection.sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
            this.parentConnection.addFreeSpaceHeapNode(connection.sessionConfig.MAX_MESSAGE_QUEUE_SIZE, this.dispatchQueue);
            this.dispatcher = new SessionDispatcher(this.dispatchQueue);
            ConnectionImpl.threadProvider.schedule((Runnable)this.dispatcher);
        }
        this.consumers = new Vector();
        this.producers = new Vector();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"SessionImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "<init>(ConnectionImpl,boolean,int,JmsPropertyContext)");
        }
    }

    public ProviderBytesMessage createBytesMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBytesMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createBytesMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBytesMessage()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        BytesMessageImpl ans = new BytesMessageImpl();
        ans.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createBytesMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBytesMessage()", ans);
        }
        return ans;
    }

    public ProviderMapMessage createMapMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMapMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createMapMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed()", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMapMessage()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        MapMessageImpl ans = new MapMessageImpl();
        ans.setSession(this);
        ans.mapNameStyle = this.mapNameStyle;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createMapMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMapMessage()", ans);
        }
        return ans;
    }

    public ProviderMessage createMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMessage()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        MessageImpl ans = new MessageImpl();
        ans.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMessage()", ans);
        }
        return ans;
    }

    public ProviderObjectMessage createObjectMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createObjectMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createObjectMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createObjectMessage()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        ObjectMessageImpl ans = new ObjectMessageImpl();
        ans.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createObjectMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createObjectMessage()", ans);
        }
        return ans;
    }

    public ProviderObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createObjectMessage(Serializable)", new Object[]{object});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createObjectMessage", (Object)object);
        }
        ObjectMessageImpl ans = new ObjectMessageImpl();
        ans.setSession(this);
        ans.setObject(object);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createObjectMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createObjectMessage(Serializable)", ans);
        }
        return ans;
    }

    public ProviderStreamMessage createStreamMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createStreamMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createStreamMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createStreamMessage()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        StreamMessageImpl ans = new StreamMessageImpl();
        ans.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createStreamMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createStreamMessage()", ans);
        }
        return ans;
    }

    public ProviderTextMessage createTextMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createTextMessage");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        TextMessageImpl ans = new TextMessageImpl();
        ans.setSession(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createTextMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage()", ans);
        }
        return ans;
    }

    public ProviderTextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage(StringBuffer)", new Object[]{stringBuffer});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createTextMessage", (Object)stringBuffer);
        }
        ProviderTextMessage result = this.createTextMessage(stringBuffer.toString());
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createTextMessage", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage(StringBuffer)", result);
        }
        return result;
    }

    public ProviderTextMessage createTextMessage(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage(String)", new Object[]{string});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"createTextMessage", (Object)string);
        }
        TextMessageImpl ans = new TextMessageImpl();
        ans.setSession(this);
        ans.setText(string);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createTextMessage", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTextMessage(String)", ans);
        }
        return ans;
    }

    public boolean getTransacted() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getTransacted()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTransacted");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getTransacted()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTransacted", (Object)new Boolean(this.transacted));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getTransacted()", this.transacted);
        }
        return this.transacted;
    }

    public void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "commit()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"commit");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "commit()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "commit()");
        }
    }

    public void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "rollback()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"rollback");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "rollback()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet2 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "rollback()", traceRet2, 2);
        }
        throw traceRet2;
    }

    public void close(boolean closeFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "close(boolean)", new Object[]{closeFromConnection});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        this.close(null, true);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "close(boolean)");
        }
    }

    public void close(Exception e, boolean appClose) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "close(Exception,boolean)", new Object[]{e, appClose});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close", (Object)e, (Object)new Boolean(appClose));
        }
        if (this.isClosed()) {
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"close");
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "close(Exception,boolean)", 1);
            }
            return;
        }
        this.active = false;
        this.parentConnection.closed(this);
        this.stop();
        if (this.consumers != null) {
            Vector tempConsumers = (Vector)this.consumers.clone();
            for (int i = 0; i < tempConsumers.size(); ++i) {
                MessageConsumerImpl consumer = (MessageConsumerImpl)tempConsumers.elementAt(i);
                consumer.close(e, appClose);
            }
            this.consumers.removeAllElements();
        }
        if (s_dispatcher == null && this.dispatcher != null) {
            this.dispatcher.close(e, appClose);
        }
        this.dispatcher = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "close(Exception,boolean)", 2);
        }
    }

    public void recover() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "recover()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"recover");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "recover()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet2 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "recover()", traceRet2, 2);
        }
        throw traceRet2;
    }

    public ProviderMessageListener getMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getMessageListener()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMessageListener");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getMessageListener()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMessageListener", (Object)this.listener);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getMessageListener()", this.listener);
        }
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(ProviderMessageListener newListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "setMessageListener(ProviderMessageListener)", new Object[]{newListener});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setMessageListener", (Object)newListener);
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "setMessageListener(ProviderMessageListener)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            ProviderMessageListener oldListener = this.listener;
            this.listener = newListener;
            if (oldListener == newListener) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"setMessageListener");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "setMessageListener(ProviderMessageListener)", 1);
                }
                return;
            }
            boolean currentlyStopped = this.stopped;
            if (!currentlyStopped) {
                this.stop();
            }
            Vector tempConsumers = (Vector)this.consumers.clone();
            for (int i = 0; i < tempConsumers.size(); ++i) {
                MessageConsumerImpl consumer = (MessageConsumerImpl)tempConsumers.elementAt(i);
                consumer.setSessionMessageListener(newListener);
            }
            if (!currentlyStopped) {
                this.start();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setMessageListener");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "setMessageListener(ProviderMessageListener)", 2);
        }
    }

    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "run()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"run");
        }
        IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-148245959, null));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "run()", traceRet1);
        }
        throw traceRet1;
    }

    ConnectionImpl getConnection() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getConnection");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getConnection", (Object)this.parentConnection);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getConnection()", "getter", this.parentConnection);
        }
        return this.parentConnection;
    }

    MessageQueue getDispatchQueue() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDispatchQueue");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDispatchQueue", (Object)this.dispatchQueue);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getDispatchQueue()", "getter", this.dispatchQueue);
        }
        return this.dispatchQueue;
    }

    private void setAcknowledgeMode(int mode) throws JMSInvalidParameterException, JMSNotSupportedException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "setAcknowledgeMode(int)", "setter", new Integer(mode));
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setAcknowledgeMode", (Object)new Integer(mode));
        }
        this.acknowledgeMode = mode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setAcknowledgeMode");
        }
    }

    public int getAcknowledgeMode() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getAcknowledgeMode");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getAcknowledgeMode", (Object)new Integer(this.acknowledgeMode));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getAcknowledgeMode()", "getter", new Integer(this.acknowledgeMode));
        }
        return this.acknowledgeMode;
    }

    boolean acknowledgeModeIsAuto() {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "acknowledgeModeIsAuto()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledgeModeIsAuto");
        }
        boolean bl = result = 1 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledgeModeIsAuto", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "acknowledgeModeIsAuto()", result);
        }
        return result;
    }

    boolean acknowledgeModeIsClient() {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "acknowledgeModeIsClient()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledgeModeIsClient");
        }
        boolean bl = result = 2 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledgeModeIsClient", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "acknowledgeModeIsClient()", result);
        }
        return result;
    }

    boolean acknowledgeModeIsDupsOK() {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "acknowledgeModeIsDupsOK()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledgeModeIsDupsOK");
        }
        boolean bl = result = 3 == this.acknowledgeMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledgeModeIsDupsOK", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "acknowledgeModeIsDupsOK()", result);
        }
        return result;
    }

    void enqueue(MessageImpl m) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "enqueue(MessageImpl)", new Object[]{m});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"enqueue", (Object)m);
        }
        this.dispatchQueue.enqueue(m);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"enqueue");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "enqueue(MessageImpl)");
        }
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isActive()", "getter", this.active);
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isClosed()", "getter", !this.active);
        }
        return !this.active;
    }

    protected boolean isStopped() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isStopped");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isStopped", (Object)new Boolean(this.stopped));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isStopped()", "getter", this.stopped);
        }
        return this.stopped;
    }

    public synchronized void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "stop()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        this.stopped = true;
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        Vector tempSubscribers = (Vector)this.consumers.clone();
        for (int i = 0; i < tempSubscribers.size(); ++i) {
            ((MessageConsumerImpl)tempSubscribers.elementAt(i)).stop();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "stop()");
        }
    }

    public synchronized void start() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "start()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        this.stopped = false;
        this.dispatcher.start();
        Vector tempSubscribers = (Vector)this.consumers.clone();
        for (int i = 0; i < tempSubscribers.size(); ++i) {
            ((MessageConsumerImpl)tempSubscribers.elementAt(i)).start();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "start()");
        }
    }

    public WMQTemporaryQueue createTemporaryQueue() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryQueue()");
        }
        String key = "MQJMS1110";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryQueue()", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderQueueBrowser createBrowser(WMQDestination queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBrowser(WMQDestination)", new Object[]{queue});
        }
        String key = "MQJMS1110";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBrowser(WMQDestination)", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderQueueBrowser createBrowser(WMQDestination queue, String messageSelector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBrowser(WMQDestination,String)", new Object[]{queue, messageSelector});
        }
        String key = "MQJMS1110";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBrowser(WMQDestination,String)", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderMessageProducer createProducer(ProviderDestination destination, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", new Object[]{destination, propertyContext});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        MessageProducerImpl newProducer = new MessageProducerImpl(destination, this, propertyContext);
        this.producers.addElement(newProducer);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createProducer(ProviderDestination,JmsPropertyContext)", newProducer);
        }
        return newProducer;
    }

    public WMQDestination createQueue(String queueName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createQueue(java.lang.String)", new Object[]{queueName});
        }
        String key = "MQJMS1110";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createQueue(java.lang.String)", traceRet1);
        }
        throw traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderMessageConsumer createConsumer(ProviderDestination topic, String messageSelector, boolean noLocal, JmsPropertyContext propertyContext) throws JMSException {
        int brokerVersion;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", new Object[]{topic, messageSelector, noLocal, propertyContext});
        }
        WMQDestination mqtopic = null;
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (topic == null || topic.toString().length() == 0) {
            if (Trace.isOn) {
                Trace.traceData(this, "Topic is Null", null);
            }
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            InvalidDestinationException traceRet2 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!topic.isTopic()) {
            if (Trace.isOn) {
                Trace.traceData(this, "Not an MQTopic", null);
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException traceRet3 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        mqtopic = (WMQDestination)topic;
        if (mqtopic.containsAnyWildcard() && ((brokerVersion = mqtopic.getIntProperty("brokerVersion")) == 0 || brokerVersion == -1)) {
            if (Trace.isOn) {
                Trace.traceData(this, "Invalid wildcard ", null);
            }
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException traceRet4 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        if (topic instanceof TemporaryTopicImpl && !((TemporaryTopicImpl)topic).isCreatedOnThisConnection(this)) {
            if (Trace.isOn) {
                Trace.traceData(this, "Temporary Topic not created on this connection", null);
            }
            JMSException traceRet5 = new JMSException(ExceptionBuilder.buildReasonString((int)793507705, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", traceRet5, 5);
            }
            throw traceRet5;
        }
        MessageConsumerImpl newConsumer = new MessageConsumerImpl(mqtopic, messageSelector, null, noLocal, this.getConnection().isPre1_2() ? 1 : 2, this, propertyContext);
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.consumers.addElement(newConsumer);
            if (!this.isStopped()) {
                newConsumer.start();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createConsumer(ProviderDestination,String,boolean,JmsPropertyContext)", newConsumer);
        }
        return newConsumer;
    }

    public TopicSubscriberImpl createDurableSubscriber(WMQDestination topic, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(WMQDestination,String)", new Object[]{topic, name});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(WMQDestination,String)", traceRet1);
        }
        throw traceRet1;
    }

    public TopicSubscriberImpl createDurableSubscriber(WMQDestination topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(WMQDestination,String,String,boolean)", new Object[]{topic, name, messageSelector, noLocal});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(WMQDestination,String,String,boolean)", traceRet1);
        }
        throw traceRet1;
    }

    public TopicSubscriberImpl createDurableSubscriber(WMQDestination topic, String name, String messageSelector) throws JMSParameterIsNullException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(WMQDestination,String,String)", new Object[]{topic, name, messageSelector});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(WMQDestination,String,String)", traceRet1);
        }
        throw traceRet1;
    }

    public void unsubscribe(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "unsubscribe(String)", new Object[]{name});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "unsubscribe(String)", traceRet1);
        }
        throw traceRet1;
    }

    public TemporaryTopicImpl createTemporaryTopic(JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryTopic(JmsPropertyContext)", new Object[]{propertyContext});
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderSession is closed", null);
            }
            javax.jms.IllegalStateException traceRet1 = new javax.jms.IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryTopic(JmsPropertyContext)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (this.unlikely == null) {
            this.makeUnlikely();
        }
        String topic = this.unlikely + '/' + this.topicCounter++;
        TemporaryTopicImpl result = new TemporaryTopicImpl(this, this.getConnection().getTemporaryTopicString(topic), propertyContext);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryTopic(JmsPropertyContext)", result);
        }
        return result;
    }

    private void makeUnlikely() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "makeUnlikely()");
        }
        byte[] bytes = cryptorand.random(20);
        StringBuffer sbuf = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            char c = (char)(bytes[i] & 0xFF);
            if (c == '/' || c == '#' || c == '+' || c == '?' || c < '0' || c > 'z') continue;
            sbuf.append(c);
        }
        this.unlikely = sbuf.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "makeUnlikely()");
        }
    }

    void closed(MessageConsumerImpl subscriber) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "closed(MessageConsumerImpl)", new Object[]{subscriber});
        }
        Assert.condition((boolean)this.consumers.removeElement(subscriber));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "closed(MessageConsumerImpl)");
        }
    }

    void closed(MessageProducerImpl publisher) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "closed(MessageProducerImpl)", new Object[]{publisher});
        }
        Assert.condition((boolean)this.producers.removeElement(publisher));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "closed(MessageProducerImpl)");
        }
    }

    public ProviderMessageConsumer createDurableSubscriber(ProviderDestination destination, String subscriptionName, String selector, boolean nolocal, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(ProviderDestination,String,String,boolean,JmsPropertyContext)", new Object[]{destination, subscriptionName, selector, nolocal, propertyContext});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createDurableSubscriber(ProviderDestination,String,String,boolean,JmsPropertyContext)", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderQueueBrowser createBrowser(ProviderDestination destination, String selector, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBrowser(ProviderDestination,String,JmsPropertyContext)", new Object[]{destination, selector, propertyContext});
        }
        String key = "MQJMS1110";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createBrowser(ProviderDestination,String,JmsPropertyContext)", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderDestination createTemporaryDestination(int destType, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryDestination(int,JmsPropertyContext)", new Object[]{new Integer(destType), propertyContext});
        }
        if (destType == 1) {
            WMQTemporaryQueue traceRet1 = this.createTemporaryQueue();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryDestination(int,JmsPropertyContext)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (destType == 2) {
            TemporaryTopicImpl traceRet2 = this.createTemporaryTopic(propertyContext);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryDestination(int,JmsPropertyContext)", traceRet2, 2);
            }
            return traceRet2;
        }
        String key = "MQJMS0003";
        String msg = ConfigEnvironment.getErrorMessage(key);
        InvalidDestinationException ide = new InvalidDestinationException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createTemporaryDestination(int,JmsPropertyContext)", (Throwable)ide);
        }
        throw ide;
    }

    public void deleteDurableSubscriber(String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "deleteDurableSubscriber(String)", new Object[]{subscriptionName});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "deleteDurableSubscriber(String)", traceRet1);
        }
        throw traceRet1;
    }

    public void loadMessageReference(ProviderMessageReference messageReference) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "loadMessageReference(ProviderMessageReference)", new Object[]{messageReference});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "loadMessageReference(ProviderMessageReference)");
        }
    }

    public ProviderMessageReference recreateMessageReference(byte[] flatMR, ProviderDestination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "recreateMessageReference(byte [ ],ProviderDestination)", new Object[]{flatMR, destination});
        }
        Trace.ffst(this, "recreateMessageReference", "XO002001", null, JMSException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "recreateMessageReference(byte [ ],ProviderDestination)", null);
        }
        return null;
    }

    public String getDestinationURI(byte[] flatMR) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getDestinationURI(byte [ ])", new Object[]{flatMR});
        }
        Trace.ffst(this, "getDestinationURI", "XO00D001", null, JMSException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "getDestinationURI(byte [ ])", null);
        }
        return null;
    }

    public String createMessageID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMessageID()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "createMessageID()", null);
        }
        return null;
    }

    public boolean isMessageAlien(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isMessageAlien(ProviderMessage)", new Object[]{message});
        }
        if (message instanceof MessageImpl) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isMessageAlien(ProviderMessage)", false, 1);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isMessageAlien(ProviderMessage)", true, 2);
        }
        return true;
    }

    public boolean isInGlobalTransaction() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "isInGlobalTransaction()", "getter", false);
        }
        return false;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/SessionImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.23.1.1 09/08/17 08:46:50");
        }
        debug = new DebugObject("SessionImpl");
        cryptorand = new MinCrypto();
    }
}

