/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.StreamMessageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Vector;

public final class SerialMessage
implements Serializable {
    private static final long serialVersionUID = 9155296495849349676L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/SerialMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.8.1.1 09/08/17 08:46:30";
    private int msgType;
    private Serializable body;
    private Dictionary properties;
    private String correlationID;
    private String messageID;
    private int priority;
    private long timestamp;
    private String typeField;
    private String replyTopic;
    private String topic;
    private boolean readOnly;
    private boolean propertiesReadOnly;
    private long expiration;
    private boolean redelivered;
    private boolean persistent;
    private int streamOffset;

    public SerialMessage(MessageImpl msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "<init>(MessageImpl)", new Object[]{msg});
        }
        this.msgType = msg instanceof BytesMessageImpl ? 3 : msg.getMessageType();
        this.readOnly = msg.readOnly;
        this.propertiesReadOnly = msg.propertiesReadOnly;
        switch (this.msgType) {
            case 3: {
                this.saveBytesMessageState((BytesMessageImpl)msg);
                break;
            }
            case 4: {
                this.body = msg.getTextBody();
                break;
            }
            case 2: {
                this.body = msg.getObjectRaw();
                break;
            }
            case 5: {
                this.body = msg.getFields();
                this.streamOffset = ((StreamMessageImpl)msg).lastField;
                break;
            }
            case 6: {
                this.body = (Serializable)((Object)msg.getNamedFields());
            }
        }
        this.properties = msg.getProperties();
        this.correlationID = msg.getCorrelationID();
        this.messageID = msg.messageId;
        if (this.messageID == null) {
            this.messageID = "ID:" + msg.getMessageID();
        }
        this.priority = msg.getPriority();
        this.timestamp = msg.getTimestamp();
        this.typeField = msg.getJMSTypeField();
        this.replyTopic = msg.getReplyString();
        this.topic = msg.getTopicString();
        this.expiration = msg.expiration;
        this.redelivered = msg.redelivered;
        this.persistent = msg.getPersistent();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "<init>(MessageImpl)");
        }
    }

    private void saveBytesMessageState(BytesMessageImpl msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "saveBytesMessageState(BytesMessageImpl)", new Object[]{msg});
        }
        if (!this.readOnly) {
            byte[] bod = msg.baos.toByteArray();
            this.body = bod;
            this.streamOffset = bod.length;
        } else if (msg.bais == null) {
            this.body = msg.getBytesBody();
            this.streamOffset = 0;
        } else {
            this.body = msg.body;
            this.streamOffset = msg.body.length - msg.bais.available();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "saveBytesMessageState(BytesMessageImpl)");
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "readResolve()");
        }
        MessageImpl msg = MessageImpl.construct(this.msgType);
        msg.readOnly = this.readOnly;
        msg.propertiesReadOnly = this.propertiesReadOnly;
        switch (this.msgType) {
            case 3: {
                try {
                    this.restoreBytesMessageState((BytesMessageImpl)msg);
                    break;
                }
                catch (IOException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "readResolve()", e);
                    }
                    NotSerializableException traceRet1 = new NotSerializableException(e.getMessage());
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "readResolve()", traceRet1);
                    }
                    throw traceRet1;
                }
            }
            case 4: {
                msg.setTextBody((String)((Object)this.body));
                break;
            }
            case 2: {
                msg.setObjectRaw((byte[])this.body);
                break;
            }
            case 5: {
                msg.setFields((Vector)this.body);
                ((StreamMessageImpl)msg).fields = (Vector)this.body;
                ((StreamMessageImpl)msg).lastField = this.streamOffset;
                break;
            }
            case 6: {
                msg.setNamedFields((Dictionary)((Object)this.body));
                ((MapMessageImpl)msg).fields = (Dictionary)((Object)this.body);
            }
        }
        msg.setProperties(this.properties);
        msg.props = this.properties;
        msg.setCorrelationID(this.correlationID);
        msg.messageId = this.messageID;
        msg.setPriority(this.priority);
        msg.setTimestamp(this.timestamp);
        msg.setJMSTypeField(this.typeField);
        msg.setReplyString(this.replyTopic);
        if (this.topic != null) {
            msg.setTopicString(this.topic);
        }
        msg.expiration = this.expiration;
        msg.redelivered = this.redelivered;
        msg.setPersistent(this.persistent);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "readResolve()", msg);
        }
        return msg;
    }

    private void restoreBytesMessageState(BytesMessageImpl msg) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "restoreBytesMessageState(BytesMessageImpl)", new Object[]{msg});
        }
        byte[] bod = (byte[])this.body;
        if (!this.readOnly) {
            msg.baos = new ByteArrayOutputStream();
            msg.dos = new DataOutputStream(msg.baos);
            msg.dos.write(bod, 0, this.streamOffset);
        } else {
            msg.setBytesBody(bod);
            if (this.streamOffset > 0) {
                msg.body = bod;
                msg.bais = new ByteArrayInputStream(bod);
                msg.dis = new DataInputStream(msg.bais);
                msg.dis.skipBytes(this.streamOffset);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "restoreBytesMessageState(BytesMessageImpl)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/SerialMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.8.1.1 09/08/17 08:46:30");
        }
    }
}

