/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderSelfSerializingObjectMessage;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class ObjectMessageImpl
extends MessageImpl
implements ProviderSelfSerializingObjectMessage,
ClientExceptionConstants {
    private static final long serialVersionUID = 329048462463920206L;
    private static final DebugObject debug;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/ObjectMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.13.1.1 09/08/17 08:46:02";

    public ObjectMessageImpl(MessageHandle cursor, ConnectionImpl conn) {
        super(cursor, conn);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "<init>(MessageHandle,ConnectionImpl)", new Object[]{cursor, conn});
        }
        this.messageClass = "jms_object";
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"ObjectMessageImpl", (Object)cursor, (Object)conn);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ObjectMessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "<init>(MessageHandle,ConnectionImpl)");
        }
    }

    public ObjectMessageImpl() {
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "<init>()");
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ObjectMessageImpl");
            }
            this.messageClass = "jms_object";
            try {
                this.setObjectBody(null);
            }
            catch (IOException e) {
                if (!Trace.isOn) break block6;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "<init>()", e);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ObjectMessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "<init>()");
        }
    }

    public void setObject(Serializable object) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", new Object[]{object});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setObject", (Object)object);
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.setObjectBody(object);
        }
        catch (InvalidClassException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", e, 1);
            }
            String key = "MQJMS1060";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (NotSerializableException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", e, 2);
            }
            String key = "MQJMS1060";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet3 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", e, 3);
            }
            String key = "MQJMS1060";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet4 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)", traceRet4, 4);
            }
            throw traceRet4;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setObject");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setObject(Serializable)");
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable result;
        block12: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()");
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"getObject");
            }
            result = null;
            try {
                result = this.getObjectBody();
            }
            catch (ClassNotFoundException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()", e, 1);
                }
                String key = "MQJMS1061";
                String msg = ConfigEnvironment.getErrorMessage(key);
                JMSException traceRet1 = new JMSException(msg, key);
                traceRet1.initCause((Throwable)e);
                traceRet1.setLinkedException((Exception)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()", traceRet1, 1);
                }
                throw traceRet1;
            }
            catch (InvalidClassException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()", e, 2);
                }
                String key = "MQJMS1061";
                String msg = ConfigEnvironment.getErrorMessage(key);
                MessageFormatException traceRet2 = new MessageFormatException(msg, key);
                traceRet2.setLinkedException((Exception)e);
                traceRet2.initCause((Throwable)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()", (Throwable)traceRet2, 2);
                }
                throw traceRet2;
            }
            catch (Exception e) {
                if (!Trace.isOn) break block12;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()", e, 3);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getObject", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getObject()", result);
        }
        return result;
    }

    public void clearBody() {
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "clearBody()");
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"clearBody");
            }
            this.readOnly = false;
            try {
                this.setObjectBody(null);
            }
            catch (IOException e) {
                if (!Trace.isOn) break block6;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "clearBody()", e);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "clearBody()");
        }
    }

    public void setSerializedObject(byte[] objectBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setSerializedObject(byte [ ])", "setter", objectBytes);
        }
        Trace.ffst(this, "setSerializedObject(byte[])", "XO00F001", null, null);
    }

    public byte[] getSerializedObject() throws JMSException {
        Trace.ffst(this, "getSerializedObject()", "XO00F002", null, null);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getSerializedObject()", "getter", null);
        }
        return null;
    }

    public Serializable getSelfSerializedObject() throws JMSException {
        Serializable traceRet1 = this.getObject();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "getSelfSerializedObject()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setSelfSerializedObject(Serializable objectBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "setSelfSerializedObject(Serializable)", "setter", objectBytes);
        }
        this.setObject(objectBytes);
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/ObjectMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.13.1.1 09/08/17 08:46:02");
        }
        debug = new DebugObject("ObjectMessageImpl");
    }
}

