/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.multicast.MulticastTopic;
import com.ibm.disthub2.impl.util.FastHashtable;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.SubscriptionInfoImpl;
import java.util.Enumeration;

public class MulticastConnectionReceiver {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MulticastConnectionReceiver.java, jmscc.wmq.v6, k701, k701-112-140304 1.9.1.1 09/08/17 08:45:51";
    private FastVector multicastTopics;
    private FastHashtable matches;

    public MulticastConnectionReceiver() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "<init>()");
        }
        this.multicastTopics = new FastVector();
        this.matches = new FastHashtable();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "<init>()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTopics(SubscriptionInfoImpl subInfo) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "registerTopics(SubscriptionInfoImpl)", new Object[]{subInfo});
        }
        Enumeration enumVar = subInfo.multicastTopics.elements();
        while (enumVar.hasMoreElements()) {
            MulticastTopic topic = (MulticastTopic)enumVar.nextElement();
            if (!this.multicastTopics.contains((Object)topic)) {
                // empty if block
            }
            this.multicastTopics.addElement((Object)topic);
            FastVector subMatches = null;
            if (this.matches.containsKey((Object)topic.topic)) {
                subMatches = (FastVector)this.matches.get((Object)topic.topic);
            } else {
                subMatches = new FastVector();
                this.matches.put((Object)topic.topic, (Object)subMatches);
            }
            if (subMatches.indexOf((Object)topic) >= 0) continue;
            FastVector fastVector = subMatches;
            synchronized (fastVector) {
                subMatches.addElement((Object)topic);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "registerTopics(SubscriptionInfoImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTopic(SubscriptionInfoImpl subInfo, MulticastTopic topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "deregisterTopic(SubscriptionInfoImpl,MulticastTopic)", new Object[]{subInfo, topic});
        }
        if (this.multicastTopics.contains((Object)topic)) {
            this.multicastTopics.removeElementAt(this.multicastTopics.indexOf((Object)topic));
            if (this.multicastTopics.indexOf((Object)topic) < 1) {
                // empty if block
            }
        }
        if (this.matches.containsKey((Object)topic.topic)) {
            FastVector subMatches;
            FastVector fastVector = subMatches = (FastVector)this.matches.get((Object)topic.topic);
            synchronized (fastVector) {
                if (subMatches.indexOf((Object)topic) > -1) {
                    subMatches.removeElementAt(subMatches.indexOf((Object)topic));
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "deregisterTopic(SubscriptionInfoImpl,MulticastTopic)");
        }
    }

    public void deregisterAllTopics(SubscriptionInfoImpl subInfo) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "deregisterAllTopics(SubscriptionInfoImpl)", new Object[]{subInfo});
        }
        Enumeration enumVar = subInfo.multicastTopics.elements();
        while (enumVar.hasMoreElements()) {
            MulticastTopic topic = (MulticastTopic)enumVar.nextElement();
            this.deregisterTopic(subInfo, topic);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "deregisterAllTopics(SubscriptionInfoImpl)");
        }
    }

    public void updateTopic(MulticastTopic topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "updateTopic(MulticastTopic)", new Object[]{topic});
        }
        if (this.multicastTopics.contains((Object)topic)) {
            MulticastTopic oldTopic = (MulticastTopic)this.multicastTopics.elementAt(this.multicastTopics.indexOf((Object)topic));
            oldTopic.timeStamp = topic.timeStamp;
            oldTopic.key = topic.key;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "updateTopic(MulticastTopic)");
        }
    }

    public void sendControlMessage(byte[] message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "sendControlMessage(byte [ ])", new Object[]{message});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "sendControlMessage(byte [ ])");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.MulticastConnectionReceiver", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MulticastConnectionReceiver.java, jmscc.wmq.v6, k701, k701-112-140304  1.9.1.1 09/08/17 08:45:51");
        }
    }
}

