/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.impl.util.PriorityQueueNode;
import com.ibm.disthub2.impl.util.Queue;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSMessageQueueOverflowException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.JMSWrappedException;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;

public class MessageQueue
implements ClientExceptionConstants,
ClientLogConstants {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageQueue.java, jmscc.wmq.v6, k701, k701-112-140304 1.10.1.1 09/08/17 08:45:39";
    private static final DebugObject debug;
    private Queue normalQueue;
    private Queue priorityQueue;
    private Thread blockedThread;
    private volatile boolean alive = true;
    private boolean stopped = true;
    private boolean appConnectionClosed = true;
    private Exception eConnectionClosed = null;
    private int messageCount;
    private int maxMessageCount;
    private PriorityQueueNode hdl;
    private ConnectionImpl.FreeSpaceHeap fsh;
    private ConnectionImpl conn;
    private boolean enableFlowControl;

    MessageQueue(int max) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "<init>(int)", new Object[]{new Integer(max)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageQueue");
        }
        this.normalQueue = new Queue();
        this.priorityQueue = new Queue();
        this.maxMessageCount = max;
        this.enableFlowControl = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageQueue");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "<init>(int)");
        }
    }

    public void setFreeSpaceHeapStuff(ConnectionImpl.FreeSpaceHeap fsh, PriorityQueueNode hdl, ConnectionImpl conn) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "setFreeSpaceHeapStuff(ConnectionImpl.FreeSpaceHeap,PriorityQueueNode,ConnectionImpl)", new Object[]{fsh, hdl, conn});
        }
        this.fsh = fsh;
        this.hdl = hdl;
        this.conn = conn;
        this.enableFlowControl = BaseConfig.getBaseConfig().ENABLE_CLIENT_FLOW_CONTROL;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "setFreeSpaceHeapStuff(ConnectionImpl.FreeSpaceHeap,PriorityQueueNode,ConnectionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean enqueue(MessageImpl msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "enqueue(MessageImpl)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"enqueue", (Object)msg);
        }
        if (this.maxMessageCount > 0 && this.messageCount >= this.maxMessageCount) {
            int numMsgs;
            MessageImpl m;
            if (debug.debugIt(2)) {
                debug.debug(2L, (Object)"enqueue", (Object)("**>Msg count=" + this.messageCount + " .ge. max(" + this.maxMessageCount + ") will clear disposables"));
            }
            Vector<MessageImpl> nonDisposables = new Vector<MessageImpl>();
            while ((m = (MessageImpl)this.priorityQueue.dequeueOrNull()) != null) {
                if (m.getDisposable()) continue;
                nonDisposables.addElement(m);
            }
            this.messageCount = numMsgs = nonDisposables.size();
            while (numMsgs-- > 0) {
                this.priorityQueue.enqueue(nonDisposables.remove(0));
            }
            while ((m = (MessageImpl)this.normalQueue.dequeueOrNull()) != null) {
                if (m.getDisposable()) continue;
                nonDisposables.addElement(m);
            }
            numMsgs = nonDisposables.size();
            this.messageCount += numMsgs;
            while (numMsgs-- > 0) {
                this.normalQueue.enqueue(nonDisposables.remove(0));
            }
            ConnectionImpl ci = msg.getConsumer().getSession().getConnection();
            if (ci != null) {
                JMSMessageQueueOverflowException je = new JMSMessageQueueOverflowException(ExceptionBuilder.buildReasonString((int)1003358355, (Object[])new Object[]{new Integer(this.maxMessageCount - this.messageCount)}));
                ci.deliverException((Exception)((Object)je), false);
            } else {
                HashMap<String, String> ffstData = new HashMap<String, String>();
                ffstData.put("ConnectionImpl", "null");
                Trace.ffst(this, "enqueue(MessageImpl)", "XO006001", ffstData, null);
            }
            if (this.messageCount >= this.maxMessageCount) {
                if (debug.debugIt(2)) {
                    debug.debug(2L, (Object)"enqueue", (Object)"**>Msg Q full with NON disposables, will throw exception to close connection");
                }
                this.alive = false;
                this.normalQueue.makeEmptyAndClean();
                this.priorityQueue.makeEmptyAndClean();
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "enqueue(MessageImpl)", false, 1);
                }
                return false;
            }
        }
        ++this.messageCount;
        if (this.enableFlowControl) {
            int freeSpace = this.maxMessageCount - this.messageCount;
            long oldprio = this.hdl.priority;
            if ((long)freeSpace < this.hdl.priority) {
                ConnectionImpl.FreeSpaceHeap freeSpaceHeap = this.fsh;
                synchronized (freeSpaceHeap) {
                    this.fsh.changePriority(freeSpace - (int)this.hdl.priority, this.hdl);
                }
                if (debug.debugIt(2)) {
                    debug.debug(-175584356845707L, (Object)"enqueue", (Object)(this.conn + ":freeSpace=" + freeSpace + ",changed priority from " + oldprio));
                }
            } else if (debug.debugIt(2)) {
                debug.debug(-175584356845707L, (Object)"enqueue", (Object)(this.conn + ":freeSpace=" + freeSpace + ",priority not updated:" + oldprio));
            }
        }
        try {
            if (debug.debugIt(16)) {
                debug.debug(16L, (Object)"enqueue", (Object)"finally doing it", (Object)msg);
            }
            if (msg.getJMSPriority() > 4) {
                this.priorityQueue.enqueue((Object)msg);
            } else {
                this.normalQueue.enqueue((Object)msg);
            }
            this.notifyAll();
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "enqueue(MessageImpl)", e);
            }
            Assert.failure((Exception)((Object)e));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"enqueue");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "enqueue(MessageImpl)", true, 2);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized MessageImpl dequeue() throws InterruptedException, JMSWrappedException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeue");
        }
        while (this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty()) {
            Object var4_1;
            block22: {
                MessageImpl traceRet12222;
                block23: {
                    block24: {
                        if (!this.alive) {
                            if (this.appConnectionClosed) {
                                if (debug.debugIt(64)) {
                                    debug.debug(-142394261359015L, (Object)"dequeue", null);
                                }
                                if (Trace.isOn) {
                                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", null, 1);
                                }
                                return null;
                            }
                            JMSWrappedException traceRet12222 = new JMSWrappedException(ExceptionBuilder.buildReasonString((int)218068710, (Object[])new Object[]{this.eConnectionClosed}), this.eConnectionClosed);
                            if (Trace.isOn) {
                                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", (Throwable)((Object)traceRet12222), 1);
                            }
                            throw traceRet12222;
                        }
                        this.blockedThread = Thread.currentThread();
                        try {
                            try {
                                this.wait();
                                if (this.alive) break block22;
                                if (this.appConnectionClosed) {
                                    if (debug.debugIt(64)) {
                                        debug.debug(-142394261359015L, (Object)"dequeue", (Object)"appConnectionClosed=true", null);
                                    }
                                    if (Trace.isOn) {
                                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", null, 2);
                                    }
                                    traceRet12222 = null;
                                    var4_1 = null;
                                    if (!Trace.isOn) break block23;
                                    break block24;
                                }
                                JMSWrappedException traceRet2 = new JMSWrappedException(ExceptionBuilder.buildReasonString((int)218068710, (Object[])new Object[]{this.eConnectionClosed}), this.eConnectionClosed);
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", (Throwable)((Object)traceRet2), 2);
                                }
                                throw traceRet2;
                            }
                            catch (InterruptedException e) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", e);
                                }
                                InterruptedException traceRet3 = new InterruptedException(ExceptionBuilder.buildReasonString((int)1613710283, (Object[])new Object[]{e}));
                                if (Trace.isOn) {
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", traceRet3, 3);
                                }
                                throw traceRet3;
                            }
                        }
                        catch (Throwable throwable) {
                            var4_1 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()");
                            }
                            this.blockedThread = null;
                            throw throwable;
                        }
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()");
                }
                this.blockedThread = null;
                return traceRet12222;
            }
            var4_1 = null;
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()");
            }
            this.blockedThread = null;
        }
        MessageImpl result = this.dequeueImmediate();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeue", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeue()", result, 3);
        }
        return result;
    }

    synchronized MessageImpl dequeueNoWait() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueNoWait()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeueNoWait");
        }
        MessageImpl result = null;
        if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
            result = this.dequeueImmediate();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeueNoWait", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueNoWait()", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized MessageImpl dequeueWait(long timeToWait) throws InterruptedException, JMSWrappedException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)", new Object[]{new Long(timeToWait)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeueWait", (Object)new Long(timeToWait));
        }
        if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
            MessageImpl result = this.dequeueImmediate();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"dequeueWait", (Object)result);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)", result, 1);
            }
            return result;
        }
        long currentTime = System.currentTimeMillis();
        long endTime = currentTime + timeToWait;
        while (endTime > currentTime) {
            block16: {
                Object var9_5;
                if (!this.alive) {
                    InterruptedException traceRet1 = new InterruptedException(ExceptionBuilder.buildReasonString((int)-1683405580, null));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)", traceRet1);
                    }
                    throw traceRet1;
                }
                this.blockedThread = Thread.currentThread();
                try {
                    this.wait(endTime - currentTime);
                    var9_5 = null;
                    if (!Trace.isOn) break block16;
                }
                catch (Throwable throwable) {
                    var9_5 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)");
                    }
                    this.blockedThread = null;
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)");
            }
            this.blockedThread = null;
            if (!(this.stopped || this.priorityQueue.isEmpty() && this.normalQueue.isEmpty())) {
                MessageImpl result = this.dequeueImmediate();
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"dequeueWait", (Object)result);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)", result, 2);
                }
                return result;
            }
            currentTime = System.currentTimeMillis();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeueWait", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueWait(long)", null, 3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized MessageImpl dequeueImmediate() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueImmediate()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dequeueImmediate");
        }
        MessageImpl result = null;
        if (!this.priorityQueue.isEmpty()) {
            result = (MessageImpl)this.priorityQueue.dequeue();
        } else if (!this.normalQueue.isEmpty()) {
            result = (MessageImpl)this.normalQueue.dequeue();
        }
        if (result == null) {
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"dequeueImmediate: result==null");
            }
            Assert.failure();
        }
        --this.messageCount;
        Assert.condition((this.messageCount >= 0 ? 1 : 0) != 0);
        if (this.enableFlowControl) {
            int freeSpace = this.maxMessageCount - this.messageCount;
            ConnectionImpl.FreeSpaceHeap freeSpaceHeap = this.fsh;
            synchronized (freeSpaceHeap) {
                long oldprio = this.hdl.priority;
                if (this.hdl == this.fsh.minNode()) {
                    this.fsh.changePriority(freeSpace - (int)this.hdl.priority, this.hdl);
                    if (this.fsh.minPriority() > oldprio) {
                        block22: {
                            try {
                                this.conn.advanceRecvWindow((int)this.fsh.minPriority());
                            }
                            catch (IOException e) {
                                if (!Trace.isOn) break block22;
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueImmediate()", e);
                            }
                        }
                        if (debug.debugIt(2)) {
                            debug.debug(-175584356845707L, (Object)"dequeueImmediate", (Object)(this.conn + ":freeSpace=" + freeSpace + ",oldprio=" + oldprio + ",advancedRecvWindow to " + this.fsh.minPriority()));
                        }
                    } else if (debug.debugIt(2)) {
                        debug.debug(-175584356845707L, (Object)"dequeueImmediate", (Object)(this.conn + ":freeSpace=" + freeSpace + ",oldprio=" + oldprio + ",recvwindow not advanced:" + this.fsh.minPriority()));
                    }
                } else if (debug.debugIt(2)) {
                    debug.debug(-175584356845707L, (Object)"dequeueImmediate", (Object)(this.conn + ":freeSpace=" + freeSpace + ",priority not changed"));
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dequeueImmediate", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "dequeueImmediate()", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveTo(MessageQueue otherQueue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "moveTo(MessageQueue)", new Object[]{otherQueue});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"moveTo", (Object)otherQueue);
        }
        MessageQueue messageQueue = otherQueue;
        synchronized (messageQueue) {
            while (!this.priorityQueue.isEmpty()) {
                otherQueue.priorityQueue.enqueue(this.priorityQueue.dequeue());
                ++otherQueue.messageCount;
                --this.messageCount;
            }
            while (!this.normalQueue.isEmpty()) {
                otherQueue.normalQueue.enqueue(this.normalQueue.dequeue());
                ++otherQueue.messageCount;
                --this.messageCount;
            }
            otherQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"moveTo");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "moveTo(MessageQueue)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveMessagesFor(MessageConsumerImpl consumer, MessageQueue otherQueue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "moveMessagesFor(MessageConsumerImpl,MessageQueue)", new Object[]{consumer, otherQueue});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"moveMessageFor", (Object)consumer, (Object)otherQueue);
        }
        MessageQueue tempQueue = new MessageQueue(0);
        MessageQueue messageQueue = otherQueue;
        synchronized (messageQueue) {
            MessageImpl msg;
            while (!this.priorityQueue.isEmpty()) {
                msg = (MessageImpl)this.priorityQueue.dequeue();
                --this.messageCount;
                if (msg.isFor(consumer)) {
                    otherQueue.priorityQueue.enqueue((Object)msg);
                    ++otherQueue.messageCount;
                    continue;
                }
                tempQueue.enqueue(msg);
            }
            while (!this.normalQueue.isEmpty()) {
                msg = (MessageImpl)this.normalQueue.dequeue();
                --this.messageCount;
                if (msg.isFor(consumer)) {
                    otherQueue.normalQueue.enqueue((Object)msg);
                    ++otherQueue.messageCount;
                    continue;
                }
                tempQueue.enqueue(msg);
            }
            tempQueue.moveTo(this);
            otherQueue.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"moveMessagesFor");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "moveMessagesFor(MessageConsumerImpl,MessageQueue)");
        }
    }

    synchronized void close(Exception e, boolean appClose) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "close(Exception,boolean)", new Object[]{e, appClose});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close", (Object)e, (Object)new Boolean(appClose));
        }
        this.alive = false;
        if (this.blockedThread != null) {
            this.appConnectionClosed = appClose;
            this.eConnectionClosed = e;
            this.blockedThread = null;
            this.notifyAll();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "close(Exception,boolean)");
        }
    }

    synchronized void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "stop()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        this.stopped = true;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "stop()");
        }
    }

    synchronized void start() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "start()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        this.stopped = false;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "start()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageQueue.java, jmscc.wmq.v6, k701, k701-112-140304  1.10.1.1 09/08/17 08:45:39");
        }
        debug = new DebugObject("MessageQueue");
    }
}

