/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.client.Message;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.DHPropertyContext;
import com.ibm.msg.client.wmq.v6.direct.internal.JMSWrappedException;
import com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.StreamMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TemporaryTopicImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TextMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicPublisherImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TopicSessionImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSBytesMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSObjectMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSMessage;
import java.io.IOException;
import java.util.Enumeration;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public class MessageProducerImpl
extends DHPropertyContext
implements ProviderMessageProducer,
ClientLogConstants,
ClientExceptionConstants {
    private static final long serialVersionUID = 8486182670759436851L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageProducerImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.16.1.1 09/08/17 08:45:31";
    private static final int JMS101_DEFAULT_VAL = -1;
    private static final DebugObject debug;
    private static final int defaultDeliveryMode = 1;
    private boolean active = true;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    protected int deliveryMode = 1;
    protected int priority = 4;
    protected long timeToLive = 0L;
    private SessionImpl parentSession;
    protected WMQDestination topic;

    MessageProducerImpl(ProviderDestination destination, SessionImpl session, JmsPropertyContext propertyContext) throws JMSException {
        super(propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "<init>(ProviderDestination,SessionImpl,JmsPropertyContext)", new Object[]{destination, session, propertyContext});
        }
        this.setIntProperty("deliveryMode", 1);
        this.parentSession = session;
        if (destination != null) {
            if (!destination.isTopic()) {
                InvalidDestinationException traceRet1 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{destination.getClass().toString()}));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "<init>(ProviderDestination,SessionImpl,JmsPropertyContext)", (Throwable)traceRet1, 1);
                }
                throw traceRet1;
            }
            this.topic = (WMQDestination)destination;
            if (this.containsWildcard(this.topic)) {
                InvalidDestinationException traceRet2 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{this.topic}));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "<init>(ProviderDestination,SessionImpl,JmsPropertyContext)", (Throwable)traceRet2, 2);
                }
                throw traceRet2;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "<init>(ProviderDestination,SessionImpl,JmsPropertyContext)");
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDisableMessageID(boolean)", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDisableMessageID", (Object)new Boolean(value));
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDisableMessageID(boolean)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.disableMessageID = value;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDisableMessageID");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDisableMessageID(boolean)");
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDisableMessageID()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDisableMessageID");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDisableMessageID()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDisableMessageID", (Object)new Boolean(this.disableMessageID));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDisableMessageID()", this.disableMessageID);
        }
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDisableMessageTimestamp(boolean)", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDisableMessageTimestamp", (Object)new Boolean(value));
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDisableMessageTimestamp(boolean)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.disableMessageTimestamp = value;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDisableMessageTimestamp");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDisableMessageTimestamp(boolean)");
        }
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDisableMessageTimestamp()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDisableMessageTimestamp");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDisableMessageTimestamp()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDisableMessageTimestamp", (Object)new Boolean(this.disableMessageTimestamp));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDisableMessageTimestamp()", this.disableMessageTimestamp);
        }
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSInvalidParameterException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDeliveryMode(int)", new Object[]{new Integer(deliveryMode)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDeliveryMode", (Object)new Integer(deliveryMode));
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDeliveryMode(int)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        MessageImpl.validateDeliveryMode(deliveryMode);
        this.deliveryMode = deliveryMode;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDeliveryMode");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setDeliveryMode(int)");
        }
    }

    public int getDeliveryMode() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDeliveryMode()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDeliveryMode");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDeliveryMode()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDeliveryMode", (Object)new Integer(this.deliveryMode));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDeliveryMode()", new Integer(this.deliveryMode));
        }
        return this.deliveryMode;
    }

    public void setPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setPriority(int)", new Object[]{new Integer(priority)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setPriority", (Object)new Integer(priority));
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setPriority(int)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        MessageImpl.validatePriority(priority);
        this.priority = priority;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setPriority");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setPriority(int)");
        }
    }

    public int getPriority() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getPriority()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getPriority");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getPriority()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getPriority", (Object)new Integer(this.priority));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getPriority()", new Integer(this.priority));
        }
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setTimeToLive(long)", new Object[]{new Long(timeToLive)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setTimeToLive", (Object)new Long(timeToLive));
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setTimeToLive(long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (timeToLive < 0L) {
            String key = "MQJMS1006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSInvalidParameterException traceRet2 = new JMSInvalidParameterException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setTimeToLive(long)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (timeToLive > 0L) {
            String key = "MQJMS6402";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet3 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setTimeToLive(long)", traceRet3, 3);
            }
            throw traceRet3;
        }
        this.timeToLive = timeToLive;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setTimeToLive");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setTimeToLive(long)");
        }
    }

    public void setTimeToLive(int timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "setTimeToLive(int)", "setter", new Integer(timeToLive));
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setTimeToLive", (Object)new Long(timeToLive));
        }
        this.setTimeToLive((long)timeToLive);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setTimeToLive");
        }
    }

    public long getTimeToLive() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getTimeToLive()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTimeToLive");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getTimeToLive()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTimeToLive", (Object)new Long(this.timeToLive));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getTimeToLive()", new Long(this.timeToLive));
        }
        return this.timeToLive;
    }

    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "close(boolean)", new Object[]{closingFromSession});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        if (this.isClosed()) {
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"close");
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "close(boolean)", 1);
            }
            return;
        }
        this.active = false;
        this.parentSession = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "close(boolean)", 2);
        }
    }

    SessionImpl getSession() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getSession");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getSession", (Object)this.parentSession);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getSession()", "getter", this.parentSession);
        }
        return this.parentSession;
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "isActive()", "getter", this.active);
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "isClosed()", "getter", !this.active);
        }
        return !this.active;
    }

    public void send(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage)", new Object[]{message});
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.topic == null) {
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSNotSupportedException traceRet2 = new JMSNotSupportedException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage)");
        }
    }

    public void send(ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage,int,int,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.topic == null) {
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSNotSupportedException traceRet2 = new JMSNotSupportedException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage,int,int,long)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        MessageImpl.validateDeliveryMode(deliveryMode);
        MessageImpl.validatePriority(priority);
        if (timeToLive > 0L) {
            String key = "MQJMS6402";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet3 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage,int,int,long)", traceRet3, 3);
            }
            throw traceRet3;
        }
        if (timeToLive != -1L && timeToLive < 0L) {
            JMSException je = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(timeToLive));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage,int,int,long)", je, 4);
            }
            throw je;
        }
        MessageImpl msg = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(this.topic, msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderMessage,int,int,long)");
        }
    }

    private MessageImpl createGryphonDomesticMessage(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "createGryphonDomesticMessage(ProviderMessage)", new Object[]{message});
        }
        if (message instanceof MessageImpl) {
            MessageImpl traceRet1 = (MessageImpl)message;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "createGryphonDomesticMessage(ProviderMessage)", traceRet1, 1);
            }
            return traceRet1;
        }
        MessageImpl msg = null;
        SessionImpl sess = this.getSession();
        Class<?> msgCls = message.getClass();
        Class<?>[] intfs = msgCls.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (intfs[i].getName().equals("com.ibm.msg.client.provider.ProviderBytesMessage")) {
                msg = (BytesMessageImpl)sess.createBytesMessage();
                byte[] buf = new byte[256];
                int len = -1;
                while ((len = ((JMSBytesMessage)message).readBytes(buf)) == buf.length) {
                    ((BytesMessageImpl)msg).writeBytes(buf);
                }
                if (len == -1) break;
                ((BytesMessageImpl)msg).writeBytes(buf, 0, len);
                break;
            }
            if (intfs[i].getName().equals("com.ibm.msg.client.provider.ProviderStreamMessage")) {
                msg = (StreamMessageImpl)sess.createStreamMessage();
                try {
                    while (true) {
                        ((ProviderStreamMessage)((Object)msg)).writeObject(((ProviderStreamMessage)message).readObject());
                    }
                }
                catch (MessageEOFException e) {
                    if (!Trace.isOn) break;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "createGryphonDomesticMessage(ProviderMessage)", e);
                    break;
                }
            }
            if (intfs[i].getName().equals("com.ibm.msg.client.provider.ProviderTextMessage")) {
                msg = (TextMessageImpl)sess.createTextMessage();
                ((ProviderTextMessage)((Object)msg)).setText(((ProviderTextMessage)message).getText());
                break;
            }
            if (intfs[i].getName().equals("com.ibm.msg.client.provider.ProviderObjectMessage")) {
                msg = (ObjectMessageImpl)sess.createObjectMessage();
                ((ObjectMessageImpl)msg).setObject(((JMSObjectMessage)message).getObject());
                break;
            }
            if (!intfs[i].getName().equals("com.ibm.msg.client.provider.ProviderMapMessage")) continue;
            msg = (MapMessageImpl)sess.createMapMessage();
            Enumeration names = ((ProviderMapMessage)((Object)msg)).getMapNames();
            while (names.hasMoreElements()) {
                String n = (String)names.nextElement();
                ((ProviderMapMessage)((Object)msg)).setObject(n, ((ProviderMapMessage)message).getObject(n));
            }
            break;
        }
        if (msg == null) {
            msg = new MessageImpl();
        }
        msg.setJMSCorrelationID(message.getJMSCorrelationID());
        msg.setJMSPriority(message.getJMSPriority());
        msg.setJMSExpiration(message.getJMSExpiration().intValue());
        msg.setJMSType(message.getJMSType());
        Enumeration props = message.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            msg.setObjectProperty(name, message.getObjectProperty(name));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "createGryphonDomesticMessage(ProviderMessage)", msg, 2);
        }
        return msg;
    }

    public void send(ProviderDestination topic, ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage)", new Object[]{topic, message});
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (topic == null) {
            if (this.topic == null) {
                String key = "MQJMS4124";
                String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
                JMSParameterIsNullException traceRet2 = new JMSParameterIsNullException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage)", (Throwable)((Object)traceRet2), 2);
                }
                throw traceRet2;
            }
            topic = this.topic;
        }
        if (!topic.isTopic()) {
            InvalidDestinationException traceRet3 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{topic.getClass().toString()}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        WMQDestination mqtopic = (WMQDestination)topic;
        if (this.containsWildcard(mqtopic)) {
            InvalidDestinationException traceRet4 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{topic}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        int localDeliveryMode = message.getJMSDeliveryMode();
        int localPriority = message.getJMSPriority();
        long localExpiration = message.getJMSExpiration();
        long localTimestamp = message.getJMSTimestamp();
        if (localTimestamp == 0L) {
            localTimestamp = System.currentTimeMillis();
        }
        long localTimeToLive = 0L;
        if (localExpiration > 0L) {
            localTimeToLive = localExpiration - localTimestamp;
        }
        if (localTimeToLive < 0L) {
            localTimeToLive = 1L;
        }
        this.send(mqtopic, message, localDeliveryMode, localPriority, localTimeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage)");
        }
    }

    public void send(ProviderDestination topic, ProviderMessage message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (topic != null && topic instanceof TemporaryTopicImpl && ((TemporaryTopicImpl)topic).isDeleted()) {
            String key = "MQJMS3019";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet2 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (topic == null) {
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "Topic");
            JMSParameterIsNullException traceRet3 = new JMSParameterIsNullException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (!topic.isTopic()) {
            InvalidDestinationException traceRet4 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)231319338, (Object[])new Object[]{topic.getClass().toString()}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        WMQDestination mqtopic = (WMQDestination)topic;
        if (this.containsWildcard(mqtopic)) {
            InvalidDestinationException traceRet5 = new InvalidDestinationException(ExceptionBuilder.buildReasonString((int)166257773, (Object[])new Object[]{topic}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", (Throwable)traceRet5, 5);
            }
            throw traceRet5;
        }
        MessageImpl.validateDeliveryMode(deliveryMode);
        MessageImpl.validatePriority(priority);
        if (timeToLive > 0L) {
            String key = "MQJMS6402";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet6 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", traceRet6, 6);
            }
            throw traceRet6;
        }
        if (timeToLive != -1L && timeToLive < 0L) {
            JMSException je = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(timeToLive));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)", je, 7);
            }
            throw je;
        }
        MessageImpl msg = message instanceof MessageImpl ? (MessageImpl)message : this.createGryphonDomesticMessage(message);
        this.publishInternal(mqtopic, msg, deliveryMode, priority, timeToLive);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "send(ProviderDestination,ProviderMessage,int,int,long)");
        }
    }

    protected void publishInternal(WMQDestination topic, MessageImpl message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        int enc;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)", new Object[]{topic, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (message == null) {
            String key = "MQJMS4124";
            String msg = ConfigEnvironment.getErrorMessage(key, "ProviderMessage");
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (message instanceof BytesMessageImpl) {
            ((BytesMessageImpl)message).prepareMessage();
        }
        message.setTopic(topic);
        long destExp = topic.getLongProperty("timeToLive");
        if (destExp == -2L) {
            if (timeToLive == -1L) {
                message.setJMSExpiration(this.getTimeToLive());
            } else {
                message.setJMSExpiration(timeToLive);
            }
        } else {
            if (destExp > 0L) {
                String key = "MQJMS6403";
                String msg = ConfigEnvironment.getErrorMessage(key);
                JMSException traceRet3 = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)", traceRet3, 3);
                }
                throw traceRet3;
            }
            message.setJMSExpiration(destExp);
        }
        int destPri = topic.getIntProperty("priority");
        if (destPri == -2) {
            if (priority == -1) {
                message.setPriority(this.getPriority());
            } else {
                message.setPriority(priority);
            }
        } else if (destPri == -1) {
            message.setJMSPriority(4);
        } else {
            message.setJMSPriority(destPri);
        }
        int destPer = topic.getIntProperty("deliveryMode");
        if (destPer == -2) {
            if (deliveryMode == -1) {
                message.setJMSDeliveryMode(this.getDeliveryMode());
            } else {
                message.setJMSDeliveryMode(deliveryMode);
            }
        } else {
            MessageImpl.validateDeliveryMode(destPer);
            message.setJMSDeliveryMode(destPer);
        }
        Integer encoding = (Integer)message.getObjectProperty("JMS_IBM_Encoding");
        if (encoding == null) {
            enc = topic.getIntProperty("encoding");
            message.setIntProperty("JMS_IBM_Encoding", enc);
            message.setJMSEncoding(enc);
        } else {
            enc = encoding;
        }
        if (message.getStringProperty("JMS_IBM_Character_Set") == null) {
            int ccsid = topic.getIntProperty("CCSID");
            String charset = MQJMSMessage.getCharacterSetString(ccsid, enc);
            message.setStringProperty("JMS_IBM_Character_Set", charset);
            message.setJMSCharset(charset);
        }
        if (!this.getDisableMessageTimestamp()) {
            message.setJMSTimestamp(System.currentTimeMillis());
        } else {
            message.resetJMSTimestamp();
        }
        try {
            this.getSession().getConnection().send((Message)message);
            message.messageId = null;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)", e);
            }
            JMSWrappedException traceRet4 = new JMSWrappedException(ExceptionBuilder.buildReasonString((int)800870265, (Object[])new Object[]{e}), e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)", (Throwable)((Object)traceRet4), 4);
            }
            throw traceRet4;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "publishInternal(WMQDestination,MessageImpl,int,int,long)");
        }
    }

    public void closeTP() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "closeTP()");
        }
        if (this.isClosed()) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "closeTP()", 1);
            }
            return;
        }
        TopicSessionImpl session = (TopicSessionImpl)this.getSession();
        if (session != null) {
            session.closed((TopicPublisherImpl)this);
        }
        this.topic = null;
        this.close(false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "closeTP()", 2);
        }
    }

    public ProviderDestination getDestination() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDestination()");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDestination()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "getDestination()", this.topic);
        }
        return this.topic;
    }

    public boolean containsWildcard(WMQDestination topic) {
        String topicString;
        boolean result;
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "containsWildcard(WMQDestination)", new Object[]{topic});
            }
            result = false;
            topicString = null;
            try {
                topicString = topic.getStringProperty("XMSC_DESTINATION_NAME");
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "containsWildcard(WMQDestination)", e);
            }
        }
        boolean bl = result = this.findFirstMatchManyWildcard(topicString) >= 0 || this.findFirstMatchOneWildcard(topicString) >= 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "containsWildcard(WMQDestination)", result);
        }
        return result;
    }

    public boolean validate(Object name, Object value) throws JMSException {
        long val;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "validate(Object,Object)", new Object[]{name, value});
        }
        if (name.equals("deliveryMode")) {
            int val2 = (Integer)value;
            if (val2 != 1) {
                String key = "MQJMS6401";
                String msg = ConfigEnvironment.getErrorMessage(key);
                JMSException traceRet1 = new JMSException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "validate(Object,Object)", traceRet1, 1);
                }
                throw traceRet1;
            }
        } else if (name.equals("timeToLive") && (val = ((Long)value).longValue()) > 0L) {
            String key = "MQJMS6402";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet2 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "validate(Object,Object)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "validate(Object,Object)", true);
        }
        return true;
    }

    private final int findFirstMatchManyWildcard(String topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Object[]{topic});
        }
        int firstOccurrence = -1;
        int topiclength = topic.length();
        if (topic == null || topiclength == 0) {
            int traceRet1 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        if (topiclength == 1) {
            if (topic.charAt(0) == '#') {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(0), 2);
                }
                return 0;
            }
            int traceRet2 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(traceRet2), 3);
            }
            return traceRet2;
        }
        if (topic.charAt(0) == '#' && topic.charAt(1) == '/') {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(0), 4);
            }
            return 0;
        }
        firstOccurrence = topic.indexOf("/#/");
        if (firstOccurrence != -1) {
            int traceRet3 = firstOccurrence + 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(traceRet3), 5);
            }
            return traceRet3;
        }
        if (topic.charAt(topiclength - 2) == '/' && topic.charAt(topiclength - 1) == '#') {
            int traceRet4 = topiclength - 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(traceRet4), 6);
            }
            return traceRet4;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchManyWildcard(String)", new Integer(firstOccurrence), 7);
        }
        return firstOccurrence;
    }

    private final int findFirstMatchOneWildcard(String topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Object[]{topic});
        }
        int firstOccurrence = -1;
        int topiclength = topic.length();
        if (topic == null || topiclength == 0) {
            int traceRet1 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        if (topiclength == 1) {
            if (topic.charAt(0) == '+') {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(0), 2);
                }
                return 0;
            }
            int traceRet2 = -1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(traceRet2), 3);
            }
            return traceRet2;
        }
        if (topic.charAt(0) == '+' && topic.charAt(1) == '/') {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(0), 4);
            }
            return 0;
        }
        firstOccurrence = topic.indexOf("/+/");
        if (firstOccurrence != -1) {
            int traceRet3 = firstOccurrence + 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(traceRet3), 5);
            }
            return traceRet3;
        }
        if (topic.charAt(topiclength - 2) == '/' && topic.charAt(topiclength - 1) == '+') {
            int traceRet4 = topiclength - 1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(traceRet4), 6);
            }
            return traceRet4;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "findFirstMatchOneWildcard(String)", new Integer(firstOccurrence), 7);
        }
        return firstOccurrence;
    }

    public boolean providerPriorityValidate(int priority) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "providerPriorityValidate(int)", new Object[]{new Integer(priority)});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "providerPriorityValidate(int)", false);
        }
        return false;
    }

    public boolean providerTimeToLiveValidate(long timeToLive) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "providerTimeToLiveValidate(long)", new Object[]{new Long(timeToLive)});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "providerTimeToLiveValidate(long)", false);
        }
        return false;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.MessageProducerImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageProducerImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.16.1.1 09/08/17 08:45:31");
        }
        debug = new DebugObject("MessageProducerImpl");
    }
}

