/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.ConnectorImpl;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.Framing;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.formats.SchemaRegistry;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSInvalidParameterException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.ObjectMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SerialMessage;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.StreamMessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.TextMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStringResources;
import com.ibm.msg.client.wmq.v6.jms.internal.MQJMSStringResources;
import java.io.Serializable;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MessageImpl
extends com.ibm.disthub2.impl.client.MessageImpl
implements ProviderMessage,
Serializable,
ClientLogConstants,
ClientExceptionConstants {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.15.1.1 09/08/17 08:45:18";
    private static final DebugObject debug;
    private static final long serialVersionUID = -4266952183484564154L;
    public static final String CLASS_NONE = "jms_none";
    public static final String CLASS_TEXT = "jms_text";
    public static final String CLASS_OBJECT = "jms_object";
    public static final String CLASS_MAP = "jms_map";
    public static final String CLASS_STREAM = "jms_stream";
    public static final String CLASS_BYTES = "jms_bytes";
    String messageClass = "jms_none";
    private SessionImpl session;
    private MessageConsumerImpl consumer;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    long expiration = 0L;
    boolean redelivered = false;
    Dictionary props;
    String messageId;
    boolean isDisposable = true;
    private int encoding;
    private String charset;
    static final StringBuffer NULL;
    transient JMSStringResources jmsStrings = new MQJMSStringResources();

    public static MessageImpl construct(MessageHandle cursor, ConnectionImpl conn) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "construct(MessageHandle,ConnectionImpl)", new Object[]{cursor, conn});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"construct", (Object)cursor, (Object)conn);
        }
        MessageImpl result = null;
        switch (cursor.getChoice(157)) {
            case 2: {
                result = new ObjectMessageImpl(cursor, conn);
                break;
            }
            case 3: {
                result = new BytesMessageImpl(cursor, conn);
                break;
            }
            case 4: {
                result = new TextMessageImpl(cursor, conn);
                break;
            }
            case 5: {
                result = new StreamMessageImpl(cursor, conn);
                break;
            }
            case 6: {
                result = new MapMessageImpl(cursor, conn);
                break;
            }
            default: {
                result = new MessageImpl(cursor, conn);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"construct", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "construct(MessageHandle,ConnectionImpl)", result);
        }
        return result;
    }

    public static MessageImpl construct(int type) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "construct(int)", new Object[]{new Integer(type)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"construct", (Object)new Integer(type));
        }
        MessageImpl result = null;
        switch (type) {
            case 2: {
                result = new ObjectMessageImpl();
                break;
            }
            case 3: {
                result = new BytesMessageImpl();
                break;
            }
            case 4: {
                result = new TextMessageImpl();
                break;
            }
            case 5: {
                result = new StreamMessageImpl();
                break;
            }
            case 6: {
                result = new MapMessageImpl();
                break;
            }
            default: {
                result = new MessageImpl();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"construct", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "construct(int)", result);
        }
        return result;
    }

    MessageImpl duplicate() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "duplicate()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"duplicate");
        }
        byte[] frame = Framing.preFrame((MessageHandle)this.cursor, (int)Framing.overhead((byte)1, null, (boolean)false), null);
        Framing.frameMessage((byte[])frame, (short)this.cursor.getInterpreterId(), (long)this.cursor.getEncodingSchema().getId(), (int)frame.length);
        MessageHandle newCursor = SchemaRegistry.getMessageHandle((byte[])frame, null);
        MessageImpl result = MessageImpl.construct(newCursor, (ConnectionImpl)this.conn);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"duplicate", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "duplicate()", result);
        }
        return result;
    }

    MessageImpl(MessageHandle cursor, ConnectionImpl conn) {
        super(cursor, (ConnectorImpl)conn);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "<init>(MessageHandle,ConnectionImpl)", new Object[]{cursor, conn});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageImpl", (Object)cursor);
        }
        this.readOnly = true;
        this.propertiesReadOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "<init>(MessageHandle,ConnectionImpl)");
        }
    }

    public MessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "<init>()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageImpl");
        }
        this.readOnly = false;
        this.propertiesReadOnly = false;
        this.props = new Hashtable();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "<init>()");
        }
    }

    void setSession(SessionImpl s) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setSession(SessionImpl)", "setter", s);
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setSession", (Object)s);
        }
        this.session = s;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setSession");
        }
    }

    void setDisposable(boolean disposable) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setDisposable(boolean)", "setter", disposable);
        }
        this.isDisposable = disposable;
    }

    boolean getDisposable() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getDisposable()", "getter", this.isDisposable);
        }
        return this.isDisposable;
    }

    void setConsumer(MessageConsumerImpl mc) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setConsumer(MessageConsumerImpl)", "setter", mc);
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setConsumer", (Object)mc);
        }
        this.consumer = mc;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setConsumer");
        }
    }

    public void setTopic(WMQDestination value) {
        String mqtopic;
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setTopic(WMQDestination)", new Object[]{value});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"setTopic", (Object)value);
            }
            mqtopic = this.getTopicString();
            try {
                mqtopic = value.getStringProperty("XMSC_DESTINATION_NAME");
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block6;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setTopic(WMQDestination)", e);
            }
        }
        this.setTopicString(mqtopic);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setTopic");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setTopic(WMQDestination)");
        }
    }

    MessageConsumerImpl getConsumer() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getConsumer");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getConsumer", (Object)this.consumer);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getConsumer()", "getter", this.consumer);
        }
        return this.consumer;
    }

    void dispatch() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "dispatch()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"dispatch");
        }
        this.consumer.dispatch(this);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dispatch");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "dispatch()");
        }
    }

    boolean isFor(ProviderMessageConsumer aConsumer) {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isFor(ProviderMessageConsumer)", new Object[]{aConsumer});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isFor", (Object)aConsumer);
        }
        boolean bl = result = this.consumer == aConsumer;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isFor", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isFor(ProviderMessageConsumer)", result);
        }
        return result;
    }

    static void validateDeliveryMode(int deliveryMode) throws JMSInvalidParameterException, JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validateDeliveryMode(int)", new Object[]{new Integer(deliveryMode)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"validateDeliveryMode", (Object)new Integer(deliveryMode));
        }
        if (deliveryMode != 1 && deliveryMode != 2) {
            String key = "MQJMS1042";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSInvalidParameterException traceRet1 = new JMSInvalidParameterException(msg);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validateDeliveryMode(int)", (Throwable)((Object)traceRet1), 1);
            }
            throw traceRet1;
        }
        if (deliveryMode == 2) {
            String key = "MQJMS6401";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet2 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validateDeliveryMode(int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"validateDeliveryMode");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validateDeliveryMode(int)");
        }
    }

    static void validatePriority(int priority1) throws JMSInvalidParameterException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validatePriority(int)", new Object[]{new Integer(priority1)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"validatePriority", (Object)new Integer(priority1));
        }
        if (priority1 < 0 || priority1 > 9) {
            JMSInvalidParameterException traceRet1 = new JMSInvalidParameterException(ExceptionBuilder.buildReasonString((int)-522107999, (Object[])new Object[]{new Integer(priority1)}));
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validatePriority(int)", (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"validatePriority");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "validatePriority(int)");
        }
    }

    public String getJMSMessageID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSMessageID()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSMessageID");
        }
        String id = null;
        if (this.messageId == null) {
            int length;
            id = Long.toHexString(this.getMessageID());
            for (int i = length = id.length(); i < 48; ++i) {
                id = "0" + id;
            }
            this.messageId = "ID:" + id;
        }
        if (this.messageId.equals("ID:000000000000000000000000000000000000000000000000")) {
            this.messageId = null;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSMessageID", (Object)this.messageId);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSMessageID()", this.messageId);
        }
        return this.messageId;
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSMessageID(String)", new Object[]{id});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSMessageID", (Object)id);
        }
        this.messageId = id;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSMessageID");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSMessageID(String)");
        }
    }

    public Long getJMSTimestamp() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSTimestamp()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSTimestamp");
        }
        long result = this.getTimestamp();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSTimestamp", (Object)new Long(result));
        }
        Long traceRet1 = new Long(result);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSTimestamp()", traceRet1);
        }
        return traceRet1;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSTimestamp(long)", "setter", new Long(timestamp));
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSTimestamp", (Object)new Long(timestamp));
        }
        this.setTimestamp(timestamp);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSTimestamp");
        }
    }

    public void resetJMSTimestamp() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "resetJMSTimestamp()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"resetJMSTimestamp");
        }
        this.setTimestamp(0L);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"resetJMSTimestamp");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "resetJMSTimestamp()");
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSCorrelationIDAsBytes()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSCorrelationIDAsBytes");
        }
        byte[] result = null;
        if (this.getJMSCorrelationID() != null) {
            result = this.getJMSCorrelationID().getBytes();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSCorrelationIDAsBytes");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSCorrelationIDAsBytes()", result);
        }
        return result;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSCorrelationIDAsBytes(byte [ ])", "setter", correlationID);
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSCorrelationIDAsBytes", (Object)correlationID);
        }
        this.setCorrelationID(new String(correlationID));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSCorrelationIDAsBytes");
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSCorrelationID");
        }
        String ans = this.getCorrelationID();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSCorrelationID", (Object)ans);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSCorrelationID()", "getter", ans);
        }
        return ans;
    }

    public void setJMSReplyTo(ProviderDestination replyTo) throws JMSException, InvalidDestinationException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSReplyTo(ProviderDestination)", new Object[]{replyTo});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSReplyTo", (Object)replyTo);
        }
        if (replyTo == null) {
            this.setReplyString(null);
        } else if (replyTo.isTopic()) {
            this.setReplyString(replyTo.toURI());
        } else {
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException traceRet1 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSReplyTo(ProviderDestination)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSReplyTo");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSReplyTo(ProviderDestination)");
        }
    }

    String getJMSDestinationString() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSDestinationString");
        }
        String result = this.getTopicString();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSDestinationString", (Object)result);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSDestinationString()", "getter", result);
        }
        return result;
    }

    public void setJMSDestination(ProviderDestination destination) throws InvalidDestinationException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSDestination(ProviderDestination)", new Object[]{destination});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSDestination", (Object)destination);
        }
        if (!destination.isTopic()) {
            String key = "MQJMS0003";
            String msg = ConfigEnvironment.getErrorMessage(key);
            InvalidDestinationException traceRet1 = new InvalidDestinationException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSDestination(ProviderDestination)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.setTopicString(destination.getName());
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSDestination");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSDestination(ProviderDestination)");
        }
    }

    public Integer getJMSDeliveryMode() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSDeliveryMode()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSDeliveryMode");
        }
        int deliveryMode = 1;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSDeliveryMode", (Object)new Integer(deliveryMode));
        }
        Integer traceRet1 = new Integer(deliveryMode);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSDeliveryMode()", traceRet1);
        }
        return traceRet1;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSDeliveryMode(int)", "setter", new Integer(deliveryMode));
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSDeliveryMode", (Object)new Integer(deliveryMode));
        }
        MessageImpl.validateDeliveryMode(deliveryMode);
        this.setPersistent(deliveryMode == 2);
    }

    public Boolean getJMSRedelivered() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSRedelivered");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSRedelivered", (Object)new Boolean(this.redelivered));
        }
        Boolean traceRet1 = new Boolean(this.redelivered);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSRedelivered()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSRedelivered(boolean)", new Object[]{redelivered});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSRedelivered", (Object)new Boolean(redelivered));
        }
        this.redelivered = redelivered;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSRedelivered");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSRedelivered(boolean)");
        }
    }

    public Long getJMSExpiration() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSExpiration");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSExpiration", (Object)new Long(this.expiration));
        }
        Long traceRet1 = new Long(this.getJMSExpirationField());
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSExpiration()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSExpiration(long)", new Object[]{new Long(expiration)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSExpiration", (Object)new Long(expiration));
        }
        this.expiration = expiration;
        this.setJMSExpirationField(expiration);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSExpiration");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSExpiration(long)");
        }
    }

    public Integer getJMSPriority() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSPriority()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSPriority");
        }
        int result = this.getPriority();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSPriority", (Object)new Integer(result));
        }
        Integer traceRet1 = new Integer(result);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSPriority()", traceRet1);
        }
        return traceRet1;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSPriority(int)", new Object[]{new Integer(priority)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSPriority", (Object)new Integer(priority));
        }
        this.setPriority(priority);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSPriority");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSPriority(int)");
        }
    }

    public void setJMSType(String type) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSType(String)", new Object[]{type});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSType", (Object)type);
        }
        if (type != null && type.startsWith("mcd://") && !CLASS_TEXT.equals(this.messageClass) && !CLASS_BYTES.equals(this.messageClass)) {
            JMSException traceRet1 = new JMSException(ConfigEnvironment.getErrorMessage("MQJMS1006", "JMSType", type));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSType(String)", traceRet1);
            }
            throw traceRet1;
        }
        this.setJMSTypeField(type);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSType");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSType(String)");
        }
    }

    public String getJMSType() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSType");
        }
        String type = this.getJMSTypeField();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSType");
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSType()", "getter", type);
        }
        return type;
    }

    public void setJMSEncoding(int enc) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSEncoding(int)", "setter", new Integer(enc));
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSEncoding", (Object)new Integer(enc));
        }
        this.encoding = enc;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSEncoding");
        }
    }

    public int getJMSEncoding() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSEncoding");
        }
        int enc = this.encoding;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSEncoding");
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSEncoding()", "getter", new Integer(enc));
        }
        return enc;
    }

    public void setJMSCharset(String charset) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSCharset(String)", "setter", charset);
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSCharset", (Object)charset);
        }
        this.charset = charset;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSCharset");
        }
    }

    public String getJMSCharset() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getJMSCharset");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getJMSCharset");
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSCharset()", "getter", this.charset);
        }
        return this.charset;
    }

    public void clearProperties() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "clearProperties()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearProperties");
        }
        super.clearProperties();
        this.props = new Hashtable();
        this.propertiesReadOnly = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearProperties");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "clearProperties()");
        }
    }

    public boolean getBooleanProperty(String name1) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getBooleanProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBooleanProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Object p = this.props.get(name1);
        Boolean b = null;
        if (p == null) {
            b = Boolean.valueOf(null);
        } else if (p instanceof String) {
            b = Boolean.valueOf((String)p);
        } else if (p instanceof Boolean) {
            b = (Boolean)p;
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getBooleanProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBooleanProperty", (Object)b);
        }
        boolean traceRet2 = b;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getBooleanProperty(String)", traceRet2);
        }
        return traceRet2;
    }

    /*
     * WARNING - void declaration
     */
    public byte getByteProperty(String name1) throws JMSException {
        void var3_3;
        Byte b;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getByteProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getByteProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            b = Byte.valueOf(null);
        } else if (p instanceof String) {
            b = Byte.valueOf((String)p);
        } else if (p instanceof Byte) {
            b = (Byte)p;
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getByteProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getByteProperty", (Object)var3_3);
        }
        byte traceRet2 = var3_3.byteValue();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getByteProperty(String)", new Byte(traceRet2));
        }
        return traceRet2;
    }

    /*
     * WARNING - void declaration
     */
    public short getShortProperty(String name1) throws JMSException {
        void var3_3;
        short s;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getShortProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getShortProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            s = Short.valueOf(null);
        } else if (p instanceof String) {
            s = Short.valueOf((String)p);
        } else if (p instanceof Short) {
            s = (Short)p;
        } else if (p instanceof Byte) {
            s = ((Byte)p).byteValue();
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getShortProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getShortProperty", (Object)new Short((short)var3_3));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getShortProperty(String)", new Short((short)var3_3));
        }
        return (short)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntProperty(String name1) throws JMSException {
        void var3_3;
        int i;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getIntProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getIntProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            i = Integer.valueOf(null);
        } else if (p instanceof String) {
            i = Integer.valueOf((String)p);
        } else if (p instanceof Integer) {
            i = (Integer)p;
        } else if (p instanceof Short) {
            i = ((Short)p).shortValue();
        } else if (p instanceof Byte) {
            i = ((Byte)p).byteValue();
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getIntProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getIntProperty", (Object)new Integer((int)var3_3));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getIntProperty(String)", new Integer((int)var3_3));
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public long getLongProperty(String name1) throws JMSException {
        void var3_3;
        long l;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getLongProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getLongProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            l = Long.valueOf(null);
        } else if (p instanceof String) {
            l = Long.valueOf((String)p);
        } else if (p instanceof Long) {
            l = (Long)p;
        } else if (p instanceof Integer) {
            l = ((Integer)p).intValue();
        } else if (p instanceof Short) {
            l = ((Short)p).shortValue();
        } else if (p instanceof Byte) {
            l = ((Byte)p).byteValue();
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getLongProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getLongProperty", (Object)new Long((long)var3_3));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getLongProperty(String)", new Long((long)var3_3));
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public float getFloatProperty(String name1) throws JMSException {
        void var3_3;
        Float f;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getFloatProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getFloatProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            f = Float.valueOf(null);
        } else if (p instanceof String) {
            f = Float.valueOf((String)p);
        } else if (p instanceof Float) {
            f = (Float)p;
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getFloatProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getFloatProperty", (Object)var3_3);
        }
        float traceRet2 = var3_3.floatValue();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getFloatProperty(String)", new Float(traceRet2));
        }
        return traceRet2;
    }

    /*
     * WARNING - void declaration
     */
    public double getDoubleProperty(String name1) throws JMSException {
        void var3_3;
        Double d;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getDoubleProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDoubleProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            d = Double.valueOf(null);
        } else if (p instanceof String) {
            d = Double.valueOf((String)p);
        } else if (p instanceof Double) {
            d = (Double)p;
        } else if (p instanceof Float) {
            d = new Double(((Float)p).doubleValue());
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getDoubleProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDoubleProperty", (Object)var3_3);
        }
        double traceRet2 = var3_3.doubleValue();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getDoubleProperty(String)", new Double(traceRet2));
        }
        return traceRet2;
    }

    public String getStringProperty(String name1) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getStringProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getStringProperty", (Object)name1);
        }
        if (name1 == null) {
            JMSException traceRet1 = new JMSException("MQJMS1029", name1);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getStringProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Object property = this.props.get(name1);
        String result = null;
        if (property != null && property != NULL) {
            result = property.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getStringProperty", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getStringProperty(String)", result);
        }
        return result;
    }

    public Object getObjectProperty(String name1) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getObjectProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getObjectProperty", (Object)name1);
        }
        if (name1 == null) {
            JMSException traceRet1 = new JMSException("MQJMS1029", name1);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getObjectProperty(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Object property = this.props.get(name1);
        Object result = null;
        if (property != null && property != NULL) {
            result = property;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getObjectProperty", result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getObjectProperty(String)", result);
        }
        return result;
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getPropertyNames()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getPropertyNames");
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        Enumeration result = this.props.keys();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getPropertyNames", result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getPropertyNames()", result);
        }
        return result;
    }

    public void setBatchProperties(Map properties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBatchProperties(Map)", new Object[]{properties});
        }
        Iterator keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            this.setObjectProperty((String)key, properties.get(key));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBatchProperties(Map)");
        }
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBooleanProperty(String,boolean)", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBooleanProperty", (Object)name, (Object)new Boolean(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBooleanProperty(String,boolean)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBooleanProperty(String,boolean)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBooleanProperty(String,boolean)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Boolean(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBooleanProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBooleanProperty(String,boolean)");
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setByteProperty(String,byte)", new Object[]{name, new Byte(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setByteProperty", (Object)name, (Object)new Byte(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setByteProperty(String,byte)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setByteProperty(String,byte)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setByteProperty(String,byte)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Byte(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setByteProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setByteProperty(String,byte)");
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setShortProperty(String,short)", new Object[]{name, new Short(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setShortProperty", (Object)name, (Object)new Short(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setShortProperty(String,short)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setShortProperty(String,short)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setShortProperty(String,short)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Short(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setShortProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setShortProperty(String,short)");
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setIntProperty(String,int)", new Object[]{name, new Integer(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setIntProperty", (Object)name, (Object)new Integer(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setIntProperty(String,int)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setIntProperty(String,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setIntProperty(String,int)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Integer(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setIntProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setIntProperty(String,int)");
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setLongProperty(String,long)", new Object[]{name, new Long(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setLongProperty", (Object)name, (Object)new Long(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setLongProperty(String,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setLongProperty(String,long)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setLongProperty(String,long)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Long(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setLongProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setLongProperty(String,long)");
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setFloatProperty(String,float)", new Object[]{name, new Float(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setFloatProperty", (Object)name, (Object)new Float(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setFloatProperty(String,float)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setFloatProperty(String,float)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setFloatProperty(String,float)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Float(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setFloatProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setFloatProperty(String,float)");
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setDoubleProperty(String,double)", new Object[]{name, new Double(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDoubleProperty", (Object)name, (Object)new Double(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setDoubleProperty(String,double)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setDoubleProperty(String,double)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setDoubleProperty(String,double)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Double(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDoubleProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setDoubleProperty(String,double)");
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setStringProperty(String,String)", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setStringProperty", (Object)name, (Object)value);
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setStringProperty(String,String)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setStringProperty(String,String)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setStringProperty(String,String)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (value == null) {
            this.props.put(name, NULL);
        } else {
            this.props.put(name, value);
        }
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setStringProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setStringProperty(String,String)");
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setObjectProperty(String,Object)", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setObjectProperty", (Object)name, value);
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setObjectProperty(String,Object)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setObjectProperty(String,Object)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setObjectProperty(String,Object)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (value == null) {
            this.props.put(name, NULL);
        } else if (value instanceof byte[]) {
            this.props.put(name, "");
        } else {
            if (!(value instanceof String || value instanceof Number || value instanceof Boolean)) {
                String key = "MQJMS0006";
                String msg = ConfigEnvironment.getErrorMessage(key);
                MessageFormatException traceRet4 = new MessageFormatException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setObjectProperty(String,Object)", (Throwable)traceRet4, 4);
                }
                throw traceRet4;
            }
            this.props.put(name, value);
        }
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setObjectProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setObjectProperty(String,Object)");
        }
    }

    public void acknowledge() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "acknowledge()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"acknowledge");
        }
        if (this.session != null && !this.session.getTransacted() && this.session.getAcknowledgeMode() != 1 && this.session.getAcknowledgeMode() != 3) {
            String key = "MQJMS6404";
            String msg = ConfigEnvironment.getErrorMessage(key);
            JMSException traceRet1 = new JMSException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "acknowledge()", traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"acknowledge");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "acknowledge()");
        }
    }

    public void clearBody() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "clearBody()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.readOnly = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBudy");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "clearBody()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJMSCorrelationID(String s) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSCorrelationID(String)", new Object[]{s});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setJMSCorrelationID", (Object)s);
        }
        if (s != null) {
            if (s.startsWith("ID:")) {
                try {
                    this.hexToBin(s, 3);
                }
                finally {
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSCorrelationID(String)");
                    }
                }
            }
            this.setCorrelationID(s);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setJMSCorrelationID");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSCorrelationID(String)");
        }
    }

    public boolean propertyExists(String s) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "propertyExists(String)", new Object[]{s});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"propertyExists", (Object)s);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        boolean result = ((Hashtable)this.props).containsKey(s);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"propertyExists", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "propertyExists(String)", result);
        }
        return result;
    }

    public int length() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "length()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"length");
        }
        int result = this.cursor.getEncodedLength(null);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"length", (Object)new Integer(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "length()", new Integer(result));
        }
        return result;
    }

    public Object writeReplace() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "writeReplace()");
        }
        SerialMessage traceRet1 = new SerialMessage(this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "writeReplace()", traceRet1);
        }
        return traceRet1;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        try {
            retval.append("\nJMS ProviderMessage class: " + this.messageClass);
            retval.append("\n  JMSDeliveryMode: " + this.getJMSDeliveryMode());
            retval.append("\n  JMSExpiration:   " + this.getJMSExpiration());
            retval.append("\n  JMSPriority:     " + this.getJMSPriority());
            retval.append("\n  JMSMessageID:    " + this.getJMSMessageID());
            retval.append("\n  JMSTimestamp:    " + this.getJMSTimestamp());
            retval.append("\n  JMSCorrelationID:" + this.getJMSCorrelationID());
            retval.append("\n  JMSDestination:  " + this.getJMSDestinationAsString());
            retval.append("\n  JMSReplyTo:      " + this.getJMSReplyToAsString());
            retval.append("\n  JMSRedelivered:  " + this.getJMSRedelivered());
            Enumeration propertyNames = this.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name1 = (String)propertyNames.nextElement();
                retval.append("\n  " + name1 + ":" + this.getObjectProperty(name1));
            }
        }
        catch (JMSException ex) {
            // empty catch block
        }
        String traceRet1 = retval.toString();
        return traceRet1;
    }

    byte[] hexToBin(String hex, int start1) throws JMSException {
        int length;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "hexToBin(String,int)", new Object[]{hex, new Integer(start1)});
        }
        if ((length = hex.length() - start1) == 0) {
            byte[] traceRet1 = new byte[]{};
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "hexToBin(String,int)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (length < 0 || length % 2 != 0) {
            JMSInvalidParameterException traceRet2 = new JMSInvalidParameterException(ExceptionBuilder.buildReasonString((int)-297750435, (Object[])new Object[]{new String(hex)}));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "hexToBin(String,int)", (Throwable)((Object)traceRet2), 1);
            }
            throw traceRet2;
        }
        byte[] retval = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            int digit1 = Character.digit(hex.charAt(2 * i + start1), 16) << 4;
            int digit2 = Character.digit(hex.charAt(2 * i + start1 + 1), 16);
            if (digit1 < 0 || digit2 < 0) {
                JMSInvalidParameterException traceRet3 = new JMSInvalidParameterException(ExceptionBuilder.buildReasonString((int)-297750435, (Object[])new Object[]{new String(hex)}));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "hexToBin(String,int)", (Throwable)((Object)traceRet3), 2);
                }
                throw traceRet3;
            }
            retval[i] = (byte)(digit1 + digit2);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "hexToBin(String,int)", retval, 2);
        }
        return retval;
    }

    private boolean isSettablePropertyName(String propertyName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", new Object[]{propertyName});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"Checking property name for validity", (Object)propertyName);
        }
        if (propertyName == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", false, 1);
            }
            return false;
        }
        if (!Character.isJavaIdentifierStart(propertyName.charAt(0))) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", false, 2);
            }
            return false;
        }
        for (int i = 1; i < propertyName.length(); ++i) {
            if (Character.isJavaIdentifierPart(propertyName.charAt(i))) continue;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", false, 3);
            }
            return false;
        }
        if (propertyName.startsWith("JMS")) {
            if (propertyName.equals("JMS_IBM_Encoding") || propertyName.equals("JMS_IBM_Character_Set")) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", true, 4);
                }
                return true;
            }
            if (propertyName.equals("JMSXGroupID") || propertyName.equals("JMSXGroupSeq")) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", true, 5);
                }
                return true;
            }
            boolean traceRet1 = this.jmsStrings.getJMS_IBM_names().containsKey(propertyName);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", traceRet1, 6);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isSettablePropertyName(String)", true, 7);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytesProperty(String name1) throws JMSException {
        void var3_3;
        byte[] bs;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getBytesProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBytesProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            bs = null;
        } else if (p instanceof String) {
            bs = ((String)p).getBytes();
        } else if (p instanceof byte[]) {
            bs = (byte[])p;
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getBytesProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBytesProperty", (Object)var3_3);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getBytesProperty(String)", var3_3);
        }
        return var3_3;
    }

    public void setBytesProperty(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBytesProperty(String,byte [ ])", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBytesProperty", (Object)name, (Object)value);
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBytesProperty(String,byte [ ])", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBytesProperty(String,byte [ ])", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBytesProperty(String,byte [ ])", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, value);
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBytesProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setBytesProperty(String,byte [ ])");
        }
    }

    /*
     * WARNING - void declaration
     */
    public char getCharProperty(String name1) throws JMSException {
        void var3_3;
        char c;
        Object p;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getCharProperty(String)", new Object[]{name1});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getCharProperty", (Object)name1);
        }
        if (this.props == null) {
            this.props = this.getProperties();
        }
        if ((p = this.props.get(name1)) == null) {
            c = '\u0000';
        } else if (p instanceof Character) {
            c = ((Character)p).charValue();
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getCharProperty(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getCharProperty", (Object)new Character((char)var3_3));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getCharProperty(String)", new Character((char)var3_3));
        }
        return (char)var3_3;
    }

    public void setCharProperty(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setCharProperty(String,char)", new Object[]{name, new Character(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setCharProperty", (Object)name, (Object)new Character(value));
        }
        if (this.propertiesReadOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setCharProperty(String,char)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setCharProperty(String,char)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.isSettablePropertyName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1058", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setCharProperty(String,char)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.props.put(name, new Character(value));
        this.setProperties(this.props);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setCharProperty");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setCharProperty(String,char)");
        }
    }

    public void removeProperty(String name1) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "removeProperty(String)", new Object[]{name1});
        }
        this.props.remove(name1);
        this.setProperties(this.props);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "removeProperty(String)");
        }
    }

    public String getJMSDestinationAsString() throws JMSException {
        String topicString = this.getTopicString();
        if (topicString != null) {
            topicString = "topic://" + this.getTopicString();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSDestinationAsString()", "getter", topicString);
        }
        return topicString;
    }

    public String getJMSReplyToAsString() throws JMSException {
        String replyString = this.getReplyString();
        if (replyString != null) {
            replyString = "topic://" + this.getReplyString();
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "getJMSReplyToAsString()", "getter", replyString);
        }
        return replyString;
    }

    public void setJMSDestinationAsString(String destination) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSDestinationAsString(String)", "setter", destination);
        }
        if (destination.startsWith("topic://")) {
            destination = destination.substring(8);
        }
        this.setTopicString(destination);
    }

    public void setJMSReplyToAsString(String replyTo) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "setJMSReplyToAsString(String)", "setter", replyTo);
        }
        this.setReplyString(replyTo);
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "clear()");
        }
        Enumeration enumeration = this.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            this.getProperties().remove(enumeration.nextElement());
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "clear()");
        }
    }

    public boolean containsKey(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "containsKey(Object)", new Object[]{key});
        }
        if (this.getProperties().get(key) != null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "containsKey(Object)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "containsKey(Object)", false, 2);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "containsValue(Object)", new Object[]{value});
        }
        Enumeration enumeration = this.getProperties().elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(value)) continue;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "containsValue(Object)", true, 1);
            }
            return true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "containsValue(Object)", false, 2);
        }
        return false;
    }

    public Set entrySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "entrySet()");
        }
        HashSet entrySet = new HashSet();
        Enumeration enumKeys = this.getProperties().elements();
        while (enumKeys.hasMoreElements()) {
            entrySet.add(enumKeys.nextElement());
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "entrySet()", entrySet);
        }
        return entrySet;
    }

    public Object get(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "get(Object)", new Object[]{key});
        }
        Object traceRet1 = this.getProperties().get(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "get(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean isEmpty() {
        boolean traceRet1 = this.getProperties().isEmpty();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "isEmpty()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Set keySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "keySet()");
        }
        HashSet keySet = new HashSet();
        Enumeration enumKeys = this.getProperties().keys();
        while (enumKeys.hasMoreElements()) {
            keySet.add(enumKeys.nextElement());
        }
        Set traceRet1 = this.keySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "keySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object put(Object arg0, Object arg1) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "put(Object,Object)", new Object[]{arg0, arg1});
        }
        Object traceRet1 = this.getProperties().put(arg0, arg1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "put(Object,Object)", traceRet1);
        }
        return traceRet1;
    }

    public void putAll(Map arg0) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "putAll(Map)", new Object[]{arg0});
        }
        Iterator itKeys = arg0.keySet().iterator();
        Iterator itValues = arg0.values().iterator();
        while (itKeys.hasNext()) {
            this.getProperties().put(itKeys.next(), itValues.next());
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "putAll(Map)");
        }
    }

    public Object remove(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "remove(Object)", new Object[]{key});
        }
        Object traceRet1 = this.getProperties().remove(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "remove(Object)", traceRet1);
        }
        return traceRet1;
    }

    public int size() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "size()");
        }
        int traceRet1 = this.getProperties().size();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "size()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Collection values() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "values()");
        }
        Set traceRet1 = this.entrySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "values()", traceRet1);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.15.1.1 09/08/17 08:45:18");
        }
        debug = new DebugObject("MessageImpl");
        NULL = new StringBuffer("<null>");
    }
}

