/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.client.Topic;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.MinimalIOException;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSListenerSetException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageListener;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.DHPropertyContext;
import com.ibm.msg.client.wmq.v6.direct.internal.JMSWrappedException;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SubscriptionInfoImpl;
import java.io.IOException;
import java.util.HashMap;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;

public class MessageConsumerImpl
extends DHPropertyContext
implements ProviderMessageConsumer,
ClientLogConstants,
ClientExceptionConstants {
    private static final long serialVersionUID = 7623800497898015264L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageConsumerImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.18.1.1 09/08/17 08:45:06";
    private static final DebugObject debug;
    private boolean active = true;
    private MessageQueue receiveQueue;
    private String messageSelector;
    protected SessionImpl parentSession;
    private MessageQueue sessionDispatchQueue;
    private ProviderMessageListener listener;
    private ProviderMessageListener sessionListener;
    protected ProviderMessageListener activeListener;
    protected WMQDestination topic;
    protected boolean noLocalMessages;
    protected int subId = -1;
    protected SubscriptionInfoImpl subInfo;
    protected String appName = null;
    protected int m_subMode;
    public SessionImpl jmsSession;
    private int readers = 0;
    private int upreaders = 0;
    private Thread readThread = null;
    private Object readLockLock = new Object();

    int getSubId() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getSubId()", "getter", new Integer(this.subId));
        }
        return this.subId;
    }

    String getSubName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getSubName()", "getter", this.appName);
        }
        return this.appName;
    }

    SubscriptionInfoImpl getSubInfo() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getSubInfo()", "getter", (Object)this.subInfo);
        }
        return this.subInfo;
    }

    public MessageConsumerImpl(String selector, SessionImpl session, JmsPropertyContext propertyContext) {
        super(propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(String,SessionImpl,JmsPropertyContext)", new Object[]{selector, session, propertyContext});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageConsumerImpl", (Object)selector, (Object)session);
        }
        this.messageSelector = selector;
        this.receiveQueue = new MessageQueue(session.getConnection().sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        if (session.getConnection().isStarted()) {
            this.receiveQueue.start();
        }
        this.parentSession = session;
        session.getConnection().addFreeSpaceHeapNode(session.getConnection().sessionConfig.MAX_MESSAGE_QUEUE_SIZE, this.receiveQueue);
        this.sessionDispatchQueue = this.parentSession.getDispatchQueue();
        try {
            this.sessionListener = this.parentSession.getMessageListener();
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(String,SessionImpl,JmsPropertyContext)", e);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "parentSession.getMessageListener() threw JMSException", null);
            }
            this.sessionListener = null;
        }
        this.activeListener = this.sessionListener;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageConsumerImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(String,SessionImpl,JmsPropertyContext)");
        }
    }

    MessageConsumerImpl(WMQDestination topic, String selector, String appName, boolean noLocalMessages, int subMode, SessionImpl session, JmsPropertyContext propertyContext) throws JMSException {
        this(selector, session, propertyContext);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", new Object[]{topic, selector, appName, noLocalMessages, new Integer(subMode), session, propertyContext});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MessageConsumerImpl", (Object)topic, (Object)selector, (Object)new Boolean(noLocalMessages), (Object)session);
        }
        this.jmsSession = session;
        this.noLocalMessages = noLocalMessages;
        this.topic = topic;
        ConnectionImpl c = null;
        if (session == null) {
            JMSException traceRet1 = new JMSException("No session");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", traceRet1, 1);
            }
            throw traceRet1;
        }
        c = session.getConnection();
        this.subInfo = new SubscriptionInfoImpl();
        this.subInfo.topic = topic.toString();
        this.subInfo.rawtopic = new TopicWrapper(topic);
        this.subInfo.selector = selector;
        this.subInfo.subMode = subMode;
        this.subInfo.reconnId = null;
        this.subInfo.tsi = this;
        this.subInfo.isJMSdurable = subMode == 4;
        this.subInfo.appName = appName;
        int mcast = 0;
        mcast = topic.getIntProperty("multicast");
        if (mcast == -1) {
            mcast = this.getSession().getConnection().getMulticast();
        }
        if ((mcast & 1) > 0) {
            this.subInfo.multicastEnabled = true;
        }
        if ((mcast & 4) > 0) {
            this.subInfo.multicastReliable = true;
        }
        this.appName = appName;
        try {
            this.subId = c.subscribeInternal(this.subInfo, false);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", e, 1);
            }
            if (e instanceof MinimalIOException) {
                int errorcode = ((MinimalIOException)e).getErrorCode();
                if (errorcode == -15) {
                    InvalidDestinationException traceRet2 = new InvalidDestinationException(e.toString());
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", (Throwable)traceRet2, 2);
                    }
                    throw traceRet2;
                }
                if (errorcode == -16) {
                    InvalidSelectorException traceRet3 = new InvalidSelectorException(e.toString());
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", (Throwable)traceRet3, 3);
                    }
                    throw traceRet3;
                }
                if (errorcode == -7 || errorcode == -18) {
                    JMSSecurityException traceRet4 = new JMSSecurityException(e.toString());
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", traceRet4, 4);
                    }
                    throw traceRet4;
                }
            }
            JMSException traceRet5 = new JMSException(e.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", traceRet5, 5);
            }
            throw traceRet5;
        }
        catch (ArithmeticException ae) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", ae, 2);
            }
            InvalidSelectorException traceRet6 = new InvalidSelectorException(ae.toString());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", (Throwable)traceRet6, 6);
            }
            throw traceRet6;
        }
        if (mcast != 0 && (mcast & 2) == 0 && !this.isSubscriptionReliableMulticast()) {
            JMSException traceRet7 = ConfigEnvironment.newException("MQJMS1102");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)", traceRet7, 7);
            }
            throw traceRet7;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MessageConsumerImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "<init>(WMQDestination,String,String,boolean,int,SessionImpl,JmsPropertyContext)");
        }
    }

    public String getMessageSelector() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getMessageSelector()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMessageSelector");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getMessageSelector()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMessageSelector", (Object)this.messageSelector);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getMessageSelector()", this.messageSelector);
        }
        return this.messageSelector;
    }

    public ProviderMessageListener getMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getMessageListener()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMessageListener");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getMessageListener()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMessageListener", (Object)this.listener);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getMessageListener()", this.listener);
        }
        return this.listener;
    }

    public synchronized void setMessageListener(ProviderMessageListener newListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setMessageListener(ProviderMessageListener)", new Object[]{newListener});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setMessageListener", (Object)newListener);
        }
        if (this.isClosed()) {
            String key = "MQJMS3038";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException traceRet1 = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setMessageListener(ProviderMessageListener)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.listener = newListener;
        if (this.sessionListener == null) {
            this.setActiveListener(newListener);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setMessageListener");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setMessageListener(ProviderMessageListener)");
        }
    }

    synchronized void setSessionMessageListener(ProviderMessageListener newListener) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setSessionMessageListener(ProviderMessageListener)", new Object[]{newListener});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setSessionMessageListener", (Object)newListener);
        }
        ProviderMessageListener oldListener = this.sessionListener;
        this.sessionListener = newListener;
        if (oldListener != newListener) {
            if (newListener != null) {
                this.setActiveListener(newListener);
            } else {
                this.setActiveListener(this.listener);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setSessionMessageListener");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setSessionMessageListener(ProviderMessageListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void setActiveListener(ProviderMessageListener newListener) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)", new Object[]{newListener});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setActiveListener", (Object)newListener);
        }
        SessionImpl sessionImpl = this.parentSession;
        // MONITORENTER : sessionImpl
        boolean currentlyStopped = this.parentSession.isStopped();
        if (!currentlyStopped) {
            this.parentSession.stop();
        }
        this.acquireWriteLock();
        try {
            ProviderMessageListener oldListener = this.activeListener;
            this.activeListener = newListener;
            if (newListener == null && oldListener == null) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"setActiveListener");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)", 1);
                }
                Object var6_5 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)");
                }
                this.releaseWriteLock();
                if (!currentlyStopped) {
                    this.parentSession.start();
                }
                // MONITOREXIT : sessionImpl
                return;
            }
            if (newListener != null && oldListener != null) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"setActiveListener");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)", 2);
                }
                Object var6_6 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)");
                }
                this.releaseWriteLock();
                if (!currentlyStopped) {
                    this.parentSession.start();
                }
                // MONITOREXIT : sessionImpl
                return;
            }
            if (newListener != null && oldListener == null) {
                this.receiveQueue.moveTo(this.sessionDispatchQueue);
            }
            if (newListener == null && oldListener != null) {
                this.sessionDispatchQueue.moveMessagesFor(this, this.receiveQueue);
            }
            Object var6_7 = null;
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)");
            }
            this.releaseWriteLock();
            if (!currentlyStopped) {
                this.parentSession.start();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)");
            }
            this.releaseWriteLock();
            if (currentlyStopped) throw throwable;
            this.parentSession.start();
            throw throwable;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setActiveListener");
        }
        if (!Trace.isOn) return;
        Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "setActiveListener(ProviderMessageListener)", 3);
    }

    protected void preReceive() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "preReceive()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "preReceive()");
        }
    }

    public ProviderMessage receive() throws JMSListenerSetException, IllegalStateException, JMSWrappedException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receive");
        }
        if (this.isClosed()) {
            String key = "MQJMS3038";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException traceRet1 = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.activeListener != null) {
            JMSListenerSetException traceRet2 = new JMSListenerSetException(ExceptionBuilder.buildReasonString((int)1839392006, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive()", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        try {
            MessageImpl message = this.receiveQueue.dequeue();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"receive", (Object)message);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive()", message);
            }
            return message;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive()", e);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(ExceptionBuilder.buildReasonString((int)1984288331, (Object[])new Object[]{e}), e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
    }

    public ProviderMessage receive(long timeOut) throws JMSException, IllegalStateException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", new Object[]{new Long(timeOut)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receive", (Object)new Long(timeOut));
        }
        if (this.isClosed()) {
            String key = "MQJMS3038";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException traceRet1 = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (timeOut == 0L) {
            ProviderMessage result = this.receive();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"receive", (Object)result);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", result, 1);
            }
            return result;
        }
        if (this.activeListener != null) {
            JMSListenerSetException traceRet2 = new JMSListenerSetException(ExceptionBuilder.buildReasonString((int)1839392006, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        try {
            MessageImpl message = this.receiveQueue.dequeueWait(timeOut);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"receive", (Object)message);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", message, 2);
            }
            return message;
        }
        catch (InterruptedException ie) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", ie);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(ExceptionBuilder.buildReasonString((int)1984288331, (Object[])new Object[]{ie}), ie);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receive(long)", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
    }

    public ProviderMessage receiveNoWait() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receiveNoWait()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"receiveNoWait");
        }
        if (this.isClosed()) {
            String key = "MQJMS3038";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException traceRet1 = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receiveNoWait()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.activeListener != null) {
            JMSListenerSetException traceRet2 = new JMSListenerSetException(ExceptionBuilder.buildReasonString((int)1839392006, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receiveNoWait()", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        MessageImpl message = this.receiveQueue.dequeueNoWait();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"receiveNoWait", (Object)message);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "receiveNoWait()", message);
        }
        return message;
    }

    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(boolean)", new Object[]{closingFromSession});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close");
        }
        this.close(null, true);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(boolean)");
        }
    }

    public void close(Exception e, boolean appClose) throws JMSException {
        block15: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(Exception,boolean)", new Object[]{e, appClose});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"close", (Object)e, (Object)new Boolean(appClose));
            }
            if (this.isClosed()) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"close");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(Exception,boolean)", 1);
                }
                return;
            }
            SessionImpl session = this.getSession();
            if (session == null) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(Exception,boolean)", 2);
                }
                return;
            }
            session.closed(this);
            ConnectionImpl c = session.getConnection();
            if (c.isActive()) {
                try {
                    if (this.subInfo.isJMSdurable) {
                        this.ackLatest(true);
                        c.deactivate(this.subInfo.reconnId);
                    } else {
                        c.unsubscribe(this.subInfo.subid);
                    }
                }
                catch (Exception ex) {
                    if (!Trace.isOn) break block15;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(Exception,boolean)", ex);
                }
            }
        }
        if (this.active) {
            this.active = false;
            this.receiveQueue.close(e, appClose);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "close(Exception,boolean)", 3);
        }
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "isActive()", "getter", this.active);
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "isClosed()", "getter", !this.active);
        }
        return !this.active;
    }

    public boolean getNoLocal() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getNoLocal");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getNoLocal", (Object)new Boolean(this.noLocalMessages));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getNoLocal()", "getter", this.noLocalMessages);
        }
        return this.noLocalMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newMessage(MessageImpl msg) {
        boolean persistent;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"newMessage", (Object)msg);
        }
        if (this.noLocalMessages && this.getSession().getConnection().isLocalMid(msg.getMessageID())) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl)", true, 1);
            }
            return true;
        }
        SubscriptionInfoImpl subInfo = (SubscriptionInfoImpl)msg.subInfo;
        if (msg.gapMsg || msg.silenceMsg) {
            Assert.condition((boolean)subInfo.isJMSdurable);
            persistent = true;
        } else {
            persistent = subInfo.subMode == 1 ? false : msg.getPersistent();
        }
        if (subInfo.subMode == 1) {
            boolean traceRet1 = this.newMessage(msg, true);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl)", traceRet1, 2);
            }
            return traceRet1;
        }
        if (subInfo.subMode == 4) {
            boolean deliver = true;
            if (persistent) {
                SubscriptionInfoImpl subscriptionInfoImpl = subInfo;
                synchronized (subscriptionInfoImpl) {
                    if (!msg.targetted) {
                        deliver = subInfo.greaterThanTmin(msg);
                    }
                    if (deliver) {
                        boolean advanced = subInfo.advanceDelivered(msg);
                        if (!advanced && !msg.gapMsg && !msg.silenceMsg && debug.debugIt(2)) {
                            debug.debug(2L, (Object)"delivered V msg did not advance Delivered");
                        }
                        subInfo.advanceTmin(msg);
                        msg.vc = subInfo.Delivered.clonep();
                    }
                }
                if (deliver) {
                    boolean traceRet2 = this.newMessage(msg, false);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl)", traceRet2, 3);
                    }
                    return traceRet2;
                }
            }
        } else {
            boolean deliver = true;
            SubscriptionInfoImpl traceRet2 = subInfo;
            synchronized (traceRet2) {
                if (persistent) {
                    deliver = subInfo.greaterThanTmin(msg);
                    if (deliver) {
                        subInfo.advanceTmin(msg);
                    }
                } else {
                    deliver = subInfo.subMode == 2;
                }
            }
            if (deliver) {
                boolean traceRet3 = this.newMessage(msg, !persistent);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl)", traceRet3, 4);
                }
                return traceRet3;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"newMessage");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl)", true, 5);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean newMessage(MessageImpl msg, boolean disposable) {
        boolean rslt;
        block13: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl,boolean)", new Object[]{msg, disposable});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"newMessage", (Object)msg);
            }
            if (msg.getConsumer() != null) {
                msg = msg.duplicate();
            }
            msg.setConsumer(this);
            msg.setDisposable(disposable);
            msg.setSession(this.parentSession);
            this.acquireReadLock();
            try {
                try {
                    rslt = this.activeListener != null ? this.sessionDispatchQueue.enqueue(msg) : this.receiveQueue.enqueue(msg);
                    if (!rslt) {
                        this.active = false;
                    }
                }
                catch (RuntimeException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl,boolean)", e);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl,boolean)", e);
                    }
                    throw e;
                }
                Object var6_4 = null;
                if (!Trace.isOn) break block13;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl,boolean)");
                }
                this.releaseReadLock();
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl,boolean)");
        }
        this.releaseReadLock();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"newMessage", (Object)new Boolean(rslt));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "newMessage(MessageImpl,boolean)", rslt);
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatch(MessageImpl message) {
        block7: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "dispatch(MessageImpl)", new Object[]{message});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"dispatch", (Object)message);
            }
            this.acquireUpReadLock();
            try {
                this.activeListener.onMessage(message);
                Object var3_2 = null;
                if (!Trace.isOn) break block7;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "dispatch(MessageImpl)");
                }
                this.releaseUpReadLock();
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "dispatch(MessageImpl)");
        }
        this.releaseUpReadLock();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"dispatch");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "dispatch(MessageImpl)");
        }
    }

    SessionImpl getSession() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getSession()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getSession");
        }
        SessionImpl result = null;
        if (this.active) {
            result = this.parentSession;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getSession", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getSession()", result);
        }
        return result;
    }

    MessageQueue getReceiveQueue() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getReceiveQueue");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getReceiveQueue", (Object)this.receiveQueue);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "getReceiveQueue()", "getter", this.receiveQueue);
        }
        return this.receiveQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireWriteLock() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireWriteLock()");
        }
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"acquireWriteLock");
            }
            Thread currThread = Thread.currentThread();
            while (this.readers > 0 || this.upreaders > 0 && currThread != this.readThread) {
                try {
                    this.readLockLock.wait(10000L);
                }
                catch (InterruptedException e) {
                    if (!Trace.isOn) continue;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireWriteLock()", e);
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"acquireWriteLock");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireWriteLock()");
        }
    }

    void releaseWriteLock() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "releaseWriteLock()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"releaseWriteLock");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"releaseWriteLock");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "releaseWriteLock()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireReadLock() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireReadLock()");
        }
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"acquireReadLock");
            }
            ++this.readers;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"acquireReadLock");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireReadLock()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReadLock() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "releaseReadLock()");
        }
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"releaseReadLock");
            }
            --this.readers;
            this.readLockLock.notifyAll();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"releaseReadLock");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "releaseReadLock()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireUpReadLock() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireUpReadLock()");
        }
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"acquireUpReadLock");
            }
            ++this.upreaders;
            this.readThread = Thread.currentThread();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"acquireUpReadLock");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "acquireUpReadLock()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseUpReadLock() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "releaseUpReadLock()");
        }
        Object object = this.readLockLock;
        synchronized (object) {
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"releaseUpReadLock");
            }
            --this.upreaders;
            if (this.upreaders == 0) {
                this.readThread = null;
            }
            this.readLockLock.notifyAll();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"releaseUpReadLock");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "releaseUpReadLock()");
        }
    }

    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "stop()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        this.receiveQueue.stop();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "stop()");
        }
    }

    void start() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "start()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        this.receiveQueue.start();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "start()");
        }
    }

    public boolean isSubscriptionMulticast() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "isSubscriptionMulticast()", "getter", this.subInfo.multicastEnabled);
        }
        return this.subInfo.multicastEnabled;
    }

    public boolean isSubscriptionReliableMulticast() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "isSubscriptionReliableMulticast()", "getter", this.subInfo.multicastReliable);
        }
        return this.subInfo.multicastReliable;
    }

    protected void ackLatest(boolean forceAckAck) throws JMSWrappedException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "ackLatest(boolean)", new Object[]{forceAckAck});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"ackLatest", (Object)new Boolean(forceAckAck));
        }
        try {
            if (!this.subInfo.isJMSdurable) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "ackLatest(boolean)", 1);
                }
                return;
            }
            MessageImpl msg = (MessageImpl)this.subInfo.latest;
            if (this.parentSession.getAcknowledgeMode() == 1) {
                if (msg != null) {
                    this.parentSession.getConnection().release(this.subInfo.reconnId, msg.vc, true);
                    this.subInfo.acked = true;
                }
            } else if (this.parentSession.getAcknowledgeMode() == 3 && msg != null) {
                this.parentSession.getConnection().release(this.subInfo.reconnId, msg.vc, forceAckAck);
            }
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "ackLatest(boolean)", e);
            }
            JMSWrappedException traceRet1 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "ackLatest(boolean)", (Throwable)((Object)traceRet1));
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ackLatest");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "ackLatest(boolean)", 2);
        }
    }

    public void start(boolean deliverImmediately) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "start(boolean)", new Object[]{deliverImmediately});
        }
        this.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "start(boolean)");
        }
    }

    public void handlePoisonMessage(ProviderMessage message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "handlePoisonMessage(ProviderMessage)", new Object[]{message});
        }
        HashMap<String, ProviderMessage> data = new HashMap<String, ProviderMessage>();
        data.put("message", message);
        Trace.ffst(this, "handlePoisonMessage", "XO00C001", data, JMSException.class);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "handlePoisonMessage(ProviderMessage)");
        }
    }

    public boolean shouldMessageBeRequeued(int attempts, ProviderMessage message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "shouldMessageBeRequeued(int,ProviderMessage)", new Object[]{new Integer(attempts), message});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "shouldMessageBeRequeued(int,ProviderMessage)", false);
        }
        return false;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MessageConsumerImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.18.1.1 09/08/17 08:45:06");
        }
        debug = new DebugObject("MessageConsumerImpl");
    }

    public class TopicWrapper
    implements Topic {
        private WMQDestination topic = null;

        public TopicWrapper(WMQDestination topic) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicWrapper", "<init>(WMQDestination)", new Object[]{topic});
            }
            this.topic = topic;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicWrapper", "<init>(WMQDestination)");
            }
        }

        public boolean isTemporary() {
            boolean traceRet1 = this.topic.isTemporary();
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicWrapper", "isTemporary()", "getter", traceRet1);
            }
            return traceRet1;
        }

        public String toStringInternal() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicWrapper", "toStringInternal()");
            }
            String traceRet1 = this.topic.getName();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.TopicWrapper", "toStringInternal()", traceRet1);
            }
            return traceRet1;
        }
    }
}

