/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MapMessageImpl
extends MessageImpl
implements ProviderMapMessage,
ClientLogConstants,
ClientExceptionConstants {
    private static final long serialVersionUID = -916298549716198003L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MapMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.8.1.1 09/08/17 08:44:42";
    private static final DebugObject debug;
    protected boolean mapNameStyle = true;
    Dictionary fields;

    public MapMessageImpl(MessageHandle cursor, ConnectionImpl conn) {
        super(cursor, conn);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "<init>(MessageHandle,ConnectionImpl)", new Object[]{cursor, conn});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MapMessageImpl", (Object)cursor);
        }
        this.messageClass = "jms_map";
        this.fields = this.getNamedFields();
        this.readOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MapMessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "<init>(MessageHandle,ConnectionImpl)");
        }
    }

    public MapMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "<init>()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"MapMessageImpl");
        }
        this.messageClass = "jms_map";
        this.fields = new Hashtable();
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"MapMessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "<init>()");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getBoolean(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBoolean", (Object)name);
        }
        Object v = this.fields.get(name);
        Boolean ans = null;
        if (v == null) {
            ans = new Boolean(false);
        } else if (v instanceof Boolean) {
            ans = (Boolean)v;
        } else if (v instanceof String) {
            ans = Boolean.valueOf((String)v);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet1 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getBoolean(String)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBoolean", (Object)ans);
        }
        boolean traceRet2 = ans;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getBoolean(String)", traceRet2);
        }
        return traceRet2;
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(String name) throws JMSException {
        void var3_4;
        byte ans;
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getByte(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getByte", (Object)name);
        }
        if ((v = this.fields.get(name)) == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getByte(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (v instanceof Byte) {
            ans = (Byte)v;
        } else if (v instanceof String) {
            ans = Byte.parseByte((String)v);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getByte(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getByte", (Object)new Byte((byte)var3_4));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getByte(String)", new Byte((byte)var3_4));
        }
        return (byte)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public short getShort(String name) throws JMSException {
        void var3_4;
        short ans;
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getShort(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getShort", (Object)name);
        }
        if ((v = this.fields.get(name)) == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getShort(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (v instanceof Short || v instanceof Byte) {
            ans = ((Number)v).shortValue();
        } else if (v instanceof String) {
            ans = Short.parseShort((String)v);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getShort(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getShort", (Object)new Short((short)var3_4));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getShort(String)", new Short((short)var3_4));
        }
        return (short)var3_4;
    }

    public char getChar(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getChar(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getChar", (Object)name);
        }
        Object v = this.fields.get(name);
        char result = '\u0000';
        if (v == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getChar(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!(v instanceof Character)) {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getChar(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        result = ((Character)v).charValue();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getChar", (Object)new Character(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getChar(String)", new Character(result));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(String name) throws JMSException {
        void var3_4;
        int ans;
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getInt(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getInt", (Object)name);
        }
        if ((v = this.fields.get(name)) == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getInt(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (v instanceof Integer || v instanceof Short || v instanceof Byte) {
            ans = ((Number)v).intValue();
        } else if (v instanceof String) {
            ans = Integer.parseInt((String)v);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getInt(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getInt", (Object)new Integer((int)var3_4));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getInt(String)", new Integer((int)var3_4));
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(String name) throws JMSException {
        void var3_4;
        long ans;
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getLong(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getLong", (Object)name);
        }
        if ((v = this.fields.get(name)) == null) {
            NumberFormatException traceRet1 = new NumberFormatException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getLong(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (v instanceof Long || v instanceof Integer || v instanceof Short || v instanceof Byte) {
            ans = ((Number)v).longValue();
        } else if (v instanceof String) {
            ans = Long.parseLong((String)v);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getLong(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getLong", (Object)new Long((long)var3_4));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getLong(String)", new Long((long)var3_4));
        }
        return (long)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(String name) throws JMSException {
        void var3_4;
        Float ans;
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getFloat(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getFloat", (Object)name);
        }
        if ((v = this.fields.get(name)) == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getFloat(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (v instanceof Float) {
            ans = (Float)v;
        } else if (v instanceof String) {
            ans = Float.valueOf((String)v);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getFloat(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getFloat", (Object)var3_4);
        }
        float traceRet3 = var3_4.floatValue();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getFloat(String)", new Float(traceRet3));
        }
        return traceRet3;
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(String name) throws JMSException {
        void var3_4;
        Double ans;
        Object v;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getDouble(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getDouble", (Object)name);
        }
        if ((v = this.fields.get(name)) == null) {
            NullPointerException traceRet1 = new NullPointerException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getDouble(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (v instanceof Double) {
            ans = (Double)v;
        } else if (v instanceof String) {
            ans = Double.valueOf((String)v);
        } else if (v instanceof Float) {
            ans = new Double(((Float)v).doubleValue());
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getDouble(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getDouble", (Object)var3_4);
        }
        double traceRet3 = var3_4.doubleValue();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getDouble(String)", new Double(traceRet3));
        }
        return traceRet3;
    }

    public String getString(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getString(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getString", (Object)name);
        }
        Object v = this.fields.get(name);
        String result = null;
        if (v != null) {
            if (v instanceof byte[]) {
                String key = "MQJMS0006";
                String msg = ConfigEnvironment.getErrorMessage(key);
                MessageFormatException traceRet1 = new MessageFormatException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getString(String)", (Throwable)traceRet1);
                }
                throw traceRet1;
            }
            result = v.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getString", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getString(String)", result);
        }
        return result;
    }

    public byte[] getBytes(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getBytes(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getBytes", (Object)name);
        }
        Object v = this.fields.get(name);
        byte[] result = null;
        if (v != null) {
            if (v instanceof byte[]) {
                result = (byte[])v;
            } else {
                String key = "MQJMS0006";
                String msg = ConfigEnvironment.getErrorMessage(key);
                MessageFormatException traceRet1 = new MessageFormatException(msg, key);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getBytes(String)", (Throwable)traceRet1);
                }
                throw traceRet1;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getBytes", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getBytes(String)", result);
        }
        return result;
    }

    public Object getObject(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getObject(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getObject", (Object)name);
        }
        Object result = this.fields.get(name);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getObject", result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getObject(String)", result);
        }
        return result;
    }

    public Enumeration getMapNames() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getMapNames");
        }
        Enumeration result = this.fields.keys();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getMapNames", result);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "getMapNames()", "getter", result);
        }
        return result;
    }

    public void setBoolean(String name, boolean value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBoolean(String,boolean)", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBoolean", (Object)name, (Object)new Boolean(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBoolean(String,boolean)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBoolean(String,boolean)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBoolean(String,boolean)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Boolean(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBoolean");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBoolean(String,boolean)");
        }
    }

    public void setByte(String name, byte value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setByte(String,byte)", new Object[]{name, new Byte(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setByte", (Object)name, (Object)new Byte(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setByte(String,byte)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setByte(String,byte)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setByte(String,byte)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Byte(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setByte");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setByte(String,byte)");
        }
    }

    public void setShort(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setShort(String,short)", new Object[]{name, new Short(value)});
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setString");
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setShort(String,short)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setShort(String,short)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setShort(String,short)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Short(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setShort");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setShort(String,short)");
        }
    }

    public void setChar(String name, char value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setChar(String,char)", new Object[]{name, new Character(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setChar", (Object)name, (Object)new Character(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setChar(String,char)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setChar(String,char)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setChar(String,char)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Character(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setChar");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setChar(String,char)");
        }
    }

    public void setInt(String name, int value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setInt(String,int)", new Object[]{name, new Integer(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setInt", (Object)name, (Object)new Integer(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setInt(String,int)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setInt(String,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setInt(String,int)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Integer(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setInt");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setInt(String,int)");
        }
    }

    public void setLong(String name, long value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setLong(String,long)", new Object[]{name, new Long(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setLong", (Object)name, (Object)new Long(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setLong(String,long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setLong(String,long)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setLong(String,long)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Long(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setLong");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setLong(String,long)");
        }
    }

    public void setFloat(String name, float value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setFloat(String,float)", new Object[]{name, new Float(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setFloat", (Object)name, (Object)new Float(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setFloat(String,float)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setFloat(String,float)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setFloat(String,float)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Float(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setFloat");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setFloat(String,float)");
        }
    }

    public void setDouble(String name, double value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setDouble(String,double)", new Object[]{name, new Double(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setDouble", (Object)name, (Object)new Double(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setDouble(String,double)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setDouble(String,double)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setDouble(String,double)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.fields.put(name, new Double(value));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setDouble");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setDouble(String,double)");
        }
    }

    public void setString(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setString(String,String)", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setString", (Object)name, (Object)value);
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setString(String,String)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setString(String,String)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setString(String,String)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (value == null) {
            this.fields.put(name, NULL);
        } else {
            this.fields.put(name, value);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setString");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setString(String,String)");
        }
    }

    public void setBytes(String name, byte[] value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ])", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBytes", (Object)name, (Object)value);
        }
        if (value == null) {
            this.setObject(name, value);
        } else if (value.length == 0) {
            this.setObject(name, value);
        } else {
            this.setBytes(name, value, 0, value.length);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBytes");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ])");
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ],int,int)", new Object[]{name, value, new Integer(offset), new Integer(length)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setBytes", (Object)name, (Object)value, (Object)new Integer(offset), (Object)new Integer(length));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ],int,int)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ],int,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ],int,int)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (length == 0) {
            this.fields.put(name, new byte[0]);
        } else {
            byte[] val = new byte[length];
            System.arraycopy(value, offset, val, 0, length);
            this.fields.put(name, val);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setBytes");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setBytes(String,byte [ ],int,int)");
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setObject(String,Object)", new Object[]{name, value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setObject", (Object)name, value);
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setObject(String,Object)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (name == null || name.trim().length() == 0) {
            String key = "MQJMS1058";
            String msg = ConfigEnvironment.getErrorMessage(key, name);
            IllegalArgumentException traceRet2 = new IllegalArgumentException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setObject(String,Object)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!this.mapNameStyle && !this.isSettableMapName(name)) {
            MessageFormatException traceRet3 = new MessageFormatException("MQJMS1066", name);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setObject(String,Object)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (value == null) {
            this.fields.put(name, NULL);
        } else if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof byte[]) {
            this.fields.put(name, value);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet4 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setObject(String,Object)", (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setObject");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "setObject(String,Object)");
        }
    }

    public boolean itemExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "itemExists(String)", new Object[]{name});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"itemExists", (Object)name);
        }
        boolean result = ((Hashtable)this.fields).containsKey(name);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"itemExists", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "itemExists(String)", result);
        }
        return result;
    }

    public void clearBody() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "clearBody()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.readOnly = false;
        this.fields = new Hashtable();
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "clearBody()");
        }
    }

    private boolean isSettableMapName(String elementName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "isSettableMapName(String)", new Object[]{elementName});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isSettableMapName");
        }
        boolean reply = true;
        for (int i = 0; i < elementName.length(); ++i) {
            char ch = elementName.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch)) continue;
                reply = false;
                break;
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            reply = false;
            break;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isSettableMapName");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "isSettableMapName(String)", reply);
        }
        return reply;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.MapMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/MapMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.8.1.1 09/08/17 08:44:42");
        }
        debug = new DebugObject("MapMessageImpl");
    }
}

