/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.mq.MQException;
import com.ibm.mq.jms.ISSLException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ISSL;
import com.ibm.msg.client.wmq.v6.direct.internal.ISSLSession;
import com.ibm.msg.client.wmq.v6.network.SSLHelper;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class JsseImpl
implements ISSL {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/JsseImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.10.1.1 09/08/17 08:44:31";
    protected String[] cipherSuites = null;

    public JsseImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "<init>()");
        }
    }

    public Object createCredentials(Object args) throws ISSLException {
        Object sslsf;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createCredentials(Object)", new Object[]{args});
        }
        if ((sslsf = BaseConfig.getBaseConfig().SSL_SOCKET_FACTORY) == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "createCredentials returning default SSLSocketFactory", null);
            }
            SocketFactory traceRet1 = SSLSocketFactory.getDefault();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createCredentials(Object)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (!(sslsf instanceof SSLSocketFactory)) {
            if (Trace.isOn) {
                Trace.traceData(this, "createCredentials identified invalid SSLSocketFactory object", null);
            }
            ISSLException traceRet2 = new ISSLException(ConfigEnvironment.getMessage("MQJMS4131"));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createCredentials(Object)", traceRet2);
            }
            throw traceRet2;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "createCredentials returning user-specified SSLSocketFactory", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createCredentials(Object)", sslsf, 2);
        }
        return sslsf;
    }

    public ISSLSession createSession(Socket underly, Object creds, boolean asServer, boolean clientAuth) throws ISSLException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createSession(Socket,Object,boolean,boolean)", new Object[]{underly, creds, asServer, clientAuth});
        }
        if (!(creds instanceof SSLSocketFactory)) {
            if (Trace.isOn) {
                Trace.traceData(this, "createSession identified invalid SSLSocketFactory object", null);
            }
            ISSLException traceRet1 = new ISSLException(ConfigEnvironment.getMessage("MQJMS4131"));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createSession(Socket,Object,boolean,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "Running SSL handshake over existing socket", null);
            }
            SSLSocket secure = SSLHelper.createSSLSocket("alreadydecided", 443, this.cipherSuites[0], BaseConfig.getBaseConfig().SSL_PEER_NAME, BaseConfig.getBaseConfig().SSL_CERT_STORES, creds, underly, clientAuth, asServer);
            if (Trace.isOn) {
                Trace.traceData(this, "Post-configuring socket", null);
            }
            JsseImplSession traceRet2 = new JsseImplSession(secure);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createSession(Socket,Object,boolean,boolean)", traceRet2);
            }
            return traceRet2;
        }
        catch (MQException me) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createSession(Socket,Object,boolean,boolean)", me);
            }
            ISSLException traceRet3 = new ISSLException(me.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "createSession(Socket,Object,boolean,boolean)", traceRet3, 2);
            }
            throw traceRet3;
        }
    }

    public String[] getEnabledCipherSuites() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "getEnabledCipherSuites()", "getter", this.cipherSuites);
        }
        return this.cipherSuites;
    }

    public void setEnabledCipherSuites(String names) throws ISSLException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "setEnabledCipherSuites(String)", new Object[]{names});
        }
        if (Trace.isOn) {
            Trace.traceData(this, "Setting ciphersuites to '" + names + "' Only first one used", null);
        }
        if (names != null && !names.equals("")) {
            StringTokenizer parseIt = new StringTokenizer(names);
            Vector<String> holder = new Vector<String>();
            while (parseIt.hasMoreTokens()) {
                String next = parseIt.nextToken();
                if (next.equals("")) continue;
                holder.add(next);
            }
            this.cipherSuites = new String[holder.size()];
            holder.copyInto(this.cipherSuites);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "setEnabledCipherSuites(String)");
        }
    }

    public void setProperty(String property, String value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "setProperty(String,String)", new Object[]{property, value});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "setProperty(String,String)");
        }
    }

    public String getProperty(String property) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "getProperty(String)", new Object[]{property});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "getProperty(String)", null);
        }
        return null;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.JsseImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/JsseImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.10.1.1 09/08/17 08:44:31");
        }
    }

    class JsseImplSession
    implements ISSLSession {
        SSLSocket sessSock;

        public JsseImplSession(SSLSocket s) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "<init>(SSLSocket)", new Object[]{s});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "<init>(SSLSocket)");
            }
        }

        public Socket getSocket() {
            SSLSocket traceRet1 = this.sessSock;
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "getSocket()", "getter", traceRet1);
            }
            return traceRet1;
        }

        public byte[] getMasterSecret() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "getMasterSecret()", "getter", null);
            }
            return null;
        }

        public String extractUserID() {
            block8: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "extractUserID()");
                }
                try {
                    X509Certificate[] certs = this.sessSock.getSession().getPeerCertificateChain();
                    if (Trace.isOn) {
                        Trace.traceData(this, "Cert string: " + ((Object)certs[0].getSubjectDN()).toString(), null);
                    }
                    StringTokenizer dnList = new StringTokenizer(((Object)certs[0].getSubjectDN()).toString(), ",");
                    while (dnList.hasMoreTokens()) {
                        StringTokenizer nextToken = new StringTokenizer(dnList.nextToken(), "=");
                        String key = nextToken.nextToken();
                        if (!key.equals("EmailAddress")) continue;
                        String result = nextToken.nextToken();
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "extractUserID()", result, 1);
                        }
                        return result;
                    }
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "extractUserID()", e);
                    }
                    if (!Trace.isOn) break block8;
                    Trace.traceData(this, "Something went wrong parsing certificate", null);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.JsseImplSession", "extractUserID()", "", 2);
            }
            return "";
        }
    }
}

