/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.formats.Framing;
import com.ibm.disthub2.impl.formats.MessageEncrypter;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.formats.SchemaRegistry;
import com.ibm.disthub2.impl.multicast.ControlChannelListener;
import com.ibm.disthub2.impl.multicast.MulticastTopic;
import com.ibm.disthub2.impl.multicast.PeerId;
import com.ibm.disthub2.impl.multicast.client.ClientBridge;
import com.ibm.disthub2.impl.multicast.client.MulticastException;
import com.ibm.disthub2.impl.multicast.client.MulticastHeartbeatTimeoutException;
import com.ibm.disthub2.impl.multicast.client.MulticastMessageReceiver;
import com.ibm.disthub2.impl.multicast.client.MulticastPacketLossException;
import com.ibm.disthub2.impl.security.IntegrityCompromisedException;
import com.ibm.disthub2.impl.security.MessageProtection;
import com.ibm.disthub2.impl.security.Qop;
import com.ibm.disthub2.impl.security.SecurityContext;
import com.ibm.disthub2.impl.util.FastHashtable;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.disthub2.impl.util.FeatureSet;
import com.ibm.disthub2.impl.util.Hex;
import com.ibm.disthub2.impl.util.TopicHandler;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SubscriptionInfoImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class ConnectionMulticastSupport
implements MulticastMessageReceiver,
ClientLogConstants,
ClientExceptionConstants {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final DebugObject debug;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/ConnectionMulticastSupport.java, jmscc.wmq.v6, k701, k701-112-140304 1.10.1.1 09/08/17 08:42:31";
    private ClientBridge bridge;
    private InetAddress brokerMulticastInterface;
    private ConnectionImpl connection;
    private FastHashtable multicastTopics;
    private FastHashtable partitionTopics;
    private PeerId peerId = null;
    private FastHashtable topicToSusbcriptions;

    public ConnectionMulticastSupport(ConnectionImpl connection) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "<init>(ConnectionImpl)", new Object[]{connection});
        }
        this.connection = connection;
        this.multicastTopics = new FastHashtable();
        this.topicToSusbcriptions = new FastHashtable();
        this.partitionTopics = new FastHashtable();
        this.setClientConfigParameters(connection.getFeatureSet());
        this.bridge = ClientBridge.getInstance((Properties)connection.getSessionConfig().getMulticastProperties());
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "<init>(ConnectionImpl)");
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "close()");
        }
        this.bridge.shutdown();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "close()");
        }
    }

    public void deregisterAllTopics(SubscriptionInfoImpl subInfo) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "deregisterAllTopics(SubscriptionInfoImpl)", new Object[]{subInfo});
        }
        if (subInfo.multicastTopics != null) {
            Enumeration enumVar = subInfo.multicastTopics.elements();
            while (enumVar.hasMoreElements()) {
                MulticastTopic topic = (MulticastTopic)enumVar.nextElement();
                this.deregisterTopic(subInfo, topic);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "deregisterAllTopics(SubscriptionInfoImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTopic(SubscriptionInfoImpl subInfo, MulticastTopic topic) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "deregisterTopic(SubscriptionInfoImpl,MulticastTopic)", new Object[]{subInfo, topic});
        }
        if (topic.enabled) {
            this.bridge.deregisterTopic((MulticastMessageReceiver)this, this.brokerMulticastInterface, topic);
        }
        int usage = 0;
        if (this.topicToSusbcriptions.containsKey((Object)topic.topic)) {
            FastVector subMatches;
            FastVector fastVector = subMatches = (FastVector)this.topicToSusbcriptions.get((Object)topic.topic);
            synchronized (fastVector) {
                if (subMatches.indexOf((Object)subInfo) > -1) {
                    subMatches.removeElementAt(subMatches.indexOf((Object)subInfo));
                }
                usage = subMatches.size();
            }
        }
        if (usage == 0) {
            if (topic.partitionLabel != null && this.partitionTopics.containsKey((Object)topic.partitionLabel)) {
                FastHashtable partitionTopicTable = (FastHashtable)this.partitionTopics.get((Object)topic.partitionLabel);
                partitionTopicTable.remove((Object)topic.topic);
            }
            if (this.multicastTopics.containsKey((Object)topic.topic)) {
                this.multicastTopics.remove((Object)topic.topic);
            }
        }
        subInfo.deleteMulticastTopic(topic);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "deregisterTopic(SubscriptionInfoImpl,MulticastTopic)");
        }
    }

    public PeerId getAddress() {
        if (this.peerId == null) {
            this.peerId = new PeerId(this.connection.getAddress(), this.connection.getPort());
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "getAddress()", "getter", this.peerId);
        }
        return this.peerId;
    }

    public MessageEncrypter incoming(byte[] msg, MulticastTopic multicastTopic) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "incoming(byte [ ],MulticastTopic)", new Object[]{msg, multicastTopic});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"incoming", (Object)msg, (Object)multicastTopic);
        }
        MessageProtection result = null;
        if (multicastTopic.securityContext == null && multicastTopic.rekey) {
            multicastTopic.setSecurity(multicastTopic.getKey(), false);
        }
        if (multicastTopic.securityContext != null) {
            try {
                Qop.checkIntegrity((byte[])msg, (SecurityContext)multicastTopic.securityContext, (boolean)false, (boolean)true);
            }
            catch (IntegrityCompromisedException exception) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "incoming(byte [ ],MulticastTopic)", exception);
                }
                if (multicastTopic.newKey != 0L || multicastTopic.newCounter) {
                    if (multicastTopic.newKey != 0L && !multicastTopic.setNewKey()) {
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "incoming(byte [ ],MulticastTopic)", exception, 1);
                        }
                        throw exception;
                    }
                    multicastTopic.newCounter = false;
                    Qop.checkIntegrity((byte[])msg, (SecurityContext)multicastTopic.securityContext, (boolean)false, (boolean)true);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "incoming(byte [ ],MulticastTopic)", exception, 2);
                }
                throw exception;
            }
            multicastTopic.securityContext.newMessage();
            if (Framing.qop((byte[])msg) == 14) {
                MessageProtection mp = multicastTopic.securityContext.getMP();
                Qop.sessionDecrypt((byte[])msg, (MessageProtection)mp, (Object)multicastTopic.securityContext.getServerKey(), (byte[])multicastTopic.securityContext.getDecryptIV());
                result = mp;
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"incoming", (Object)Hex.toString((byte[])msg));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"incoming", result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "incoming(byte [ ],MulticastTopic)", result);
        }
        return result;
    }

    public boolean isOpen() {
        boolean traceRet1 = this.connection.isActive();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "isOpen()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void onControlMessage(byte[] message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onControlMessage(byte [ ])", new Object[]{message});
        }
        this.connection.sendMulticastControlMsg(message);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onControlMessage(byte [ ])");
        }
    }

    public void onException(MulticastException dhmex) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onException(MulticastException)", new Object[]{dhmex});
        }
        if (dhmex instanceof MulticastPacketLossException) {
            this.connection.onException((Exception)((Object)new com.ibm.mq.jms.MulticastPacketLossException(ConfigEnvironment.getErrorMessage("MQJMS1103", new Integer(((MulticastPacketLossException)dhmex).getNumberOfPackets())))));
        } else if (dhmex instanceof MulticastHeartbeatTimeoutException) {
            this.connection.onException((Exception)((Object)new com.ibm.mq.jms.MulticastHeartbeatTimeoutException(ConfigEnvironment.getErrorMessage("MQJMS1104"))));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onException(MulticastException)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String topic, byte[] newData) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onMessage(String,byte [ ])", new Object[]{topic, newData});
        }
        String newTopic = null;
        if (this.connection.ipv6Connection() && topic.length() > 6 && topic.substring(0, 6).equals("IPv6//")) {
            try {
                topic = newTopic = topic.substring(6, topic.length());
            }
            catch (Exception ee) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onMessage(String,byte [ ])", ee, 1);
                }
                this.connection.setException(ee);
            }
        }
        if (this.multicastTopics.containsKey((Object)topic)) {
            MulticastTopic multicastTopic;
            MulticastTopic multicastTopic2 = multicastTopic = (MulticastTopic)this.multicastTopics.get((Object)topic);
            synchronized (multicastTopic2) {
                try {
                    MessageHandle msg = null;
                    byte[] data = new byte[newData.length];
                    System.arraycopy(newData, 0, data, 0, newData.length);
                    MessageEncrypter mp = this.incoming(data, multicastTopic);
                    msg = SchemaRegistry.getMessageHandle((byte[])data, (MessageEncrypter)mp);
                    if (BaseConfig.getBaseConfig().ENABLE_QOP_SECURITY && multicastTopic.qop > Framing.qop((byte[])data)) {
                        Byte onMsg = new Byte(Framing.qop((byte[])data));
                        Byte req = new Byte(multicastTopic.qop);
                        Integer type = new Integer(1);
                        IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)1481488182, (Object[])new Object[]{onMsg, req, type}));
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onMessage(String,byte [ ])", traceRet1);
                        }
                        throw traceRet1;
                    }
                    if (this.topicToSusbcriptions.containsKey((Object)topic)) {
                        FastVector subMatches = (FastVector)this.topicToSusbcriptions.get((Object)topic);
                        this.connection.newMulticastMessage(subMatches, msg);
                    }
                }
                catch (IOException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onMessage(String,byte [ ])", e, 2);
                    }
                    this.connection.setException(e);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "onMessage(String,byte [ ])");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTopic(SubscriptionInfoImpl subInfo, MulticastTopic topic) {
        FastVector partitionTopicTable;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "registerTopic(SubscriptionInfoImpl,MulticastTopic)", new Object[]{subInfo, topic});
        }
        FastVector subMatches = null;
        if (this.topicToSusbcriptions.containsKey((Object)topic.topic)) {
            subMatches = (FastVector)this.topicToSusbcriptions.get((Object)topic.topic);
        } else {
            subMatches = new FastVector();
            this.topicToSusbcriptions.put((Object)topic.topic, (Object)subMatches);
        }
        if (topic.partitionLabel != null) {
            if (topic.getKey() != null) {
                topic.rekey = true;
            }
            if (this.partitionTopics.containsKey((Object)topic.partitionLabel)) {
                partitionTopicTable = (FastHashtable)this.partitionTopics.get((Object)topic.partitionLabel);
            } else {
                partitionTopicTable = new FastHashtable();
                this.partitionTopics.put((Object)topic.partitionLabel, (Object)partitionTopicTable);
            }
            partitionTopicTable.put((Object)topic.topic, (Object)topic);
        }
        if (subMatches.indexOf((Object)subInfo) < 0) {
            partitionTopicTable = subMatches;
            synchronized (partitionTopicTable) {
                subMatches.addElement((Object)subInfo);
            }
        }
        if (!this.multicastTopics.containsKey((Object)topic.topic)) {
            this.multicastTopics.put((Object)topic.topic, (Object)topic);
        } else if (topic.enabled) {
            MulticastTopic oldTopic = (MulticastTopic)this.multicastTopics.get((Object)topic.topic);
            if (!oldTopic.enabled) {
                this.multicastTopics.put((Object)topic.topic, (Object)topic);
            }
        }
        if (topic.enabled) {
            this.bridge.registerTopic(topic, this.brokerMulticastInterface, (MulticastMessageReceiver)this, this.connection.ipv6Connection());
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "registerTopic(SubscriptionInfoImpl,MulticastTopic)");
        }
    }

    public void registerTopics(SubscriptionInfoImpl subInfo) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "registerTopics(SubscriptionInfoImpl)", new Object[]{subInfo});
        }
        if (subInfo.multicastTopics != null) {
            Enumeration enumVar = subInfo.multicastTopics.elements();
            while (enumVar.hasMoreElements()) {
                MulticastTopic topic = (MulticastTopic)enumVar.nextElement();
                this.registerTopic(subInfo, topic);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "registerTopics(SubscriptionInfoImpl)");
        }
    }

    public void sendControlMessage(byte[] message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "sendControlMessage(byte [ ])", new Object[]{message});
        }
        this.bridge.onControlMessage(message, (ControlChannelListener)this);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "sendControlMessage(byte [ ])");
        }
    }

    public void setAddress(PeerId peerId) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setAddress(PeerId)", "setter", peerId);
        }
        this.peerId = peerId;
    }

    public void setClientConfigParameters(FeatureSet multicastFeature) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setClientConfigParameters(FeatureSet)", new Object[]{multicastFeature});
        }
        String methodName = "setClientConfigParameters";
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setClientConfigParameters");
        }
        if (this.bridge == null) {
            String s = multicastFeature.get("MULTICAST", "MULTICAST_DATA_PORT");
            if (s != null) {
                SessionConfig.MULTICAST_DATA_PORT = Integer.parseInt(s);
            }
            if ((s = multicastFeature.get("MULTICAST", "MULTICAST_BACKOFF_TIME_MILLIS")) != null) {
                SessionConfig.MULTICAST_BACKOFF_TIME_MILLIS = Integer.parseInt(s);
            }
            if ((s = multicastFeature.get("MULTICAST", "MULTICAST_NACK_CHECK_PERIOD_MILLIS")) != null) {
                SessionConfig.MULTICAST_NACK_CHECK_PERIOD_MILLIS = Integer.parseInt(s);
            }
            if ((s = multicastFeature.get("MULTICAST", "MULTICAST_PACKET_BUFFERS")) != null) {
                SessionConfig.MULTICAST_PACKET_BUFFERS = Integer.parseInt(s);
            }
            if ((s = multicastFeature.get("MULTICAST", "MULTICAST_SOCKET_BUFFER_SIZE_KBYTE")) != null) {
                SessionConfig.MULTICAST_SOCKET_BUFFER_SIZE_KBYTE = Integer.parseInt(s);
            }
            if ((s = multicastFeature.get("MULTICAST", "MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES")) != null) {
                SessionConfig.MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES = Integer.parseInt(s);
            }
            if ((s = multicastFeature.get("MULTICAST", "MULTICAST_PROTOCOL_TYPE")) != null) {
                this.connection.getSessionConfig().MULTICAST_PROTOCOL_TYPE = s;
            }
            if (this.connection.ipv6Connection()) {
                try {
                    this.brokerMulticastInterface = InetAddress.getByName(multicastFeature.get("MULTICAST", "MULTICAST_MULTICAST_IPV6INTERFACE"));
                }
                catch (UnknownHostException uhex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setClientConfigParameters(FeatureSet)", uhex, 1);
                    }
                    IOException traceRet1 = new IOException(uhex.toString());
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setClientConfigParameters(FeatureSet)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
            }
            try {
                this.brokerMulticastInterface = InetAddress.getByName(multicastFeature.get("MULTICAST", "MULTICAST_MULTICAST_INTERFACE"));
            }
            catch (UnknownHostException uhex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setClientConfigParameters(FeatureSet)", uhex, 2);
                }
                IOException traceRet2 = new IOException(uhex.toString());
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setClientConfigParameters(FeatureSet)", traceRet2, 2);
                }
                throw traceRet2;
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"setClientConfigParameters", (Object)("MULTICAST_DATA_PORT=" + SessionConfig.MULTICAST_DATA_PORT + "MULTICAST_BACKOFF_TIME_MILLIS=" + SessionConfig.MULTICAST_BACKOFF_TIME_MILLIS + "MULTICAST_NACK_CHECK_PERIOD_MILLIS=" + SessionConfig.MULTICAST_NACK_CHECK_PERIOD_MILLIS + "MULTICAST_PACKET_BUFFERS=" + SessionConfig.MULTICAST_PACKET_BUFFERS + "MULTICAST_SOCKET_BUFFER_SIZE_KBYTE=" + SessionConfig.MULTICAST_SOCKET_BUFFER_SIZE_KBYTE + "brokerMulticastInterface=" + multicastFeature.get("MULTICAST", "MULTICAST_MULTICAST_INTERFACE") + "brokerMulticastInterface=" + multicastFeature.get("MULTICAST", "MULTICAST_MULTICAST_INTERFACE") + "MULTICAST_PROTOCOL_TYPE=" + this.connection.getSessionConfig().MULTICAST_PROTOCOL_TYPE + "MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES=" + SessionConfig.MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setClientConfigParameters");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "setClientConfigParameters(FeatureSet)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopics(MulticastTopic[] topics) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "updateTopics(MulticastTopic [ ])", new Object[]{topics});
        }
        for (int i = 0; i < topics.length; ++i) {
            if (this.multicastTopics.containsKey((Object)topics[i].topic)) {
                MulticastTopic oldTopic;
                MulticastTopic partitionTopicTable;
                SubscriptionInfoImpl subInfo;
                Enumeration enumVar;
                FastVector subMatches;
                if (!topics[i].enabled) {
                    MulticastTopic topic;
                    MulticastTopic multicastTopic = topic = (MulticastTopic)this.multicastTopics.get((Object)topics[i].topic);
                    synchronized (multicastTopic) {
                        topic.setSecurity(null, false);
                        if (this.topicToSusbcriptions.containsKey((Object)topics[i].topic)) {
                            subMatches = (FastVector)this.topicToSusbcriptions.get((Object)topics[i].topic);
                            enumVar = subMatches.elements();
                            while (enumVar.hasMoreElements()) {
                                subInfo = (SubscriptionInfoImpl)((Object)enumVar.nextElement());
                                this.deregisterTopic(subInfo, topic);
                            }
                        }
                    }
                    if (topic.partitionLabel != null || !this.partitionTopics.containsKey((Object)topics[i].topic)) continue;
                    partitionTopicTable = (FastHashtable)this.partitionTopics.get((Object)topic.topic);
                    Enumeration enumVar2 = partitionTopicTable.elements();
                    while (enumVar2.hasMoreElements()) {
                        MulticastTopic subTopic = (MulticastTopic)enumVar2.nextElement();
                        subInfo = subTopic;
                        synchronized (subInfo) {
                            subTopic.setSecurity(null, false);
                            if (this.topicToSusbcriptions.containsKey((Object)subTopic.topic)) {
                                FastVector subMatches2 = (FastVector)this.topicToSusbcriptions.get((Object)subTopic.topic);
                                Enumeration subEnum = subMatches2.elements();
                                while (subEnum.hasMoreElements()) {
                                    SubscriptionInfoImpl subInfo2 = (SubscriptionInfoImpl)((Object)subEnum.nextElement());
                                    this.deregisterTopic(subInfo2, subTopic);
                                }
                            }
                        }
                    }
                    continue;
                }
                partitionTopicTable = oldTopic = (MulticastTopic)this.multicastTopics.get((Object)topics[i].topic);
                synchronized (partitionTopicTable) {
                    if (topics[i].hasQop() || oldTopic.hasQop()) {
                        oldTopic.qop = topics[i].qop;
                        oldTopic.newKey(topics[i].getKey(), topics[i].timeStamp);
                    }
                    oldTopic.reliable = topics[i].reliable;
                    if ((oldTopic.groupAddress == null && topics[i].groupAddress != null || !oldTopic.groupAddress.equals(topics[i].groupAddress)) && this.topicToSusbcriptions.containsKey((Object)oldTopic.topic)) {
                        subMatches = (FastVector)this.topicToSusbcriptions.get((Object)oldTopic.topic);
                        enumVar = subMatches.elements();
                        while (enumVar.hasMoreElements()) {
                            subInfo = (SubscriptionInfoImpl)((Object)enumVar.nextElement());
                            if (oldTopic.enabled) {
                                this.deregisterTopic(subInfo, oldTopic);
                            } else {
                                oldTopic.enabled = true;
                            }
                            oldTopic.groupAddress = topics[i].groupAddress;
                            subInfo.addMulticastTopic(oldTopic);
                            this.registerTopic(subInfo, oldTopic);
                        }
                    }
                    continue;
                }
            }
            if (!topics[i].enabled) continue;
            if (topics[i].hasQop()) {
                topics[i].rekey = true;
            }
            if (topics[i].partitionLabel == null) {
                Enumeration enumVar = this.connection.allSubs.elements();
                while (enumVar.hasMoreElements()) {
                    SubscriptionInfoImpl subInfo = (SubscriptionInfoImpl)((Object)enumVar.nextElement());
                    Object[][] topic = subInfo.parsedTopic;
                    if (!TopicHandler.topicMatch((Object[][])topic, (String)topics[i].topic, (char)'/')) continue;
                    subInfo.addMulticastTopic(topics[i]);
                    this.registerTopic(subInfo, topics[i]);
                }
                continue;
            }
            if (topics[i].partitionLabel == null || !this.topicToSusbcriptions.containsKey((Object)topics[i].partitionLabel)) continue;
            FastVector subMatches = (FastVector)this.topicToSusbcriptions.get((Object)topics[i].partitionLabel);
            Enumeration enumVar = subMatches.elements();
            while (enumVar.hasMoreElements()) {
                SubscriptionInfoImpl subInfo = (SubscriptionInfoImpl)((Object)enumVar.nextElement());
                subInfo.addMulticastTopic(topics[i]);
                this.registerTopic(subInfo, topics[i]);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "updateTopics(MulticastTopic [ ])");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/ConnectionMulticastSupport.java, jmscc.wmq.v6, k701, k701-112-140304  1.10.1.1 09/08/17 08:42:31");
        }
        debug = new DebugObject("ConnectionMulticastSupport");
    }
}

