/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.client.Listener;
import com.ibm.disthub2.client.MessageBodyHandle;
import com.ibm.disthub2.client.ThreadProvider;
import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.ConnectorImpl;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.client.SubscriptionInfo;
import com.ibm.disthub2.impl.client.TopicImpl;
import com.ibm.disthub2.impl.formats.MessageDataHandle;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.multicast.MulticastTopic;
import com.ibm.disthub2.impl.multicast.MulticastUtil;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.impl.util.DoPrivileged;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.disthub2.impl.util.PriorityQueueNode;
import com.ibm.disthub2.impl.util.PriorityQueuePlus;
import com.ibm.disthub2.impl.util.SocketThreadPool;
import com.ibm.disthub2.impl.util.SocketThreadPoolClient;
import com.ibm.disthub2.impl.util.SocketThreadPoolClientHndl;
import com.ibm.disthub2.impl.util.SocketThreadPoolException;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSNotSupportedException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderConnectionBrowser;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderExceptionListener;
import com.ibm.msg.client.provider.ProviderMessageReferenceHandler;
import com.ibm.msg.client.provider.ProviderMetaData;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.wmq.common.internal.WMQCommonConnection;
import com.ibm.msg.client.wmq.common.internal.WMQDestination;
import com.ibm.msg.client.wmq.common.internal.WMQMetaData;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionMulticastSupport;
import com.ibm.msg.client.wmq.v6.direct.internal.JMSWrappedException;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageConsumerImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageQueue;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.SubscriptionInfoImpl;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public class ConnectionImpl
extends ConnectorImpl
implements WMQCommonConnection,
ProviderConnection,
SocketThreadPoolClient,
ClientLogConstants,
ClientExceptionConstants {
    private static final long serialVersionUID = -496955958787213958L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final DebugObject debug;
    private static long midMask;
    private static SocketThreadPool s_clientSocketThreadPool;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/ConnectionImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.16.1.1 09/08/17 08:42:17";
    private static boolean threadPoolChecked;
    private WMQMetaData metaData;
    public static ThreadProvider threadProvider;
    protected boolean appConnectionClosed;
    private String clientID;
    private boolean clientIDFixed;
    protected Exception eConnectionClosed;
    final boolean enableMulticast;
    private ProviderExceptionListener exceptionListener;
    FreeSpaceHeap fsh;
    public boolean haltExecution;
    private JmsPropertyContext jmsPropertyContext;
    private SocketThreadPoolClientHndl m_threadPoolHandle;
    protected boolean mapNameStyle;
    private int multicast;
    protected ConnectionMulticastSupport multicastSupport;
    public SessionConfig sessionConfig;
    protected Vector sessions;
    protected boolean stopped;
    private String userName;

    private static synchronized boolean isThreadPooled() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isThreadPooled()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isThreadPooled");
        }
        boolean result = true;
        if (threadPoolChecked) {
            result = s_clientSocketThreadPool != null;
        } else {
            int rdrs = SessionConfig.getSessionConfig().MAX_CLIENT_READ_THREADS;
            if (rdrs == 0) {
                threadPoolChecked = true;
                result = false;
            } else {
                int pollint = SessionConfig.getSessionConfig().CLIENT_THREAD_POLLING_INTERVAL;
                try {
                    Class<?> cls = Class.forName("com.ibm.disthub2.impl.util.ASocketThreadPool");
                    s_clientSocketThreadPool = (SocketThreadPool)cls.newInstance();
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isThreadPooled()", e);
                    }
                    RuntimeException traceRet1 = new RuntimeException(ExceptionBuilder.buildReasonString((int)-181372107, (Object[])new Object[]{e}));
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isThreadPooled()", traceRet1);
                    }
                    throw traceRet1;
                }
                s_clientSocketThreadPool.setMaxThreads(rdrs, 0);
                s_clientSocketThreadPool.setPollingInterval(pollint);
                s_clientSocketThreadPool.start();
                threadPoolChecked = true;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isThreadPooled", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isThreadPooled()", result);
        }
        return result;
    }

    public ConnectionImpl(String socketType, String hostname, int port, String userName, String password, SessionConfig config, JmsPropertyContext jmsPropertyContext) throws IOException {
        block16: {
            block15: {
                super(socketType, hostname, port, userName, password, (Listener)null, false, (BaseConfig)config);
                this.appConnectionClosed = true;
                this.clientID = null;
                this.clientIDFixed = false;
                this.eConnectionClosed = null;
                this.haltExecution = false;
                this.jmsPropertyContext = null;
                this.mapNameStyle = true;
                this.stopped = true;
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "<init>(String,String,int,String,String,SessionConfig,JmsPropertyContext)", new Object[]{socketType, hostname, new Integer(port), userName, password == null ? password : "********", config, jmsPropertyContext});
                }
                super.allocateMatchSupport();
                try {
                    this.multicast = jmsPropertyContext.getIntProperty("multicast");
                }
                catch (JMSException je) {
                    if (!Trace.isOn) break block15;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "<init>(String,String,int,String,String,SessionConfig,JmsPropertyContext)", je, 1);
                }
            }
            this.sessionConfig = config != null ? config : SessionConfig.getSessionConfig();
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ConnectionImpl", (Object)socketType, (Object)hostname, (Object)new Integer(port), (Object)userName, (Object)"********");
            }
            boolean bl = this.enableMulticast = this.sessionConfig.MULTICAST_ENABLED && !this.pre1_2;
            if (ConnectionImpl.isThreadPooled()) {
                try {
                    this.m_threadPoolHandle = s_clientSocketThreadPool.registerClient(this.socket, (SocketThreadPoolClient)this);
                    this.m_threadPoolHandle.readyToRead();
                }
                catch (SocketThreadPoolException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "<init>(String,String,int,String,String,SessionConfig,JmsPropertyContext)", e, 2);
                    }
                    IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)66471145, (Object[])new Object[]{e}));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "<init>(String,String,int,String,String,SessionConfig,JmsPropertyContext)", traceRet1);
                    }
                    throw traceRet1;
                }
            } else {
                threadProvider.schedule((Runnable)((Object)this));
            }
            this.userName = userName;
            try {
                this.mapNameStyle = jmsPropertyContext.getBooleanProperty("XMSC_WMQ_MAP_NAME_STYLE");
            }
            catch (JMSException jmse) {
                if (!Trace.isOn) break block16;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "<init>(String,String,int,String,String,SessionConfig,JmsPropertyContext)", jmse, 3);
            }
        }
        this.setMaxWindowSize(this.sessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        this.fsh = new FreeSpaceHeap();
        this.startDelivery();
        if (this.enableMulticast) {
            this.queryMulticastFeature();
            this.multicastSupport = new ConnectionMulticastSupport(this);
        }
        this.sessions = new Vector();
        this.jmsPropertyContext = jmsPropertyContext;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"ConnectionImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "<init>(String,String,int,String,String,SessionConfig,JmsPropertyContext)");
        }
    }

    public FreeSpaceHeapNode addFreeSpaceHeapNode(int freeSpace, MessageQueue q) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "addFreeSpaceHeapNode(int,MessageQueue)", new Object[]{new Integer(freeSpace), q});
        }
        FreeSpaceHeapNode qn = new FreeSpaceHeapNode(freeSpace);
        this.fsh.put(qn);
        q.setFreeSpaceHeapStuff(this.fsh, qn, this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "addFreeSpaceHeapNode(int,MessageQueue)", (Object)qn);
        }
        return qn;
    }

    void checkConnectionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "checkConnectionOpen()");
        }
        if (this.isClosed()) {
            String key = "MQJMS1004";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException je = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderConnection is closed. Throwing IllegalStateException.", null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "checkConnectionOpen()", (Throwable)je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "checkConnectionOpen()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "close()");
        }
        this.closeT();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "close()");
        }
    }

    synchronized void closed(SessionImpl session) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "closed(SessionImpl)", new Object[]{session});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"closed", (Object)session);
        }
        Assert.condition((boolean)this.sessions.removeElement(session));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"closed");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "closed(SessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeT() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "closeT()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"closeT");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.isClosed()) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"closeT");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "closeT()", 1);
                }
                return;
            }
            if (this.lastException != null) {
                this.deactivate();
            }
        }
        if (this.sessions != null) {
            Vector tempSessions = (Vector)this.sessions.clone();
            for (int i = 0; i < tempSessions.size(); ++i) {
                SessionImpl session = (SessionImpl)tempSessions.elementAt(i);
                try {
                    session.close(this.eConnectionClosed, this.appConnectionClosed);
                    continue;
                }
                finally {
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "closeT()");
                    }
                }
            }
            this.sessions.removeAllElements();
        }
        this.deactivate();
        this.superClose();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"closeT");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "closeT()", 2);
        }
    }

    protected void completeMulticastSubscribe(SubscriptionInfo subInfo, MessageDataHandle msg) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "completeMulticastSubscribe(SubscriptionInfo,MessageDataHandle)", new Object[]{subInfo, msg});
        }
        if (msg.getChoice(168) == 1) {
            if (msg.getBoolean(58)) {
                SubscriptionInfoImpl localSubInfo = (SubscriptionInfoImpl)subInfo;
                this.match.removeSubscription(subInfo);
                localSubInfo.multicastEnabled = true;
                MulticastTopic[] multicastTopics = MulticastUtil.getMulticastTopics((MessageDataHandle)msg);
                if (multicastTopics != null) {
                    for (int i = 0; i < multicastTopics.length; ++i) {
                        localSubInfo.addMulticastTopic(multicastTopics[i]);
                        if (i == 0) {
                            localSubInfo.multicastReliable = multicastTopics[i].reliable && localSubInfo.multicastReliable;
                        }
                        multicastTopics[i].reliable = localSubInfo.multicastReliable;
                    }
                    this.multicastSupport.registerTopics(localSubInfo);
                }
            } else {
                subInfo.multicastEnabled = false;
                subInfo.multicastReliable = false;
            }
        } else {
            subInfo.multicastEnabled = false;
            subInfo.multicastReliable = false;
        }
        Integer subint = new Integer(subInfo.subid);
        this.allSubs.put(subint, subInfo);
        subInfo.active = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "completeMulticastSubscribe(SubscriptionInfo,MessageDataHandle)");
        }
    }

    protected synchronized void completeSubscribe(int id, int track, MessageDataHandle msg, boolean reactivate) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "completeSubscribe(int,int,MessageDataHandle,boolean)", new Object[]{new Integer(id), new Integer(track), msg, reactivate});
        }
        if (id < 0) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "completeSubscribe(int,int,MessageDataHandle,boolean)", 1);
            }
            return;
        }
        SubscriptionInfo subInfo = (SubscriptionInfo)this.responseHolders[track];
        subInfo.subid = id;
        if (subInfo.multicastEnabled) {
            this.completeMulticastSubscribe(subInfo, msg);
        } else {
            super.completeSubscribe(id, track, msg, reactivate);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "completeSubscribe(int,int,MessageDataHandle,boolean)", 2);
        }
    }

    protected Class configClass() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "configClass()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "configClass()", SessionConfig.class);
        }
        return SessionConfig.class;
    }

    public void connectionDropped() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "connectionDropped()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"connectionDropped");
        }
        this.connectionDropped(this.getException(), false);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"connectionDropped");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "connectionDropped()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDropped(Exception e, boolean appClose) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "connectionDropped(Exception,boolean)", new Object[]{e, appClose});
        }
        if (debug.debugIt(32)) {
            debug.debug(32L, (Object)"connectionDropped", (Object)e, (Object)new Boolean(appClose));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            ProviderExceptionListener el;
            block13: {
                el = this.exceptionListener;
                try {
                    if (this.multicastSupport != null && this.enableMulticast) {
                        Enumeration enumVar = this.allSubs.elements();
                        while (enumVar.hasMoreElements()) {
                            Object nextSub = enumVar.nextElement();
                            if (!(nextSub instanceof SubscriptionInfoImpl) || this.multicastSupport == null) continue;
                            this.multicastSupport.deregisterAllTopics((SubscriptionInfoImpl)((Object)nextSub));
                        }
                    }
                    this.appConnectionClosed = appClose;
                    this.eConnectionClosed = e;
                    this.close();
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "connectionDropped(Exception,boolean)", je);
                    }
                    if (!debug.debugIt(2)) break block13;
                    debug.debug(2L, (Object)"connectionDropped", (Object)("got mystery exception je=" + je.toString()));
                }
            }
            if (!appClose) {
                this.deliverException(el, e, true);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(64L, (Object)"connectionDropped");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "connectionDropped(Exception,boolean)");
        }
    }

    public com.ibm.disthub2.impl.client.MessageImpl constructDummyMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "constructDummyMessageImpl()");
        }
        MessageImpl traceRet1 = new MessageImpl();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "constructDummyMessageImpl()", traceRet1);
        }
        return traceRet1;
    }

    public com.ibm.disthub2.impl.client.MessageImpl constructMessageImpl(MessageHandle msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "constructMessageImpl(MessageHandle)", new Object[]{msg});
        }
        MessageImpl traceRet1 = MessageImpl.construct(msg, this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "constructMessageImpl(MessageHandle)", traceRet1);
        }
        return traceRet1;
    }

    public ProviderConnectionBrowser createConnectionBrowser(ProviderDestination destination, String selector, ProviderMessageReferenceHandler msgRefHandler, int quantityHint) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createConnectionBrowser(ProviderDestination,String,ProviderMessageReferenceHandler,int)", new Object[]{destination, selector, msgRefHandler, new Integer(quantityHint)});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createConnectionBrowser(ProviderDestination,String,ProviderMessageReferenceHandler,int)", traceRet1);
        }
        throw traceRet1;
    }

    public ProviderConnectionBrowser createDurableConnectionBrowser(ProviderDestination destination, String clientid, String subName, String selector, ProviderMessageReferenceHandler msgRefHandler, int quantityHint, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createDurableConnectionBrowser(ProviderDestination,String,String,String,ProviderMessageReferenceHandler,int,boolean)", new Object[]{destination, clientid, subName, selector, msgRefHandler, new Integer(quantityHint), noLocal});
        }
        String key = "MQJMS6311";
        String msg = ConfigEnvironment.getErrorMessage(key);
        JMSException traceRet1 = new JMSException(msg, key);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createDurableConnectionBrowser(ProviderDestination,String,String,String,ProviderMessageReferenceHandler,int,boolean)", traceRet1);
        }
        throw traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderSession createSession(boolean transacted, int acknowledgeMode, JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(boolean,int,JmsPropertyContext)", new Object[]{transacted, new Integer(acknowledgeMode), propertyContext});
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(boolean,int,JmsPropertyContext)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        SessionImpl newSession = new SessionImpl(this, transacted, acknowledgeMode, propertyContext);
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.sessions.addElement(newSession);
            if (!this.stopped) {
                newSession.start();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"createSession", (Object)newSession);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(boolean,int,JmsPropertyContext)", newSession);
        }
        return newSession;
    }

    public ProviderSession createSession(JmsPropertyContext propertyContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(JmsPropertyContext)", new Object[]{propertyContext});
        }
        ProviderSession providerSession = null;
        if (propertyContext.propertyExists("XMSC_TRANSACTED")) {
            boolean transacted = propertyContext.getBooleanProperty("XMSC_TRANSACTED");
            int ackMode = propertyContext.getIntProperty("XMSC_ACKNOWLEDGE_MODE");
            if (transacted) {
                String key = "MQJMS6311";
                String msg = ConfigEnvironment.getErrorMessage(key);
                JMSNotSupportedException traceRet1 = new JMSNotSupportedException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(JmsPropertyContext)", (Throwable)((Object)traceRet1), 1);
                }
                throw traceRet1;
            }
            if (ackMode == 2) {
                String key = "MQJMS6404";
                String msg = ConfigEnvironment.getErrorMessage(key);
                JMSNotSupportedException traceRet2 = new JMSNotSupportedException(msg);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(JmsPropertyContext)", (Throwable)((Object)traceRet2), 2);
                }
                throw traceRet2;
            }
            providerSession = this.createSession(transacted, ackMode, propertyContext);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createSession(JmsPropertyContext)", providerSession);
        }
        return providerSession;
    }

    public void culled(SocketThreadPoolClientHndl h) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "culled(SocketThreadPoolClientHndl)", new Object[]{h});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"culled", (Object)h);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"culled");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "culled(SocketThreadPoolClientHndl)");
        }
    }

    protected void deactivate() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deactivate()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"deactivate");
        }
        this.active = false;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"deactivate");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deactivate()");
        }
    }

    public boolean doRead() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "doRead()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"doRead");
        }
        boolean result = false;
        try {
            this.m_threadPoolHandle.beginRead();
            byte[] data = this.receive();
            this.m_threadPoolHandle.endRead();
            this.handleMessage(data);
            result = true;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "doRead()", e);
            }
            this.setException(e);
            result = false;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"doRead", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "doRead()", result);
        }
        return result;
    }

    public boolean doWrite() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "doWrite()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"doWrite");
        }
        RuntimeException traceRet1 = new RuntimeException(ExceptionBuilder.buildReasonString((int)-343781462, null));
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "doWrite()", traceRet1);
        }
        throw traceRet1;
    }

    public boolean enableMulticast() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "enableMulticast()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "enableMulticast()", this.enableMulticast);
        }
        return this.enableMulticast;
    }

    protected InetAddress getAddress() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getAddress()");
        }
        if (this.socket != null) {
            InetAddress traceRet1 = this.socket.getInetAddress();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getAddress()", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getAddress()", null, 2);
        }
        return null;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getBooleanProperty(String)", new Object[]{name});
        }
        boolean traceRet1 = this.jmsPropertyContext.getBooleanProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getBooleanProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    public byte getByteProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getByteProperty(String)", new Object[]{name});
        }
        byte traceRet1 = this.jmsPropertyContext.getByteProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getByteProperty(String)", new Byte(traceRet1));
        }
        return traceRet1;
    }

    public byte[] getBytesProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getBytesProperty(String)", new Object[]{name});
        }
        byte[] traceRet1 = this.jmsPropertyContext.getBytesProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getBytesProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    public char getCharProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getCharProperty(String)", new Object[]{name});
        }
        char traceRet1 = this.jmsPropertyContext.getCharProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getCharProperty(String)", new Character(traceRet1));
        }
        return traceRet1;
    }

    public String getClientID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getClientID()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getClientID");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getClientID()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getClientID", (Object)this.clientID);
        }
        if (this.clientID == null || this.clientID.equals("")) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getClientID()", this.userName, 1);
            }
            return this.userName;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getClientID()", this.clientID, 2);
        }
        return this.clientID;
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getDoubleProperty(String)", new Object[]{name});
        }
        double traceRet1 = this.jmsPropertyContext.getDoubleProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getDoubleProperty(String)", new Double(traceRet1));
        }
        return traceRet1;
    }

    public ProviderExceptionListener getExceptionListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getExceptionListener()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getExceptionListener");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getExceptionListener()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getExceptionListener", (Object)this.exceptionListener);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getExceptionListener()", this.exceptionListener);
        }
        return this.exceptionListener;
    }

    public float getFloatProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getFloatProperty(String)", new Object[]{name});
        }
        float traceRet1 = this.jmsPropertyContext.getFloatProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getFloatProperty(String)", new Float(traceRet1));
        }
        return traceRet1;
    }

    public int getIntProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getIntProperty(String)", new Object[]{name});
        }
        int traceRet1 = this.jmsPropertyContext.getIntProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getIntProperty(String)", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public long getLongProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getLongProperty(String)", new Object[]{name});
        }
        long traceRet1 = this.jmsPropertyContext.getLongProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getLongProperty(String)", new Long(traceRet1));
        }
        return traceRet1;
    }

    protected int getMulticast() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getMulticast()", "getter", new Integer(this.multicast));
        }
        return this.multicast;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getObjectProperty(String)", new Object[]{name});
        }
        Object traceRet1 = this.jmsPropertyContext.getObjectProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getObjectProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    protected int getPort() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getPort()");
        }
        if (this.socket != null) {
            int traceRet1 = this.socket.getPort();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getPort()", new Integer(traceRet1), 1);
            }
            return traceRet1;
        }
        int traceRet2 = -1;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getPort()", new Integer(traceRet2), 2);
        }
        return traceRet2;
    }

    public Enumeration getPropertyNames() throws JMSException {
        Enumeration traceRet1 = this.jmsPropertyContext.getPropertyNames();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getPropertyNames()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public SessionConfig getSessionConfig() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getSessionConfig()", "getter", this.sessionConfig);
        }
        return this.sessionConfig;
    }

    public short getShortProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getShortProperty(String)", new Object[]{name});
        }
        short traceRet1 = this.jmsPropertyContext.getShortProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getShortProperty(String)", new Short(traceRet1));
        }
        return traceRet1;
    }

    public String getStringProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getStringProperty(String)", new Object[]{name});
        }
        String traceRet1 = this.jmsPropertyContext.getStringProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getStringProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    String getTemporaryTopicString(String arg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getTemporaryTopicString(String)", new Object[]{arg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"getTemporaryTopicString", (Object)arg);
        }
        String result = this.createTemporaryTopicString(arg);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"getTermporaryTopicString", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getTemporaryTopicString(String)", result);
        }
        return result;
    }

    protected void handleControl(MessageHandle msg) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleControl(MessageHandle)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleControl", (Object)msg);
        }
        switch (msg.getChoice(162)) {
            case 32: {
                this.handleMulticastControlReq(msg);
                break;
            }
            case 33: {
                this.handleMulticastControlReply(msg);
                break;
            }
            case 34: {
                this.handleMulticastTopicsUpdate(msg);
                break;
            }
            default: {
                super.handleControl(msg);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleControl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleControl(MessageHandle)");
        }
    }

    protected void handleMessage(byte[] data) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMessage(byte [ ])", new Object[]{data});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMessage", (Object)data);
        }
        super.handleMessage(data);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMessage");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMessage(byte [ ])");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMulticastControlReply(MessageHandle msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastControlReply(MessageHandle)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMulticastControlReply", (Object)msg);
        }
        if (this.enableMulticast) {
            byte[] data = msg.getByteArray(102);
            if (this.multicastSupport != null) {
                ConnectionMulticastSupport connectionMulticastSupport = this.multicastSupport;
                synchronized (connectionMulticastSupport) {
                    this.multicastSupport.onControlMessage(data);
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMulticastControlReply");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastControlReply(MessageHandle)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMulticastControlReq(MessageHandle msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastControlReq(MessageHandle)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMulticastControlReq", (Object)msg);
        }
        if (this.enableMulticast) {
            byte[] data = msg.getByteArray(101);
            if (this.multicastSupport != null) {
                ConnectionMulticastSupport connectionMulticastSupport = this.multicastSupport;
                synchronized (connectionMulticastSupport) {
                    this.multicastSupport.sendControlMessage(data);
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMulticastControlReq");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastControlReq(MessageHandle)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMulticastTopicsUpdate(MessageHandle msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastTopicsUpdate(MessageHandle)", new Object[]{msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"handleMulticastTopicsUpdate", (Object)msg);
        }
        if (this.enableMulticast && this.multicastSupport != null) {
            MulticastTopic[] multicastTopics = MulticastUtil.getMulticastTopicsUpdate((MessageDataHandle)msg);
            try {
                ConnectionMulticastSupport connectionMulticastSupport = this.multicastSupport;
                synchronized (connectionMulticastSupport) {
                    this.multicastSupport.updateTopics(multicastTopics);
                }
            }
            catch (IOException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastTopicsUpdate(MessageHandle)", e);
                }
                this.setException(e);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"handleMulticastTopicsUpdate");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "handleMulticastTopicsUpdate(MessageHandle)");
        }
    }

    public boolean ipv6Connection() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "ipv6Connection()");
        }
        if (this.socket != null) {
            if (this.socket.getLocalAddress() instanceof Inet6Address) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "ipv6Connection()", true, 1);
                }
                return true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "ipv6Connection()", false, 2);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "ipv6Connection()", false, 3);
        }
        return false;
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isActive", (Object)new Boolean(this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isActive()", "getter", this.active);
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isClosed", (Object)new Boolean(!this.active));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isClosed()", "getter", !this.active);
        }
        return !this.active;
    }

    boolean isLocalMid(long mid) {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isLocalMid(long)", new Object[]{new Long(mid)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isLocalMid", (Object)new Long(mid));
        }
        boolean bl = result = (mid & midMask) == (this.messageId & midMask);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isLocalMid", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isLocalMid(long)", result);
        }
        return result;
    }

    boolean isPre1_2() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isPre1_2()", "getter", this.pre1_2);
        }
        return this.pre1_2;
    }

    boolean isStarted() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isStarted");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isStarted", (Object)new Boolean(!this.stopped));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isStarted()", "getter", !this.stopped);
        }
        return !this.stopped;
    }

    boolean isStopped() {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"isStopped");
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"isStopped", (Object)new Boolean(this.stopped));
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isStopped()", "getter", this.stopped);
        }
        return this.stopped;
    }

    public void newMessageForClient(SubscriptionInfo subInfo, com.ibm.disthub2.impl.client.MessageImpl msg) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "newMessageForClient(com.ibm.disthub2.impl.client.SubscriptionInfo,com.ibm.disthub2.impl.client.MessageImpl)", new Object[]{subInfo, msg});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"newMessageForClient2", (Object)subInfo, (Object)msg);
        }
        msg.subInfo = subInfo;
        if (this.haltExecution) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "newMessageForClient(com.ibm.disthub2.impl.client.SubscriptionInfo,com.ibm.disthub2.impl.client.MessageImpl)", 1);
            }
            return;
        }
        if (!((MessageConsumerImpl)subInfo.tsi).newMessage((MessageImpl)msg)) {
            if (debug.debugIt(2)) {
                debug.debug(2L, (Object)"newMessageForClient", (Object)"delivery failed, will close connection");
            }
            this.haltExecution = true;
        }
        if (this.haltExecution) {
            this.setException((Exception)((Object)new JMSException(ExceptionBuilder.buildReasonString((int)1003358355, (Object[])new Object[]{new Integer(0)}))));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"newMessageForClient");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "newMessageForClient(com.ibm.disthub2.impl.client.SubscriptionInfo,com.ibm.disthub2.impl.client.MessageImpl)", 2);
        }
    }

    protected void newMulticastMessage(FastVector subscriptions, MessageHandle msg) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "newMulticastMessage(FastVector,MessageHandle)", new Object[]{subscriptions, msg});
        }
        Enumeration iter = subscriptions.elements();
        while (iter.hasMoreElements()) {
            SubscriptionInfo subInfo = (SubscriptionInfo)iter.nextElement();
            if (!this.match.doesThisMatch((ConnectorImpl)this, subInfo, msg)) continue;
            com.ibm.disthub2.impl.client.MessageImpl m = this.constructMessageImpl(msg);
            m.subInfo = subInfo;
            this.newMessageForClient(subInfo, m);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "newMulticastMessage(FastVector,MessageHandle)");
        }
    }

    public void onException(Exception ex) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "onException(Exception)", new Object[]{ex});
        }
        this.deliverException(ex, false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "onException(Exception)");
        }
    }

    public void deliverException(Exception e, boolean connectionBroken) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deliverException(Exception,boolean)", new Object[]{e, connectionBroken});
        }
        this.deliverException(this.exceptionListener, e, connectionBroken);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deliverException(Exception,boolean)");
        }
    }

    private void deliverException(ProviderExceptionListener el, Exception e, boolean connectionBroken) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deliverException(ProviderExceptionListener,Exception,boolean)", new Object[]{el, e, connectionBroken});
        }
        if (el != null) {
            JMSException je = e instanceof JMSException ? (JMSException)((Object)e) : new JMSWrappedException(e);
            el.onException(je, connectionBroken);
        } else if (debug.debugIt(16)) {
            debug.debug(16L, (Object)"deliverException", (Object)"no exceptionlistener to dispatch ");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deliverException(ProviderExceptionListener,Exception,boolean)");
        }
    }

    public boolean propertyExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "propertyExists(String)", new Object[]{name});
        }
        boolean traceRet1 = this.jmsPropertyContext.propertyExists(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "propertyExists(String)", traceRet1);
        }
        return traceRet1;
    }

    protected void queryMulticastFeature() throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "queryMulticastFeature()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"queryMulticastFeature");
        }
        MessageHandle query = ConnectorImpl.newMessage((int)7, (String)"", (int)4);
        query.setBoolean(42, true);
        MessageBodyHandle[] fTable = new MessageBodyHandle[]{query.newTableRow(43)};
        fTable[0].setString(0, "MULTICAST");
        fTable[0].setString(1, "");
        fTable[0].setString(2, "");
        query.setTable(43, fTable);
        this.send(query);
        this.waitForFeatureExchange("MULTICAST");
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"queryMulticastFeature");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "queryMulticastFeature()");
        }
    }

    protected synchronized void requestProperties(String name) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "requestProperties(String)", new Object[]{name});
        }
        TopicImpl toRegister = (TopicImpl)this.topicCache.get((Object)name);
        toRegister.setDefaultProperties();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "requestProperties(String)");
        }
    }

    public void sendMulticastControlMsg(byte[] message) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "sendMulticastControlMsg(byte [ ])", new Object[]{message});
        }
        try {
            int track = 0;
            MessageHandle cntrlMsg = ConnectorImpl.newControlMessage((int)32, (int)track);
            cntrlMsg.setByteArray(101, message);
            this.send(cntrlMsg);
        }
        catch (IOException exception) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "sendMulticastControlMsg(byte [ ])", exception);
            }
            this.setException(exception);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "sendMulticastControlMsg(byte [ ])");
        }
    }

    public void setBatchProperties(Map properties) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setBatchProperties(Map)", "setter", properties);
        }
        this.jmsPropertyContext.setBatchProperties(properties);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setBooleanProperty(String,boolean)", new Object[]{name, value});
        }
        this.jmsPropertyContext.setBooleanProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setBooleanProperty(String,boolean)");
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setByteProperty(String,byte)", new Object[]{name, new Byte(value)});
        }
        this.jmsPropertyContext.setByteProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setByteProperty(String,byte)");
        }
    }

    public void setBytesProperty(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setBytesProperty(String,byte [ ])", new Object[]{name, value});
        }
        this.jmsPropertyContext.setBytesProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setBytesProperty(String,byte [ ])");
        }
    }

    public void setCharProperty(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setCharProperty(String,char)", new Object[]{name, new Character(value)});
        }
        this.jmsPropertyContext.setCharProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setCharProperty(String,char)");
        }
    }

    public void setClientID(String clientId) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientID(String)", new Object[]{clientId});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setClientID", (Object)clientId);
        }
        if (this.clientIDFixed) {
            String msg = ConfigEnvironment.getErrorMessage("MQJMS3031");
            IllegalStateException traceRet1 = new IllegalStateException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientID(String)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (clientId == null) {
            String key = "MQJMS0002";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException traceRet2 = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientID(String)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (this.clientID != null) {
            String key = "MQJMS3032";
            String msg = ConfigEnvironment.getErrorMessage(key);
            IllegalStateException traceRet3 = new IllegalStateException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientID(String)", (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        this.clientID = clientId;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setClientID", (Object)this.clientID);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientID(String)");
        }
    }

    void setClientIDFixed() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientIDFixed()");
        }
        this.clientIDFixed = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setClientIDFixed()");
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setDoubleProperty(String,double)", new Object[]{name, new Double(value)});
        }
        this.jmsPropertyContext.setDoubleProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setDoubleProperty(String,double)");
        }
    }

    protected void setException(Exception e) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setException(Exception)", "setter", e);
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setException", (Object)e);
        }
        super.setException(e);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ProviderExceptionListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setExceptionListener(ProviderExceptionListener)", new Object[]{listener});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setExceptionListener", (Object)listener);
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setExceptionListener(ProviderExceptionListener)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.exceptionListener = listener;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setExceptionListener");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setExceptionListener(ProviderExceptionListener)");
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setFloatProperty(String,float)", new Object[]{name, new Float(value)});
        }
        this.jmsPropertyContext.setFloatProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setFloatProperty(String,float)");
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setIntProperty(String,int)", new Object[]{name, new Integer(value)});
        }
        this.jmsPropertyContext.setIntProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setIntProperty(String,int)");
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setLongProperty(String,long)", new Object[]{name, new Long(value)});
        }
        this.jmsPropertyContext.setLongProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setLongProperty(String,long)");
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setObjectProperty(String,Object)", new Object[]{name, value});
        }
        this.jmsPropertyContext.setObjectProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setObjectProperty(String,Object)");
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setShortProperty(String,short)", new Object[]{name, new Short(value)});
        }
        this.jmsPropertyContext.setShortProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setShortProperty(String,short)");
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setStringProperty(String,String)", new Object[]{name, value});
        }
        this.jmsPropertyContext.setStringProperty(name, value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "setStringProperty(String,String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "start()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"start");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "start()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this.stopped) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"start");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "start()", 1);
                }
                return;
            }
            Vector tempSessions = (Vector)this.sessions.clone();
            for (int i = 0; i < tempSessions.size(); ++i) {
                SessionImpl session = (SessionImpl)tempSessions.elementAt(i);
                session.start();
            }
            this.stopped = false;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"start");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "start()", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "stop()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"stop");
        }
        if (this.isClosed()) {
            IllegalStateException traceRet1 = new IllegalStateException(ExceptionBuilder.buildReasonString((int)-1924738140, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "stop()", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.stopped) {
                if (debug.debugIt(64)) {
                    debug.debug(-142394261359015L, (Object)"stop");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "stop()", 1);
                }
                return;
            }
            Vector tempSessions = (Vector)this.sessions.clone();
            for (int i = 0; i < tempSessions.size(); ++i) {
                SessionImpl session = (SessionImpl)tempSessions.elementAt(i);
                session.stop();
            }
            this.stopped = true;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"stop");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "stop()", 2);
        }
    }

    private void superClose() throws JMSException {
        block8: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "superClose()");
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"close");
            }
            this.active = false;
            this.exceptionListener = null;
            super.close(!this.appConnectionClosed);
            if (this.m_threadPoolHandle != null) {
                try {
                    this.m_threadPoolHandle.deregisterClient();
                }
                catch (SocketThreadPoolException e) {
                    if (!Trace.isOn) break block8;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "superClose()", e);
                }
            }
        }
        if (this.multicastSupport != null) {
            this.multicastSupport.close();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "superClose()");
        }
    }

    public void unsubscribe(int id) throws IOException {
        SubscriptionInfoImpl subInfo;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "unsubscribe(int)", new Object[]{new Integer(id)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"unsubscribe", (Object)new Integer(id));
        }
        if ((subInfo = (SubscriptionInfoImpl)((Object)this.allSubs.get(new Integer(id)))) != null && subInfo.multicastEnabled) {
            this.multicastSupport.deregisterAllTopics(subInfo);
        }
        super.unsubscribe(id);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"unsubscribe");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "unsubscribe(int)");
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "clear()");
        }
        this.jmsPropertyContext.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "clear()");
        }
    }

    public boolean containsKey(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "containsKey(Object)", new Object[]{key});
        }
        boolean traceRet1 = this.jmsPropertyContext.containsKey(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "containsKey(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean containsValue(Object value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "containsValue(Object)", new Object[]{value});
        }
        boolean traceRet1 = this.jmsPropertyContext.containsValue(value);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "containsValue(Object)", traceRet1);
        }
        return traceRet1;
    }

    public Set entrySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "entrySet()");
        }
        Set traceRet1 = this.jmsPropertyContext.entrySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "entrySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object get(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "get(Object)", new Object[]{key});
        }
        Object traceRet1 = this.jmsPropertyContext.get(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "get(Object)", traceRet1);
        }
        return traceRet1;
    }

    public boolean isEmpty() {
        boolean traceRet1 = this.jmsPropertyContext.isEmpty();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "isEmpty()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Set keySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "keySet()");
        }
        Set traceRet1 = this.jmsPropertyContext.keySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "keySet()", traceRet1);
        }
        return traceRet1;
    }

    public Object put(Object arg0, Object arg1) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "put(Object,Object)", new Object[]{arg0, arg1});
        }
        Object traceRet1 = this.jmsPropertyContext.put(arg0, arg1);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "put(Object,Object)", traceRet1);
        }
        return traceRet1;
    }

    public void putAll(Map arg0) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "putAll(Map)", new Object[]{arg0});
        }
        this.jmsPropertyContext.putAll(arg0);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "putAll(Map)");
        }
    }

    public Object remove(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "remove(Object)", new Object[]{key});
        }
        Object traceRet1 = this.jmsPropertyContext.remove(key);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "remove(Object)", traceRet1);
        }
        return traceRet1;
    }

    public int size() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "size()");
        }
        int traceRet1 = this.jmsPropertyContext.size();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "size()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Collection values() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "values()");
        }
        Collection traceRet1 = this.jmsPropertyContext.values();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "values()", traceRet1);
        }
        return traceRet1;
    }

    public ProviderMetaData getMetaData() throws JMSException {
        if (this.metaData == null) {
            String providerVersion = this.getStringProperty("XMSC_WMQ_PROVIDER_VERSION");
            this.metaData = new WMQMetaData(providerVersion);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getMetaData()", "getter", this.metaData);
        }
        return this.metaData;
    }

    public boolean getPersistenceFromMD() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "getPersistenceFromMD()", "getter", false);
        }
        return false;
    }

    public WMQDestination createTemporaryDestination(int destType, JmsPropertyContext propContext) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createTemporaryDestination(int,JmsPropertyContext)", new Object[]{new Integer(destType), propContext});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "createTemporaryDestination(int,JmsPropertyContext)", null);
        }
        return null;
    }

    public void deleteTemporaryDestination(WMQDestination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deleteTemporaryDestination(WMQDestination)", new Object[]{dest});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "deleteTemporaryDestination(WMQDestination)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl", "static", "SCCS id", (Object)sccsid);
        }
        debug = new DebugObject("ConnectionImpl");
        midMask = -4294967296L;
        threadProvider = new ThreadProviderImpl();
    }

    static class ThreadProviderImpl
    implements ThreadProvider {
        ThreadProviderImpl() {
        }

        public void schedule(Runnable r) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ThreadProviderImpl", "schedule(Runnable)", new Object[]{r});
            }
            DoPrivileged.createAndStartThread((Runnable)r, (boolean)true);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ThreadProviderImpl", "schedule(Runnable)");
            }
        }
    }

    public class FreeSpaceHeapNode
    extends PriorityQueueNode {
        FreeSpaceHeapNode(int p) {
            super((long)p);
        }
    }

    public class FreeSpaceHeap
    extends PriorityQueuePlus {
    }
}

