/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.wmq.v6.direct.internal.ConfigEnvironment;
import com.ibm.msg.client.wmq.v6.direct.internal.ConnectionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.JMSWrappedException;
import com.ibm.msg.client.wmq.v6.direct.internal.MessageImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class BytesMessageImpl
extends MessageImpl
implements ProviderBytesMessage,
ClientLogConstants,
ClientExceptionConstants {
    private static final int BYTE_OUTPUT_STREAM_SIZE = 1024;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final DebugObject debug;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_FLOAT_S390 = 768;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/BytesMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304 1.8.1.1 09/08/17 08:41:50";
    private static final long serialVersionUID = -1457018201401185578L;
    ByteArrayInputStream bais;
    ByteArrayOutputStream baos;
    byte[] body;
    DataInputStream dis;
    DataOutputStream dos;
    private long lastKnownLength = -1L;

    public BytesMessageImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "<init>()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"BytesMessageImpl");
        }
        this.messageClass = "jms_bytes";
        this.baos = new ByteArrayOutputStream(1024);
        this.dos = new DataOutputStream(this.baos);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"BytesMessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "<init>()");
        }
    }

    public BytesMessageImpl(MessageHandle cursor, ConnectionImpl conn) {
        super(cursor, conn);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "<init>(MessageHandle,ConnectionImpl)", new Object[]{cursor, conn});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"BytesMessageImpl", (Object)cursor, (Object)conn);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"BytesMessageImpl");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "<init>(MessageHandle,ConnectionImpl)");
        }
    }

    public void clearBody() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "clearBody()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clearBody");
        }
        this.lastKnownLength = -1L;
        if (this.readOnly) {
            this.readOnly = false;
            if (this.body == null) {
                this.obtainBody();
            }
            this.bais.reset();
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream(1024);
                this.dos = new DataOutputStream(this.baos);
            } else {
                this.baos.reset();
            }
        } else {
            this.baos.reset();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clearBody");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "clearBody()");
        }
    }

    public long getBodyLength() throws JMSException, MessageNotReadableException {
        long traceRet12;
        long length;
        block17: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()");
            }
            length = 0L;
            byte[] copyBuffer = new byte[4000];
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"getBodyLength");
            }
            if (!this.readOnly) {
                MessageNotReadableException traceRet12 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()", (Throwable)traceRet12, 1);
                }
                throw traceRet12;
            }
            if (this.lastKnownLength != -1L) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()", new Long(this.lastKnownLength), 1);
                }
                return this.lastKnownLength;
            }
            if (this.body == null) {
                this.obtainBody();
            }
            try {
                int moreBytes;
                while ((moreBytes = this.dis.read(copyBuffer)) >= 0) {
                    length += (long)moreBytes;
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()", new Long(length), 2);
                }
                traceRet12 = length;
                Object var8_7 = null;
                if (!Trace.isOn) break block17;
            }
            catch (IOException ioe) {
                try {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()", ioe);
                    }
                    JMSWrappedException traceRet2 = new JMSWrappedException(ioe);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()", (Throwable)((Object)traceRet2), 2);
                    }
                    throw traceRet2;
                }
                catch (Throwable throwable) {
                    block18: {
                        Object var8_8 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()");
                        }
                        this.lastKnownLength = length;
                        if (!debug.debugIt(64)) break block18;
                        debug.debug(-153415734321212L, (Object)("Returning length : " + length));
                        debug.debug(-142394261359015L, (Object)"getBodyLength");
                    }
                    throw throwable;
                }
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBodyLength()");
        }
        this.lastKnownLength = length;
        if (debug.debugIt(64)) {
            debug.debug(-153415734321212L, (Object)("Returning length : " + length));
            debug.debug(-142394261359015L, (Object)"getBodyLength");
        }
        return traceRet12;
    }

    public byte[] getBytes() throws JMSException {
        if (this.body == null) {
            this.obtainBody();
        }
        byte[] bytes = new byte[this.body.length];
        this.readBytes(bytes);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "getBytes()", "getter", bytes);
        }
        return bytes;
    }

    private void obtainBody() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "obtainBody()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"obtainBody");
        }
        try {
            this.body = this.getBytesBody();
            this.bais = new ByteArrayInputStream(this.body);
            this.dis = new DataInputStream(this.bais);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "obtainBody()", e);
            }
            Assert.failure((Exception)e);
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"obtainBody");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "obtainBody()");
        }
    }

    void prepareMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "prepareMessage()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"prepareMessage");
        }
        if (!this.readOnly) {
            this.setBytesBody(this.baos.toByteArray());
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"prepareMessage");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "prepareMessage()");
        }
    }

    public boolean readBoolean() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readBoolean");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        boolean result = false;
        try {
            result = this.dis.readBoolean();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBoolean", (Object)new Boolean(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBoolean()", result);
        }
        return result;
    }

    public byte readByte() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readByte");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        byte result = 0;
        try {
            result = this.dis.readByte();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readByte", (Object)new Byte(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readByte()", new Byte(result));
        }
        return result;
    }

    public int readBytes(byte[] value) throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ])", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readBytes");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ])", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int result = 0;
        try {
            result = this.dis.read(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ])", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ])", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBytes", (Object)new Integer(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ])", new Integer(result));
        }
        return result;
    }

    public int readBytes(byte[] value, int length) throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ],int)", new Object[]{value, new Integer(length)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"BytesMessageImpl.readBytes", (Object)new Integer(length));
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ],int)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int result = 0;
        try {
            result = this.dis.read(value, 0, length);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ],int)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ],int)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readBytes", (Object)new Integer(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readBytes(byte [ ],int)", new Integer(result));
        }
        return result;
    }

    public char readChar() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readChar");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        char result = '\u0000';
        try {
            result = this.dis.readChar();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readChar", (Object)new Character(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readChar()", new Character(result));
        }
        return result;
    }

    public double readDouble() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readDouble");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        double result = 0.0;
        try {
            result = this.dis.readDouble();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readDouble", (Object)new Double(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readDouble()", new Double(result));
        }
        return result;
    }

    public float readFloat() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readFloat");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        float result = 0.0f;
        try {
            result = this.dis.readFloat();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readFloat", (Object)new Double(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readFloat()", new Float(result));
        }
        return result;
    }

    public int readInt() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readInt");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int result = 0;
        try {
            result = this.dis.readInt();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readInt", (Object)new Integer(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readInt()", new Integer(result));
        }
        return result;
    }

    public long readLong() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readLong");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        long result = 0L;
        try {
            result = this.dis.readLong();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readLong", (Object)new Long(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readLong()", new Long(result));
        }
        return result;
    }

    public short readShort() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readShort");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        short result = 0;
        try {
            result = this.dis.readShort();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readShort", (Object)new Short(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readShort()", new Short(result));
        }
        return result;
    }

    public int readUnsignedByte() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readUnsignedByte");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int result = 0;
        try {
            result = this.dis.readUnsignedByte();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readUnsignedByte", (Object)new Integer(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedByte()", new Integer(result));
        }
        return result;
    }

    public int readUnsignedShort() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readUnsignedShort");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int result = 0;
        try {
            result = this.dis.readUnsignedShort();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readUnsignedShort", (Object)new Integer(result));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUnsignedShort()", new Integer(result));
        }
        return result;
    }

    public String readUTF() throws MessageNotReadableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readUTF");
        }
        if (!this.readOnly) {
            MessageNotReadableException traceRet1 = new MessageNotReadableException(ExceptionBuilder.buildReasonString((int)-228824350, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.body == null) {
            this.obtainBody();
        }
        String result = null;
        try {
            result = this.dis.readUTF();
        }
        catch (EOFException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()", e, 1);
            }
            MessageEOFException traceRet2 = new MessageEOFException(ExceptionBuilder.buildReasonString((int)1019955564, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()", traceRet2, 2);
            }
            throw traceRet2;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()", e, 2);
            }
            JMSWrappedException traceRet3 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()", (Throwable)((Object)traceRet3), 3);
            }
            throw traceRet3;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readUTF", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "readUTF()", result);
        }
        return result;
    }

    public void reset() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "reset()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"reset");
        }
        if (!this.readOnly) {
            this.prepareMessage();
            this.readOnly = true;
            this.body = this.baos.toByteArray();
            this.bais = new ByteArrayInputStream(this.body);
            this.dis = new DataInputStream(this.bais);
        } else if (this.bais != null) {
            this.bais.reset();
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"reset");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "reset()");
        }
    }

    public void setBytes(byte[] bytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "setBytes(byte [ ])", "setter", bytes);
        }
        this.writeBytes(bytes);
    }

    public void writeBoolean(boolean value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBoolean(boolean)", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBoolean", (Object)new Boolean(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBoolean(boolean)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeBoolean(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBoolean(boolean)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBoolean(boolean)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBoolean");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeByte(byte)", new Object[]{new Byte(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeByte", (Object)new Byte(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeByte(byte)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeByte(byte)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeByte(byte)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeByte");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeByte(byte)");
        }
    }

    public void writeBytes(byte[] value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ])", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBytes");
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ])", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.write(value, 0, value.length);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ])", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ])", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBytes");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeBytes", (Object)new Integer(offset), (Object)new Integer(length));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ],int,int)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.write(value, offset, length);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ],int,int)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ],int,int)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeBytes");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeChar(char value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeChar(char)", new Object[]{new Character(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeChar", (Object)new Character(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeChar(char)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeChar(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeChar(char)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeChar(char)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeChar");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeChar(char)");
        }
    }

    public void writeDouble(double value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeDouble(double)", new Object[]{new Double(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeDouble", (Object)new Double(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeDouble(double)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeDouble(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeDouble(double)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeDouble(double)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeDouble");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeDouble(double)");
        }
    }

    public void writeFloat(float value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeFloat(float)", new Object[]{new Float(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeFloat", (Object)new Float(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeFloat(float)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeFloat(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeFloat(float)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeFloat(float)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeFloat");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeFloat(float)");
        }
    }

    public void writeInt(int value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeInt(int)", new Object[]{new Integer(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeInt", (Object)new Integer(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeInt(int)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeInt(int)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeInt(int)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeInt");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeInt(int)");
        }
    }

    public void writeLong(long value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeLong(long)", new Object[]{new Long(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeLong", (Object)new Long(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeLong(long)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeLong(long)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeLong(long)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeLong");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeLong(long)");
        }
    }

    public void writeObject(Object value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeObject(Object)", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeObject", value);
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeObject(Object)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            String key = "MQJMS0006";
            String msg = ConfigEnvironment.getErrorMessage(key);
            MessageFormatException traceRet2 = new MessageFormatException(msg, key);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeObject(Object)", (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeObject");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeObject(Object)");
        }
    }

    public void writeShort(short value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeShort(short)", new Object[]{new Short(value)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeShort", (Object)new Short(value));
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeShort(short)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeShort(short)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeShort(short)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeShort");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeShort(short)");
        }
    }

    public void writeUTF(String value) throws MessageNotWriteableException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeUTF(String)", new Object[]{value});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeUTF", (Object)value);
        }
        if (this.readOnly) {
            MessageNotWriteableException traceRet1 = new MessageNotWriteableException(ExceptionBuilder.buildReasonString((int)2144856379, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeUTF(String)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            this.dos.writeUTF(value);
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeUTF(String)", e);
            }
            JMSWrappedException traceRet2 = new JMSWrappedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeUTF(String)", (Throwable)((Object)traceRet2), 2);
            }
            throw traceRet2;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeUTF");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "writeUTF(String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.BytesMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/BytesMessageImpl.java, jmscc.wmq.v6, k701, k701-112-140304  1.8.1.1 09/08/17 08:41:50");
        }
        debug = new DebugObject("BytesMessageImpl");
    }
}

