/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.AuthException;
import com.ibm.disthub2.spi.AuthResult;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.AuthBase;
import com.ibm.msg.client.wmq.v6.direct.internal.AuthPrincipal;
import com.ibm.msg.client.wmq.v6.direct.internal.DefaultPrincipal;
import com.ibm.msg.client.wmq.v6.direct.internal.ISSL;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Properties;

public class AuthClient
extends AuthBase {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static DebugObject debug;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/AuthClient.java, jmscc.wmq.v6, k701, k701-112-140304 1.8.1.1 09/08/17 08:41:26";

    public AuthClient(Socket s, AuthPrincipal creds, Properties mD, short[] protos, ISSL sslLib) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "<init>(Socket,AuthPrincipal,Properties,short [ ],ISSL)", new Object[]{s, creds, mD, protos, sslLib});
        }
        this.sock = s;
        this.credentials = creds;
        this.metaData = mD;
        this.cfgProtos = protos;
        this.xssl = sslLib;
        this.role = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "<init>(Socket,AuthPrincipal,Properties,short [ ],ISSL)");
        }
    }

    public AuthResult authenticate() throws AuthException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "authenticate()");
        }
        try {
            this.setupDataStreams();
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"runClient", (Object)"Starting client auth protocol...");
                for (int q = 0; q < this.cfgProtos.length; ++q) {
                    debug.debug(-153415734321212L, (Object)"runClient", (Object)("Client proto: " + q + " " + this.cfgProtos[q] + " (" + (char)(this.cfgProtos[q] >> 8) + ")"));
                }
            }
            new AuthBase.Hello(this.cfgProtos).writeMsg(this.ostr);
            AuthBase.MsgBase m = AuthBase.xDummy.readMsg(this.istr);
            short sProto = m.getType();
            if (sProto == 88) {
                this.termException((AuthBase.AuthExceptionMsg)m);
            }
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"runClient", (Object)("Server requests proto (" + m.getClass() + ") : " + sProto + " (" + (char)(sProto >> 8) + ")"));
            }
            short proto = 0;
            if (this.cfgProtos != null) {
                for (int j = 0; j < this.cfgProtos.length; ++j) {
                    if (sProto != this.cfgProtos[j]) continue;
                    proto = sProto;
                    break;
                }
            }
            this.whichProto = proto;
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"runClient", (Object)("Running client with protocol: " + proto + " (" + (char)(proto >> 8) + ")"));
            }
            AuthResult result = null;
            switch (proto) {
                case 99: {
                    result = this.clntChallengeUP(m);
                    break;
                }
                case 19779: {
                    result = this.clntChallengeMPR(m);
                    break;
                }
                case 21315: {
                    result = this.clntChallengeSSLUP(m);
                    break;
                }
                case 21059: {
                    result = this.clntChallengeSSLPure(m);
                    break;
                }
                case 67: {
                    result = this.clntChallengeUP(m);
                    break;
                }
                default: {
                    this.termException(ExceptionBuilder.buildReasonString((int)813349304, (Object[])new Object[]{new Short(proto)}), 1);
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"runClient", (Object)result);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "authenticate()", result, 1);
            }
            return result;
        }
        catch (AuthException ae) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "authenticate()", ae, 1);
            }
            this.termException(ae);
        }
        catch (IOException ioe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "authenticate()", ioe, 2);
            }
            AuthException traceRet1 = new AuthException(2, (Exception)ioe, null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "authenticate()", traceRet1);
            }
            throw traceRet1;
        }
        Assert.condition((boolean)false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "authenticate()", null, 2);
        }
        return null;
    }

    protected AuthResult clntChallengeMPR(AuthBase.MsgBase m) throws AuthException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeMPR(MsgBase)", new Object[]{m});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeMPR", (Object)m);
        }
        AuthBase.ChallengeMPR c = (AuthBase.ChallengeMPR)m;
        String otherId = c.serverId;
        String otherXid = c.serverXid;
        byte[] clntRndm = AuthBase.random(20);
        String selfId = this.credentials.getName();
        String selfPassword = this.credentials.getPassword();
        String selfXid = AuthBase.transformPropObj(this.metaData);
        this.mutualPasswordMacs(selfPassword, otherId, otherXid, c.Rs, selfId, selfXid, clntRndm);
        new AuthBase.ResponseAndCounter(selfId, selfXid, clntRndm, this.macClnt).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase xr = AuthBase.xDummy.readMsg(this.istr);
        if (xr.getType() != 19791) {
            this.termWrongMsg(xr);
        }
        AuthBase.OkayResponse r = (AuthBase.OkayResponse)xr;
        if (!Arrays.equals(r.MacS, this.macServ)) {
            this.termException(ExceptionBuilder.buildReasonString((int)1231952836, null), 3);
        }
        AuthResult result = new AuthResult();
        result.authPrincipal = new DefaultPrincipal(otherId, "");
        result.authMetaData = AuthBase.transformPropString(otherXid);
        result.sharedSecret = this.sessionSecret;
        Assert.condition((this.sessionSecret != null ? 1 : 0) != 0);
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeMPR", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeMPR(MsgBase)", result);
        }
        return result;
    }

    protected AuthResult clntChallengeSSLPure(AuthBase.MsgBase m) throws AuthException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeSSLPure(MsgBase)", new Object[]{m});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeSSLPure", (Object)m);
        }
        this.sslStart(false, (short)21059);
        byte[] clntRndm = AuthBase.random(20);
        String selfId = this.credentials.getName();
        String selfXid = AuthBase.transformPropObj(this.metaData);
        new AuthBase.ReplySSLPure(selfId, "", selfXid, clntRndm).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase xr = AuthBase.xDummy.readMsg(this.istr);
        if (xr.getType() != 21071) {
            this.termWrongMsg(xr);
        }
        AuthBase.OkaySSLPure r = (AuthBase.OkaySSLPure)xr;
        String serverID = this.sslSession.extractUserID();
        if (serverID == null) {
            serverID = r.serverId;
        }
        this.sslDeriveSessionKey(this.sslSession, r.Rs, clntRndm);
        AuthResult result = new AuthResult();
        result.authPrincipal = new DefaultPrincipal(serverID, "");
        result.authMetaData = AuthBase.transformPropString(r.serverXid);
        result.sharedSecret = this.sessionSecret;
        Assert.condition((result.sharedSecret != null ? 1 : 0) != 0);
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeSSLPure", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeSSLPure(MsgBase)", result);
        }
        return result;
    }

    protected AuthResult clntChallengeSSLUP(AuthBase.MsgBase m) throws AuthException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeSSLUP(MsgBase)", new Object[]{m});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeSSLUP", (Object)m);
        }
        this.sslStart(false, (short)21315);
        byte[] clntRndm = AuthBase.random(20);
        String selfId = this.credentials.getName();
        String selfPassword = this.credentials.getPassword();
        String selfXid = AuthBase.transformPropObj(this.metaData);
        new AuthBase.ReplySSLUP(selfId, selfPassword, selfXid, clntRndm).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase xr = AuthBase.xDummy.readMsg(this.istr);
        if (xr.getType() != 21327) {
            this.termWrongMsg(xr);
        }
        AuthBase.OkaySSLUP r = (AuthBase.OkaySSLUP)xr;
        String serverID = this.sslSession.extractUserID();
        if (serverID == null) {
            serverID = r.serverId;
        }
        this.sslDeriveSessionKey(this.sslSession, r.Rs, clntRndm);
        AuthResult result = new AuthResult();
        result.authPrincipal = new DefaultPrincipal(serverID, "");
        result.authMetaData = AuthBase.transformPropString(r.serverXid);
        result.sharedSecret = this.sessionSecret;
        Assert.condition((result.sharedSecret != null ? 1 : 0) != 0);
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeSSLUP", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeSSLUP(MsgBase)", result);
        }
        return result;
    }

    protected AuthResult clntChallengeUP(AuthBase.MsgBase m) throws AuthException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeUP(MsgBase)", new Object[]{m});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeUP", (Object)m);
        }
        String selfId = this.credentials.getName();
        String selfPassword = this.credentials.getPassword();
        String selfXid = AuthBase.transformPropObj(this.metaData);
        new AuthBase.ReplyUP(selfId, selfPassword, selfXid).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase xr = AuthBase.xDummy.readMsg(this.istr);
        if (xr.getType() != 111 && xr.getType() != 79) {
            this.termWrongMsg(xr);
        }
        AuthBase.OkayUP r = (AuthBase.OkayUP)xr;
        AuthResult result = new AuthResult();
        result.authPrincipal = new DefaultPrincipal(r.serverId, "");
        result.authMetaData = AuthBase.transformPropString(r.serverXid);
        result.sharedSecret = "NOT A GOOD SECRET!".getBytes();
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeUP", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "clntChallengeUP(MsgBase)", result);
        }
        return result;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.AuthClient", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/AuthClient.java, jmscc.wmq.v6, k701, k701-112-140304  1.8.1.1 09/08/17 08:41:26");
        }
        debug = new DebugObject("AuthClient");
    }
}

