/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.direct.internal;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.crypto.export.cl3.CL3;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.impl.util.Hex;
import com.ibm.disthub2.spi.AuthException;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ISSLException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.direct.internal.AuthPrincipal;
import com.ibm.msg.client.wmq.v6.direct.internal.DefaultExceptionConstants;
import com.ibm.msg.client.wmq.v6.direct.internal.DefaultLogConstants;
import com.ibm.msg.client.wmq.v6.direct.internal.ISSL;
import com.ibm.msg.client.wmq.v6.direct.internal.ISSLSession;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Properties;

public class AuthBase
implements DefaultLogConstants,
DefaultExceptionConstants {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/AuthBase.java, jmscc.wmq.v6, k701, k701-112-140304 1.9.1.1 09/08/17 08:48:42";
    protected static final boolean AS_CLIENT = false;
    protected static final boolean AS_SERVER = true;
    protected static final short AUTH_EXCEPTION = 88;
    protected static final String CLIENT = "Client";
    protected static final byte[] closeKey;
    protected static final int DEATH_THRESHHOLD = 60;
    protected static DebugObject debug;
    protected static final short defProto = 99;
    protected static final short DUMMY = 0;
    protected static final short HEAD_REQUEST = 17480;
    protected static final int HEAD_WORD = 1212498244;
    protected static final short HELLO = 22600;
    protected static final short HELLO_old = 72;
    protected static final String HTTP_HEAD_RESPONSE_STRING = "ResponseToRequest\r\n\r\n";
    protected static final int N_RANDOM = 20;
    protected static final short OKAY_RESPONSE = 19791;
    protected static final short OKAY_SSL_PURE = 21071;
    protected static final short OKAY_SSL_UP = 21327;
    protected static final short OKAY_UP = 111;
    protected static final short OKAY_UP_pxid = 79;
    protected static final short REPLY_SSL_PURE = 21077;
    protected static final short REPLY_SSL_UP = 21333;
    protected static final short REPLY_UP = 85;
    protected static final short RESPONSE_COUNTER = 19797;
    protected static final String SERVER = "Server";
    protected static final String SESSION_KEY = "SessionKey";
    protected static final int VERSION_MAGIC = 122605;
    protected static MsgBase xDummy;
    protected short[] cfgProtos;
    protected AuthPrincipal credentials;
    protected DataInputStream istr;
    protected byte[] macClnt;
    protected byte[] macServ;
    protected Properties metaData;
    protected DataOutputStream ostr;
    protected boolean role;
    protected byte[] sessionSecret = null;
    protected Socket sock;
    protected ISSLSession sslSession;
    protected short whichProto = 0;
    protected ISSL xssl;

    protected static final byte[] bac3(byte[] a, byte[] b, byte[] c) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bac3(byte [ ],byte [ ],byte [ ])", new Object[]{a, b, c});
        }
        byte[] r = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        System.arraycopy(c, 0, r, a.length + b.length, c.length);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bac3(byte [ ],byte [ ],byte [ ])", r);
        }
        return r;
    }

    protected static final byte[] bac7(byte[] a, byte[] b, byte[] c, byte[] d, byte[] e, byte[] f, byte[] g) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bac7(byte [ ],byte [ ],byte [ ],byte [ ],byte [ ],byte [ ],byte [ ])", new Object[]{a, b, c, d, e, f, g});
        }
        byte[] r = new byte[a.length + b.length + c.length + d.length + e.length + f.length + g.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        System.arraycopy(c, 0, r, a.length + b.length, c.length);
        System.arraycopy(d, 0, r, a.length + b.length + c.length, d.length);
        System.arraycopy(e, 0, r, a.length + b.length + c.length + d.length, e.length);
        System.arraycopy(f, 0, r, a.length + b.length + c.length + d.length + e.length, f.length);
        System.arraycopy(g, 0, r, a.length + b.length + c.length + d.length + e.length + f.length, g.length);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bac7(byte [ ],byte [ ],byte [ ],byte [ ],byte [ ],byte [ ],byte [ ])", r);
        }
        return r;
    }

    protected static final byte[] bafString(String s) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bafString(String)", new Object[]{s});
        }
        try {
            byte[] traceRet1 = s.getBytes("UTF8");
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bafString(String)", traceRet1);
            }
            return traceRet1;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bafString(String)", e);
            }
            Error error = Assert.failureError();
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "bafString(String)", error);
            }
            throw error;
        }
    }

    protected static byte[] hmac(byte[] key, byte[] msg) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "hmac(byte [ ],byte [ ])", new Object[]{key, msg});
        }
        byte[] r = new byte[20];
        byte[] workKey = new byte[64];
        if (key.length > workKey.length) {
            CL3.sha(null, (byte[])key, (int)0, (int)key.length, (byte[])workKey, (int)0);
        } else {
            System.arraycopy(key, 0, workKey, 0, key.length);
        }
        int i = 0;
        while (i < workKey.length) {
            int n = i++;
            workKey[n] = (byte)(workKey[n] ^ 0x36);
        }
        CL3 istate = CL3.shaInit(null);
        CL3.sha((CL3)istate, (byte[])workKey, (int)0, (int)workKey.length, null, (int)0);
        CL3 ostate = CL3.shaInit(null);
        i = 0;
        while (i < workKey.length) {
            int n = i++;
            workKey[n] = (byte)(workKey[n] ^ 0x6A);
        }
        CL3.sha((CL3)ostate, (byte[])workKey, (int)0, (int)workKey.length, null, (int)0);
        CL3.sha((CL3)istate, (byte[])msg, (int)0, (int)msg.length, (byte[])r, (int)0);
        CL3.sha((CL3)ostate, (byte[])r, (int)0, (int)20, (byte[])r, (int)0);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "hmac(byte [ ],byte [ ])", r);
        }
        return r;
    }

    public static short[] parseAuthProtocols(String spec) throws AuthException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "parseAuthProtocols(String)", new Object[]{spec});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"parseAuthProtocols", (Object)spec);
        }
        if (spec == null || spec.length() == 0) {
            AuthException traceRet1 = new AuthException(1, (Exception)new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)1100607165, null)), null);
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "parseAuthProtocols(String)", (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        int len = spec.length();
        short[] authProtocols = new short[len + 1];
        int bc = 0;
        block6: for (int i = 0; i < len; ++i) {
            switch (spec.charAt(i)) {
                case 'M': {
                    authProtocols[i] = 19779;
                    continue block6;
                }
                case 'S': {
                    authProtocols[i] = 21315;
                    continue block6;
                }
                case 'R': {
                    authProtocols[i] = 21059;
                    continue block6;
                }
                case 'P': {
                    authProtocols[i] = 99;
                    bc = 67;
                    continue block6;
                }
                default: {
                    AuthException traceRet2 = new AuthException(1, (Exception)new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)1191761697, (Object[])new Object[]{new Character(spec.charAt(i))})), null);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "parseAuthProtocols(String)", (Throwable)traceRet2, 2);
                    }
                    throw traceRet2;
                }
            }
        }
        authProtocols[len] = bc;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"parseAuthProtocols", (Object)authProtocols);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "parseAuthProtocols(String)", authProtocols);
        }
        return authProtocols;
    }

    protected static byte[] random(int n) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "random(int)", new Object[]{new Integer(n)});
        }
        byte[] r = new byte[n];
        CL3.rng(null, (byte[])r, (int)0, (int)n);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "random(int)", r);
        }
        return r;
    }

    protected static byte[] readSBA(DataInputStream oi) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "readSBA(DataInputStream)", new Object[]{oi});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"readSBA", (Object)oi);
        }
        int n = oi.readUnsignedShort();
        byte[] b = new byte[n];
        oi.readFully(b);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"readSBA", (Object)b);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "readSBA(DataInputStream)", b);
        }
        return b;
    }

    public static boolean SSLrequired(short[] protocols) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "SSLrequired(short [ ])", new Object[]{protocols});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"SSLrequired", (Object)protocols);
        }
        for (int i = 0; i < protocols.length; ++i) {
            switch (protocols[i]) {
                case 21059: 
                case 21315: {
                    if (debug.debugIt(64)) {
                        debug.debug(-142394261359015L, (Object)"SSLrequired", (Object)new Boolean(true));
                    }
                    if (Trace.isOn) {
                        Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "SSLrequired(short [ ])", true, 1);
                    }
                    return true;
                }
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"SSLrequired", (Object)new Boolean(false));
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "SSLrequired(short [ ])", false, 2);
        }
        return false;
    }

    protected static String transformPropObj(Properties obj) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropObj(Properties)", new Object[]{obj});
        }
        StringBuffer result = new StringBuffer();
        Enumeration<?> i = obj.propertyNames();
        while (i.hasMoreElements()) {
            char next;
            int j;
            String propName = (String)i.nextElement();
            String value = obj.getProperty(propName);
            StringBuffer temp = new StringBuffer();
            for (j = 0; j < propName.length(); ++j) {
                next = propName.charAt(j);
                if (next == '\\') {
                    temp.append("\\\\");
                    continue;
                }
                if (next == '=') {
                    temp.append("\\=");
                    continue;
                }
                temp.append(next);
            }
            propName = temp.toString();
            temp = new StringBuffer();
            for (j = 0; j < value.length(); ++j) {
                next = value.charAt(j);
                if (next == '\\') {
                    temp.append("\\\\");
                    continue;
                }
                if (next == ']') {
                    temp.append("\\]");
                    continue;
                }
                temp.append(next);
            }
            value = temp.toString();
            result.append("[");
            result.append(propName);
            result.append("=");
            result.append(value);
            result.append("]");
        }
        String toReturn = result.toString();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropObj(Properties)", (Object)toReturn);
        }
        return toReturn;
    }

    protected static Properties transformPropString(String obj) throws IllegalArgumentException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropString(String)", new Object[]{obj});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"transformPropString", (Object)obj);
        }
        Properties result = new Properties();
        for (int i = 0; i < obj.length(); ++i) {
            int j;
            StringBuffer name = new StringBuffer();
            StringBuffer value = new StringBuffer();
            if (obj.charAt(i++) != '[') {
                IllegalArgumentException traceRet1 = new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)-1295122870, (Object[])new Object[]{obj}));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropString(String)", traceRet1, 1);
                }
                throw traceRet1;
            }
            for (j = i; j < obj.length() && obj.charAt(j) != '=' && (obj.charAt(j) != '\\' || ++j != obj.length()); ++j) {
                name.append(obj.charAt(j));
            }
            if (j >= obj.length()) {
                IllegalArgumentException traceRet2 = new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)-1295122870, (Object[])new Object[]{obj}));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropString(String)", traceRet2, 2);
                }
                throw traceRet2;
            }
            for (j = i = j + 1; j < obj.length() && obj.charAt(j) != ']' && (obj.charAt(j) != '\\' || ++j != obj.length()); ++j) {
                value.append(obj.charAt(j));
            }
            if (j >= obj.length()) {
                IllegalArgumentException traceRet3 = new IllegalArgumentException(ExceptionBuilder.buildReasonString((int)-1295122870, (Object[])new Object[]{obj}));
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropString(String)", traceRet3, 3);
                }
                throw traceRet3;
            }
            result.setProperty(name.toString(), value.toString());
            i = j;
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"transformPropString", (Object)result);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "transformPropString(String)", result);
        }
        return result;
    }

    protected static void writeSBA(byte[] b, DataOutput oo) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "writeSBA(byte [ ],DataOutput)", new Object[]{b, oo});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"writeSBA", (Object)b, (Object)oo);
        }
        oo.writeShort(b.length);
        oo.write(b);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"writeSBA");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "writeSBA(byte [ ],DataOutput)");
        }
    }

    protected AuthBase() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "<init>()");
        }
    }

    void cleanup() throws IOException {
        block17: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "cleanup()");
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"cleanup");
            }
            this.istr = null;
            if (this.ostr != null) {
                try {
                    this.close_ostr();
                }
                catch (Exception e) {
                    if (!Trace.isOn) break block17;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "cleanup()", e);
                }
            }
        }
        if (this.sslSession != null) {
            this.sslSession.getSocket().close();
            if (!this.role) {
                DataOutputStream out = new DataOutputStream(this.sock.getOutputStream());
                out.write(closeKey);
                out.flush();
                DataInputStream in = new DataInputStream(this.sock.getInputStream());
                byte[] next = new byte[1];
                int count = 0;
                while (in.read(next) != -1) {
                    if (next[0] == closeKey[count]) {
                        if (++count != closeKey.length) continue;
                        if (Trace.isOn) {
                            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "cleanup()", 1);
                        }
                        return;
                    }
                    count = 0;
                }
                this.sock.close();
                IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)-1731999971, null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "cleanup()", traceRet1, 1);
                }
                throw traceRet1;
            }
            DataInputStream in = new DataInputStream(this.sock.getInputStream());
            byte[] next = new byte[1];
            int count = 0;
            while (in.read(next) != -1) {
                if (next[0] == closeKey[count]) {
                    if (++count != closeKey.length) continue;
                    break;
                }
                count = 0;
            }
            if (count != closeKey.length) {
                this.sock.close();
                IOException traceRet2 = new IOException(ExceptionBuilder.buildReasonString((int)-1731999971, null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "cleanup()", traceRet2, 2);
                }
                throw traceRet2;
            }
            DataOutputStream out = new DataOutputStream(this.sock.getOutputStream());
            out.write(closeKey);
            out.flush();
        }
        this.sslSession = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"cleanup");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "cleanup()", 2);
        }
    }

    protected void close_ostr() throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "close_ostr()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"close_ostr");
        }
        if (this.ostr != null) {
            this.ostr.flush();
        }
        this.ostr = null;
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"close_ostr");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "close_ostr()");
        }
    }

    protected void mutualPasswordMacs(String pw, String servId, String servXid, byte[] servRndm, String clntId, String clntXid, byte[] clntRndm) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "mutualPasswordMacs(String,String,String,byte [ ],String,String,byte [ ])", new Object[]{pw, servId, servXid, servRndm, clntId, clntXid, clntRndm});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"mutualPasswordMacs", (Object)"********", (Object)servId, (Object)servXid, (Object)servRndm, (Object)clntId, (Object)clntXid, (Object)clntRndm);
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"mutualPasswordMacs", (Object)("MutualPasswordMacs w/ pw = " + pw + ",\n\t servId = " + servId + ", servXid = " + servXid + ", servRndm = " + servRndm + ",\n\t clientId = " + clntId + ", clntXid = " + clntXid + ", clntRndm = " + clntRndm));
        }
        byte[] bafServId = AuthBase.bafString(servId);
        byte[] bafServXid = AuthBase.bafString(servXid);
        byte[] bafClntId = AuthBase.bafString(clntId);
        byte[] bafClntXid = AuthBase.bafString(clntXid);
        byte[] bafClient = AuthBase.bafString(CLIENT);
        byte[] thingC = AuthBase.bac7(bafServId, bafServXid, servRndm, bafClntId, bafClntXid, clntRndm, bafClient);
        byte[] bafPw = AuthBase.bafString(pw);
        this.macClnt = AuthBase.hmac(bafPw, thingC);
        byte[] bafServer = AuthBase.bafString(SERVER);
        byte[] thingS = AuthBase.bac7(bafServId, bafServXid, servRndm, bafClntId, bafClntXid, clntRndm, bafServer);
        this.macServ = AuthBase.hmac(bafPw, thingS);
        byte[] bafSessionKey = AuthBase.bafString(SESSION_KEY);
        byte[] thingK = AuthBase.bac7(bafServId, bafServXid, servRndm, bafClntId, bafClntXid, clntRndm, bafSessionKey);
        this.sessionSecret = AuthBase.hmac(bafPw, thingK);
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"mutualPasswordMacs", (Object)("Result, macClnt: " + Hex.toString((byte[])this.macClnt) + " macServ: " + Hex.toString((byte[])this.macServ) + " sessionSecret: " + Hex.toString((byte[])this.sessionSecret)));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"mutualPasswordMacs");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "mutualPasswordMacs(String,String,String,byte [ ],String,String,byte [ ])");
        }
    }

    void setupDataStreams() throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "setupDataStreams()");
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setupDataStreams");
        }
        this.istr = new DataInputStream(this.sock.getInputStream());
        this.ostr = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream(), 1024));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setupDataStreams");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "setupDataStreams()");
        }
    }

    protected void sslDeriveSessionKey(ISSLSession session, byte[] servRndm, byte[] clntRndm) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "sslDeriveSessionKey(ISSLSession,byte [ ],byte [ ])", new Object[]{session, servRndm, clntRndm});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"sslDeriveSessionKey", (Object)session, (Object)servRndm, (Object)clntRndm);
        }
        byte[] bafSessionKey = AuthBase.bafString(SESSION_KEY);
        byte[] thingK = AuthBase.bac3(servRndm, clntRndm, bafSessionKey);
        byte[] ms = session.getMasterSecret();
        if (ms == null) {
            byte[] dum = new byte[]{1, 2, 3, 4, 5};
            ms = dum;
        }
        this.sessionSecret = AuthBase.hmac(ms, thingK);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"sslDeriveSessionKey");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "sslDeriveSessionKey(ISSLSession,byte [ ],byte [ ])");
        }
    }

    protected void sslStart(boolean role, short proto) throws IOException, AuthException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "sslStart(boolean,short)", new Object[]{role, new Short(proto)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"sslStart", (Object)new Boolean(role), (Object)new Short(proto));
        }
        Assert.condition((this.xssl != null ? 1 : 0) != 0);
        try {
            this.sslSession = this.xssl.createSession(this.sock, this.credentials.getSSLCredentials(), role, proto == 21059);
        }
        catch (ISSLException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "sslStart(boolean,short)", e);
            }
            AuthException traceRet1 = new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)1536360197, (Object[])new Object[]{e})), null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "sslStart(boolean,short)", (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.istr = new DataInputStream(this.sslSession.getSocket().getInputStream());
        this.ostr = new DataOutputStream(new BufferedOutputStream(this.sslSession.getSocket().getOutputStream(), 1024));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"sslStart");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "sslStart(boolean,short)");
        }
    }

    void termException(AuthException ae) throws AuthException {
        block9: {
            block8: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthException)", new Object[]{ae});
                }
                if (debug.debugIt(32)) {
                    debug.debug(-165922073994779L, (Object)"termException", (Object)ae);
                }
                if (this.ostr != null) {
                    try {
                        new AuthExceptionMsg(ae).writeMsg(this.ostr);
                        this.close_ostr();
                    }
                    catch (Exception x) {
                        if (!Trace.isOn) break block8;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthException)", x, 1);
                    }
                }
            }
            try {
                this.cleanup();
            }
            catch (IOException e) {
                if (!Trace.isOn) break block9;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthException)", e, 2);
            }
        }
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthException)", (Throwable)ae);
        }
        throw ae;
    }

    void termException(AuthExceptionMsg em) throws AuthException {
        block7: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthExceptionMsg)", new Object[]{em});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"termException", (Object)em);
            }
            if (debug.debugIt(2)) {
                debug.debug(-175584356845707L, (Object)"termException", (Object)("Terminating with exception: " + em.getMessage()));
            }
            try {
                this.close_ostr();
            }
            catch (Exception x) {
                if (!Trace.isOn) break block7;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthExceptionMsg)", x);
            }
        }
        this.termException(new AuthException(em.getCode(), (Exception)new RuntimeException(em.getMessage()), null));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"termException");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(AuthExceptionMsg)");
        }
    }

    void termException(String reason, int c) throws AuthException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(String,int)", new Object[]{reason, new Integer(c)});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"termException", (Object)reason, (Object)new Integer(c));
        }
        this.termException(new AuthException(c, (Exception)new RuntimeException(reason), null));
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"termException");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termException(String,int)");
        }
    }

    void termWrongMsg(MsgBase m) throws AuthException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termWrongMsg(MsgBase)", new Object[]{m});
        }
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"termWrongMessage", (Object)m);
        }
        if (m instanceof AuthExceptionMsg) {
            this.termException((AuthExceptionMsg)m);
        }
        this.termException(ExceptionBuilder.buildReasonString((int)1970506625, (Object[])new Object[]{new Short(m.getType())}), 1);
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"termWrongMsg");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "termWrongMsg(MsgBase)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.direct.internal.AuthBase", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/direct/internal/AuthBase.java, jmscc.wmq.v6, k701, k701-112-140304  1.9.1.1 09/08/17 08:48:42");
        }
        closeKey = new byte[]{84, 72, 73, 83, 55, 73, 83, 56, 68, 85, 77, 66, 49, 50, 51, 52};
        debug = new DebugObject("AuthBase");
        xDummy = new MsgBase();
    }

    protected static class ResponseAndCounter
    extends MsgBase {
        byte[] MacC;
        byte[] Rc;
        String userid;
        String xid;

        ResponseAndCounter(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "<init>(DataInputStream)");
            }
        }

        ResponseAndCounter(String u, String x, byte[] r, byte[] m) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "<init>(String,String,byte [ ],byte [ ])", new Object[]{u, x, r, m});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ResponseAndCounter", (Object)u, (Object)x, (Object)r, (Object)m);
            }
            this.userid = u;
            this.xid = x;
            this.Rc = r;
            this.MacC = m;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ResponseAndCounter");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "<init>(String,String,byte [ ],byte [ ])");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "getType()", "getter", new Short(19797));
            }
            return 19797;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.userid = oi.readUTF();
            this.xid = oi.readUTF();
            this.Rc = AuthBase.readSBA(oi);
            this.MacC = AuthBase.readSBA(oi);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeUTF(this.userid);
            oo.writeUTF(this.xid);
            AuthBase.writeSBA(this.Rc, oo);
            AuthBase.writeSBA(this.MacC, oo);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ResponseAndCounter", "writeBody(DataOutput)");
            }
        }
    }

    protected static class ReplyUP
    extends MsgBase {
        String password;
        String userid;
        String xid;

        ReplyUP(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "<init>(DataInputStream)");
            }
        }

        ReplyUP(String u, String p, String x) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "<init>(String,String,String)", new Object[]{u, p, x});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ReplyUP", (Object)u, (Object)"********", (Object)x);
            }
            this.userid = u;
            this.password = p;
            this.xid = x;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ReplyUP");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "<init>(String,String,String)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "getType()", "getter", new Short(85));
            }
            return 85;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.userid = oi.readUTF();
            this.password = oi.readUTF();
            this.xid = oi.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeUTF(this.userid);
            oo.writeUTF(this.password);
            oo.writeUTF(this.xid);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplyUP", "writeBody(DataOutput)");
            }
        }
    }

    protected static class ReplySSLUP
    extends MsgBase {
        String password;
        byte[] Rc;
        String userid;
        String xid;

        ReplySSLUP(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "<init>(DataInputStream)");
            }
        }

        ReplySSLUP(String u, String p, String x, byte[] r) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "<init>(String,String,String,byte [ ])", new Object[]{u, p, x, r});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ReplySSLUP", (Object)u, (Object)"********", (Object)x, (Object)r);
            }
            this.userid = u;
            this.password = p;
            this.xid = x;
            this.Rc = r;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ReplySSLUP");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "<init>(String,String,String,byte [ ])");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "getType()", "getter", new Short(21333));
            }
            return 21333;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.userid = oi.readUTF();
            this.password = oi.readUTF();
            this.xid = oi.readUTF();
            this.Rc = AuthBase.readSBA(oi);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeUTF(this.userid);
            oo.writeUTF(this.password);
            oo.writeUTF(this.xid);
            AuthBase.writeSBA(this.Rc, oo);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLUP", "writeBody(DataOutput)");
            }
        }
    }

    protected static class ReplySSLPure
    extends ReplySSLUP {
        ReplySSLPure(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLPure", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLPure", "<init>(DataInputStream)");
            }
        }

        ReplySSLPure(String u, String p, String x, byte[] r) {
            super(u, p, x, r);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLPure", "<init>(String,String,String,byte [ ])", new Object[]{u, p, x, r});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLPure", "<init>(String,String,String,byte [ ])");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ReplySSLPure", "getType()", "getter", new Short(21077));
            }
            return 21077;
        }
    }

    protected static class OkayUP_pxid
    extends OkayUP {
        OkayUP_pxid() {
            super(null, null);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "<init>()");
            }
        }

        OkayUP_pxid(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "getType()", "getter", new Short(79));
            }
            return 79;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP_pxid", "writeBody(DataOutput)");
            }
        }
    }

    protected static class OkayUP
    extends MsgBase {
        String serverId;
        String serverXid;

        OkayUP(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "<init>(DataInputStream)");
            }
        }

        OkayUP(String s, String x) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "<init>(String,String)", new Object[]{s, x});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"OkayUP", (Object)s, (Object)x);
            }
            this.serverId = s;
            this.serverXid = x;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"OkayUP");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "<init>(String,String)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "getType()", "getter", new Short(111));
            }
            return 111;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.serverId = oi.readUTF();
            this.serverXid = oi.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeUTF(this.serverId);
            oo.writeUTF(this.serverXid);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayUP", "writeBody(DataOutput)");
            }
        }
    }

    protected static class OkaySSLUP
    extends MsgBase {
        byte[] Rs;
        String serverId;
        String serverXid;

        OkaySSLUP(byte[] r, String s, String x) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "<init>(byte [ ],String,String)", new Object[]{r, s, x});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"OkaySSLUP", (Object)r, (Object)s, (Object)x);
            }
            this.Rs = r;
            this.serverId = s;
            this.serverXid = x;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"OkaySSLUP");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "<init>(byte [ ],String,String)");
            }
        }

        OkaySSLUP(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "getType()", "getter", new Short(21327));
            }
            return 21327;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.Rs = AuthBase.readSBA(oi);
            this.serverId = oi.readUTF();
            this.serverXid = oi.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            AuthBase.writeSBA(this.Rs, oo);
            oo.writeUTF(this.serverId);
            oo.writeUTF(this.serverXid);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLUP", "writeBody(DataOutput)");
            }
        }
    }

    protected static class OkaySSLPure
    extends OkaySSLUP {
        OkaySSLPure(byte[] r, String s, String x) {
            super(r, s, x);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLPure", "<init>(byte [ ],String,String)", new Object[]{r, s, x});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLPure", "<init>(byte [ ],String,String)");
            }
        }

        OkaySSLPure(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLPure", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLPure", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkaySSLPure", "getType()", "getter", new Short(21071));
            }
            return 21071;
        }
    }

    protected static class OkayResponse
    extends MsgBase {
        byte[] MacS;

        OkayResponse(byte[] m) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "<init>(byte [ ])", new Object[]{m});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"OkayResponse", (Object)m);
            }
            this.MacS = m;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"OkayResponse");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "<init>(byte [ ])");
            }
        }

        OkayResponse(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "<init>(DataInputStream)");
            }
        }

        public byte[] getMacBytes() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "getMacBytes()", "getter", this.MacS);
            }
            return this.MacS;
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "getType()", "getter", new Short(19791));
            }
            return 19791;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.MacS = AuthBase.readSBA(oi);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            AuthBase.writeSBA(this.MacS, oo);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.OkayResponse", "writeBody(DataOutput)");
            }
        }
    }

    protected static class MsgBase {
        MsgBase() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "<init>()");
            }
        }

        protected MsgBase(DataInputStream oi) throws IOException, AuthException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"MsgBase", (Object)oi);
            }
            this.readBody(oi);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"MsgBase");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "getType()", "getter", new Short(0));
            }
            return 0;
        }

        public void readBody(DataInputStream oi) throws IOException, AuthException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readBody(DataInputStream)");
            }
        }

        MsgBase readMsg(DataInputStream oi) throws IOException, AuthException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readMsg(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readMsg", (Object)oi);
            }
            int verm = oi.readInt();
            MsgBase result = null;
            if (122605 != verm) {
                int n;
                byte[] wrong;
                block33: {
                    if (verm == 1212498244) {
                        result = new HeadRequest(oi);
                        if (debug.debugIt(64)) {
                            debug.debug(-142394261359015L, (Object)"readMsg", (Object)result);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readMsg(DataInputStream)", result, 1);
                        }
                        return result;
                    }
                    wrong = new byte[60];
                    wrong[0] = (byte)(verm >> 24);
                    wrong[1] = (byte)(verm >> 16);
                    wrong[2] = (byte)(verm >> 8);
                    wrong[3] = (byte)verm;
                    n = 4;
                    try {
                        if (oi.available() > 0) {
                            n += oi.read(wrong, n, wrong.length - n);
                        }
                    }
                    catch (Exception x) {
                        if (!Trace.isOn) break block33;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readMsg(DataInputStream)", x);
                    }
                }
                AuthException traceRet1 = new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)1023917489, (Object[])new Object[]{Hex.dumpString((byte[])wrong, (int)0, (int)n)})), null);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readMsg(DataInputStream)", (Throwable)traceRet1, 1);
                }
                throw traceRet1;
            }
            short type = oi.readShort();
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"readMsg", (Object)("Received msg type: " + type));
            }
            switch (type) {
                case 88: {
                    result = new AuthExceptionMsg(oi);
                    break;
                }
                case 72: {
                    result = new Hello(oi, 67);
                    break;
                }
                case 22600: {
                    result = new Hello(oi);
                    break;
                }
                case 99: {
                    result = new ChallengeUP(oi);
                    break;
                }
                case 67: {
                    result = new ChallengeUP_pxid(oi);
                    break;
                }
                case 85: {
                    result = new ReplyUP(oi);
                    break;
                }
                case 111: {
                    result = new OkayUP(oi);
                    break;
                }
                case 79: {
                    result = new OkayUP_pxid(oi);
                    break;
                }
                case 19779: {
                    result = new ChallengeMPR(oi);
                    break;
                }
                case 19797: {
                    result = new ResponseAndCounter(oi);
                    break;
                }
                case 19791: {
                    result = new OkayResponse(oi);
                    break;
                }
                case 21315: {
                    result = new ChallengeSSLUP(oi);
                    break;
                }
                case 21333: {
                    result = new ReplySSLUP(oi);
                    break;
                }
                case 21327: {
                    result = new OkaySSLUP(oi);
                    break;
                }
                case 21059: {
                    result = new ChallengeSSLPure(oi);
                    break;
                }
                case 21077: {
                    result = new ReplySSLPure(oi);
                    break;
                }
                case 21071: {
                    result = new OkaySSLPure(oi);
                    break;
                }
                default: {
                    AuthException traceRet2 = new AuthException(1, (Exception)new RuntimeException(ExceptionBuilder.buildReasonString((int)-640421958, (Object[])new Object[]{new Short(type)})), null);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readMsg(DataInputStream)", (Throwable)traceRet2, 2);
                    }
                    throw traceRet2;
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readMsg", (Object)result);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "readMsg(DataInputStream)", result, 2);
            }
            return result;
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "writeBody(DataOutput)");
            }
        }

        public void writeMsg(DataOutputStream oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "writeMsg(DataOutputStream)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeMsg", (Object)oo);
            }
            oo.writeInt(122605);
            oo.writeShort(this.getType());
            this.writeBody(oo);
            oo.flush();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeMsg");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.MsgBase", "writeMsg(DataOutputStream)");
            }
        }
    }

    protected static class Hello
    extends MsgBase {
        short[] protos;

        Hello(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "<init>(DataInputStream)");
            }
        }

        Hello(DataInputStream oi, short proto) throws IOException, AuthException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "<init>(DataInputStream,short)", new Object[]{oi, new Short(proto)});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"Hello", (Object)oi, (Object)new Short(proto));
            }
            this.protos = new short[]{proto};
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"Hello");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "<init>(DataInputStream,short)");
            }
        }

        Hello(short[] P) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "<init>(short [ ])", new Object[]{P});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"Hello", (Object)P);
            }
            this.protos = P != null ? P : new short[]{99};
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"Hello");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "<init>(short [ ])");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "getType()", "getter", new Short(22600));
            }
            return 22600;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            int n = oi.readUnsignedShort();
            this.protos = new short[n];
            for (int i = 0; i < n; ++i) {
                this.protos[i] = oi.readShort();
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeShort(this.protos.length);
            for (int i = 0; i < this.protos.length; ++i) {
                oo.writeShort(this.protos[i]);
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.Hello", "writeBody(DataOutput)");
            }
        }
    }

    protected static class HeadRequest
    extends MsgBase {
        HeadRequest(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "getType()", "getter", new Short(17480));
            }
            return 17480;
        }

        public void readBody(DataInputStream oi) throws IOException {
            byte four;
            byte three;
            byte two;
            byte one;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            int count = 0;
            do {
                one = oi.readByte();
                if (count++ <= 60) continue;
                IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)-900202921, null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "readBody(DataInputStream)", traceRet1);
                }
                throw traceRet1;
            } while (one != 13 || (two = oi.readByte()) != 10 || (three = oi.readByte()) != 13 || (four = oi.readByte()) != 10);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            IOException traceRet1 = new IOException(ExceptionBuilder.buildReasonString((int)1604135494, null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.direct.internal.HeadRequest", "writeBody(DataOutput)", traceRet1);
            }
            throw traceRet1;
        }
    }

    protected static class ChallengeUP_pxid
    extends MsgBase {
        ChallengeUP_pxid() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP_pxid", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP_pxid", "<init>()");
            }
        }

        ChallengeUP_pxid(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP_pxid", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP_pxid", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP_pxid", "getType()", "getter", new Short(67));
            }
            return 67;
        }
    }

    protected static class ChallengeUP
    extends MsgBase {
        ChallengeUP() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP", "<init>()");
            }
        }

        ChallengeUP(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeUP", "getType()", "getter", new Short(99));
            }
            return 99;
        }
    }

    protected static class ChallengeSSLUP
    extends ChallengeUP {
        ChallengeSSLUP() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLUP", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLUP", "<init>()");
            }
        }

        ChallengeSSLUP(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLUP", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLUP", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLUP", "getType()", "getter", new Short(21315));
            }
            return 21315;
        }
    }

    protected static class ChallengeSSLPure
    extends ChallengeUP {
        ChallengeSSLPure() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLPure", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLPure", "<init>()");
            }
        }

        ChallengeSSLPure(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLPure", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLPure", "<init>(DataInputStream)");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeSSLPure", "getType()", "getter", new Short(21059));
            }
            return 21059;
        }
    }

    protected static class ChallengeMPR
    extends MsgBase {
        byte[] Rs;
        String serverId;
        String serverXid;

        ChallengeMPR(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "<init>(DataInputStream)");
            }
        }

        ChallengeMPR(String s, String x, byte[] r) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "<init>(String,String,byte [ ])", new Object[]{s, x, r});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"ChallengeMPR", (Object)s, (Object)x, (Object)r);
            }
            this.serverId = s;
            this.serverXid = x;
            this.Rs = r;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"ChallengeMPR");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "<init>(String,String,byte [ ])");
            }
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "getType()", "getter", new Short(19779));
            }
            return 19779;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.serverId = oi.readUTF();
            this.serverXid = oi.readUTF();
            this.Rs = AuthBase.readSBA(oi);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "readBody(DataInputStream)");
            }
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeUTF(this.serverId);
            oo.writeUTF(this.serverXid);
            AuthBase.writeSBA(this.Rs, oo);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.ChallengeMPR", "writeBody(DataOutput)");
            }
        }
    }

    protected static class AuthExceptionMsg
    extends MsgBase {
        int code;
        String reason;

        AuthExceptionMsg(AuthException e) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "<init>(AuthException)", new Object[]{e});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"AuthExceptionMsg", (Object)e);
            }
            this.code = e.code;
            this.reason = e.wrapped != null ? e.wrapped.getMessage() : "";
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"AuthExceptionMsg");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "<init>(AuthException)");
            }
        }

        AuthExceptionMsg(DataInputStream oi) throws IOException, AuthException {
            super(oi);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "<init>(DataInputStream)", new Object[]{oi});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "<init>(DataInputStream)");
            }
        }

        AuthExceptionMsg(int c, String r) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "<init>(int,String)", new Object[]{new Integer(c), r});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"AuthExceptionMsg", (Object)new Integer(c), (Object)r);
            }
            this.code = c;
            this.reason = r;
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"AuthExceptionMsg");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "<init>(int,String)");
            }
        }

        int getCode() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "getCode()", "getter", new Integer(this.code));
            }
            return this.code;
        }

        String getMessage() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "getMessage()", "getter", this.reason);
            }
            return this.reason;
        }

        public short getType() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "getType()", "getter", new Short(88));
            }
            return 88;
        }

        public void readBody(DataInputStream oi) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "readBody(DataInputStream)", new Object[]{oi});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"readBody", (Object)oi);
            }
            this.code = oi.readInt();
            this.reason = oi.readUTF();
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"readBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "readBody(DataInputStream)");
            }
        }

        public String toString() {
            String traceRet1 = "code=" + this.code + ", reason=" + this.reason;
            return traceRet1;
        }

        public void writeBody(DataOutput oo) throws IOException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "writeBody(DataOutput)", new Object[]{oo});
            }
            if (debug.debugIt(32)) {
                debug.debug(-165922073994779L, (Object)"writeBody", (Object)oo);
            }
            oo.writeInt(this.code);
            oo.writeUTF(this.reason);
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"writeBody");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.direct.internal.AuthExceptionMsg", "writeBody(DataOutput)");
            }
        }
    }
}

