/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.internal.JmqiResource;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQXAVerbs;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MQXAResource
implements XAResource {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int nextRMID;
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQXAResource.java, jmscc.wmq.v6, k701, k701-112-140304 1.27.1.1 09/08/17 08:05:04";
    private boolean closed = false;
    private boolean debugXA = false;
    private boolean impEndFlag = false;
    private String qmgrName;
    private int rmid;
    private MQXAVerbs session = null;

    static Exception createXAException(int errorCode, String msg) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "createXAException(int,String)", new Object[]{new Integer(errorCode), msg});
        }
        XAException xae = new XAException(msg);
        xae.errorCode = errorCode;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "createXAException(int,String)", xae);
        }
        return xae;
    }

    private static synchronized int getNextRMID() {
        int traceRet1 = nextRMID++;
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "getNextRMID()", "getter", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public MQXAResource(MQXAVerbs session, String qmgrName) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", new Object[]{session, qmgrName});
        }
        try {
            int res;
            this.qmgrName = qmgrName;
            this.session = session;
            this.rmid = MQXAResource.getNextRMID();
            try {
                res = session.XAOPEN(qmgrName, this.rmid, 0);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", e, 1);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", traceRet1, 2);
                }
                throw traceRet1;
            }
            if (res != 0) {
                String[] inserts = new String[]{"xa_open", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", e, 3);
                }
                throw e;
            }
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)", e, 4);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "<init>(MQXAVerbs,String)");
        }
    }

    public void close() throws XAException {
        block20: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()");
            }
            try {
                if (this.debugXA) {
                    System.out.println(this + " close()");
                }
                if (!this.closed) {
                    int res;
                    try {
                        res = this.session.XACLOSE(this.qmgrName, this.rmid, 0);
                    }
                    catch (RuntimeException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", e, 1);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", e, 1);
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", e, 2);
                        }
                        XAException traceRet1 = (XAException)e;
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", traceRet1, 2);
                        }
                        throw traceRet1;
                    }
                    if (res != 0) {
                        String[] inserts = new String[]{"xa_close", Integer.toString(res)};
                        String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                        XAException e = new XAException(msg);
                        e.errorCode = res;
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", e, 3);
                        }
                        throw e;
                    }
                    this.closed = true;
                    this.session = null;
                    break block20;
                }
                if (this.debugXA) {
                    System.out.println(this + " was already closed");
                }
                if (Trace.isOn) {
                    Trace.traceData(this, " already closed", null);
                }
            }
            catch (XAException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", e, 3);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "errorCode=" + e.errorCode, null);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()", e, 4);
                }
                throw e;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "close()");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", new Object[]{xid, onePhase});
        }
        try {
            int res;
            if (this.debugXA) {
                System.out.println(this + " commit(" + xid + ", " + onePhase + ")");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 1);
                }
                throw e;
            }
            int flags = onePhase ? 0x40000000 : 0;
            try {
                res = this.session.XACOMMIT(xid, this.rmid, flags);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res != 0 && res != 3) {
                String[] inserts = new String[]{"xa_commit", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 4);
                }
                throw e;
            }
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "commit(Xid,boolean)");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", new Object[]{xid, new Integer(flags)});
        }
        try {
            int res;
            if (this.debugXA) {
                System.out.println(this + " end(" + xid + ")");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 1);
                }
                throw e;
            }
            try {
                res = this.session.XAEND(xid, this.rmid, flags);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res != 0) {
                String[] inserts = new String[]{"xa_end", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 4);
                }
                throw e;
            }
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "end(Xid,int)");
        }
    }

    public void finalize() throws Throwable {
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "finalize()");
            }
            if (this.debugXA) {
                System.out.println(this.toString() + ".finalize()");
            }
            try {
                this.close();
            }
            catch (XAException e) {
                if (!Trace.isOn) break block5;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "finalize()", e);
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "finalize()");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", new Object[]{xid});
        }
        try {
            int res;
            if (this.debugXA) {
                System.out.println(this + " forget(" + xid + ")");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 1);
                }
                throw e;
            }
            try {
                res = this.session.XAFORGET(xid, this.rmid, 0);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res != 0) {
                String[] inserts = new String[]{"xa_forget", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 4);
                }
                throw e;
            }
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "forget(Xid)");
        }
    }

    public String getResourceString() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "getResourceString()", "getter", this.qmgrName);
        }
        return this.qmgrName;
    }

    public int getTransactionTimeout() throws XAException {
        int traceRet1 = -1;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "getTransactionTimeout()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "isSameRM(XAResource)", new Object[]{xares});
        }
        if (this.debugXA) {
            System.out.println(this + " isSameRM()");
        }
        if (this.closed) {
            String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
            XAException e = new XAException(msg);
            e.errorCode = -6;
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "isSameRM(XAResource)", e);
            }
            throw e;
        }
        if (xares instanceof MQXAResource) {
            boolean traceRet1 = this.qmgrName.equals(((MQXAResource)xares).qmgrName);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "isSameRM(XAResource)", traceRet1, 1);
            }
            return traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "isSameRM(XAResource)", false, 2);
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", new Object[]{xid});
        }
        try {
            int res;
            if (this.debugXA) {
                System.out.println(this + " prepare(" + xid + ")");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 1);
                }
                throw e;
            }
            try {
                res = this.session.XAPREPARE(xid, this.rmid, 0);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res != 0 && res != 3) {
                String[] inserts = new String[]{"xa_prepare", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 4);
                }
                throw e;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", new Integer(res));
            }
            return res;
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "prepare(Xid)", e, 5);
            }
            throw e;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", new Object[]{new Integer(flag)});
        }
        Xid[] xids = new Xid[10];
        try {
            Xid[] result;
            int res;
            int internalFlag;
            if (this.debugXA) {
                System.out.println(this + " recover()");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 1);
                }
                throw e;
            }
            boolean prevImpEndFlag = this.impEndFlag;
            this.impEndFlag = false;
            switch (flag) {
                case 0x800000: {
                    internalFlag = 0;
                    break;
                }
                case 0x1800000: {
                    internalFlag = 0x1000000;
                    break;
                }
                default: {
                    internalFlag = flag;
                }
            }
            try {
                res = this.session.XARECOVER(xids, this.rmid, internalFlag);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res < 0) {
                if (prevImpEndFlag && res == -5 && flag == 0) {
                    Xid[] traceRet2 = new Xid[]{};
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", traceRet2, 1);
                    }
                    return traceRet2;
                }
                String[] inserts = new String[]{"xa_recover", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 4);
                }
                throw e;
            }
            if (res != xids.length) {
                result = new Xid[res];
                System.arraycopy(xids, 0, result, 0, res);
                if ((flag & 0x800000) == 0) {
                    this.impEndFlag = true;
                }
            } else {
                int i;
                Vector<Xid> xidVec = new Vector<Xid>();
                boolean gotLastXid = false;
                internalFlag = 0;
                while (!gotLastXid) {
                    for (i = 0; i < res; ++i) {
                        xidVec.addElement(xids[i]);
                        xids[i] = null;
                    }
                    try {
                        res = this.session.XARECOVER(xids, this.rmid, internalFlag);
                    }
                    catch (RuntimeException e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 3);
                        }
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 5);
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 4);
                        }
                        XAException traceRet3 = (XAException)e;
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", traceRet3, 6);
                        }
                        throw traceRet3;
                    }
                    if (res < 0) {
                        String[] inserts = new String[]{"xa_recover", Integer.toString(res)};
                        String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                        XAException e = new XAException(msg);
                        e.errorCode = res;
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 7);
                        }
                        throw e;
                    }
                    if (res == xids.length) continue;
                    gotLastXid = true;
                    if ((flag & 0x800000) != 0) continue;
                    this.impEndFlag = true;
                }
                for (i = 0; i < res; ++i) {
                    xidVec.addElement(xids[i]);
                }
                result = xidVec.toArray(xids);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", result, 2);
            }
            return result;
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 5);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "recover(int)", e, 8);
            }
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", new Object[]{xid});
        }
        try {
            int res;
            if (this.debugXA) {
                System.out.println(this + " rollback(" + xid + ")");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 1);
                }
                throw e;
            }
            try {
                res = this.session.XAROLLBACK(xid, this.rmid, 0);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res != 0) {
                String[] inserts = new String[]{"xa_rollback", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 4);
                }
                throw e;
            }
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "rollback(Xid)");
        }
    }

    public void setDebugXA(boolean x) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "setDebugXA(boolean)", "setter", x);
        }
        this.debugXA = x;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "setTransactionTimeout(int)", new Object[]{new Integer(seconds)});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "setTransactionTimeout(int)", false);
        }
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", new Object[]{xid, new Integer(flags)});
        }
        try {
            int res;
            if (this.debugXA) {
                System.out.println(this + " start(" + xid + ")");
            }
            if (this.closed) {
                String msg = MQException.getNLSMsg((String)"MID_ResourceClosed");
                XAException e = new XAException(msg);
                e.errorCode = -6;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 1);
                }
                throw e;
            }
            try {
                res = this.session.XASTART(xid, this.rmid, flags);
            }
            catch (RuntimeException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 1);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 2);
                }
                throw e;
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 2);
                }
                XAException traceRet1 = (XAException)e;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", traceRet1, 3);
                }
                throw traceRet1;
            }
            if (res != 0) {
                String[] inserts = new String[]{"xa_start", Integer.toString(res)};
                String msg = JmqiResource.getString((String)"MQJE114", (String[])inserts);
                XAException e = new XAException(msg);
                e.errorCode = res;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 4);
                }
                throw e;
            }
        }
        catch (XAException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 3);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "errorCode=" + e.errorCode, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)", e, 5);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "start(Xid,int)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQXAResource", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQXAResource.java, jmscc.wmq.v6, k701, k701-112-140304  1.27.1.1 09/08/17 08:05:04");
        }
        nextRMID = 0;
    }
}

