/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.IOException;

class MQS390PackedDecimalSupport {
    private static final String clsName = "MQS390PackedDecimalSupport";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQS390PackedDecimalSupport.java, jmscc.wmq.v6, k701, k701-112-140304 1.18.1.1 09/08/17 08:04:17";

    MQS390PackedDecimalSupport() {
    }

    protected static final long convertToBinary(byte[] packedDecimalBytes) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToBinary(byte [ ])", new Object[]{packedDecimalBytes});
        }
        long retVal = 0L;
        long multiplier = 1L;
        boolean positive = true;
        for (int b = packedDecimalBytes.length - 1; b >= 0; --b) {
            byte thisByte = packedDecimalBytes[b];
            int leastSignificantDigit = thisByte & 0xF;
            int mostSignificantDigit = thisByte >>> 4 & 0xF;
            if (b == packedDecimalBytes.length - 1) {
                switch (leastSignificantDigit) {
                    case 12: {
                        positive = true;
                        break;
                    }
                    case 13: {
                        positive = false;
                        break;
                    }
                    case 15: {
                        positive = true;
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.traceData(clsName, "Invalid sign nibble: " + leastSignificantDigit, null);
                        }
                        IOException traceRet1 = new IOException("Invalid sign nibble in packed decimal");
                        if (Trace.isOn) {
                            Trace.throwing("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToBinary(byte [ ])", traceRet1, 1);
                        }
                        throw traceRet1;
                    }
                }
                leastSignificantDigit = mostSignificantDigit;
                mostSignificantDigit = 0;
            }
            if (leastSignificantDigit > 9 || mostSignificantDigit > 9) {
                if (Trace.isOn) {
                    Trace.traceData(clsName, "Digit outside of range 0..9", null);
                }
                IOException traceRet2 = new IOException("Packed Decimal digit outside of range 0-9");
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToBinary(byte [ ])", traceRet2, 2);
                }
                throw traceRet2;
            }
            int binaryValue = leastSignificantDigit + 10 * mostSignificantDigit;
            retVal += multiplier * (long)binaryValue;
            if (b == packedDecimalBytes.length - 1) {
                multiplier *= 10L;
                continue;
            }
            multiplier *= 100L;
        }
        if (!positive) {
            retVal = -retVal;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToBinary(byte [ ])", new Long(retVal));
        }
        return retVal;
    }

    protected static final byte[] convertToPackedDecimal(int binary) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(int)", new Object[]{new Integer(binary)});
        }
        if (binary > 9999999 || binary < -9999999) {
            if (Trace.isOn) {
                Trace.traceData(clsName, "Outside of range for integer packed decimal", null);
            }
            IOException traceRet1 = new IOException("Outside of range for integer packed decimal (+/-9999999)");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(int)", traceRet1);
            }
            throw traceRet1;
        }
        byte[] retVal = new byte[4];
        boolean positive = binary >= 0;
        int decimalDigit = Math.abs(binary % 10);
        binary /= 10;
        byte signByte = positive ? (byte)(decimalDigit << 4 | 0xC) : (byte)(decimalDigit << 4 | 0xD);
        retVal[3] = signByte;
        for (int byteIndex = 2; byteIndex >= 0; --byteIndex) {
            byte thisByte;
            int leastSignificantDigit = Math.abs(binary % 10);
            int mostSignificantDigit = Math.abs((binary /= 10) % 10);
            binary /= 10;
            retVal[byteIndex] = thisByte = (byte)(leastSignificantDigit | mostSignificantDigit << 4);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(int)", retVal);
        }
        return retVal;
    }

    protected static final byte[] convertToPackedDecimal(long binary) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(long)", new Object[]{new Long(binary)});
        }
        if (binary > 999999999999999L || binary < -999999999999999L) {
            if (Trace.isOn) {
                Trace.traceData(clsName, "Outside of range for long packed decimal", null);
            }
            IOException traceRet1 = new IOException("Outside of range for long packed decimal (0+/-999999999999999)");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(long)", traceRet1);
            }
            throw traceRet1;
        }
        byte[] retVal = new byte[8];
        boolean positive = binary >= 0L;
        int decimalDigit = (int)Math.abs(binary % 10L);
        binary /= 10L;
        byte signByte = positive ? (byte)(decimalDigit << 4 | 0xC) : (byte)(decimalDigit << 4 | 0xD);
        retVal[7] = signByte;
        for (int byteIndex = 6; byteIndex >= 0; --byteIndex) {
            byte thisByte;
            int leastSignificantDigit = (int)Math.abs(binary % 10L);
            int mostSignificantDigit = (int)Math.abs((binary /= 10L) % 10L);
            binary /= 10L;
            retVal[byteIndex] = thisByte = (byte)(leastSignificantDigit | mostSignificantDigit << 4);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(long)", retVal);
        }
        return retVal;
    }

    protected static final byte[] convertToPackedDecimal(short binary) throws IOException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(short)", new Object[]{new Short(binary)});
        }
        if (binary > 999 || binary < -999) {
            if (Trace.isOn) {
                Trace.traceData(clsName, "Outside of range for short packed decimal", null);
            }
            IOException traceRet1 = new IOException("Outside of range for short packed decimal (+/-999)");
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(short)", traceRet1);
            }
            throw traceRet1;
        }
        byte[] retVal = new byte[2];
        boolean positive = binary >= 0;
        int decimalDigit = Math.abs(binary % 10);
        binary = (short)(binary / 10);
        byte signByte = positive ? (byte)(decimalDigit << 4 | 0xC) : (byte)(decimalDigit << 4 | 0xD);
        retVal[1] = signByte;
        for (int byteIndex = 0; byteIndex >= 0; --byteIndex) {
            byte thisByte;
            int leastSignificantDigit = Math.abs(binary % 10);
            binary = (short)(binary / 10);
            int mostSignificantDigit = Math.abs(binary % 10);
            binary = (short)(binary / 10);
            retVal[byteIndex] = thisByte = (byte)(leastSignificantDigit | mostSignificantDigit << 4);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "convertToPackedDecimal(short)", retVal);
        }
        return retVal;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQS390PackedDecimalSupport", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQS390PackedDecimalSupport.java, jmscc.wmq.v6, k701, k701-112-140304  1.18.1.1 09/08/17 08:04:17");
        }
    }
}

