/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.common.internal.Reason;
import com.ibm.msg.client.wmq.v6.base.internal.MQConnectionRequestInfo;
import com.ibm.msg.client.wmq.v6.base.internal.MQEnvironment;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionFactory;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQOD;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueue;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManagerEventListener;
import com.ibm.msg.client.wmq.v6.base.internal.MQResourceException;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class MQQueueManager
extends MQManagedObject {
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQQueueManager.java, jmscc.wmq.v6, k701, k701-112-140304 1.55.1.2 10/11/15 15:53:44";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MQ_Q_NAME_LENGTH = 48;
    private static final int MQCA_COMMAND_INPUT_Q_NAME = 2003;
    private static final int MQIA_SYNCPOINT = 30;
    private static final int MQOT_Q_MGR = 5;
    private static JmqiEnvironment jmqiEnv;
    private Vector queues;
    private MQQueueManagerEventListener qmEventListener;
    private Pint completionCode = jmqiEnv.newPint();
    private Pint reason = jmqiEnv.newPint();
    private MQManagedConnectionJ11 mqManCon = null;
    private MQQueueManager copy = null;
    private MQQueueManager original = null;
    private MQException exceptionForDisconnect = null;
    private boolean allowErrorEvents = false;
    private boolean forSPI = false;
    private boolean inheritTx = false;
    private boolean asyncCmt = false;
    private boolean supportsQAT2 = false;
    protected boolean connectStatus = false;
    private int commandLevel = -1;

    public boolean isConnected() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "isConnected()", "getter", this.connectStatus);
        }
        return this.connectStatus;
    }

    public String getCommandInputQueueName() throws MQException {
        String traceRet1 = this.getString(2003, 48);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "getCommandInputQueueName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getCommandLevel() throws MQException {
        if (this.commandLevel == -1) {
            this.commandLevel = this.getInt(31);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "getCommandLevel()", "getter", new Integer(this.commandLevel));
        }
        return this.commandLevel;
    }

    public int getSyncpointAvailability() throws MQException {
        int traceRet1 = this.getInt(30);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "getSyncpointAvailability()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public MQQueueManager(String queueManagerName) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(String)", new Object[]{queueManagerName});
        }
        this.initialize(this.procure(queueManagerName, null));
        this.allowErrorEvents = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(String)");
        }
    }

    public MQQueueManager(String queueManagerName, Map mqProperties) throws MQException {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(String,Map)", new Object[]{queueManagerName, propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(String,Map)", new Object[]{queueManagerName, mqProperties});
            }
        }
        this.initialize(this.procure(queueManagerName, mqProperties));
        this.allowErrorEvents = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(String,Hashtable)");
        }
    }

    MQQueueManager(MQManagedConnectionJ11 mancon) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(MQManagedConnectionJ11)", new Object[]{mancon});
        }
        this.name = this.pszName = mancon.getQmgrName();
        this.queues = new Vector(5);
        this.qmEventListener = null;
        this.mqManCon = mancon;
        this.osession = mancon.getMQSESSION();
        this.hconn = mancon.getHconn();
        this.connectStatus = this.connected = this.mqManCon.isConnected();
        this.connectionReference = this;
        this.parentQmgr = this;
        this.resourceOpen = false;
        this.openStatus = false;
        this.forSPI = "SPI_ENABLE".equals(mancon.getStringProperty("SPI"));
        this.inheritTx = false;
        if (this.connected) {
            if (Trace.isOn) {
                Trace.traceData(this, "Opening Qmgr for inquire", null);
            }
            MQOD mqod = new MQOD();
            mqod.ObjectType = 5;
            this.osession.MQOPEN(this.hconn, mqod, 8224, this.phobj, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException traceRet1 = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(MQManagedConnectionJ11)", traceRet1, 1);
                }
                throw traceRet1;
            }
            this.resourceOpen = true;
            this.openStatus = true;
            this.osession.resolveV2Support(this.hconn, this.phobj.getHobj(), this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException traceRet2 = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                JmqiException e = MQSESSION.getJmqiEnv().getLastException();
                traceRet2.initCause((Throwable)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(MQManagedConnectionJ11)", traceRet2, 2);
                }
                throw traceRet2;
            }
            this.setSupportsQAT2(this.osession.supportsQAT2);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "<init>(MQManagedConnectionJ11)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(MQQueueManager qmgr) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "initialize(MQQueueManager)", new Object[]{qmgr});
        }
        MQQueueManager mQQueueManager = qmgr;
        synchronized (mQQueueManager) {
            this.pszName = qmgr.pszName;
            this.name = qmgr.name;
            this.queues = qmgr.queues;
            this.mqManCon = qmgr.mqManCon;
            this.osession = qmgr.osession;
            this.hconn = qmgr.hconn;
            this.phobj = qmgr.phobj;
            this.connected = qmgr.connected;
            this.connectStatus = qmgr.connectStatus;
            this.resourceOpen = qmgr.resourceOpen;
            this.openStatus = qmgr.openStatus;
            this.forSPI = qmgr.forSPI;
            this.setSupportsQAT2(qmgr.getSupportsQAT2());
            this.parentQmgr = this;
            this.connectionReference = this;
            this.original = qmgr;
            qmgr.copy = this;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "initialize(MQQueueManager)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "disconnect()");
        }
        this.allowErrorEvents = false;
        MQQueueManager mQQueueManager = this;
        synchronized (mQQueueManager) {
            if (!this.connected) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "disconnect()", 1);
                }
                return;
            }
            this.cleanup();
        }
        mQQueueManager = this;
        synchronized (mQQueueManager) {
            if (this.original != null) {
                this.mqManCon.fireConnectionClosedEvent(this.original);
            } else {
                this.mqManCon.fireConnectionClosedEvent(this);
            }
            if (this.exceptionForDisconnect != null) {
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "disconnect()", this.exceptionForDisconnect);
                }
                throw this.exceptionForDisconnect;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "disconnect()", 2);
        }
    }

    public synchronized void commit() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "commit()");
        }
        if (!this.connected) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "commit()", traceRet1, 1);
            }
            throw traceRet1;
        }
        this.osession.MQCMIT(this.hconn, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "commit()", mqe, 2);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "commit()");
        }
    }

    public synchronized void backout() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "backout()");
        }
        if (!this.connected) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "backout()", traceRet1, 1);
            }
            throw traceRet1;
        }
        this.osession.MQBACK(this.hconn, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "backout()", mqe, 2);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "backout()");
        }
    }

    MQSESSION getSession() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "getSession()", "getter", this.osession);
        }
        return this.osession;
    }

    public synchronized void putMsg2(String qName, String qmName, MQMsg2 msg2, MQPutMessageOptions pmo) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "putMsg2(String,String,MQMsg2,MQPutMessageOptions)", new Object[]{qName, qmName, msg2, pmo});
        }
        if (!this.connected) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "putMsg2(String,String,MQMsg2,MQPutMessageOptions)", traceRet1, 1);
            }
            throw traceRet1;
        }
        MQOD od = new MQOD();
        if (qName != null && qName.length() > 0) {
            od.ObjectName = qName;
        }
        if (qmName != null && qmName.length() > 0) {
            od.ObjectQMgrName = qmName;
        }
        ByteBuffer msgData = null;
        if (msg2 != null) {
            msgData = msg2.getInternalBuffer();
            this.osession.MQPUT1(this.hconn, od, msg2, pmo, msg2.getMessageDataLength(), msgData, this.completionCode, this.reason);
        } else {
            this.osession.MQPUT1(this.hconn, od, msg2, pmo, 0, null, this.completionCode, this.reason);
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "putMsg2(String,String,MQMsg2,MQPutMessageOptions)", mqe, 2);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "putMsg2(String,String,MQMsg2,MQPutMessageOptions)");
        }
    }

    public synchronized MQQueue accessQueue(String queueName, int openOptions, String queueManagerName, String dynamicQueueName, String alternateUserId) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "accessQueue(String,int,String,String,String)", new Object[]{queueName, new Integer(openOptions), queueManagerName, dynamicQueueName, alternateUserId});
        }
        if (!this.connected) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "accessQueue(String,int,String,String,String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "inheritTx = " + this.inheritTx, null);
            Trace.traceData(this, "asyncCmt = " + this.asyncCmt, null);
        }
        MQOD od = new MQOD();
        if (queueName != null && queueName.length() > 0) {
            od.ObjectName = queueName;
        }
        if (queueManagerName != null && queueManagerName.length() > 0) {
            od.ObjectQMgrName = queueManagerName;
        }
        if (dynamicQueueName != null && dynamicQueueName.length() > 0) {
            od.DynamicQName = dynamicQueueName;
        }
        if (alternateUserId != null && alternateUserId.length() > 0) {
            od.AlternateUserId = alternateUserId;
        }
        MQQueue q = new MQQueue();
        q.hconn = this.hconn;
        q.connected = this.connected;
        if (Trace.isOn) {
            Trace.traceData(this, "queue = " + od.ObjectName + "\nqueue manager = " + od.ObjectQMgrName + "\ndynamic queue name = " + od.DynamicQName + "\nalternate user id = " + od.AlternateUserId + "\noptions = " + openOptions, null);
        }
        this.osession.MQOPEN(q.hconn, od, openOptions, q.phobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            q.resourceOpen = false;
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "accessQueue(String,int,String,String,String)", mqe, 2);
            }
            throw mqe;
        }
        q.resourceOpen = true;
        q.mgr = this;
        this.queues.addElement(q);
        q.name = od.ObjectName;
        q.openOptions = openOptions;
        q.openStatus = true;
        q.parentQmgr = this;
        q.connectionReference = this;
        if (alternateUserId != null) {
            q.alternateUserId = alternateUserId;
        }
        q.mqca_description = 2013;
        if (Trace.isOn) {
            Trace.traceData(this, "Opened queue name = " + q.name, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "accessQueue(String,int,String,String,String)", q);
        }
        return q;
    }

    public synchronized MQQueue accessQueue(String queueName, int openOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "accessQueue(String,int)", new Object[]{queueName, new Integer(openOptions)});
        }
        MQQueue traceRet1 = this.accessQueue(queueName, openOptions, null, null, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "accessQueue(String,int)", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        block18: {
            block17: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "cleanup()");
                }
                if (this.copy != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Delegating cleanup to " + this.copy, null);
                    }
                    MQQueueManager mQQueueManager = this.copy;
                    synchronized (mQQueueManager) {
                        this.copy.cleanup();
                        this.connectStatus = false;
                        this.connected = false;
                        this.openStatus = false;
                        this.resourceOpen = false;
                    }
                }
                try {
                    Vector qVector = (Vector)this.queues.clone();
                    for (int i = 0; i < qVector.size(); ++i) {
                        MQQueue q = (MQQueue)qVector.elementAt(i);
                        if (q.resourceOpen) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Closing queue " + q, null);
                            }
                            q.close();
                        }
                        q.connected = false;
                    }
                }
                catch (Exception ex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "cleanup()", ex, 1);
                    }
                    if (!Trace.isOn) break block17;
                    Trace.traceData(this, "Queue cleanup() exception", null);
                }
            }
            this.queues.removeAllElements();
            if (Trace.isOn) {
                Trace.traceData(this, "All queues closed.", null);
            }
            this.qmEventListener = null;
            try {
                this.close();
            }
            catch (MQException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "cleanup()", ex, 2);
                }
                if (!Trace.isOn) break block18;
                Trace.traceData(this, "Exception during close, proceeding anyway.", null);
            }
        }
        this.connectStatus = false;
        this.connected = false;
        this.connectionReference = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "cleanup()");
        }
    }

    protected final void registerQueue(MQQueue q) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "registerQueue(MQQueue)", new Object[]{q});
        }
        this.queues.addElement(q);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "registerQueue(MQQueue)");
        }
    }

    protected final void unregisterQueue(MQQueue q) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "unregisterQueue(MQQueue)", new Object[]{q});
        }
        this.queues.removeElement(q);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "unregisterQueue(MQQueue)");
        }
    }

    void errorOccurred(MQException mqe) {
        MQQueueManagerEventListener el;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "errorOccurred(MQException)", new Object[]{mqe});
        }
        if (this.allowErrorEvents && mqe.completionCode == 2 && (el = this.qmEventListener) != null && Reason.isConnectionBroken(mqe.reasonCode)) {
            el.onConnectionBrokenException(this, mqe);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "errorOccurred(MQException)");
        }
    }

    void setExceptionForDisconnect(MQException mqe) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "setExceptionForDisconnect(MQException)", "setter", (Object)mqe);
        }
        this.exceptionForDisconnect = mqe;
        if (this.copy != null) {
            this.copy.exceptionForDisconnect = mqe;
        }
    }

    synchronized void honourRRS() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "honourRRS()");
        }
        this.osession.honourRRS(this.hconn, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "honourRRS()", mqe);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "honourRRS()");
        }
    }

    public int _getConnectionCCSID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "_getConnectionCCSID()");
        }
        int traceRet1 = this.osession.getConnectionCCSID();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "_getConnectionCCSID()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public boolean getSupportsQAT2() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "getSupportsQAT2()", "getter", this.supportsQAT2);
        }
        return this.supportsQAT2;
    }

    public void setSupportsQAT2(boolean b) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "setSupportsQAT2(boolean)", "setter", b);
        }
        this.supportsQAT2 = b;
    }

    public MQQueueManagerEventListener getEventListener() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "getEventListener()", "getter", this.qmEventListener);
        }
        return this.qmEventListener;
    }

    public void setEventListener(MQQueueManagerEventListener el) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "setEventListener(MQQueueManagerEventListener)", "setter", el);
        }
        this.qmEventListener = el;
    }

    private String determineTransport(Map mqProperties) throws MQException {
        String scphs;
        String trans;
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "determineTransport(Map)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "determineTransport(Map)", new Object[]{mqProperties});
            }
        }
        if ((trans = MQEnvironment.getStringProperty("transport", mqProperties)).equals("MQSeries")) {
            String hostname = MQEnvironment.getStringProperty("hostname", mqProperties);
            trans = hostname == null || hostname.trim().equals("") ? "MQSeries Bindings" : "MQSeries Client";
        }
        if (!trans.equals("MQSeries Client") && (scphs = MQEnvironment.getStringProperty("SSL Cipher Suite", mqProperties)) != null && !scphs.trim().equals("")) {
            MQException traceRet1 = new MQException(2, 2396, null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "determineTransport(Hashtable)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "determineTransport(Hashtable)", trans);
        }
        return trans;
    }

    private MQQueueManager obtainBaseMQQueueManager(String qmgr, Map mqProperties) throws MQException {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "obtainBaseMQQueueManager(String,Map)", new Object[]{qmgr, propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "obtainBaseMQQueueManager(String,Map)", new Object[]{qmgr, mqProperties});
            }
        }
        String transport = this.determineTransport(mqProperties);
        MQManagedConnectionFactory mcf = MQSESSION.getMQManagedConnectionFactory(transport, qmgr, mqProperties);
        MQConnectionRequestInfo cxReqInf = MQSESSION.getConnectionRequestInfo(transport, mqProperties, false);
        try {
            MQManagedConnectionJ11 mc = mcf.createManagedConnection(cxReqInf);
            MQQueueManager m = (MQQueueManager)mc.getConnection(cxReqInf);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "obtainBaseMQQueueManager(String,Hashtable)", m);
            }
            return m;
        }
        catch (MQResourceException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "obtainBaseMQQueueManager(String,Hashtable)", e);
            }
            MQException traceRet1 = this.processException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "obtainBaseMQQueueManager(String,Hashtable)", traceRet1);
            }
            throw traceRet1;
        }
    }

    private MQException processException(MQResourceException e) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "processException(MQResourceException)", new Object[]{e});
        }
        if (e.getMessage().equals("allocateConnection")) {
            MQException traceRet1 = new MQException(2, 2025, (Object)"no more connections available");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "processException(MQResourceException)", (Object)traceRet1, 1);
            }
            return traceRet1;
        }
        Exception le = e.getLinkedException();
        if (le instanceof MQException) {
            MQException traceRet2 = (MQException)((Object)le);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "processException(MQResourceException)", (Object)traceRet2, 2);
            }
            return traceRet2;
        }
        MQException traceRet3 = new MQException(2, 2195, (Object)this);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "processException(MQResourceException)", (Object)traceRet3, 3);
        }
        return traceRet3;
    }

    private MQQueueManager procure(String queueManagerName, Map mqProperties) throws MQException {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "procure(String,Map)", new Object[]{queueManagerName, propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "procure(String,Map)", new Object[]{queueManagerName, mqProperties});
            }
        }
        MQQueueManager baseQM = this.obtainBaseMQQueueManager(queueManagerName, mqProperties);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "procure(String,Hashtable)", baseQM);
        }
        return baseQM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void asyncCommit() throws MQException {
        block12: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "asyncCommit()");
            }
            try {
                if (!this.connected) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "not connected", null);
                    }
                    MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "asyncCommit()", traceRet1, 1);
                    }
                    throw traceRet1;
                }
                MQSESSION osession = this.getSession();
                osession.spiAsyncCmit(this.hconn, this.completionCode, this.reason);
                if (this.completionCode.x != 0 || this.reason.x != 0) {
                    MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                    this.errorOccurred(mqe);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "asyncCommit()", mqe, 2);
                    }
                    throw mqe;
                }
                Object var4_4 = null;
                if (!Trace.isOn) break block12;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "asyncCommit()");
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "asyncCommit completed with completionCode: " + this.completionCode.x + " reason: " + this.reason.x, null);
                }
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "asyncCommit()");
        }
        if (Trace.isOn) {
            Trace.traceData(this, "asyncCommit completed with completionCode: " + this.completionCode.x + " reason: " + this.reason.x, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "asyncCommit()");
        }
    }

    public synchronized void spiActivateDeferred(byte[] msgId) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiActivateDeferred(byte [ ])", new Object[]{msgId});
        }
        if (!this.connected) {
            if (Trace.isOn) {
                Trace.traceData(this, "not connected", null);
            }
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiActivateDeferred(byte [ ])", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (msgId == null || msgId.length != 24) {
            if (Trace.isOn) {
                Trace.traceData(this, "msgId is null or msgId.length != MQC.MQ_MSG_ID_LENGTH", null);
            }
            MQException traceRet2 = new MQException(2, 2206, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiActivateDeferred(byte [ ])", traceRet2, 2);
            }
            throw traceRet2;
        }
        MQSESSION osession = this.getSession();
        osession.spiDefActivate(this.hconn, msgId, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiActivateDeferred(byte [ ])", mqe, 3);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "spiActivateDeferred completed with completionCode: " + this.completionCode.x + " reason: " + this.reason.x, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiActivateDeferred(byte [ ])");
        }
    }

    public synchronized void spiCancelDeferred(byte[] msgId) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiCancelDeferred(byte [ ])", new Object[]{msgId});
        }
        if (!this.connected) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiCancelDeferred(byte [ ])", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (msgId == null || msgId.length != 24) {
            MQException traceRet2 = new MQException(2, 2206, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiCancelDeferred(byte [ ])", traceRet2, 2);
            }
            throw traceRet2;
        }
        MQSESSION osession = this.getSession();
        osession.spiDefCancel(this.hconn, msgId, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiCancelDeferred(byte [ ])", mqe, 3);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "spiCancelDeferred completed with completionCode: " + this.completionCode.x + " reason: " + this.reason.x, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiCancelDeferred(byte [ ])");
        }
    }

    public synchronized boolean spiSupportsDeferred() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiSupportsDeferred()");
        }
        if (!this.connected) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiSupportsDeferred()", traceRet1);
            }
            throw traceRet1;
        }
        MQSESSION osession = this.getSession();
        boolean out = osession.spiSupportsDeferred();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiSupportsDeferred()", out);
        }
        return out;
    }

    public synchronized boolean spiSupportsInherited() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiSupportsInherited()");
        }
        if (!this.connected) {
            if (Trace.isOn) {
                Trace.traceData(this, "not connected", null);
            }
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiSupportsInherited()", traceRet1);
            }
            throw traceRet1;
        }
        MQSESSION osession = this.getSession();
        boolean out = osession.spiSupportsInherited();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "spiSupportsInherited()", out);
        }
        return out;
    }

    static String translate(String suite, int source) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "translate(String,int)", new Object[]{suite, new Integer(source)});
        }
        String spec = "";
        if (suite != null) {
            String[][] strings = new String[][]{{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_RSA_EXPORT1024_WITH_RC4_56_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA"}, {"DES_SHA_EXPORT", "DES_SHA_EXPORT1024", "NULL_MD5", "NULL_SHA", "RC2_MD5_EXPORT", "RC4_56_SHA_EXPORT1024", "RC4_MD5_US", "RC4_MD5_EXPORT", "RC4_SHA_US", "TRIPLE_DES_SHA_US", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_DES_CBC_SHA", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "FIPS_WITH_DES_CBC_SHA", "FIPS_WITH_3DES_EDE_CBC_SHA"}};
            String[] ssource = strings[1];
            String[] sdest = strings[0];
            if (source == 0) {
                ssource = strings[0];
                sdest = strings[1];
            }
            for (int i = 0; i < ssource.length; ++i) {
                if (!suite.equals(ssource[i])) continue;
                spec = sdest[i];
                break;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "translate(String,int)", (Object)spec);
        }
        return spec;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQQueueManager.java, jmscc.wmq.v6, k701, k701-112-140304  1.55.1.2 10/11/15 15:53:44");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "static()");
        }
        MQException.logExclude((Integer)new Integer(0));
        new MQException(0, 0, null);
        MQException.log = null;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager", "static()");
        }
        jmqiEnv = MQSESSION.getJmqiEnv();
    }
}

