/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.internal.Configuration;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQMD;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject;
import com.ibm.msg.client.wmq.v6.base.internal.MQMessage;
import com.ibm.msg.client.wmq.v6.base.internal.MQMsg2;
import com.ibm.msg.client.wmq.v6.base.internal.MQOD;
import com.ibm.msg.client.wmq.v6.base.internal.MQPutMessageOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MQQueue
extends MQManagedObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQQueue.java, jmscc.wmq.v6, k701, k701-112-140304 1.34.1.6 11/11/24 13:32:51";
    private static final int MQ_Q_NAME_LENGTH = 48;
    private static final int MQCA_BASE_Q_NAME = 2002;
    private static final int MQCA_REMOTE_Q_MGR_NAME = 2017;
    private static final int MQCA_REMOTE_Q_NAME = 2018;
    private static final int MQIA_CURRENT_Q_DEPTH = 3;
    private static final int MQIA_DEFINITION_TYPE = 7;
    private static final int MQIA_NPM_CLASS = 78;
    private static final int MQIA_Q_TYPE = 20;
    public static final int spiGETOPT_INHERIT = 1;
    public static final int spiGETOPT_SHORT_TXN = 16;
    public static final int spiPUTOPT_ASYNC = 32;
    public static final int spiPUTOPT_BLANK_PADDED = 1;
    public static final int spiPUTOPT_DEFERRED = 4;
    public static final int spiPUTOPT_NONE = 0;
    public static final int spiPUTOPT_PUT_AND_FORGET = 8;
    public static final int spiPUTOPT_SYNCPOINT_IF_YOU_LIKE = 2;
    public static final int spiGETOPT_COMMIT = 2;
    public static final int spiGETOPT_COMMIT_ASYNC = 8;
    public static final int spiGETOPT_COMMIT_IF_YOU_LIKE = 4;
    private static final byte[] MQMI_NONE;
    private static final int MQNPM_CLASS_HIGH = 10;
    private static JmqiEnvironment jmqiEnv;
    private Pint msgLength = jmqiEnv.newPint();
    private ByteBuffer spiGetBuffer = ByteBuffer.wrap(new byte[Default_DefaultMsgLength]);
    private static int smallMsgsBufferReductionThreshold;
    private static final String smallMsgsBufferReductionThresholdProperty = "com.ibm.msg.client.wmq.v6.base.internal.MQQueue.smallMsgsBufferReductionThreshold";
    protected ByteBuffer baseJavaGetBuffer = ByteBuffer.wrap(new byte[Default_DefaultMsgLength]);
    private Pint completionCode = jmqiEnv.newPint();
    private int DefaultMsgLength = Default_DefaultMsgLength;
    private static int Default_DefaultMsgLength;
    protected MQQueueManager mgr = null;
    private int msgsTooSmallForBuffer = 0;
    protected MQSESSION osession = null;
    private GregorianCalendar putCalendar = null;
    private Pint reason = jmqiEnv.newPint();

    protected MQQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>()");
        }
    }

    public MQQueue(MQQueueManager qMgr, String queueName, int openOptions, String queueManagerName, String dynamicQueueName, String alternateUserId) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>(MQQueueManager,String,int,String,String,String)", new Object[]{qMgr, queueName, new Integer(openOptions), queueManagerName, dynamicQueueName, alternateUserId});
        }
        if (qMgr == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI001");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>(MQQueueManager,String,int,String,String,String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!qMgr.connected) {
            MQException traceRet2 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>(MQQueueManager,String,int,String,String,String)", traceRet2, 2);
            }
            throw traceRet2;
        }
        MQOD od = new MQOD();
        if (queueName != null && queueName.length() > 0) {
            od.ObjectName = queueName;
        }
        if (queueManagerName != null && queueManagerName.length() > 0) {
            od.ObjectQMgrName = queueManagerName;
        }
        if (dynamicQueueName != null && dynamicQueueName.length() > 0) {
            od.DynamicQName = dynamicQueueName;
        }
        if (alternateUserId != null && alternateUserId.length() > 0) {
            od.AlternateUserId = alternateUserId;
        }
        this.hconn = qMgr.hconn;
        this.connected = qMgr.connected;
        if (Trace.isOn) {
            Trace.traceData(this, "queue = " + od.ObjectName + "\nqueue manager = " + od.ObjectQMgrName + "\ndynamic queue name = " + od.DynamicQName + "\nalternate user id = " + od.AlternateUserId + "\noptions = " + openOptions, null);
        }
        this.osession = qMgr.getSession();
        this.osession.MQOPEN(this.hconn, od, openOptions, this.phobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            this.resourceOpen = false;
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            qMgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>(MQQueueManager,String,int,String,String,String)", mqe, 3);
            }
            throw mqe;
        }
        this.resourceOpen = true;
        this.mgr = qMgr;
        this.name = od.ObjectName;
        this.openOptions = openOptions;
        this.openStatus = true;
        this.parentQmgr = qMgr;
        this.connectionReference = qMgr;
        if (alternateUserId != null) {
            this.alternateUserId = alternateUserId;
        }
        this.mqca_description = 2013;
        qMgr.registerQueue(this);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "<init>(MQQueueManager,String,int,String,String,String)");
        }
    }

    public final int _getConnectionCCSID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "_getConnectionCCSID()");
        }
        if (this.osession == null) {
            this.osession = this.mgr.getSession();
        }
        int traceRet1 = this.osession.getConnectionCCSID();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "_getConnectionCCSID()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void close() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "close()");
        }
        super.close();
        if (this.connectionReference != null) {
            this.connectionReference.unregisterQueue(this);
        }
        this.mgr = null;
        this.connectionReference = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "close()");
        }
    }

    public void get(MQMessage message) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage)", new Object[]{message});
        }
        this.get(message, new MQGetMessageOptions(true));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(MQMessage message, MQGetMessageOptions getMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)", new Object[]{message, getMessageOptions});
        }
        int DefaultMsgLength = Default_DefaultMsgLength;
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            if (message == null) {
                MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI025");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (getMessageOptions == null) {
                MQException traceRet2 = new MQException(2, 2186, (Object)this, "MQJI026");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)", traceRet2, 2);
                }
                throw traceRet2;
            }
            MQMessage getmd = message;
            Pint msgLength = jmqiEnv.newPint();
            byte[] prevMsgId = null;
            byte[] prevCorrelId = null;
            int prevMatchOptions = 0;
            prevMatchOptions = getMessageOptions.matchOptions;
            if (prevMatchOptions == 0 || prevMatchOptions == 1) {
                prevCorrelId = message.correlationId;
                message.correlationId = MQMI_NONE;
                getMessageOptions.matchOptions |= 2;
            }
            if (prevMatchOptions == 0 || prevMatchOptions == 2) {
                prevMsgId = message.messageId;
                message.messageId = MQMI_NONE;
                getMessageOptions.matchOptions |= 1;
            }
            int encoding = message.encoding;
            int ccsid = message.characterSet;
            byte[] msgId = new byte[1];
            byte[] correlId = new byte[1];
            if (message.messageId != null) {
                msgId = new byte[message.messageId.length];
                System.arraycopy(message.messageId, 0, msgId, 0, message.messageId.length);
            } else {
                message.messageId = MQC.MQMI_NONE;
                if (Trace.isOn) {
                    Trace.traceData(this, "Saved NullPointerException on message.messageId", null);
                }
            }
            if (message.correlationId != null) {
                correlId = new byte[message.correlationId.length];
                System.arraycopy(message.correlationId, 0, correlId, 0, message.correlationId.length);
            } else if (Trace.isOn) {
                Trace.traceData(this, "Saved NullPointerException on message.correlationId", null);
            }
            if (message.getBufferSizeHint() != -1) {
                DefaultMsgLength = message.getBufferSizeHint();
                this.baseJavaGetBuffer = ByteBuffer.wrap(new byte[DefaultMsgLength]);
            }
            if ((getMessageOptions.options & 0x1006) == 0) {
                getMessageOptions.options |= 4;
            }
            if (this.osession == null && this.mgr != null) {
                this.osession = this.mgr.getSession();
            }
            if (!this.connected || this.osession == null) {
                MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)", traceRet3, 3);
                }
                throw traceRet3;
            }
            if (!this.resourceOpen) {
                MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI027");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)", traceRet4, 4);
                }
                throw traceRet4;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
                Trace.traceData(this, "message id: ", (Object)message.messageId);
                Trace.traceData(this, "corelation id: ", (Object)message.correlationId);
            }
            this.osession.MQGET(this.hconn, this.phobj.getHobj(), getmd, getMessageOptions, this.baseJavaGetBuffer.limit(), this.baseJavaGetBuffer, msgLength, this.completionCode, this.reason);
            if (this.completionCode.x != 0 && this.reason.x == 2010) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Retrying MQGET with buffer size reduced to " + msgLength.x, null);
                }
                DefaultMsgLength = msgLength.x;
                this.baseJavaGetBuffer = ByteBuffer.wrap(new byte[DefaultMsgLength]);
                this.osession.MQGET(this.hconn, this.phobj.getHobj(), getmd, getMessageOptions, this.baseJavaGetBuffer.limit(), this.baseJavaGetBuffer, msgLength, this.completionCode, this.reason);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage is " + msgLength.x + " bytes long.", null);
            }
            while (this.completionCode.x != 0 && this.reason.x == 2080) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Retrying MQGET with increased buffer size.", null);
                }
                DefaultMsgLength = msgLength.x;
                this.baseJavaGetBuffer = ByteBuffer.wrap(new byte[DefaultMsgLength]);
                getmd.encoding = encoding;
                getmd.characterSet = ccsid;
                getmd.messageId = new byte[msgId.length];
                System.arraycopy(msgId, 0, getmd.messageId, 0, msgId.length);
                getmd.correlationId = new byte[correlId.length];
                System.arraycopy(correlId, 0, getmd.correlationId, 0, correlId.length);
                this.osession.MQGET(this.hconn, this.phobj.getHobj(), getmd, getMessageOptions, this.baseJavaGetBuffer.limit(), this.baseJavaGetBuffer, msgLength, this.completionCode, this.reason);
            }
            if (msgLength.x <= 0 && Trace.isOn) {
                Trace.traceData(this, "get (empty message)", null);
            }
            if (prevMsgId != null || prevCorrelId != null) {
                getMessageOptions.matchOptions = prevMatchOptions;
            }
            if (this.completionCode.x == 2) {
                if (prevMsgId != null) {
                    message.messageId = prevMsgId;
                }
                if (prevCorrelId != null) {
                    message.correlationId = prevCorrelId;
                }
            }
            message.setMessageData(this.baseJavaGetBuffer, Math.min(this.baseJavaGetBuffer.limit(), msgLength.x), msgLength.x);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)", mqe, 5);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(MQMessage message, MQGetMessageOptions getMessageOptions, int MaxMsgSize) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", new Object[]{message, getMessageOptions, new Integer(MaxMsgSize)});
        }
        byte[] prevMsgId = null;
        byte[] prevCorrelId = null;
        int prevMatchOptions = 0;
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            if (message == null) {
                MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI025");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (MaxMsgSize < 0) {
                MQException traceRet2 = new MQException(2, 2005, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", traceRet2, 2);
                }
                throw traceRet2;
            }
            if (getMessageOptions == null) {
                MQException traceRet3 = new MQException(2, 2186, (Object)this, "MQJI026");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", traceRet3, 3);
                }
                throw traceRet3;
            }
            byte[] msgId = new byte[1];
            byte[] correlId = new byte[1];
            if (message.messageId != null) {
                msgId = new byte[message.messageId.length];
                System.arraycopy(message.messageId, 0, msgId, 0, message.messageId.length);
            } else {
                message.messageId = MQC.MQMI_NONE;
                if (Trace.isOn) {
                    Trace.traceData(this, "Saved NullPointerException on message.messageId", null);
                }
            }
            if (message.correlationId != null) {
                correlId = new byte[message.correlationId.length];
                System.arraycopy(message.correlationId, 0, correlId, 0, message.correlationId.length);
            } else if (Trace.isOn) {
                Trace.traceData(this, "Saved NullPointerException on message.correlationId", null);
            }
            if ((getMessageOptions.options & 0x1006) == 0) {
                getMessageOptions.options |= 4;
            }
            if ((prevMatchOptions = getMessageOptions.matchOptions) == 0 || prevMatchOptions == 1) {
                prevCorrelId = message.correlationId;
                message.correlationId = MQMI_NONE;
                getMessageOptions.matchOptions |= 2;
            }
            if (prevMatchOptions == 0 || prevMatchOptions == 2) {
                prevMsgId = message.messageId;
                message.messageId = MQMI_NONE;
                getMessageOptions.matchOptions |= 1;
            }
            MQMessage getmd = message;
            Pint msgLength = jmqiEnv.newPint();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[MaxMsgSize]);
            if (this.osession == null && this.mgr != null) {
                this.osession = this.mgr.getSession();
            }
            if (!this.connected || this.osession == null) {
                MQException traceRet4 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", traceRet4, 4);
                }
                throw traceRet4;
            }
            if (!this.resourceOpen) {
                MQException traceRet5 = new MQException(2, 2019, (Object)this, "MQJI027");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", traceRet5, 5);
                }
                throw traceRet5;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
                Trace.traceData(this, "message id: ", (Object)message.messageId);
                Trace.traceData(this, "correlation id: ", (Object)message.correlationId);
            }
            this.osession.MQGET(this.hconn, this.phobj.getHobj(), getmd, getMessageOptions, buffer.limit(), buffer, msgLength, this.completionCode, this.reason);
            if (this.completionCode.x != 0 && this.reason.x == 2010) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Retrying MQGET with buffer size reduced to " + msgLength.x, null);
                }
                buffer = ByteBuffer.wrap(new byte[msgLength.x]);
                this.osession.MQGET(this.hconn, this.phobj.getHobj(), getmd, getMessageOptions, buffer.limit(), buffer, msgLength, this.completionCode, this.reason);
            }
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage is " + msgLength.x + " bytes long.", null);
            }
            if (prevMsgId != null || prevCorrelId != null) {
                getMessageOptions.matchOptions = prevMatchOptions;
            }
            if (this.completionCode.x == 2) {
                if (prevMsgId != null) {
                    message.messageId = prevMsgId;
                }
                if (prevCorrelId != null) {
                    message.correlationId = prevCorrelId;
                }
            }
            message.setMessageData(buffer, Math.min(buffer.limit(), msgLength.x), msgLength.x);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)", mqe, 6);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "get(MQMessage,MQGetMessageOptions,int)");
        }
    }

    public int getCurrentDepth() throws MQException {
        int traceRet1 = this.getInt(3);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getCurrentDepth()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getDefinitionType() throws MQException {
        int traceRet1 = this.getInt(7);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getDefinitionType()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    final Hobj getHandle() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getHandle()");
        }
        if (!this.resourceOpen) {
            Hobj traceRet1 = CMQC.jmqi_MQHO_UNUSABLE_HOBJ;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getHandle()", traceRet1, 1);
            }
            return traceRet1;
        }
        Hobj traceRet2 = this.phobj.getHobj();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getHandle()", traceRet2, 2);
        }
        return traceRet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMsg2(MQMsg2 message, MQGetMessageOptions getMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2(MQMsg2,MQGetMessageOptions)", new Object[]{message, getMessageOptions});
        }
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            this.getMsg2Int(message, getMessageOptions, this.completionCode, this.reason, 0);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2(MQMsg2,MQGetMessageOptions)", mqe);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2(MQMsg2,MQGetMessageOptions)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getMsg2(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgSize) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2(MQMsg2,MQGetMessageOptions,int)", new Object[]{message, getMessageOptions, new Integer(MaxMsgSize)});
        }
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            this.getMsg2Int(message, getMessageOptions, MaxMsgSize, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2(MQMsg2,MQGetMessageOptions,int)", mqe);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2(MQMsg2,MQGetMessageOptions,int)");
        }
    }

    private void getMsg2Int(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgSize, Pint completionCode, Pint reasonCode) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", new Object[]{message, getMessageOptions, new Integer(MaxMsgSize), completionCode, reasonCode});
        }
        byte[] prevMsgId = null;
        byte[] prevCorrelId = null;
        int prevMatchOptions = 0;
        if (message == null) {
            completionCode.x = 2;
            reasonCode.x = 2026;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode + ", rc=" + reasonCode.x + ")", null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 1);
            }
            return;
        }
        if (MaxMsgSize < 0) {
            completionCode.x = 2;
            reasonCode.x = 2005;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode + ", rc=" + reasonCode.x + ")", null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 2);
            }
            return;
        }
        if (getMessageOptions == null) {
            completionCode.x = 2;
            reasonCode.x = 2186;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode + ", rc=" + reasonCode.x + ")", null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 3);
            }
            return;
        }
        if ((getMessageOptions.options & 0x1006) == 0) {
            getMessageOptions.options |= 4;
        }
        if ((prevMatchOptions = getMessageOptions.matchOptions) == 0 || prevMatchOptions == 1) {
            prevCorrelId = message.getCorrelationId();
            message.setCorrelationId(MQMI_NONE);
            getMessageOptions.matchOptions |= 2;
        }
        if (prevMatchOptions == 0 || prevMatchOptions == 2) {
            prevMsgId = message.getMessageId();
            message.setMessageId(MQMI_NONE);
            getMessageOptions.matchOptions |= 1;
        }
        Pint msgLength = jmqiEnv.newPint();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[MaxMsgSize]);
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            completionCode.x = 2;
            reasonCode.x = 2018;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode + ", rc=" + reasonCode.x + ")", null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 4);
            }
            return;
        }
        if (!this.resourceOpen) {
            completionCode.x = 2;
            reasonCode.x = 2019;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode + ", rc=" + reasonCode.x + ")", null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 5);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
            Trace.traceData(this, "message id: ", (Object)message.getMessageId());
            Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
        }
        this.osession.MQGET(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, msgLength, completionCode, reasonCode);
        if (completionCode.x != 0 && this.reason.x == 2010) {
            if (Trace.isOn) {
                Trace.traceData(this, "Retrying MQGET with buffer size reduced to " + msgLength.x, null);
            }
            buffer = ByteBuffer.wrap(new byte[msgLength.x]);
            this.osession.MQGET(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, msgLength, completionCode, reasonCode);
        }
        if (Trace.isOn) {
            Trace.traceData(this, "ProviderMessage is " + msgLength.x + " bytes long.", null);
        }
        if (prevMsgId != null || prevCorrelId != null) {
            getMessageOptions.matchOptions = prevMatchOptions;
        }
        if (completionCode.x == 2) {
            if (prevMsgId != null) {
                message.setMessageId(prevMsgId);
            }
            if (prevCorrelId != null) {
                message.setCorrelationId(prevCorrelId);
            }
        }
        message.setMessageData(buffer, Math.min(buffer.limit(), msgLength.x));
        if (Trace.isOn) {
            Trace.traceData(this, "getMsg2Int completed with cc=" + completionCode.x + ", rc=" + reasonCode.x + ")", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 6);
        }
    }

    private synchronized void getMsg2Int(MQMsg2 message, MQGetMessageOptions getMessageOptions, Pint completionCode, Pint reasonCode, int expectedMsgLength) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,Pint,Pint,int)", new Object[]{message, getMessageOptions, completionCode, reasonCode, new Integer(expectedMsgLength)});
        }
        if (expectedMsgLength > 0) {
            this.DefaultMsgLength = expectedMsgLength;
        }
        if (message == null) {
            completionCode.x = 2;
            reasonCode.x = 2026;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode.x + ", rc=" + reasonCode.x, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,Pint,Pint,int)", 1);
            }
            return;
        }
        if (getMessageOptions == null) {
            completionCode.x = 2;
            reasonCode.x = 2186;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode.x + ", rc=" + reasonCode.x, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,Pint,Pint,int)", 2);
            }
            return;
        }
        Pint msgLength = jmqiEnv.newPint();
        byte[] prevMsgId = null;
        byte[] prevCorrelId = null;
        int prevMatchOptions = 0;
        prevMatchOptions = getMessageOptions.matchOptions;
        if (prevMatchOptions == 0 || prevMatchOptions == 1) {
            prevCorrelId = message.getCorrelationId();
            message.setCorrelationId(MQMI_NONE);
            getMessageOptions.matchOptions |= 2;
        }
        if (prevMatchOptions == 0 || prevMatchOptions == 2) {
            prevMsgId = message.getMessageId();
            message.setMessageId(MQMI_NONE);
            getMessageOptions.matchOptions |= 1;
        }
        int encoding = message.getEncoding();
        int ccsid = message.getCharacterSet();
        byte[] msgId = message.getMessageId();
        byte[] correlId = message.getCorrelationId();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.DefaultMsgLength]);
        if ((getMessageOptions.options & 0x1006) == 0) {
            getMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            completionCode.x = 2;
            reasonCode.x = 2018;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode.x + ", rc=" + reasonCode.x, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,Pint,Pint,int)", 3);
            }
            return;
        }
        if (!this.resourceOpen) {
            completionCode.x = 2;
            reasonCode.x = 2019;
            if (Trace.isOn) {
                Trace.traceData(this, "getMsg2Int (cc=" + completionCode.x + ", rc=" + reasonCode.x, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,Pint,Pint,int)", 4);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
            Trace.traceData(this, "message id: ", (Object)message.getMessageId());
            Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
        }
        this.osession.MQGET(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, msgLength, completionCode, reasonCode);
        if (completionCode.x != 0 && this.reason.x == 2010) {
            if (Trace.isOn) {
                Trace.traceData(this, "Retrying MQGET with buffer size reduced to " + msgLength.x, null);
            }
            this.DefaultMsgLength = msgLength.x;
            buffer = ByteBuffer.wrap(new byte[this.DefaultMsgLength]);
            this.osession.MQGET(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, msgLength, completionCode, reasonCode);
        }
        if (Trace.isOn) {
            Trace.traceData(this, "ProviderMessage is " + msgLength.x + " bytes long.", null);
        }
        while (completionCode.x != 0 && reasonCode.x == 2080) {
            Trace.traceData(this, "Retrying MQGET with increased buffer size.", null);
            this.DefaultMsgLength = msgLength.x;
            buffer = ByteBuffer.wrap(new byte[this.DefaultMsgLength]);
            message.setEncoding(encoding);
            message.setCharacterSet(ccsid);
            message.setMessageId(msgId);
            message.setCorrelationId(correlId);
            this.osession.MQGET(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, msgLength, completionCode, reasonCode);
        }
        if (msgLength.x <= 0 && Trace.isOn) {
            Trace.traceData(this, "getMsg2Int (empty message)", null);
        }
        if (prevMsgId != null || prevCorrelId != null) {
            getMessageOptions.matchOptions = prevMatchOptions;
        }
        if (completionCode.x == 2) {
            if (prevMsgId != null) {
                message.setMessageId(prevMsgId);
            }
            if (prevCorrelId != null) {
                message.setCorrelationId(prevCorrelId);
            }
        }
        if (completionCode.x != 2 || reasonCode.x == 2033) {
            this.msgsTooSmallForBuffer = this.DefaultMsgLength > msgLength.x * 2 ? ++this.msgsTooSmallForBuffer : 0;
            if (this.msgsTooSmallForBuffer >= smallMsgsBufferReductionThreshold) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Reducing buffer size. msgsTooSmallForBuffer = " + this.msgsTooSmallForBuffer, null);
                }
                this.DefaultMsgLength = Default_DefaultMsgLength;
                this.msgsTooSmallForBuffer = 0;
            }
        }
        message.setMessageData(buffer, Math.min(buffer.limit(), msgLength.x));
        if (Trace.isOn) {
            Trace.traceData(this, "getMsg2Int completed with cc=" + completionCode.x + ", rc=" + reasonCode.x + ")", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2Int(MQMsg2,MQGetMessageOptions,Pint,Pint,int)", 5);
        }
    }

    public synchronized int getMsg2NoExc(MQMsg2 message, MQGetMessageOptions getMessageOptions) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2NoExc(MQMsg2,MQGetMessageOptions)", new Object[]{message, getMessageOptions});
        }
        this.getMsg2Int(message, getMessageOptions, this.completionCode, this.reason, 0);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2NoExc(MQMsg2,MQGetMessageOptions)", new Integer(this.reason.x));
        }
        return this.reason.x;
    }

    public synchronized int getMsg2NoExc(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgSize) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2NoExc(MQMsg2,MQGetMessageOptions,int)", new Object[]{message, getMessageOptions, new Integer(MaxMsgSize)});
        }
        this.getMsg2Int(message, getMessageOptions, MaxMsgSize, this.completionCode, this.reason);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "getMsg2NoExc(MQMsg2,MQGetMessageOptions,int)", new Integer(this.reason.x));
        }
        return this.reason.x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNPMClassHigh() {
        block46: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
            }
            myQueue = null;
            opened = false;
            try {
                try {
                    try {
                        if (this.isOpen() && (this.openOptions & 32) == 32) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Not reopening queue as already opened for inquire", null);
                            }
                            opened = false;
                            myQueue = this;
                        } else {
                            myQueue = this.mgr.accessQueue(this.name, 8224);
                            opened = true;
                        }
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", e, 1);
                        }
                        myQueue = null;
                    }
                    v0 = res = myQueue != null && myQueue.getInt(78) == 10;
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", res, 1);
                    }
                    var4_6 = res;
                    var14_9 = null;
                    if (!Trace.isOn) break block46;
                }
                catch (MQException mq) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mq, 2);
                    }
                    try {
                        qType = myQueue.getInt(20);
                        if (qType == 1 || qType == 2) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "NPMCLASS(HIGH) unsupported, qType=" + qType, null);
                            }
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", false, 2);
                            }
                            var5_23 = false;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (MQException mq2) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mq2, 3);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "inquire failed with: " + (Object)mq2, null);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", false, 6);
                        }
                        var5_27 = false;
                        var14_14 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
                        }
                        try {
                            if (myQueue == null) return var5_27;
                            if (opened == false) return var5_27;
                            myQueue.close();
                            return var5_27;
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn == false) return var5_27;
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
                        }
                        return var5_27;
                    }
                    var14_10 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 702->717)] { 
lbl68:
                    // 1 sources

                    if (myQueue == null) return var5_23;
                    if (opened == false) return var5_23;
                    myQueue.close();
                    return var5_23;
lbl72:
                    // 1 sources

                    catch (MQException mqe) {
                        if (Trace.isOn == false) return var5_23;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
                    }
                    return var5_23;
lbl-1000:
                    // 1 sources

                    {
                        if (qType != 3) ** GOTO lbl-1000
                        inq = new int[1];
                        CAresult = new byte[48];
                        inq[0] = 2002;
                        myQueue.inquire(inq, null, CAresult);
                        res = new String(CAresult);
                        if (Trace.isOn) {
                            Trace.traceData(this, "alias, resolves to =" + res, null);
                        }
                        theQueue = this.mgr.accessQueue(res, 8224);
                        isNPMClass = theQueue.isNPMClassHigh();
                        theQueue.close();
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", isNPMClass, 3);
                        }
                        var10_36 = isNPMClass;
                    }
                    var14_11 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 702->717)] { 
lbl95:
                    // 1 sources

                    if (myQueue == null) return var10_36;
                    if (opened == false) return var10_36;
                    myQueue.close();
                    return var10_36;
lbl99:
                    // 1 sources

                    catch (MQException mqe) {
                        if (Trace.isOn == false) return var10_36;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
                    }
                    return var10_36;
lbl-1000:
                    // 1 sources

                    {
                        if (qType != 6) ** GOTO lbl-1000
                        inq = new int[2];
                        CAresult = new byte[96];
                        inq[0] = 2017;
                        inq[1] = 2018;
                        myQueue.inquire(inq, null, CAresult);
                        res = new String(CAresult);
                        qm = res.substring(0, 47);
                        q = res.substring(48);
                        if (Trace.isOn) {
                            Trace.traceData(this, "remote queue, resolves to=" + qm + "/" + q, null);
                        }
                        theQueue = this.mgr.accessQueue(res, 8224);
                        isNPMClass = theQueue.isNPMClassHigh();
                        theQueue.close();
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", isNPMClass, 4);
                        }
                        var12_39 = isNPMClass;
                    }
                    var14_12 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 702->717)] { 
lbl125:
                    // 1 sources

                    if (myQueue == null) return var12_39;
                    if (opened == false) return var12_39;
                    myQueue.close();
                    return var12_39;
lbl129:
                    // 1 sources

                    catch (MQException mqe) {
                        if (Trace.isOn == false) return var12_39;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
                    }
                    return var12_39;
lbl-1000:
                    // 1 sources

                    {
                        if (Trace.isOn) {
                            Trace.traceData(this, "unexpected qType=" + qType, null);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", false, 5);
                        }
                        var5_26 = false;
                    }
                    var14_13 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 702->717)] { 
lbl143:
                    // 1 sources

                    if (myQueue == null) return var5_26;
                    if (opened == false) return var5_26;
                    myQueue.close();
                    return var5_26;
lbl147:
                    // 1 sources

                    catch (MQException mqe) {
                        if (Trace.isOn == false) return var5_26;
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
                    }
                    return var5_26;
                }
            }
            catch (Throwable var13_40) {
                var14_15 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
                }
                try {}
                catch (MQException mqe) {
                    if (Trace.isOn == false) throw var13_40;
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
                    throw var13_40;
                }
                if (myQueue == null) throw var13_40;
                if (opened == false) throw var13_40;
                myQueue.close();
                throw var13_40;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()");
        }
        try {}
        catch (MQException mqe) {
            if (Trace.isOn == false) return var4_6;
            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "isNPMClassHigh()", mqe, 4);
            return var4_6;
        }
        if (myQueue == null) return var4_6;
        if (opened == false) return var4_6;
        myQueue.close();
        return var4_6;
    }

    public void put(MQMessage message) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage)", new Object[]{message});
        }
        this.put(message, new MQPutMessageOptions());
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", new Object[]{message, putMessageOptions});
        }
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            MQMessage putmd = message;
            if (message == null) {
                MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI028");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (putMessageOptions == null) {
                MQException traceRet2 = new MQException(2, 2173, (Object)this, "MQJI029");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet2, 2);
                }
                throw traceRet2;
            }
            putMessageOptions.invalidDestCount = 1;
            putMessageOptions.knownDestCount = 0;
            putMessageOptions.unknownDestCount = 0;
            if ((putMessageOptions.options & 6) == 0) {
                putMessageOptions.options |= 4;
            }
            if (this.osession == null && this.mgr != null) {
                this.osession = this.mgr.getSession();
            }
            if (!this.connected || this.osession == null) {
                MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet3, 3);
                }
                throw traceRet3;
            }
            if (!this.resourceOpen) {
                MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI027");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet4, 4);
                }
                throw traceRet4;
            }
            if ((putMessageOptions.options & 0x300) != 0) {
                if (putMessageOptions.contextReference != null) {
                    putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                    if (putMessageOptions.contextReferenceHandle == CMQC.jmqi_MQHO_UNUSABLE_HOBJ) {
                        MQException traceRet5 = new MQException(2, 2097, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet5, 5);
                        }
                        throw traceRet5;
                    }
                    if (this.mgr != putMessageOptions.contextReference.mgr) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderConnection references do not match", null);
                        }
                        MQException traceRet6 = new MQException(2, 2097, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet6, 6);
                        }
                        throw traceRet6;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Obtained context reference handle:" + putMessageOptions.contextReferenceHandle, null);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Context reference queue is null", null);
                    }
                    MQException traceRet7 = new MQException(2, 2097, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", traceRet7, 7);
                    }
                    throw traceRet7;
                }
            }
            if ((putMessageOptions.options & 0x800) != 0) {
                if (putmd.putDateTime == null) {
                    putmd.putDate = MQMD.getDate(null);
                    putmd.putTime = MQMD.getTime(null);
                } else {
                    if (this.putCalendar == null) {
                        TimeZone gmt = TimeZone.getTimeZone("GMT");
                        this.putCalendar = new GregorianCalendar(gmt);
                    }
                    this.putCalendar.setTime(putmd.putDateTime.getTime());
                    putmd.putDate = MQMD.getDate(this.putCalendar);
                    putmd.putTime = MQMD.getTime(this.putCalendar);
                }
            }
            ByteBuffer msgData = ByteBuffer.wrap(message.toByteArray());
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage length = " + msgData.limit() + " bytes.", null);
                Trace.traceData(this, "put options = " + putMessageOptions.options + "\nmessage type = " + message.messageType + "\nencoding = " + message.encoding + "\ncharacter set = " + message.characterSet + "\nformat = " + message.format, null);
                Trace.traceData(this, "message id: ", (Object)message.messageId);
                Trace.traceData(this, "correlation id: ", (Object)message.correlationId);
            }
            this.osession.MQPUT(this.hconn, this.phobj.getHobj(), putmd, putMessageOptions, msgData.limit(), msgData, this.completionCode, this.reason);
            if (Trace.isOn) {
                Trace.traceData(this, "Returned message id follows:", (Object)message.messageId);
            }
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)", mqe, 8);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "put(MQMessage,MQPutMessageOptions)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMsg2(MQMsg2 message, MQPutMessageOptions putMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", new Object[]{message, putMessageOptions});
        }
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            if (message == null) {
                MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI028");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (putMessageOptions == null) {
                MQException traceRet2 = new MQException(2, 2173, (Object)this, "MQJI029");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet2, 2);
                }
                throw traceRet2;
            }
            putMessageOptions.invalidDestCount = 1;
            putMessageOptions.knownDestCount = 0;
            putMessageOptions.unknownDestCount = 0;
            if ((putMessageOptions.options & 6) == 0) {
                putMessageOptions.options |= 4;
            }
            if (this.osession == null && this.mgr != null) {
                this.osession = this.mgr.getSession();
            }
            if (!this.connected || this.osession == null) {
                MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet3, 3);
                }
                throw traceRet3;
            }
            if (!this.resourceOpen) {
                MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI027");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet4, 4);
                }
                throw traceRet4;
            }
            if ((putMessageOptions.options & 0x300) != 0) {
                if (putMessageOptions.contextReference != null) {
                    putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                    if (putMessageOptions.contextReferenceHandle == CMQC.jmqi_MQHO_UNUSABLE_HOBJ) {
                        MQException traceRet5 = new MQException(2, 2097, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet5, 5);
                        }
                        throw traceRet5;
                    }
                    if (this.mgr != putMessageOptions.contextReference.mgr) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderConnection references do not match", null);
                        }
                        MQException traceRet6 = new MQException(2, 2097, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet6, 6);
                        }
                        throw traceRet6;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Obtained context reference handle:" + putMessageOptions.contextReferenceHandle, null);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Context reference queue is null", null);
                    }
                    MQException traceRet7 = new MQException(2, 2097, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", traceRet7, 7);
                    }
                    throw traceRet7;
                }
            }
            ByteBuffer msgData = message.getInternalBuffer();
            int messageDataLength = message.getMessageDataLength();
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage length = " + messageDataLength + " bytes.", null);
                Trace.traceData(this, "put options = " + putMessageOptions.options + "\nmessage type = " + message.getMessageType() + "\nencoding = " + message.getEncoding() + "\ncharacter set = " + message.getCharacterSet() + "\nformat = " + message.getFormat(), null);
                Trace.traceData(this, "message id: ", (Object)message.getMessageId());
                Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
            }
            this.osession.MQPUT(this.hconn, this.phobj.getHobj(), message, putMessageOptions, messageDataLength, msgData, this.completionCode, this.reason);
            if (Trace.isOn) {
                Trace.traceData(this, "Returned message id follows:", (Object)message.getMessageId());
            }
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)", mqe, 8);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "putMsg2(MQMsg2,MQPutMessageOptions)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiBatchedGet(MQMsg2 message, MQGetMessageOptions getMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGet(MQMsg2,MQGetMessageOptions)", new Object[]{message, getMessageOptions});
        }
        MQException exception = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            try {
                this.spiBatchedGetInt(message, getMessageOptions, this.completionCode, this.reason);
            }
            catch (MQException mqe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGet(MQMsg2,MQGetMessageOptions)", mqe);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGet(MQMsg2,MQGetMessageOptions)", mqe, 1);
                }
                throw mqe;
            }
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                exception = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (exception != null) {
            this.parentQmgr.errorOccurred(exception);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGet(MQMsg2,MQGetMessageOptions)", exception, 2);
            }
            throw exception;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGet(MQMsg2,MQGetMessageOptions)");
        }
    }

    private void spiBatchedGetInt(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgSize, Pint cc, Pint rc) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", new Object[]{message, getMessageOptions, new Integer(MaxMsgSize), cc, rc});
        }
        if (message == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "message is null", null);
            }
            cc.x = 2;
            rc.x = 2026;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 1);
            }
            return;
        }
        if (MaxMsgSize < 0) {
            if (Trace.isOn) {
                Trace.traceData(this, "MaxMsgSize < 0 - Buffer length error", null);
            }
            cc.x = 2;
            rc.x = 2005;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 2);
            }
            return;
        }
        if (getMessageOptions == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "getMessageOptions is null", null);
            }
            cc.x = 2;
            rc.x = 2186;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 3);
            }
            return;
        }
        byte[] prevMsgId = null;
        byte[] prevCorrelId = null;
        int prevMatchOptions = 0;
        if ((getMessageOptions.options & 0x1006) == 0) {
            getMessageOptions.options |= 4;
        }
        if ((prevMatchOptions = getMessageOptions.matchOptions) == 0 || prevMatchOptions == 1) {
            prevCorrelId = message.getCorrelationId();
            message.setCorrelationId(MQMI_NONE);
            getMessageOptions.matchOptions |= 2;
        }
        if (prevMatchOptions == 0 || prevMatchOptions == 2) {
            prevMsgId = message.getMessageId();
            message.setMessageId(MQMI_NONE);
            getMessageOptions.matchOptions |= 1;
        }
        Pint msgLength = jmqiEnv.newPint();
        byte[] array = new byte[MaxMsgSize];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "not connected or osession is null", null);
            }
            cc.x = 2;
            rc.x = 2018;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 4);
            }
            return;
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.traceData(this, "resource not open", null);
            }
            cc.x = 2;
            rc.x = 2019;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 5);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
            Trace.traceData(this, "message id:", (Object)message.getMessageId());
            Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
        }
        this.osession.spiBatchedGet(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, msgLength, cc, rc);
        if (Trace.isOn) {
            Trace.traceData(this, "ProviderMessage is " + msgLength.x + " bytes long.", null);
        }
        if (prevMsgId != null || prevCorrelId != null) {
            getMessageOptions.matchOptions = prevMatchOptions;
        }
        if (cc.x == 2) {
            if (prevMsgId != null) {
                message.setMessageId(prevMsgId);
            }
            if (prevCorrelId != null) {
                message.setCorrelationId(prevCorrelId);
            }
        }
        message.setMessageData(buffer, Math.min(buffer.limit(), msgLength.x));
        if (Trace.isOn) {
            Trace.traceData(this, "spiBatchedGetMsg2Int completed with cc=" + cc.x + ", rc=" + rc.x + ")", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 6);
        }
    }

    private void spiBatchedGetInt(MQMsg2 message, MQGetMessageOptions getMessageOptions, Pint cc, Pint rc) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,Pint,Pint)", new Object[]{message, getMessageOptions, cc, rc});
        }
        if (message == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "message is null", null);
            }
            cc.x = 2;
            rc.x = 2026;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,Pint,Pint)", 1);
            }
            return;
        }
        if (getMessageOptions == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "getMessageOptions is null", null);
            }
            cc.x = 2;
            rc.x = 2186;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,Pint,Pint)", 2);
            }
            return;
        }
        byte[] prevMsgId = null;
        byte[] prevCorrelId = null;
        int prevMatchOptions = 0;
        prevMatchOptions = getMessageOptions.matchOptions;
        if (prevMatchOptions == 0 || prevMatchOptions == 1) {
            prevCorrelId = message.getCorrelationId();
            message.setCorrelationId(MQMI_NONE);
            getMessageOptions.matchOptions |= 2;
        }
        if (prevMatchOptions == 0 || prevMatchOptions == 2) {
            prevMsgId = message.getMessageId();
            message.setMessageId(MQMI_NONE);
            getMessageOptions.matchOptions |= 1;
        }
        int encoding = message.getEncoding();
        int ccsid = message.getCharacterSet();
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        ByteBuffer buffer = message.getInternalBuffer();
        int minBufferSize = message.sizeOfMQMD() + getMessageOptions.sizeOfMQGetMessageOptions(this.hconn) + 1;
        int idealBufferSize = 0;
        idealBufferSize = buffer == null ? 1024 : buffer.limit();
        if (idealBufferSize < minBufferSize) {
            idealBufferSize = minBufferSize;
        }
        if (idealBufferSize < this.osession.getMaxMessageSizeForBatch()) {
            idealBufferSize = this.osession.getMaxMessageSizeForBatch();
        }
        if (buffer == null || buffer.limit() < idealBufferSize) {
            byte[] array = new byte[idealBufferSize];
            buffer = ByteBuffer.wrap(array);
        }
        if ((getMessageOptions.options & 0x1006) == 0) {
            getMessageOptions.options |= 4;
        }
        if (!this.connected || this.osession == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "not connected or osession is null", null);
            }
            cc.x = 2;
            rc.x = 2018;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,Pint,Pint)", 3);
            }
            return;
        }
        if (!this.resourceOpen) {
            if (Trace.isOn) {
                Trace.traceData(this, "resource is not open", null);
            }
            cc.x = 2;
            rc.x = 2019;
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,Pint,Pint)", 4);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
            Trace.traceData(this, "message id: ", (Object)message.getMessageId());
            Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
        }
        cc.x = 0;
        rc.x = 0;
        this.osession.spiBatchedGet(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, this.msgLength, cc, rc);
        if (Trace.isOn) {
            Trace.traceData(this, "ProviderMessage is " + this.msgLength.x + " bytes long.", null);
        }
        if (cc.x != 0 && rc.x == 2080) {
            if (Trace.isOn) {
                Trace.traceData(this, "Retrying get with buffer size increased to " + this.msgLength.x, null);
            }
            buffer = ByteBuffer.wrap(new byte[this.msgLength.x]);
            message.setEncoding(encoding);
            message.setCharacterSet(ccsid);
            this.osession.spiBatchedGet(this.hconn, this.phobj.getHobj(), message, getMessageOptions, buffer.limit(), buffer, this.msgLength, cc, rc);
            if (Trace.isOn) {
                Trace.traceData(this, "Buffer size after retry is " + this.msgLength.x, null);
            }
        }
        if (this.msgLength.x <= 0 && Trace.isOn) {
            Trace.traceData(this, "spiBatchedGetInt (empty message)", null);
        }
        if (prevMsgId != null || prevCorrelId != null) {
            getMessageOptions.matchOptions = prevMatchOptions;
        }
        if (cc.x == 2 || rc.x == 2080) {
            if (prevMsgId != null) {
                message.setMessageId(prevMsgId);
            }
            if (prevCorrelId != null) {
                message.setCorrelationId(prevCorrelId);
            }
        }
        message.setInternalBuffer(buffer, Math.min(buffer.limit(), this.msgLength.x));
        if (Trace.isOn) {
            Trace.traceData(this, "spiBatchedGetInt completed with cc=" + cc.x + ", rc=" + rc.x + ")", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetInt(MQMsg2,MQGetMessageOptions,Pint,Pint)", 5);
        }
    }

    public synchronized int spiBatchedGetNoExc(MQMsg2 message, MQGetMessageOptions getMessageOptions, int MaxMsgLen) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetNoExc(MQMsg2,MQGetMessageOptions,int)", new Object[]{message, getMessageOptions, new Integer(MaxMsgLen)});
        }
        try {
            this.spiBatchedGetInt(message, getMessageOptions, MaxMsgLen, this.completionCode, this.reason);
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetNoExc(MQMsg2,MQGetMessageOptions,int)", mqe);
            }
            this.reason.x = mqe.reasonCode;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiBatchedGetNoExc(MQMsg2,MQGetMessageOptions,int)", new Integer(this.reason.x));
        }
        return this.reason.x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiDeferredPut(MQMsg2 message, MQPutMessageOptions putMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", new Object[]{message, putMessageOptions});
        }
        MQException mqe = null;
        MQQueue mQQueue = this;
        synchronized (mQQueue) {
            if (message == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "message is null", null);
                }
                MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI028");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (putMessageOptions == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "putMessageOptions is null", null);
                }
                MQException traceRet2 = new MQException(2, 2173, (Object)this, "MQJI029");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet2, 2);
                }
                throw traceRet2;
            }
            putMessageOptions.invalidDestCount = 1;
            putMessageOptions.knownDestCount = 0;
            putMessageOptions.unknownDestCount = 0;
            if ((putMessageOptions.options & 6) == 0) {
                putMessageOptions.options |= 4;
            }
            MQSESSION osession = null;
            if (this.mgr != null) {
                osession = this.mgr.getSession();
            }
            if (!this.connected || osession == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "not connected or osession is null", null);
                }
                MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet3, 3);
                }
                throw traceRet3;
            }
            if (!this.resourceOpen) {
                if (Trace.isOn) {
                    Trace.traceData(this, "resource not open", null);
                }
                MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI027");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet4, 4);
                }
                throw traceRet4;
            }
            if ((putMessageOptions.options & 0x300) != 0) {
                if (putMessageOptions.contextReference != null) {
                    putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                    if (putMessageOptions.contextReferenceHandle == CMQC.jmqi_MQHO_UNUSABLE_HOBJ) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "context handle error", null);
                        }
                        MQException traceRet5 = new MQException(2, 2097, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet5, 5);
                        }
                        throw traceRet5;
                    }
                    if (this.mgr != putMessageOptions.contextReference.mgr) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderConnection references do not match", null);
                        }
                        MQException traceRet6 = new MQException(2, 2097, (Object)this);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet6, 6);
                        }
                        throw traceRet6;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "Obtained context reference handle:" + putMessageOptions.contextReferenceHandle, null);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.traceData(this, "Context reference queue is null", null);
                    }
                    MQException traceRet7 = new MQException(2, 2097, (Object)this);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", traceRet7, 7);
                    }
                    throw traceRet7;
                }
            }
            int messageDataLength = message.getMessageDataLength();
            ByteBuffer msgData = message.getInternalBuffer();
            if (Trace.isOn) {
                Trace.traceData(this, "ProviderMessage length = " + messageDataLength + " butes.", null);
                Trace.traceData(this, "put options = " + putMessageOptions.options + "\nmessage type = " + message.getMessageType() + "\nencoding = " + message.getEncoding() + "\ncharacter set = " + message.getCharacterSet() + "\nformat = " + message.getFormat(), null);
                Trace.traceData(this, "message id: ", (Object)message.getMessageId());
                Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
            }
            osession.spiDefPut(this.hconn, this.phobj.getHobj(), message, putMessageOptions, messageDataLength, msgData, this.completionCode, this.reason);
            if (Trace.isOn) {
                Trace.traceData(this, "Returned message id follows:", (Object)message.getMessageId());
            }
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.traceData(this, "spiDefPut returned with completionCode: " + this.completionCode.x + " and reason: " + this.reason.x, null);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)", mqe, 8);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiDeferredPut(MQMsg2,MQPutMessageOptions)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spiGet(MQMsg2 message, MQGetMessageOptions getMessageOptions, int spiOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGet(MQMsg2,MQGetMessageOptions,int)", new Object[]{message, getMessageOptions, new Integer(spiOptions)});
        }
        try {
            MQException mqe = null;
            MQQueue mQQueue = this;
            synchronized (mQQueue) {
                this.spiGetInt(message, getMessageOptions, spiOptions, this.completionCode, this.reason);
                if (this.completionCode.x != 0 || this.reason.x != 0) {
                    mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                }
            }
            if (mqe != null) {
                this.parentQmgr.errorOccurred(mqe);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGet(MQMsg2,MQGetMessageOptions,int)", mqe, 1);
                }
                throw mqe;
            }
        }
        catch (MQException mqe) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGet(MQMsg2,MQGetMessageOptions,int)", mqe);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGet(MQMsg2,MQGetMessageOptions,int)", mqe, 2);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGet(MQMsg2,MQGetMessageOptions,int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void spiGetInt(MQMsg2 message, MQGetMessageOptions getMessageOptions, int spiOptions, Pint cc, Pint rc) throws MQException {
        block48: {
            block47: {
                block46: {
                    block45: {
                        block44: {
                            block42: {
                                block43: {
                                    if (Trace.isOn) {
                                        Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", new Object[]{message, getMessageOptions, new Integer(spiOptions), cc, rc});
                                    }
                                    try {
                                        try {
                                            if (message == null) {
                                                cc.x = 2;
                                                rc.x = 2026;
                                                if (Trace.isOn) {
                                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 1);
                                                }
                                                Object var15_6 = null;
                                                if (!Trace.isOn) break block42;
                                                break block43;
                                            }
                                            if (getMessageOptions == null) {
                                                cc.x = 2;
                                                rc.x = 2186;
                                                if (Trace.isOn) {
                                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 2);
                                                }
                                                break block44;
                                            }
                                            Pint msgLength = jmqiEnv.newPint();
                                            byte[] prevMsgId = null;
                                            byte[] prevCorrelId = null;
                                            int prevMatchOptions = 0;
                                            prevMatchOptions = getMessageOptions.matchOptions;
                                            if (prevMatchOptions == 0 || prevMatchOptions == 1) {
                                                prevCorrelId = message.getCorrelationId();
                                                message.setCorrelationId(MQMI_NONE);
                                                getMessageOptions.matchOptions |= 2;
                                            }
                                            if (prevMatchOptions == 0 || prevMatchOptions == 2) {
                                                prevMsgId = message.getMessageId();
                                                message.setMessageId(MQMI_NONE);
                                                getMessageOptions.matchOptions |= 1;
                                            }
                                            int encoding = message.getEncoding();
                                            int ccsid = message.getCharacterSet();
                                            byte[] msgId = message.getMessageId();
                                            byte[] correlId = message.getCorrelationId();
                                            if (this.osession == null && this.mgr != null) {
                                                this.osession = this.mgr.getSession();
                                            }
                                            if ((getMessageOptions.options & 0x1006) == 0) {
                                                getMessageOptions.options |= 4;
                                            }
                                            if (!this.connected || this.osession == null) {
                                                cc.x = 2;
                                                rc.x = 2018;
                                                if (Trace.isOn) {
                                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 3);
                                                }
                                                break block45;
                                            }
                                            if (!this.resourceOpen) {
                                                cc.x = 2;
                                                rc.x = 2019;
                                                if (Trace.isOn) {
                                                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 4);
                                                }
                                                break block46;
                                            }
                                            if (Trace.isOn) {
                                                Trace.traceData(this, "get options = " + getMessageOptions.options + "\nwait interval = " + getMessageOptions.waitInterval, null);
                                                Trace.traceData(this, "message id", (Object)message.getMessageId());
                                                Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
                                            }
                                            this.osession.spiGet(this.hconn, this.phobj.getHobj(), message, getMessageOptions, spiOptions, this.spiGetBuffer.limit(), this.spiGetBuffer, msgLength, cc, rc);
                                            if (Trace.isOn) {
                                                Trace.traceData(this, "ProviderMessage is " + msgLength.x + " bytes long.", null);
                                            }
                                            while (cc.x != 0 && rc.x == 2080) {
                                                if (Trace.isOn) {
                                                    Trace.traceData(this, "Retrying get with increased buffer size.", null);
                                                }
                                                this.spiGetBuffer = ByteBuffer.wrap(new byte[msgLength.x]);
                                                message.setEncoding(encoding);
                                                message.setCharacterSet(ccsid);
                                                message.setMessageId(msgId);
                                                message.setCorrelationId(correlId);
                                                this.osession.spiGet(this.hconn, this.phobj.getHobj(), message, getMessageOptions, spiOptions, this.spiGetBuffer.limit(), this.spiGetBuffer, msgLength, cc, rc);
                                            }
                                            if (msgLength.x <= 0 && Trace.isOn) {
                                                Trace.traceData(this, "got empty message", null);
                                            }
                                            if (prevMsgId != null || prevCorrelId != null) {
                                                getMessageOptions.matchOptions = prevMatchOptions;
                                            }
                                            if (cc.x == 2) {
                                                if (prevMsgId != null) {
                                                    message.setMessageId(prevMsgId);
                                                }
                                                if (prevCorrelId != null) {
                                                    message.setCorrelationId(prevCorrelId);
                                                }
                                            }
                                            message.setInternalBuffer(this.spiGetBuffer, Math.min(this.spiGetBuffer.limit(), msgLength.x));
                                            if (Trace.isOn) {
                                                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 5);
                                            }
                                            break block47;
                                        }
                                        catch (MQException mqe) {
                                            if (Trace.isOn) {
                                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", mqe);
                                            }
                                            Object var15_11 = null;
                                            if (Trace.isOn) {
                                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
                                            }
                                            if (Trace.isOn) {
                                                Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
                                            }
                                            break block48;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var15_12 = null;
                                        if (Trace.isOn) {
                                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
                                        }
                                        if (Trace.isOn) {
                                            Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
                                        }
                                        throw throwable;
                                    }
                                }
                                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
                            }
                            return;
                        }
                        Object var15_7 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
                        }
                        return;
                    }
                    Object var15_8 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
                    }
                    return;
                }
                Object var15_9 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
                }
                return;
            }
            Object var15_10 = null;
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)");
            }
            if (Trace.isOn) {
                Trace.traceData(this, "spiGetInt completed with cc = " + cc.x + ", rc = " + rc.x, null);
            }
            return;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiGetInt(MQMsg2,MQGetMessageOptions,int,Pint,Pint)", 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void spiPut(MQMsg2 message, MQPutMessageOptions putMessageOptions, int spiOpts) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", new Object[]{message, putMessageOptions, new Integer(spiOpts)});
        }
        try {
            block40: {
                try {
                    MQSESSION osession;
                    block39: {
                        if (message == null) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Sanity check failed: null message", null);
                            }
                            MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI028");
                            if (!Trace.isOn) throw traceRet1;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet1, 1);
                            throw traceRet1;
                        }
                        if (putMessageOptions == null) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "Sanity check failed: null PutMessageOptions", null);
                            }
                            MQException traceRet2 = new MQException(2, 2173, (Object)this, "MQJI029");
                            if (!Trace.isOn) throw traceRet2;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet2, 2);
                            throw traceRet2;
                        }
                        putMessageOptions.invalidDestCount = 1;
                        putMessageOptions.knownDestCount = 0;
                        putMessageOptions.unknownDestCount = 0;
                        if ((putMessageOptions.options & 6) == 0) {
                            putMessageOptions.options |= 4;
                        }
                        osession = null;
                        if (this.mgr != null) {
                            osession = this.mgr.getSession();
                        }
                        if (!this.connected || osession == null) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "ProviderConnection check failed.", null);
                            }
                            MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
                            if (!Trace.isOn) throw traceRet3;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet3, 3);
                            throw traceRet3;
                        }
                        if (!this.resourceOpen) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "hObj check failed. resource closed.", null);
                            }
                            MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI027");
                            if (!Trace.isOn) throw traceRet4;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet4, 4);
                            throw traceRet4;
                        }
                        try {
                            if ((putMessageOptions.options & 0x300) == 0) break block39;
                            if (putMessageOptions.contextReference != null) {
                                putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                                if (putMessageOptions.contextReferenceHandle == CMQC.jmqi_MQHO_UNUSABLE_HOBJ) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "could not get contextReferenceHandle", null);
                                    }
                                    MQException traceRet5 = new MQException(2, 2097, (Object)this);
                                    if (!Trace.isOn) throw traceRet5;
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet5, 5);
                                    throw traceRet5;
                                }
                                if (this.mgr != putMessageOptions.contextReference.mgr) {
                                    if (Trace.isOn) {
                                        Trace.traceData(this, "ProviderConnection references do not match", null);
                                    }
                                    MQException traceRet6 = new MQException(2, 2097, (Object)this);
                                    if (!Trace.isOn) throw traceRet6;
                                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet6, 6);
                                    throw traceRet6;
                                }
                                if (Trace.isOn) {
                                    Trace.traceData(this, "Obtained context reference handle:" + putMessageOptions.contextReferenceHandle, null);
                                }
                                break block39;
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Context reference queue is null", null);
                            }
                            MQException traceRet7 = new MQException(2, 2097, (Object)this);
                            if (!Trace.isOn) throw traceRet7;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", traceRet7, 7);
                            throw traceRet7;
                        }
                        catch (MQException mqe) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 1);
                            }
                            if (Trace.isOn) {
                                Trace.traceData(this, "Failed to process Context Reference.", null);
                            }
                            if (!Trace.isOn) throw mqe;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 8);
                            throw mqe;
                        }
                    }
                    try {
                        MQException mqe = null;
                        MQQueue mQQueue = this;
                        // MONITORENTER : mQQueue
                        int messageDataLength = message.getMessageDataLength();
                        ByteBuffer msgData = message.getInternalBuffer();
                        if (Trace.isOn) {
                            Trace.traceData(this, "ProviderMessage length = " + messageDataLength + " butes.", null);
                            Trace.traceData(this, "\nput options   = " + putMessageOptions.options + "\nspi options   = " + spiOpts + "\nmessage type  = " + message.getMessageType() + "\nencoding      = " + message.getEncoding() + "\ncharacter set = " + message.getCharacterSet() + "\nformat        = " + message.getFormat(), null);
                            Trace.traceData(this, "message id: ", (Object)message.getMessageId());
                            Trace.traceData(this, "correlation id: ", (Object)message.getCorrelationId());
                        }
                        osession.spiPut(this.hconn, this.phobj.getHobj(), message, putMessageOptions, spiOpts, messageDataLength, msgData, this.completionCode, this.reason);
                        if (Trace.isOn) {
                            Trace.traceData(this, "Returned message id follows:", (Object)message.getMessageId());
                        }
                        if (this.completionCode.x != 0 || this.reason.x != 0) {
                            mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                        }
                        // MONITOREXIT : mQQueue
                        if (mqe != null) {
                            this.parentQmgr.errorOccurred(mqe);
                            if (!Trace.isOn) throw mqe;
                            Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 9);
                            throw mqe;
                        }
                    }
                    catch (MQException mqe) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 2);
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "Failed to put message.", null);
                        }
                        if (!Trace.isOn) throw mqe;
                        Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 10);
                        throw mqe;
                    }
                    Object var11_19 = null;
                    if (!Trace.isOn) break block40;
                }
                catch (MQException mqe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 3);
                    }
                    if (!Trace.isOn) throw mqe;
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)", mqe, 11);
                    throw mqe;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)");
            }
            if (Trace.isOn) {
                Trace.traceData(this, "spiPut completed with cc = " + this.completionCode.x + " rc = " + this.reason.x, null);
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)");
            }
            if (!Trace.isOn) throw throwable;
            Trace.traceData(this, "spiPut completed with cc = " + this.completionCode.x + " rc = " + this.reason.x, null);
            throw throwable;
        }
        if (!Trace.isOn) return;
        Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "spiPut(MQMsg2,MQPutMessageOptions,int)");
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQQueue.java, jmscc.wmq.v6, k701, k701-112-140304  1.34.1.6 11/11/24 13:32:51");
        }
        MQMI_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        jmqiEnv = MQSESSION.getJmqiEnv();
        smallMsgsBufferReductionThreshold = 10;
        Default_DefaultMsgLength = 4096;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "static()");
        }
        PropertyStore.register(smallMsgsBufferReductionThresholdProperty, smallMsgsBufferReductionThreshold, new Long(0L), null);
        smallMsgsBufferReductionThreshold = (int)PropertyStore.getLongProperty(smallMsgsBufferReductionThresholdProperty);
        Configuration config = new Configuration(jmqiEnv);
        Default_DefaultMsgLength = config.getIntValue(Configuration.defaultMaxMsgSizeProperty);
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "Set defaultMessageLength (com.ibm.mq.jmqi.defaultMaxMsgSize) to ", (Object)new Integer(Default_DefaultMsgLength));
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQQueue", "static()");
        }
    }
}

