/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.HashMap;

public class MQObjectInputStream
extends ObjectInputStream {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static HashMap primitiveClasses;
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQObjectInputStream.java, jmscc.wmq.v6, k701, k701-112-140304 1.23.1.1 09/08/17 08:03:09";
    ClassLoader cl = null;

    protected MQObjectInputStream(ClassLoader cl) throws IOException, SecurityException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "<init>(ClassLoader)", new Object[]{cl});
        }
        this.cl = cl;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "<init>(ClassLoader)");
        }
    }

    public MQObjectInputStream(InputStream in, ClassLoader cl) throws IOException, StreamCorruptedException {
        super(in);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "<init>(InputStream,ClassLoader)", new Object[]{in, cl});
        }
        this.cl = cl;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "<init>(InputStream,ClassLoader)");
        }
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", new Object[]{v});
        }
        try {
            if (Trace.isOn) {
                Trace.traceData(this, "Attempting to resolve class " + v.getName() + " using forName() with the classloader " + this.cl, null);
            }
            Class traceRet1 = CSSystem.dynamicLoadClass(v.getName(), this.getClass(), false);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", traceRet1, 1);
            }
            return traceRet1;
        }
        catch (ClassNotFoundException e) {
            Class returncl;
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", e, 1);
            }
            if ((returncl = (Class)primitiveClasses.get(v.getName())) != null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Resolved as primitive!", null);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", returncl, 2);
                }
                return returncl;
            }
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "forName() failed to resolve class " + v.getName() + " with classloader " + this.cl, null);
                    Trace.traceData(this, "Now attempting to resolve class " + v.getName() + " using forName() with the classloader " + this.getClass().getClassLoader(), null);
                }
                Class traceRet2 = CSSystem.dynamicLoadClass(v.getName(), this.getClass(), false);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", traceRet2, 3);
                }
                return traceRet2;
            }
            catch (ClassNotFoundException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", ex, 2);
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "forName() failed to resolve class " + v.getName() + " with classloader " + this.getClass().getClassLoader(), null);
                    Trace.traceData(this, "Attempting to resolve class " + v.getName() + " using loadClass() with the classloader " + this.cl, null);
                }
                Class<?> traceRet3 = this.cl.loadClass(v.getName());
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "resolveClass(ObjectStreamClass)", traceRet3, 4);
                }
                return traceRet3;
            }
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQObjectInputStream.java, jmscc.wmq.v6, k701, k701-112-140304  1.23.1.1 09/08/17 08:03:09");
        }
        primitiveClasses = new HashMap();
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "static()");
        }
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("void", Void.TYPE);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQObjectInputStream", "static()");
        }
    }
}

