/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.MQMD;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.mq.jmqi.system.JmqiComponentTls;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.JmqiTls;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class MQMsg2
extends JmqiObject {
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQMsg2.java, jmscc.wmq.v6, k701, k701-112-140304 1.38.1.2 11/11/11 09:18:42";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int INITIAL_MSG_SIZE = 2048;
    private static JmqiEnvironment jmqiEnv;
    private static JmqiSystemEnvironment jmqiSysEnv;
    private MQMD jmqiStructure = MQSESSION.getJmqiEnv().newMQMD();
    private long putTimeMillis;
    private int ccsidForStrings;
    private boolean stringsNeedCcsidConversion = false;
    private boolean ccsidForStringsIsAscii;
    private ByteBuffer messageData = null;
    private int messageDataOffset = 0;
    private int readCursor = 0;

    public MQMsg2() {
        super(MQSESSION.getJmqiEnv());
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "<init>()");
        }
        this.jmqiStructure.setCodedCharSetId(MQSESSION.getDefaultCCSID());
        this.jmqiStructure.setVersion(2);
        this.messageData = ByteBuffer.allocate(2048);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "<init>()");
        }
    }

    public String getFormat() throws MQException {
        String traceRet1 = this.jmqiStructure.getFormat();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getFormat()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public long getFormatAsLong() throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getFormatAsLong()");
        }
        long retValue = 0L;
        String fmt = this.jmqiStructure.getFormat();
        if (fmt != null) {
            byte[] format = fmt.getBytes();
            for (int i = 0; i < 8; ++i) {
                retValue <<= 8;
                long value = format[i];
                if (value < 0L) {
                    value += 256L;
                }
                retValue += value;
            }
        } else {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("MQMD.format", "null");
            Trace.ffst((Object)this, "getFormatAsLong", "XO003001", data, MQException.class);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getFormatAsLong()", new Long(retValue));
        }
        return retValue;
    }

    public void setFormat(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setFormat(String)", "setter", s);
        }
        this.jmqiStructure.setFormat(s);
    }

    public String getReplyToQueueName() throws MQException {
        String traceRet1 = this.jmqiStructure.getReplyToQ();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getReplyToQueueName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setReplyToQueueName(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setReplyToQueueName(String)", "setter", s);
        }
        this.jmqiStructure.setReplyToQ(s);
    }

    public void resetReplyToQueueName() throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "resetReplyToQueueName()");
        }
        this.jmqiStructure.setReplyToQ(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "resetReplyToQueueName()");
        }
    }

    public String getReplyToQueueManagerName() throws MQException {
        String result = this.jmqiStructure.getReplyToQMgr();
        if (result == null) {
            result = "";
        }
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getReplyToQueueManagerName()", "getter", result);
        }
        return result;
    }

    public void setReplyToQueueManagerName(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setReplyToQueueManagerName(String)", "setter", s);
        }
        this.jmqiStructure.setReplyToQMgr(s);
    }

    public void resetReplyToQueueManagerName() throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "resetReplyToQueueManagerName()");
        }
        this.jmqiStructure.setReplyToQMgr(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "resetReplyToQueueManagerName()");
        }
    }

    public String getUserId() throws MQException {
        String traceRet1 = this.jmqiStructure.getUserIdentifier();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getUserId()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public byte[] getUserIdAsBytes() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getUserIdAsBytes()");
        }
        String s = this.jmqiStructure.getUserIdentifier();
        byte[] traceRet1 = null;
        traceRet1 = s != null ? s.getBytes() : new byte[12];
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getUserIdAsBytes()", traceRet1);
        }
        return traceRet1;
    }

    public void setUserId(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setUserId(String)", "setter", s);
        }
        this.jmqiStructure.setUserIdentifier(s);
    }

    public String getApplicationIdData() throws MQException {
        String traceRet1 = this.jmqiStructure.getApplIdentityData();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getApplicationIdData()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setApplicationIdData(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setApplicationIdData(String)", "setter", s);
        }
        this.jmqiStructure.setApplIdentityData(s);
    }

    public String getPutApplicationName() throws MQException {
        String traceRet1 = this.jmqiStructure.getPutApplName();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutApplicationName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public byte[] getPutApplicationNameAsBytes() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutApplicationNameAsBytes()");
        }
        String s = this.jmqiStructure.getPutApplName();
        byte[] traceRet1 = null;
        traceRet1 = s != null ? s.getBytes() : new byte[28];
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutApplicationNameAsBytes()", traceRet1);
        }
        return traceRet1;
    }

    public void setPutApplicationName(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setPutApplicationName(String)", "setter", s);
        }
        this.jmqiStructure.setPutApplName(s);
    }

    public String getApplicationOriginData() throws MQException {
        String traceRet1 = this.jmqiStructure.getApplOriginData();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getApplicationOriginData()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setApplicationOriginData(String s) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setApplicationOriginData(String)", "setter", s);
        }
        this.jmqiStructure.setApplOriginData(s);
    }

    public int getReport() {
        int traceRet1 = this.jmqiStructure.getReport();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getReport()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setReport(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setReport(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setReport(i);
    }

    public int getMessageType() {
        int traceRet1 = this.jmqiStructure.getMsgType();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageType()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMessageType(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageType(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setMsgType(i);
    }

    public int getExpiry() {
        int traceRet1 = this.jmqiStructure.getExpiry();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getExpiry()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setExpiry(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setExpiry(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setExpiry(i);
    }

    public int getFeedback() {
        int traceRet1 = this.jmqiStructure.getFeedback();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getFeedback()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setFeedback(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setFeedback(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setFeedback(i);
    }

    public int getEncoding() {
        int traceRet1 = this.jmqiStructure.getEncoding();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getEncoding()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setEncoding(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setEncoding(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setEncoding(i);
    }

    public int getCharacterSet() {
        int traceRet1 = this.jmqiStructure.getCodedCharSetId();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getCharacterSet()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setCharacterSet(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setCharacterSet(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setCodedCharSetId(i);
    }

    public int getPriority() {
        int traceRet1 = this.jmqiStructure.getPriority();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPriority()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setPriority(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setPriority(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setPriority(i);
    }

    public int getPersistence() {
        int traceRet1 = this.jmqiStructure.getPersistence();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPersistence()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setPersistence(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setPersistence(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setPersistence(i);
    }

    public int getBackoutCount() {
        int traceRet1 = this.jmqiStructure.getBackoutCount();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getBackoutCount()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setBackoutCount(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setBackoutCount(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setBackoutCount(i);
    }

    public int getPutApplicationType() {
        int traceRet1 = this.jmqiStructure.getPutApplType();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutApplicationType()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setPutApplicationType(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setPutApplicationType(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setPutApplType(i);
    }

    public int getMessageSequenceNumber() {
        int traceRet1 = this.jmqiStructure.getMsgSeqNumber();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageSequenceNumber()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMessageSequenceNumber(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageSequenceNumber(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setMsgSeqNumber(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public int getOffset() {
        int traceRet1 = this.jmqiStructure.getOffset();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getOffset()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setOffset(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setOffset(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setOffset(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public int getMessageFlags() {
        int traceRet1 = this.jmqiStructure.getMsgFlags();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageFlags()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setMessageFlags(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageFlags(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setMsgFlags(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public int getOriginalLength() {
        int traceRet1 = this.jmqiStructure.getOriginalLength();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getOriginalLength()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setOriginalLength(int i) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setOriginalLength(int)", "setter", new Integer(i));
        }
        this.jmqiStructure.setOriginalLength(i);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public byte[] getMessageId() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageId()");
        }
        byte[] returnValue = new byte[24];
        System.arraycopy(this.jmqiStructure.getMsgId(), 0, returnValue, 0, 24);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageId()", returnValue);
        }
        return returnValue;
    }

    public void setMessageId(byte[] value) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageId(byte [ ])", "setter", value);
        }
        this.jmqiStructure.setMsgId(value);
    }

    public byte[] getMessageIdRef() {
        byte[] traceRet1 = this.jmqiStructure.getMsgId();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageIdRef()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public byte[] getCorrelationId() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getCorrelationId()");
        }
        byte[] returnValue = new byte[24];
        System.arraycopy(this.jmqiStructure.getCorrelId(), 0, returnValue, 0, 24);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getCorrelationId()", returnValue);
        }
        return returnValue;
    }

    public void setCorrelationId(byte[] value) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setCorrelationId(byte [ ])", "setter", value);
        }
        this.jmqiStructure.setCorrelId(value);
    }

    public byte[] getCorrelationIdRef() {
        byte[] traceRet1 = this.jmqiStructure.getCorrelId();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getCorrelationIdRef()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public byte[] getAccountingToken() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getAccountingToken()");
        }
        byte[] returnValue = new byte[32];
        System.arraycopy(this.jmqiStructure.getAccountingToken(), 0, returnValue, 0, 32);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getAccountingToken()", returnValue);
        }
        return returnValue;
    }

    public void setAccountingToken(byte[] b) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setAccountingToken(byte [ ])", "setter", b);
        }
        this.jmqiStructure.setAccountingToken(b);
    }

    public byte[] getGroupId() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getGroupId()");
        }
        byte[] returnValue = new byte[24];
        System.arraycopy(this.jmqiStructure.getGroupId(), 0, returnValue, 0, 24);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getGroupId()", returnValue);
        }
        return returnValue;
    }

    public void setGroupId(byte[] value) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setGroupId(byte [ ])", "setter", value);
        }
        this.jmqiStructure.setGroupId(value);
        if (this.jmqiStructure.getVersion() < 2) {
            this.jmqiStructure.setVersion(2);
        }
    }

    public byte[] getPutDateAsBytes() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutDateAsBytes()");
        }
        String s = this.jmqiStructure.getPutDate();
        byte[] traceRet1 = null;
        traceRet1 = s != null ? s.getBytes() : new byte[8];
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutDateAsBytes()", traceRet1);
        }
        return traceRet1;
    }

    public String getPutDate() {
        String traceRet1 = this.jmqiStructure.getPutDate();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutDate()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setPutDate(String s) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setPutDate(String)", "setter", s);
        }
        this.jmqiStructure.setPutDate(s);
    }

    public byte[] getPutTimeAsBytes() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutTimeAsBytes()");
        }
        String s = this.jmqiStructure.getPutTime();
        byte[] traceRet1 = null;
        traceRet1 = s != null ? s.getBytes() : new byte[8];
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutTimeAsBytes()", traceRet1);
        }
        return traceRet1;
    }

    public String getPutTime() {
        String traceRet1 = this.jmqiStructure.getPutTime();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutTime()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setPutTime(String s) {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setPutTime(String)", "setter", s);
        }
        this.jmqiStructure.setPutTime(s);
    }

    public int getVersion() {
        int traceRet1 = this.jmqiStructure.getVersion();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getVersion()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public long getPutTimeMillis() throws MQException {
        this.putTimeMillis = MQDateConverter.mqDateTimeToMillis(this.jmqiStructure.getPutTime(), this.jmqiStructure.getPutDate());
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getPutTimeMillis()", "getter", new Long(this.putTimeMillis));
        }
        return this.putTimeMillis;
    }

    public int _getCcsid() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "_getCcsid()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "_getCcsid()", new Integer(this.ccsidForStrings));
        }
        return this.ccsidForStrings;
    }

    public boolean _getIsCcsidAscii() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "_getIsCcsidAscii()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "_getIsCcsidAscii()", this.ccsidForStringsIsAscii);
        }
        return this.ccsidForStringsIsAscii;
    }

    public boolean _doStringsNeedCcsidConversion() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "_doStringsNeedCcsidConversion()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "_doStringsNeedCcsidConversion()", this.stringsNeedCcsidConversion);
        }
        return this.stringsNeedCcsidConversion;
    }

    public void setCharacterSetToDefault() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setCharacterSetToDefault()");
        }
        this.jmqiStructure.setCodedCharSetId(MQSESSION.getDefaultCCSID());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setCharacterSetToDefault()");
        }
    }

    private boolean isVersion1Safe() {
        boolean traceRet1;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "isVersion1Safe()");
        }
        boolean invalidGroupId = false;
        byte[] groupId = this.jmqiStructure.getGroupId();
        if (groupId != null) {
            for (int i = 0; i < groupId.length && !invalidGroupId; ++i) {
                if (groupId[i] == 0) continue;
                invalidGroupId = true;
            }
        }
        boolean bl = traceRet1 = !invalidGroupId && this.jmqiStructure.getMsgSeqNumber() == 1 && this.jmqiStructure.getOffset() == 0 && this.jmqiStructure.getMsgFlags() == 0 && this.jmqiStructure.getOriginalLength() == -1;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "isVersion1Safe()", traceRet1);
        }
        return traceRet1;
    }

    public void setVersion(int newVersion) throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setVersion(int)", new Object[]{new Integer(newVersion)});
        }
        if (newVersion > 2 || newVersion < 1) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJE064", "" + newVersion);
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setVersion(int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (newVersion == 1 && !this.isVersion1Safe()) {
            MQException traceRet2 = new MQException(2, 2026, (Object)this, "MQJE055");
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setVersion(int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        this.jmqiStructure.setVersion(newVersion);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setVersion(int)");
        }
    }

    public byte[] getMessageData() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageData()");
        }
        byte[] returnData = null;
        returnData = new byte[this.messageDataOffset];
        this.messageData.position(0);
        this.messageData.get(returnData, 0, this.messageDataOffset);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageData()", returnData);
        }
        return returnData;
    }

    public byte[] getMessageDataRef() {
        byte[] traceRet1 = this.messageData.array();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageDataRef()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public void setMessageData(ByteBuffer data) throws MQException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageData(ByteBuffer)", "setter", data);
        }
        this.setMessageData(data, data.limit());
    }

    public void setMessageData(ByteBuffer data, int messageLength) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageData(ByteBuffer,int)", new Object[]{data, new Integer(messageLength)});
        }
        if (messageLength == data.limit()) {
            this.messageData = data;
        } else {
            this.messageData = ByteBuffer.allocate(messageLength);
            this.messageData.put(data.array(), 0, messageLength);
        }
        this.messageDataOffset = messageLength;
        this.readCursor = 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setMessageData(ByteBuffer,int)");
        }
    }

    protected void setInternalBuffer(ByteBuffer data, int len) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setInternalBuffer(ByteBuffer,int)", new Object[]{data, new Integer(len)});
        }
        this.messageData = data;
        this.messageDataOffset = len;
        this.readCursor = 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "setInternalBuffer(ByteBuffer,int)");
        }
    }

    protected ByteBuffer getInternalBuffer() {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getInternalBuffer()", "getter", this.messageData);
        }
        return this.messageData;
    }

    private void expandMessageData(int newMinSize) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "expandMessageData(int)", new Object[]{new Integer(newMinSize)});
        }
        ByteBuffer tmp = ByteBuffer.allocate(newMinSize);
        this.messageData.position(0);
        this.messageData.limit(this.messageDataOffset);
        tmp.put(this.messageData);
        this.messageData = tmp;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "expandMessageData(int)");
        }
    }

    public final void appendInt(int value, int encoding) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendInt(int,int)", new Object[]{new Integer(value), new Integer(encoding)});
        }
        if (this.messageData.capacity() < this.messageDataOffset + 4) {
            this.expandMessageData(this.messageDataOffset + 4);
        }
        try {
            switch (encoding & 0xF) {
                case 0: 
                case 1: {
                    this.messageData.order(ByteOrder.BIG_ENDIAN);
                    this.messageData.putInt(this.messageDataOffset, value);
                    this.messageDataOffset += 4;
                    break;
                }
                case 2: {
                    this.messageData.order(ByteOrder.LITTLE_ENDIAN);
                    this.messageData.putInt(this.messageDataOffset, value);
                    this.messageDataOffset += 4;
                    break;
                }
                default: {
                    IOException traceRet1 = new IOException("unknown encoding: " + (encoding & 0xF));
                    if (Trace.isOn) {
                        Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendInt(int,int)", traceRet1, 1);
                    }
                    throw traceRet1;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendInt(int,int)", aioobe);
            }
            IOException traceRet2 = new IOException(aioobe.getMessage());
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendInt(int,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendInt(int,int)");
        }
    }

    public final void appendByteArray(byte[] data) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendByteArray(byte [ ])", new Object[]{data});
        }
        if (this.messageData.capacity() < this.messageDataOffset + data.length) {
            this.expandMessageData(this.messageDataOffset + data.length);
        }
        this.messageData.position(this.messageDataOffset);
        this.messageData.put(data);
        this.messageDataOffset += data.length;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendByteArray(byte [ ])");
        }
    }

    public void appendByteArray(byte[] data, int offset, int length) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendByteArray(byte [ ],int,int)", new Object[]{data, new Integer(offset), new Integer(length)});
        }
        if (this.messageData.capacity() < this.messageDataOffset + length) {
            this.expandMessageData(this.messageDataOffset + length);
        }
        this.messageData.position(this.messageDataOffset);
        this.messageData.put(data, offset, length);
        this.messageDataOffset += length;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "appendByteArray(byte [ ],int,int)");
        }
    }

    public int getMessageDataLength() {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getMessageDataLength()", "getter", new Integer(this.messageDataOffset));
        }
        return this.messageDataOffset;
    }

    public void clearMessageData() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "clearMessageData()");
        }
        this.messageDataOffset = 0;
        this.readCursor = 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "clearMessageData()");
        }
    }

    public int readInt(int encoding) throws IOException, EOFException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "readInt(int)", new Object[]{new Integer(encoding)});
        }
        if (this.messageData.capacity() - this.readCursor < 4) {
            EOFException traceRet1 = new EOFException("end of message reached");
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "readInt(int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        try {
            switch (encoding & 0xF) {
                case 0: 
                case 1: {
                    this.messageData.order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 2: {
                    this.messageData.order(ByteOrder.LITTLE_ENDIAN);
                    break;
                }
                default: {
                    IOException traceRet2 = new IOException("unknown encoding: " + (encoding & 0xF));
                    if (Trace.isOn) {
                        Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "readInt(int)", traceRet2, 2);
                    }
                    throw traceRet2;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "readInt(int)", aioobe);
            }
            IOException traceRet3 = new IOException(aioobe.getMessage());
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "readInt(int)", traceRet3, 3);
            }
            throw traceRet3;
        }
        int retVal = this.messageData.getInt(this.readCursor);
        this.readCursor += 4;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "readInt(int)", new Integer(retVal));
        }
        return retVal;
    }

    public void skipReadingBytes(int bytesToSkip) throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "skipReadingBytes(int)", new Object[]{new Integer(bytesToSkip)});
        }
        this.readCursor += bytesToSkip;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "skipReadingBytes(int)");
        }
    }

    public int read(byte[] data) throws MQException {
        int traceRet1;
        int readLen;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "read(byte [ ])", new Object[]{data});
        }
        if (this.messageDataOffset - this.readCursor < (readLen = data.length)) {
            readLen = this.messageDataOffset - this.readCursor;
        }
        if (readLen > 0) {
            this.messageData.position(this.readCursor);
            this.messageData.get(data, 0, readLen);
        }
        this.readCursor += readLen;
        int n = traceRet1 = readLen > 0 ? readLen : -1;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "read(byte [ ])", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void resetReadPosition() throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "resetReadPosition()");
        }
        this.readCursor = 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "resetReadPosition()");
        }
    }

    protected MQMD getJMQIStructure() {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "getJMQIStructure()", "getter", this.jmqiStructure);
        }
        return this.jmqiStructure;
    }

    protected final int sizeOfMQMD() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "sizeOfMQMD()");
        }
        int version = this.jmqiStructure.getVersion();
        int pointerSize = 4;
        int size = 0;
        try {
            size = MQMD.getSize((JmqiEnvironment)this.env, (int)version, (int)pointerSize);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "sizeOfMQMD()", e);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("version", Integer.toString(version));
            data.put("pointerSize", Integer.toString(pointerSize));
            data.put("exception", (Object)e);
            Trace.ffst((Object)this, "sizeOfMQMD", "probe1", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "sizeOfMQMD()", new Integer(size));
        }
        return size;
    }

    public final DataOutputStream writeTo(DataOutputStream dataBuffer, int ccsid, boolean ccsidIsAscii) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "writeTo(DataOutputStream,int,boolean)", new Object[]{dataBuffer, new Integer(ccsid), ccsidIsAscii});
        }
        try {
            int pointerSize = 4;
            JmqiCodepage cp = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)this.env, (int)ccsid);
            int requiredSize = this.jmqiStructure.getRequiredBufferSize(pointerSize, cp);
            byte[] data = new byte[requiredSize];
            boolean swap = false;
            JmqiComponentTls tls = jmqiSysEnv.getComponentTls(MQSESSION.jmsv6CompId);
            JmqiTls jTls = jmqiSysEnv.getJmqiTls(tls);
            this.jmqiStructure.writeToBuffer(data, 0, pointerSize, swap, cp, jTls);
            dataBuffer.write(data);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "writeTo(DataOutputStream,int,boolean)", e);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ccsid", Integer.toString(ccsid));
            data.put("exception", (Object)e);
            Trace.ffst((Object)this, "writeTo", "probe1", data, MQException.class);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "writeTo(DataOutputStream,int,boolean)", dataBuffer);
        }
        return dataBuffer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQMsg2", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQMsg2.java, jmscc.wmq.v6, k701, k701-112-140304  1.38.1.2 11/11/11 09:18:42");
        }
        jmqiEnv = MQSESSION.getJmqiEnv();
        jmqiSysEnv = (JmqiSystemEnvironment)jmqiEnv;
    }
}

