/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQMD;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;

public class MQMessage
extends MQMD {
    private static final int CHAR_SIZEOF = 2;
    private static final int CODESET_UCS = 1200;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQMessage.java, jmscc.wmq.v6, k701, k701-112-140304 1.29.1.1 09/08/17 08:02:40";
    private static final int INT_SIZEOF = 4;
    protected static final int READ_MODE = 1;
    protected static final int WRITE_MODE = 2;
    private int _bufferSizeHint = -1;
    private int _dataLength;
    private ByteArrayInputStream _readBytes;
    private ByteArrayOutputStream _writeBytes;
    private int cursorPos;
    private byte[] dataBuffer;
    private int mode;
    private DataInputStream readStream;
    private byte[] reversingBuffer = new byte[8];
    private ByteArrayOutputStream reversingOutBytes = new ByteArrayOutputStream();
    private DataOutputStream reversingOutStream;
    private DataOutputStream writeStream;

    public MQMessage() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "<init>()");
        }
        this.dataBuffer = new byte[0];
        this._readBytes = new ByteArrayInputStream(this.dataBuffer);
        this._writeBytes = new ByteArrayOutputStream(100);
        this.readStream = new DataInputStream(this._readBytes);
        this.writeStream = new DataOutputStream(this._writeBytes);
        this.mode = 2;
        this.cursorPos = 0;
        this._dataLength = 0;
        this.reversingOutStream = new DataOutputStream(this.reversingOutBytes);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "<init>()");
        }
    }

    public void clearMessage() throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "clearMessage()");
        }
        this.reset();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "clearMessage()");
        }
    }

    protected int getBufferSizeHint() {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "getBufferSizeHint()", "getter", new Integer(this._bufferSizeHint));
        }
        return this._bufferSizeHint;
    }

    private String getCharacterSetString(int charSet) {
        String retVal;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "getCharacterSetString(int)", new Object[]{new Integer(charSet)});
        }
        if (charSet == 0) {
            charSet = MQSESSION.getDefaultCCSID();
        }
        if ((retVal = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (int)charSet).charsetId) == null) {
            retVal = "Cp" + Integer.toString(charSet);
        }
        if (Trace.isOn) {
            Trace.traceData((Object)this, "Mapped " + charSet + " -> " + retVal, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "getCharacterSetString(int)", retVal);
        }
        return retVal;
    }

    public int getDataLength() throws IOException {
        if (this.mode != 1) {
            this.setMode(1);
        }
        int retVal = this._readBytes.available();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "getDataLength()", "getter", new Integer(retVal));
        }
        return retVal;
    }

    public int getDataOffset() throws IOException {
        if (this.mode != 1) {
            this.setMode(1);
        }
        int retVal = this._dataLength - this._readBytes.available();
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "getDataOffset()", "getter", new Integer(retVal));
        }
        return retVal;
    }

    public int getMessageLength() throws IOException {
        if (this.mode != 1) {
            this.setMode(1);
        }
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "getMessageLength()", "getter", new Integer(this.dataBuffer.length));
        }
        return this.dataBuffer.length;
    }

    public byte readByte() throws IOException, EOFException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readByte()");
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        byte retVal = this.readStream.readByte();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readByte()", new Byte(retVal));
        }
        return retVal;
    }

    public char readChar() throws IOException, EOFException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readChar()");
        }
        char retVal = '\u0000';
        if (this.mode != 1) {
            this.setMode(1);
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                retVal = this.readStream.readChar();
                break;
            }
            case 2: {
                DataInputStream rIn = this.readReverse(2);
                retVal = rIn.readChar();
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "Invalid encoding : " + (this.encoding & 0xF00), null);
                }
                IOException traceRet1 = new IOException("Invalid encoding : " + (this.encoding & 0xF00));
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readChar()", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readChar()", new Character(retVal));
        }
        return retVal;
    }

    private String readConvertedLine() throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readConvertedLine()");
        }
        byte[] stringBytes = new byte[this.getDataLength()];
        System.arraycopy(this.dataBuffer, this.getDataOffset(), stringBytes, 0, stringBytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(stringBytes);
        BufferedReader isr = new BufferedReader(new InputStreamReader((InputStream)bais, this.getCharacterSetString(this.characterSet)));
        if (Trace.isOn) {
            Trace.traceData((Object)this, "Built InputStreamReader", null);
        }
        StringBuffer retVal = new StringBuffer(this.getDataLength());
        String ending = "";
        boolean readLine = false;
        block5: while (!readLine) {
            if (isr.ready()) {
                int aChar = isr.read();
                switch (aChar) {
                    case -1: {
                        readLine = true;
                        break;
                    }
                    case 10: {
                        ending = "\n";
                        readLine = true;
                        break;
                    }
                    case 13: {
                        int anotherChar;
                        readLine = true;
                        ending = "\r";
                        if (!isr.ready() || (anotherChar = isr.read()) != 10) continue block5;
                        ending = "\r\n";
                        break;
                    }
                    default: {
                        retVal.append((char)aChar);
                    }
                }
                continue;
            }
            readLine = true;
        }
        int bytesUsed = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, this.getCharacterSetString(this.characterSet));
        String charsRead = retVal + ending;
        osw.write(charsRead, 0, charsRead.length());
        osw.flush();
        bytesUsed = baos.toByteArray().length;
        this.readStream.skip(bytesUsed);
        if (Trace.isOn) {
            Trace.traceData((Object)this, "Read string: '" + retVal + "', " + bytesUsed + " bytes.", null);
        }
        String traceRet1 = retVal.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readConvertedLine()", traceRet1);
        }
        return traceRet1;
    }

    public void readFully(byte[] b) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readFully(byte [ ])", new Object[]{b});
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        this.readStream.readFully(b);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readFully(byte [ ])");
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readFully(byte [ ],int,int)", new Object[]{b, new Integer(off), new Integer(len)});
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        this.readStream.readFully(b, off, len);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readFully(byte [ ],int,int)");
        }
    }

    /*
     * WARNING - void declaration
     */
    public int readInt() throws IOException {
        void var1_1;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readInt()");
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                int retVal = this.readStream.readInt();
                break;
            }
            case 2: {
                DataInputStream rIn = this.readReverse(4);
                int retVal = rIn.readInt();
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "Invalid encoding : " + (this.encoding & 0xF00), null);
                }
                IOException traceRet1 = new IOException("Invalid encoding : " + (this.encoding & 0xF00));
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readInt()", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readInt()", new Integer((int)var1_1));
        }
        return (int)var1_1;
    }

    public String readLine() throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readLine()");
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        switch (this.characterSet) {
            case 1200: {
                String traceRet1 = this.readUnicodeLine();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readLine()", traceRet1, 1);
                }
                return traceRet1;
            }
        }
        String traceRet3 = this.readConvertedLine();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readLine()", traceRet3, 2);
        }
        return traceRet3;
    }

    private final DataInputStream readReverse(int numBytes) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readReverse(int)", new Object[]{new Integer(numBytes)});
        }
        this.readStream.read(this.reversingBuffer, 0, numBytes);
        this.reverse(this.reversingBuffer, numBytes);
        ByteArrayInputStream bIn = new ByteArrayInputStream(this.reversingBuffer);
        DataInputStream dIS = new DataInputStream(bIn);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readReverse(int)", dIS);
        }
        return dIS;
    }

    public String readStringOfByteLength(int numberOfBytes) throws IOException, EOFException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readStringOfByteLength(int)", new Object[]{new Integer(numberOfBytes)});
        }
        byte[] b = new byte[numberOfBytes];
        String result = null;
        int originalDataOffset = this.getDataOffset();
        if (this.mode != 1) {
            this.setMode(1);
        }
        try {
            this.readStream.readFully(b, 0, numberOfBytes);
            result = new String(b, this.getCharacterSetString(this.characterSet));
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readStringOfByteLength(int)", e);
            }
            this.setDataOffset(originalDataOffset);
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readStringOfByteLength(int)", e);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readStringOfByteLength(int)", result);
        }
        return result;
    }

    private String readUnicodeLine() throws IOException {
        StringBuffer retVal;
        block10: {
            if (Trace.isOn) {
                Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readUnicodeLine()");
            }
            retVal = new StringBuffer(this.getDataLength() / 2);
            try {
                boolean endOfLine = false;
                block6: while (!endOfLine) {
                    char thisChar = this.readChar();
                    switch (thisChar) {
                        case '\n': {
                            endOfLine = true;
                            continue block6;
                        }
                        case '\r': {
                            char anotherChar;
                            endOfLine = true;
                            if (this.getDataLength() < 2 || (anotherChar = this.readChar()) == '\n') continue block6;
                            this.seek(this.getDataOffset() - 2);
                            continue block6;
                        }
                    }
                    retVal.append(thisChar);
                }
            }
            catch (EOFException ex) {
                if (Trace.isOn) {
                    Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readUnicodeLine()", ex);
                }
                if (!Trace.isOn) break block10;
                Trace.traceData((Object)this, "hit end of file!", null);
            }
        }
        String traceRet1 = retVal.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "readUnicodeLine()", traceRet1);
        }
        return traceRet1;
    }

    private final synchronized void reset() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "reset()");
        }
        this._writeBytes.reset();
        this.dataBuffer = new byte[0];
        this._readBytes = new ByteArrayInputStream(this.dataBuffer);
        this.readStream = new DataInputStream(this._readBytes);
        this.mode = 2;
        this.cursorPos = 0;
        this._dataLength = 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "reset()");
        }
    }

    private final void reverse(byte[] buffer, int length) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "reverse(byte [ ],int)", new Object[]{buffer, new Integer(length)});
        }
        for (int i = 0; i < length / 2; ++i) {
            byte temp = buffer[i];
            buffer[i] = buffer[length - 1 - i];
            buffer[length - 1 - i] = temp;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "reverse(byte [ ],int)");
        }
    }

    public void seek(int offset) throws EOFException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "seek(int)", new Object[]{new Integer(offset)});
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        if (offset > this._dataLength) {
            EOFException traceRet1 = new EOFException("offset greater than dataLength");
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "seek(int)", traceRet1);
            }
            throw traceRet1;
        }
        this._readBytes.reset();
        this._readBytes.skip(offset);
        this.cursorPos = offset;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "seek(int)");
        }
    }

    public void setDataOffset(int offset) throws EOFException {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "setDataOffset(int)", "setter", new Integer(offset));
        }
        this.seek(offset);
    }

    protected final void setMessageData(ByteBuffer data, int messageLength, int totalMessageLength) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "setMessageData(ByteBuffer,int,int)", new Object[]{data, new Integer(messageLength), new Integer(totalMessageLength)});
        }
        this._writeBytes.reset();
        if (Trace.isOn) {
            Trace.traceData((Object)this, "Array size mismatch: Making copy of byte array", null);
        }
        this.dataBuffer = new byte[messageLength];
        System.arraycopy(data.array(), 0, this.dataBuffer, 0, messageLength);
        this._dataLength = messageLength;
        this.cursorPos = 0;
        this._readBytes = new ByteArrayInputStream(this.dataBuffer);
        this.readStream = new DataInputStream(this._readBytes);
        this.mode = 1;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "setMessageData(ByteBuffer,int,int)");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void setMode(int mode) {
        block12: {
            if (Trace.isOn) {
                Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "setMode(int)", new Object[]{new Integer(mode)});
            }
            if (mode == this.mode) break block12;
            switch (mode) {
                case 1: {
                    if (Trace.isOn) {
                        Trace.traceData((Object)this, "Switching to read mode", null);
                    }
                    writtenBytes = null;
                    writtenBytes = this._writeBytes.toByteArray();
                    this._dataLength = this.cursorPos + Math.max(writtenBytes.length, this.dataBuffer.length - this.cursorPos);
                    tempBuffer = new byte[this._dataLength];
                    try {
                        System.arraycopy(this.dataBuffer, 0, tempBuffer, 0, this.cursorPos);
                        System.arraycopy(writtenBytes, 0, tempBuffer, this.cursorPos, writtenBytes.length);
                        bytesRemaining = this.dataBuffer.length - this.cursorPos - writtenBytes.length;
                        if (bytesRemaining > 0) {
                            System.arraycopy(this.dataBuffer, this.cursorPos + writtenBytes.length, tempBuffer, this.cursorPos + writtenBytes.length, bytesRemaining);
                        }
                    }
                    catch (Exception e) {
                        if (Trace.isOn) {
                            Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "setMode(int)", e);
                        }
                        if (!Trace.isOn) ** GOTO lbl24
                        Trace.traceData((Object)this, "Exception building message data " + e, null);
                    }
lbl24:
                    // 3 sources

                    this.dataBuffer = tempBuffer;
                    this._readBytes = new ByteArrayInputStream(this.dataBuffer);
                    this.readStream = new DataInputStream(this._readBytes);
                    this.cursorPos += writtenBytes.length;
                    this._readBytes.skip(this.cursorPos);
                    this._writeBytes.reset();
                    this.mode = 1;
                    break;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.traceData((Object)this, "Switching to write mode", null);
                    }
                    this.cursorPos = this._dataLength - this._readBytes.available();
                    this.mode = 2;
                    break;
                }
                default: {
                    if (!Trace.isOn) break;
                    Trace.traceData((Object)this, "Invalid mode : " + mode, null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "setMode(int)");
        }
    }

    public int skipBytes(int n) throws IOException, EOFException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "skipBytes(int)", new Object[]{new Integer(n)});
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        int maxBytesToSkip = Math.min(n, this._readBytes.available());
        if (Trace.isOn) {
            Trace.traceData((Object)this, "Skipping " + maxBytesToSkip + " bytes.", null);
        }
        this.readStream.skipBytes(maxBytesToSkip);
        if (maxBytesToSkip < n) {
            EOFException traceRet1 = new EOFException("insufficient bytes remain");
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "skipBytes(int)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "skipBytes(int)", new Integer(maxBytesToSkip));
        }
        return maxBytesToSkip;
    }

    protected final byte[] toByteArray() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "toByteArray()");
        }
        if (this.mode != 1) {
            this.setMode(1);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "toByteArray()", this.dataBuffer);
        }
        return this.dataBuffer;
    }

    public void write(byte[] b) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "write(byte [ ])", new Object[]{b});
        }
        if (this.mode != 2) {
            this.setMode(2);
        }
        this.writeStream.write(b);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "write(byte [ ])");
        }
    }

    public void write(int b) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "write(int)", new Object[]{new Integer(b)});
        }
        if (this.mode != 2) {
            this.setMode(2);
        }
        this.writeStream.write(b);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "write(int)");
        }
    }

    public void writeChar(int v) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChar(int)", new Object[]{new Integer(v)});
        }
        if (this.mode != 2) {
            this.setMode(2);
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.writeStream.writeChar(v);
                break;
            }
            case 2: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeChar(v);
                byte[] b = this.reversingOutBytes.toByteArray();
                this.reverse(b, 2);
                this.writeStream.write(b);
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "Unsupported encoding: " + (this.encoding & 0xF), null);
                }
                IOException traceRet1 = new IOException("Unsupported encoding: " + (this.encoding & 0xF));
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChar(int)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChar(int)");
        }
    }

    public void writeChars(String s) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChars(String)", new Object[]{s});
        }
        if (this.mode != 2) {
            this.setMode(2);
        }
        try {
            for (int i = 0; i < s.length(); ++i) {
                this.writeChar(s.charAt(i));
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChars(String)", ex);
            }
            IOException traceRet1 = new IOException(ex.toString());
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChars(String)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeChars(String)");
        }
    }

    public void writeInt(int v) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeInt(int)", new Object[]{new Integer(v)});
        }
        if (this.mode != 2) {
            this.setMode(2);
        }
        switch (this.encoding & 0xF) {
            case 0: 
            case 1: {
                this.writeStream.writeInt(v);
                break;
            }
            case 2: {
                this.reversingOutBytes.reset();
                this.reversingOutStream.writeInt(v);
                byte[] b = this.reversingOutBytes.toByteArray();
                this.reverse(b, 4);
                this.writeStream.write(b);
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.traceData((Object)this, "Unsupported encoding: " + (this.encoding & 0xF), null);
                }
                IOException traceRet1 = new IOException("Unsupported encoding: " + (this.encoding & 0xF));
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeInt(int)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeInt(int)");
        }
    }

    public void writeString(String s) throws IOException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeString(String)", new Object[]{s});
        }
        if (this.mode != 2) {
            this.setMode(2);
        }
        switch (this.characterSet) {
            case 1200: {
                this.writeChars(s);
                break;
            }
            case 0: {
                this.characterSet = MQSESSION.getDefaultCCSID();
            }
            default: {
                if (this.getCharacterSetString(this.characterSet).equals("Cp930")) {
                    byte[] stringBytes = s.getBytes(this.getCharacterSetString(this.characterSet));
                    this.writeStream.write(stringBytes, 0, stringBytes.length);
                    break;
                }
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.writeStream, this.getCharacterSetString(this.characterSet));
                osw.write(s, 0, s.length());
                osw.flush();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "writeString(String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQMessage.java, jmscc.wmq.v6, k701, k701-112-140304  1.29.1.1 09/08/17 08:02:40");
        }
    }
}

