/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Phobj;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;

public class MQManagedObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static JmqiEnvironment jmqiEnv;
    protected static final int MQ_DESC_LENGTH = 64;
    protected static final int MQCA_PROCESS_DESC = 2011;
    protected static final int MQCA_Q_DESC = 2013;
    protected static final int MQCA_Q_MGR_DESC = 2014;
    private static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQManagedObject.java, jmscc.wmq.v6, k701, k701-112-140304 1.26.1.2 10/12/01 15:37:12";
    public String alternateUserId = "";
    public int closeOptions = 0;
    protected Pint completionCode = jmqiEnv.newPint();
    protected boolean connected;
    public MQQueueManager connectionReference = null;
    protected Hconn hconn;
    public boolean isOpen = false;
    protected int mqca_description = 2014;
    public String name = "";
    public int openOptions = 32;
    protected boolean openStatus = false;
    protected MQSESSION osession = null;
    MQQueueManager parentQmgr = null;
    protected Phobj phobj;
    protected String pszName;
    protected Pint reason = jmqiEnv.newPint();
    protected boolean resourceOpen;

    protected MQManagedObject() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "<init>()");
        }
        this.resourceOpen = false;
        this.connected = false;
        this.hconn = null;
        this.phobj = jmqiEnv.newPhobj();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "<init>()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "close()");
        }
        MQException mqe = null;
        MQManagedObject mQManagedObject = this;
        synchronized (mQManagedObject) {
            if (this.osession == null && this.connectionReference != null) {
                this.osession = this.connectionReference.getSession();
            }
            if (!this.connected || this.osession == null) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "close()", 1);
                }
                return;
            }
            if (this.resourceOpen) {
                this.osession.MQCLOSE(this.hconn, this.phobj, this.closeOptions, this.completionCode, this.reason);
                if (this.completionCode.x != 0 || this.reason.x != 0) {
                    mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                }
            }
            if (mqe == null) {
                this.resourceOpen = false;
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "close()", mqe);
            }
            throw mqe;
        }
        this.isOpen = false;
        this.openStatus = false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "close()", 2);
        }
    }

    public final String getAttributeString(int aSelector, int length) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getAttributeString(int,int)", new Object[]{new Integer(aSelector), new Integer(length)});
        }
        String result = this.getString(aSelector, length);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getAttributeString(int,int)", result);
        }
        return result;
    }

    public String getDescription() throws MQException {
        String traceRet1 = this.getString(this.mqca_description, 64);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getDescription()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Hconn getHconn() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getHconn()", "getter", this.hconn);
        }
        return this.hconn;
    }

    protected final int getInt(int aSelector) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getInt(int)", new Object[]{new Integer(aSelector)});
        }
        int[] selectors = new int[]{aSelector};
        int[] intAttrs = new int[1];
        this.inquire(selectors, intAttrs, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getInt(int)", new Integer(intAttrs[0]));
        }
        return intAttrs[0];
    }

    protected final String getString(int aSelector, int length) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getString(int,int)", new Object[]{new Integer(aSelector), new Integer(length)});
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getString(int,int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        String result = this.osession.MQINQ(this.hconn, this.phobj.getHobj(), aSelector, length, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getString(int,int)", mqe, 2);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "getString(int,int)", result);
        }
        return result;
    }

    public void inquire(int[] selectors, int[] intAttrs, byte[] charAttrs) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "inquire(int [ ],int [ ],byte [ ])", new Object[]{selectors, intAttrs, charAttrs});
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "inquire(int [ ],int [ ],byte [ ])", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!this.resourceOpen) {
            MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "inquire(int [ ],int [ ],byte [ ])", traceRet2, 2);
            }
            throw traceRet2;
        }
        if (selectors == null || selectors.length == 0) {
            MQException traceRet3 = new MQException(2, 2067, (Object)this, "MQJI017");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "inquire(int [ ],int [ ],byte [ ])", traceRet3, 3);
            }
            throw traceRet3;
        }
        int numInts = 0;
        if (intAttrs != null) {
            numInts = intAttrs.length;
        }
        int numChars = 0;
        if (charAttrs != null) {
            numChars = charAttrs.length;
        }
        this.osession.MQINQ(this.hconn, this.phobj.getHobj(), selectors.length, selectors, numInts, intAttrs, numChars, charAttrs, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "inquire(int [ ],int [ ],byte [ ])", mqe, 4);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "inquire(int [ ],int [ ],byte [ ])");
        }
    }

    public boolean isOpen() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "isOpen()", "getter", this.openStatus);
        }
        return this.openStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int[] selectors, int[] intAttrs, byte[] charAttrs) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "set(int [ ],int [ ],byte [ ])", new Object[]{selectors, intAttrs, charAttrs});
        }
        MQException mqe = null;
        MQManagedObject mQManagedObject = this;
        synchronized (mQManagedObject) {
            if (this.osession == null && this.connectionReference != null) {
                this.osession = this.connectionReference.getSession();
            }
            if (!this.connected || this.osession == null) {
                MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "set(int [ ],int [ ],byte [ ])", traceRet1, 1);
                }
                throw traceRet1;
            }
            if (!this.resourceOpen) {
                MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "set(int [ ],int [ ],byte [ ])", traceRet2, 2);
                }
                throw traceRet2;
            }
            if (selectors == null || selectors.length == 0) {
                MQException traceRet3 = new MQException(2, 2067, (Object)this, "MQJI017");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "set(int [ ],int [ ],byte [ ])", traceRet3, 3);
                }
                throw traceRet3;
            }
            int numInts = 0;
            if (intAttrs != null) {
                numInts = intAttrs.length;
            }
            int numChars = 0;
            if (charAttrs != null) {
                numChars = charAttrs.length;
            }
            this.osession.MQSET(this.hconn, this.phobj.getHobj(), selectors.length, selectors, numInts, intAttrs, numChars, charAttrs, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            }
        }
        if (mqe != null) {
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "set(int [ ],int [ ],byte [ ])", mqe, 4);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "set(int [ ],int [ ],byte [ ])");
        }
    }

    public final void setAttributeString(int aSelector, String aValue, int length) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setAttributeString(int,String,int)", new Object[]{new Integer(aSelector), aValue, new Integer(length)});
        }
        this.setString(aSelector, aValue, length);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setAttributeString(int,String,int)");
        }
    }

    protected final void setInt(int aSelector, int aValue) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setInt(int,int)", new Object[]{new Integer(aSelector), new Integer(aValue)});
        }
        int[] selectors = new int[]{aSelector};
        int[] intAttrs = new int[]{aValue};
        this.set(selectors, intAttrs, null);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setInt(int,int)");
        }
    }

    protected final void setString(int aSelector, String aValue, int length) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setString(int,String,int)", new Object[]{new Integer(aSelector), aValue, new Integer(length)});
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setString(int,String,int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!this.resourceOpen) {
            MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setString(int,String,int)", traceRet2, 2);
            }
            throw traceRet2;
        }
        this.osession.MQSET(this.hconn, this.phobj.getHobj(), aSelector, aValue, length, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.parentQmgr.errorOccurred(mqe);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setString(int,String,int)", mqe, 3);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "setString(int,String,int)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQManagedObject.java, jmscc.wmq.v6, k701, k701-112-140304  1.26.1.2 10/12/01 15:37:12");
        }
        jmqiEnv = MQSESSION.getJmqiEnv();
    }
}

