/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiUtils;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.mq.jmqi.handles.Phconn;
import com.ibm.mq.jmqi.handles.Pint;
import com.ibm.mq.jmqi.system.JmqiConnectOptions;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition;
import com.ibm.msg.client.wmq.v6.base.internal.MQConnectionOptions;
import com.ibm.msg.client.wmq.v6.base.internal.MQConnectionRequestInfo;
import com.ibm.msg.client.wmq.v6.base.internal.MQConnectionSecurityParameters;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionFactory;
import com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager;
import com.ibm.msg.client.wmq.v6.base.internal.MQResourceException;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import com.ibm.msg.client.wmq.v6.base.internal.MQSSLConfigurationOptions;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;

public class MQManagedConnectionJ11 {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQManagedConnectionJ11.java, jmscc.wmq.v6, k701, k701-112-140304 1.47.1.1 09/08/17 08:02:16";
    MQConnectionOptions cno;
    private boolean connected = false;
    MQConnectionRequestInfo initialCxReqInf;
    MQManagedConnectionFactory initialMCF;
    JmqiConnectOptions jmqiCno;
    private JmqiEnvironment jmqiEnv = MQSESSION.getJmqiEnv();
    private Phconn phconn;
    private Hashtable properties = new Hashtable();
    private String qmgrName;
    Vector qmgrs = new Vector();
    private MQSESSION session;

    MQManagedConnectionJ11(String qmgrName, Hashtable properties, MQConnectionRequestInfo cxRequestInfo, MQManagedConnectionFactory mcf) throws MQException {
        Object ccdtUrlObject;
        if (Trace.isOn) {
            if (properties.containsKey("password")) {
                Hashtable<String, String> propsNotPasswd = new Hashtable<String, String>(properties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "<init>(String,Hashtable,MQConnectionRequestInfo,MQManagedConnectionFactory)", new Object[]{qmgrName, propsNotPasswd, cxRequestInfo, mcf});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "<init>(String,Hashtable,MQConnectionRequestInfo,MQManagedConnectionFactory)", new Object[]{qmgrName, properties, cxRequestInfo, mcf});
            }
        }
        this.phconn = this.jmqiEnv.newPhconn();
        Pint pCompCode = this.jmqiEnv.newPint();
        Pint pReason = this.jmqiEnv.newPint();
        if (qmgrName == null) {
            qmgrName = "";
        }
        this.qmgrName = qmgrName;
        if (properties == null || cxRequestInfo == null || mcf == null) {
            HashMap<String, Cloneable> data = new HashMap<String, Cloneable>();
            if (properties != null && properties.containsKey("password")) {
                Hashtable<String, String> propsNotPasswd = new Hashtable<String, String>(properties);
                propsNotPasswd.put("password", "********");
                data.put("properties", propsNotPasswd);
            } else {
                data.put("properties", properties);
            }
            data.put("cxRequestInfo", cxRequestInfo);
            data.put("mcf", mcf);
            Trace.ffst(this, "MQManagedConnectionJ11", "XO00E001", data, NullPointerException.class);
        }
        this.initialCxReqInf = cxRequestInfo;
        this.initialMCF = (MQManagedConnectionFactory)mcf.clone();
        this.properties = properties;
        this.connected = false;
        this.session = MQSESSION.getSession(this);
        String transport = this.getStringProperty("transport");
        URL ccdtUrl = null;
        if (transport.equals("MQSeries Client") && (ccdtUrlObject = this.getProperty("CCDT URL")) != null && ccdtUrlObject instanceof URL) {
            ccdtUrl = (URL)ccdtUrlObject;
        }
        this.cno = this.constructCNO(qmgrName, properties);
        this.jmqiCno = this.constructJmqiCNO(transport, ccdtUrl);
        this.session.MQCONNX_j(qmgrName, this.jmqiCno, this.cno, this.phconn, pCompCode, pReason);
        if (pCompCode.x != 0 || pReason.x != 0) {
            this.session = null;
            MQException me = new MQException(pCompCode.x, pReason.x, (Object)this);
            me.initCause((Throwable)this.jmqiEnv.getLastException());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "<init>(String,Hashtable,MQConnectionRequestInfo,MQManagedConnectionFactory)", me, 2);
            }
            throw me;
        }
        this.connected = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "<init>(String,Hashtable,MQConnectionRequestInfo,MQManagedConnectionFactory)");
        }
    }

    protected boolean authenticate(Pint pCompCode, Pint pReason) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", new Object[]{pCompCode, pReason});
        }
        try {
            MQSESSION session = MQSESSION.getSession(this);
            if (Trace.isOn) {
                Trace.traceData(this, "Session associated with this managed connection is " + session, null);
            }
            String userId = this.getStringProperty("userID", "");
            String password = this.getStringProperty("password", "");
            pCompCode.x = 0;
            if (null != userId && !userId.trim().equals("")) {
                session.authenticate(this.phconn.getHconn(), userId, password, pCompCode, pReason);
            }
            if (pCompCode.x == 2) {
                if (Trace.isOn) {
                    Trace.traceData(this, "Failed to authenticate userId and Password: rc=" + pReason.x, null);
                }
                MQException me = new MQException(pCompCode.x, pReason.x, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", me, 1);
                }
                throw me;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", true);
            }
            return true;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", e);
            }
            if (e instanceof MQException) {
                MQException traceRet1 = (MQException)((Object)e);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", traceRet1, 2);
                }
                throw traceRet1;
            }
            if (e instanceof MQResourceException && ((MQResourceException)e).getLinkedException() != null && ((MQResourceException)e).getLinkedException() instanceof MQException) {
                MQException traceRet2 = (MQException)((Object)((MQResourceException)e).getLinkedException());
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", traceRet2, 3);
                }
                throw traceRet2;
            }
            MQException mqe = new MQException(2, 2102, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "authenticate(Pint,Pint)", mqe, 4);
            }
            throw mqe;
        }
    }

    private MQConnectionOptions constructCNO(String queueManagerName, Hashtable properties) throws MQException {
        int options;
        if (Trace.isOn) {
            if (properties.containsKey("password")) {
                Hashtable<String, String> propsNotPasswd = new Hashtable<String, String>(properties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructCNO(String,Hashtable)", new Object[]{queueManagerName, propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructCNO(String,Hashtable)", new Object[]{queueManagerName, properties});
            }
        }
        MQConnectionOptions mqcno = new MQConnectionOptions();
        int check = options = this.getIntegerProperty("connectOptions");
        String transport = this.getStringProperty("transport");
        if ((check &= 0xFFFFFC60) != 0) {
            MQException traceRet1 = new MQException(2, 2046, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructCNO(String,Hashtable)", traceRet1, 1);
            }
            throw traceRet1;
        }
        if (transport.equals("MQSeries Client")) {
            if (options != 0) {
                check = options;
                if ((check &= 0xFFFFFDFF) == 0 && options != 0) {
                    options -= 512;
                }
            }
            if (options != 0) {
                check = options;
                if ((check &= 0xFFFFFEFF) == 0 && options != 0) {
                    options -= 256;
                }
            }
            if ((options & 8) != 0 || (options & 0x10) != 0) {
                MQException mqe = new MQException(2, 2046, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructCNO(String,Hashtable)", mqe, 2);
                }
                throw mqe;
            }
        }
        boolean sslFipsRequired = false;
        if (transport.equals("MQSeries Client")) {
            mqcno.setVersion(4);
            MQSSLConfigurationOptions sco = new MQSSLConfigurationOptions();
            sco.setVersion(2);
            mqcno.setMQSCO(sco);
            sslFipsRequired = (Boolean)properties.get("SSL Fips Required");
            sco.setFipsRequired(sslFipsRequired);
            int i = this.getIntegerProperty("KeyResetCount", 0);
            if (i < 0 || i > 999999999) {
                MQException traceRet2 = new MQException(2, 2409, (Object)this);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructCNO(String,Hashtable)", traceRet2, 3);
                }
                throw traceRet2;
            }
            if (i > 0) {
                sco.setKeyResetCount(i);
            }
        }
        MQChannelDefinition clientConn = null;
        if (!properties.containsKey("CCDT URL")) {
            String sslCipherSuite;
            clientConn = new MQChannelDefinition();
            clientConn.channelName = (String)properties.get("channel");
            clientConn.queueManagerName = queueManagerName;
            clientConn.maxMessageLength = 0x6400000;
            StringBuffer connectionName = new StringBuffer();
            connectionName.append((String)properties.get("hostname"));
            Integer port = (Integer)properties.get("port");
            if (port != null) {
                connectionName.append("(");
                connectionName.append(port.toString());
                connectionName.append(")");
            }
            clientConn.connectionName = connectionName.toString();
            clientConn.port = port == null ? 0 : port;
            clientConn.remoteUserId = (String)properties.get("userID");
            clientConn.remotePassword = (String)properties.get("password");
            clientConn.sslPeerName = (String)properties.get("SSL Peer Name");
            StringBuffer localAddress = new StringBuffer();
            Object object = properties.get("FIREWALL_SETTINGS");
            if (object != null) {
                if (object instanceof Hashtable) {
                    Hashtable hashtable = (Hashtable)object;
                    String address = (String)hashtable.get("HOST");
                    String startPort = (String)hashtable.get("START_PORT");
                    String endPort = (String)hashtable.get("END_PORT");
                    if (address != null) {
                        localAddress.append(address);
                    }
                    if (startPort != null || endPort != null) {
                        localAddress.append("(");
                        if (startPort != null) {
                            localAddress.append(startPort);
                        }
                        if (endPort != null) {
                            localAddress.append(",");
                            localAddress.append(endPort);
                        }
                        localAddress.append(")");
                    }
                } else {
                    localAddress.append(object.toString());
                }
                clientConn.localAddress = localAddress.toString();
            }
            if ((sslCipherSuite = this.getStringProperty("SSL Cipher Suite")) != null) {
                String sslCipherSpec = JmqiUtils.toCipherSpec((String)sslCipherSuite, (boolean)sslFipsRequired);
                if (sslCipherSpec != null) {
                    clientConn.sslCipherSpec = sslCipherSpec;
                } else {
                    throw new MQException(2, 2400, (Object)this);
                }
            }
            clientConn.securityUserData = "";
            clientConn.sendUserData = "";
            clientConn.receiveUserData = "";
            clientConn.hdrCompList = (Collection)properties.get("Header Compression Property");
            clientConn.msgCompList = (Collection)properties.get("ProviderMessage Compression Property");
            clientConn.sharingConversations = 0;
        }
        mqcno.setMQCD(clientConn);
        Object obj = this.getProperty("ConnTag Property");
        boolean set = false;
        if (obj != null && obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == 0) continue;
                set = true;
            }
            if (set) {
                mqcno.setVersion(3);
                mqcno.setConnTag(b);
            }
        }
        if (transport.equals("MQSeries Bindings")) {
            String username = this.getStringProperty("userID", null);
            String password = this.getStringProperty("password", null);
            if (Trace.isOn) {
                Trace.traceData(this, "MQCSP UserName = " + username, null);
            }
            if (password != null && Trace.isOn) {
                Trace.traceData(this, "MQCSP password length = " + password.length(), null);
            }
            if (username != null && password != null && username.trim().length() > 0) {
                mqcno.setVersion(5);
                MQConnectionSecurityParameters csp = new MQConnectionSecurityParameters();
                csp.setCSPUserId(username);
                csp.setCSPPassword(password);
                csp.setAuthenticationType(1);
                mqcno.setMQCSP(csp);
                if (Trace.isOn) {
                    Trace.traceData(this, " Constructed CSP AuthType " + csp.getAuthenticationType(), null);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructCNO(String,Hashtable)", (Object)mqcno);
        }
        return mqcno;
    }

    private JmqiConnectOptions constructJmqiCNO(String transport, URL ccdtUrl) throws MQException {
        String password;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructJmqiCNO(String,URL)", new Object[]{transport, ccdtUrl});
        }
        JmqiSystemEnvironment jmqiSystemEnv = (JmqiSystemEnvironment)MQSESSION.getJmqiEnv();
        JmqiConnectOptions jmqiCNO = jmqiSystemEnv.newJmqiConnectOptions();
        String userId = this.getStringProperty("userID");
        if (userId != null && userId.length() > 0) {
            jmqiCNO.setUserIdentifier(userId);
        }
        if ((password = this.getStringProperty("password")) != null && password.length() > 0) {
            jmqiCNO.setPassword(password);
        }
        jmqiCNO.setCcdtUrl(ccdtUrl);
        if (ccdtUrl != null) {
            jmqiCNO.setFlags(64);
            jmqiCNO.setSharingConversations(0);
        }
        jmqiCNO.setSecurityExit(this.getProperty("securityExit"));
        jmqiCNO.setReceiveExits(this.getProperty("receiveExit"));
        jmqiCNO.setSendExits(this.getProperty("sendExit"));
        jmqiCNO.setSecurityExitUserData((String)this.getProperty("securitydExitData"));
        jmqiCNO.setReceiveExitsUserData((String)this.getProperty("receiveExitData"));
        jmqiCNO.setSendExitsUserData((String)this.getProperty("sendExitData"));
        jmqiCNO.setCrlCertStores((Collection)this.getProperty("SSL CertStores"));
        jmqiCNO.setSslSocketFactory((SSLSocketFactory)this.getProperty("SSL Socket Factory"));
        int ccsid = this.getIntegerProperty("CCSID");
        if (ccsid > 0) {
            jmqiCNO.setQueueManagerCCSID(ccsid);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "constructJmqiCNO(String,URL)", jmqiCNO);
        }
        return jmqiCNO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws MQResourceException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "destroy()");
        }
        Pint pCompCode = this.jmqiEnv.newPint();
        Pint pReason = this.jmqiEnv.newPint();
        Enumeration e = this.qmgrs.elements();
        while (e.hasMoreElements()) {
            MQQueueManager qm;
            MQQueueManager mQQueueManager = qm = (MQQueueManager)e.nextElement();
            synchronized (mQQueueManager) {
                if (qm.isConnected()) {
                    qm.cleanup();
                }
            }
        }
        this.qmgrs.removeAllElements();
        if (!this.connected) {
            String msg = MQException.getNLSMsg((String)"MQJI040");
            MQResourceException traceRet1 = new MQResourceException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "destroy()", traceRet1, 1);
            }
            throw traceRet1;
        }
        this.session.MQDISC(this.phconn, pCompCode, pReason);
        this.connected = false;
        this.session = null;
        if (pCompCode.x != 0 || pReason.x != 0) {
            MQException mqe = new MQException(pCompCode.x, pReason.x, (Object)this);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "destroy()", mqe, 2);
            }
            throw mqe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "destroy()");
        }
    }

    void fireConnectionClosedEvent(MQQueueManager qmgr) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "fireConnectionClosedEvent(MQQueueManager)", new Object[]{qmgr});
        }
        this.qmgrs.removeElement(qmgr);
        try {
            this.destroy();
        }
        catch (MQResourceException mqre) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "fireConnectionClosedEvent(MQQueueManager)", mqre);
            }
            HashMap<String, MQResourceException> data = new HashMap<String, MQResourceException>();
            data.put("exception:", mqre);
            Trace.ffst(this, "fireConnectionClosedEvent", "XO00E002", data, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "fireConnectionClosedEvent(MQQueueManager)");
        }
    }

    public synchronized Object getConnection(MQConnectionRequestInfo cxRequestInfo) throws MQResourceException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getConnection(MQConnectionRequestInfo)", new Object[]{cxRequestInfo});
        }
        if (!this.connected) {
            String msg = MQException.getNLSMsg((String)"MQJI040");
            MQResourceException re = new MQResourceException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getConnection(MQConnectionRequestInfo)", re, 1);
            }
            throw re;
        }
        MQQueueManager qm = new MQQueueManager(this);
        this.qmgrs.addElement(qm);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getConnection(MQConnectionRequestInfo)", qm);
        }
        return qm;
    }

    Hconn getHconn() {
        Hconn traceRet1 = this.phconn.getHconn();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getHconn()", "getter", traceRet1);
        }
        return traceRet1;
    }

    int getIntegerProperty(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getIntegerProperty(Object)", new Object[]{key});
        }
        int traceRet1 = this.getIntegerProperty(key, 0);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getIntegerProperty(Object)", new Integer(traceRet1));
        }
        return traceRet1;
    }

    int getIntegerProperty(Object key, int defaultValue) {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getIntegerProperty(Object,int)", new Object[]{key, new Integer(defaultValue)});
        }
        int value = (object = this.getProperty(key)) != null && object instanceof Integer ? (Integer)object : defaultValue;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getIntegerProperty(Object,int)", new Integer(value));
        }
        return value;
    }

    public MQSESSION getMQSESSION() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getMQSESSION()", "getter", this.session);
        }
        return this.session;
    }

    Object getProperty(Object key) {
        return this.properties.get(key);
    }

    String getQmgrName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getQmgrName()", "getter", this.qmgrName);
        }
        return this.qmgrName;
    }

    public String getStringProperty(Object key) {
        return this.getStringProperty(key, null);
    }

    String getStringProperty(Object key, String defaultValue) {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getStringProperty(Object,String)", new Object[]{key, defaultValue});
        }
        String value = (object = this.getProperty(key)) != null && object instanceof String ? (String)object : defaultValue;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "getStringProperty(Object,String)", key == "password" ? "********" : value);
        }
        return value;
    }

    boolean isConnected() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "isConnected()", "getter", this.connected);
        }
        return this.connected;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQManagedConnectionJ11.java, jmscc.wmq.v6, k701, k701-112-140304  1.47.1.1 09/08/17 08:02:16");
        }
    }
}

