/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQEnvironment;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MQMD
extends JmqiObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final TimeZone GMT;
    private static final GregorianCalendar gmtConverter;
    private GregorianCalendar putCalendar = null;
    public static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQMD.java, jmscc.wmq.v6, k701, k701-112-140304 1.32.1.1 09/08/17 08:01:48";
    protected static final int sizeofMQMDv1 = 324;
    protected static final int sizeofMQMDv2 = 364;
    public byte[] accountingToken = new byte[32];
    public String applicationIdData = "";
    public String applicationOriginData = "";
    public int backoutCount = 0;
    private int cachedCcsid;
    private String cachedCcsidStr = null;
    public int characterSet = 0;
    public byte[] correlationId = new byte[24];
    public int encoding = 273;
    public int expiry = -1;
    public int feedback = 0;
    public String format = "        ";
    public byte[] groupId = new byte[24];
    private com.ibm.mq.jmqi.MQMD jmqiStructure = MQSESSION.getJmqiEnv().newMQMD();
    public int messageFlags = 0;
    public byte[] messageId = new byte[24];
    public int messageSequenceNumber = 1;
    public int messageType = 8;
    public int offset = 0;
    public int originalLength = -1;
    public int persistence = 2;
    public int priority = -1;
    public String putApplicationName = "";
    public int putApplicationType = 0;
    String putDate = "";
    public GregorianCalendar putDateTime = null;
    String putTime = "";
    public String replyToQueueManagerName = "";
    public String replyToQueueName = "";
    public int report = 0;
    public String userId = "";
    private int version = 2;

    static final String getDate(GregorianCalendar dateTime) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getDate(GregorianCalendar)", new Object[]{dateTime});
        }
        String strDate = dateTime != null ? MQMD.setNumberToLength(new Integer(dateTime.get(1)).toString(), 4) + MQMD.setNumberToLength(new Integer(dateTime.get(2) + 1).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(5)).toString(), 2) : "        ";
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getDate(GregorianCalendar)", (Object)strDate);
        }
        return strDate;
    }

    static final String getTime(GregorianCalendar dateTime) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getTime(GregorianCalendar)", new Object[]{dateTime});
        }
        String strTime = dateTime != null ? MQMD.setNumberToLength(new Integer(dateTime.get(11)).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(12)).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(13)).toString(), 2) + MQMD.setNumberToLength(new Integer(dateTime.get(14) / 10).toString(), 2) : "        ";
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getTime(GregorianCalendar)", (Object)strTime);
        }
        return strTime;
    }

    private static final String setNumberToLength(String strNumber, int iNewLength) {
        String strPadded;
        int iOldLength;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setNumberToLength(String,int)", new Object[]{strNumber, new Integer(iNewLength)});
        }
        if ((iOldLength = strNumber.length()) > iNewLength) {
            strPadded = strNumber.substring(0, iNewLength);
        } else {
            strPadded = new String(strNumber);
            for (int i = iOldLength; i < iNewLength; ++i) {
                strPadded = "0" + strPadded;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setNumberToLength(String,int)", (Object)strPadded);
        }
        return strPadded;
    }

    public MQMD() {
        super(MQSESSION.getJmqiEnv());
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "<init>()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] convertCalendarToStrings(GregorianCalendar calendar) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "convertCalendarToStrings(GregorianCalendar)", new Object[]{calendar});
        }
        String[] jmqiPutDateTime = new String[2];
        char[] rawPutDate = new char[8];
        char[] rawPutTime = new char[8];
        if (calendar == null) {
            Arrays.fill(rawPutDate, ' ');
            Arrays.fill(rawPutTime, ' ');
        } else {
            int hundredth;
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            GregorianCalendar gregorianCalendar = gmtConverter;
            synchronized (gregorianCalendar) {
                gmtConverter.setTime(calendar.getTime());
                year = gmtConverter.get(1);
                month = gmtConverter.get(2) + 1;
                day = gmtConverter.get(5);
                hour = gmtConverter.get(11);
                minute = gmtConverter.get(12);
                second = gmtConverter.get(13);
                hundredth = gmtConverter.get(14) / 10;
            }
            int contrib = year / 1000;
            rawPutDate[0] = (char)(48 + contrib);
            year -= contrib * 1000;
            contrib = year / 100;
            rawPutDate[1] = (char)(48 + contrib);
            year -= contrib * 100;
            contrib = year / 10;
            rawPutDate[2] = (char)(48 + contrib);
            year -= contrib * 10;
            contrib = year;
            rawPutDate[3] = (char)(48 + contrib);
            contrib = month / 10;
            rawPutDate[4] = (char)(48 + contrib);
            month -= contrib * 10;
            contrib = month;
            rawPutDate[5] = (char)(48 + contrib);
            contrib = day / 10;
            rawPutDate[6] = (char)(48 + contrib);
            day -= contrib * 10;
            contrib = day;
            rawPutDate[7] = (char)(48 + contrib);
            contrib = hour / 10;
            rawPutTime[0] = (char)(48 + contrib);
            hour -= contrib * 10;
            contrib = hour;
            rawPutTime[1] = (char)(48 + contrib);
            contrib = minute / 10;
            rawPutTime[2] = (char)(48 + contrib);
            minute -= contrib * 10;
            contrib = minute;
            rawPutTime[3] = (char)(48 + contrib);
            contrib = second / 10;
            rawPutTime[4] = (char)(48 + contrib);
            second -= contrib * 10;
            contrib = second;
            rawPutTime[5] = (char)(48 + contrib);
            contrib = hundredth / 10;
            rawPutTime[6] = (char)(48 + contrib);
            hundredth -= contrib * 10;
            contrib = hundredth;
            rawPutTime[7] = (char)(48 + contrib);
        }
        jmqiPutDateTime[0] = new String(rawPutDate);
        jmqiPutDateTime[1] = new String(rawPutTime);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "convertCalendarToStrings(GregorianCalendar)", jmqiPutDateTime);
        }
        return jmqiPutDateTime;
    }

    protected final GregorianCalendar getDateAndTime(String date, String time) {
        GregorianCalendar retVal;
        char[] rawPutTime;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getDateAndTime(String,String)", new Object[]{date, time});
        }
        char[] rawPutDate = date != null ? date.toCharArray() : null;
        char[] cArray = rawPutTime = time != null ? time.toCharArray() : null;
        if (rawPutDate != null && rawPutDate.length == 8 && rawPutTime != null && rawPutTime.length == 8) {
            int year = (rawPutDate[0] - 48) * 1000;
            year += (rawPutDate[1] - 48) * 100;
            year += (rawPutDate[2] - 48) * 10;
            year += rawPutDate[3] - 48;
            int month = (rawPutDate[4] - 48) * 10;
            month += rawPutDate[5] - 48;
            --month;
            int day = (rawPutDate[6] - 48) * 10;
            day += rawPutDate[7] - 48;
            int hour = (rawPutTime[0] - 48) * 10;
            int minute = (rawPutTime[2] - 48) * 10;
            int second = (rawPutTime[4] - 48) * 10;
            int millisecond = (rawPutTime[6] - 48) * 10;
            millisecond += rawPutTime[7] - 48;
            retVal = new GregorianCalendar(year, month, day, hour += rawPutTime[1] - 48, minute += rawPutTime[3] - 48, second += rawPutTime[5] - 48);
            retVal.setTimeZone(GMT);
            retVal.set(14, millisecond *= 10);
        } else {
            retVal = new GregorianCalendar();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getDateAndTime(String,String)", retVal);
        }
        return retVal;
    }

    protected com.ibm.mq.jmqi.MQMD getJMQIStructure(int pmoFlags) {
        boolean setIdCts;
        this.jmqiStructure.setVersion(this.version);
        this.jmqiStructure.setReport(this.report);
        this.jmqiStructure.setMsgType(this.messageType);
        this.jmqiStructure.setExpiry(this.expiry);
        this.jmqiStructure.setFeedback(this.feedback);
        this.jmqiStructure.setEncoding(this.encoding);
        this.jmqiStructure.setCodedCharSetId(this.characterSet);
        this.jmqiStructure.setFormat(this.format);
        this.jmqiStructure.setPriority(this.priority);
        this.jmqiStructure.setPersistence(this.persistence);
        this.jmqiStructure.setMsgId(this.messageId);
        this.jmqiStructure.setCorrelId(this.correlationId);
        this.jmqiStructure.setBackoutCount(this.backoutCount);
        this.jmqiStructure.setReplyToQ(this.replyToQueueName);
        this.jmqiStructure.setReplyToQMgr(this.replyToQueueManagerName);
        boolean setAllCtx = (pmoFlags & 0x800) != 0;
        boolean bl = setIdCts = setAllCtx || (pmoFlags & 0x400) != 0;
        if (setIdCts) {
            this.jmqiStructure.setUserIdentifier(this.userId);
            this.jmqiStructure.setAccountingToken(this.accountingToken);
            this.jmqiStructure.setApplIdentityData(this.applicationIdData);
        }
        if (setAllCtx) {
            this.jmqiStructure.setPutApplType(this.putApplicationType);
            this.jmqiStructure.setPutApplName(this.putApplicationName);
            this.jmqiStructure.setApplOriginData(this.applicationOriginData);
            String[] jmqiPutDateTime = this.convertCalendarToStrings(this.putDateTime);
            this.jmqiStructure.setPutDate(jmqiPutDateTime[0]);
            this.jmqiStructure.setPutTime(jmqiPutDateTime[1]);
        }
        if (this.version >= 2) {
            this.jmqiStructure.setGroupId(this.groupId);
            this.jmqiStructure.setMsgSeqNumber(this.messageSequenceNumber);
            this.jmqiStructure.setOffset(this.offset);
            this.jmqiStructure.setMsgFlags(this.messageFlags);
            this.jmqiStructure.setOriginalLength(this.originalLength);
        }
        return this.jmqiStructure;
    }

    public int getVersion() {
        if (Trace.isOn) {
            Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "getVersion()", "getter", new Integer(this.version));
        }
        return this.version;
    }

    private byte[] makeBytesFromString(String strToUse, int ccsid, boolean codepageIsAscii, boolean isInvariant) throws MQException {
        int i;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeBytesFromString(String,int,boolean,boolean)", new Object[]{strToUse, new Integer(ccsid), codepageIsAscii, isInvariant});
        }
        byte[] retBytes = null;
        boolean onlyInvariantChars = false;
        if (isInvariant) {
            onlyInvariantChars = true;
        } else if (codepageIsAscii) {
            onlyInvariantChars = true;
            for (i = 0; i < strToUse.length() && onlyInvariantChars; ++i) {
                onlyInvariantChars = strToUse.charAt(i) < '\u0080';
            }
        }
        if (codepageIsAscii && onlyInvariantChars) {
            retBytes = new byte[strToUse.length()];
            for (i = 0; i < retBytes.length; ++i) {
                retBytes[i] = (byte)strToUse.charAt(i);
            }
        } else {
            if (this.cachedCcsidStr == null || this.cachedCcsid != ccsid) {
                this.cachedCcsidStr = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (int)ccsid).charsetId;
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = String.valueOf(ccsid);
                }
                this.cachedCcsid = ccsid;
            }
            try {
                byte[] convertedBytes = strToUse.getBytes(this.cachedCcsidStr);
                if (convertedBytes.length != strToUse.length()) {
                    retBytes = new byte[strToUse.length()];
                    System.arraycopy(convertedBytes, 0, retBytes, 0, retBytes.length);
                }
                retBytes = convertedBytes;
            }
            catch (UnsupportedEncodingException e) {
                if (Trace.isOn) {
                    Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeBytesFromString(String,int,boolean,boolean)", e);
                }
                this.cachedCcsidStr = null;
                MQException traceRet1 = new MQException(2, 2195, (Object)"MQJE046", this.cachedCcsidStr);
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeBytesFromString(String,int,boolean,boolean)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeBytesFromString(String,int,boolean,boolean)", retBytes);
        }
        return retBytes;
    }

    private String makeStringFromBytes(byte[] bytesToUse, int ccsid, boolean codepageIsAscii, boolean isInvariant) throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeStringFromBytes(byte [ ],int,boolean,boolean)", new Object[]{bytesToUse, new Integer(ccsid), codepageIsAscii, isInvariant});
        }
        String retStr = null;
        boolean onlyInvariantChars = false;
        if (isInvariant) {
            onlyInvariantChars = true;
        } else if (codepageIsAscii) {
            onlyInvariantChars = true;
            for (int i = 0; i < bytesToUse.length && onlyInvariantChars; ++i) {
                onlyInvariantChars = bytesToUse[i] >= 0;
            }
        }
        if (onlyInvariantChars && codepageIsAscii) {
            char[] chars = new char[bytesToUse.length];
            for (int i = 0; i < bytesToUse.length; ++i) {
                chars[i] = (char)bytesToUse[i];
            }
            retStr = new String(chars);
        } else {
            if (this.cachedCcsid != ccsid || this.cachedCcsidStr == null) {
                this.cachedCcsidStr = JmqiCodepage.getJmqiCodepage((JmqiEnvironment)MQSESSION.getJmqiEnv(), (int)ccsid).charsetId;
                if (this.cachedCcsidStr == null) {
                    this.cachedCcsidStr = String.valueOf(ccsid);
                }
                this.cachedCcsid = ccsid;
            }
            try {
                retStr = new String(bytesToUse, this.cachedCcsidStr);
            }
            catch (UnsupportedEncodingException e) {
                if (Trace.isOn) {
                    Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeStringFromBytes(byte [ ],int,boolean,boolean)", e);
                }
                this.cachedCcsidStr = null;
                MQException traceRet1 = new MQException(2, 2195, (Object)"MQJE046", this.cachedCcsidStr);
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeStringFromBytes(byte [ ],int,boolean,boolean)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "makeStringFromBytes(byte [ ],int,boolean,boolean)", retStr);
        }
        return retStr;
    }

    public final DataInputStream readFrom(DataInputStream dataBuffer, int ccsid, boolean ccsidIsAscii) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "readFrom(java.io.DataInputStream,int,boolean)", new Object[]{dataBuffer, new Integer(ccsid), ccsidIsAscii});
        }
        if (dataBuffer.available() < 324) {
            MQException traceRet1 = new MQException(2, 2195, (Object)"MQJE043");
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "readFrom(java.io.DataInputStream,int,boolean)", traceRet1, 1);
            }
            throw traceRet1;
        }
        byte[] eyecatcherBytes = new byte[4];
        dataBuffer.read(eyecatcherBytes, 0, 4);
        String eyecatcher = MQEnvironment.stringFromBytes(eyecatcherBytes);
        if (!eyecatcher.equals("MD  ")) {
            MQException traceRet2 = new MQException(2, 2195, (Object)"MQJE042", eyecatcher);
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "readFrom(java.io.DataInputStream,int,boolean)", traceRet2, 2);
            }
            throw traceRet2;
        }
        this.version = dataBuffer.readInt();
        this.report = dataBuffer.readInt();
        this.messageType = dataBuffer.readInt();
        this.expiry = dataBuffer.readInt();
        this.feedback = dataBuffer.readInt();
        this.encoding = dataBuffer.readInt();
        this.characterSet = dataBuffer.readInt();
        byte[] fmtBytes = new byte[8];
        dataBuffer.read(fmtBytes, 0, 8);
        this.format = this.makeStringFromBytes(fmtBytes, ccsid, ccsidIsAscii, false);
        this.priority = dataBuffer.readInt();
        this.persistence = dataBuffer.readInt();
        this.messageId = this.setArrayToLength(this.messageId, 24);
        dataBuffer.read(this.messageId, 0, 24);
        this.correlationId = this.setArrayToLength(this.correlationId, 24);
        dataBuffer.read(this.correlationId, 0, 24);
        this.backoutCount = dataBuffer.readInt();
        byte[] replyToQBytes = new byte[48];
        dataBuffer.read(replyToQBytes, 0, 48);
        this.replyToQueueName = this.makeStringFromBytes(replyToQBytes, ccsid, ccsidIsAscii, true);
        byte[] replyToQMgrBytes = new byte[48];
        dataBuffer.read(replyToQMgrBytes, 0, 48);
        this.replyToQueueManagerName = this.makeStringFromBytes(replyToQMgrBytes, ccsid, ccsidIsAscii, true);
        byte[] userIDBytes = new byte[12];
        dataBuffer.read(userIDBytes, 0, 12);
        this.userId = this.makeStringFromBytes(userIDBytes, ccsid, ccsidIsAscii, false);
        this.accountingToken = this.setArrayToLength(this.accountingToken, 32);
        dataBuffer.read(this.accountingToken, 0, 32);
        byte[] applIdBytes = new byte[32];
        dataBuffer.read(applIdBytes, 0, 32);
        this.applicationIdData = this.makeStringFromBytes(applIdBytes, ccsid, ccsidIsAscii, false);
        this.putApplicationType = dataBuffer.readInt();
        byte[] applBytes = new byte[28];
        dataBuffer.read(applBytes, 0, 28);
        this.putApplicationName = this.makeStringFromBytes(applBytes, ccsid, ccsidIsAscii, false);
        byte[] dateBytes = new byte[8];
        dataBuffer.read(dateBytes, 0, 8);
        this.putDate = this.makeStringFromBytes(dateBytes, ccsid, ccsidIsAscii, true);
        byte[] timeBytes = new byte[8];
        dataBuffer.read(timeBytes, 0, 8);
        this.putTime = this.makeStringFromBytes(timeBytes, ccsid, ccsidIsAscii, true);
        byte[] originBytes = new byte[4];
        dataBuffer.read(originBytes, 0, 4);
        this.applicationOriginData = this.makeStringFromBytes(originBytes, ccsid, ccsidIsAscii, false);
        this.putDateTime = this.getDateAndTime(this.putDate, this.putTime);
        if (this.version > 1) {
            this.groupId = this.setArrayToLength(this.groupId, 24);
            dataBuffer.read(this.groupId, 0, 24);
            this.messageSequenceNumber = dataBuffer.readInt();
            this.offset = dataBuffer.readInt();
            this.messageFlags = dataBuffer.readInt();
            this.originalLength = dataBuffer.readInt();
        } else {
            this.groupId = MQC.MQGI_NONE;
            this.messageSequenceNumber = 1;
            this.offset = 0;
            this.messageFlags = 0;
            this.originalLength = -1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "readFrom(java.io.DataInputStream,int,boolean)", dataBuffer);
        }
        return dataBuffer;
    }

    protected final byte[] setArrayToLength(byte[] array, int length) throws MQException {
        byte[] retVal;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setArrayToLength(byte [ ],int)", new Object[]{array, new Integer(length)});
        }
        try {
            retVal = new byte[length];
            if (array == null || array.length == 0) {
                for (int i = 0; i < length; ++i) {
                    retVal[i] = 0;
                }
            } else if (array.length < length) {
                System.arraycopy(array, 0, retVal, 0, array.length);
                for (int i = array.length; i < length; ++i) {
                    retVal[i] = 0;
                }
            } else {
                System.arraycopy(array, 0, retVal, 0, length);
            }
        }
        catch (Exception ex) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setArrayToLength(byte [ ],int)", ex);
            }
            MQException traceRet1 = new MQException(2, 2195, (Object)"MQJE044");
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setArrayToLength(byte [ ],int)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setArrayToLength(byte [ ],int)", retVal);
        }
        return retVal;
    }

    protected final void setDateAndTime(int year, int month, int day, int hour, int minute, int second, int millis) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setDateAndTime(int,int,int,int,int,int,int)", new Object[]{new Integer(year), new Integer(month), new Integer(day), new Integer(hour), new Integer(minute), new Integer(second), new Integer(millis)});
        }
        if (this.putDateTime == null) {
            this.putDateTime = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        } else {
            this.putDateTime.set(year, month - 1, day, hour, minute, second);
        }
        this.putDateTime.setTimeZone(GMT);
        this.putDateTime.set(14, millis);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setDateAndTime(int,int,int,int,int,int,int)");
        }
    }

    public void setVersion(int version) throws MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setVersion(int)", new Object[]{new Integer(version)});
        }
        if (version > 2 || version < 1) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI013", "" + version);
            if (Trace.isOn) {
                Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setVersion(int)", traceRet1, 1);
            }
            throw traceRet1;
        }
        this.version = version;
        if (version == 1) {
            boolean invalidGroupId = false;
            if (this.groupId != null) {
                for (int i = 0; i < this.groupId.length; ++i) {
                    if (this.groupId[i] == 0) continue;
                    invalidGroupId = true;
                    break;
                }
            }
            if (invalidGroupId || this.messageSequenceNumber != 1 || this.offset != 0 || this.messageFlags != 0 || this.originalLength != -1) {
                MQException traceRet2 = new MQException(2, 2026, (Object)this, "MQJE055");
                if (Trace.isOn) {
                    Trace.throwing((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setVersion(int)", traceRet2, 2);
                }
                throw traceRet2;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "setVersion(int)");
        }
    }

    protected final int sizeOfMQMD() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "sizeOfMQMD()");
        }
        if (this.version == 1) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "sizeOfMQMD()", new Integer(324), 1);
            }
            return 324;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "sizeOfMQMD()", new Integer(364), 2);
        }
        return 364;
    }

    protected void updateFromJMQIStructure(int pmoFlags) {
        boolean nSetIdCts;
        this.version = this.jmqiStructure.getVersion();
        this.report = this.jmqiStructure.getReport();
        this.messageType = this.jmqiStructure.getMsgType();
        this.expiry = this.jmqiStructure.getExpiry();
        this.feedback = this.jmqiStructure.getFeedback();
        this.encoding = this.jmqiStructure.getEncoding();
        this.characterSet = this.jmqiStructure.getCodedCharSetId();
        this.format = this.jmqiStructure.getFormat();
        this.priority = this.jmqiStructure.getPriority();
        this.persistence = this.jmqiStructure.getPersistence();
        this.messageId = new byte[24];
        System.arraycopy(this.jmqiStructure.getMsgId(), 0, this.messageId, 0, 24);
        this.correlationId = new byte[24];
        System.arraycopy(this.jmqiStructure.getCorrelId(), 0, this.correlationId, 0, 24);
        this.backoutCount = this.jmqiStructure.getBackoutCount();
        this.replyToQueueName = this.jmqiStructure.getReplyToQ();
        this.replyToQueueManagerName = this.jmqiStructure.getReplyToQMgr();
        boolean nSetAllCtx = (pmoFlags & 0x800) == 0;
        boolean bl = nSetIdCts = nSetAllCtx && (pmoFlags & 0x400) == 0;
        if (nSetIdCts) {
            this.userId = this.jmqiStructure.getUserIdentifier();
            this.accountingToken = new byte[32];
            System.arraycopy(this.jmqiStructure.getAccountingToken(), 0, this.accountingToken, 0, 32);
            this.applicationIdData = this.jmqiStructure.getApplIdentityData();
        }
        if (nSetAllCtx) {
            this.putApplicationType = this.jmqiStructure.getPutApplType();
            this.putApplicationName = this.jmqiStructure.getPutApplName();
            this.applicationOriginData = this.jmqiStructure.getApplOriginData();
            this.putDateTime = this.getDateAndTime(this.jmqiStructure.getPutDate(), this.jmqiStructure.getPutTime());
        }
        if (this.version >= 2) {
            this.groupId = new byte[24];
            System.arraycopy(this.jmqiStructure.getGroupId(), 0, this.groupId, 0, 24);
            this.messageSequenceNumber = this.jmqiStructure.getMsgSeqNumber();
            this.offset = this.jmqiStructure.getOffset();
            this.messageFlags = this.jmqiStructure.getMsgFlags();
            this.originalLength = this.jmqiStructure.getOriginalLength();
        }
    }

    public final DataOutputStream writeTo(DataOutputStream dataBuffer, int ccsid, boolean ccsidIsAscii) throws IOException, MQException {
        String date;
        block8: {
            if (Trace.isOn) {
                Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "writeTo(java.io.DataOutputStream,int,boolean)", new Object[]{dataBuffer, new Integer(ccsid), ccsidIsAscii});
            }
            dataBuffer.writeBytes("MD  ");
            dataBuffer.writeInt(this.version);
            dataBuffer.writeInt(this.report);
            dataBuffer.writeInt(this.messageType);
            dataBuffer.writeInt(this.expiry);
            dataBuffer.writeInt(this.feedback);
            dataBuffer.writeInt(this.encoding);
            dataBuffer.writeInt(this.characterSet);
            String fmt = null;
            fmt = MQSESSION.setStringToLength(this.format, 8);
            dataBuffer.write(this.makeBytesFromString(fmt, ccsid, ccsidIsAscii, false));
            dataBuffer.writeInt(this.priority);
            dataBuffer.writeInt(this.persistence);
            this.messageId = this.setArrayToLength(this.messageId, 24);
            dataBuffer.write(this.messageId, 0, 24);
            this.correlationId = this.setArrayToLength(this.correlationId, 24);
            dataBuffer.write(this.correlationId, 0, 24);
            dataBuffer.writeInt(this.backoutCount);
            String replyToQ = null;
            replyToQ = MQSESSION.setStringToLength(this.replyToQueueName, 48);
            dataBuffer.write(this.makeBytesFromString(replyToQ, ccsid, ccsidIsAscii, true));
            String replyToQMgr = null;
            replyToQMgr = MQSESSION.setStringToLength(this.replyToQueueManagerName, 48);
            dataBuffer.write(this.makeBytesFromString(replyToQMgr, ccsid, ccsidIsAscii, true));
            String userID = null;
            userID = MQSESSION.setStringToLength(this.userId, 12);
            dataBuffer.write(this.makeBytesFromString(userID, ccsid, ccsidIsAscii, false));
            try {
                this.accountingToken = this.setArrayToLength(this.accountingToken, 32);
            }
            catch (Exception e) {
                if (!Trace.isOn) break block8;
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "writeTo(java.io.DataOutputStream,int,boolean)", e);
            }
        }
        dataBuffer.write(this.accountingToken, 0, 32);
        String applId = null;
        applId = MQSESSION.setStringToLength(this.applicationIdData, 32);
        dataBuffer.write(this.makeBytesFromString(applId, ccsid, ccsidIsAscii, false));
        dataBuffer.writeInt(this.putApplicationType);
        String applName = null;
        applName = MQSESSION.setStringToLength(this.putApplicationName, 28);
        dataBuffer.write(this.makeBytesFromString(applName, ccsid, ccsidIsAscii, false));
        if (this.putDateTime == null) {
            date = MQMD.getDate(null);
            String time = MQMD.getTime(null);
            dataBuffer.writeBytes(this.makeStringFromBytes(date.getBytes(), ccsid, ccsidIsAscii, true));
            dataBuffer.writeBytes(this.makeStringFromBytes(time.getBytes(), ccsid, ccsidIsAscii, true));
        } else {
            if (this.putCalendar == null) {
                this.putCalendar = new GregorianCalendar(GMT);
            }
            this.putCalendar.setTime(this.putDateTime.getTime());
            date = MQMD.getDate(this.putCalendar);
            dataBuffer.writeBytes(this.makeStringFromBytes(date.getBytes(), ccsid, ccsidIsAscii, true));
            String time = MQMD.getTime(this.putCalendar);
            dataBuffer.writeBytes(this.makeStringFromBytes(time.getBytes(), ccsid, ccsidIsAscii, true));
        }
        String originData = null;
        originData = MQSESSION.setStringToLength(this.applicationOriginData, 4);
        dataBuffer.write(this.makeBytesFromString(originData, ccsid, ccsidIsAscii, false));
        if (this.version > 1) {
            this.groupId = this.setArrayToLength(this.groupId, 24);
            dataBuffer.write(this.groupId);
            dataBuffer.writeInt(this.messageSequenceNumber);
            dataBuffer.writeInt(this.offset);
            dataBuffer.writeInt(this.messageFlags);
            dataBuffer.writeInt(this.originalLength);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQMD", "writeTo(java.io.DataOutputStream,int,boolean)", dataBuffer);
        }
        return dataBuffer;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQMD", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQMD.java, jmscc.wmq.v6, k701, k701-112-140304  1.32.1.1 09/08/17 08:01:48");
        }
        GMT = TimeZone.getTimeZone("GMT");
        gmtConverter = new GregorianCalendar(GMT);
    }
}

