/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.MQGMO;
import com.ibm.mq.jmqi.handles.Hconn;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQC;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.util.Arrays;
import java.util.HashMap;

public class MQGetMessageOptions
extends JmqiObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQGetMessageOptions.java, jmscc.wmq.v6, k701, k701-112-140304 1.25.1.1 09/08/17 08:01:26";
    protected static final int sizeofMQGetMessageOptionsv1 = 72;
    protected static final int sizeofMQGetMessageOptionsv2 = 80;
    protected static final int sizeofMQGetMessageOptionsv3 = 100;
    public char groupStatus = (char)32;
    private MQGMO jmqiStructure = MQSESSION.getJmqiEnv().newMQGMO();
    public int matchOptions = 3;
    public byte[] msgToken = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean noReadBack = false;
    public int options = 0;
    public String resolvedQueueName = "";
    public int returnedLength = -1;
    public char segmentation = (char)32;
    public char segmentStatus = (char)32;
    private int version = 1;
    public int waitInterval = 0;

    public MQGetMessageOptions() {
        super(MQSESSION.getJmqiEnv());
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "<init>()");
        }
    }

    public MQGetMessageOptions(boolean noReadBack) {
        this();
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "<init>(boolean)", new Object[]{noReadBack});
        }
        if (noReadBack) {
            this.noReadBack = true;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "<init>(boolean)");
        }
    }

    protected void calcVersion(Hconn hconn) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "calcVersion(Hconn)", new Object[]{hconn});
        }
        int platform = 0;
        int cmdLevel = 0;
        int fapLevel = 0;
        if (hconn != null) {
            try {
                platform = hconn.getPlatform();
                cmdLevel = hconn.getCmdLevel();
                fapLevel = hconn.getFapLevel();
            }
            catch (JmqiException e) {
                if (Trace.isOn) {
                    Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "calcVersion(Hconn)", e);
                }
                HashMap<String, JmqiException> data = new HashMap<String, JmqiException>();
                data.put("exception", e);
                Trace.ffst((Object)this, "calcVersion", "probe1", data, null);
            }
            this.version = cmdLevel >= 600 || platform != 1 && cmdLevel >= 510 ? 3 : (platform != 1 && fapLevel >= 4 || platform == 1 && cmdLevel >= 530 ? 2 : 1);
            if (Trace.isOn) {
                Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "calcVersion(Hconn)", "Selected GMO version:", new Integer(this.version));
            }
        } else {
            int minVersion = 1;
            if (this.matchOptions != 3) {
                minVersion = 2;
            }
            if (this.groupStatus != ' ') {
                minVersion = 2;
            }
            if (this.segmentStatus != ' ') {
                minVersion = 2;
            }
            if (this.segmentation != ' ') {
                minVersion = 2;
            }
            if (this.msgToken != null && !Arrays.equals(this.msgToken, MQC.MQMTOK_NONE)) {
                minVersion = 3;
            }
            this.version = minVersion;
            if (Trace.isOn) {
                Trace.data((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "calcVersion(Hconn)", "Predicted GMO version (based on selected options - connection info unavailable):", new Integer(this.version));
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "calcVersion(Hconn)");
        }
    }

    protected MQGMO getJMQIStructure(Hconn hconn) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "getJMQIStructure(Hconn)", new Object[]{hconn});
        }
        this.jmqiStructure.setVersion(this.getVersion(hconn));
        this.jmqiStructure.setOptions(this.options);
        this.jmqiStructure.setWaitInterval(this.waitInterval);
        this.jmqiStructure.setResolvedQName(this.resolvedQueueName);
        this.jmqiStructure.setMsgToken(this.msgToken);
        this.jmqiStructure.setReturnedLength(this.returnedLength);
        this.jmqiStructure.setMatchOptions(this.matchOptions);
        this.jmqiStructure.setGroupStatus((int)this.groupStatus);
        this.jmqiStructure.setSegmentStatus((int)this.segmentStatus);
        this.jmqiStructure.setSegmentation((int)this.segmentation);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "getJMQIStructure(Hconn)", this.jmqiStructure);
        }
        return this.jmqiStructure;
    }

    protected final int getVersion(Hconn hconn) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "getVersion(Hconn)", new Object[]{hconn});
        }
        this.calcVersion(hconn);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "getVersion(Hconn)", new Integer(this.version));
        }
        return this.version;
    }

    protected final int sizeOfMQGetMessageOptions(Hconn hconn) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "sizeOfMQGetMessageOptions(Hconn)", new Object[]{hconn});
        }
        int version = this.getVersion(hconn);
        int pointerSize = 4;
        int size = 0;
        try {
            size = MQGMO.getSize((JmqiEnvironment)this.env, (int)version, (int)pointerSize);
        }
        catch (JmqiException e) {
            if (Trace.isOn) {
                Trace.catchBlock((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "sizeOfMQGetMessageOptions(Hconn)", e);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("version", Integer.toString(version));
            data.put("pointerSize", Integer.toString(pointerSize));
            data.put("exception", (Object)e);
            Trace.ffst((Object)this, "sizeOfMQGetMessageOptions", "probe1", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "sizeOfMQGetMessageOptions(Hconn)", new Integer(size));
        }
        return size;
    }

    protected void updateFromJMQIStructure() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "updateFromJMQIStructure()");
        }
        if (!this.noReadBack) {
            this.version = this.jmqiStructure.getVersion();
            this.options = this.jmqiStructure.getOptions();
            this.waitInterval = this.jmqiStructure.getWaitInterval();
            this.resolvedQueueName = this.jmqiStructure.getResolvedQName();
            this.msgToken = this.jmqiStructure.getMsgToken();
            this.returnedLength = this.jmqiStructure.getReturnedLength();
            this.matchOptions = this.jmqiStructure.getMatchOptions();
            this.groupStatus = (char)this.jmqiStructure.getGroupStatus();
            this.segmentStatus = (char)this.jmqiStructure.getSegmentStatus();
            this.segmentation = (char)this.jmqiStructure.getSegmentation();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "updateFromJMQIStructure()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQGetMessageOptions", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQGetMessageOptions.java, jmscc.wmq.v6, k701, k701-112-140304  1.25.1.1 09/08/17 08:01:26");
        }
    }
}

