/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class MQDateConverter
extends JmqiObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static MQDateConverter instance;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQDateConverter.java, jmscc.wmq.v6, k701, k701-112-140304 1.21.1.1 09/08/17 08:01:02";
    private GregorianCalendar calendar = null;
    private int firstMonthInTable;
    private long[] millisAtMonthStart;

    public static synchronized long mqDateTimeToMillis(byte[] time, byte[] date) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "mqDateTimeToMillis(byte [ ],byte [ ])", new Object[]{time, date});
        }
        long traceRet1 = instance.fastDateToMillis(time, date);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "mqDateTimeToMillis(byte [ ],byte [ ])", new Long(traceRet1));
        }
        return traceRet1;
    }

    public static synchronized long mqDateTimeToMillis(String time, String date) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "mqDateTimeToMillis(String,String)", new Object[]{time, date});
        }
        long traceRet1 = instance.fastDateToMillis(time.getBytes(), date.getBytes());
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "mqDateTimeToMillis(String,String)", new Long(traceRet1));
        }
        return traceRet1;
    }

    private MQDateConverter() {
        super(MQSESSION.getJmqiEnv());
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "<init>()");
        }
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.calendar.set(14, 0);
        this.firstMonthInTable = this.calendar.get(2) > 6 ? (this.calendar.get(1) - 1970) * 12 : (this.calendar.get(1) - 1970) * 12 - 6;
        this.millisAtMonthStart = new long[12];
        for (int i = this.firstMonthInTable; i < this.firstMonthInTable + 12; ++i) {
            this.calendar.set(i / 12 + 1970, i % 12, 1, 0, 0, 0);
            this.millisAtMonthStart[i - this.firstMonthInTable] = this.calendar.getTime().getTime();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "<init>()");
        }
    }

    private long fastDateToMillis(byte[] time, byte[] date) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "fastDateToMillis(byte [ ],byte [ ])", new Object[]{time, date});
        }
        int dateYear = (date[0] - 48) * 1000 + (date[1] - 48) * 100 + (date[2] - 48) * 10 + date[3] - 48;
        int dateMonth = (date[4] - 48) * 10 + date[5] - 48;
        long dateDay = (date[6] - 48) * 10 + date[7] - 48;
        long timeHour = (time[0] - 48) * 10 + time[1] - 48;
        long timeMinute = (time[2] - 48) * 10 + time[3] - 48;
        long timeSecond = (time[4] - 48) * 10 + time[5] - 48;
        long timeMillis = (time[6] - 48) * 100 + (time[7] - 48) * 10;
        int monthsSince1970 = (dateYear - 1970) * 12 + dateMonth;
        long retValue = 0L;
        if (monthsSince1970 > this.firstMonthInTable + 12) {
            if (System.currentTimeMillis() > this.millisAtMonthStart[11]) {
                this.updateTable();
                retValue = monthsSince1970 > this.firstMonthInTable + 12 ? this.slowDateToMillis(dateYear, dateMonth, dateDay, timeHour, timeMinute, timeSecond, timeMillis) : this.millisAtMonthStart[monthsSince1970 - this.firstMonthInTable - 1] + (dateDay - 1L) * 86400000L + timeHour * 3600000L + timeMinute * 60000L + timeSecond * 1000L + timeMillis;
            } else {
                retValue = this.slowDateToMillis(dateYear, dateMonth, dateDay, timeHour, timeMinute, timeSecond, timeMillis);
            }
        } else {
            retValue = monthsSince1970 > this.firstMonthInTable ? this.millisAtMonthStart[monthsSince1970 - this.firstMonthInTable - 1] + (dateDay - 1L) * 86400000L + timeHour * 3600000L + timeMinute * 60000L + timeSecond * 1000L + timeMillis : this.slowDateToMillis(dateYear, dateMonth, dateDay, timeHour, timeMinute, timeSecond, timeMillis);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "fastDateToMillis(byte [ ],byte [ ])", new Long(retValue));
        }
        return retValue;
    }

    private long slowDateToMillis(int year, int month, long day, long hour, long minute, long second, long millis) {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "slowDateToMillis(int,int,long,long,long,long,long)", new Object[]{new Integer(year), new Integer(month), new Long(day), new Long(hour), new Long(minute), new Long(second), new Long(millis)});
        }
        this.calendar.set(year, month - 1, (int)day, (int)hour, (int)minute, (int)second);
        this.calendar.set(14, (int)millis);
        long traceRet1 = this.calendar.getTime().getTime();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "slowDateToMillis(int,int,long,long,long,long,long)", new Long(traceRet1));
        }
        return traceRet1;
    }

    private void updateTable() {
        int i;
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "updateTable()");
        }
        for (i = 6; i < 12; ++i) {
            this.millisAtMonthStart[i - 6] = this.millisAtMonthStart[i];
        }
        this.calendar.set(14, 0);
        this.firstMonthInTable += 6;
        for (i = this.firstMonthInTable + 6; i < this.firstMonthInTable + 12; ++i) {
            this.calendar.set(i / 12 + 1970, i % 12, 1, 0, 0, 0);
            this.millisAtMonthStart[i - this.firstMonthInTable] = this.calendar.getTime().getTime();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "updateTable()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQDateConverter.java, jmscc.wmq.v6, k701, k701-112-140304  1.21.1.1 09/08/17 08:01:02");
        }
        instance = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "static()");
        }
        instance = new MQDateConverter();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQDateConverter", "static()");
        }
    }
}

