/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo;
import com.ibm.msg.client.wmq.v6.base.internal.MQConnectionRequestInfo;
import com.ibm.msg.client.wmq.v6.base.internal.MQEnvironment;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionFactory;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11;
import com.ibm.msg.client.wmq.v6.base.internal.MQResourceException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

class MQClientManagedConnectionFactoryJ11
implements MQManagedConnectionFactory {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQClientManagedConnectionFactoryJ11.java, jmscc.wmq.v6, k701, k701-112-140304 1.32.1.1 09/08/17 08:00:19";
    private static final long serialVersionUID = 4815162342L;
    private int fieldCCSID = 819;
    private String fieldChannel = "";
    private int fieldPortNumber = 1414;
    private String fieldQMGR = "";
    private String fieldServerName = "";

    MQClientManagedConnectionFactoryJ11(String qmgr, Map mqProperties) {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "<init>(String,Map)", new Object[]{qmgr, propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "<init>(String,Map)", new Object[]{qmgr, mqProperties});
            }
        }
        this.fieldQMGR = qmgr;
        String svrName = MQEnvironment.getStringProperty("hostname", mqProperties);
        this.fieldServerName = svrName != null ? svrName : "localhost";
        this.fieldPortNumber = MQEnvironment.getIntegerProperty("port", mqProperties);
        this.fieldChannel = MQEnvironment.getStringProperty("channel", mqProperties);
        this.fieldCCSID = MQEnvironment.getIntegerProperty("CCSID", mqProperties);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "<init>(String,Map)");
        }
    }

    public MQManagedConnectionJ11 createManagedConnection(MQConnectionRequestInfo cxRequestInfo) throws MQResourceException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "createManagedConnection(MQConnectionRequestInfo)", new Object[]{cxRequestInfo});
        }
        MQManagedConnectionJ11 traceRet1 = this._createManagedConnection(cxRequestInfo);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "createManagedConnection(MQConnectionRequestInfo)", traceRet1);
        }
        return traceRet1;
    }

    MQManagedConnectionJ11 _createManagedConnection(MQConnectionRequestInfo cxRequestInfo) throws MQResourceException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "_createManagedConnection(MQConnectionRequestInfo)", new Object[]{cxRequestInfo});
        }
        if (!(cxRequestInfo instanceof ClientConnectionRequestInfo)) {
            String msg = MQException.getNLSMsg((String)"MQJI039");
            MQResourceException traceRet1 = new MQResourceException(msg);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "_createManagedConnection(MQConnectionRequestInfo)", traceRet1);
            }
            throw traceRet1;
        }
        ClientConnectionRequestInfo cCxReqInf = (ClientConnectionRequestInfo)cxRequestInfo;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("transport", "MQSeries Client");
        properties.put("hostname", this.fieldServerName);
        properties.put("port", new Integer(this.fieldPortNumber));
        properties.put("channel", this.fieldChannel);
        properties.put("CCSID", new Integer(this.fieldCCSID));
        properties.put("connectOptions", new Integer(cCxReqInf.connectOptions));
        if (cCxReqInf.securityExit != null) {
            properties.put("securityExit", cCxReqInf.securityExit);
        }
        if (cCxReqInf.sendExit != null) {
            properties.put("sendExit", cCxReqInf.sendExit);
        }
        if (cCxReqInf.receiveExit != null) {
            properties.put("receiveExit", cCxReqInf.receiveExit);
        }
        if (cCxReqInf.securityExitData != null) {
            properties.put("securitydExitData", cCxReqInf.securityExitData);
        }
        if (cCxReqInf.sendExitData != null) {
            properties.put("sendExitData", cCxReqInf.sendExitData);
        }
        if (cCxReqInf.receiveExitData != null) {
            properties.put("receiveExitData", cCxReqInf.receiveExitData);
        }
        if (cCxReqInf.userName != null) {
            properties.put("userID", cCxReqInf.userName);
        }
        if (cCxReqInf.password != null) {
            properties.put("password", cCxReqInf.password);
        }
        if (cCxReqInf.spi != null) {
            properties.put("SPI", cCxReqInf.spi);
        }
        if (cCxReqInf.ccdtUrl != null) {
            properties.put("CCDT URL", cCxReqInf.ccdtUrl);
        }
        if (cCxReqInf.inheritTx != null) {
            if (Trace.isOn) {
                Trace.traceData(this, "put inheritTx = " + cCxReqInf.inheritTx, null);
            }
            properties.put("SPI_INHERIT_TX", cCxReqInf.inheritTx);
        }
        if (cCxReqInf.asyncCmt != null) {
            if (Trace.isOn) {
                Trace.traceData(this, "put asyncCmt  = " + cCxReqInf.asyncCmt, null);
            }
            properties.put("SPI_ASYNC_CMIT", cCxReqInf.asyncCmt);
        }
        if (cCxReqInf.xaRequired) {
            properties.put("XAReq", new Boolean(true));
        }
        if (cCxReqInf.useQmCcsid) {
            properties.put("Use QM CCSID", new Boolean(true));
        }
        if (cCxReqInf.useBatching != null) {
            properties.put("Batching enabled", cCxReqInf.useBatching);
        }
        if (cCxReqInf.batchFloor != null) {
            properties.put("Batch size floor", cCxReqInf.batchFloor);
        }
        if (cCxReqInf.batchCeiling != null) {
            properties.put("Batch size ceiling", cCxReqInf.batchCeiling);
        }
        if (cCxReqInf.batchThreshold != null) {
            properties.put("Batching threshold", cCxReqInf.batchThreshold);
        }
        if (cCxReqInf.batchInterval != null) {
            properties.put("Batch interval", cCxReqInf.batchInterval);
        }
        if (cCxReqInf.sslCipherSuite != null) {
            properties.put("SSL Cipher Suite", cCxReqInf.sslCipherSuite);
        }
        if (cCxReqInf.sslPeername != null) {
            properties.put("SSL Peer Name", cCxReqInf.sslPeername);
        }
        if (cCxReqInf.sslCertStores != null) {
            properties.put("SSL CertStores", cCxReqInf.sslCertStores);
        }
        if (cCxReqInf.sslSocketFactory != null) {
            properties.put("SSL Socket Factory", cCxReqInf.sslSocketFactory);
        }
        if (cCxReqInf.sslResetCount != null) {
            properties.put("KeyResetCount", cCxReqInf.sslResetCount);
        }
        if (cCxReqInf.sslFipsRequired != null) {
            properties.put("SSL Fips Required", cCxReqInf.sslFipsRequired);
        }
        if (cCxReqInf.localAddress != null) {
            properties.put("FIREWALL_SETTINGS", cCxReqInf.localAddress);
        }
        if (cCxReqInf.hdrCompList != null) {
            properties.put("Header Compression Property", cCxReqInf.hdrCompList);
        }
        if (cCxReqInf.msgCompList != null) {
            properties.put("ProviderMessage Compression Property", cCxReqInf.msgCompList);
        }
        if (cCxReqInf.connTag != null) {
            properties.put("ConnTag Property", cCxReqInf.connTag);
        }
        MQManagedConnectionJ11 mancon = new MQManagedConnectionJ11(this.fieldQMGR, properties, cCxReqInf, this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "_createManagedConnection(MQConnectionRequestInfo)", mancon);
        }
        return mancon;
    }

    public Object clone() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "clone()");
        }
        try {
            Object traceRet1 = super.clone();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "clone()", traceRet1);
            }
            return traceRet1;
        }
        catch (CloneNotSupportedException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "clone()", e);
            }
            IllegalAccessError traceRet2 = new IllegalAccessError();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "clone()", traceRet2);
            }
            throw traceRet2;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MQClientManagedConnectionFactoryJ11 other = (MQClientManagedConnectionFactoryJ11)obj;
        return MQClientManagedConnectionFactoryJ11.twoStringsEqual(this.fieldQMGR, other.fieldQMGR) && this.fieldServerName.equals(other.fieldServerName) && this.fieldPortNumber == other.fieldPortNumber && this.fieldChannel.equals(other.fieldChannel) && this.fieldCCSID == other.fieldCCSID;
    }

    public int hashCode() {
        int traceRet1 = this.getClass().hashCode();
        return traceRet1;
    }

    static boolean twoStringsEqual(String a, String b) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "twoStringsEqual(String,String)", new Object[]{a, b});
        }
        boolean result = a == null && b == null ? true : (a == null || b == null ? false : a.equals(b));
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "twoStringsEqual(String,String)", result);
        }
        return result;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQClientManagedConnectionFactoryJ11", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQClientManagedConnectionFactoryJ11.java, jmscc.wmq.v6, k701, k701-112-140304  1.32.1.1 09/08/17 08:00:19");
        }
    }
}

