/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.exits.MQCD;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQSESSION;
import java.util.Collection;
import java.util.Iterator;

public class MQChannelDefinition
extends JmqiObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#)  com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQChannelDefinition.java, jmscc.wmq.v6, k701, k701-112-140304 1.24.1.1 09/08/17 08:00:04";
    public String channelName;
    public String connectionName;
    public Collection hdrCompList = null;
    private MQCD jmqiStructure = MQSESSION.getJmqiEnv().newMQCD();
    public String localAddress;
    public int maxMessageLength;
    public Collection msgCompList = null;
    public int port;
    public String queueManagerName;
    public String receiveUserData;
    public String remotePassword;
    public String remoteUserId;
    public String securityUserData;
    public String sendUserData;
    public int sharingConversations = -1;
    private static final int SHARING_CONVERSATIONS_NOT_SET = -1;
    public String sslPeerName;
    public String sslCipherSpec = null;

    public MQChannelDefinition() {
        super(MQSESSION.getJmqiEnv());
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "<init>()");
        }
    }

    private int calcMinimumVersion() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "calcMinimumVersion()");
        }
        int version = 2;
        if (this.remoteUserId != null && this.remoteUserId.length() > 12) {
            version = 6;
        }
        if (this.remotePassword != null && this.remotePassword.length() > 12) {
            version = 6;
        }
        if (this.localAddress != null && this.localAddress.length() > 0) {
            version = 7;
        }
        if (this.sslCipherSpec != null && this.sslCipherSpec.length() > 0) {
            version = 7;
        }
        if (this.sslPeerName != null && this.sslPeerName.length() > 0) {
            version = 7;
        }
        if (this.hdrCompList != null && this.hdrCompList.size() > 0) {
            version = 8;
        }
        if (this.msgCompList != null && this.msgCompList.size() > 0) {
            version = 8;
        }
        if (this.sharingConversations != -1) {
            version = 9;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "calcMinimumVersion()", new Integer(version));
        }
        return version;
    }

    protected MQCD getJMQIStructure() {
        if (Trace.isOn) {
            Trace.entry((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "getJMQIStructure()");
        }
        this.jmqiStructure.setVersion(this.calcMinimumVersion());
        this.jmqiStructure.setChannelName(this.channelName);
        this.jmqiStructure.setQMgrName(this.queueManagerName);
        this.jmqiStructure.setMaxMsgLength(this.maxMessageLength);
        this.jmqiStructure.setConnectionName(this.connectionName);
        this.jmqiStructure.setRemoteUserIdentifier(this.remoteUserId);
        this.jmqiStructure.setRemotePassword(this.remotePassword);
        this.jmqiStructure.setSslPeerName(this.sslPeerName);
        this.jmqiStructure.setLocalAddress(this.localAddress);
        this.jmqiStructure.setSslCipherSpec(this.sslCipherSpec);
        this.jmqiStructure.setSecurityUserData(this.securityUserData);
        this.jmqiStructure.setSendUserData(this.sendUserData);
        this.jmqiStructure.setReceiveUserData(this.receiveUserData);
        Collection localHdrCompList = this.hdrCompList;
        if (localHdrCompList != null) {
            int[] hdrCompListArray = new int[localHdrCompList.size()];
            Iterator iterator = localHdrCompList.iterator();
            int entryIndex = 0;
            while (iterator.hasNext()) {
                Object hdrCompEntry = iterator.next();
                hdrCompListArray[entryIndex] = hdrCompEntry instanceof Integer ? (Integer)hdrCompEntry : 0;
                ++entryIndex;
            }
            this.jmqiStructure.setHdrCompList(hdrCompListArray);
        } else {
            this.jmqiStructure.setHdrCompList(null);
        }
        Collection localMsgCompList = this.msgCompList;
        if (localMsgCompList != null) {
            int[] msgCompListArray = new int[localMsgCompList.size()];
            Iterator iterator = localMsgCompList.iterator();
            int entryIndex = 0;
            while (iterator.hasNext()) {
                Object msgCompEntry = iterator.next();
                msgCompListArray[entryIndex] = msgCompEntry instanceof Integer ? (Integer)msgCompEntry : 0;
                ++entryIndex;
            }
            this.jmqiStructure.setMsgCompList(msgCompListArray);
        } else {
            this.jmqiStructure.setMsgCompList(null);
        }
        if (this.sharingConversations != -1) {
            this.jmqiStructure.setSharingConversations(this.sharingConversations);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "getJMQIStructure()", this.jmqiStructure);
        }
        return this.jmqiStructure;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.MQChannelDefinition", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/MQChannelDefinition.java, jmscc.wmq.v6, k701, k701-112-140304  1.24.1.1 09/08/17 08:00:04");
        }
    }
}

