/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.v6.base.internal;

import com.ibm.mq.MQException;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.wmq.v6.base.internal.MQConnectionRequestInfo;
import com.ibm.msg.client.wmq.v6.base.internal.MQEnvironment;
import com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11;
import com.ibm.msg.client.wmq.v6.network.FWHelper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

class ClientConnectionRequestInfo
extends MQConnectionRequestInfo
implements Cloneable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/ClientConnectionRequestInfo.java, jmscc.wmq.v6, k701, k701-112-140304 1.34.1.3 10/12/03 15:05:07";
    public Object asyncCmt;
    public Integer batchCeiling = null;
    public Integer batchFloor = null;
    public Integer batchInterval = null;
    public Integer batchThreshold = null;
    public Object ccdtUrl = null;
    public int connectOptions;
    public byte[] connTag = null;
    public Object hdrCompList = null;
    public Object inheritTx;
    public Object localAddress = "";
    public Object msgCompList = null;
    public String password;
    public String receiveExit;
    public String receiveExitData;
    public String securityExit;
    public String securityExitData;
    public String sendExit;
    public String sendExitData;
    public String spi;
    public Object sslCertStores = null;
    public String sslCipherSuite = null;
    public Boolean sslFipsRequired = null;
    public String sslPeername = null;
    public Integer sslResetCount = null;
    public Object sslSocketFactory = null;
    public Boolean useBatching = null;
    public boolean useQmCcsid;
    public String userName;
    public boolean xaRequired;

    private static boolean byteArrayEquals(byte[] bytes1, byte[] bytes2) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "byteArrayEquals(byte [ ],byte [ ])", new Object[]{bytes1, bytes2});
        }
        if (bytes1 == bytes2) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "byteArrayEquals(byte [ ],byte [ ])", true, 1);
            }
            return true;
        }
        if (bytes1 == null || bytes2 == null) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "byteArrayEquals(byte [ ],byte [ ])", false, 2);
            }
            return false;
        }
        if (bytes1.length != bytes2.length) {
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "byteArrayEquals(byte [ ],byte [ ])", false, 3);
            }
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            if (Trace.isOn) {
                Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "byteArrayEquals(byte [ ],byte [ ])", false, 4);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "byteArrayEquals(byte [ ],byte [ ])", true, 5);
        }
        return true;
    }

    ClientConnectionRequestInfo(Hashtable props) throws MQException {
        if (Trace.isOn) {
            if (props.containsKey("password")) {
                Hashtable<String, String> propsNotPasswd = new Hashtable<String, String>(props);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "<init>(Hashtable)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "<init>(Hashtable)", new Object[]{props});
            }
        }
        this.complexPopulate(props);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "<init>(Hashtable)");
        }
    }

    ClientConnectionRequestInfo(Map mqProperties, boolean fromUrl) throws MQException {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "<init>(Map,boolean)", new Object[]{propsNotPasswd, fromUrl});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "<init>(Map,boolean)", new Object[]{mqProperties, fromUrl});
            }
        }
        if (fromUrl) {
            this.simplePopulate(mqProperties);
        } else {
            this.complexPopulate(mqProperties);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "<init>(Hashtable,boolean)");
        }
    }

    private void complexPopulate(Map mqProperties) throws MQException {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "complexPopulate(Map)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "complexPopulate(Map)", new Object[]{mqProperties});
            }
        }
        this.hasVariablePortion = true;
        this.ccdtUrl = MQEnvironment.getObjectProperty("CCDT URL", mqProperties);
        this.connectOptions = MQEnvironment.getIntegerProperty("connectOptions", mqProperties);
        this.securityExit = (String)MQEnvironment.getObjectProperty("securityExit", mqProperties);
        this.receiveExit = (String)MQEnvironment.getObjectProperty("receiveExit", mqProperties);
        this.sendExit = (String)MQEnvironment.getObjectProperty("sendExit", mqProperties);
        this.securityExitData = (String)MQEnvironment.getObjectProperty("securitydExitData", mqProperties);
        this.receiveExitData = (String)MQEnvironment.getObjectProperty("receiveExitData", mqProperties);
        this.sendExitData = (String)MQEnvironment.getObjectProperty("sendExitData", mqProperties);
        this.userName = MQEnvironment.getStringProperty("userID", mqProperties);
        this.password = MQEnvironment.getStringProperty("password", mqProperties);
        this.spi = MQEnvironment.getStringProperty("SPI", mqProperties);
        this.inheritTx = MQEnvironment.getObjectProperty("SPI_INHERIT_TX", mqProperties);
        this.asyncCmt = MQEnvironment.getObjectProperty("SPI_ASYNC_CMIT", mqProperties);
        if (Trace.isOn) {
            Trace.traceData(this, "inheritTx = " + this.inheritTx, null);
            Trace.traceData(this, "asyncCmt = " + this.asyncCmt, null);
        }
        this.sslCipherSuite = MQEnvironment.getStringProperty("SSL Cipher Suite", mqProperties);
        this.sslPeername = MQEnvironment.getStringProperty("SSL Peer Name", mqProperties);
        this.sslCertStores = MQEnvironment.getObjectProperty("SSL CertStores", mqProperties);
        if (this.sslCertStores instanceof Vector) {
            this.sslCertStores = ((Vector)this.sslCertStores).clone();
            if (Trace.isOn) {
                Trace.traceData(this, "Cloned sslCertStores (complexPopulate)", (Object)"");
            }
        }
        this.sslSocketFactory = MQEnvironment.getObjectProperty("SSL Socket Factory", mqProperties);
        this.hdrCompList = MQEnvironment.getObjectProperty("Header Compression Property", mqProperties);
        if (this.hdrCompList instanceof Vector) {
            this.hdrCompList = ((Vector)this.hdrCompList).clone();
            if (Trace.isOn) {
                Trace.traceData(this, "Cloned hdrCompList (complexPopulate)", (Object)"");
            }
        }
        this.msgCompList = MQEnvironment.getObjectProperty("ProviderMessage Compression Property", mqProperties);
        if (this.msgCompList instanceof Vector) {
            this.msgCompList = ((Vector)this.msgCompList).clone();
            if (Trace.isOn) {
                Trace.traceData(this, "Cloned msgCompList (complexPopulate)", (Object)"");
            }
        }
        this.sslResetCount = (Integer)MQEnvironment.getObjectProperty("KeyResetCount", mqProperties);
        this.sslFipsRequired = (Boolean)MQEnvironment.getObjectProperty("SSL Fips Required", mqProperties);
        this.connTag = (byte[])MQEnvironment.getObjectProperty("ConnTag Property", mqProperties);
        String localAddressStr = MQEnvironment.getStringProperty("Local Address Property", mqProperties);
        if (localAddressStr != null) {
            FWHelper.encodeToObject(localAddressStr);
            this.localAddress = localAddressStr;
        }
        this.setClassFields(mqProperties);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "complexPopulate(Map)");
        }
    }

    public boolean fixedEquals(Object obj) {
        block12: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", new Object[]{obj});
            }
            if (this == obj) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", true, 1);
                }
                return true;
            }
            if (obj == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", false, 2);
                }
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", false, 3);
                }
                return false;
            }
            ClientConnectionRequestInfo other = (ClientConnectionRequestInfo)obj;
            try {
                if (this.connectOptions == other.connectOptions && this.objEquals(this.userName, other.userName) && this.objEquals(this.password, other.password) && this.objEquals(this.securityExit, other.securityExit) && this.objEquals(this.sendExit, other.sendExit) && this.objEquals(this.receiveExit, other.receiveExit) && this.xaRequired == other.xaRequired && this.useQmCcsid == other.useQmCcsid && this.objEquals(this.spi, other.spi) && this.objEquals(this.inheritTx, other.inheritTx) && this.objEquals(this.asyncCmt, other.asyncCmt) && this.objEquals(this.useBatching, other.useBatching) && this.objEquals(this.batchFloor, other.batchFloor) && this.objEquals(this.batchCeiling, other.batchCeiling) && this.objEquals(this.batchThreshold, other.batchThreshold) && this.objEquals(this.batchInterval, other.batchInterval) && this.objEquals(this.sslCipherSuite, other.sslCipherSuite) && this.objEquals(this.sslPeername, other.sslPeername) && this.objEquals(this.sslCertStores, other.sslCertStores) && this.objEquals(this.hdrCompList, other.hdrCompList) && this.objEquals(this.msgCompList, other.msgCompList) && ClientConnectionRequestInfo.byteArrayEquals(this.connTag, other.connTag) && this.objEquals(this.sslResetCount, other.sslResetCount) && this.objEquals(this.sslFipsRequired, other.sslFipsRequired)) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", true, 4);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block12;
                Trace.catchBlock(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedEquals(Object)", false, 5);
        }
        return false;
    }

    public int fixedHashCode() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedHashCode()");
        }
        int out = 31 * this.connectOptions;
        if (this.userName != null) {
            out += 37 * this.userName.hashCode();
        }
        if (this.xaRequired) {
            out += 43;
        }
        if (this.useQmCcsid) {
            out += 47;
        }
        if (this.spi != null) {
            out += 53 * this.spi.hashCode();
        }
        if (this.useBatching != null) {
            out += 59 * this.useBatching.hashCode();
        }
        if (this.batchFloor != null) {
            out += 61 * this.batchFloor.hashCode();
        }
        if (this.batchCeiling != null) {
            out += 67 * this.batchCeiling.hashCode();
        }
        if (this.batchThreshold != null) {
            out += 71 * this.batchThreshold.hashCode();
        }
        if (this.batchInterval != null) {
            out += 73 * this.batchInterval.hashCode();
        }
        if (this.sslCipherSuite != null) {
            out += 79 * this.sslCipherSuite.hashCode();
        }
        if (this.sslPeername != null) {
            out += 83 * this.sslPeername.hashCode();
        }
        if (this.sslCertStores != null) {
            out += 89 * this.sslCertStores.hashCode();
        }
        if (this.hdrCompList != null) {
            out += 103 * this.hdrCompList.hashCode();
        }
        if (this.msgCompList != null) {
            out += 107 * this.msgCompList.hashCode();
        }
        if (this.connTag != null) {
            out += 109 * new String(this.connTag).hashCode();
        }
        if (this.sslResetCount != null) {
            out += 113 * this.sslResetCount.hashCode();
        }
        if (this.sslFipsRequired != null) {
            out += 127 * this.sslFipsRequired.hashCode();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "fixedHashCode()", new Integer(out));
        }
        return out;
    }

    private int getInt(Map mqProperties, String key) {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "getInt(Map,String)", new Object[]{propsNotPasswd, key});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "getInt(Map,String)", new Object[]{mqProperties, key});
            }
        }
        Integer integer = (Integer)mqProperties.get(key);
        int result = 0;
        if (integer != null) {
            result = integer;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "getInt(Map,String)", new Integer(result));
        }
        return result;
    }

    private void setClassFields(Map mqProperties) {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "setClassFields(Map)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "setClassFields(Map)", new Object[]{mqProperties});
            }
        }
        if (mqProperties != null) {
            this.xaRequired = false;
            Object xar = mqProperties.get("XAReq");
            if (xar != null && xar instanceof Boolean) {
                this.xaRequired = (Boolean)xar;
            }
            this.useQmCcsid = false;
            Object object = mqProperties.get("Use QM CCSID");
            if (object != null && object instanceof Boolean) {
                this.useQmCcsid = (Boolean)object;
            }
            if ((object = mqProperties.get("Batching enabled")) != null && object instanceof Boolean) {
                this.useBatching = (Boolean)object;
            }
            if ((object = mqProperties.get("Batch size floor")) != null && object instanceof Integer) {
                this.batchFloor = (Integer)object;
            }
            if ((object = mqProperties.get("Batch size ceiling")) != null && object instanceof Integer) {
                this.batchCeiling = (Integer)object;
            }
            if ((object = mqProperties.get("Batching threshold")) != null && object instanceof Integer) {
                this.batchThreshold = (Integer)object;
            }
            if ((object = mqProperties.get("Batch interval")) != null && object instanceof Integer) {
                this.batchInterval = (Integer)object;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "setClassFields(Map)");
        }
    }

    private void simplePopulate(Map mqProperties) throws MQException {
        if (Trace.isOn) {
            if (mqProperties.containsKey("password")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(mqProperties);
                propsNotPasswd.put("password", "********");
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "simplePopulate(Map)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "simplePopulate(Map)", new Object[]{mqProperties});
            }
        }
        this.hasVariablePortion = true;
        this.ccdtUrl = mqProperties.get("CCDT URL");
        this.connectOptions = this.getInt(mqProperties, "connectOptions");
        this.securityExit = (String)mqProperties.get("securityExit");
        this.receiveExit = (String)mqProperties.get("receiveExit");
        this.sendExit = (String)mqProperties.get("sendExit");
        this.securityExitData = (String)mqProperties.get("securitydExitData");
        this.receiveExitData = (String)mqProperties.get("receiveExitData");
        this.sendExitData = (String)mqProperties.get("sendExitData");
        this.userName = MQEnvironment.getStringProperty("userID", mqProperties);
        this.password = MQEnvironment.getStringProperty("password", mqProperties);
        this.spi = (String)mqProperties.get("SPI");
        this.inheritTx = mqProperties.get("SPI_INHERIT_TX");
        this.asyncCmt = mqProperties.get("SPI_ASYNC_CMIT");
        if (Trace.isOn) {
            Trace.traceData(this, "inheritTx = " + this.inheritTx, null);
            Trace.traceData(this, "asyncCmt = " + this.asyncCmt, null);
        }
        this.sslCipherSuite = (String)mqProperties.get("SSL Cipher Suite");
        this.sslPeername = (String)mqProperties.get("SSL Peer Name");
        this.sslCertStores = mqProperties.get("SSL CertStores");
        if (this.sslCertStores instanceof Vector) {
            this.sslCertStores = ((Vector)this.sslCertStores).clone();
            if (Trace.isOn) {
                Trace.traceData(this, "Cloned sslCertStores (simplePopulate)", (Object)"");
            }
        }
        this.sslSocketFactory = mqProperties.get("SSL Socket Factory");
        this.hdrCompList = mqProperties.get("Header Compression Property");
        if (this.hdrCompList instanceof Vector) {
            this.hdrCompList = ((Vector)this.hdrCompList).clone();
            if (Trace.isOn) {
                Trace.traceData(this, "Cloned hdrCompList (simplePopulate)", (Object)"");
            }
        }
        this.msgCompList = mqProperties.get("ProviderMessage Compression Property");
        if (this.msgCompList instanceof Vector) {
            this.msgCompList = ((Vector)this.msgCompList).clone();
            if (Trace.isOn) {
                Trace.traceData(this, "Cloned msgCompList (simplePopulate)", (Object)"");
            }
        }
        this.sslResetCount = (Integer)mqProperties.get("KeyResetCount");
        this.connTag = (byte[])mqProperties.get("ConnTag Property");
        String localAddressStr = (String)mqProperties.get("Local Address Property");
        if (localAddressStr != null && !localAddressStr.equals("")) {
            FWHelper.encodeToObject(localAddressStr);
            this.localAddress = localAddressStr;
        }
        this.setClassFields(mqProperties);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "simplePopulate(Map)");
        }
    }

    public boolean variableEquals(Object obj) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableEquals(Object)", new Object[]{obj});
        }
        ClientConnectionRequestInfo other = (ClientConnectionRequestInfo)obj;
        if (!this.objEquals(this.localAddress, other.localAddress)) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableEquals(Object)", false, 1);
            }
            return false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableEquals(Object)", true, 2);
        }
        return true;
    }

    public int variableHashCode() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableHashCode()");
        }
        int out = 0;
        if (this.localAddress != null) {
            out += 101 * this.localAddress.hashCode();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableHashCode()", new Integer(out));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean variableIsSuitable(MQManagedConnectionJ11 mc) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableIsSuitable(MQManagedConnectionJ11)", new Object[]{mc});
        }
        if (mc == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableIsSuitable(MQManagedConnectionJ11)", false, 1);
            }
            return false;
        }
        MQManagedConnectionJ11 mQManagedConnectionJ11 = mc;
        synchronized (mQManagedConnectionJ11) {
            if (!FWHelper.fuzzyCompare(mc, this.localAddress)) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableIsSuitable(MQManagedConnectionJ11)", false, 2);
                }
                return false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "variableIsSuitable(MQManagedConnectionJ11)", true, 3);
        }
        return true;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.v6.base.internal.ClientConnectionRequestInfo", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.v6/src/com/ibm/msg/client/wmq/v6/base/internal/ClientConnectionRequestInfo.java, jmscc.wmq.v6, k701, k701-112-140304  1.34.1.3 10/12/03 15:05:07");
        }
    }
}

