/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.wmq.messages;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.wmq.common.internal.messages.WMQStreamMessage;
import com.ibm.msg.client.wmq.messages.TransientMessage;
import com.ibm.msg.client.wmq.v6.direct.internal.SessionImpl;
import com.ibm.msg.client.wmq.v6.direct.internal.StreamMessageImpl;
import com.ibm.msg.client.wmq.v6.jms.internal.JMSStreamMessage;
import com.ibm.msg.client.wmq.v6.jms.internal.MQSession;
import java.util.ArrayList;
import javax.jms.JMSException;

public class TransientStreamMessage
extends TransientMessage
implements ProviderStreamMessage {
    private static final long serialVersionUID = -9203783229043607847L;
    public static final String sccsid = "@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/messages/TransientStreamMessage.java, jmscc.wmq, k701, k701-112-140304 1.9.1.1 09/08/17 08:56:53";
    private ArrayList stream = new ArrayList();
    private int streamPos;

    public TransientStreamMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "<init>()");
        }
        this.messageClass = "jms_stream";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "<init>()");
        }
    }

    public Object readObject() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "readObject()");
        }
        if (this.streamPos >= this.stream.size()) {
            JMSException je = (JMSException)((Object)NLSServices.createException("JMSWMQ0017", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "readObject()", je);
            }
            throw je;
        }
        Object object = this.stream.get(this.streamPos);
        ++this.streamPos;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "readObject()", object);
        }
        return object;
    }

    public void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "reset()");
        }
        this.streamPos = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "reset()");
        }
    }

    public void stepBack() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "stepBack()");
        }
        if (this.streamPos > 0) {
            --this.streamPos;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "stepBack()");
        }
    }

    public synchronized void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "clearBody()");
        }
        this.streamPos = 0;
        this.stream.clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "clearBody()");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeBoolean(boolean)", new Object[]{value});
        }
        this.stream.add(new Boolean(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeByte(byte)", new Object[]{new Byte(value)});
        }
        this.stream.add(new Byte(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeByte(byte)");
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeBytes(byte [ ])", new Object[]{value});
        }
        this.stream.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeBytes(byte [ ])");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        byte[] bytes = new byte[length];
        System.arraycopy(value, offset, bytes, 0, length);
        this.stream.add(bytes);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeChar(char)", new Object[]{new Character(value)});
        }
        this.stream.add(new Character(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeChar(char)");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeDouble(double)", new Object[]{new Double(value)});
        }
        this.stream.add(new Double(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeDouble(double)");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeFloat(float)", new Object[]{new Float(value)});
        }
        this.stream.add(new Float(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeFloat(float)");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeInt(int)", new Object[]{new Integer(value)});
        }
        this.stream.add(new Integer(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeInt(int)");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeLong(long)", new Object[]{new Long(value)});
        }
        this.stream.add(new Long(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeLong(long)");
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeObject(Object)", new Object[]{value});
        }
        this.stream.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeObject(Object)");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeShort(short)", new Object[]{new Short(value)});
        }
        this.stream.add(new Short(value));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeShort(short)");
        }
    }

    public void writeString(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeString(String)", new Object[]{value});
        }
        this.stream.add(value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "writeString(String)");
        }
    }

    public ArrayList getStreamData() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "getStreamData()", "getter", this.stream);
        }
        return this.stream;
    }

    public ProviderMessage convertIntoWMQMessage(ProviderSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "convertIntoWMQMessage(ProviderSession)", new Object[]{session});
        }
        WMQStreamMessage retValue = new WMQStreamMessage();
        this.setJMSPropsOnProviderMessage(retValue);
        this.setPCPropertiesOnProviderMessage(retValue);
        for (int i = 0; i < this.stream.size(); ++i) {
            retValue.writeObject(this.stream.get(i));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "convertIntoWMQMessage(ProviderSession)", retValue);
        }
        return retValue;
    }

    public ProviderMessage convertIntoMQMessage(ProviderSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "convertIntoMQMessage(ProviderSession)", new Object[]{session});
        }
        ProviderStreamMessage retValue = ((MQSession)session).createStreamMessage();
        this.setJMSPropsOnProviderMessage(retValue);
        this.setPCPropertiesOnProviderMessage(retValue);
        for (int i = 0; i < this.stream.size(); ++i) {
            ((JMSStreamMessage)retValue).writeObject(this.stream.get(i));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "convertIntoMQMessage(ProviderSession)", retValue);
        }
        return retValue;
    }

    public ProviderMessage convertIntoRTTMessage(ProviderSession session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "convertIntoRTTMessage(ProviderSession)", new Object[]{session});
        }
        ProviderStreamMessage retValue = ((SessionImpl)session).createStreamMessage();
        this.setJMSPropsOnProviderMessage(retValue);
        this.setPCPropertiesOnProviderMessage(retValue);
        for (int i = 0; i < this.stream.size(); ++i) {
            ((StreamMessageImpl)retValue).writeObject(this.stream.get(i));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.wmq.messages.TransientStreamMessage", "convertIntoRTTMessage(ProviderSession)", retValue);
        }
        return retValue;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.wmq.messages.TransientStreamMessage", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.wmq.factories/src/com/ibm/msg/client/wmq/messages/TransientStreamMessage.java, jmscc.wmq, k701, k701-112-140304  1.9.1.1 09/08/17 08:56:53");
        }
    }
}

